/* UTF-8 func by www.DT-Club.net */

#include <amxmodx>
#include <fakemeta>

#define dPluginName			"NavigationSystem"
#define dPluginVersion			"20211117"
#define dPluginAuthor			"251020worm"
#define dPluginLastChangeTime		"20220410143300"

new gMdlId_BeamNode, gMdlId_BeamPath1, gMdlId_BeamPath2

new Array:gArray_SpawnPos, Array:gArray_Ladder, Array:gArray_TraceIgnoreEnt

new gForward_ReturnValue
new gForward_NodeLoading, gForward_NodeLoaded
new gForward_NodeSaving, gForward_NodeSaved

new gBeamCount[33]
new Float:gTimer_Update

#define dJumpHeight		45.0					// 跳跃高度(空中按蹲可缩短下半身18高度.导致玩家能跳上63高度的障碍物)
#define dSafeHeight		161.0					// 安全高度理论上=500*500/2/800,然而实测为161

#define dTraceIgnore		IGNORE_MONSTERS

enum PathFlags
{
	PF_Walk,
	PF_CrouchRun	= 1,
	PF_Climb	= 2,
}

new Array:gArray_NodeDucking
new Array:gArray_NodePoint, Array:gArray_NodeAbsMin, Array:gArray_NodeAbsMax, Array:gArray_NodeNormal
new Array:gArray_NodeStart, Array:gArray_NodeEnd, Array:gArray_NodeFlags, Array:gArray_NodeHeight, Array:gArray_NodeDistance

new bool:gAutoAlign
new Array:gArray_Selected


new Float:gMapAbsMin[3], Float:gMapAbsMax[3]
new Array:gArray_XBox

#define dMenuCmd			"nsmenu"

new gNodeId_Aiming
new gMenuId_Main, gMenuId_Create, gMenuId_Edit, gMenuId_Test

public plugin_precache()
{
	gMdlId_BeamNode		= precache_model("sprites/white.spr")
	gMdlId_BeamPath1	= precache_model("sprites/arrow1.spr")
	gMdlId_BeamPath2	= precache_model("sprites/shellchrome.spr")
	
	gArray_SpawnPos		= ArrayCreate(6)
	gArray_Ladder		= ArrayCreate()
	gArray_TraceIgnoreEnt	= ArrayCreate(2)
	
	gArray_NodeDucking	= ArrayCreate()
	gArray_NodePoint	= ArrayCreate(3)
	gArray_NodeAbsMin	= ArrayCreate(3)
	gArray_NodeAbsMax	= ArrayCreate(3)
	gArray_NodeNormal	= ArrayCreate(3)
	gArray_NodeStart	= ArrayCreate()
	gArray_NodeEnd		= ArrayCreate()
	gArray_NodeFlags	= ArrayCreate()
	gArray_NodeHeight	= ArrayCreate()
	gArray_NodeDistance	= ArrayCreate()
	
	gMenuId_Main = gMenuId_Create = gMenuId_Edit = gMenuId_Test = -1
	
	register_forward(FM_Spawn, "fw_Spawn_Post", 1)
}

public fw_Spawn_Post(ent)
{
	if (!pev_valid(ent)) return
	
	new className[32]
	pev(ent, pev_classname, className, 31)
	
	if (equal(className, "info_vip_start"))		{ NavSys_AddSpawnPos(ent); return; }
	if (equal(className, "info_player_start"))	{ NavSys_AddSpawnPos(ent); return; }
	if (equal(className, "info_player_deathmatch"))	{ NavSys_AddSpawnPos(ent); return; }
	
	if (equal(className, "func_ladder")) ArrayPushCell(gArray_Ladder, ent)
	else if (equal(className, "func_breakable"))
	{
		new Float:takeDamage
		pev(ent, pev_takedamage, takeDamage)
		if (takeDamage == DAMAGE_NO) return
		
		new param[2]
		param[0] = ent
		param[1] = pev(ent, pev_solid)
		ArrayPushArray(gArray_TraceIgnoreEnt, param)
	}
	else if (!contain(className, "func_door"))
	{
		if (pev(ent, pev_spawnflags) == SF_DOOR_USE_ONLY) return
		
		new param[2]
		param[0] = ent
		param[1] = pev(ent, pev_solid)
		ArrayPushArray(gArray_TraceIgnoreEnt, param)
	}
}

NavSys_AddSpawnPos(ent)
{
	new Float:vecSrc[3], Float:vecDest[3]
	pev(ent, pev_origin, vecSrc)
	vecDest[0] = vecSrc[0]
	vecDest[1] = vecSrc[1]
	vecDest[2] = vecSrc[2] - 9999.0
	NavSys_Trace(vecSrc, vecDest, HULL_HUMAN)
	
	new Float:vecEndPos[3], Float:vecPlaneNormal[3]
	get_tr2(0, TR_vecEndPos, vecEndPos)
	get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal)
	
	new Float:spawnPos[6]
	spawnPos[0] = vecEndPos[0]
	spawnPos[1] = vecEndPos[1]
	spawnPos[2] = vecEndPos[2]
	spawnPos[3] = vecPlaneNormal[0]
	spawnPos[4] = vecPlaneNormal[1]
	spawnPos[5] = vecPlaneNormal[2]
	ArrayPushArray(gArray_SpawnPos, spawnPos)
}

public plugin_init()
{
	register_plugin(dPluginName, dPluginVersion, dPluginAuthor)
	
	register_dictionary("NavigationSystem.txt")
	
	register_clcmd("nsmenu", "clcmd_NSMenu")
	
	register_forward(FM_PlayerPreThink, "fw_PlayerPreThink")
	
	gForward_NodeLoading = CreateMultiForward("NavSys_NodeLoading", ET_STOP, FP_CELL)
	gForward_NodeLoaded = CreateMultiForward("NavSys_NodeLoaded", ET_STOP, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL)
	gForward_NodeSaving = CreateMultiForward("NavSys_NodeSaving", ET_STOP, FP_CELL)
	gForward_NodeSaved = CreateMultiForward("NavSys_NodeSaved", ET_STOP, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL)
	
	if (!NavSys_LoadFile(0))
	{
		NavNode_AutoCreating()
		NavNode_AutoMerging(false)
		NavBox_Update()
		NavSys_SaveFile(0)
	}
}

public clcmd_NSMenu(id)
{
	if(get_user_flags(id) & ADMIN_RCON)
	{
		NavSys_EditMode(id)
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE;
}

NavSys_EditMode(id)
{
	if (gMenuId_Main < 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "EDIT_MODE_ON")
		
		NavSysMenu_Init()
	}
	
	menu_display(id, gMenuId_Main)
}

public fw_PlayerPreThink(id)
{
	if (id != 1) return
	if(!(get_user_flags(id) & ADMIN_RCON))
	 	return
	if (gMenuId_Main < 0) return
	if (!is_user_alive(id)) return
	
	gBeamCount[id] = 0
	
	new Float:gameTime = get_gametime()
	if (gTimer_Update < gameTime)
	{
		gTimer_Update = gameTime + 0.08
		
		gNodeId_Aiming = NavBox_GetNodeInFront(id)
		
		new nodeId, bool:drawnAiming
		new Array:arrayEnd, Array:arrayPath = ArrayCreate()
		
		if (0 <= gNodeId_Aiming)
		{
			arrayEnd = ArrayGetCell(gArray_NodeEnd, gNodeId_Aiming)
			for (new i = ArraySize(arrayEnd) - 1; 0 <= i; i--) ArrayPushCell(arrayPath, ArrayGetCell(arrayEnd, i))
		}
		
		for (new i = ArraySize(gArray_Selected) - 1; 0 <=i; i--)
		{
			nodeId = ArrayGetCell(gArray_Selected, i)
			
			if (nodeId == gNodeId_Aiming)
			{
				drawnAiming = true
				NavNode_DrawMesh(id, gNodeId_Aiming, true, 1, 10, 0, 255, 255, 255)
				continue
			}
			
			NavNode_DrawMesh(id, nodeId, false, 1, 10, 0, 255, 255, 255)
			
			for (new j = ArraySize(arrayPath) - 1; 0 <= j; j--)
			{
				if (ArrayGetCell(arrayPath, j) == nodeId)
				{
					ArrayDeleteItem(arrayPath, j)
					break
				}
			}
		}
		
		if (0 <= gNodeId_Aiming && !drawnAiming) NavNode_DrawMesh(id, gNodeId_Aiming, true, 1, 10, 0, 255, 255, 0)
		for (new i = ArraySize(arrayPath) - 1; 0 <= i; i--) NavNode_DrawMesh(id, ArrayGetCell(arrayPath, i), false, 1, 10, 0, 255, 0, 0)
		
		ArrayDestroy(arrayPath)
	}
	
	new button = pev(id, pev_button)
	new oldButtons = pev(id, pev_oldbuttons)
	
	if (button & IN_ATTACK && oldButtons & IN_ATTACK == 0)
	{
		if (gNodeId_Aiming < 0)	NavSysMenu_CreateNodeInFront(id)
		else			NavSysMenu_Selects(id)
	}
	else if (button & IN_ATTACK2 && oldButtons & IN_ATTACK2 == 0)
	{
		if (gNodeId_Aiming < 0)	menu_display(id, gMenuId_Main)
		else			menu_display(id, gMenuId_Edit)
	}
}

NavSys_SaveFile(id)
{
	ExecuteForward(gForward_NodeSaving, gForward_ReturnValue, id)
	
	new nodeNums = ArraySize(gArray_NodeDucking)
	if (!nodeNums)
	{
		if (id)	client_print(id, print_chat, "%L", LANG_SERVER, "NODE_NOT_FOUND")
		else	server_print("%L", LANG_SERVER, "NODE_NOT_FOUND")
		
		ExecuteForward(gForward_NodeSaved, gForward_ReturnValue, id,
		gArray_NodeDucking, gArray_NodePoint, gArray_NodeAbsMin, gArray_NodeAbsMax, gArray_NodeNormal,
		gArray_NodeStart, gArray_NodeEnd, gArray_NodeFlags, gArray_NodeHeight, gArray_NodeDistance)
		
		return false
	}
	
	new filePath[128]
	get_localinfo("amxx_datadir", filePath, 127)
	format(filePath, 127, "%s/NavigationSystem", filePath)
	if (!dir_exists(filePath)) mkdir(filePath)
	
	new mapName[32]
	get_mapname(mapName, 31)
	format(filePath, 127, "%s/%s.navsys", filePath, mapName)
	
	new fileHandle = fopen(filePath, "wb")
	if (!fileHandle)
	{
		if (id)	client_print(id, print_chat, "%L", LANG_SERVER, "NAV_SAVE_ERROR")
		else	server_print("%L", LANG_SERVER, "NAV_SAVE_ERROR")
		
		ExecuteForward(gForward_NodeSaved, gForward_ReturnValue, id,
		gArray_NodeDucking, gArray_NodePoint, gArray_NodeAbsMin, gArray_NodeAbsMax, gArray_NodeNormal,
		gArray_NodeStart, gArray_NodeEnd, gArray_NodeFlags, gArray_NodeHeight, gArray_NodeDistance)
		
		return false
	}
	
	fwrite(fileHandle, get_systime(), BLOCK_INT)
	
	new iNode
	new coord[3]
	new Array:arrayStart, Array:arrayEnd, Array:arrayFlags, Array:arrayHeight, Array:arrayDistance
	new iPath, pathNums
	
	for (iNode = 0; iNode < nodeNums; iNode++)
	{
		fwrite(fileHandle, ArrayGetCell(gArray_NodeDucking, iNode), BLOCK_BYTE)
		
		ArrayGetArray(gArray_NodePoint, iNode, coord)
		fwrite_blocks(fileHandle, coord, 3, BLOCK_INT)
		
		ArrayGetArray(gArray_NodeAbsMin, iNode, coord)
		fwrite_blocks(fileHandle, coord, 3, BLOCK_INT)
		
		ArrayGetArray(gArray_NodeAbsMax, iNode, coord)
		fwrite_blocks(fileHandle, coord, 3, BLOCK_INT)
		
		ArrayGetArray(gArray_NodeNormal, iNode, coord)
		fwrite_blocks(fileHandle, coord, 3, BLOCK_INT)
		
		arrayStart	= ArrayGetCell(gArray_NodeStart,	iNode)
		arrayEnd	= ArrayGetCell(gArray_NodeEnd,		iNode)
		arrayFlags	= ArrayGetCell(gArray_NodeFlags,	iNode)
		arrayHeight	= ArrayGetCell(gArray_NodeHeight,	iNode)
		arrayDistance	= ArrayGetCell(gArray_NodeDistance,	iNode)
		
		pathNums = ArraySize(arrayStart)
		fwrite(fileHandle, pathNums, BLOCK_INT)
		
		for (iPath = 0; iPath < pathNums; iPath++)
		{
			fwrite(fileHandle, ArrayGetCell(arrayStart,	iPath), BLOCK_INT)
		}
		
		pathNums = ArraySize(arrayEnd)
		fwrite(fileHandle, pathNums, BLOCK_INT)
		
		for (iPath = 0; iPath < pathNums; iPath++)
		{
			fwrite(fileHandle, ArrayGetCell(arrayEnd,	iPath), BLOCK_INT)
			fwrite(fileHandle, ArrayGetCell(arrayFlags,	iPath), BLOCK_BYTE)
			fwrite(fileHandle, ArrayGetCell(arrayHeight,	iPath), BLOCK_INT)
			fwrite(fileHandle, ArrayGetCell(arrayDistance,	iPath), BLOCK_INT)
		}
	}
	
	fclose(fileHandle)
	
	if (id)	client_print(id, print_chat, "%L", LANG_SERVER, "NAV_SAVED", nodeNums)
	else	server_print("%L", LANG_SERVER, "NAV_SAVED", nodeNums)
	
	ExecuteForward(gForward_NodeSaved, gForward_ReturnValue, id,
	gArray_NodeDucking, gArray_NodePoint, gArray_NodeAbsMin, gArray_NodeAbsMax, gArray_NodeNormal,
	gArray_NodeStart, gArray_NodeEnd, gArray_NodeFlags, gArray_NodeHeight, gArray_NodeDistance)
	
	return true
}

NavSys_LoadFile(id)
{
	ExecuteForward(gForward_NodeLoading, gForward_ReturnValue, id)
	
	new filePath[128]
	get_localinfo("amxx_datadir", filePath, 127)
	format(filePath, 127, "%s/NavigationSystem", filePath)
	if (!dir_exists(filePath))
	{
		if (id)	client_print(id, print_chat, "%L", LANG_SERVER, "NAV_FILE_NOT_FOUND")
		else	server_print("%L", LANG_SERVER, "NAV_FILE_NOT_FOUND")
		
		ExecuteForward(gForward_NodeLoaded, gForward_ReturnValue, id,
		gArray_NodeDucking, gArray_NodePoint, gArray_NodeAbsMin, gArray_NodeAbsMax, gArray_NodeNormal,
		gArray_NodeStart, gArray_NodeEnd, gArray_NodeFlags, gArray_NodeHeight, gArray_NodeDistance)
		
		return false
	}
	
	new mapName[32]
	get_mapname(mapName, 31)
	format(filePath, 127, "%s/%s.navsys", filePath, mapName)
	
	new fileHandle = fopen(filePath, "rb")
	if (!fileHandle)
	{
		if (id)	client_print(id, print_chat, "%L", LANG_SERVER, "NAV_LOAD_ERROR")
		else	server_print("%L", LANG_SERVER, "NAV_LOAD_ERROR")
		
		ExecuteForward(gForward_NodeLoaded, gForward_ReturnValue, id,
		gArray_NodeDucking, gArray_NodePoint, gArray_NodeAbsMin, gArray_NodeAbsMax, gArray_NodeNormal,
		gArray_NodeStart, gArray_NodeEnd, gArray_NodeFlags, gArray_NodeHeight, gArray_NodeDistance)
		
		return false
	}
	
	new nodeNums = ArraySize(gArray_NodeDucking)
	if (nodeNums) NavNode_Clear()
	
	new iNode
	new Array:arrayStart, Array:arrayEnd, Array:arrayFlags, Array:arrayHeight, Array:arrayDistance
	
	new fileSize = file_size(filePath)
	
	new warning, bool:error
	new value, coord[3]
	new iPath, pathNums
	
	if (fileSize < 4) { error = true; goto LoopEnd; }
	fread(fileHandle, value, BLOCK_INT)
	if (value <= parse_time(dPluginLastChangeTime, "%Y%m%d%H%M%S")) { error = true; goto LoopEnd; }
	
	LoopStart:
	
	if (fileSize - ftell(fileHandle) < 1) { error = true; goto LoopEnd; }
	fread(fileHandle, value, BLOCK_BYTE)
	ArrayPushCell(gArray_NodeDucking, value)
	
	if (fileSize - ftell(fileHandle) < 12) { error = true; goto LoopEnd; }
	fread_blocks(fileHandle, coord, 3, BLOCK_INT)
	ArrayPushArray(gArray_NodePoint, coord)
	
	if (fileSize - ftell(fileHandle) < 12) { error = true; goto LoopEnd; }
	fread_blocks(fileHandle, coord, 3, BLOCK_INT)
	ArrayPushArray(gArray_NodeAbsMin, coord)
	
	if (fileSize - ftell(fileHandle) < 12) { error = true; goto LoopEnd; }
	fread_blocks(fileHandle, coord, 3, BLOCK_INT)
	ArrayPushArray(gArray_NodeAbsMax, coord)
	
	if (fileSize - ftell(fileHandle) < 12) { error = true; goto LoopEnd; }
	fread_blocks(fileHandle, coord, 3, BLOCK_INT)
	ArrayPushArray(gArray_NodeNormal, coord)
	
	arrayStart	= ArrayCreate()
	arrayEnd	= ArrayCreate()
	arrayFlags	= ArrayCreate()
	arrayHeight	= ArrayCreate()
	arrayDistance	= ArrayCreate()
	ArrayPushCell(gArray_NodeStart,		arrayStart)
	ArrayPushCell(gArray_NodeEnd,		arrayEnd)
	ArrayPushCell(gArray_NodeFlags,		arrayFlags)
	ArrayPushCell(gArray_NodeHeight,	arrayHeight)
	ArrayPushCell(gArray_NodeDistance,	arrayDistance)
	
	if (fileSize - ftell(fileHandle) < 4) { error = true; goto LoopEnd; }
	fread(fileHandle, pathNums, BLOCK_INT)
	
	for (iPath = 0; iPath < pathNums; iPath++)
	{
		if (fileSize - ftell(fileHandle) < 4) { error = true; goto LoopEnd; }
		fread(fileHandle, value, BLOCK_INT)
		ArrayPushCell(arrayStart, value)
	}
	
	if (fileSize - ftell(fileHandle) < 4) { error = true; goto LoopEnd; }
	fread(fileHandle, pathNums, BLOCK_INT)
	
	for (iPath = 0; iPath < pathNums; iPath++)
	{
		if (fileSize - ftell(fileHandle) < 4) { error = true; goto LoopEnd; }
		fread(fileHandle, value, BLOCK_INT)
		ArrayPushCell(arrayEnd, value)
		
		if (fileSize - ftell(fileHandle) < 1) { error = true; goto LoopEnd; }
		fread(fileHandle, value, BLOCK_BYTE)
		ArrayPushCell(arrayFlags, value)
		
		if (fileSize - ftell(fileHandle) < 4) { error = true; goto LoopEnd; }
		fread(fileHandle, value, BLOCK_INT)
		ArrayPushCell(arrayHeight, value)
		
		if (fileSize - ftell(fileHandle) < 4) { error = true; goto LoopEnd; }
		fread(fileHandle, value, BLOCK_INT)
		ArrayPushCell(arrayDistance, value)
	}
	
	if (fileSize - ftell(fileHandle) < 61)	goto LoopEnd
	else					goto LoopStart
	
	LoopEnd:
	
	warning = fileSize - ftell(fileHandle)
	fclose(fileHandle)
	
	if (error)
	{
		nodeNums = ArraySize(gArray_NodeStart)
		for (iNode = 0; iNode < nodeNums; iNode++)
		{
			arrayStart = ArrayGetCell(gArray_NodeStart, iNode)
			ArrayDestroy(arrayStart)
		}
		nodeNums = ArraySize(gArray_NodeEnd)
		for (iNode = 0; iNode < nodeNums; iNode++)
		{
			arrayEnd	= ArrayGetCell(gArray_NodeEnd,		iNode)
			arrayFlags	= ArrayGetCell(gArray_NodeFlags,	iNode)
			arrayHeight	= ArrayGetCell(gArray_NodeHeight,	iNode)
			arrayDistance	= ArrayGetCell(gArray_NodeDistance,	iNode)
			ArrayDestroy(arrayEnd)
			ArrayDestroy(arrayFlags)
			ArrayDestroy(arrayHeight)
			ArrayDestroy(arrayDistance)
		}
		
		ArrayClear(gArray_NodeDucking)
		ArrayClear(gArray_NodePoint)
		ArrayClear(gArray_NodeAbsMin)
		ArrayClear(gArray_NodeAbsMax)
		ArrayClear(gArray_NodeNormal)
		ArrayClear(gArray_NodeStart)
		ArrayClear(gArray_NodeEnd)
		ArrayClear(gArray_NodeFlags)
		ArrayClear(gArray_NodeHeight)
		ArrayClear(gArray_NodeDistance)
		
		NavBox_Update()
		
		if (id)	client_print(id, print_chat, "%L", LANG_SERVER, "NAV_LOAD_ERROR2")
		else	server_print("%L", LANG_SERVER, "NAV_LOAD_ERROR2")
		
		ExecuteForward(gForward_NodeLoaded, gForward_ReturnValue, id,
		gArray_NodeDucking, gArray_NodePoint, gArray_NodeAbsMin, gArray_NodeAbsMax, gArray_NodeNormal,
		gArray_NodeStart, gArray_NodeEnd, gArray_NodeFlags, gArray_NodeHeight, gArray_NodeDistance)
		
		return false
	}
	
	NavBox_Update()
	
	if (id)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "NAV_LOADED", ArraySize(gArray_NodeDucking))
		if (warning) client_print(id, print_chat, "%L", LANG_SERVER, "NAV_WARNING", warning)
	}
	else
	{
		server_print("%L", LANG_SERVER, "NAV_LOADED", ArraySize(gArray_NodeDucking))
		if (warning) server_print("%L", LANG_SERVER, "NAV_WARNING", warning)
	}
	
	ExecuteForward(gForward_NodeLoaded, gForward_ReturnValue, id,
	gArray_NodeDucking, gArray_NodePoint, gArray_NodeAbsMin, gArray_NodeAbsMax, gArray_NodeNormal,
	gArray_NodeStart, gArray_NodeEnd, gArray_NodeFlags, gArray_NodeHeight, gArray_NodeDistance)
	
	return true
}

NavSys_DeleteFile(id)
{
	new filePath[128]
	get_localinfo("amxx_datadir", filePath, 127)
	format(filePath, 127, "%s/NavigationSystem", filePath)
	if (dir_exists(filePath))
	{
		new mapName[32]
		get_mapname(mapName, 31)
		format(filePath, 127, "%s/%s.navsys", filePath, mapName)
		if (file_exists(filePath)) delete_file(filePath)
	}
	
	NavNode_Clear()
	NavBox_Update()
	
	if (id)	client_print(id, print_chat, "%L", LANG_SERVER, "NAV_DELETED")
	else	server_print("%L", LANG_SERVER, "NAV_DELETED")
}

NavSys_Trace(const Float:vecSrc[3], const Float:vecDest[3], hull)
{
	new i, param[2]
	for (i = ArraySize(gArray_Ladder) - 1; 0 <= i; i--) set_pev(ArrayGetCell(gArray_Ladder, i), pev_solid, SOLID_BSP)
	for (i = ArraySize(gArray_TraceIgnoreEnt) - 1; 0 <= i; i--)
	{
		ArrayGetArray(gArray_TraceIgnoreEnt, i, param)
		param[1] = pev(param[0], pev_solid)
		set_pev(param[0], pev_solid, SOLID_NOT)
		ArraySetArray(gArray_TraceIgnoreEnt, i, param)
	}
	
	if (hull < 0)	engfunc(EngFunc_TraceLine, vecSrc, vecDest, dTraceIgnore, -1, 0)
	else		engfunc(EngFunc_TraceHull, vecSrc, vecDest, dTraceIgnore, hull, -1, 0)
	
	for (i = ArraySize(gArray_Ladder) - 1; 0 <= i; i--) set_pev(ArrayGetCell(gArray_Ladder, i), pev_solid, SOLID_NOT)
	for (i = ArraySize(gArray_TraceIgnoreEnt) - 1; 0 <= i; i--)
	{
		ArrayGetArray(gArray_TraceIgnoreEnt, i, param)
		set_pev(param[0], pev_solid, param[1])
	}
}

bool:NavSys_IsVacantSpace(const Float:origin[3], hull)
{
	NavSys_Trace(origin, origin, hull)
	
	if (!get_tr2(0, TR_InOpen) || get_tr2(0, TR_AllSolid) || get_tr2(0, TR_StartSolid)) return false
	
	return true
}

stock AngleVector(const Float:angles[3], dirt, Float:vector[3])
{
	new Float:cp, Float:cy, Float:sy, Float:sp
	cp = floatcos(M_PI * angles[0] / 180.0)
	cy = floatcos(M_PI * angles[1] / 180.0)
	sy = floatsin(M_PI * angles[1] / 180.0)
	sp = floatsin(M_PI * angles[0] / 180.0)
	if (dirt == ANGLEVECTOR_FORWARD)
	{
		vector[0] = cp * cy
		vector[1] = cp * sy
		vector[2] = -sp
	}
	if (dirt == ANGLEVECTOR_RIGHT)
	{
		new Float:sr, Float:cr
		sr = floatsin(M_PI * angles[2] / 180.0)
		cr = floatcos(M_PI * angles[2] / 180.0)
		vector[0] = (-1.0 * sr * sp * cy + -1.0 * cr * -sy)
		vector[1] = (-1.0 * sr * sp * sy + -1.0 * cr * cy)
		vector[2] = -1.0 * sr * cp
	}
	if (dirt == ANGLEVECTOR_UP)
	{
		new Float:sr, Float:cr
		sr = floatsin(M_PI * angles[2] / 180.0)
		cr = floatcos(M_PI * angles[2] / 180.0)
		vector[0] = (cr * sp * cy + -sr * -sy)
		vector[1] = (cr * sp * sy + -sr * cy)
		vector[2] = cr * cp
	}
}
stock VectorAngle(const Float:vector[3], Float:angles[3])
{
	if (vector[1] == 0.0 && vector[0] == 0.0)
        {
		angles[0] = vector[2] > 0.0 ? 90.0 : 270.0
		angles[1] = 0.0
		angles[2] = 0.0
		return
	}
	new Float:yaw, Float:pitch, Float:tmp
	yaw = floatatan2(vector[1], vector[0], degrees)
	if (yaw < 0.0) yaw += 360
	
	tmp = floatsqroot(vector[0] * vector[0] + vector[1] * vector[1])
	pitch = floatatan2(vector[2], tmp, degrees)
	if (pitch < 0.0) pitch += 360
	
	angles[0] = pitch
	angles[1] = yaw
	angles[2] = 0.0
}
stock bool:VecEqual(const Float:vec1[], const Float:vec2[])
{
	return vec1[0] == vec2[0] && vec1[1] == vec2[1] && vec1[2] == vec2[2]
}
stock VecAdd(const Float:vec1[], const Float:vec2[], Float:vecOut[])
{
	vecOut[0] = vec1[0] + vec2[0]
	vecOut[1] = vec1[1] + vec2[1]
	vecOut[2] = vec1[2] + vec2[2]
}
stock VecSub(const Float:vec1[], const Float:vec2[], Float:vecOut[])
{
	vecOut[0] = vec1[0] - vec2[0]
	vecOut[1] = vec1[1] - vec2[1]
	vecOut[2] = vec1[2] - vec2[2]
}
stock VecMulScalar(const Float:vec[], Float:scalar, Float:vecOut[])
{
	vecOut[0] = vec[0] * scalar
	vecOut[1] = vec[1] * scalar
	vecOut[2] = vec[2] * scalar
}
stock VecAddScaled(const Float:vec1[], const Float:vec2[], Float:scalar, Float:vecOut[])
{
	vecOut[0] = vec1[0] + vec2[0] * scalar
	vecOut[1] = vec1[1] + vec2[1] * scalar
	vecOut[2] = vec1[2] + vec2[2] * scalar
}
stock VecSubScaled(const Float:vec1[], const Float:vec2[], Float:scalar, Float:vecOut[])
{
	vecOut[0] = vec1[0] - vec2[0] * scalar
	vecOut[1] = vec1[1] - vec2[1] * scalar
	vecOut[2] = vec1[2] - vec2[2] * scalar
}
stock Float:VecLength(const Float:vec[])
{
	return floatsqroot((vec[0]) * (vec[0]) + (vec[1]) * (vec[1]) + (vec[2]) * (vec[2]))
}
stock Float:VecLength2D(const Float:vec[])
{
	return floatsqroot((vec[0]) * (vec[0]) + (vec[1]) * (vec[1]))
}
stock Float:VecDistance(const Float:vec1[], const Float:vec2[])
{
	return floatsqroot
	(
		(vec1[0] - vec2[0]) * (vec1[0] - vec2[0]) +
		(vec1[1] - vec2[1]) * (vec1[1] - vec2[1]) +
		(vec1[2] - vec2[2]) * (vec1[2] - vec2[2])
	)                                       
}
stock Float:VecDistance2D(const Float:vec1[], const Float:vec2[])
{
	return floatsqroot
	(
		(vec1[0] - vec2[0]) * (vec1[0] - vec2[0]) +
		(vec1[1] - vec2[1]) * (vec1[1] - vec2[1])
	)
}
stock Float:VecDot(const Float:vec1[], const Float:vec2[])
{
	return vec1[0] * vec2[0] + vec1[1] * vec2[1] + vec1[2] * vec2[2]
}
stock InclinedPlanePoint(const Float:pointOnPlane[3], const Float:normal[3], const Float:pointIn[3], Float:pointOut[3])
{
	if (VecEqual(pointOnPlane, pointIn))
	{
		pointOut = pointOnPlane
		return
	}
	
	new Float:vecTemp[3]
	VecSub(pointIn, pointOnPlane, vecTemp)
	
	new Float:length = vector_length(vecTemp)
	length *= -VecDot(normal, vecTemp) / length
	
	pointOut[0] = pointIn[0]
	pointOut[1] = pointIn[1]
	pointOut[2] = pointIn[2] + length / normal[2]
}
stock Float:InclinedPlaneZ(const Float:pointOnPlane[3], const Float:normal[3], const Float:point[3])
{
	if (VecEqual(pointOnPlane, point)) return pointOnPlane[2]
	
	new Float:vecTemp[3]
	VecSub(point, pointOnPlane, vecTemp)
	
	new Float:length = vector_length(vecTemp)
	length *= -VecDot(normal, vecTemp) / length
	
	return point[2] + length / normal[2]
}

stock GetPlaneType(Float:planeNormalZ)
{
	// 天花板
	if (planeNormalZ == -1.0)	return 0
	// 倾斜天花板
	else if (planeNormalZ < 0.0)	return 1
	// 地面
	else if (planeNormalZ == 1.0)	return 2
	// 倾斜地面
	else if (0.0 < planeNormalZ)	return 3
	// 墙面
	return 4
}

stock bool:IsPlaneFloor(const Float:planeNormalZ)
{
	return 0.7 <= planeNormalZ
}

stock bool:IsPlaneSteep(const Float:planeNormalZ)
{
	return 0.0 < planeNormalZ < 0.7
}

stock SendMsg_BeamPoints(id, const Float:start[3], const Float:end[3], mdlId, life, width, noise, r, g, b, scrollSpeed = 0)
{
	if (127 < gBeamCount[id]) return
	
	gBeamCount[id]++
	
	engfunc(EngFunc_MessageBegin, MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, end, id)
	write_byte(TE_BEAMPOINTS)
	engfunc(EngFunc_WriteCoord, end[0])
	engfunc(EngFunc_WriteCoord, end[1])
	engfunc(EngFunc_WriteCoord, end[2])
	engfunc(EngFunc_WriteCoord, start[0])
	engfunc(EngFunc_WriteCoord, start[1])
	engfunc(EngFunc_WriteCoord, start[2])
	write_short(mdlId)
	write_byte(0)
	write_byte(1)
	write_byte(life)
	write_byte(width)
	write_byte(noise)
	write_byte(r)
	write_byte(g)
	write_byte(b)
	write_byte(255)		// brightness
	write_byte(scrollSpeed)	// scroll speed in 0.1's
	message_end()
}

public plugin_natives()
{
	register_native("NavSys_Pathfinding",		"_Sys_Pathfinding")
	register_native("NavSys_Pathfinding2",		"_Sys_Pathfinding2")
	register_native("NavSys_GetWaypointFinal",	"_Sys_GetWaypointFinal")
	register_native("NavSys_GetWaypointSecond",	"_Sys_GetWaypointSecond")
	register_native("NavSys_GetWaypointPathInfo",	"_Sys_GetWaypointPathInfo")
	register_native("NavSys_GetSpawnPos",		"_Sys_GetSpawnPos")
	register_native("NavSys_GetLadder",		"_Sys_GetLadder")
	register_native("NavBox_Exist",			"_Box_Exist")
	register_native("NavBox_Draw",			"_Box_Draw")
	register_native("NavBox_GetArea",		"_Box_GetArea")
	register_native("NavBox_GetContain",		"_Box_GetContain")
	register_native("NavBox_GetNearest",		"_Box_GetNearest")
	register_native("NavBox_GetNodeArray",		"_Box_GetNodeArray")
	register_native("NavBox_GetNode",		"_Box_GetNode")
	register_native("NavBox_GetNodeNearest",	"_Box_GetNodeNearest")
	register_native("NavBox_GetNodeContain",	"_Box_GetNodeContain")
	register_native("NavBox_GetNodeIntersect",	"_Box_GetNodeIntersect")
	register_native("NavBox_GetNodeInFront",	"_Box_GetNodeInFront")
	register_native("NavNode_DrawMesh",		"_Node_DrawMesh")
	register_native("NavNode_DrawBox",		"_Node_DrawBox")
	register_native("NavNode_GetNearest",		"_Node_GetNearest")
	register_native("NavNode_GetPathCoord",		"_Node_GetPathCoord")
	register_native("NavNode_GetPathCoord2",	"_Node_GetPathCoord2")
	register_native("NavNode_PathExist",		"_Node_PathExist")
	register_native("NavNode_PathExist2",		"_Node_PathExist2")
}

public Array:_Sys_Pathfinding()
{
	new tickStart = tickcount()
	
	new iNodeOrigin = get_param(1)
	new iNodeGoal = get_param(2)
	new maxTickCount = get_param(4)
	
	new Float:origin[3], Float:goal[3]
	ArrayGetArray(gArray_NodePoint, iNodeOrigin, origin)
	ArrayGetArray(gArray_NodePoint, iNodeGoal, goal)
	
	new waypointNums = 1
	new waypoint[7], Array:arrayWaypoint = ArrayCreate(7)
	waypoint[0] = iNodeOrigin			// 表示当前路点的导航点下标
	waypoint[1] = any:false				// 表示路径点的gArray_NodeEnd属性已被访问
	waypoint[2] = any:0.0				// 表示起点到路径点的实际路程
	waypoint[3] = any:VecDistance(origin, goal)	// 表示起点到路径点的实际路程+路径点到终点的直线路程
	waypoint[4] = -1				// 表示上一个路径点的导航点下标
	waypoint[5] = -1				// 表示上一个路径点下标
	waypoint[6] = -1				// 关系式:waypoint[0] == ArrayGetCell(ArrayGetCell(gArray_NodeEnd, waypoint[4]), waypoint[6])
	ArrayPushArray(arrayWaypoint, waypoint)
	
	new iWaypoint, iWaypointSelect, waypointSelect[7], Float:lastDist
	new iPath, Array:arrayEnd, Array:arrayFlags, Array:arrayHeight, Array:arrayDistance
	new iNodeEnd, PathFlags:pathFlags, Float:pathHeight, Float:pathDist, Float:nodePoint[3]
	new newWaypoint[7]
	
	LoopStart:
	
	iWaypointSelect = -1
	for (iWaypoint = 0; iWaypoint < waypointNums; iWaypoint++)
	{
		ArrayGetArray(arrayWaypoint, iWaypoint, waypoint)
		if (waypoint[1]) continue
		if (Float:waypoint[3] < lastDist || iWaypointSelect < 0) { lastDist = Float:waypoint[3]; iWaypointSelect = iWaypoint; }
	}
	
	if (iWaypointSelect < 0)
	{
		set_param_byref(3, -2)
		return arrayWaypoint
	}
	
	ArrayGetArray(arrayWaypoint, iWaypointSelect, waypointSelect)
	waypointSelect[1] = any:true
	ArraySetArray(arrayWaypoint, iWaypointSelect, waypointSelect)
	
	arrayEnd	= ArrayGetCell(gArray_NodeEnd,		waypointSelect[0])
	arrayFlags	= ArrayGetCell(gArray_NodeFlags,	waypointSelect[0])
	arrayHeight	= ArrayGetCell(gArray_NodeHeight,	waypointSelect[0])
	arrayDistance	= ArrayGetCell(gArray_NodeDistance,	waypointSelect[0])
	
	for (iPath = ArraySize(arrayEnd) - 1; 0 <= iPath; iPath--)
	{
		iNodeEnd	= ArrayGetCell(arrayEnd,	iPath)
		pathFlags	= ArrayGetCell(arrayFlags,	iPath)
		pathHeight	= ArrayGetCell(arrayHeight,	iPath)
		pathDist	= ArrayGetCell(arrayDistance,	iPath)
		
		if (pathFlags & PF_CrouchRun || 45.0 < pathHeight)	newWaypoint[2] = any:(Float:waypointSelect[2] + pathDist * 3.0)
		else if (18.0 < pathHeight)				newWaypoint[2] = any:(Float:waypointSelect[2] + pathDist * 1.5)
		else							newWaypoint[2] = any:(Float:waypointSelect[2] + pathDist)
		
		if (iNodeEnd == iNodeGoal)
		{
			newWaypoint[0] = iNodeEnd
			newWaypoint[1] = any:false
			newWaypoint[3] = newWaypoint[2]
			newWaypoint[4] = waypointSelect[0]
			newWaypoint[5] = iWaypointSelect
			newWaypoint[6] = iPath
			ArrayPushArray(arrayWaypoint, newWaypoint)
			set_param_byref(3, waypointNums)
			return arrayWaypoint
		}
		
		for (iWaypoint = 0; iWaypoint < waypointNums; iWaypoint++)
		{
			ArrayGetArray(arrayWaypoint, iWaypoint, waypoint)
			if (waypoint[0] == iNodeEnd) break
		}
		if (iWaypoint == waypointNums)
		{
			ArrayGetArray(gArray_NodePoint, iNodeEnd, nodePoint)
			newWaypoint[0] = iNodeEnd
			newWaypoint[1] = any:false
			newWaypoint[3] = any:(Float:newWaypoint[2] + VecDistance(nodePoint, goal))
			newWaypoint[4] = waypointSelect[0]
			newWaypoint[5] = iWaypointSelect
			newWaypoint[6] = iPath
			waypointNums++
			ArrayPushArray(arrayWaypoint, newWaypoint)
			continue
		}
		
		// 若iNode到iNode2的路程比路径点记载的路程更短,则重定义路径点的父路径点
		if (Float:newWaypoint[2] < Float:waypoint[2])
		{
			ArrayGetArray(gArray_NodePoint, iNodeEnd, nodePoint)
			waypoint[0] = iNodeEnd
			waypoint[3] = any:(Float:newWaypoint[2] + (Float:waypoint[3] - Float:waypoint[2]))
			waypoint[4] = waypointSelect[0]
			waypoint[5] = iWaypointSelect
			waypoint[6] = iPath
			ArraySetArray(arrayWaypoint, iWaypoint, waypoint)
		}
	}
	
	if (0 <= maxTickCount < tickcount() - tickStart)
	{
		set_param_byref(3, -1)
		return arrayWaypoint
	}
	
	goto LoopStart
}
public _Sys_Pathfinding2()
{
	new tickStart = tickcount()
	
	new Array:arrayWaypoint = any:get_param(1)
	new iNodeGoal = get_param(2)
	new maxTickCount = get_param(3)
	
	new Float:goal[3]
	ArrayGetArray(gArray_NodePoint, iNodeGoal, goal)
	
	new waypointNums = ArraySize(arrayWaypoint)
	new waypoint[7]
	
	new iWaypoint, iWaypointSelect, waypointSelect[7], Float:lastDist
	new iPath, Array:arrayEnd, Array:arrayFlags, Array:arrayHeight, Array:arrayDistance
	new iNodeEnd, PathFlags:pathFlags, Float:pathHeight, Float:pathDist, Float:nodePoint[3]
	new newWaypoint[7]
	
	LoopStart:
	
	iWaypointSelect = -1
	for (iWaypoint = 0; iWaypoint < waypointNums; iWaypoint++)
	{
		ArrayGetArray(arrayWaypoint, iWaypoint, waypoint)
		if (waypoint[1]) continue
		if (Float:waypoint[3] < lastDist || iWaypointSelect < 0) { lastDist = Float:waypoint[3]; iWaypointSelect = iWaypoint; }
	}
	
	if (iWaypointSelect < 0) return -2
	
	ArrayGetArray(arrayWaypoint, iWaypointSelect, waypointSelect)
	waypointSelect[1] = any:true
	ArraySetArray(arrayWaypoint, iWaypointSelect, waypointSelect)
	
	arrayEnd	= ArrayGetCell(gArray_NodeEnd,		waypointSelect[0])
	arrayFlags	= ArrayGetCell(gArray_NodeFlags,	waypointSelect[0])
	arrayHeight	= ArrayGetCell(gArray_NodeHeight,	waypointSelect[0])
	arrayDistance	= ArrayGetCell(gArray_NodeDistance,	waypointSelect[0])
	
	for (iPath = ArraySize(arrayEnd) - 1; 0 <= iPath; iPath--)
	{
		iNodeEnd	= ArrayGetCell(arrayEnd,	iPath)
		pathFlags	= ArrayGetCell(arrayFlags,	iPath)
		pathHeight	= ArrayGetCell(arrayHeight,	iPath)
		pathDist	= ArrayGetCell(arrayDistance,	iPath)
		
		if (pathFlags & PF_CrouchRun || 45.0 < pathHeight)	newWaypoint[2] = any:(Float:waypointSelect[2] + pathDist * 3.0)
		else if (18.0 < pathHeight)				newWaypoint[2] = any:(Float:waypointSelect[2] + pathDist * 1.5)
		else							newWaypoint[2] = any:(Float:waypointSelect[2] + pathDist)
		
		if (iNodeEnd == iNodeGoal)
		{
			newWaypoint[0] = iNodeEnd
			newWaypoint[1] = any:false
			newWaypoint[3] = newWaypoint[2]
			newWaypoint[4] = waypointSelect[0]
			newWaypoint[5] = iWaypointSelect
			newWaypoint[6] = iPath
			ArrayPushArray(arrayWaypoint, newWaypoint)
			return waypointNums
		}
		
		for (iWaypoint = 0; iWaypoint < waypointNums; iWaypoint++)
		{
			ArrayGetArray(arrayWaypoint, iWaypoint, waypoint)
			if (waypoint[0] == iNodeEnd) break
		}
		if (iWaypoint == waypointNums)
		{
			ArrayGetArray(gArray_NodePoint, iNodeEnd, nodePoint)
			newWaypoint[0] = iNodeEnd
			newWaypoint[1] = any:false
			newWaypoint[3] = any:(Float:newWaypoint[2] + VecDistance(nodePoint, goal))
			newWaypoint[4] = waypointSelect[0]
			newWaypoint[5] = iWaypointSelect
			newWaypoint[6] = iPath
			waypointNums++
			ArrayPushArray(arrayWaypoint, newWaypoint)
			continue
		}
		
		// 若iNode到iNode2的路程比路径点记载的路程更短,则重定义路径点的父路径点
		if (Float:newWaypoint[2] < Float:waypoint[2])
		{
			ArrayGetArray(gArray_NodePoint, iNodeEnd, nodePoint)
			waypoint[0] = iNodeEnd
			waypoint[3] = any:(Float:newWaypoint[2] + (Float:waypoint[3] - Float:waypoint[2]))
			waypoint[4] = waypointSelect[0]
			waypoint[5] = iWaypointSelect
			waypoint[6] = iPath
			ArraySetArray(arrayWaypoint, iWaypoint, waypoint)
		}
	}
	
	if (0 <= maxTickCount < tickcount() - tickStart) return -1
	
	goto LoopStart
}
public _Sys_GetWaypointFinal()
{
	new Array:arrayWaypoint = any:get_param(1)
	
	new Float:goal[3]
	get_array_f(2, goal, 3)
	
	new iWaypointFinal = -1
	new waypoint[7]
	new bool:ducking, Float:point[3], Float:absMin[3], Float:absMax[3], Float:normal[3]
	new i, bool:bContain, Float:dist, Float:lastDist, Float:vecDist[3], Float:vecDest[3]
	for (new iWaypoint = ArraySize(arrayWaypoint) - 1; 0 < iWaypoint; iWaypoint--)
	{
		ArrayGetArray(arrayWaypoint, iWaypoint, waypoint)
		ducking = ArrayGetCell(gArray_NodeDucking, waypoint[0])
		ArrayGetArray(gArray_NodePoint, waypoint[0], point)
		ArrayGetArray(gArray_NodeAbsMin, waypoint[0], absMin)
		ArrayGetArray(gArray_NodeAbsMax, waypoint[0], absMax)
		ArrayGetArray(gArray_NodeNormal, waypoint[0], normal)
		
		for (i = 0; i < 2; i++)
		{
			if (goal[i] < absMin[i])	{ vecDist[i] = absMin[i] - goal[i];	vecDest[i] = absMin[i]; }
			else if (absMax[i] < goal[i])	{ vecDist[i] = goal[i] - absMax[i];	vecDest[i] = absMax[i]; }
			else				{ vecDist[i] = 0.0;			vecDest[i] = goal[i]; }
		}
		
		point[2] -= ducking ? 18.0 : 36.0
		absMin[2] = InclinedPlaneZ(point, normal, goal)
		absMax[2] = absMin[2] + (ducking ? 36.0 : 72.0)
		point[2] = (absMin[2] + absMax[2]) * 0.5
		if (goal[2] < absMin[2])	vecDist[2] = absMin[2] - goal[2]
		else if (absMax[2] < goal[2])	vecDist[2] = goal[2] - absMax[2]
		else				vecDist[2] = 0.0
		
		if (vecDist[0] == 0.0 && vecDist[1] == 0.0 && vecDist[2] == 0.0)
		{
			dist = (point[2] - goal[2]) * (point[2] - goal[2])
			if (dist < lastDist || !bContain)
			{
				lastDist = dist
				bContain = true
				iWaypointFinal = iWaypoint
			}
			continue
		}
		if (bContain) continue
		
		dist =	(vecDist[0]) * (vecDist[0]) +
			(vecDist[1]) * (vecDist[1]) +
			(vecDist[2]) * (vecDist[2])
		
		if (dist < lastDist || iWaypointFinal < 0)
		{
			lastDist = dist
			iWaypointFinal = iWaypoint
		}
	}
	return iWaypointFinal
}
public _Sys_GetWaypointSecond()
{
	new Array:arrayWaypoint = any:get_param(1)
	
	new waypoint[7]
	waypoint[5] = get_param(2)
	
	do ArrayGetArray(arrayWaypoint, waypoint[5], waypoint)
	while (0 < waypoint[5])
	
	set_array(3, waypoint, 7)
}
public _Sys_GetWaypointPathInfo()
{
	new Array:arrayWaypoint = any:get_param(1)
	new iWaypointFinal = get_param(2)
	
	new Float:origin[3]
	get_array_f(3, origin, 3)
	
	new waypoint[7]
	new bool:ducking, Float:point[3], Float:absMin[3], Float:absMax[3], Float:normal[3], Float:vecDist[3], Float:vecDest[3]
	new i, bool:bContain, Float:dist, Float:lastDist = -1.0
	new iWaypointNearest, iWaypointNext, iWaypointTemp = -1
	while (0 <= iWaypointFinal)
	{
		ArrayGetArray(arrayWaypoint, iWaypointFinal, waypoint)
		
		ducking = ArrayGetCell(gArray_NodeDucking, waypoint[0])
		ArrayGetArray(gArray_NodePoint, waypoint[0], point)
		ArrayGetArray(gArray_NodeAbsMin, waypoint[0], absMin)
		ArrayGetArray(gArray_NodeAbsMax, waypoint[0], absMax)
		ArrayGetArray(gArray_NodeNormal, waypoint[0], normal)
		
		for (i = 0; i < 2; i++)
		{
			if (origin[i] < absMin[i])	{ vecDist[i] = absMin[i] - origin[i];	vecDest[i] = absMin[i]; }
			else if (absMax[i] < origin[i])	{ vecDist[i] = origin[i] - absMax[i];	vecDest[i] = absMax[i]; }
			else				{ vecDist[i] = 0.0;			vecDest[i] = origin[i]; }
		}
		
		point[2] -= ducking ? 18.0 : 36.0
		absMin[2] = InclinedPlaneZ(point, normal, origin)
		absMax[2] = absMin[2] + (ducking ? 36.0 : 72.0)
		point[2] = (absMin[2] + absMax[2]) * 0.5
		if (origin[2] < absMin[2])	vecDist[2] = absMin[2] - origin[2]
		else if (absMax[2] < origin[2])	vecDist[2] = origin[2] - absMax[2]
		else				vecDist[2] = 0.0
		
		if (vecDist[0] == 0.0 && vecDist[1] == 0.0 && vecDist[2] == 0.0)
		{
			dist = (point[2] - origin[2]) * (point[2] - origin[2])
			if (dist < lastDist || !bContain)
			{
				lastDist = dist
				bContain = true
				iWaypointNearest = iWaypointFinal
				iWaypointNext = iWaypointTemp
			}
		}
		else if (!bContain)
		{
			dist =	(vecDist[0]) * (vecDist[0]) +
				(vecDist[1]) * (vecDist[1]) +
				(vecDist[2]) * (vecDist[2])
			
			if (dist < lastDist || lastDist < 0.0)
			{
				lastDist = dist
				iWaypointNearest = iWaypointFinal
				iWaypointNext = iWaypointTemp
			}
		}
		
		iWaypointTemp = iWaypointFinal
		iWaypointFinal = waypoint[5]
	}
	
	ArrayGetArray(arrayWaypoint, iWaypointNearest, waypoint)
	if (0 <= waypoint[5])
	{
		if (0.0 < Float:ArrayGetCell(ArrayGetCell(gArray_NodeHeight, waypoint[4]), waypoint[6]))
		{
			ArrayGetArray(gArray_NodePoint, waypoint[0], point)
			dist = (point[2] - origin[2]) * (point[2] - origin[2])
			ArrayGetArray(gArray_NodePoint, waypoint[4], point)
			lastDist = (point[2] - origin[2]) * (point[2] - origin[2])
			if (lastDist < dist)
			{
				set_param_byref(4, waypoint[4])
				set_param_byref(5, waypoint[0])
				set_param_byref(6, waypoint[6])
				return
			}
		}
	}
	
	if (iWaypointNext < 0)
	{
		set_param_byref(4, waypoint[0])
		set_param_byref(5, -1)
		set_param_byref(6, -1)
		return
	}
	
	ArrayGetArray(arrayWaypoint, iWaypointNext, waypoint)
	set_param_byref(4, waypoint[4])
	set_param_byref(5, waypoint[0])
	set_param_byref(6, waypoint[6])
}
public Array:_Sys_GetSpawnPos() { return gArray_SpawnPos; }
public Array:_Sys_GetLadder() { return gArray_Ladder; }
public bool:_Box_Exist()
{
	new Float:origin[3]
	get_array_f(1, origin, 3)
	return NavBox_Exist(origin)
}
public _Box_Draw()
{
	new Float:absMin[3], Float:absMax[3]
	get_array_f(2, absMin, 3)
	get_array_f(3, absMax, 3)
	NavBox_Draw(get_param(1), absMin, absMax, get_param(4), get_param(5), get_param(6), get_param(7), get_param(8), get_param(9))
}
public _Box_GetArea()
{
	set_array_f(1, gMapAbsMin, 3)
	set_array_f(2, gMapAbsMax, 3)
}
public _Box_GetContain()
{
	new Float:origin[3], Float:absMin[3], Float:absMax[3]
	get_array_f(1, origin, 3)
	NavBox_GetContain(origin, absMin, absMax)
	set_array_f(2, absMin, 3)
	set_array_f(3, absMax, 3)
}
public _Box_GetNearest()
{
	new Float:origin[3], Float:absMin[3], Float:absMax[3]
	get_array_f(1, origin, 3)
	NavBox_GetNearest(origin, absMin, absMax)
	set_array_f(2, absMin, 3)
	set_array_f(3, absMax, 3)
}
public Array:_Box_GetNodeArray()
{
	new Float:origin[3]
	get_array_f(1, origin, 3)
	return NavBox_GetNodeArray(origin)
}
public _Box_GetNode()
{
	new Float:origin[3]
	get_array_f(1, origin, 3)
	return NavBox_GetNode(origin)
}
public _Box_GetNodeNearest()
{
	new Float:origin[3]
	get_array_f(1, origin, 3)
	return NavBox_GetNodeNearest(origin)
}
public _Box_GetNodeContain()
{
	new Float:origin[3]
	get_array_f(1, origin, 3)
	return NavBox_GetNodeContain(origin)
}
public _Box_GetNodeIntersect()
{
	new Float:absMin[3], Float:absMax[3]
	get_array_f(1, absMin, 3)
	get_array_f(2, absMax, 3)
	return NavBox_GetNodeIntersect(absMin, absMax)
}
public _Box_GetNodeInFront() { return NavBox_GetNodeInFront(get_param(1)); }
public _Node_DrawMesh()
{
	NavNode_DrawMesh(get_param(1), get_param(2), bool:get_param(3), get_param(4), get_param(5), get_param(6), get_param(7), get_param(8), get_param(9))
}
public _Node_DrawBox() { NavNode_DrawBox(get_param(1), get_param(2), get_param(3), get_param(4), get_param(5), get_param(6), get_param(7), get_param(8)); }
public _Node_GetNearest()
{
	new Float:origin[3]
	get_array_f(1, origin, 3)
	return NavNode_GetNearest(origin)
}
public _Node_GetPathCoord()
{
	new Float:start[3], Float:mid[3], Float:end[3]
	NavNode_GetPathCoord(get_param(1), get_param(2), get_param(3), start, mid, end)
	set_array_f(4, start, 3)
	set_array_f(5, mid, 3)
	set_array_f(6, end, 3)
}
public _Node_GetPathCoord2()
{
	new PathFlags:flags, Float:height, Float:end[3]
	NavNode_GetPathCoord2(get_param(1), get_param(2), get_param(3), flags, height, end)
	set_param_byref(4, any:flags)
	set_param_byref(5, any:height)
	set_array_f(6, end, 3)
}
public bool:_Node_PathExist()
{
	new bool:duckingStart, Float:start[3], Float:goal[3]
	new bool:duckingEnd, Float:end[3], Float:normal[3]
	new bool:crouchRun, Float:height
	new bool:exist
	
	duckingStart = any:get_param(1)
	get_array_f(2, start, 3)
	get_array_f(3, goal, 3)
	
	exist = NavPath_Exist(duckingStart, start, goal, duckingEnd, end, normal, crouchRun, height)
	
	set_param_byref(4, any:duckingEnd)
	set_array_f(5, end, 3)
	set_array_f(6, normal, 3)
	set_param_byref(7, any:crouchRun)
	set_param_byref(8, any:height)
	
	return exist
}
public bool:_Node_PathExist2()
{
	new bool:duckingStart, Float:start[3], Float:goal[3]
	new bool:duckingEnd, Float:end[3], Float:normal[3]
	new bool:crouchRun, Float:height
	new bool:exist
	
	duckingStart = any:get_param(1)
	get_array_f(2, start, 3)
	get_array_f(3, goal, 3)
	
	exist = NavPath_Exist2(duckingStart, start, goal, duckingEnd, end, normal, crouchRun, height)
	
	set_param_byref(4, any:duckingEnd)
	set_array_f(5, end, 3)
	set_array_f(6, normal, 3)
	set_param_byref(7, any:crouchRun)
	set_param_byref(8, any:height)
	
	return exist
}

NavSysMenu_Init()
{
	new menuName[32], itemName[32]
	format(menuName, 31, "%L", LANG_SERVER, "MENU_NAME_MAIN")
	gMenuId_Main = menu_create(menuName, "MenuHandler_Main")
	
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_NODE_CREATE")
	menu_additem(gMenuId_Main, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_NODE_EDIT")
	menu_additem(gMenuId_Main, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST")
	menu_additem(gMenuId_Main, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_SAVE")
	menu_additem(gMenuId_Main, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_RELOAD")
	menu_additem(gMenuId_Main, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_DELETE")
	menu_additem(gMenuId_Main, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_EDIT_OFF")
	menu_additem(gMenuId_Main, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_MENU_OFF")
	menu_setprop(gMenuId_Main, MPROP_EXITNAME, itemName)
	
	format(menuName, 31, "%L", LANG_SERVER, "MENU_NAME_NODE_CREATE")
	gMenuId_Create = menu_create(menuName, "MenuHandler_Create")
	
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_AUTO_GENERATION")
	menu_additem(gMenuId_Create, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_CREATE_TO_FOOT")
	menu_additem(gMenuId_Create, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_CREATE_TO_AIM")
	menu_additem(gMenuId_Create, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_AUTO_ALIGN")
	menu_additem(gMenuId_Create, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TO_MAIN")
	menu_setprop(gMenuId_Create, MPROP_EXITNAME, itemName)
	
	format(menuName, 31, "%L", LANG_SERVER, "MENU_NAME_NODE_EDIT")
	gMenuId_Edit = menu_create(menuName, "MenuHandler_Edit")
	
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_NODE_SELECT")
	menu_additem(gMenuId_Edit, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_NODE_CROUCH")
	menu_additem(gMenuId_Edit, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_NODE_MERGE")
	menu_additem(gMenuId_Edit, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_NODE_DELETE")
	menu_additem(gMenuId_Edit, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_NODE_AUTO_MERGE1")
	menu_additem(gMenuId_Edit, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_NODE_AUTO_MERGE2")
	menu_additem(gMenuId_Edit, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_PATH_CONNECT")
	menu_additem(gMenuId_Edit, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_PATH_SET_CROUCH")
	menu_additem(gMenuId_Edit, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_PATH_SET_CLIMB")
	menu_additem(gMenuId_Edit, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_PATH_SET_HEIGHT")
	menu_additem(gMenuId_Edit, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_BACK")
	menu_setprop(gMenuId_Edit, MPROP_BACKNAME, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_NEXT")
	menu_setprop(gMenuId_Edit, MPROP_NEXTNAME, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TO_MAIN")
	menu_setprop(gMenuId_Edit, MPROP_EXITNAME, itemName)
	
	format(menuName, 31, "%L", LANG_SERVER, "MENU_NAME_TEST")
	gMenuId_Test = menu_create(menuName, "MenuHandler_Test")
	
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST1")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST2")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST3")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST4")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST5")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST6")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST7")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST8")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST9")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST10")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST11")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST12")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST13")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST14")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST15")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST16")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST17")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TEST18")
	menu_additem(gMenuId_Test, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_BACK")
	menu_setprop(gMenuId_Test, MPROP_BACKNAME, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_NEXT")
	menu_setprop(gMenuId_Test, MPROP_NEXTNAME, itemName)
	format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_TO_MAIN")
	menu_setprop(gMenuId_Test, MPROP_EXITNAME, itemName)
	
	gAutoAlign = true
	gArray_Selected = ArrayCreate()
}

public MenuHandler_Main(id, menuId, itemId)
{
	if(!(get_user_flags(id) & ADMIN_RCON)) return
	if (id != 1) return
	if (!is_user_alive(id)) return
	
	switch (itemId)
	{
		// 创建导航点
		case 0: menu_display(id, gMenuId_Create)
		// 编辑导航点
		case 1: menu_display(id, gMenuId_Edit)
		// 测试功能
		case 2: menu_display(id, gMenuId_Test)
		// 保存导航信息
		case 3:
		{
			NavSys_SaveFile(id)
			menu_display(id, gMenuId_Main)
		}
		// 重载导航信息
		case 4:
		{
			NavSys_LoadFile(id)
			menu_display(id, gMenuId_Main)
		}
		// 清除导航信息
		case 5:
		{
			NavSys_DeleteFile(id)
			menu_display(id, gMenuId_Main)
		}
		// 关闭编辑模式
		case 6:
		{
			NavSysMenu_Destroy()
			client_print(id, print_chat, "%L", LANG_SERVER, "EDIT_MODE_OFF")
		}
	}
}

public MenuHandler_Create(id, menuId, itemId)
{
	if(!(get_user_flags(id) & ADMIN_RCON)) return;
	if (id != 1) return
	if (!is_user_alive(id)) return
	
	switch (itemId)
	{
		// 自动创建
		case 0: NavSysMenu_AutoCreating(id)
		// 创建到脚下
		case 1: NavSysMenu_CreateNodeOnGround(id)
		// 创建到准星
		case 2: NavSysMenu_CreateNodeInFront(id)
		// 自动对齐
		case 3:
		{
			gAutoAlign = !gAutoAlign
			new itemName[32]
			if (gAutoAlign)
			{
				format(itemName, 31, "%L", LANG_SERVER, "ITEM_NAME_AUTO_ALIGN")
				menu_item_setname(gMenuId_Create, 4, itemName)
				client_print(id, print_chat, "%L", LANG_SERVER, "AUTO_ALIGN_ON")
			}
			else
			{
				format(itemName, 31, "\d%L", LANG_SERVER, "ITEM_NAME_AUTO_ALIGN")
				menu_item_setname(gMenuId_Create, 4, itemName)
				client_print(id, print_chat, "%L", LANG_SERVER, "AUTO_ALIGN_OFF")
			}
		}
		case MENU_EXIT: { menu_display(id, gMenuId_Main); return; }
	}
	menu_display(id, gMenuId_Create)
}

public MenuHandler_Edit(id, menuId, itemId)
{
	if(!(get_user_flags(id) & ADMIN_RCON)) return;
	if (id != 1) return
	if (!is_user_alive(id)) return
	
	switch (itemId)
	{
		// 导航点:选择/舍弃
		case 0: NavSysMenu_Selects(id)
		// 导航点:蹲下/站起
		case 1: NavSysMenu_Crouch(id)
		// 导航点:合并
		case 2: NavSysMenu_Merge(id)
		// 导航点:删除
		case 3: NavSysMenu_Delete(id)
		// 导航点:自动合并.短
		case 4: NavSysMenu_AutoMerging(id, false)
		// 导航点:自动合并.长
		case 5: NavSysMenu_AutoMerging(id, true)
		// 路径:创建/删除
		case 6: NavSysMenu_CreatePath(id)
		// 路径:蹲跑标志
		case 7: { menu_display(id, gMenuId_Edit, 1); NavSysMenu_ChangePathFlags(id, false); return; }
		// 路径:攀爬标志
		case 8: { menu_display(id, gMenuId_Edit, 1); NavSysMenu_ChangePathFlags(id, true); return; }
		// 路径:障碍高度
		case 9: { menu_display(id, gMenuId_Edit, 1); NavSysMenu_ChangePathHeight(id); return; }
		case MENU_EXIT: { menu_display(id, gMenuId_Main); return; }
	}
	menu_display(id, gMenuId_Edit)
}

public MenuHandler_Test(id, menuId, itemId)
{
	if(!(get_user_flags(id) & ADMIN_RCON)) return;
	if (id != 1) return
	if (!is_user_alive(id)) return
	
	switch (itemId)
	{
		// NavSys_Pathfinding
		case 0: NavSysMenu_Test1(id)
		// NavSys_GetWaypointFinal
		case 1: NavSysMenu_Test2(id)
		// NavSys_GetWaypointSecond
		case 2: NavSysMenu_Test3(id)
		// NavSys_GetWaypointPathInfo
		case 3: NavSysMenu_Test4(id)
		// NavSys_GetSpawnPos
		case 4: NavSysMenu_Test5(id)
		// NavSys_GetLadder
		case 5: NavSysMenu_Test6(id)
		// NavBox_Exist&Contain&Nearest
		case 6: NavSysMenu_Test7(id)
		// NavBox_GetNodeArray
		case 7: { menu_display(id, gMenuId_Test, 1); NavSysMenu_Test8(id); return; }
		// NavBox_GetNode
		case 8: { menu_display(id, gMenuId_Test, 1); NavSysMenu_Test9(id); return; }
		// NavBox_GetNodeNearest
		case 9: { menu_display(id, gMenuId_Test, 1); NavSysMenu_Test10(id); return; }
		// NavBox_GetNodeContain
		case 10: { menu_display(id, gMenuId_Test, 1); NavSysMenu_Test11(id); return; }
		// NavBox_GetNodeIntersect
		case 11: { menu_display(id, gMenuId_Test, 1); NavSysMenu_Test12(id); return; }
		// NavNode_DrawBox
		case 12: { menu_display(id, gMenuId_Test, 1); NavSysMenu_Test13(id); return; }
		// NavNode_GetNearest
		case 13: { menu_display(id, gMenuId_Test, 1); NavSysMenu_Test14(id); return; }
		// NavNode_GetPathCoord
		case 14: { menu_display(id, gMenuId_Test, 2); NavSysMenu_Test15(id); return; }
		// NavNode_GetPathCoord2
		case 15: { menu_display(id, gMenuId_Test, 2); NavSysMenu_Test16(id); return; }
		// NavNode_PathExist
		case 16: { menu_display(id, gMenuId_Test, 2); NavSysMenu_Test17(id); return; }
		// NavNode_PathExist2
		case 17: { menu_display(id, gMenuId_Test, 2); NavSysMenu_Test18(id); return; }
		case MENU_EXIT: { menu_display(id, gMenuId_Main); return; }
	}
	menu_display(id, gMenuId_Test)
}

NavSysMenu_Destroy()
{
	if (0 <= gMenuId_Main)
	{
		menu_destroy(gMenuId_Main)
		gMenuId_Main = -1
	}
	if (0 <= gMenuId_Create)
	{
		menu_destroy(gMenuId_Create)
		gMenuId_Create = -1
	}
	if (0 <= gMenuId_Edit)
	{
		menu_destroy(gMenuId_Edit)
		gMenuId_Edit = -1
	}
	if (0 <= gMenuId_Test)
	{
		menu_destroy(gMenuId_Test)
		gMenuId_Test = -1
	}
	
	gNodeId_Aiming = -1
	ArrayDestroy(gArray_Selected)
}

NavSysMenu_AutoCreating(id)
{
	NavNode_AutoCreating()
	NavBox_Update()
	NavSys_SaveFile(id)
}

NavSysMenu_CreateNodeOnGround(id)
{
	new Float:vecSrc[3]
	pev(id, pev_origin, vecSrc)
	
	new hull = pev(id, pev_flags) & FL_DUCKING ? HULL_HEAD : HULL_HUMAN
	
	if (!NavSys_IsVacantSpace(vecSrc, hull))
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_CREATE_NODE")
		return
	}
	
	new Float:vecDest[3], Float:vecEndPos[3], Float:vecPlaneNormal[3]
	vecDest[0] = vecSrc[0]
	vecDest[1] = vecSrc[1]
	vecDest[2] = vecSrc[2] - 9999.0
	NavSys_Trace(vecSrc, vecDest, hull)
	get_tr2(0, TR_vecEndPos, vecEndPos)
	get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal)
	
	if (gAutoAlign)
	{
		vecDest[0] = 16.0 * floatround(vecEndPos[0] / 16.0)
		vecDest[1] = 16.0 * floatround(vecEndPos[1] / 16.0)
		vecDest[2] = vecEndPos[2]
		if (!VecEqual(vecEndPos, vecDest))
		{
			InclinedPlanePoint(vecEndPos, vecPlaneNormal, vecDest, vecEndPos)
			if (!NavSys_IsVacantSpace(vecEndPos, hull))
			{
				client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_CREATE_NODE")
				return
			}
			
			vecDest[0] = vecEndPos[0]
			vecDest[1] = vecEndPos[1]
			vecDest[2] = vecEndPos[2] - 9999.0
			NavSys_Trace(vecEndPos, vecDest, hull)
			get_tr2(0, TR_vecEndPos, vecEndPos)
			get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal)
		}
	}
	
	if (NavBox_Exist(vecEndPos) && 0 <= NavBox_GetNodeContain(vecEndPos))
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_CREATE_NODE")
		return
	}
	
	new nodeIndex = NavNode_Create(vecEndPos, vecPlaneNormal, (hull == HULL_HEAD))
	NavBox_AddNode(nodeIndex)
	
	NavNode_DrawMesh(id, nodeIndex, false, 5, 5, 25, 255, 0, 0)
	client_print(id, print_chat, "%L", LANG_SERVER, "CREATE_NODE", nodeIndex, nodeIndex + 1)
}

NavSysMenu_CreateNodeInFront(id)
{
	new Float:vecSrc[3], Float:vecIdeal[3], Float:vecDest[3], Float:vecEndPos[3], Float:vecPlaneNormal[3]
	pev(id, pev_origin, vecSrc)
	pev(id, pev_view_ofs, vecIdeal)
	VecAdd(vecSrc, vecIdeal, vecSrc)
	pev(id, pev_v_angle, vecIdeal)
	AngleVector(vecIdeal, ANGLEVECTOR_FORWARD, vecIdeal)
	VecMulScalar(vecIdeal, 9999.0, vecIdeal)
	VecAdd(vecSrc, vecIdeal, vecDest)
	NavSys_Trace(vecSrc, vecDest, -1)
	get_tr2(0, TR_vecEndPos, vecEndPos)
	get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal)
	
	if (gAutoAlign)
	{
		vecDest[0] = 16.0 * floatround(vecEndPos[0] / 16.0)
		vecDest[1] = 16.0 * floatround(vecEndPos[1] / 16.0)
		InclinedPlanePoint(vecEndPos, vecPlaneNormal, vecDest, vecEndPos)
	}
	
	new hull = HULL_HEAD
	
	vecEndPos[2] += 36.0
	vecDest[0] = vecEndPos[0]
	vecDest[1] = vecEndPos[1]
	vecDest[2] = vecEndPos[2] - 9999.0
	NavSys_Trace(vecEndPos, vecDest, hull)
	get_tr2(0, TR_vecEndPos, vecEndPos)
	get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal)
	
	if (!NavSys_IsVacantSpace(vecEndPos, hull))
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_CREATE_NODE")
		return
	}
	
	hull = HULL_HUMAN
	vecEndPos[2] += 18.0
	
	if (!NavSys_IsVacantSpace(vecEndPos, hull))
	{
		hull = HULL_HEAD
		vecEndPos[2] -= 18.0
	}
	
	if (NavBox_Exist(vecEndPos) && 0 <= NavBox_GetNodeContain(vecEndPos))
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_CREATE_NODE")
		return
	}
	
	new nodeIndex = NavNode_Create(vecEndPos, vecPlaneNormal, (hull == HULL_HEAD))
	NavBox_AddNode(nodeIndex)
	
	NavNode_DrawMesh(id, nodeIndex, false, 5, 5, 25, 255, 0, 0)
	client_print(id, print_chat, "%L", LANG_SERVER, "CREATE_NODE", nodeIndex, nodeIndex + 1)
}

NavSysMenu_Selects(id)
{
	if (gNodeId_Aiming < 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_SELECT_NODE")
		return
	}
	client_print(id, print_chat, "%L", LANG_SERVER, NavNode_Selects(gNodeId_Aiming) ? "SELECT_NODE" : "UNSELECT_NODE", gNodeId_Aiming)
}

NavSysMenu_Crouch(id)
{
	new nodeNums = ArraySize(gArray_Selected)
	if (!nodeNums)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_SET_NODE_CROUCH")
		return
	}
	
	new iNode, iPath
	new iNodeStart, iPathTemp
	new Array:arrayStart, Array:arrayEnd, Array:arrayDistance
	new bool:ducking, Float:origin[3], Float:absMax[3], Float:dest[3]
	
	for (new i = 0; i < nodeNums; i++)
	{
		iNode = ArrayGetCell(gArray_Selected, i)
		
		ArrayGetArray(gArray_NodePoint, iNode, origin)
		ArrayGetArray(gArray_NodeAbsMax, iNode, absMax)
		
		if (ArrayGetCell(gArray_NodeDucking, iNode))
		{
			ducking = false
			origin[2] += 18.0
			absMax[2] += 36.0
		}
		else
		{
			ducking = true
			dest[0] = origin[0]
			dest[1] = origin[1]
			dest[2] = origin[2] - 9999.0
			NavSys_Trace(origin, dest, HULL_HEAD)
			get_tr2(0, TR_vecEndPos, origin)
			absMax[2] -= 36.0
		}
		
		ArraySetArray(gArray_NodePoint, iNode, origin)
		ArraySetArray(gArray_NodeAbsMax, iNode, absMax)
		ArraySetCell(gArray_NodeDucking, iNode, ducking)
		
		arrayStart = ArrayGetCell(gArray_NodeStart, iNode)
		for (iPath = ArraySize(arrayStart) - 1; 0 <= iPath; iPath--)
		{
			iNodeStart = ArrayGetCell(arrayStart, iPath)
			
			ArrayGetArray(gArray_NodePoint, iNodeStart, dest)
			
			arrayEnd	= ArrayGetCell(gArray_NodeEnd,		iNodeStart)
			arrayDistance	= ArrayGetCell(gArray_NodeDistance,	iNodeStart)
			
			for (iPathTemp = ArraySize(arrayEnd) - 1; 0 <= iPathTemp; iPathTemp--)
			{
				if (ArrayGetCell(arrayEnd, iPathTemp) != iNode) continue
				
				ArraySetCell(arrayDistance, iPathTemp, VecDistance(origin, dest))
			}
		}
		
		arrayEnd	= ArrayGetCell(gArray_NodeEnd,		iNode)
		arrayDistance	= ArrayGetCell(gArray_NodeDistance,	iNode)
		for (iPath = ArraySize(arrayEnd) - 1; 0 <= iPath; iPath--)
		{
			ArrayGetArray(gArray_NodePoint, ArrayGetCell(arrayEnd, iPath), dest)
			
			ArraySetCell(arrayDistance, iPath, VecDistance(origin, dest))
		}
		
		client_print(id, print_chat, "%L", LANG_SERVER, ducking ? "SET_NODE_DUCKING" : "SET_NODE_STANDING", iNode)
	}
	
	ArrayClear(gArray_Selected)
	
	NavBox_Update()
}

NavSysMenu_Merge(id)
{
	new nodeNums = ArraySize(gArray_Selected)
	if (nodeNums != 2)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_MERGE1")
		return
	}
	
	new iNodeStart = ArrayGetCell(gArray_Selected, 0)
	new iNodeEnd = ArrayGetCell(gArray_Selected, 1)
	ArrayClear(gArray_Selected)
	
	if (ArrayGetCell(gArray_NodeDucking, iNodeStart) != ArrayGetCell(gArray_NodeDucking, iNodeEnd))
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_MERGE2")
		return
	}
	
	new iPath, Array:arrayStart, Array:arrayEnd
	
	arrayStart = ArrayGetCell(gArray_NodeStart, iNodeStart)
	for (iPath = ArraySize(arrayStart) - 1; 0 <= iPath && ArrayGetCell(arrayStart, iPath) != iNodeEnd; iPath--) { }
	if (iPath < 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_MERGE3", iNodeEnd, iNodeStart)
		return
	}
	arrayEnd = ArrayGetCell(gArray_NodeEnd, iNodeStart)
	for (iPath = ArraySize(arrayEnd) - 1; 0 <= iPath && ArrayGetCell(arrayEnd, iPath) != iNodeEnd; iPath--) { }
	if (iPath < 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_MERGE3", iNodeStart, iNodeEnd)
		return
	}
	
	new Float:normal[2][3]
	ArrayGetArray(gArray_NodeNormal, iNodeStart, normal[0])
	ArrayGetArray(gArray_NodeNormal, iNodeEnd, normal[1])
	if (!VecEqual(normal[0], normal[1]))
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_MERGE4", iNodeStart, iNodeEnd)
		return
	}
	
	new Float:absMin[3][3], Float:absMax[3][3]
	new Float:width[2], Float:height[2]
	
	ArrayGetArray(gArray_NodeAbsMin, iNodeStart, absMin[0])
	ArrayGetArray(gArray_NodeAbsMax, iNodeStart, absMax[0])
	ArrayGetArray(gArray_NodeAbsMin, iNodeEnd, absMin[1])
	ArrayGetArray(gArray_NodeAbsMax, iNodeEnd, absMax[1])
	
	width[0] = absMax[0][0] - absMin[0][0]
	height[0] = absMax[0][1] - absMin[0][1]
	width[1] = absMax[1][0] - absMin[1][0]
	height[1] = absMax[1][1] - absMin[1][1]
	
	// 如果iNodeStart与iNodeEnd无法竖向对齐或横向对齐
	if ((absMin[0][0] != absMin[1][0] || absMax[0][0] != absMax[1][0]) && (absMin[0][1] != absMin[1][1] || absMax[0][1] != absMax[1][1]))
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_MERGE5", iNodeStart, iNodeEnd)
		return
	}
	
	new Float:origin[3], Float:dest[3], Float:mins[3], Float:maxs[3]
	for (new i = 0; i < 3; i++)
	{
		absMin[2][i] = floatmin(absMin[0][i], absMin[1][i])
		absMax[2][i] = floatmax(absMax[0][i], absMax[1][i])
		origin[i] = (absMin[2][i] + absMax[2][i]) * 0.5
		dest[i] = origin[i]
		mins[i] = absMin[2][i] - origin[i]
		maxs[i] = absMax[2][i] - origin[i]
	}
	
	switch (NavNode_Merge(iNodeStart, iNodeEnd, origin, absMin[2], absMax[2]))
	{
		case 0:
		{
			client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_MERGE6", iNodeStart, iNodeEnd)
			return
		}
		case -1:
		{
			client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_MERGE7", iNodeStart, iNodeEnd)
			return
		}
		case -2:
		{
			client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_MERGE8", iNodeStart, iNodeEnd)
			return
		}
		case -3:
		{
			client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_MERGE9", iNodeStart, iNodeEnd)
			return
		}
		case -4:
		{
			client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_MERGE10", iNodeStart, iNodeEnd)
			return
		}
		case -5:
		{
			client_print(id, print_chat, "%L", LANG_SERVER, "FAILED_TO_MERGE11", iNodeStart, iNodeEnd)
			return
		}
	}
	
	NavBox_Update()
	
	NavNode_DrawMesh(id, iNodeEnd < iNodeStart ? iNodeStart - 1 : iNodeStart, true, 5, 5, 25, 255, 0, 0)
	
	client_print(id, print_chat, "%L", LANG_SERVER, "MERGE", iNodeEnd, iNodeStart)
}

NavSysMenu_Delete(id)
{
	new nodeNums = ArraySize(gArray_Selected)
	if (!nodeNums)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "NODE_DELETION_FAILED")
		return
	}
	
	new i, j, k, l, iNode
	
	// 将已选中的导航点编号按照从大到小的顺序排列
	for (i = 0; i < nodeNums - 1; i++)
	{
		for (j = 0; j < nodeNums - 1 - i; j++)
		{
			k = ArrayGetCell(gArray_Selected, j)
			l = ArrayGetCell(gArray_Selected, j + 1)
			if (l > k)
			{
				ArraySetCell(gArray_Selected, j, l)
				ArraySetCell(gArray_Selected, j + 1, k)
			}
		}
	}
	
	for (i = 0; i < nodeNums; i++)
	{
		iNode = ArrayGetCell(gArray_Selected, i)
		NavNode_Delete(iNode)
		client_print(id, print_chat, "%L", LANG_SERVER, "NODE_DELETED", iNode)
	}
	
	ArrayClear(gArray_Selected)
	
	// 更新世界盒内导航点信息
	NavBox_Update()
}

NavSysMenu_AutoMerging(id, bool:longAllowed)
{
	if (!ArraySize(gArray_NodeDucking))
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "AUTO_MERGE_FAILED")
		return
	}
	
	ArrayClear(gArray_Selected)
	
	NavNode_AutoMerging(longAllowed)
	NavNode_AutoMerging(longAllowed)
	NavBox_Update()
	NavSys_SaveFile(id)
}

NavSysMenu_CreatePath(id)
{
	new nodeNums = ArraySize(gArray_Selected)
	if (nodeNums != 2)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "PATH_CONNECT_FAILED")
		return
	}
	
	new iNodeStart	= ArrayGetCell(gArray_Selected, 0)
	new iNodeEnd	= ArrayGetCell(gArray_Selected, 1)
	ArrayClear(gArray_Selected)
	
	new Array:arrayStart
	new Array:arrayEnd	= ArrayGetCell(gArray_NodeEnd,		iNodeStart)
	new Array:arrayFlags	= ArrayGetCell(gArray_NodeFlags,	iNodeStart)
	new Array:arrayHeight	= ArrayGetCell(gArray_NodeHeight,	iNodeStart)
	new Array:arrayDistance	= ArrayGetCell(gArray_NodeDistance,	iNodeStart)
	
	for (new iPath = ArraySize(arrayEnd) - 1; 0 <= iPath; iPath--)
	{
		// 如果iNodeEnd是iNodeStart的终点之一
		if (ArrayGetCell(arrayEnd, iPath) == iNodeEnd)
		{
			/** 删除此路径 */
			ArrayDeleteItem(arrayEnd,	iPath)
			ArrayDeleteItem(arrayFlags,	iPath)
			ArrayDeleteItem(arrayHeight,	iPath)
			ArrayDeleteItem(arrayDistance,	iPath)
			
			/** iNodeStart不再是iNodeEnd的起点 */
			arrayStart = ArrayGetCell(gArray_NodeStart, iNodeEnd)
			for (iPath = ArraySize(arrayStart) - 1; 0 <= iPath; iPath--)
			{
				if (ArrayGetCell(arrayStart, iPath) == iNodeStart)
				{
					ArrayDeleteItem(arrayStart, iPath)
					break
				}
			}
			
			NavNode_DrawMesh(id, iNodeStart, true, 5, 5, 25, 255, 0, 0)
			NavNode_DrawMesh(id, iNodeEnd, false, 5, 5, 25, 255, 0, 0)
			client_print(id, print_chat, "%L", LANG_SERVER, "PATH_DISCONNECT", iNodeStart, iNodeEnd)
			return
		}
	}
	
	/** 将iNodeEnd设为iNodeStart的终点之一 */
	new Float:origin[3], Float:dest[3]
	ArrayGetArray(gArray_NodePoint, iNodeStart,	origin)
	ArrayGetArray(gArray_NodePoint, iNodeEnd,	dest)
	ArrayPushCell(arrayEnd,		iNodeEnd)
	ArrayPushCell(arrayFlags,	ArrayGetCell(gArray_NodeDucking, iNodeEnd) ? PF_CrouchRun : PF_Walk)
	ArrayPushCell(arrayHeight,	0.0)
	ArrayPushCell(arrayDistance,	VecDistance(origin, dest))
	
	/** 将iNodeStart设为iNodeEnd的起点之一 */
	ArrayPushCell(ArrayGetCell(gArray_NodeStart, iNodeEnd), iNodeStart)
	
	NavNode_DrawMesh(id, iNodeStart, true, 5, 5, 25, 255, 0, 0)
	NavNode_DrawMesh(id, iNodeEnd, false, 5, 5, 25, 255, 0, 0)
	client_print(id, print_chat, "%L", LANG_SERVER, "PATH_CONNECT", iNodeStart, iNodeEnd)
}

NavSysMenu_ChangePathFlags(id, bool:climb)
{
	new nodeNums = ArraySize(gArray_Selected)
	if (nodeNums != 2)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, climb ? "PATH_CHANGE_FLAG_FAILED3" : "PATH_CHANGE_FLAG_FAILED1")
		return
	}
	
	new iNodeStart = ArrayGetCell(gArray_Selected, 0)
	new iNodeEnd = ArrayGetCell(gArray_Selected, 1)
	ArrayClear(gArray_Selected)
	
	new iPath, Array:arrayEnd = ArrayGetCell(gArray_NodeEnd, iNodeStart)
	for (iPath = ArraySize(arrayEnd) - 1; 0 <= iPath; iPath--)
	{
		if (ArrayGetCell(arrayEnd, iPath) == iNodeEnd)
		{
			new Array:arrayFlags = ArrayGetCell(gArray_NodeFlags, iNodeStart)
			
			new PathFlags:pathFlags = ArrayGetCell(arrayFlags, iPath)
			
			if (climb)
			{
				if (pathFlags & PF_Climb)
				{
					pathFlags &= ~PF_Climb
					client_print(id, print_chat, "%L", LANG_SERVER, "PATH_SUB_FLAG2", iNodeStart, iNodeEnd)
				}
				else
				{
					pathFlags |= PF_Climb
					client_print(id, print_chat, "%L", LANG_SERVER, "PATH_ADD_FLAG2", iNodeStart, iNodeEnd)
				}
			}
			else
			{
				if (pathFlags & PF_CrouchRun)
				{
					pathFlags &= ~PF_CrouchRun
					client_print(id, print_chat, "%L", LANG_SERVER, "PATH_SUB_FLAG1", iNodeStart, iNodeEnd)
				}
				else
				{
					pathFlags |= PF_CrouchRun
					client_print(id, print_chat, "%L", LANG_SERVER, "PATH_ADD_FLAG1", iNodeStart, iNodeEnd)
				}
			}
			ArraySetCell(arrayFlags, iPath, pathFlags)
			return
		}
	}
	
	client_print(id, print_chat, "%L", LANG_SERVER, climb ? "PATH_CHANGE_FLAG_FAILED4" : "PATH_CHANGE_FLAG_FAILED2", iNodeEnd, iNodeStart)
}

NavSysMenu_ChangePathHeight(id)
{
	new nodeNums = ArraySize(gArray_Selected)
	if (nodeNums != 2)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "PATH_CHANGE_HEIGHT_FAILED1")
		return
	}
	
	new iNode1 = ArrayGetCell(gArray_Selected, 0)
	new iNode2 = ArrayGetCell(gArray_Selected, 1)
	
	new iPath, Array:arrayEnd = ArrayGetCell(gArray_NodeEnd, iNode1)
	for (iPath = ArraySize(arrayEnd) - 1; 0 <= iPath && ArrayGetCell(arrayEnd, iPath) != iNode2; iPath--) { }
	if (iPath < 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "PATH_CHANGE_HEIGHT_FAILED2", iNode2, iNode1)
		return
	}
	
	new Float:origin[3], Float:viewOfs[3]
	pev(id, pev_origin, origin)
	pev(id, pev_view_ofs, viewOfs)
	VecAdd(origin, viewOfs, origin)
	
	new Float:start[3], Float:mid[3], Float:end[3]
	NavNode_GetPathCoord(iNode1, iNode2, iPath, start, mid, end)
	
	new Float:vecX[3]
	vecX[0] = mid[0] - origin[0]
	vecX[1] = mid[1] - origin[1]
	new Float:vecLenX = VecLength2D(vecX)
	
	new Float:angles[3], Float:vecIdeal[3], Float:dest[3]
	pev(id, pev_v_angle, angles)
	angles[1] = floatatan2(vecX[1], vecX[0], degrees)
	AngleVector(angles, ANGLEVECTOR_FORWARD, vecIdeal)
	VecAddScaled(origin, vecIdeal, vecLenX * vecLenX / VecDot(vecX, vecIdeal), dest)
	
	start[2] -= ArrayGetCell(gArray_NodeDucking, iNode1) ? 12.0 : 30.0
	end[2] -= ArrayGetCell(gArray_NodeDucking, iNode2) ? 12.0 : 30.0
	
	new Array:arrayHeight = ArrayGetCell(gArray_NodeHeight, iNode1)
	new Float:oldHeight = ArrayGetCell(arrayHeight, iPath)
	new Float:height = float(clamp(floatround(dest[2] - start[2]), 0, floatround(dJumpHeight + 18)))
	ArraySetCell(arrayHeight, iPath, height)
	
	client_print(id, print_chat, "%L", LANG_SERVER, "PATH_CHANGE_HEIGHT", iNode1, iNode2, oldHeight, height)
	
	mid[2] = start[2] + height
	AngleVector(angles, ANGLEVECTOR_RIGHT, vecIdeal)
	VecAddScaled(mid, vecIdeal, 16.0, dest)
	
	SendMsg_BeamPoints(id, start, mid, gMdlId_BeamNode, 30, 10, 0, 218, 0, 0)
	SendMsg_BeamPoints(id, mid, end, gMdlId_BeamNode, 30, 10, 0, 218, 0, 0)
	SendMsg_BeamPoints(id, mid, dest, gMdlId_BeamNode, 30, 10, 0, 218, 0, 218)
}

native Array:NavSys_Pathfinding(iNodeOrigin, iNodeGoal, &iWaypointFinal, maxTickCount = -1)
NavSysMenu_Test1(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST1_NAME")
	
	if (ArraySize(gArray_Selected) != 2)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST1_FAILED1")
		return
	}
	
	new iNodeOrigin = ArrayGetCell(gArray_Selected, 0)
	new iNodeGoal = ArrayGetCell(gArray_Selected, 1)
	
	new timeLeft = tickcount()
	new iWaypointFinal
	new Array:arrayWaypoint = NavSys_Pathfinding(iNodeOrigin, iNodeGoal, iWaypointFinal)
	
	timeLeft = tickcount() - timeLeft
	
	if (iWaypointFinal < 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST1_FAILED2", ArraySize(arrayWaypoint), timeLeft)
		return
	}
	
	new iColor, colorRGB[3][3]
	colorRGB[0] = { 255, 0, 0 }
	colorRGB[1] = { 0, 255, 0 }
	colorRGB[2] = { 0, 0, 255 }
	
	new nodeNums = -1
	new waypoint[7], Float:start[3], Float:end[3]
	while (0 < iWaypointFinal)
	{
		ArrayGetArray(arrayWaypoint, iWaypointFinal, waypoint)
		ArrayGetArray(gArray_NodePoint, waypoint[4], start)
		ArrayGetArray(gArray_NodePoint, waypoint[0], end)
		SendMsg_BeamPoints(id, start, end, gMdlId_BeamNode, 50, 10, 0, colorRGB[iColor][0], colorRGB[iColor][1], colorRGB[iColor][2])
		iColor = (iColor + 1) % 3
		nodeNums++
		iWaypointFinal = waypoint[5]
	}
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST1", iNodeOrigin, iNodeGoal, nodeNums, ArraySize(arrayWaypoint), timeLeft)
}

native NavSys_GetWaypointFinal(Array:arrayWaypoint, const Float:goal[3])
NavSysMenu_Test2(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST2_NAME")
	
	if (ArraySize(gArray_Selected) != 2)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST2_FAILED")
		return
	}
	
	new iNodeOrigin = ArrayGetCell(gArray_Selected, 0)
	new iNodeGoal = ArrayGetCell(gArray_Selected, 1)
	
	new iWaypointFinal
	new Array:arrayWaypoint = NavSys_Pathfinding(iNodeOrigin, iNodeGoal, iWaypointFinal, 0)
	if (iWaypointFinal < 0)
	{
		new Float:goal[3]
		ArrayGetArray(gArray_NodePoint, iNodeGoal, goal)
		iWaypointFinal = NavSys_GetWaypointFinal(arrayWaypoint, goal)
	}
	
	new iColor, colorRGB[3][3]
	colorRGB[0] = { 255, 0, 0 }
	colorRGB[1] = { 0, 255, 0 }
	colorRGB[2] = { 0, 0, 255 }
	
	new iNodeFinal = -1
	new waypoint[7], Float:start[3], Float:end[3]
	while (0 < iWaypointFinal)
	{
		ArrayGetArray(arrayWaypoint, iWaypointFinal, waypoint)
		ArrayGetArray(gArray_NodePoint, waypoint[4], start)
		ArrayGetArray(gArray_NodePoint, waypoint[0], end)
		SendMsg_BeamPoints(id, start, end, gMdlId_BeamNode, 50, 10, 0, colorRGB[iColor][0], colorRGB[iColor][1], colorRGB[iColor][2])
		iColor = (iColor + 1) % 3
		iWaypointFinal = waypoint[5]
		
		if (iNodeFinal < 0) iNodeFinal = waypoint[0]
	}
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST2", iNodeFinal)
}

native NavSys_GetWaypointSecond(Array:arrayWaypoint, iWaypointFinal, waypoint[7])
NavSysMenu_Test3(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST3_NAME")
	
	if (ArraySize(gArray_Selected) != 2)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST3_FAILED")
		return
	}
	
	new iNodeOrigin = ArrayGetCell(gArray_Selected, 0)
	new iNodeGoal = ArrayGetCell(gArray_Selected, 1)
	
	new iWaypointFinal
	new Array:arrayWaypoint = NavSys_Pathfinding(iNodeOrigin, iNodeGoal, iWaypointFinal, 0)
	
	if (iWaypointFinal < 0)
	{
		new Float:goal[3]
		ArrayGetArray(gArray_NodePoint, iNodeGoal, goal)
		iWaypointFinal = NavSys_GetWaypointFinal(arrayWaypoint, goal)
	}
	
	new waypoint[7], Float:start[3], Float:end[3]
	NavSys_GetWaypointSecond(arrayWaypoint, iWaypointFinal, waypoint)
	ArrayGetArray(gArray_NodePoint, waypoint[4], start)
	ArrayGetArray(gArray_NodePoint, waypoint[0], end)
	SendMsg_BeamPoints(id, start, end, gMdlId_BeamNode, 50, 10, 0, 255, 0, 0)
	
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST3", waypoint[0])
}

native NavSys_GetWaypointPathInfo(Array:arrayWaypoint, iWaypointFinal, const Float:origin[3], &iNodeStart, &iNodeEnd, &iPath)
NavSysMenu_Test4(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST4_NAME")
	
	if (ArraySize(gArray_Selected) != 2)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST4_FAILED")
		return
	}
	
	new iNodeOrigin = ArrayGetCell(gArray_Selected, 0)
	new iNodeGoal = ArrayGetCell(gArray_Selected, 1)
	
	new iWaypointFinal
	new Array:arrayWaypoint = NavSys_Pathfinding(iNodeOrigin, iNodeGoal, iWaypointFinal, 0)
	
	if (iWaypointFinal < 0)
	{
		new Float:goal[3]
		ArrayGetArray(gArray_NodePoint, iNodeGoal, goal)
		iWaypointFinal = NavSys_GetWaypointFinal(arrayWaypoint, goal)
	}
	
	new waypoint[7], Float:origin[3], iNodeStart, iNodeEnd, iPath
	pev(id, pev_origin, origin)
	NavSys_GetWaypointPathInfo(arrayWaypoint, iWaypointFinal, origin, iNodeStart, iNodeEnd, iPath)
	
	new iColor, colorRGB[3][3]
	colorRGB[0] = { 255, 0, 0 }
	colorRGB[1] = { 0, 255, 0 }
	colorRGB[2] = { 0, 0, 255 }
	
	new nodeNums = -1
	new Float:start[3], Float:end[3]
	while (0 < iWaypointFinal && (nodeNums < 0 || waypoint[4] != iNodeStart))
	{
		ArrayGetArray(arrayWaypoint, iWaypointFinal, waypoint)
		ArrayGetArray(gArray_NodePoint, waypoint[4], start)
		ArrayGetArray(gArray_NodePoint, waypoint[0], end)
		SendMsg_BeamPoints(id, start, end, gMdlId_BeamNode, 50, 10, 0, colorRGB[iColor][0], colorRGB[iColor][1], colorRGB[iColor][2])
		iColor = (iColor + 1) % 3
		nodeNums++
		iWaypointFinal = waypoint[5]
	}
	SendMsg_BeamPoints(id, origin, start, gMdlId_BeamNode, 50, 10, 0, 255, 255, 255)
	
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST4", iNodeStart, iPath, iNodeEnd)
}

native Array:NavSys_GetSpawnPos()
NavSysMenu_Test5(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST5_NAME")
	
	new Array:arraySpawnPos = NavSys_GetSpawnPos()
	new spawnPosNums = ArraySize(arraySpawnPos)
	new Float:spawnPos[6], Float:vecSrc[3], Float:vecDest[3]
	for (new i; i < spawnPosNums; i++)
	{
		ArrayGetArray(arraySpawnPos, i, spawnPos)
		vecSrc[0] = spawnPos[0]
		vecSrc[1] = spawnPos[1]
		vecSrc[2] = spawnPos[2] - 36.0
		vecDest[0] = vecSrc[0]
		vecDest[1] = vecSrc[1]
		vecDest[2] = vecSrc[2] + 72.0
		SendMsg_BeamPoints(id, vecSrc, vecDest, gMdlId_BeamNode, 50, 10, 0, 0, 255, 0)
		vecDest[0] = vecSrc[0] + spawnPos[3] * 32.0
		vecDest[1] = vecSrc[1] + spawnPos[4] * 32.0
		vecDest[2] = vecSrc[2] + spawnPos[5] * 32.0
		SendMsg_BeamPoints(id, vecSrc, vecDest, gMdlId_BeamNode, 50, 20, 0, 255, 0, 255)
	}
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST5", spawnPosNums)
}

native Array:NavSys_GetLadder()
NavSysMenu_Test6(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST6_NAME")
	
	new Array:arrayLadder = NavSys_GetLadder()
	new iLadderEnt, solidType
	new ladderNums = ArraySize(arrayLadder)
	new Float:absMin[3], Float:absMax[3], Float:origin[3], Float:start[3], Float:end[3], Float:normal[3]
	new iVec, Float:vecLong[8][3], Float:vecShort[8][3]
	vecLong[0] = Float:{ 9999.0, 9999.0, 0.0 }
	vecLong[1] = Float:{ -9999.0, 9999.0, 0.0 }
	vecLong[2] = Float:{ -9999.0, -9999.0, 0.0 }
	vecLong[3] = Float:{ 9999.0, -9999.0, 0.0 }
	vecLong[4] = Float:{ 0.0, 9999.0, 9999.0 }
	vecLong[5] = Float:{ 0.0, -9999.0, 9999.0 }
	vecLong[6] = Float:{ 0.0, -9999.0, -9999.0 }
	vecLong[7] = Float:{ 0.0, 9999.0, -9999.0 }
	vecShort[0] = Float:{ 0.01, 0.01, 0.0 }
	vecShort[1] = Float:{ -0.01, 0.01, 0.0 }
	vecShort[2] = Float:{ -0.01, -0.01, 0.0 }
	vecShort[3] = Float:{ 0.01, -0.01, 0.0 }
	vecShort[4] = Float:{ 0.0, 0.01, 0.01 }
	vecShort[5] = Float:{ 0.0, -0.01, 0.01 }
	vecShort[6] = Float:{ 0.0, -0.01, -0.01 }
	vecShort[7] = Float:{ 0.0, 0.01, -0.01 }
	
	for (new i; i < ladderNums; i++)
	{
		iLadderEnt = ArrayGetCell(arrayLadder, i)
		solidType = pev(iLadderEnt, pev_solid)
		set_pev(iLadderEnt, pev_solid, SOLID_BSP)
		
		pev(iLadderEnt, pev_mins, absMin)
		pev(iLadderEnt, pev_maxs, absMax)
		pev(iLadderEnt, pev_origin, origin)
		
		VecAdd(origin, absMin, absMin)
		VecAdd(origin, absMax, absMax)
		origin[0] = (absMin[0] + absMax[0]) * 0.5
		origin[1] = (absMin[1] + absMax[1]) * 0.5
		origin[2] = (absMin[2] + absMax[2]) * 0.5
		
		for (iVec = 3; 0 <= iVec; iVec--)
		{
			VecAdd(origin, vecLong[iVec], end)
			
			engfunc(EngFunc_TraceLine, origin, end, dTraceIgnore, iLadderEnt, 0)
			get_tr2(0, TR_vecEndPos, end)
			
			VecAdd(end, vecShort[iVec], end)
			
			engfunc(EngFunc_TraceLine, end, origin, dTraceIgnore, 0, 0)
			if (get_tr2(0, TR_pHit) == iLadderEnt) break
		}
		if (iVec < 0)
		{
			set_pev(iLadderEnt, pev_solid, solidType)
			continue
		}
		
		get_tr2(0, TR_vecPlaneNormal, normal)
		
		if (normal[2] == 0.0)
		{
			start[0] = origin[0]
			start[1] = origin[1]
			start[2] = absMin[2]
			end[0] = origin[0]
			end[1] = origin[1]
			end[2] = absMax[2]
		}
		else
		{
			VectorAngle(normal, normal)
			normal[0] *= -1.0
			AngleVector(normal, ANGLEVECTOR_UP, normal)
			VecAddScaled(origin, normal, 72.0, end)
			VecSubScaled(origin, normal, (origin[2] - absMin[2]) / normal[2], start)
			VecAddScaled(origin, normal, (absMax[2] - origin[2]) / normal[2], end)
		}
		SendMsg_BeamPoints(id, start, end, gMdlId_BeamNode, 50, 10, 0, 255, 0, 255)
		
		set_pev(iLadderEnt, pev_solid, solidType)
	}
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST6", ladderNums)
}

NavSysMenu_Test7(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST7_NAME")
	
	new Float:origin[3]
	pev(id, pev_origin, origin)
	
	new Float:absMin[3], Float:absMax[3]
	if (NavBox_Exist(origin))
	{
		NavBox_GetContain(origin, absMin, absMax)
		NavBox_Draw(id, absMin, absMax, 50, 10, 0, 255, 0, 255)
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST7_DRAW_CONTAIN")
	}
	else
	{
		NavBox_GetNearest(origin, absMin, absMax)
		NavBox_Draw(id, absMin, absMax, 50, 10, 0, 255, 0, 0)
		NavBox_Draw(id, gMapAbsMin, gMapAbsMax, 50, 10, 0, 255, 0, 0)
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST7_DRAW_NEAREST")
	}
}

NavSysMenu_Test8(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST8_NAME")
	
	if (ArraySize(gArray_NodeDucking) == 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "NODE_NOT_FOUND")
		return
	}
	
	new Float:origin[3]
	pev(id, pev_origin, origin)
	
	new Float:absMin[3], Float:absMax[3]
	if (NavBox_Exist(origin))
	{
		NavBox_GetContain(origin, absMin, absMax)
		NavBox_Draw(id, absMin, absMax, 50, 10, 0, 16, 16, 16)
		new iNode, Array:arrayNode = NavBox_GetNodeArray(origin)
		for (new i = ArraySize(arrayNode) - 1; 0 <= i; i--)
		{
			iNode = ArrayGetCell(arrayNode, i)
			NavNode_DrawMesh(id, iNode, false, 50, 10, 0, 128, 0, 128)
		}
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST8_DRAW_CONTAIN", ArraySize(arrayNode))
	}
	else
	{
		NavBox_GetNearest(origin, absMin, absMax)
		NavBox_Draw(id, absMin, absMax, 50, 10, 0, 16, 16, 16)
		new iNode, Array:arrayNode = NavBox_GetNodeArray(absMin)
		for (new i = ArraySize(arrayNode) - 1; 0 <= i; i--)
		{
			iNode = ArrayGetCell(arrayNode, i)
			NavNode_DrawMesh(id, iNode, false, 50, 10, 0, 128, 0, 0)
		}
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST8_DRAW_NEAREST", ArraySize(arrayNode))
	}
}

NavSysMenu_Test9(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST9_NAME")
	
	if (ArraySize(gArray_NodeDucking) == 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "NODE_NOT_FOUND")
		return
	}
	
	new Float:origin[3]
	pev(id, pev_origin, origin)
	
	new timeLeft = tickcount()
	new iNode = NavBox_GetNode(origin)
	timeLeft = tickcount() - timeLeft
	
	NavNode_DrawMesh(id, iNode, false, 50, 10, 0, 255, 0, 255)
	
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST9", iNode, timeLeft)
}

NavSysMenu_Test10(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST10_NAME")
	
	if (ArraySize(gArray_NodeDucking) == 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "NODE_NOT_FOUND")
		return
	}
	
	new Float:origin[3]
	pev(id, pev_origin, origin)
	
	new timeLeft = tickcount()
	new iNode = NavBox_GetNodeNearest(origin)
	timeLeft = tickcount() - timeLeft
	
	NavNode_DrawMesh(id, iNode, false, 50, 10, 0, 255, 0, 255)
	
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST10", iNode, timeLeft)
}

NavSysMenu_Test11(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST11_NAME")
	
	if (ArraySize(gArray_NodeDucking) == 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "NODE_NOT_FOUND")
		return
	}
	
	new Float:origin[3]
	pev(id, pev_origin, origin)
	
	if (NavBox_Exist(origin))
	{
		new timeLeft = tickcount()
		new iNode = NavBox_GetNodeContain(origin)
		timeLeft = tickcount() - timeLeft
		
		if (iNode < 0) client_print(id, print_chat, "%L", LANG_SERVER, "TEST11_FAILED")
		else
		{
			NavNode_DrawMesh(id, iNode, false, 50, 10, 0, 255, 0, 255)
			
			client_print(id, print_chat, "%L", LANG_SERVER, "TEST11", iNode, timeLeft)
		}
	}
	else client_print(id, print_chat, "%L", LANG_SERVER, "TEST11_FAILED")
}

NavSysMenu_Test12(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST12_NAME")
	
	if (ArraySize(gArray_NodeDucking) == 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "NODE_NOT_FOUND")
		return
	}
	
	new Float:origin[3]
	pev(id, pev_origin, origin)
	
	if (NavBox_Exist(origin))
	{
		new Float:absMin[3], Float:absMax[3]
		pev(id, pev_mins, absMin)
		pev(id, pev_maxs, absMax)
		VecAdd(origin, absMin, absMin)
		VecAdd(origin, absMax, absMax)
		
		new timeLeft = tickcount()
		new iNode = NavBox_GetNodeIntersect(absMin, absMax)
		timeLeft = tickcount() - timeLeft
		
		if (iNode < 0) client_print(id, print_chat, "%L", LANG_SERVER, "TEST12_FAILED")
		else
		{
			NavNode_DrawMesh(id, iNode, false, 50, 10, 0, 255, 0, 255)
			
			client_print(id, print_chat, "%L", LANG_SERVER, "TEST12", iNode, timeLeft)
		}
	}
	else client_print(id, print_chat, "%L", LANG_SERVER, "TEST12_FAILED")
}

NavSysMenu_Test13(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST13_NAME")
	
	if (!ArraySize(gArray_Selected))
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST13_FAILED")
		return
	}
	
	new iNode
	for (new i = ArraySize(gArray_Selected) - 1; 0 <= i; i--)
	{
		iNode = ArrayGetCell(gArray_Selected, i)
		
		NavNode_DrawBox(id, iNode, 50, 10, 0, 255, 0, 255)
	}
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST13", ArraySize(gArray_Selected))
}

NavSysMenu_Test14(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST14_NAME")
	
	if (ArraySize(gArray_NodeDucking) == 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "NODE_NOT_FOUND")
		return
	}
	
	new Float:origin[3]
	pev(id, pev_origin, origin)
	
	new timeLeft = tickcount()
	new iNode = NavNode_GetNearest(origin)
	timeLeft = tickcount() - timeLeft
	
	NavNode_DrawMesh(id, iNode, false, 50, 10, 0, 255, 0, 255)
	
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST14", iNode, timeLeft)
}

NavSysMenu_Test15(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST15_NAME")
	
	if (ArraySize(gArray_Selected) != 2)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST15_FAILED1")
		return
	}
	
	new iNodeStart = ArrayGetCell(gArray_Selected, 0)
	new iNodeEnd = ArrayGetCell(gArray_Selected, 1)
	
	new Array:arrayEnd = ArrayGetCell(gArray_NodeEnd, iNodeStart)
	new iPath
	for (iPath = ArraySize(arrayEnd) - 1; 0 <= iPath && ArrayGetCell(arrayEnd, iPath) != iNodeEnd; iPath--) { }
	
	if (iPath < 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST15_FAILED2", iNodeStart, iNodeEnd)
		return
	}
	
	new Float:start[3], Float:mid[3], Float:end[3]
	NavNode_GetPathCoord(iNodeStart, iNodeEnd, iPath, start, mid, end)
	
	SendMsg_BeamPoints(id, start, mid, gMdlId_BeamNode, 50, 10, 0, 192, 0, 0)
	SendMsg_BeamPoints(id, mid, end, gMdlId_BeamNode, 50, 10, 0, 0, 0, 192)
	
	if (ArrayGetCell(gArray_NodeDucking, iNodeStart)) { start[2] -= 12.0; mid[2] -= 12.0; }
	else { start[2] -= 30.0; mid[2] -= 30.0; }
	end[2] -= ArrayGetCell(gArray_NodeDucking, iNodeEnd) ? 12.0 : 30.0
	
	SendMsg_BeamPoints(id, start, mid, gMdlId_BeamPath1, 50, 20, 0, 255, 0, 0)
	SendMsg_BeamPoints(id, mid, end, gMdlId_BeamPath1, 50, 20, 0, 0, 0, 255)
	
	NavNode_DrawBox(id, iNodeStart, 50, 10, 0, 16, 16, 16)
	NavNode_DrawBox(id, iNodeEnd, 50, 10, 0, 16, 16, 16)
	
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST15", iNodeStart, iNodeEnd)
}

NavSysMenu_Test16(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST16_NAME")
	
	if (ArraySize(gArray_Selected) != 2)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST16_FAILED1")
		return
	}
	
	new iNodeStart = ArrayGetCell(gArray_Selected, 0)
	new iNodeEnd = ArrayGetCell(gArray_Selected, 1)
	
	new Array:arrayEnd = ArrayGetCell(gArray_NodeEnd, iNodeStart)
	new iPath
	for (iPath = ArraySize(arrayEnd) - 1; 0 <= iPath && ArrayGetCell(arrayEnd, iPath) != iNodeEnd; iPath--) { }
	
	if (iPath < 0)
	{
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST16_FAILED2", iNodeStart, iNodeEnd)
		return
	}
	
	new PathFlags:flags, Float:height, Float:top[3], Float:bottom[3]
	NavNode_GetPathCoord2(iNodeStart, iNodeEnd, iPath, flags, height, top)
	
	bottom[0] = top[0]
	bottom[1] = top[1]
	bottom[2] = top[2] - (ArrayGetCell(gArray_NodeDucking, iNodeEnd) ? 12.0 : 30.0)
	
	SendMsg_BeamPoints(id, top, bottom, gMdlId_BeamNode, 50, 10, 0, 255, 0, 255)
	
	NavNode_DrawBox(id, iNodeStart, 50, 10, 0, 16, 16, 16)
	NavNode_DrawBox(id, iNodeEnd, 50, 10, 0, 16, 16, 16)
	
	if (flags == PF_Walk)		client_print(id, print_chat, "%L", LANG_SERVER, "TEST16_WALK", height)
	else if (flags == PF_CrouchRun)	client_print(id, print_chat, "%L", LANG_SERVER, "TEST16_CROHCURUN", height)
	else if (flags == PF_Climb)	client_print(id, print_chat, "%L", LANG_SERVER, "TEST16_CLIMb", height)
	else 				client_print(id, print_chat, "%L", LANG_SERVER, "TEST16_CROUCHCLIMB", height)
	
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST16", iNodeStart, iNodeEnd)
}

NavSysMenu_Test17(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST17_NAME")
	
	new bool:duckingStart, Float:start[3], Float:goal[3]
	new bool:duckingEnd, Float:end[3], Float:normal[3]
	new bool:crouchRun, Float:height
	
	duckingStart = pev(id, pev_flags) & FL_DUCKING ? true : false
	pev(id, pev_origin, start)
	pev(id, pev_v_angle, goal)
	goal[0] = start[0] + floatcos(goal[1], degrees) * 32.0
	goal[1] = start[1] + floatsin(goal[1], degrees) * 32.0
	
	if (NavPath_Exist(duckingStart, start, goal, duckingEnd, end, normal, crouchRun, height))
	{
		start[2] -= duckingStart ? 18.0 : 36.0
		end[2] -= duckingEnd ? 18.0 : 36.0
		SendMsg_BeamPoints(id, start, end, gMdlId_BeamPath1, 50, 10, 0, 255, 0, 255)
		
		client_print(id, print_chat, "%L", LANG_SERVER, duckingEnd ? "TEST17_END_STATE2" : "TEST17_END_STATE1")
		client_print(id, print_chat, "%L", LANG_SERVER, crouchRun ? "TEST17_CROUCHRUN2" : "TEST17_CROUCHRUN1")
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST17_HEIGHT", height)
		
		return
	}
	
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST17_FAILED")
}


NavSysMenu_Test18(id)
{
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST18_NAME")
	
	new bool:duckingStart, Float:start[3], Float:goal[3]
	new bool:duckingEnd, Float:end[3], Float:normal[3]
	new bool:crouchRun, Float:height
	
	duckingStart = pev(id, pev_flags) & FL_DUCKING ? true : false
	pev(id, pev_origin, start)
	pev(id, pev_v_angle, goal)
	goal[0] = start[0] + floatcos(goal[1], degrees) * 32.0
	goal[1] = start[1] + floatsin(goal[1], degrees) * 32.0
	
	if (NavPath_Exist2(duckingStart, start, goal, duckingEnd, end, normal, crouchRun, height))
	{
		start[2] -= duckingStart ? 18.0 : 36.0
		end[2] -= duckingEnd ? 18.0 : 36.0
		SendMsg_BeamPoints(id, start, end, gMdlId_BeamPath1, 50, 10, 0, 255, 0, 255)
		
		client_print(id, print_chat, "%L", LANG_SERVER, duckingEnd ? "TEST18_END_STATE2" : "TEST18_END_STATE1")
		client_print(id, print_chat, "%L", LANG_SERVER, crouchRun ? "TEST18_CROUCHRUN2" : "TEST18_CROUCHRUN1")
		client_print(id, print_chat, "%L", LANG_SERVER, "TEST18_HEIGHT", height)
		
		return
	}
	
	client_print(id, print_chat, "%L", LANG_SERVER, "TEST18_FAILED")
}
NavBox_Draw(id, const Float:absMin[3], const Float:absMax[3], life, width, noise, r, g, b)
{
	new Float:point[8][3]
	point[0][0] = absMax[0]
	point[0][1] = absMax[1]
	point[0][2] = absMax[2]
	point[1][0] = absMin[0]
	point[1][1] = absMax[1]
	point[1][2] = absMax[2]
	point[2][0] = absMin[0]
	point[2][1] = absMin[1]
	point[2][2] = absMax[2]
	point[3][0] = absMax[0]
	point[3][1] = absMin[1]
	point[3][2] = absMax[2]
	point[4][0] = absMax[0]
	point[4][1] = absMax[1]
	point[4][2] = absMin[2]
	point[5][0] = absMin[0]
	point[5][1] = absMax[1]
	point[5][2] = absMin[2]
	point[6][0] = absMin[0]
	point[6][1] = absMin[1]
	point[6][2] = absMin[2]
	point[7][0] = absMax[0]
	point[7][1] = absMin[1]
	point[7][2] = absMin[2]
	SendMsg_BeamPoints(id, point[0], point[1], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, point[1], point[2], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, point[2], point[3], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, point[3], point[0], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, point[4], point[5], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, point[5], point[6], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, point[6], point[7], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, point[7], point[4], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, point[0], point[4], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, point[1], point[5], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, point[2], point[6], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, point[3], point[7], gMdlId_BeamNode, life, width, noise, r, g, b)
}

bool:NavBox_Exist(const Float:origin[3])
{
	return	(gMapAbsMin[0] <= origin[0] < gMapAbsMax[0]) &&
		(gMapAbsMin[1] <= origin[1] < gMapAbsMax[1]) &&
		(gMapAbsMin[2] <= origin[2] < gMapAbsMax[2])
}

NavBox_AddNode(nodeIndex)
{
	/** 以下代码:将导航点分配到有所接触的盒子 */
	new Float:absMin[3], Float:absMax[3], Float:boxAbsMin[3], Float:boxAbsMax[3], Float:nodePoint[3]
	ArrayGetArray(gArray_NodeAbsMin, nodeIndex, absMin)
	ArrayGetArray(gArray_NodeAbsMax, nodeIndex, absMax)
	
	new bool:boxExist = true
	for (new i; i < 3; i++)
	{
		boxAbsMin[i] = 128.0 * floatround(absMin[i] / 128.0, floatround_floor)
		boxAbsMax[i] = 128.0 * floatround(absMax[i] / 128.0, floatround_ceil)
		if (boxAbsMin[i] < gMapAbsMin[i] || gMapAbsMax[i] < boxAbsMax[i]) boxExist = false
	}
	
	if (boxExist)
	{
		// 节点最多能接触8个盒子
		for (nodePoint[2] = boxAbsMin[2]; nodePoint[2] < boxAbsMax[2]; nodePoint[2] += 128.0)
		{
			for (nodePoint[1] = boxAbsMin[1]; nodePoint[1] < boxAbsMax[1]; nodePoint[1] += 128.0)
			{
				for (nodePoint[0] = boxAbsMin[0]; nodePoint[0] < boxAbsMax[0]; nodePoint[0] += 128.0)
				{
					ArrayPushCell(NavBox_GetNodeArray(nodePoint), nodeIndex)
				}
			}
		}
		return
	}
	/** 以上代码:将导航点分配到有所接触的盒子 */
	
	/** 以下代码:销毁所有盒子 */
	new x, y, z, Array:arrayYBox, Array:arrayZBox, Array:arrayBox
	if (gArray_XBox != Invalid_Array)
	{
		for (x = ArraySize(gArray_XBox) - 1; 0 <= x; x--)
		{
			arrayYBox = ArrayGetCell(gArray_XBox, x)
			for (y = ArraySize(arrayYBox) - 1; 0 <= y; y--)
			{
				arrayZBox = ArrayGetCell(arrayYBox, y)
				for (z = ArraySize(arrayZBox) - 1; 0 <= z; z--)
				{
					arrayBox = ArrayGetCell(arrayZBox, z)
					ArrayDestroy(arrayBox)
				}
				ArrayDestroy(arrayZBox)
			}
			ArrayDestroy(arrayYBox)
		}
		ArrayDestroy(gArray_XBox)
	}
	/** 以上代码:销毁所有盒子 */
	
	/** 以下代码:更新地图盒子尺寸,计算各轴盒子数量 */
	new boxNums[3]
	for (new i; i < 3; i++)
	{
		if (gMapAbsMin[i] == gMapAbsMax[i])
		{
			gMapAbsMin[i] = boxAbsMin[i]
			gMapAbsMax[i] = boxAbsMax[i]
		}
		else
		{
			if (boxAbsMin[i] < gMapAbsMin[i]) gMapAbsMin[i] = boxAbsMin[i]
			if (gMapAbsMax[i] < boxAbsMax[i]) gMapAbsMax[i] = boxAbsMax[i]
		}
		
		boxNums[i] = floatround((gMapAbsMax[i] - gMapAbsMin[i]) / 128.0)
	}
	/** 以上代码:更新地图盒子尺寸,计算各轴盒子数量 */
	
	/** 以下代码:重新创建盒子 */
	gArray_XBox = ArrayCreate(1, boxNums[0])
	for (x = 0; x < boxNums[0]; x++)
	{
		arrayYBox = ArrayCreate(1, boxNums[1])
		for (y = 0; y < boxNums[1]; y++)
		{
			arrayZBox = ArrayCreate(1, boxNums[2])
			for (z = 0; z < boxNums[2]; z++) ArrayPushCell(arrayZBox, ArrayCreate())
			ArrayPushCell(arrayYBox, arrayZBox)
		}
		ArrayPushCell(gArray_XBox, arrayYBox)
	}
	/** 以上代码:重新创建盒子 */
	
	/** 以下代码:将所有导航点分配到有所接触的盒子内 */
	for (new i = ArraySize(gArray_NodeAbsMin) - 1; 0 <= i; i--)
	{
		ArrayGetArray(gArray_NodeAbsMin, i, absMin)
		ArrayGetArray(gArray_NodeAbsMax, i, absMax)
		for (new j; j < 3; j++)
		{
			boxAbsMin[j] = 128.0 * floatround(absMin[j] / 128.0, floatround_floor)
			boxAbsMax[j] = 128.0 * floatround(absMax[j] / 128.0, floatround_ceil)
		}
		// 每个节点最多能接触8个盒子
		for (nodePoint[2] = boxAbsMin[2]; nodePoint[2] < boxAbsMax[2]; nodePoint[2] += 128.0)
		{
			for (nodePoint[1] = boxAbsMin[1]; nodePoint[1] < boxAbsMax[1]; nodePoint[1] += 128.0)
			{
				for (nodePoint[0] = boxAbsMin[0]; nodePoint[0] < boxAbsMax[0]; nodePoint[0] += 128.0)
				{
					ArrayPushCell(NavBox_GetNodeArray(nodePoint), i)
				}
			}
		}
	}
	/** 以上代码:将所有导航点分配到有所接触的盒子内 */
}

NavBox_Update()
{
	/** 以下代码:销毁所有盒子 */
	new x, y, z, Array:arrayYBox, Array:arrayZBox, Array:arrayBox
	if (gArray_XBox != Invalid_Array)
	{
		for (x = ArraySize(gArray_XBox) - 1; 0 <= x; x--)
		{
			arrayYBox = ArrayGetCell(gArray_XBox, x)
			for (y = ArraySize(arrayYBox) - 1; 0 <= y; y--)
			{
				arrayZBox = ArrayGetCell(arrayYBox, y)
				for (z = ArraySize(arrayZBox) - 1; 0 <= z; z--)
				{
					arrayBox = ArrayGetCell(arrayZBox, z)
					ArrayDestroy(arrayBox)
				}
				ArrayDestroy(arrayZBox)
			}
			ArrayDestroy(arrayYBox)
		}
		ArrayDestroy(gArray_XBox)
	}
	/** 以上代码:销毁所有盒子 */
	
	/** 以下代码:更新地图盒子尺寸,计算各轴盒子数量 */
	new i, j, boxNums[3], Float:absMin[3], Float:absMax[3], Float:boxAbsMin[3], Float:boxAbsMax[3]
	gMapAbsMin = boxAbsMin
	gMapAbsMax = boxAbsMin
	for (i = ArraySize(gArray_NodePoint) - 1; 0 <= i; i--)
	{
		ArrayGetArray(gArray_NodeAbsMin, i, absMin)
		ArrayGetArray(gArray_NodeAbsMax, i, absMax)
	
		for (j = 0; j < 3; j++)
		{
			boxAbsMin[j] = 128.0 * floatround(absMin[j] / 128.0, floatround_floor)
			boxAbsMax[j] = 128.0 * floatround(absMax[j] / 128.0, floatround_ceil)
			
			if (gMapAbsMin[j] == gMapAbsMax[j])
			{
				gMapAbsMin[j] = boxAbsMin[j]
				gMapAbsMax[j] = boxAbsMax[j]
			}
			else
			{
				if (boxAbsMin[j] < gMapAbsMin[j]) gMapAbsMin[j] = boxAbsMin[j]
				if (gMapAbsMax[j] < boxAbsMax[j]) gMapAbsMax[j] = boxAbsMax[j]
			}
			
			boxNums[j] = floatround((gMapAbsMax[j] - gMapAbsMin[j]) / 128.0)
		}
	}
	/** 以上代码:更新地图盒子尺寸,计算各轴盒子数量 */
	
	if (boxNums[0] == 0) return
	
	/** 以下代码:重新创建盒子 */
	gArray_XBox = ArrayCreate(1, boxNums[0])
	for (x = 0; x < boxNums[0]; x++)
	{
		arrayYBox = ArrayCreate(1, boxNums[1])
		for (y = 0; y < boxNums[1]; y++)
		{
			arrayZBox = ArrayCreate(1, boxNums[2])
			for (z = 0; z < boxNums[2]; z++) ArrayPushCell(arrayZBox, ArrayCreate())
			ArrayPushCell(arrayYBox, arrayZBox)
		}
		ArrayPushCell(gArray_XBox, arrayYBox)
	}
	/** 以上代码:重新创建盒子 */
	
	/** 以下代码:将所有导航点分配到有所接触的盒子内 */
	new Float:nodePoint[3]
	for (i = ArraySize(gArray_NodeAbsMin) - 1; 0 <= i; i--)
	{
		ArrayGetArray(gArray_NodePoint, i, absMin)
		ArrayGetArray(gArray_NodeAbsMin, i, absMin)
		ArrayGetArray(gArray_NodeAbsMax, i, absMax)
		for (j = 0; j < 3; j++)
		{
			boxAbsMin[j] = 128.0 * floatround(absMin[j] / 128.0, floatround_floor)
			boxAbsMax[j] = 128.0 * floatround(absMax[j] / 128.0, floatround_ceil)
		}
		// 每个节点最多能接触8个盒子
		for (nodePoint[2] = boxAbsMin[2]; nodePoint[2] < boxAbsMax[2]; nodePoint[2] += 128.0)
		{
			for (nodePoint[1] = boxAbsMin[1]; nodePoint[1] < boxAbsMax[1]; nodePoint[1] += 128.0)
			{
				for (nodePoint[0] = boxAbsMin[0]; nodePoint[0] < boxAbsMax[0]; nodePoint[0] += 128.0)
				{
					ArrayPushCell(NavBox_GetNodeArray(nodePoint), i)
				}
			}
		}
	}
	/** 以上代码:将所有导航点分配到有所接触的盒子内 */
}

Array:NavBox_GetNodeArray(const Float:origin[3])
{
	new xId = floatround((origin[0] - gMapAbsMin[0]) / 128.0, floatround_floor)
	new yId = floatround((origin[1] - gMapAbsMin[1]) / 128.0, floatround_floor)
	new zId = floatround((origin[2] - gMapAbsMin[2]) / 128.0, floatround_floor)
	return ArrayGetCell(ArrayGetCell(ArrayGetCell(gArray_XBox, xId), yId), zId)
}

NavBox_GetContain(const Float:origin[3], Float:absMin[3], Float:absMax[3])
{
	for (new i; i < 3; i++)
	{
		absMin[i] = 128.0 * floatround(origin[i] / 128.0, floatround_floor)
		absMax[i] = absMin[i] + 128.0
	}
}

NavBox_GetNearest(const Float:origin[3], Float:absMin[3], Float:absMax[3])
{
	for (new i; i < 3; i++)
	{
		if (origin[i] < gMapAbsMin[i])
		{
			absMin[i] = gMapAbsMin[i]
			absMax[i] = gMapAbsMax[i] + 128.0
		}
		else if (gMapAbsMax[i] <= origin[i])
		{
			absMin[i] = gMapAbsMax[i] - 128.0
			absMax[i] = gMapAbsMax[i]
		}
		else
		{
			absMin[i] = 128.0 * floatround(origin[i] / 128.0, floatround_floor)
			absMax[i] = absMin[i] + 128.0
		}
	}
}

NavBox_GetNode(const Float:origin[3])
{
	new iNodeSelect = NavBox_GetNodeNearest(origin)
	if (0 <= iNodeSelect)
	{
		new bool:ducking, Float:point[3], Float:absMin[3], Float:absMax[3], Float:normal[3]
		ducking = ArrayGetCell(gArray_NodeDucking, iNodeSelect)
		ArrayGetArray(gArray_NodePoint, iNodeSelect, point)
		ArrayGetArray(gArray_NodeAbsMin, iNodeSelect, absMin)
		ArrayGetArray(gArray_NodeAbsMax, iNodeSelect, absMax)
		ArrayGetArray(gArray_NodeNormal, iNodeSelect, normal)
		absMin[2] = InclinedPlaneZ(point, normal, origin) - (ducking ? 18.0 : 36.0)
		absMax[2] = absMin[2] + (ducking ? 36.0 : 72.0)
		point[2] = (absMin[2] + absMax[2]) * 0.5
		new Float:dist1 = (point[2] - origin[2]) * (point[2] - origin[2])
		new Float:dist2
		new Float:vecDist[3]
		new Float:lastDist
		new iNodeSelect2 = -1
		
		new Array:arrayStart = ArrayGetCell(gArray_NodeStart, iNodeSelect)
		new Array:arrayEnd, Array:arrayHeight
		new i, j, k, iNodeStart
		for (i = ArraySize(arrayStart) - 1; 0 <= i; i--)
		{
			iNodeStart = ArrayGetCell(arrayStart, i)
			arrayEnd = ArrayGetCell(gArray_NodeEnd, iNodeStart)
			arrayHeight = ArrayGetCell(gArray_NodeHeight, iNodeStart)
			for (j = ArraySize(arrayEnd) - 1; 0 <= j; j--)
			{
				if (ArrayGetCell(arrayEnd, j) == iNodeSelect)
				{
					if (0.0 < Float:ArrayGetCell(arrayHeight, j))
					{
						ducking = ArrayGetCell(gArray_NodeDucking, iNodeStart)
						ArrayGetArray(gArray_NodePoint, iNodeStart, point)
						ArrayGetArray(gArray_NodeAbsMin, iNodeStart, absMin)
						ArrayGetArray(gArray_NodeAbsMax, iNodeStart, absMax)
						ArrayGetArray(gArray_NodeNormal, iNodeStart, normal)
						absMin[2] = InclinedPlaneZ(point, normal, origin) - (ducking ? 18.0 : 36.0)
						absMax[2] = absMin[2] + (ducking ? 36.0 : 72.0)
						point[2] = (absMin[2] + absMax[2]) * 0.5
						dist2 = (point[2] - origin[2]) * (point[2] - origin[2])
						if (dist2 <= dist1)
						{
							for (k = 0; k < 3; k++)
							{
								if (absMax[k] < origin[k])	vecDist[k] = origin[k] - absMax[k]
								else if (origin[k] < absMin[k])	vecDist[k] = absMin[k] - origin[k]
								else				vecDist[k] = 0.0
							}
							
							dist2 =	(vecDist[0]) * (vecDist[0]) +
								(vecDist[1]) * (vecDist[1]) +
								(vecDist[2]) * (vecDist[2])
							
							if (dist2 < lastDist || iNodeSelect2 < 0) { lastDist = dist2; iNodeSelect2 = iNodeStart; }
						}
					}
					break
				}
			}
		}
		if (0 <= iNodeSelect2) return iNodeSelect2
	}
	return iNodeSelect
}

NavBox_GetNodeNearest(const Float:origin[3])
{
	if (!ArraySize(gArray_NodeDucking)) return -1
	
	new i, Float:point[3]
	for (; i < 3; i++)
	{
		if (origin[i] < gMapAbsMin[i])		point[i] = gMapAbsMin[i]
		else if (gMapAbsMax[i] <= origin[i])	point[i] = gMapAbsMax[i] - 128.0
		else					point[i] = 128.0 * floatround(origin[i] / 128.0, floatround_floor)
	}
	
	new iNodeSelect = _GetNodeNearest(NavBox_GetNodeArray(point), origin)
	if (0 <= iNodeSelect) return iNodeSelect
	
	new bool:boxExist = true
	new Float:boxCoord[3], Float:boxAbsMin[3], Float:boxAbsMax[3]
	new iNode, Float:dist, Float:lastDist
	new layers
	for (layers = 1; boxExist; layers++)
	{
		for (i = 0; i < 3; i++)
		{
			boxAbsMin[i] = point[i] - 128.0 * layers
			boxAbsMax[i] = point[i] + 128.0 * layers
		}
		
		boxExist = false
		
		// 底面
		if (gMapAbsMin[2] <= boxAbsMin[2])
		{
			boxCoord[2] = boxAbsMin[2]
			for (boxCoord[1] = boxAbsMin[1] + 128.0; boxCoord[1] < boxAbsMax[1] - 128.0; boxCoord[1] += 128.0)
			{
				if (boxCoord[1] < gMapAbsMin[1]) continue
				if (gMapAbsMax[1] <= boxCoord[1]) break
				
				for (boxCoord[0] = boxAbsMin[0] + 128.0; boxCoord[0] < boxAbsMax[0] - 128.0; boxCoord[0] += 128.0)
				{
					if (boxCoord[0] < gMapAbsMin[0]) continue
					if (gMapAbsMax[0] <= boxCoord[0]) break
					
					boxExist = true
					
					iNode = _GetNodeNearest2(NavBox_GetNodeArray(boxCoord), origin, dist)
					
					if (0 <= iNode && (dist < lastDist || iNodeSelect < 0)) { lastDist = dist; iNodeSelect = iNode; }
				}
			}
		}
		// 顶面
		if (boxAbsMax[2] < gMapAbsMax[2])
		{
			boxCoord[2] = boxAbsMax[2]
			for (boxCoord[1] = boxAbsMin[1] + 128.0; boxCoord[1] < boxAbsMax[1] - 128.0; boxCoord[1] += 128.0)
			{
				if (boxCoord[1] < gMapAbsMin[1]) continue
				if (gMapAbsMax[1] <= boxCoord[1]) break
				
				for (boxCoord[0] = boxAbsMin[0] + 128.0; boxCoord[0] < boxAbsMax[0] - 128.0; boxCoord[0] += 128.0)
				{
					if (boxCoord[0] < gMapAbsMin[0]) continue
					if (gMapAbsMax[0] <= boxCoord[0]) break
					
					boxExist = true
					
					iNode = _GetNodeNearest2(NavBox_GetNodeArray(boxCoord), origin, dist)
					
					if (0 <= iNode && (dist < lastDist || iNodeSelect < 0)) { lastDist = dist; iNodeSelect = iNode; }
				}
			}
		}
		// 南面
		if (gMapAbsMin[1] <= boxAbsMin[1])
		{
			boxCoord[1] = boxAbsMin[1]
			for (boxCoord[2] = boxAbsMin[2]; boxCoord[2] < boxAbsMax[2]; boxCoord[2] += 128.0)
			{
				if (boxCoord[2] < gMapAbsMin[2]) continue
				if (gMapAbsMax[2] <= boxCoord[2]) break
				
				for (boxCoord[0] = boxAbsMin[0]; boxCoord[0] < boxAbsMax[0] - 128.0; boxCoord[0] += 128.0)
				{
					if (boxCoord[0] < gMapAbsMin[0]) continue
					if (gMapAbsMax[0] <= boxCoord[0]) break
					
					boxExist = true
					
					iNode = _GetNodeNearest2(NavBox_GetNodeArray(boxCoord), origin, dist)
					
					if (0 <= iNode && (dist < lastDist || iNodeSelect < 0)) { lastDist = dist; iNodeSelect = iNode; }
				}
			}
		}
		// 北面
		if (boxAbsMax[1] < gMapAbsMax[1])
		{
			boxCoord[1] = boxAbsMax[1]
			for (boxCoord[2] = boxAbsMin[2]; boxCoord[2] < boxAbsMax[2]; boxCoord[2] += 128.0)
			{
				if (boxCoord[2] < gMapAbsMin[2]) continue
				if (gMapAbsMax[2] <= boxCoord[2]) break
				
				for (boxCoord[0] = boxAbsMax[0] - 128.0; boxAbsMin[0] < boxCoord[0]; boxCoord[0] -= 128.0)
				{
					if (boxCoord[0] < gMapAbsMin[0]) continue
					if (gMapAbsMax[0] <= boxCoord[0]) break
					
					boxExist = true
					
					iNode = _GetNodeNearest2(NavBox_GetNodeArray(boxCoord), origin, dist)
					
					if (0 <= iNode && (dist < lastDist || iNodeSelect < 0)) { lastDist = dist; iNodeSelect = iNode; }
				}
			}
		}
		// 西面
		if (gMapAbsMin[0] <= boxAbsMin[0])
		{
			boxCoord[0] = boxAbsMin[0]
			for (boxCoord[2] = boxAbsMin[2]; boxCoord[2] < boxAbsMax[2]; boxCoord[2] += 128.0)
			{
				if (boxCoord[2] < gMapAbsMin[2]) continue
				if (gMapAbsMax[2] <= boxCoord[2]) break
				
				for (boxCoord[1] = boxAbsMax[1] - 128.0; boxAbsMin[1] < boxCoord[1]; boxCoord[1] -= 128.0)
				{
					if (boxCoord[1] < gMapAbsMin[1]) continue
					if (gMapAbsMax[1] <= boxCoord[1]) break
					
					boxExist = true
					
					iNode = _GetNodeNearest2(NavBox_GetNodeArray(boxCoord), origin, dist)
					
					if (0 <= iNode && (dist < lastDist || iNodeSelect < 0)) { lastDist = dist; iNodeSelect = iNode; }
				}
			}
		}
		// 东面
		if (boxAbsMax[0] < gMapAbsMax[0])
		{
			boxCoord[0] = boxAbsMax[0]
			for (boxCoord[2] = boxAbsMin[2]; boxCoord[2] < boxAbsMax[2]; boxCoord[2] += 128.0)
			{
				if (boxCoord[2] < gMapAbsMin[2]) continue
				if (gMapAbsMax[2] <= boxCoord[2]) break
				
				for (boxCoord[1] = boxAbsMin[1]; boxCoord[1] < boxAbsMax[1] - 128.0; boxCoord[1] += 128.0)
				{
					if (boxCoord[1] < gMapAbsMin[1]) continue
					if (gMapAbsMax[1] <= boxCoord[1]) break
					
					boxExist = true
					
					iNode = _GetNodeNearest2(NavBox_GetNodeArray(boxCoord), origin, dist)
					
					if (0 <= iNode && (dist < lastDist || iNodeSelect < 0)) { lastDist = dist; iNodeSelect = iNode; }
				}
			}
		}
		if (0 <= iNodeSelect) return iNodeSelect
	}
	
	return -1
}

_GetNodeNearest(Array:arrayNode, const Float:origin[3])
{
	new j, iNode, iNodeSelect = -1
	new bool:bContain
	new Float:dist, Float:lastDist, Float:bottom, Float:height, Float:vecDist[3], Float:vecDest[3]
	new bool:ducking, Float:point[3], Float:absMin[3], Float:absMax[3], Float:normal[3]
	for (new i = ArraySize(arrayNode) - 1; 0 <= i; i--)
	{
		iNode = ArrayGetCell(arrayNode, i)
		
		ducking = ArrayGetCell(gArray_NodeDucking, iNode)
		ArrayGetArray(gArray_NodePoint, iNode, point)
		ArrayGetArray(gArray_NodeAbsMin, iNode, absMin)
		ArrayGetArray(gArray_NodeAbsMax, iNode, absMax)
		ArrayGetArray(gArray_NodeNormal, iNode, normal)
		
		for (j = 0; j < 2; j++)
		{
			if (origin[j] < absMin[j])	{ vecDist[j] = absMin[j] - origin[j];	vecDest[j] = absMin[j]; }
			else if (absMax[j] < origin[j])	{ vecDist[j] = origin[j] - absMax[j];	vecDest[j] = absMax[j]; }
			else				{ vecDist[j] = 0.0;			vecDest[j] = origin[j]; }
		}
		
		point[2] -= ducking ? 18.0 : 36.0
		bottom = InclinedPlaneZ(point, normal, vecDest)
		height = bottom + (ducking ? 36.0 : 72.0)
		if (origin[2] < bottom)		vecDist[2] = bottom - origin[2]
		else if (height < origin[2])	vecDist[2] = origin[2] - height
		else				vecDist[2] = 0.0
		
		if (vecDist[0] == 0.0 && vecDist[1] == 0.0 && vecDist[2] == 0.0)
		{
			dist = ((height + bottom) * 0.5 - origin[2]) * ((height + bottom) * 0.5 - origin[2])
			if (dist < lastDist || !bContain) { lastDist = dist; bContain = true; iNodeSelect = iNode; }
			continue
		}
		if (bContain) continue
		
		dist =	(vecDist[0]) * (vecDist[0]) +
			(vecDist[1]) * (vecDist[1]) +
			(vecDist[2]) * (vecDist[2])
		
		if (dist < lastDist || iNodeSelect < 0) { lastDist = dist; iNodeSelect = iNode; }
	}
	return iNodeSelect
}

_GetNodeNearest2(Array:arrayNode, const Float:origin[3], &Float:distance)
{
	distance = 0.0
	
	new j, iNode, iNodeSelect = -1
	new Float:dist, Float:bottom, Float:height, Float:vecDist[3], Float:vecDest[3]
	new bool:ducking, Float:point[3], Float:absMin[3], Float:absMax[3], Float:normal[3]
	for (new i = ArraySize(arrayNode) - 1; 0 <= i; i--)
	{
		iNode = ArrayGetCell(arrayNode, i)
		
		ducking = ArrayGetCell(gArray_NodeDucking, iNode)
		ArrayGetArray(gArray_NodePoint, iNode, point)
		ArrayGetArray(gArray_NodeAbsMin, iNode, absMin)
		ArrayGetArray(gArray_NodeAbsMax, iNode, absMax)
		ArrayGetArray(gArray_NodeNormal, iNode, normal)
		
		for (j = 0; j < 2; j++)
		{
			if (origin[j] < absMin[j])	{ vecDist[j] = absMin[j] - origin[j];	vecDest[j] = absMin[j]; }
			else if (absMax[j] < origin[j])	{ vecDist[j] = origin[j] - absMax[j];	vecDest[j] = absMax[j]; }
			else				{ vecDist[j] = 0.0;			vecDest[j] = origin[j]; }
		}
		
		point[2] -= ducking ? 18.0 : 36.0
		bottom = InclinedPlaneZ(point, normal, vecDest)
		height = bottom + (ducking ? 36.0 : 72.0)
		if (origin[2] < bottom)		vecDist[2] = bottom - origin[2]
		else if (height < origin[2])	vecDist[2] = origin[2] - height
		else				vecDist[2] = 0.0
		
		dist =	(vecDist[0]) * (vecDist[0]) +
			(vecDist[1]) * (vecDist[1]) +
			(vecDist[2]) * (vecDist[2])
		
		if (dist < distance || iNodeSelect < 0) { distance = dist; iNodeSelect = iNode; }
	}
	return iNodeSelect
}

NavBox_GetNodeContain(const Float:origin[3])
{
	new bool:ducking
	new Float:absMin[3], Float:absMax[3], Float:point[3], Float:normal[3], Float:vecDest[3]
	new iNode, Array:arrayNode = NavBox_GetNodeArray(origin)
	for (new i = ArraySize(arrayNode) - 1; 0 <= i; i--)
	{
		iNode = ArrayGetCell(arrayNode, i)
		ArrayGetArray(gArray_NodeAbsMin, iNode, absMin)
		if (origin[0] < absMin[0]) continue
		if (origin[1] < absMin[1]) continue
		ArrayGetArray(gArray_NodeAbsMax, iNode, absMax)
		if (absMax[0] <= origin[0]) continue
		if (absMax[1] <= origin[1]) continue
		
		ducking = ArrayGetCell(gArray_NodeDucking, iNode)
		ArrayGetArray(gArray_NodePoint, iNode, point)
		ArrayGetArray(gArray_NodeNormal, iNode, normal)
		
		point[2] -= ducking ? 18.0 : 36.0
		vecDest[0] = origin[0]
		vecDest[1] = origin[1]
		vecDest[2] = InclinedPlaneZ(point, normal, vecDest)
		if (origin[2] < vecDest[2]) continue
		vecDest[2] += ducking ? 36.0 : 72.0
		if (vecDest[2] <= origin[2]) continue
		
		return iNode
	}
	return -1
}

NavBox_GetNodeIntersect(const Float:absMin[3], const Float:absMax[3])
{
	new i, Float:center[3], Float:boxAbsMin[3], Float:boxAbsMax[3]
	for (; i < 3; i++)
	{
		boxAbsMin[i] = floatmax(gMapAbsMin[i], 128.0 * floatround(absMin[i] / 128.0, floatround_floor))
		boxAbsMax[i] = floatmin(gMapAbsMax[i], 128.0 * floatround(absMax[i] / 128.0, floatround_ceil))
		center[i] = (absMin[i] + absMax[i]) * 0.5
	}
	
	new j, iNode, iNodeSelect = -1
	new bool:bContain
	new Array:arrayNode
	new Float:dist, Float:lastDist
	new Float:boxCoord[3], Float:vecDist[3]
	new bool:ducking, Float:nodeAbsMin[3], Float:nodeAbsMax[3], Float:nodePoint[3], Float:nodeNormal[3]
	
	for (boxCoord[2] = boxAbsMin[2]; boxCoord[2] < boxAbsMax[2]; boxCoord[2] += 128.0)
	{
		for (boxCoord[1] = boxAbsMin[1]; boxCoord[1] < boxAbsMax[1]; boxCoord[1] += 128.0)
		{
			for (boxCoord[0] = boxAbsMin[0]; boxCoord[0] < boxAbsMax[0]; boxCoord[0] += 128.0)
			{
				if (!NavBox_Exist(boxCoord)) continue
				
				arrayNode = NavBox_GetNodeArray(boxCoord)
				for (i = ArraySize(arrayNode) - 1; 0 <= i; i--)
				{
					iNode = ArrayGetCell(arrayNode, i)
					
					ArrayGetArray(gArray_NodeAbsMin, iNode, nodeAbsMin)
					if (absMax[0] < nodeAbsMin[0]) continue
					if (absMax[1] < nodeAbsMin[1]) continue
					ArrayGetArray(gArray_NodeAbsMax, iNode, nodeAbsMax)
					if (nodeAbsMax[0] <= absMin[0]) continue
					if (nodeAbsMax[1] <= absMin[1]) continue
					
					ducking = ArrayGetCell(gArray_NodeDucking, iNode)
					ArrayGetArray(gArray_NodePoint, iNode, nodePoint)
					ArrayGetArray(gArray_NodeNormal, iNode, nodeNormal)
					
					nodePoint[2] -= ducking ? 18.0 : 36.0
					nodeAbsMin[2] = InclinedPlaneZ(nodePoint, nodeNormal, center)
					nodeAbsMax[2] = nodeAbsMin[2] + (ducking ? 36.0 : 72.0)
					
					if (absMax[2] < nodeAbsMin[2]) continue
					if (nodeAbsMax[2] <= absMin[2]) continue
					
					if (	nodeAbsMin[0] <= center[0] < nodeAbsMax[0] && 
						nodeAbsMin[1] <= center[1] < nodeAbsMax[1] &&
						nodeAbsMin[2] <= center[2] < nodeAbsMax[2] )
					{
						dist = ((nodeAbsMin[2] + nodeAbsMax[2]) * 0.5 - center[2]) * ((nodeAbsMin[2] + nodeAbsMax[2]) * 0.5 - center[2])
						if (dist < lastDist || !bContain) { lastDist = dist; bContain = true; iNodeSelect = iNode; }
						continue
					}
					if (bContain) continue
					
					for (j = 0; j < 3; j++)
					{
						if (nodeAbsMax[j] < absMin[j])		vecDist[j] = absMin[j] - nodeAbsMax[j]
						else if (absMax[j] < nodeAbsMin[j])	vecDist[j] = nodeAbsMin[j] - absMax[j]
						else					vecDist[j] = 0.0
					}
					
					dist =	(vecDist[0]) * (vecDist[0]) +
						(vecDist[1]) * (vecDist[1]) +
						(vecDist[2]) * (vecDist[2])
					
					if (dist < lastDist || iNodeSelect < 0) { lastDist = dist; iNodeSelect = iNode; }
				}
			}
		}
	}
	return iNodeSelect
}

NavBox_GetNodeInFront(id)
{
	if (gArray_XBox == Invalid_Array) return -1
	
	new i, j, loop, Float:rayLength, Float:dist, Float:lastDist = -1.0
	new Float:rayStart[3], Float:rayDir[3], Float:rayEnd[3], Float:lastRayEnd[3], Float:boxAbsMin[3], Float:boxAbsMax[3]
	
	pev(id, pev_origin, rayStart)
	pev(id, pev_view_ofs, rayDir)
	VecAdd(rayStart, rayDir, rayStart)
	pev(id, pev_v_angle, rayDir)
	AngleVector(rayDir, ANGLEVECTOR_FORWARD, rayDir)
	VecAddScaled(rayStart, rayDir, 9999.0, rayEnd)
	NavSys_Trace(rayStart, rayEnd, -1)
	get_tr2(0, TR_vecEndPos, rayEnd)
	
	rayLength = VecDistance(rayStart, rayEnd)
	
	if (NavBox_Exist(rayStart)) NavBox_GetNearest(rayStart, boxAbsMin, boxAbsMax)
	else
	{
		for (i = 0; i < 3; i++)
		{
			if (rayDir[i] == 0.0) continue
			
			if (rayDir[i] < 0.0)
			{
				// 不可能命中世界盒
				if (rayStart[i] <= gMapAbsMin[i]) return -1
				// 不可能命中世界盒
				if (rayStart[i] < gMapAbsMax[i]) continue
				dist = (gMapAbsMax[i] - rayStart[i]) / rayDir[i]
			}
			else
			{
				// 不可能命中世界盒
				if (gMapAbsMax[i] <= rayStart[i]) return -1
				// 不可能命中世界盒
				if (gMapAbsMin[i] < rayStart[i]) continue
				dist = (gMapAbsMin[i] - rayStart[i]) / rayDir[i]
			}
			VecAddScaled(rayStart, rayDir, dist, rayEnd)
			
			for (j = 2; 0 <= j; j--)
			{
				if (j == i) continue
				if (gMapAbsMin[j] <= rayEnd[j] <= gMapAbsMax[j]) continue
				break
			}
			if (j < 0)
			{
				for (j = 0; j < 3; j++)
				{
					rayStart[j] = rayEnd[j]
					if (rayEnd[j] == gMapAbsMin[j] && 0.0 < rayDir[j])		boxAbsMin[j] = gMapAbsMin[j]
					else if (rayEnd[j] == gMapAbsMax[j] && rayDir[j] < 0.0)		boxAbsMin[j] = gMapAbsMax[j] - 128.0
					else								boxAbsMin[j] = 128.0 * floatround(rayEnd[j] / 128.0, floatround_floor)
					boxAbsMax[j] = boxAbsMin[j] + 128.0
				}
				break
			}
		}
		// 未命中世界盒
		if (i == 3) return -1
		// 世界盒被遮挡
		if (rayLength < dist) return -1
		rayLength -= dist
	}
	
	new nodeIndex, nodeId, Array:arrayNode
	new Float:lenVecTemp, Float:lenVecX, Float:lenVecY, Float:cosA
	new Float:origin[3], Float:vecTemp[3], Float:vecX[3], Float:vecY[3], Float:rayHit[3], Float:absMin[3], Float:absMax[3]
	
	LoopStart:
	
	nodeIndex = -1
	arrayNode = NavBox_GetNodeArray(boxAbsMin)
	for (new i = ArraySize(arrayNode) - 1; 0 <= i; i--)
	{
		nodeId = ArrayGetCell(arrayNode, i)
		
		ArrayGetArray(gArray_NodePoint, nodeId, origin)
		origin[2] -= ArrayGetCell(gArray_NodeDucking, nodeId) ? 13.0 : 31.0
		
		VecSub(rayStart, origin, vecTemp)
		lenVecTemp = VecLength(vecTemp)
		if (0.0 <= VecDot(rayDir, vecTemp) / lenVecTemp) continue
		
		ArrayGetArray(gArray_NodeNormal, nodeId, vecX)
		
		lenVecX = VecDot(vecX, vecTemp)
		VecAddScaled(origin, vecX, lenVecX, vecTemp)
		VecSub(rayStart, vecTemp, vecY)
		VecMulScalar(rayDir, -1.0, vecTemp)
		lenVecTemp = VecLength(vecY)
		cosA = VecDot(vecX, vecTemp)
		lenVecY = lenVecTemp - floattan(floatacos(cosA, degrees), degrees) * lenVecX
		VecAddScaled(origin, vecY, lenVecY / lenVecTemp, vecTemp)
		dist = lenVecX / cosA
		if (rayLength < dist) continue
		VecAddScaled(rayStart, rayDir, dist, rayHit)
		
		ArrayGetArray(gArray_NodeAbsMin, nodeId, absMin)
		if (rayHit[0] < absMin[0] || rayHit[1] < absMin[1]) continue
		ArrayGetArray(gArray_NodeAbsMax, nodeId, absMax)
		if (absMax[0] <= rayHit[0] || absMax[1] <= rayHit[1]) continue
		
		dist = floatabs(rayHit[2] - rayStart[2])
		if (dist < lastDist || nodeIndex < 0) { lastDist = dist; nodeIndex = nodeId; }
	}
	if (0 <= nodeIndex) return nodeIndex
	
	for (i = 0; i < 3; i++)
	{
		if (rayDir[i] == 0.0) continue
		
		if (rayDir[i] < 0.0)
		{
			// 不可能命中盒子
			if (rayStart[i] < boxAbsMin[i]) continue
			dist = (boxAbsMin[i] - rayStart[i]) / rayDir[i]
		}
		else
		{
			// 不可能命中盒子
			if (boxAbsMax[i] < rayStart[i]) continue
			dist = (boxAbsMax[i] - rayStart[i]) / rayDir[i]
		}
		VecAddScaled(rayStart, rayDir, dist, rayEnd)
		if (loop && VecEqual(rayEnd, lastRayEnd)) continue
		lastRayEnd = rayEnd
		
		for (j = 2; 0 <= j; j--)
		{
			if (j == i) continue
			if (boxAbsMin[j] <= rayEnd[j] <= boxAbsMax[j]) continue
			break
		}
		if (j < 0)
		{
			for (j = 0; j < 3; j++)
			{
				rayStart[j] = rayEnd[j]
				if (rayEnd[j] == boxAbsMin[j] && rayDir[j] < 0.0)	boxAbsMin[j] -= 128.0
				else if (rayEnd[j] == boxAbsMax[j] && 0.0 < rayDir[j])	boxAbsMin[j] = boxAbsMax[j]
				else							boxAbsMin[j] = 128.0 * floatround(rayEnd[j] / 128.0, floatround_floor)
				boxAbsMax[j] = boxAbsMin[j] + 128.0
				
				// 超出世界盒范围
				if (boxAbsMin[j] < gMapAbsMin[j] || gMapAbsMax[j] <= boxAbsMin[j]) return -1
			}
			// 下一个被遮挡
			if (rayLength < dist) return -1
			
			loop++
			rayLength -= dist
			
			goto LoopStart
		}
	}
	
	// 超出世界盒范围(上面已经有同样的条件.此行代码不可能运行.写此代码只是为了消除编译器警告)
	return -1	
}

NavNode_Create(const Float:origin[3], const Float:normal[3], bool:ducking)
{
	new nodeIndex = ArraySize(gArray_NodePoint)
	
	new Float:height = ducking ? 18.0 : 36.0
	
	new Float:absMin[3], Float:absMax[3]
	absMin[0] = origin[0] - 16.0
	absMin[1] = origin[1] - 16.0
	absMin[2] = origin[2] - height
	absMax[0] = origin[0] + 16.0
	absMax[1] = origin[1] + 16.0
	absMax[2] = origin[2] + height
	
	ArrayPushCell(gArray_NodeDucking, ducking)
	ArrayPushArray(gArray_NodePoint, origin)
	ArrayPushArray(gArray_NodeAbsMin, absMin)
	ArrayPushArray(gArray_NodeAbsMax, absMax)
	ArrayPushArray(gArray_NodeNormal, normal)
	ArrayPushCell(gArray_NodeStart, ArrayCreate())
	ArrayPushCell(gArray_NodeEnd, ArrayCreate())
	ArrayPushCell(gArray_NodeFlags, ArrayCreate())
	ArrayPushCell(gArray_NodeHeight, ArrayCreate())
	ArrayPushCell(gArray_NodeDistance, ArrayCreate())
	
	return nodeIndex
}

NavNode_Clear()
{
	new iNode, nodeNums
	new Array:arrayStart, Array:arrayEnd, Array:arrayFlags, Array:arrayHeight, Array:arrayDistance
	nodeNums = ArraySize(gArray_NodeDucking)
	for (iNode = 0; iNode < nodeNums; iNode++)
	{
		arrayStart	= ArrayGetCell(gArray_NodeStart,	iNode)
		arrayEnd	= ArrayGetCell(gArray_NodeEnd,		iNode)
		arrayFlags	= ArrayGetCell(gArray_NodeFlags,	iNode)
		arrayHeight	= ArrayGetCell(gArray_NodeHeight,	iNode)
		arrayDistance	= ArrayGetCell(gArray_NodeDistance,	iNode)
		ArrayDestroy(arrayStart)
		ArrayDestroy(arrayEnd)
		ArrayDestroy(arrayFlags)
		ArrayDestroy(arrayHeight)
		ArrayDestroy(arrayDistance)
	}
	
	ArrayClear(gArray_NodeDucking)
	ArrayClear(gArray_NodePoint)
	ArrayClear(gArray_NodeAbsMin)
	ArrayClear(gArray_NodeAbsMax)
	ArrayClear(gArray_NodeNormal)
	ArrayClear(gArray_NodeStart)
	ArrayClear(gArray_NodeEnd)
	ArrayClear(gArray_NodeFlags)
	ArrayClear(gArray_NodeHeight)
	ArrayClear(gArray_NodeDistance)
}

NavNode_DrawMesh(id, nodeIndex, bool:drawPaths, life, width, noise, r, g, b)
{
	new bool:ducking, Float:nodePoint[3], Float:absMin[3], Float:absMax[3], Float:normal[3]
	ducking = ArrayGetCell(gArray_NodeDucking, nodeIndex)
	ArrayGetArray(gArray_NodePoint, nodeIndex, nodePoint)
	ArrayGetArray(gArray_NodeAbsMin, nodeIndex, absMin)
	ArrayGetArray(gArray_NodeAbsMax, nodeIndex, absMax)
	ArrayGetArray(gArray_NodeNormal, nodeIndex, normal)
	
	nodePoint[2] -= ducking ? 13.0 : 31.0
	
	new Float:cornerPoint[4][3]
	cornerPoint[0][0] = absMax[0] - 2.0
	cornerPoint[0][1] = absMax[1] - 2.0
	cornerPoint[0][2] = InclinedPlaneZ(nodePoint, normal, cornerPoint[0])
	cornerPoint[1][0] = absMin[0] + 2.0
	cornerPoint[1][1] = absMax[1] - 2.0
	cornerPoint[1][2] = InclinedPlaneZ(nodePoint, normal, cornerPoint[1])
	cornerPoint[2][0] = absMin[0] + 2.0
	cornerPoint[2][1] = absMin[1] + 2.0
	cornerPoint[2][2] = InclinedPlaneZ(nodePoint, normal, cornerPoint[2])
	cornerPoint[3][0] = absMax[0] - 2.0
	cornerPoint[3][1] = absMin[1] + 2.0
	cornerPoint[3][2] = InclinedPlaneZ(nodePoint, normal, cornerPoint[3])
	
	SendMsg_BeamPoints(id, cornerPoint[0], cornerPoint[1], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[1], cornerPoint[2], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[2], cornerPoint[3], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[3], cornerPoint[0], gMdlId_BeamNode, life, width, noise, r, g, b)
	if (ducking)
	{
		SendMsg_BeamPoints(id, cornerPoint[0], cornerPoint[2], gMdlId_BeamNode, life, width, noise, r, g, b)
		SendMsg_BeamPoints(id, cornerPoint[1], cornerPoint[3], gMdlId_BeamNode, life, width, noise, r, g, b)
	}
	
	if (drawPaths)
	{
		nodePoint[2] += 1.0
		
		new nodeId, PathFlags:pathFlags, Float:height
		new iPathStart, iPathEnd
		new Array:arrayStart	= ArrayGetCell(gArray_NodeStart,	nodeIndex)
		new Array:arrayEnd	= ArrayGetCell(gArray_NodeEnd,		nodeIndex)
		new Array:arrayFlags	= ArrayGetCell(gArray_NodeFlags,	nodeIndex)
		new Array:arrayHeight	= ArrayGetCell(gArray_NodeHeight,	nodeIndex)
		
		new Float:dest[3], Float:destAbsMin[3], Float:destAbsMax[3], Float:mid[3], Float:start[3], Float:end[3], Float:vecF[3]
		new j, mdlId, pathWidth, r, g, b
		for (iPathEnd = ArraySize(arrayEnd) - 1; 0 <= iPathEnd; iPathEnd--)
		{
			nodeId		= ArrayGetCell(arrayEnd,	iPathEnd)
			pathFlags	= ArrayGetCell(arrayFlags,	iPathEnd)
			height		= ArrayGetCell(arrayHeight,	iPathEnd)
			
			ArrayGetArray(gArray_NodePoint, nodeId, dest)
			ArrayGetArray(gArray_NodeAbsMin, nodeId, destAbsMin)
			ArrayGetArray(gArray_NodeAbsMax, nodeId, destAbsMax)
			ArrayGetArray(gArray_NodeNormal, nodeId, vecF)
			
			dest[2] -= ArrayGetCell(gArray_NodeDucking, nodeId) ? 12.0 : 30.0
			
			for (j = 0; j < 2; j++)
			{
				if (dest[j] < nodePoint[j])	mid[j] = floatmin(nodePoint[j], floatmax(dest[j], (destAbsMax[j] + absMin[j]) * 0.5))
				else				mid[j] = floatmax(nodePoint[j], floatmin(dest[j], (absMax[j] + destAbsMin[j]) * 0.5))
				if (mid[j] == absMin[j])	{ start[j] = absMin[j] + 16.0; end[j] = absMin[j] - 16.0; }
				else if (mid[j] == absMax[j])	{ start[j] = absMax[j] - 16.0; end[j] = absMax[j] + 16.0; }
				else				{ start[j] = end[j] = mid[j]; }
			}
			start[2]	= InclinedPlaneZ(nodePoint, normal, start)
			mid[2]		= InclinedPlaneZ(nodePoint, normal, mid) + height
			end[2]		= InclinedPlaneZ(dest, vecF, end)
			
			for (iPathStart = ArraySize(arrayStart) - 1; 0 <= iPathStart && ArrayGetCell(arrayStart, iPathStart) != nodeId; iPathStart--) { }
			
			if (pathFlags & PF_Climb)	{ mdlId = gMdlId_BeamPath2; pathWidth = width + 15; }
			else				{ mdlId = gMdlId_BeamPath1; pathWidth = width + 10; }
			if (pathFlags & PF_CrouchRun)	{ r = 200; g = 0; b = iPathStart < 0 ? 0 : 200; }
			else				{ r = 0; g = iPathStart < 0 ? 0 : 200; b = 200; }
			
			if (0.0 < height)
			{
				SendMsg_BeamPoints(id, start, mid, gMdlId_BeamNode, life, width, noise, r, g, b)
				SendMsg_BeamPoints(id, mid, end, mdlId, life, pathWidth, noise, r, g, b)
			}
			else	SendMsg_BeamPoints(id, start, end, mdlId, life, pathWidth, noise, r, g, b)
		}
	}
}

NavNode_DrawBox(id, nodeIndex, life, width, noise, r, g, b)
{
	new bool:ducking, Float:nodePoint[3], Float:absMin[3], Float:absMax[3], Float:normal[3]
	ducking = ArrayGetCell(gArray_NodeDucking, nodeIndex)
	ArrayGetArray(gArray_NodePoint, nodeIndex, nodePoint)
	ArrayGetArray(gArray_NodeAbsMin, nodeIndex, absMin)
	ArrayGetArray(gArray_NodeAbsMax, nodeIndex, absMax)
	ArrayGetArray(gArray_NodeNormal, nodeIndex, normal)
	
	nodePoint[2] -= ducking ? 18.0 : 36.0
	
	new Float:cornerPoint[8][3]
	cornerPoint[0][0] = absMax[0]
	cornerPoint[0][1] = absMax[1]
	cornerPoint[0][2] = InclinedPlaneZ(nodePoint, normal, cornerPoint[0])
	cornerPoint[1][0] = absMin[0]
	cornerPoint[1][1] = absMax[1]
	cornerPoint[1][2] = InclinedPlaneZ(nodePoint, normal, cornerPoint[1])
	cornerPoint[2][0] = absMin[0]
	cornerPoint[2][1] = absMin[1]
	cornerPoint[2][2] = InclinedPlaneZ(nodePoint, normal, cornerPoint[2])
	cornerPoint[3][0] = absMax[0]
	cornerPoint[3][1] = absMin[1]
	cornerPoint[3][2] = InclinedPlaneZ(nodePoint, normal, cornerPoint[3])
	
	nodePoint[2] += ducking ? 36.0 : 72.0
	
	cornerPoint[4][0] = absMax[0]
	cornerPoint[4][1] = absMax[1]
	cornerPoint[4][2] = InclinedPlaneZ(nodePoint, normal, cornerPoint[4])
	cornerPoint[5][0] = absMin[0]
	cornerPoint[5][1] = absMax[1]
	cornerPoint[5][2] = InclinedPlaneZ(nodePoint, normal, cornerPoint[5])
	cornerPoint[6][0] = absMin[0]
	cornerPoint[6][1] = absMin[1]
	cornerPoint[6][2] = InclinedPlaneZ(nodePoint, normal, cornerPoint[6])
	cornerPoint[7][0] = absMax[0]
	cornerPoint[7][1] = absMin[1]
	cornerPoint[7][2] = InclinedPlaneZ(nodePoint, normal, cornerPoint[7])
	
	SendMsg_BeamPoints(id, cornerPoint[0], cornerPoint[1], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[1], cornerPoint[2], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[2], cornerPoint[3], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[3], cornerPoint[0], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[4], cornerPoint[5], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[5], cornerPoint[6], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[6], cornerPoint[7], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[7], cornerPoint[4], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[0], cornerPoint[4], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[1], cornerPoint[5], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[2], cornerPoint[6], gMdlId_BeamNode, life, width, noise, r, g, b)
	SendMsg_BeamPoints(id, cornerPoint[3], cornerPoint[7], gMdlId_BeamNode, life, width, noise, r, g, b)
}

bool:NavNode_Selects(nodeIndex)
{
	for (new i = ArraySize(gArray_Selected) - 1; 0 <= i; i--)
	{
		if (ArrayGetCell(gArray_Selected, i) == nodeIndex)
		{
			ArrayDeleteItem(gArray_Selected, i)
			return false
		}
	}
	ArrayPushCell(gArray_Selected, nodeIndex)
	return true
}

NavNode_Delete(iNodeSelect)
{
	new iNodeStart, iNodeMid, iNodeEnd, iPath
	new Array:arrayStart, Array:arrayEnd, Array:arrayFlags, Array:arrayHeight, Array:arrayDistance
	
	// 删除所有终点是iNodeSelect的路径,并更新节点id
	for (iNodeMid = ArraySize(gArray_NodeDucking) - 1; 0 <= iNodeMid; iNodeMid--)
	{
		arrayStart	= ArrayGetCell(gArray_NodeStart,	iNodeMid)
		arrayEnd	= ArrayGetCell(gArray_NodeEnd,		iNodeMid)
		arrayFlags	= ArrayGetCell(gArray_NodeFlags,	iNodeMid)
		arrayHeight	= ArrayGetCell(gArray_NodeHeight,	iNodeMid)
		arrayDistance	= ArrayGetCell(gArray_NodeDistance,	iNodeMid)
		
		// 遍历iNodeMid的所有起点,有则删除iNodeSelect,更新其他起点id
		for (iPath = ArraySize(arrayStart) - 1; 0 <= iPath; iPath--)
		{
			iNodeStart = ArrayGetCell(arrayStart, iPath)
			if (iNodeStart == iNodeSelect) ArrayDeleteItem(arrayStart, iPath)
			else if (iNodeSelect < iNodeStart) ArraySetCell(arrayStart, iPath, iNodeStart - 1)
		}
		// 遍历iNodeMid的所有终点,删除终点是iNodeSelect的路径,或更新终点id
		for (iPath = ArraySize(arrayEnd) - 1; 0 <= iPath; iPath--)
		{
			iNodeEnd = ArrayGetCell(arrayEnd, iPath)
			if (iNodeEnd == iNodeSelect)
			{
				ArrayDeleteItem(arrayEnd,	iPath)
				ArrayDeleteItem(arrayFlags,	iPath)
				ArrayDeleteItem(arrayHeight,	iPath)
				ArrayDeleteItem(arrayDistance,	iPath)
			}
			else if (iNodeSelect < iNodeEnd) ArraySetCell(arrayEnd, iPath, iNodeEnd - 1)
		}
	}
	
	// 删除iNodeSelect节点的所有信息
	arrayStart	= ArrayGetCell(gArray_NodeStart,	iNodeSelect)
	arrayEnd	= ArrayGetCell(gArray_NodeEnd,		iNodeSelect)
	arrayFlags	= ArrayGetCell(gArray_NodeFlags,	iNodeSelect)
	arrayHeight	= ArrayGetCell(gArray_NodeHeight,	iNodeSelect)
	arrayDistance	= ArrayGetCell(gArray_NodeDistance,	iNodeSelect)
	ArrayDestroy(arrayStart)
	ArrayDestroy(arrayEnd)
	ArrayDestroy(arrayFlags)
	ArrayDestroy(arrayHeight)
	ArrayDestroy(arrayDistance)
	
	ArrayDeleteItem(gArray_NodeDucking,	iNodeSelect)
	ArrayDeleteItem(gArray_NodePoint,	iNodeSelect)
	ArrayDeleteItem(gArray_NodeAbsMax,	iNodeSelect)
	ArrayDeleteItem(gArray_NodeAbsMin,	iNodeSelect)
	ArrayDeleteItem(gArray_NodeNormal,	iNodeSelect)
	ArrayDeleteItem(gArray_NodeStart,	iNodeSelect)
	ArrayDeleteItem(gArray_NodeEnd,		iNodeSelect)
	ArrayDeleteItem(gArray_NodeFlags,	iNodeSelect)
	ArrayDeleteItem(gArray_NodeHeight,	iNodeSelect)
	ArrayDeleteItem(gArray_NodeDistance,	iNodeSelect)
}

NavNode_AutoCreating()
{
	new i, param[2]
	for (i = ArraySize(gArray_Ladder) - 1; 0 <= i; i--) set_pev(ArrayGetCell(gArray_Ladder, i), pev_solid, SOLID_BSP)
	for (i = ArraySize(gArray_TraceIgnoreEnt) - 1; 0 <= i; i--)
	{
		ArrayGetArray(gArray_TraceIgnoreEnt, i, param)
		param[1] = pev(param[0], pev_solid)
		set_pev(param[0], pev_solid, SOLID_NOT)
		ArraySetArray(gArray_TraceIgnoreEnt, i, param)
	}
	
	new iVecDir, Float:vecDir[8][2] =
	{
		{	32.0,	0.0	},
		{	32.0,	32.0	},
		{	0.0,	32.0	},
		{	-32.0,	32.0	},
		{	-32.0,	0.0	},
		{	-32.0,	-32.0	},
		{	0.0,	-32.0	},
		{	32.0,	-32.0	}
	}
	
	new iSpawnPos, spawnPosNums, Float:spawnPos[6]
	new iNodeSelect, iNode, nodeNums
	new bool:ducking, Float:coord[3], Float:normal[3], Float:absMin[3], Float:absMax[3]
	new bool:nodeDucking, Float:nodePoint[3], Float:nodeNormal[3], bool:crouchRun, Float:height
	
	nodeNums = ArraySize(gArray_NodeDucking)
	if (nodeNums) NavNode_Clear()
	
	spawnPosNums = ArraySize(gArray_SpawnPos)
	for (iSpawnPos = 0; iSpawnPos < spawnPosNums; iSpawnPos++)
	{
		ArrayGetArray(gArray_SpawnPos, iSpawnPos, spawnPos)
		coord[0] = spawnPos[0]
		coord[1] = spawnPos[1]
		coord[2] = spawnPos[2]
		
		nodeNums = ArraySize(gArray_NodeDucking)
		for (iNode = 0; iNode < nodeNums; iNode++)
		{
			ArrayGetArray(gArray_NodeAbsMin, iNode, absMin)
			if (coord[0] < absMin[0]) continue
			if (coord[1] < absMin[1]) continue
			if (coord[2] < absMin[2]) continue
			ArrayGetArray(gArray_NodeAbsMax, iNode, absMax)
			if (absMax[0] <= coord[0]) continue
			if (absMax[1] <= coord[1]) continue
			if (absMax[2] <= coord[2]) continue
			break
		}
		if (nodeNums && iNode < nodeNums) continue
		
		normal[0] = spawnPos[3]
		normal[1] = spawnPos[4]
		normal[2] = spawnPos[5]
		iNodeSelect = NavNode_Create(coord, normal, ducking)
		nodeNums++
		
		LoopStart:
		
		for (iVecDir = 0; iVecDir < 8; iVecDir++)
		{
			nodePoint[0] = coord[0] + vecDir[iVecDir][0]
			nodePoint[1] = coord[1] + vecDir[iVecDir][1]
			nodePoint[2] = coord[2]
			if (NavPath_Exist2(ducking, coord, nodePoint, nodeDucking, nodePoint, nodeNormal, crouchRun, height))
			{
				for (iNode = 0; iNode < nodeNums; iNode++)
				{
					if (iNode == iNodeSelect) continue
					ArrayGetArray(gArray_NodeAbsMin, iNode, absMin)
					if (nodePoint[0] < absMin[0]) continue
					if (nodePoint[1] < absMin[1]) continue
					if (nodePoint[2] < absMin[2]) continue
					ArrayGetArray(gArray_NodeAbsMax, iNode, absMax)
					if (absMax[0] <= nodePoint[0]) continue
					if (absMax[1] <= nodePoint[1]) continue
					if (absMax[2] <= nodePoint[2]) continue
					break
				}
				
				if (iNode == nodeNums)
				{
					iNode = NavNode_Create(nodePoint, nodeNormal, nodeDucking)
					nodeNums++
				}
				else 	ArrayGetArray(gArray_NodePoint, iNode, nodePoint)
				
				ArrayPushCell(ArrayGetCell(gArray_NodeStart,		iNode),		iNodeSelect)
				ArrayPushCell(ArrayGetCell(gArray_NodeEnd,		iNodeSelect),	iNode)
				ArrayPushCell(ArrayGetCell(gArray_NodeFlags,		iNodeSelect),	crouchRun ? PF_CrouchRun : PF_Walk)
				ArrayPushCell(ArrayGetCell(gArray_NodeHeight,		iNodeSelect),	height)
				ArrayPushCell(ArrayGetCell(gArray_NodeDistance,		iNodeSelect),	VecDistance(coord, nodePoint))
			}
		}
		
		if (++iNodeSelect < nodeNums)
		{
			ducking = ArrayGetCell(gArray_NodeDucking, iNodeSelect)
			ArrayGetArray(gArray_NodePoint, iNodeSelect, coord)
			goto LoopStart
		}
	}
	
	for (i = ArraySize(gArray_Ladder) - 1; 0 <= i; i--) set_pev(ArrayGetCell(gArray_Ladder, i), pev_solid, SOLID_NOT)
	for (i = ArraySize(gArray_TraceIgnoreEnt) - 1; 0 <= i; i--)
	{
		ArrayGetArray(gArray_TraceIgnoreEnt, i, param)
		set_pev(param[0], pev_solid, param[1])
	}
}

bool:NavPath_Exist(bool:duckingStart, const Float:start[3], const Float:goal[3], &bool:duckingEnd, Float:end[3], Float:normal[3], &bool:crouchRun, &Float:height)
{
	new hull
	new bool:isPlaneSteep, bool:startOnSteep, bool:safeHeight
	new Float:fraction, Float:z
	new Float:vecSrc[3], Float:vecDest[3], Float:vecPlaneNormal[3], Float:vecEndPos[3], Float:vecTemp[3]
	
	vecSrc[0] = start[0]
	vecSrc[1] = start[1]
	vecSrc[2] = start[2] - 9999.0
	engfunc(EngFunc_TraceHull, start, vecSrc, dTraceIgnore, HULL_HEAD, -1, 0)
	get_tr2(0, TR_vecEndPos, vecSrc)
	get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal)
	
	vecDest[0] = goal[0]
	vecDest[1] = goal[1]
	vecDest[2] = vecSrc[2]
	startOnSteep = IsPlaneSteep(vecPlaneNormal[2])
	
	engfunc(EngFunc_TraceHull, vecSrc, vecDest, dTraceIgnore, HULL_HEAD, -1, 0)
	
	get_tr2(0, TR_flFraction, fraction)
	if (fraction < 1.0)
	{
		if (startOnSteep) return false
		
		get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal)
		new bool:isPlaneFloor = IsPlaneFloor(vecPlaneNormal[2])
		
		vecTemp[0] = vecDest[0]
		vecTemp[1] = vecDest[1]
		vecTemp[2] = vecSrc[2] + (duckingStart ? dJumpHeight : dJumpHeight + 18.0)
		
		engfunc(EngFunc_TraceHull, vecDest, vecTemp, dTraceIgnore, HULL_HEAD, -1, 0)
		get_tr2(0, TR_vecEndPos, vecDest)
		
		vecTemp[2] = vecSrc[2] - 9999.0
		
		engfunc(EngFunc_TraceHull, vecDest, vecTemp, dTraceIgnore, HULL_HEAD, -1, 0)
		get_tr2(0, TR_vecEndPos, vecEndPos)
		get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal)
		
		engfunc(EngFunc_TraceHull, vecEndPos, vecEndPos, dTraceIgnore, HULL_HEAD, -1, 0)
		if (!get_tr2(0, TR_InOpen) || get_tr2(0, TR_AllSolid) || get_tr2(0, TR_StartSolid)) return false
		
		if (vecEndPos[2] <= vecSrc[2])
		{
			isPlaneSteep = IsPlaneSteep(vecPlaneNormal[2])
			safeHeight = vecDest[2] - vecEndPos[2] <= dSafeHeight
			
			/* 尝试将坐标提升到与直立玩家的坐标相同的高度 */
			vecEndPos[2] += 18.0
			engfunc(EngFunc_TraceHull, vecEndPos, vecEndPos, dTraceIgnore, HULL_HUMAN, -1, 0)
			if (get_tr2(0, TR_InOpen) && !get_tr2(0, TR_AllSolid) && !get_tr2(0, TR_StartSolid)) hull = HULL_HUMAN
			else { hull = HULL_HEAD; vecEndPos[2] -= 18.0; }
			
			// 会摔伤.此路不通
			if (!isPlaneSteep && dSafeHeight < vecDest[2] - vecEndPos[2]) return false
		}
		else
		{
			safeHeight = true
			if (isPlaneFloor)
			{
				z = 0.0
				
				engfunc(EngFunc_TraceHull, vecSrc, vecEndPos, dTraceIgnore, HULL_HEAD, -1, 0)
				get_tr2(0, TR_flFraction, fraction)
				if (fraction < 1.0)
				{
					get_tr2(0, TR_vecPlaneNormal, vecTemp)
					if (!IsPlaneFloor(vecTemp[2]))	z = float(floatround(vecEndPos[2] - vecSrc[2], floatround_ceil))
				}
			}
			else
			{
				if (IsPlaneSteep(vecPlaneNormal[2]))	z = 45.0
				else					z = float(floatround(vecEndPos[2] - vecSrc[2], floatround_ceil))
				
				vecSrc[2] = vecEndPos[2]
				engfunc(EngFunc_TraceHull, vecEndPos, vecSrc, dTraceIgnore, HULL_HEAD, -1, 0)
				get_tr2(0, TR_flFraction, fraction)
				if (fraction < 1.0) return false
			}
			
			/* 尝试将坐标提升到与直立玩家的坐标相同的高度 */
			vecEndPos[2] += 18.0
			engfunc(EngFunc_TraceHull, vecEndPos, vecEndPos, dTraceIgnore, HULL_HUMAN, -1, 0)
			if (get_tr2(0, TR_InOpen) && !get_tr2(0, TR_AllSolid) && !get_tr2(0, TR_StartSolid)) hull = HULL_HUMAN
			else { hull = HULL_HEAD; vecEndPos[2] -= 18.0; }
		}
	}
	else
	{
		vecTemp[0] = vecDest[0]
		vecTemp[1] = vecDest[1]
		vecTemp[2] = vecDest[2] - 9999.0
		
		engfunc(EngFunc_TraceHull, vecDest, vecTemp, dTraceIgnore, HULL_HEAD, -1, 0)
		
		get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal)
		get_tr2(0, TR_vecEndPos, vecEndPos)
		
		isPlaneSteep = IsPlaneSteep(vecPlaneNormal[2])
		safeHeight = vecDest[2] - vecEndPos[2] <= dSafeHeight
		
		/* 尝试将坐标提升到与直立玩家的坐标相同的高度 */
		vecEndPos[2] += 18.0
		engfunc(EngFunc_TraceHull, vecEndPos, vecEndPos, dTraceIgnore, HULL_HUMAN, -1, 0)
		if (get_tr2(0, TR_InOpen) && !get_tr2(0, TR_AllSolid) && !get_tr2(0, TR_StartSolid)) hull = HULL_HUMAN
		else { hull = HULL_HEAD; vecEndPos[2] -= 18.0; }
		
		// 会摔伤.此路不通
		if (!isPlaneSteep && dSafeHeight < vecDest[2] - vecEndPos[2]) return false
	}
	
	// 终点是否需要蹲下
	duckingEnd = (hull == HULL_HEAD)
	// 路径终点坐标
	end = vecEndPos
	// 路径终点面向
	normal = vecPlaneNormal
	// 如果直立跳崖会跌伤,或终点为下蹲尺寸.则需要蹲跑才能抵达终点
	crouchRun = (!safeHeight || duckingEnd)
	// 路径中间的障碍物高度
	height = z
	
	return true
}

bool:NavPath_Exist2(bool:duckingStart, const Float:start[3], const Float:goal[3], &bool:duckingEnd, Float:end[3], Float:normal[3], &bool:crouchRun, &Float:height)
{
	new planeType
	new bool:isPlaneSteep, bool:startOnSteep
	new Float:z, Float:lastZ, Float:fraction
	new Float:lastPlaneInfo[5][4], Float:lastGround[2]
	new Float:vecSrc[3], Float:vecDest[3], Float:vecPlaneNormal[3], Float:vecTemp[3]
	
	vecSrc[0] = start[0]
	vecSrc[1] = start[1]
	vecSrc[2] = start[2] - 9999.0
	engfunc(EngFunc_TraceHull, start, vecSrc, dTraceIgnore, HULL_HEAD, -1, 0)
	get_tr2(0, TR_vecEndPos, vecSrc)
	get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal)
	
	vecDest[0] = goal[0]
	vecDest[1] = goal[1]
	vecDest[2] = vecSrc[2]
	startOnSteep = IsPlaneSteep(vecPlaneNormal[2])
	
	LoopStart:
	
	engfunc(EngFunc_TraceHull, vecSrc, vecDest, dTraceIgnore, HULL_HEAD, -1, 0)
	
	get_tr2(0, TR_flFraction, fraction)
	if (fraction < 1.0)					// 如果射线被障碍物阻挡
	{
		get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal)
		
		planeType = GetPlaneType(vecPlaneNormal[2])	// 根据障碍物类型(0:天花板,1:倾斜天花板,2:地面,3:倾斜地面,4:墙面)
		
		isPlaneSteep = IsPlaneSteep(vecPlaneNormal[2])
		
		get_tr2(0, TR_vecEndPos, vecSrc)
		
		if (lastPlaneInfo[planeType][3])		// 如果不是第一次被这种地形阻挡
		{
			// 如果这一次的命中点与上一次的命中点相同.说明死循环了.无法前进
			if (VecEqual(vecSrc, lastPlaneInfo[planeType])) return false
			
			// 如果这一个垂直墙壁不等于上一个垂直墙壁.则重新计算跳跃高度
			if (planeType == 4 && 0.0 < fraction) z = 0.0
		}
		
		/* 记住这个地形的坐标 */
		lastPlaneInfo[planeType] = vecSrc
		lastPlaneInfo[planeType][3] = 1.0
		
		switch (planeType)
		{
			case 0:	// 击中天花板
			{
				if (vecDest[0] == vecSrc[0] && vecDest[1] == vecSrc[1])
				{
					vecDest[0] = goal[0]
					vecDest[1] = goal[1]
				}
				vecDest[2] = vecSrc[2]
			}
			case 1:	// 击中倾斜天花板
			{
				if (vecDest[0] == vecSrc[0] && vecDest[1] == vecSrc[1])
				{
					vecDest[0] = goal[0]
					vecDest[1] = goal[1]
				}
				vecDest[2] = InclinedPlaneZ(vecSrc, vecPlaneNormal, vecDest)
			}
			case 2:	// 击中地面
			{
				vecDest[2] = vecSrc[2]
			}
			case 3:	// 击中倾斜地面
			{
				vecDest[2] = InclinedPlaneZ(vecSrc, vecPlaneNormal, vecDest)
				if (!startOnSteep && isPlaneSteep) lastZ = dJumpHeight
			}
			case 4:	// 击中墙面
			{
				// 起点为下蹲尺寸,禁止测试跳跃
				if (duckingStart)
				{
					if (dJumpHeight <= z) return false
				}
				// 跳跃测试的高度已经到达极限,无法越过墙面
				else if (dJumpHeight + 18.0 <= z) return false
				
				if (z == 0.0)
				{
					vecTemp[0] = vecSrc[0]
					vecTemp[1] = vecSrc[1]
					vecTemp[2] = vecSrc[2] - 9999.0
					engfunc(EngFunc_TraceHull, vecSrc, vecTemp, dTraceIgnore, HULL_HEAD, -1, 0)
					
					get_tr2(0, TR_vecEndPos, vecSrc)
					if (vecSrc[0] == lastGround[0] && vecSrc[1] == lastGround[1]) return false
					
					lastGround[0] = vecSrc[0]
					lastGround[1] = vecSrc[1]
				}
				
				z++
				if (lastZ < z) lastZ = z
				
				/* 垂直向上发射轨迹盒.有3种结果:无障碍物/命中倾斜天花板/命中天花板 */
				vecDest[0] = vecSrc[0]
				vecDest[1] = vecSrc[1]
				vecDest[2] = vecSrc[2] + 1.0
			}
		}
		goto LoopStart
	}
	
	if (vecDest[0] == vecSrc[0] && vecDest[1] == vecSrc[1])
	{
		vecSrc[2] = vecDest[2]
		vecDest[0] = goal[0]
		vecDest[1] = goal[1]
		goto LoopStart
	}
	
	vecTemp[0] = vecDest[0]
	vecTemp[1] = vecDest[1]
	vecTemp[2] = vecDest[2] - 9999.0
	engfunc(EngFunc_TraceHull, vecDest, vecTemp, dTraceIgnore, HULL_HEAD, -1, 0)
	
	get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal)
	get_tr2(0, TR_vecEndPos, vecTemp)
	
	isPlaneSteep = IsPlaneSteep(vecPlaneNormal[2])
	new bool:safeHeight = vecDest[2] - vecTemp[2] <= dSafeHeight
	
	/* 尝试将坐标提升到与直立玩家的坐标相同的高度 */
	new hull
	vecTemp[2] += 18.0
	engfunc(EngFunc_TraceHull, vecTemp, vecTemp, dTraceIgnore, HULL_HUMAN, -1, 0)
	if (!get_tr2(0, TR_InOpen) || get_tr2(0, TR_AllSolid) || get_tr2(0, TR_StartSolid)) { hull = HULL_HEAD; vecTemp[2] -= 18.0; }
	else hull = HULL_HUMAN
	
	if (isPlaneSteep)	// 终点是陡坡
	{
		// 太陡了
		if (vecPlaneNormal[2] < 0.35) return false
		// 起点是陡坡,起点低于终点.此路不通
		if (startOnSteep && start[2] <= vecTemp[2]) return false
	}
	else			// 终点不是陡坡
	{
		// 会摔伤.此路不通
		if (dSafeHeight < vecDest[2] - vecTemp[2]) return false
	}
	
	// 终点是否需要蹲下
	duckingEnd = (hull == HULL_HEAD)
	// 路径终点坐标
	end = vecTemp
	// 路径终点面向
	normal = vecPlaneNormal
	// 如果路途中顶部有障碍物,或直立跳崖会跌伤而蹲跑不会,或终点为下蹲尺寸.则需要蹲跑才能抵达终点
	//crouchRun = (lastPlaneInfo[0][3] || lastPlaneInfo[1][3] || !safeHeight || ducking)
	// 如果直立跳崖会跌伤,或终点为下蹲尺寸.则需要蹲跑才能抵达终点
	crouchRun = (!safeHeight || duckingEnd)
	// 路径中间的障碍物高度
	height = lastZ
	
	return true
}

NavNode_AutoMerging(bool:longAllowed)
{
	new i, bool:loopEnable
	new iNodeStart, iNodeEnd, bool:ducking
	new Float:normal[2][3], Float:absMin[3][3], Float:absMax[3][3]
	new Float:origin[3], Float:dest[3], Float:mins[3], Float:maxs[3]
	new Float:width[2], Float:height[2]
	new iPath[2]
	new Array:arrayStart, Array:arrayEnd
	
	LoopStart:
	
	if (ArraySize(gArray_NodeDucking) <= iNodeStart)
	{
		if (loopEnable)
		{
			loopEnable = false
			iNodeStart = 0
			goto LoopStart
		}
		
		return
	}
	
	ducking = ArrayGetCell(gArray_NodeDucking, iNodeStart)
	ArrayGetArray(gArray_NodeAbsMin, iNodeStart, absMin[0])
	ArrayGetArray(gArray_NodeAbsMax, iNodeStart, absMax[0])
	ArrayGetArray(gArray_NodeNormal, iNodeStart, normal[0])
	
	width[0] = absMax[0][0] - absMin[0][0]
	height[0] = absMax[0][1] - absMin[0][1]
	
	arrayStart	= ArrayGetCell(gArray_NodeStart,	iNodeStart)
	arrayEnd	= ArrayGetCell(gArray_NodeEnd,		iNodeStart)
	for (iPath[0] = ArraySize(arrayEnd) - 1; 0 <= iPath[0]; iPath[0]--)
	{
		/** 如果iNodeEnd不是iNodeStart的起点之一(如果是单向路径),则不能融合 */
		iNodeEnd = ArrayGetCell(arrayEnd, iPath[0])
		for (iPath[1] = ArraySize(arrayStart) - 1; 0 <= iPath[1] && ArrayGetCell(arrayStart, iPath[1]) != iNodeEnd; iPath[1]--) { }
		if (iPath[1] < 0) continue
		
		// iNodeStart与iNodeEnd的姿态不同,不能融合
		if (ducking != ArrayGetCell(gArray_NodeDucking, iNodeEnd)) continue
		
		// iNodeStart与iNodeEnd的面向不同,不能融合
		ArrayGetArray(gArray_NodeNormal, iNodeEnd, normal[1])
		if (!VecEqual(normal[0], normal[1])) continue
		
		ArrayGetArray(gArray_NodeAbsMin, iNodeEnd, absMin[1])
		ArrayGetArray(gArray_NodeAbsMax, iNodeEnd, absMax[1])
		
		width[1] = absMax[1][0] - absMin[1][0]
		height[1] = absMax[1][1] - absMin[1][1]
		
		// 如果iNodeStart与iNodeEnd的所有横线的minX相等,maxX相等(排列出四行对齐的横线)
		if (absMin[0][0] == absMin[1][0] && absMax[0][0] == absMax[1][0])
		{
			// 如果iNodeStart或iNodeEnd的横线比竖线短,则不能融合
			if (!longAllowed && (width[0] < height[0] || width[1] < height[1])) continue
		}
		// 如果iNodeStart与iNodeEnd的所有竖线的minY相等,maxY相等(排列出四列对齐的竖线)
		else if (absMin[0][1] == absMin[1][1] && absMax[0][1] == absMax[1][1])
		{
			// 如果iNodeStart或iNodeEnd的竖线比横线短,则不能融合
			if (!longAllowed && (height[0] < width[0] || height[1] < width[1])) continue
		}
		// 如果iNodeStart与iNodeEnd的所有横线竖线都不能对齐,则不能融合
		else continue
		
		for (i = 0; i < 3; i++)
		{
			absMin[2][i] = floatmin(absMin[0][i], absMin[1][i])
			absMax[2][i] = floatmax(absMax[0][i], absMax[1][i])
			origin[i] = (absMin[2][i] + absMax[2][i]) * 0.5
			dest[i] = origin[i]
			mins[i] = absMin[2][i] - origin[i]
			maxs[i] = absMax[2][i] - origin[i]
		}
		
		if (NavNode_Merge(iNodeStart, iNodeEnd, origin, absMin[2], absMax[2]) == 1)
		{
			if (iNodeEnd < iNodeStart) iNodeStart--
			
			loopEnable = true
			
			break
		}
	}
	
	iNodeStart++
	goto LoopStart
}

NavNode_Merge(iNode1, iNode2, const Float:origin[3], const Float:absMin[3], const Float:absMax[3])
{
	new Array:arrayStart[3], Array:arrayEnd[3], Array:arrayFlags[3], Array:arrayHeight[3], Array:arrayDistance[3]
	arrayStart[0]		= ArrayGetCell(gArray_NodeStart,	iNode1)
	arrayEnd[0]		= ArrayGetCell(gArray_NodeEnd,		iNode1)
	arrayFlags[0]		= ArrayGetCell(gArray_NodeFlags,	iNode1)
	arrayHeight[0]		= ArrayGetCell(gArray_NodeHeight,	iNode1)
	arrayDistance[0]	= ArrayGetCell(gArray_NodeDistance,	iNode1)
	arrayStart[1]		= ArrayGetCell(gArray_NodeStart,	iNode2)
	arrayEnd[1]		= ArrayGetCell(gArray_NodeEnd,		iNode2)
	arrayFlags[1]		= ArrayGetCell(gArray_NodeFlags,	iNode2)
	arrayHeight[1]		= ArrayGetCell(gArray_NodeHeight,	iNode2)
	arrayDistance[1]	= ArrayGetCell(gArray_NodeDistance,	iNode2)
	
	new iPath, iPath2, iPathTemp, iNodeStart, iNodeEnd, iNodeTemp, Float:p1[3], Float:p2[3], Float:dest[3]
	new flags, height
	
	/** 对iNode1&2进行同样的操作
	 *  如果iNode1&2属于某个单向路径的终点(iNode1&2位于悬崖底部或顶部)
	 *  则不能融合 */
	for (new i = 0; i < 2; i++)
	{
		for (iPath = ArraySize(arrayStart[i]) - 1; 0 <= iPath; iPath--)
		{
			iNodeStart = ArrayGetCell(arrayStart[i], iPath)
			if (iNodeStart == iNode1 || iNodeStart == iNode2) continue
			
			for (iPath2 = ArraySize(arrayEnd[i]) - 1; 0 <= iPath2 && ArrayGetCell(arrayEnd[i], iPath2) != iNodeStart; iPath2--) { }
			// 如果iNodeStart抵达iNode1&2但是无法原路返回(iNodeStart可能在悬崖顶部),则不能融合
			if (iPath2 < 0) return 0
			
			iNodeTemp = -1
			arrayEnd[2] = ArrayGetCell(gArray_NodeEnd, iNodeStart)
			for (iPath2 = ArraySize(arrayEnd[2]) - 1; 0 <= iPath2; iPath2--)
			{
				iNodeEnd = ArrayGetCell(arrayEnd[2], iPath2)
				if (iNodeEnd == (i ? iNode1 : iNode2)) iNodeTemp = iNodeEnd
				if (iNodeEnd == (i ? iNode2 : iNode1)) height = ArrayGetCell(ArrayGetCell(gArray_NodeHeight, iNodeStart), iPath2)
			}
			// 如果iNodeStart的终点不同时包含iNode1和iNode2,并且iNodeStart需要跳跃才能抵达iNode1&2
			if (iNodeTemp < 0 && 0.0 < height)
			{
				ArrayGetArray(gArray_NodePoint, iNode1, p1)
				ArrayGetArray(gArray_NodePoint, iNode2, p2)
				ArrayGetArray(gArray_NodePoint, iNodeStart, dest)
				// 如果iNode1和iNode2位于一个顶面倾斜的悬崖顶部.则不能融合
				if (dest[2] < p1[2] && dest[2] < p2[2] && p1[2] != p2[2]) return -1
			}
		}
	}
	
	/** 如果iNode1和iNode2抵达同一个终点的方式不同
	 *  如果iNode1往返iNode2的方式不同
	 *  则不能融合 */
	for (iPath = ArraySize(arrayEnd[0]) - 1; 0 <= iPath; iPath--)
	{
		iNodeEnd = ArrayGetCell(arrayEnd[0], iPath)
		
		flags	= ArrayGetCell(arrayFlags[0],	iPath)
		height	= ArrayGetCell(arrayHeight[0],	iPath)
		
		for (iPath2 = ArraySize(arrayEnd[1]) - 1; 0 <= iPath2; iPath2--)
		{
			iNodeTemp = ArrayGetCell(arrayEnd[1], iPath2)
			// 如果 iNodeEnd是iNode1和iNode2的共有终点
			if (iNodeTemp == iNodeEnd)
			{
				// 走路姿态不同
				if (ArrayGetCell(arrayFlags[1], iPath2) != flags) return -2
				// 障碍高度不同
				if (ArrayGetCell(arrayHeight[1], iPath2) != height) return -3
				break
			}
			// 否则如果 iNode1与iNode2之间可相互往返
			else if (iNodeEnd == iNode2 && iNodeTemp == iNode1)
			{
				// 走路姿态不同
				if (ArrayGetCell(arrayFlags[1], iPath2) != flags) return -4
				// 障碍高度不同
				if (ArrayGetCell(arrayHeight[1], iPath2) != height) return -5
				break
			}
		}
	}
	
	ArraySetArray(gArray_NodePoint,		iNode1, origin)
	ArraySetArray(gArray_NodeAbsMin,	iNode1, absMin)
	ArraySetArray(gArray_NodeAbsMax,	iNode1, absMax)
	
	/** 遍历iNode1的所有起点,更新他们抵达iNode1的路径长度 */
	for (iPath = ArraySize(arrayStart[0]) - 1; 0 <= iPath; iPath--)
	{
		iNodeStart = ArrayGetCell(arrayStart[0], iPath)
		
		// 起点是iNode2,不需要更新,因为iNode2至iNode1的路径将被删除
		if (iNodeStart == iNode2) continue
		
		arrayEnd[2]		= ArrayGetCell(gArray_NodeEnd,		iNodeStart)
		arrayDistance[2]	= ArrayGetCell(gArray_NodeDistance,	iNodeStart)
		
		ArrayGetArray(gArray_NodePoint, iNodeStart, dest)
		
		for (iPathTemp = ArraySize(arrayEnd[2]) - 1; 0 <= iPathTemp; iPathTemp--)
		{
			if (ArrayGetCell(arrayEnd[2], iPathTemp) == iNode1)
			{
				ArraySetCell(arrayDistance[2],	iPathTemp, VecDistance(origin, dest))
				break
			}
		}
	}
	
	/** 遍历iNode1的所有终点,更新iNode1抵达终点的路径长度 */
	for (iPath = ArraySize(arrayEnd[0]) - 1; 0 <= iPath; iPath--)
	{
		iNodeEnd = ArrayGetCell(arrayEnd[0], iPath)
		
		// 终点是iNode2,不需要更新,因为iNode1至iNode2的路径将被删除
		if (iNodeEnd == iNode2) continue
		
		ArrayGetArray(gArray_NodePoint, iNodeEnd, dest)
		
		ArraySetCell(arrayDistance[0], iPath, VecDistance(origin, dest))
	}
	
	/** 遍历iNode2的所有起点,复制给iNode1,更新他们抵达iNode2的路径终点和路径长度 */
	for (iPath = ArraySize(arrayStart[1]) - 1; 0 <= iPath; iPath--)
	{
		iNodeStart = ArrayGetCell(arrayStart[1], iPath)
		
		// 起点是iNode1,不需要复制,因为iNode1至iNode2的路径将被删除
		if (iNodeStart == iNode1) continue
		
		/** 如果iNode1已经拥有此起点,则无需复制 */
		for (iPath2 = ArraySize(arrayStart[0]) - 1; 0 <= iPath2 && ArrayGetCell(arrayStart[0], iPath2) != iNodeStart; iPath2--) { }
		if (0 <= iPath2) continue
		
		ArrayGetArray(gArray_NodePoint, iNodeStart, dest)
		
		// iNodeStart成为iNode1的起点
		ArrayPushCell(arrayStart[0], iNodeStart)
		
		/** 将iNodeStart至iNode2的路径终点改为iNode1,并更新长度 */
		arrayEnd[2]		= ArrayGetCell(gArray_NodeEnd,		iNodeStart)
		arrayDistance[2]	= ArrayGetCell(gArray_NodeDistance,	iNodeStart)
		
		for (iPathTemp = ArraySize(arrayEnd[2]) - 1; 0 <= iPathTemp; iPathTemp--)
		{
			if (ArrayGetCell(arrayEnd[2], iPathTemp) == iNode2)
			{
				ArraySetCell(arrayEnd[2],	iPathTemp,	iNode1)
				ArraySetCell(arrayDistance[2],	iPathTemp,	VecDistance(origin, dest))
				break
			}
		}
	}
	
	/** 变量iNode2的所有终点,复制给iNode1,更新iNode1抵达终点的路径长度 */
	for (iPath = ArraySize(arrayEnd[1]) - 1; 0 <= iPath; iPath--)
	{
		iNodeEnd = ArrayGetCell(arrayEnd[1], iPath)
		
		// 终点是iNode1,不需要复制,因为iNode2至iNode1的路径将被删除
		if (iNodeEnd == iNode1) continue
		
		/** 如果iNode1已经拥有此终点,则无需复制 */
		for (iPath2 = ArraySize(arrayEnd[0]) - 1; 0 <= iPath2 && ArrayGetCell(arrayEnd[0], iPath2) != iNodeEnd; iPath2--) { }
		if (0 <= iPath2) continue
		
		ArrayGetArray(gArray_NodePoint, iNodeEnd, dest)
		
		/** 将iNodeEnd成为iNode1的终点 */
		ArrayPushCell(arrayEnd[0],	iNodeEnd)
		ArrayPushCell(arrayFlags[0],	ArrayGetCell(arrayFlags[1], iPath))
		ArrayPushCell(arrayHeight[0],	ArrayGetCell(arrayHeight[1], iPath))
		ArrayPushCell(arrayDistance[0],	VecDistance(origin, dest))
		
		/** iNodeEnd的起点依然是iNode2,需要改成iNode1 */
		arrayStart[2]		= ArrayGetCell(gArray_NodeStart,	iNodeEnd)
		
		for (iPathTemp = ArraySize(arrayStart[2]) - 1; 0 <= iPathTemp; iPathTemp--)
		{
			if (ArrayGetCell(arrayStart[2], iPathTemp) == iNode2)
			{
				ArraySetCell(arrayStart[2], iPathTemp, iNode1)
				break
			}
		}
	}
	
	NavNode_Delete(iNode2)
	
	return 1
}

NavNode_GetNearest(const Float:origin[3])
{
	new iNodeSelect = -1
	new i, bool:bContain, Float:dist, Float:lastDist, Float:vecDist[3], Float:vecDest[3]
	new bool:ducking, Float:point[3], Float:absMin[3], Float:absMax[3], Float:normal[3]
	
	for (new iNode = ArraySize(gArray_NodeDucking) - 1; 0 <= iNode; iNode--)
	{
		ducking = ArrayGetCell(gArray_NodeDucking, iNode)
		ArrayGetArray(gArray_NodePoint, iNode, point)
		ArrayGetArray(gArray_NodeAbsMin, iNode, absMin)
		ArrayGetArray(gArray_NodeAbsMax, iNode, absMax)
		ArrayGetArray(gArray_NodeNormal, iNode, normal)
		
		for (i = 0; i < 2; i++)
		{
			if (origin[i] < absMin[i])	{ vecDist[i] = absMin[i] - origin[i];	vecDest[i] = absMin[i]; }
			else if (absMax[i] < origin[i])	{ vecDist[i] = origin[i] - absMax[i];	vecDest[i] = absMax[i]; }
			else				{ vecDist[i] = 0.0;			vecDest[i] = origin[i]; }
		}
		
		point[2] -= ducking ? 18.0 : 36.0
		absMin[2] = InclinedPlaneZ(point, normal, origin)
		absMax[2] = absMin[2] + (ducking ? 36.0 : 72.0)
		point[2] = (absMin[2] + absMax[2]) * 0.5
		if (origin[2] < absMin[2])	vecDist[2] = absMin[2] - origin[2]
		else if (absMax[2] < origin[2])	vecDist[2] = origin[2] - absMax[2]
		else				vecDist[2] = 0.0
		
		if (vecDist[0] == 0.0 && vecDist[1] == 0.0 && vecDist[2] == 0.0)
		{
			dist = (point[2] - origin[2]) * (point[2] - origin[2])
			if (dist < lastDist || !bContain) { lastDist = dist; bContain = true; iNodeSelect = iNode; }
			continue
		}
		if (bContain) continue
		
		dist =	(vecDist[0]) * (vecDist[0]) +
			(vecDist[1]) * (vecDist[1]) +
			(vecDist[2]) * (vecDist[2])
		
		if (dist < lastDist || iNodeSelect < 0) { lastDist = dist; iNodeSelect = iNode; }
	}
	
	return iNodeSelect
}

NavNode_GetPathCoord(iNodeStart, iNodeEnd, iPath, Float:start[3], Float:mid[3], Float:end[3])
{
	new Float:nodePoint[2][3], Float:absMin[2][3], Float:absMax[2][3], Float:normal[2][3]
	ArrayGetArray(gArray_NodePoint, iNodeStart, nodePoint[0])
	ArrayGetArray(gArray_NodeAbsMin, iNodeStart, absMin[0])
	ArrayGetArray(gArray_NodeAbsMax, iNodeStart, absMax[0])
	ArrayGetArray(gArray_NodeNormal, iNodeStart, normal[0])
	
	ArrayGetArray(gArray_NodePoint, iNodeEnd, nodePoint[1])
	ArrayGetArray(gArray_NodeAbsMin, iNodeEnd, absMin[1])
	ArrayGetArray(gArray_NodeAbsMax, iNodeEnd, absMax[1])
	ArrayGetArray(gArray_NodeNormal, iNodeEnd, normal[1])
	
	for (new j = 0; j < 2; j++)
	{
		if (nodePoint[1][j] < nodePoint[0][j])	mid[j] = floatmin(nodePoint[0][j], floatmax(nodePoint[1][j], (absMax[1][j] + absMin[0][j]) * 0.5))
		else					mid[j] = floatmax(nodePoint[0][j], floatmin(nodePoint[1][j], (absMax[0][j] + absMin[1][j]) * 0.5))
		if (mid[j] == absMin[0][j])		{ start[j] = absMin[0][j] + 16.0; end[j] = absMin[0][j] - 16.0; }
		else if (mid[j] == absMax[0][j])	{ start[j] = absMax[0][j] - 16.0; end[j] = absMax[0][j] + 16.0; }
		else					{ start[j] = end[j] = mid[j]; }
	}
	
	start[2] = InclinedPlaneZ(nodePoint[0], normal[0], start)
	mid[2] = InclinedPlaneZ(nodePoint[0], normal[0], mid) + Float:ArrayGetCell(ArrayGetCell(gArray_NodeHeight, iNodeStart), iPath)
	end[2] = InclinedPlaneZ(nodePoint[1], normal[1], end)
}

NavNode_GetPathCoord2(iNodeStart, iNodeEnd, iPath, &PathFlags:flags, &Float:height, Float:end[3])
{
	flags	= ArrayGetCell(ArrayGetCell(gArray_NodeFlags, iNodeStart), iPath)
	height	= ArrayGetCell(ArrayGetCell(gArray_NodeHeight, iNodeStart), iPath)
	
	new Float:nodePoint[2][3], Float:absMin[2][3], Float:absMax[2][3], Float:normal[2][3], Float:mid[3]
	ArrayGetArray(gArray_NodePoint, iNodeStart, nodePoint[0])
	ArrayGetArray(gArray_NodeAbsMin, iNodeStart, absMin[0])
	ArrayGetArray(gArray_NodeAbsMax, iNodeStart, absMax[0])
	ArrayGetArray(gArray_NodeNormal, iNodeStart, normal[0])
	
	ArrayGetArray(gArray_NodePoint, iNodeEnd, nodePoint[1])
	ArrayGetArray(gArray_NodeAbsMin, iNodeEnd, absMin[1])
	ArrayGetArray(gArray_NodeAbsMax, iNodeEnd, absMax[1])
	ArrayGetArray(gArray_NodeNormal, iNodeEnd, normal[1])
	
	for (new j = 0; j < 2; j++)
	{
		if (nodePoint[1][j] < nodePoint[0][j])	mid[j] = floatmin(nodePoint[0][j], floatmax(nodePoint[1][j], (absMax[1][j] + absMin[0][j]) * 0.5))
		else					mid[j] = floatmax(nodePoint[0][j], floatmin(nodePoint[1][j], (absMax[0][j] + absMin[1][j]) * 0.5))
		if (mid[j] == absMin[0][j])		end[j] = absMin[0][j] - 16.0
		else if (mid[j] == absMax[0][j])	end[j] = absMax[0][j] + 16.0
		else					end[j] = mid[j]
	}
	
	end[2] = InclinedPlaneZ(nodePoint[1], normal[1], end)
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ ansicpg936\\ deff0{\\ fonttbl{\\ f0\\ fnil\\ fcharset134 Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang2052\\ f0\\ fs16 \n\\ par }
*/


