#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <hamsandwich>
#include <reapi>
#include <xs>
#include <cstrike>
#include <fun>
#include <geoip>
#include <nvault>
#include <NavigationSystem>

enum Attribute
{
	AttIntStart,		// int value start ( like pev_iuser1/pev_solid/pev_movetype )
	Att_Target,
	Att_IUser1,
	Att_IUser2,
	AttIntEnd,		// int value end
	AttFlStart,		// float value start ( like pev_fuser1/pev_health/pev_takedamage )
	Att_FrameTimer,
	Att_FUser1,
	Att_FUser2,
	AttFlEnd,		// float value end
	AttVecStart,		// float[3] start ( like pev_vuser1/pev_angles/pev_velocity )
	Att_VUser1,
	Att_VUser2,
	AttVecEnd		// float[3] end
}


#define PLUGIN "Valorant TDM"
#define VERSION "1.0"
#define AUTHOR "Jenessee"

new GameName[32] = PLUGIN

native is_in_viewcone(entity, const Float:origin[3], use3d = 0);

//#define DEBUG

new Array:ArModel, Array:ArSound
new GTempData[64]

new const UnPrecache_ModelList[ ][ ] = 
{ 
	"models/w_battery.mdl", 
	"models/shield/p_shield_deagle.mdl", 
	"models/shield/p_shield_fiveseven.mdl", 
	"models/shield/p_shield_flashbang.mdl", 
	"models/shield/p_shield_glock18.mdl", 
	"models/shield/p_shield_hegrenade.mdl", 
	"models/shield/p_shield_knife.mdl", 
	"models/shield/p_shield_p228.mdl", 
	"models/shield/p_shield_smokegrenade.mdl", 
	"models/shield/p_shield_usp.mdl", 
	"models/shield/v_shield_deagle.mdl", 
	"models/shield/v_shield_fiveseven.mdl", 
	"models/shield/v_shield_flashbang.mdl", 
	"models/shield/v_shield_glock18.mdl", 
	"models/shield/v_shield_hegrenade.mdl", 
	"models/shield/v_shield_knife.mdl", 
	"models/shield/v_shield_p228.mdl", 
	"models/shield/v_shield_smokegrenade.mdl", 
	"models/shield/v_shield_usp.mdl", 
	"models/w_antidote.mdl", 
	"models/w_security.mdl", 
	"models/w_longjump.mdl", 
	"sprites/WXplo1.spr", 
	"sprites/bubble.spr", 
	"sprites/eexplo.spr", 
	"sprites/fexplo.spr", 
	"sprites/fexplo1.spr", 
	"sprites/b-tele1.spr", 
	"sprites/c-tele1.spr", 
	"sprites/ledglow.spr", 
	"sprites/laserdot.spr", 
	"sprites/explode1.spr",
	"models/shield/p_shield_deagle.mdl",
	"models/shield/p_shield_fiveseven.mdl",
	"models/shield/p_shield_flashbang.mdl",
	"models/shield/p_shield_glock18.mdl",
	"models/shield/p_shield_hegrenade.mdl",
	"models/shield/p_shield_p228.mdl",
	"models/shield/p_shield_smokegrenade.mdl",
	"models/shield/p_shield_usp.mdl",
	"models/shield/v_shield_deagle.mdl",
	"models/shield/v_shield_fiveseven.mdl",
	"models/shield/v_shield_flashbang.mdl",
	"models/shield/v_shield_glock18.mdl",
	"models/shield/v_shield_hegrenade.mdl",
	"models/shield/v_shield_p228.mdl",
	"models/shield/v_shield_smokegrenade.mdl",
	"models/shield/v_shield_usp.mdl",
	"models/shield/v_shield_knife.mdl",
	"models/v_shield.mdl",
	"models/p_shield.mdl",
	"models/w_shield.mdl",
	"models/v_shield_r.mdl",
	"models/p_shield_r.mdl",
	"models/w_shield_r.mdl",
	"models/v_aug.mdl",
	"models/p_aug.mdl ",
	"models/v_c4.mdl",
	"models/p_c4.mdl",
	"models/p_famas.mdl",
	"models/v_famas.mdl",
	"models/p_galil.mdl",
	"models/v_galil.mdl",
	"models/p_glock18.mdl",
	"models/p_m4a1.mdl",
	"models/v_m4a1.mdl",
	"models/v_mac10.mdl",
	"models/p_mac10.mdl",
	"models/p_mp5.mdl",
	"models/v_mp5.mdl",
	"models/v_p228.mdl",
	"models/p_p228.mdl",
	"models/p_p90.mdl",
	"models/v_p90.mdl",
	"models/p_scout.mdl",
	"models/v_scout.mdl",
	"models/v_sg550.mdl",
	"models/p_sg550.mdl",
	"models/p_sg552.mdl",
	"models/v_sg552.mdl",
	"models/v_tmp.mdl",
	"models/p_tmp.mdl",
	"models/v_ump45.mdl",
	"models/p_ump45.mdl",
	"models/p_xm1014.mdl",
	"models/v_xm1014.mdl",
	"sprites/c4.spr",
	"sprites/ic4.spr",
	"sprites/ihostage.spr",
	"sprites/iplayerc4.spr",
	"sprites/iplayervip.spr",
	"sprites/ibackpack.spr"
} 

new const UnPrecache_SoundList[ ][ ] = 
{
	"items/suitcharge1.wav", 
	"items/suitchargeno1.wav", 
	"items/suitchargeok1.wav", 
	"common/wpn_hudoff.wav", 
	"common/wpn_hudon.wav", 
	"common/wpn_moveselect.wav", 
	"player/geiger6.wav", 
	"player/geiger5.wav", 
	"player/geiger4.wav", 
	"player/geiger3.wav", 
	"player/geiger2.wav", 
	"player/geiger1.wav  ", 
	"weapons/bullet_hit1.wav", 
	"weapons/bullet_hit2.wav", 
	"items/weapondrop1.wav", 
	"weapons/generic_reload.wav", 
	"buttons/bell1.wav", 
	"buttons/blip1.wav", 
	"buttons/blip2.wav", 
	"buttons/button11.wav", 
	"buttons/latchunlocked2.wav", 
	"buttons/lightswitch2.wav", 
	"ambience/quail1.wav", 
	"events/tutor_msg.wav", 
	"events/enemy_died.wav", 
	"events/friend_died.wav", 
	"events/task_complete.wav", 
	"weapons/c4_beep1.wav", 
	"weapons/c4_beep2.wav", 
	"weapons/c4_beep3.wav", 
	"weapons/c4_beep4.wav", 
	"weapons/c4_beep5.wav", 
	"weapons/c4_explode1.wav", 
	"weapons/c4_plant.wav", 
	"weapons/c4_disarm.wav", 
	"weapons/c4_disarmed.wav", 
	"items/kevlar.wav", 
	"items/nvg_on.wav",
	"items/nvg_off.wav",
	"items/equip_nvg.wav",
	"ambience/Guit1.wav",
	"ambience/Opera.wav",
	"ambience/Opera.wav",
	"weapons/sg_explode.wav",
	"weapons/p228_clipin.wav",
	"weapons/p228_clipout.wav",
	"weapons/p228_slidepull.wav",
	"weapons/p228_sliderelease.wav",
	"weapons/pinpull.wav",
	"weapons/scout_bolt.wav",
	"weapons/scout_clipin.wav",
	"weapons/scout_clipout.wav",
	"weapons/sg550_clipout.wav",
	"weapons/sg550_boltpull.wav",
	"weapons/sg550_clipin.wav",
	"weapons/sg550_clipout.wav",
	"weapons/aug_boltpull.wav",
	"weapons/aug_boltslap.wav",
	"weapons/aug_forearm.wav",
	"weapons/aug_clipin.wav",
	"weapons/aug_clipout.wav",
	"weapons/p90_boltpull.wav",
	"weapons/p90_clipin.wav",
	"weapons/p90_clipout.wav",
	"weapons/p90_cliprelease.wav",
	"weapons/pinpull.wav",
	"weapons/fiveseven-1.wav",
	"weapons/fiveseven-2.wav",
	"weapons/fiveseven_clipin.wav",
	"weapons/fiveseven_clipout.wav",
	"weapons/fiveseven_slidepull.wav",
	"weapons/fiveseven_sliderelease.wav",
	"weapons/g3sg1_clipin.wav",
	"weapons/g3sg1_clipout.wav",
	"weapons/g3sg1_slide.wav",
	"weapons/sg552_boltpull.wav",
	"weapons/sg552_clipin.wav",
	"weapons/sg552_clipout.wav",
	"weapons/awp_clipin.wav",
	"weapons/awp_clipout.wav",
	"weapons/awp_deploy.wav",
	"weapons/tmp_clipin.wav",
	"weapons/tmp_clipout.wav",
	"weapons/flashbang-1.wav",
	"weapons/flashbang-2.wav",
	"weapons/famas-burst.wav",
	"weapons/famas_boltpull.wav",
	"weapons/famas_boltslap.wav",
	"weapons/famas_clipin.wav",
	"weapons/famas_clipout.wav",
	"weapons/famas_forearm.wav",
	"weapons/mac10_boltpull.wav",
	"weapons/mac10_clipin.wav",
	"weapons/mac10_clipout.wav",
	"weapons/ump45_boltslap.wav",
	"weapons/ump45_clipin.wav",
	"weapons/ump45_clipout.wav",
	"radio/blow.wav",
	"radio/bombdef.wav",
	"radio/bombpl.wav",
	"radio/circleback.wav",
	"radio/clear.wav",
	"radio/com_followcom.wav",
	"radio/com_getinpos.wav",
	"radio/com_go.wav",
	"radio/com_reportin.wav",
	"radio/ct_affirm.wav",
	"radio/ct_backup.wav",
	"radio/ct_coverme.wav",
	"radio/ct_enemys.wav",
	"radio/ct_fireinhole.wav",
	"radio/ct_imhit.wav",
	"radio/ct_inpos.wav",
	"radio/ct_point.wav",
	"radio/ct_reportingin.wav",
	"radio/ctwin.wav",
	"radio/elim.wav",
	"radio/enemydown.wav",
	"radio/fallback.wav",
	"radio/fireassis.wav",
	"radio/flankthem.wav",
	"radio/followme.wav",
	"radio/getout.wav",
	"radio/hitassist.wav",
	"radio/hosdown.wav",
	"radio/letsgo.wav",
	"radio/locknload.wav",
	"radio/matedown.wav",
	"radio/meetme.wav",
	"radio/moveout.wav",
	"radio/negative.wav",
	"radio/position.wav",
	"radio/regroup.wav",
	"radio/rescued.wav",
	"radio/roger.wav",
	"radio/rounddraw.wav",
	"radio/sticktog.wav",
	"radio/stormfront.wav",
	"radio/takepoint.wav",
	"radio/takepoint.wav",
	"radio/terwin.wav",
	"radio/vip.wav",
	"hostage/hos1.wav",
	"hostage/hos2.wav",
	"hostage/hos3.wav",
	"hostage/hos4.wav",
	"hostage/hos5.wav",
	"hostage/hos1.wav",
	"items/tr_kevlar.wav",
	"player/breathe1.wav",
	"player/breathe2.wav",
	"player/pl_fallpain1.wav",
	"player/pl_fallpain2.wav",
	"player/pl_fallpain3.wav",
	"player/gasp1.wav",
	"player/gasp2.wav",	 
	"weapons/ak47_clipout.wav", 
	"weapons/ak47_clipin.wav", 
	"weapons/ak47_boltpull.wav", 
	"weapons/aug_clipout.wav", 
	"weapons/aug_clipin.wav", 
	"weapons/aug_boltpull.wav", 
	"weapons/aug_boltslap.wav", 
	"weapons/aug_forearm.wav", 
	"weapons/c4_click.wav", 
	"weapons/c4_beep1.wav", 
	"weapons/c4_beep2.wav", 
	"weapons/c4_beep3.wav", 
	"weapons/c4_beep4.wav", 
	"weapons/c4_beep5.wav", 
	"weapons/c4_explode1.wav", 
	"weapons/c4_plant.wav", 
	"weapons/c4_disarm.wav", 
	"weapons/c4_disarmed.wav", 
	"weapons/elite_reloadstart.wav", 
	"weapons/elite_leftclipin.wav", 
	"weapons/elite_clipout.wav", 
	"weapons/elite_sliderelease.wav", 
	"weapons/elite_rightclipin.wav", 
	"weapons/elite_deploy.wav", 
	"weapons/famas_clipout.wav", 
	"weapons/famas_clipin.wav", 
	"weapons/famas_boltpull.wav", 
	"weapons/famas_boltslap.wav", 
	"weapons/famas_forearm.wav", 
	"weapons/g3sg1_slide.wav", 
	"weapons/g3sg1_clipin.wav", 
	"weapons/g3sg1_clipout.wav", 
	"weapons/galil_clipout.wav", 
	"weapons/galil_clipin.wav", 
	"weapons/galil_boltpull.wav", 
	"weapons/m4a1_clipin.wav", 
	"weapons/m4a1_clipout.wav", 
	"weapons/m4a1_boltpull.wav", 
	"weapons/m4a1_deploy.wav", 
	"weapons/m4a1_silencer_on.wav", 
	"weapons/m4a1_silencer_off.wav", 
	"weapons/m249_boxout.wav", 
	"weapons/m249_boxin.wav", 
	"weapons/m249_chain.wav", 
	"weapons/m249_coverup.wav", 
	"weapons/m249_coverdown.wav", 
	"weapons/mac10_clipout.wav", 
	"weapons/mac10_clipin.wav", 
	"weapons/mac10_boltpull.wav", 
	"weapons/mp5_clipout.wav", 
	"weapons/mp5_clipin.wav", 
	"weapons/mp5_slideback.wav", 
	"weapons/p90_clipout.wav", 
	"weapons/p90_clipin.wav", 
	"weapons/p90_boltpull.wav", 
	"weapons/p90_cliprelease.wav", 
	"weapons/p228_clipout.wav", 
	"weapons/p228_clipin.wav", 
	"weapons/p228_sliderelease.wav", 
	"weapons/p228_slidepull.wav", 
	"weapons/scout_bolt.wav", 
	"weapons/scout_clipin.wav", 
	"weapons/scout_clipout.wav", 
	"weapons/sg550_boltpull.wav", 
	"weapons/sg550_clipin.wav", 
	"weapons/sg550_clipout.wav", 
	"weapons/sg552_clipout.wav", 
	"weapons/sg552_clipin.wav", 
	"weapons/sg552_boltpull.wav", 
	"weapons/ump45_clipout.wav", 
	"weapons/ump45_clipin.wav", 
	"weapons/ump45_boltslap.wav", 
	"weapons/usp_clipout.wav", 
	"weapons/usp_clipin.wav", 
	"weapons/usp_silencer_on.wav", 
	"weapons/usp_silencer_off.wav", 
	"weapons/usp_sliderelease.wav", 
	"weapons/usp_slideback.wav", 
	"weapons/fiveseven_slidepull.wav", 
	"weapons/fiveseven_sliderelease.wav", 
	"weapons/de_clipout.wav", 
	"weapons/de_clipin.wav", 
	"weapons/de_deploy.wav", 
	"weapons/sliderelease1.wav", 
	"weapons/slideback1.wav", 
	"weapons/357_cock1.wav", 
	"weapons/pinpull.wav", 
	"common/bodydrop3.wav", 
	"common/bodydrop4.wav",
	"weapons/ak47-1.wav", 
	"weapons/ak47-2.wav", 
	"weapons/aug-1.wav", 
	"weapons/awp1.wav", 
	"weapons/deagle-1.wav", 
	"weapons/deagle-2.wav", 
	"weapons/famas-1.wav", 
	"weapons/famas-2.wav", 
	"weapons/famas-burst.wav",
	"weapons/fiveseven-1.wav", 
	"weapons/flashbang-1.wav", 
	"weapons/flashbang-2.wav", 
	"weapons/g3sg1-1.wav", 
	"weapons/galil-1.wav", 
	"weapons/galil-2.wav", 
	"weapons/glock18-1.wav", 
	"weapons/glock18-2.wav", 
	"weapons/knife_deploy1.wav", 
	"weapons/knife_hit1.wav", 
	"weapons/knife_hit2.wav", 
	"weapons/knife_hit3.wav", 
	"weapons/knife_hit4.wav", 
	"weapons/knife_hitwall1.wav", 
	"weapons/knife_slash1.wav", 
	"weapons/knife_slash2.wav", 
	"weapons/knife_stab.wav", 
	"weapons/m3-1.wav", 
	"weapons/m4a1-1.wav", 
	"weapons/m4a1_unsil-1.wav", 
	"weapons/m4a1_unsil-2.wav", 
	"weapons/m249-1.wav", 
	"weapons/m249-2.wav", 
	"weapons/mac10-1.wav", 
	"weapons/mp5-1.wav", 
	"weapons/mp5-2.wav", 
	"weapons/p90-1.wav", 
	"weapons/p228-1.wav", 
	"weapons/scout_fire-1.wav", 
	"weapons/sg_explode.wav", 
	"weapons/sg550-1.wav", 
	"weapons/sg552-1.wav", 
	"weapons/sg552-2.wav", 
	"weapons/tmp-1.wav", 
	"weapons/tmp-2.wav", 
	"weapons/ump45-1.wav", 
	"weapons/usp_unsil-1.wav", 
	"weapons/usp_unsil-2.wav", 
	"weapons/usp1.wav", 
	"weapons/usp2.wav", 
	"weapons/xm1014-1.wav"
} 


enum
{
	AGENT_JETT = 0,
	AGENT_REYNA,
	AGENT_RAZE,
	AGENT_FADE,
	AGENT_DEADLOCK
}

enum
{
	QUOTE_KILL_HEADSHOT = 0,
	QUOTE_KILL,
	QUOTE_3KILL,
	QUOTE_4KILL,
	QUOTE_5KILL,
	QUOTE_ACE,

	QUOTE_PAIN_HEAD,
	QUOTE_PAIN,

	QUOTE_ALMOST_WIN,
	QUOTE_HEALING,

	QUOTE_WIN,

	QUOTE_CANTUSE,
	QUOTE_ULTREADY,
	QUOTE_SKILL1,
	QUOTE_SKILL2
}

new const Agent_Quote_HeadShotKill[][] = 
{
	{AGENT_JETT, "jett/headshot1"},
	{AGENT_JETT, "jett/headshot2"},
	{AGENT_JETT, "jett/headshot3"},
	{AGENT_JETT, "jett/headshot4"},
	{AGENT_JETT, "jett/headshot5"},
	{AGENT_JETT, "jett/headshot6"},

	{AGENT_REYNA, "reyna/headshot1"},
	{AGENT_REYNA, "reyna/headshot2"},
	{AGENT_REYNA, "reyna/headshot3"},
	{AGENT_REYNA, "reyna/headshot4"},
	{AGENT_REYNA, "reyna/headshot5"},
	{AGENT_REYNA, "reyna/headshot6"},
	{AGENT_REYNA, "reyna/headshot7"},

	{AGENT_RAZE, "raze/headshot1"},
	{AGENT_RAZE, "raze/headshot2"},
	{AGENT_RAZE, "raze/headshot3"},
	{AGENT_RAZE, "raze/headshot4"},
	{AGENT_RAZE, "raze/headshot5"},
	{AGENT_RAZE, "raze/headshot6"},

	{AGENT_FADE, "fade/headshot1"},
	{AGENT_FADE, "fade/headshot2"},
	{AGENT_FADE, "fade/headshot3"},
	{AGENT_FADE, "fade/headshot4"},
	{AGENT_FADE, "fade/headshot5"},
	{AGENT_FADE, "fade/headshot6"},

	{AGENT_DEADLOCK, "deadlock/headshot1"},
	{AGENT_DEADLOCK, "deadlock/headshot2"},
	{AGENT_DEADLOCK, "deadlock/headshot3"},
	{AGENT_DEADLOCK, "deadlock/headshot4"},
	{AGENT_DEADLOCK, "deadlock/headshot5"},
	{AGENT_DEADLOCK, "deadlock/headshot6"}
}

new const Agent_Quote_Kill[][] = 
{
	{AGENT_JETT, "jett/kill1"},
	{AGENT_JETT, "jett/kill2"},
	{AGENT_JETT, "jett/kill3"},
	{AGENT_JETT, "jett/kill4"},
	{AGENT_JETT, "jett/kill5"},
	{AGENT_JETT, "jett/kill6"},
	{AGENT_JETT, "jett/kill7"},
	{AGENT_JETT, "jett/kill8"},
	{AGENT_JETT, "jett/kill9"},
	{AGENT_JETT, "jett/kill10"},

	{AGENT_REYNA, "reyna/kill1"},
	{AGENT_REYNA, "reyna/kill2"},
	{AGENT_REYNA, "reyna/kill3"},
	{AGENT_REYNA, "reyna/kill4"},
	{AGENT_REYNA, "reyna/kill5"},
	{AGENT_REYNA, "reyna/kill6"},
	{AGENT_REYNA, "reyna/kill7"},
	{AGENT_REYNA, "reyna/kill8"},
	{AGENT_REYNA, "reyna/kill9"},
	{AGENT_REYNA, "reyna/kill10"},
	{AGENT_REYNA, "reyna/kill11"},
	{AGENT_REYNA, "reyna/kill12"},

	{AGENT_RAZE, "raze/kill1"},
	{AGENT_RAZE, "raze/kill2"},
	{AGENT_RAZE, "raze/kill3"},
	{AGENT_RAZE, "raze/kill4"},
	{AGENT_RAZE, "raze/kill5"},
	{AGENT_RAZE, "raze/kill6"},
	{AGENT_RAZE, "raze/kill7"},
	{AGENT_RAZE, "raze/kill8"},
	{AGENT_RAZE, "raze/kill9"},
	{AGENT_RAZE, "raze/kill10"},

	{AGENT_FADE, "fade/kill1"},
	{AGENT_FADE, "fade/kill2"},
	{AGENT_FADE, "fade/kill3"},
	{AGENT_FADE, "fade/kill4"},
	{AGENT_FADE, "fade/kill5"},
	{AGENT_FADE, "fade/kill6"},
	{AGENT_FADE, "fade/kill7"},
	{AGENT_FADE, "fade/kill8"},
	{AGENT_FADE, "fade/kill9"},
	{AGENT_FADE, "fade/kill10"},

	{AGENT_DEADLOCK, "deadlock/kill1"},
	{AGENT_DEADLOCK, "deadlock/kill2"},
	{AGENT_DEADLOCK, "deadlock/kill3"},
	{AGENT_DEADLOCK, "deadlock/kill4"},
	{AGENT_DEADLOCK, "deadlock/kill5"},
	{AGENT_DEADLOCK, "deadlock/kill6"},
	{AGENT_DEADLOCK, "deadlock/kill7"},
	{AGENT_DEADLOCK, "deadlock/kill8"},
	{AGENT_DEADLOCK, "deadlock/kill9"},
	{AGENT_DEADLOCK, "deadlock/kill10"},
	{AGENT_DEADLOCK, "deadlock/kill11"}
}

new const Agent_Quote_3Kill[][] = 
{
	{AGENT_JETT, "jett/3kill"},
	{AGENT_JETT, "jett/3kill2"},

	{AGENT_REYNA, "reyna/3kill"},
	{AGENT_REYNA, "reyna/3kill2"},

	{AGENT_RAZE, "raze/3kill"},
	{AGENT_RAZE, "raze/3kill2"},

	{AGENT_FADE, "fade/3kill"},
	{AGENT_FADE, "fade/3kill2"},

	{AGENT_DEADLOCK, "deadlock/3kill"},
	{AGENT_DEADLOCK, "deadlock/3kill2"}
}

new const Agent_Quote_4Kill[][] = 
{
	{AGENT_JETT, "jett/4kill"},
	{AGENT_JETT, "jett/4kill2"},

	{AGENT_REYNA, "reyna/4kill"},
	{AGENT_REYNA, "reyna/4kill2"},

	{AGENT_RAZE, "raze/4kill"},
	{AGENT_RAZE, "raze/4kill2"},

	{AGENT_FADE, "fade/4kill"},
	{AGENT_FADE, "fade/4kill2"},

	{AGENT_DEADLOCK, "deadlock/4kill"},
	{AGENT_DEADLOCK, "deadlock/4kill2"}
}

new const Agent_Quote_5Kill[][] = 
{
	{AGENT_JETT, "jett_bela1"},
	{AGENT_JETT, "jett_bela2"},

	{AGENT_REYNA, "reyna_bela1"},
	{AGENT_REYNA, "reyna_bela2"},

	{AGENT_RAZE, "raze_bela1"},
	{AGENT_RAZE, "raze_bela2"},

	{AGENT_FADE, "fade_bela1"},
	{AGENT_FADE, "fade_bela2"},

	{AGENT_DEADLOCK, "deadlock_bela1"},
	{AGENT_DEADLOCK, "deadlock_bela2"}
}

new const Agent_Quote_Ace[][] = 
{
	{AGENT_JETT, "jett/5kill"},

	{AGENT_REYNA, "reyna/5kill"},
	{AGENT_REYNA, "reyna/5kill2"},
	{AGENT_REYNA, "reyna/5kill3"},
	{AGENT_REYNA, "reyna/5kill4"},
	{AGENT_REYNA, "reyna/5kill5"},

	{AGENT_RAZE, "raze/5kill"},
	{AGENT_RAZE, "raze/5kill2"},

	{AGENT_FADE, "fade/5kill"},
	{AGENT_FADE, "fade/5kill2"},

	{AGENT_DEADLOCK, "deadlock/5kill"},
	{AGENT_DEADLOCK, "deadlock/5kill2"},
	{AGENT_DEADLOCK, "deadlock/5kill3"},
	{AGENT_DEADLOCK, "deadlock/5kill4"}
}

new const Agent_Quote_AlmostWin[][] = 
{
	{AGENT_JETT, "jett/almostwin"},
	{AGENT_JETT, "jett/almostwin2"},

	{AGENT_REYNA, "reyna/almostwin"},
	{AGENT_REYNA, "reyna/almostwin2"},

	{AGENT_RAZE, "raze/almostwin"},
	{AGENT_RAZE, "raze/almostwin2"},

	{AGENT_FADE, "fade/almostwin"},
	{AGENT_FADE, "fade/almostwin2"},

	{AGENT_DEADLOCK, "deadlock/almostwin"},
	{AGENT_DEADLOCK, "deadlock/almostwin2"}
}

new const Agent_Quote_Death[][] = 
{
	{AGENT_JETT, "jett/death1"},
	{AGENT_JETT, "jett/death2"},
	{AGENT_JETT, "jett/death3"},

	{AGENT_REYNA, "reyna/death1"},
	{AGENT_REYNA, "reyna/death2"},
	{AGENT_REYNA, "reyna/death3"},

	{AGENT_RAZE, "raze/death1"},
	{AGENT_RAZE, "raze/death2"},
	{AGENT_RAZE, "raze/death3"},

	{AGENT_FADE, "fade/death1"},
	{AGENT_FADE, "fade/death2"},
	{AGENT_FADE, "fade/death3"},

	{AGENT_DEADLOCK, "deadlock/death1"},
	{AGENT_DEADLOCK, "deadlock/death2"},
	{AGENT_DEADLOCK, "deadlock/death3"}
}

new const Agent_Quote_PainBody[][] = 
{
	{AGENT_JETT, "jett/pain1"},
	{AGENT_JETT, "jett/pain2"},
	{AGENT_JETT, "jett/pain3"},

	{AGENT_REYNA, "reyna/pain1"},
	{AGENT_REYNA, "reyna/pain2"},
	{AGENT_REYNA, "reyna/pain3"},

	{AGENT_RAZE, "raze/pain1"},
	{AGENT_RAZE, "raze/pain2"},
	{AGENT_RAZE, "raze/pain3"},

	{AGENT_FADE, "fade/pain1"},
	{AGENT_FADE, "fade/pain2"},
	{AGENT_FADE, "fade/pain3"},

	{AGENT_DEADLOCK, "deadlock/pain1"},
	{AGENT_DEADLOCK, "deadlock/pain2"},
	{AGENT_DEADLOCK, "deadlock/pain3"}
}

new const Agent_Quote_PainHead[][] = 
{
	{AGENT_JETT, "jett/head1"},
	{AGENT_JETT, "jett/head2"},
	{AGENT_JETT, "jett/head3"},

	{AGENT_REYNA, "reyna/head1"},
	{AGENT_REYNA, "reyna/head2"},
	{AGENT_REYNA, "reyna/head3"},

	{AGENT_RAZE, "raze/head1"},
	{AGENT_RAZE, "raze/head2"},
	{AGENT_RAZE, "raze/head3"},

	{AGENT_FADE, "fade/head1"},
	{AGENT_FADE, "fade/head2"},
	{AGENT_FADE, "fade/head3"},

	{AGENT_DEADLOCK, "deadlock/head1"},
	{AGENT_DEADLOCK, "deadlock/head2"},
	{AGENT_DEADLOCK, "deadlock/head3"}
}

new const Agent_Quote_Healing[][] = 
{
	{AGENT_JETT, "jett/heal1"},
	{AGENT_JETT, "jett/heal2"},
	{AGENT_JETT, "jett/heal3"},

	{AGENT_REYNA, "reyna/heal1"},
	{AGENT_REYNA, "reyna/heal2"},
	{AGENT_REYNA, "reyna/heal3"},

	{AGENT_RAZE, "raze/heal1"},
	{AGENT_RAZE, "raze/heal2"},
	{AGENT_RAZE, "raze/heal3"},

	{AGENT_FADE, "fade/heal1"},
	{AGENT_FADE, "fade/heal2"},
	{AGENT_FADE, "fade/heal3"},

	{AGENT_DEADLOCK, "deadlock/heal1"},
	{AGENT_DEADLOCK, "deadlock/heal2"},
	{AGENT_DEADLOCK, "deadlock/heal3"}
}

new const Agent_Quote_CantUse[][] = 
{
	{AGENT_JETT, "jett/cantuse"},
	{AGENT_JETT, "jett/cantuse2"},

	{AGENT_REYNA, "reyna/cantuse"},
	{AGENT_REYNA, "reyna/cantuse2"},

	{AGENT_RAZE, "raze/cantuse"},
	{AGENT_RAZE, "raze/cantuse2"},

	{AGENT_FADE, "fade/cantuse"},
	{AGENT_FADE, "fade/cantuse2"},

	{AGENT_DEADLOCK, "deadlock/cantuse"},
	{AGENT_DEADLOCK, "deadlock/cantuse2"},
}

new const Agent_Quote_UltReady[][] = 
{
	{AGENT_JETT, "jett/ultready"},
	{AGENT_JETT, "jett/ultready2"},

	{AGENT_REYNA, "reyna/ultready"},
	{AGENT_REYNA, "reyna/ultready2"},

	{AGENT_RAZE, "raze/ultready"},
	{AGENT_RAZE, "raze/ultready2"},

	{AGENT_FADE, "fade/ultready"},
	{AGENT_FADE, "fade/ultready2"},

	{AGENT_DEADLOCK, "deadlock/ultready"},
	{AGENT_DEADLOCK, "deadlock/ultready2"},
}

new const Agent_Quote_Skill1[][] = 
{
	{AGENT_JETT, "jett/dash1"},
	{AGENT_JETT, "jett/dash2"},
	{AGENT_JETT, "jett/dash3"},

	{AGENT_REYNA, "reyna/leer_throw1"},
	{AGENT_REYNA, "reyna/leer_throw2"},
	{AGENT_REYNA, "reyna/leer_throw3"},
	{AGENT_REYNA, "reyna/leer_throw4"},

	{AGENT_RAZE, "raze/bomb_throw"},
	{AGENT_RAZE, "raze/bomb_throw2"},
	{AGENT_RAZE, "raze/bomb_throw3"},

	{AGENT_FADE, "fade/release_wolf1"},
	{AGENT_FADE, "fade/release_wolf2"},

	{AGENT_DEADLOCK, "deadlock/barrier_badcast"},
	{AGENT_DEADLOCK, "deadlock/barrier_badcast2"},
}

new const Agent_Quote_Skill2[][] = 
{
	{AGENT_RAZE, "raze/bomb_kill1"},
	{AGENT_RAZE, "raze/bomb_kill2"},
	{AGENT_RAZE, "raze/bomb_kill3"},
	{AGENT_RAZE, "raze/bomb_kill4"},
	{AGENT_RAZE, "raze/bomb_kill5"},
	{AGENT_RAZE, "raze/bomb_kill6"},
	{AGENT_RAZE, "raze/bomb_kill7"},
	{AGENT_RAZE, "raze/bomb_kill8"},

	{AGENT_FADE, "fade/wolf_found_enemy1"},
	{AGENT_FADE, "fade/wolf_found_enemy2"},

	{AGENT_DEADLOCK, "deadlock/revive"}
}

new const Agent_Quote_Selected[][] = 
{
	"jett/selected",
	"reyna/selected",
	"raze/selected",
	"fade/selected",
	"deadlock/selected"
}

new const Agent_Quote_Win[][] = 
{
	{AGENT_JETT, "jett/win1"},
	{AGENT_JETT, "jett/win2"},
	{AGENT_JETT, "jett/win3"},

	{AGENT_REYNA, "reyna/win1"},
	{AGENT_REYNA, "reyna/win2"},
	{AGENT_REYNA, "reyna/win3"},
	{AGENT_REYNA, "reyna/win4"},

	{AGENT_RAZE, "raze/win1"},
	{AGENT_RAZE, "raze/win2"},
	{AGENT_RAZE, "raze/win3"},
	{AGENT_RAZE, "raze/win4"},

	{AGENT_FADE, "fade/win1"},
	{AGENT_FADE, "fade/win2"},
	{AGENT_FADE, "fade/win3"},

	{AGENT_DEADLOCK, "deadlock/win1"},
	{AGENT_DEADLOCK, "deadlock/win2"},
	{AGENT_DEADLOCK, "deadlock/win3"}
}

enum 
{
	PLAYER_MODEL = 0,
	NAME,
	ARES,
	BUCKY,
	BULLDOG,
	CLASSIC,
	FRENZY,
	GHOST,
	GUARDIAN,
	JUDGE,
	KNIFE,
	MARSHALL,
	ODIN,
	OPERATOR,
	PHANTOM,
	SHERRIF,
	SHORTY,
	SPECTRE, 
	STINGER,
	VANDAL
}

new const Agent_Info[][][] = 
{
	{"valorant_jett4", "Jett", "v_aresfx", "v_bucky", "v_bulldog", "v_classic", "v_frenzyfx", "v_ghost", "v_guardian", "v_judge", "v_knife_base", "v_marshall", "v_odinfx", "v_operatorfx2", "v_phantom", "v_sherriffx", "v_shorty", "v_spectrefx", "v_stingerfx", "v_vandal"},
	{"valorant_reyna", "Reyna", "v_ares2fx", "v_bucky2", "v_bulldog2", "v_classic2", "v_frenzy2fx", "v_ghost2", "v_guardian2", "v_judge2", "v_knife_base2", "v_marshall2", "v_odin2fx", "v_operatorfx3", "v_phantom2", "v_sherrif2fx", "v_shorty2", "v_spectre2fx", "v_stinger2fx", "v_vandal2"},
	{"valorant_raze", "Raze", "v_aresfx", "v_bucky", "v_bulldog", "v_classic", "v_frenzyfx", "v_ghost", "v_guardian", "v_judge", "v_knife_base", "v_marshall", "v_odinfx", "v_operatorfx2", "v_phantom", "v_sherriffx", "v_shorty", "v_spectrefx", "v_stingerfx", "v_vandal"},
	{"valorant_fade", "Fade", "v_aresfx", "v_bucky", "v_bulldog", "v_classic", "v_frenzyfx", "v_ghost", "v_guardian", "v_judge", "v_knife_base", "v_marshall", "v_odinfx", "v_operatorfx2", "v_phantom", "v_sherriffx", "v_shorty", "v_spectrefx", "v_stingerfx", "v_vandal"},
	{"valorant_deadlock", "Deadlock", "v_ares2fx", "v_bucky2", "v_bulldog2", "v_classic2", "v_frenzy2fx", "v_ghost2", "v_guardian2", "v_judge2", "v_knife_base2", "v_marshall2", "v_odin2fx", "v_operatorfx3", "v_phantom2", "v_sherrif2fx", "v_shorty2", "v_spectre2fx", "v_stinger2fx", "v_vandal2"}
}

enum skillInfo
{
	SKILL_SPRITE[32],
	SKILL_NAME[32],
	SKILL_VIEWMODEL[128],
	SKILL_PMODEL[128],
	SKILL_PLAYERANIMATION[32],
	SKILL_COOLDOWN,
	SKILL_SPEED
}

new const Agent_Skills[][skillInfo] = 
{
	{"skill_dash", "SKILL_DASH", "v_jett_dash", "", "", 10, 1},
	{"skill_leer", "SKILL_LEER", "v_reyna_leer", "", "", 18, 260},
	{"skill_bomb", "SKILL_BOMB", "v_raze_bomb", "p_raze_bomb", "", 15, 260},
	{"skill_prowler", "SKILL_PROWLER", "v_fade_prowler", "", "", 20, 260},
	{"skill_point", "SKILL_POINT", "v_deadlock_barrier", "p_deadlock_barrier", "c4", 22, 260}
}

new const Skill_Resources[][] = 
{
	"Jenessee_Valorant/skill/jett_dash_back.wav", // 0
	"Jenessee_Valorant/skill/jett_dash_forward.wav", // 1

	"models/Jenessee_Valorant/skills/jett_dash_animation.mdl", // 2

	"Jenessee_Valorant/skill/ult_ready.wav", // 3

	"models/Jenessee_Valorant/skills/w_raze_bomb.mdl", // 4

	"Jenessee_Valorant/skill/raze_bomb_beep_1.wav", // 5
	"Jenessee_Valorant/skill/raze_bomb_pre_explode.wav", // 6
	"Jenessee_Valorant/skill/raze_bomb_first_explode.wav", // 7
	"models/Jenessee_Valorant/skills/raze_bomb_first_explosion.mdl", // 8
	"Jenessee_Valorant/skill/raze_bomb_beep_2.wav", // 9

	"Jenessee_Valorant/skill/raze_bomb_mini_exp1.wav", // 10
	"Jenessee_Valorant/skill/raze_bomb_mini_exp2.wav", // 11
	"Jenessee_Valorant/skill/raze_bomb_mini_exp3.wav", // 12
	"models/Jenessee_Valorant/skills/raze_bomb_second_explosion.mdl", // 13

	"sprites/Jenessee_Valorant/reyna_leer_start.spr", // 14
	"sprites/Jenessee_Valorant/reyna_leer.spr", // 15
	"models/Jenessee_Valorant/skills/reyna_leer_helper.mdl", // 16

	"models/Jenessee_Valorant/skills/w_raze_bomb_small.mdl", // 17
	"models/Jenessee_Valorant/skills/sky.mdl", // 18
	"Jenessee_Valorant/skill/reyna_leer_blind_start.wav", // 19
	"Jenessee_Valorant/skill/reyna_leer_blind_end.wav", // 20
	"models/Jenessee_Valorant/skills/reyna_eye_projectile.mdl", // 21
	"Jenessee_Valorant/skill/reyna_leer_projectile_ally.wav", // 22
	"Jenessee_Valorant/skill/reyna_leer_projectile_enemy.wav", // 23
	"Jenessee_Valorant/skill/reyna_eyeform_ally.wav", // 24
	"Jenessee_Valorant/skill/reyna_eyeform_enemy.wav", // 25
	"Jenessee_Valorant/skill/reyna_leer_removed.wav", // 26
	"models/Jenessee_Valorant/skills/reyna_leer_explo.mdl", // 27

	"models/Jenessee_Valorant/skills/w_deadlock_barrier.mdl", // 28
	"models/Jenessee_Valorant/skills/deadlock_revive_effect.mdl", // 29
	"models/Jenessee_Valorant/skills/deadlock_revive.mdl", // 30

	"Jenessee_Valorant/skill/deadlock_barrier_projectile.wav", // 31
	"Jenessee_Valorant/skill/deadlock_barrier_active2.wav", // 32
	"Jenessee_Valorant/skill/deadlock_barrier_idle.wav", // 33 // 21 saniye
	"Jenessee_Valorant/skill/deadlock_barrier_removed.wav", // 34
	"Jenessee_Valorant/skill/player_revive.wav", // 35
	"models/Jenessee_Valorant/skills/w_deadlock_barrier2.mdl", // 36
	"models/Jenessee_Valorant/skills/deadlock_barrier_explode.mdl", // 37
	"Jenessee_Valorant/skill/reyna_leer_bullet_hit.wav", // 38
	"models/Jenessee_Valorant/skills/reyna_eye_blind.mdl", // 39

	"models/Jenessee_Valorant/skills/fade_prowler.mdl", // 40
	"models/Jenessee_Valorant/skills/fade_prowler_death.mdl", // 41
	"models/Jenessee_Valorant/skills/fade_prowler_hit.mdl", // 42

	"Jenessee_Valorant/skill/fade_wolf_move_normal1.wav", // 43
	"Jenessee_Valorant/skill/fade_wolf_move_normal2.wav", // 44
	"Jenessee_Valorant/skill/fade_wolf_move_normal3.wav", // 45
	"Jenessee_Valorant/skill/fade_wolf_move_normal4.wav", // 46

	"Jenessee_Valorant/skill/fade_wolf_found_enemy.wav", // 47
	"Jenessee_Valorant/skill/fade_wolf_found_enemy2.wav", // 48

	"Jenessee_Valorant/skill/fade_wolf_follow_enemy.wav", // 49
	"Jenessee_Valorant/skill/fade_wolf_follow_enemy2.wav", // 50
	"Jenessee_Valorant/skill/fade_wolf_follow_enemy3.wav", // 51

	"Jenessee_Valorant/skill/fade_wolf_death.wav", // 52
	"Jenessee_Valorant/skill/fade_wolf_timeout.wav", // 53

	"Jenessee_Valorant/skill/fade_wolf_bite.wav", // 54
	"Jenessee_Valorant/skill/fade_wolf_bite_confirmed.wav", // 55

	"Jenessee_Valorant/skill/fade_wolf_bullet_hit.wav", // 56
	"valorant_jett_dash" // 57
}

new const Agent_BodyCode[] = 
{
	242,
	0,
	121,
	0,
	15
}

enum weaponInfo
{
	WEAPON_NAME[32],
	WEAPON_SPRITE_NAME[32],
	WEAPON_ENTITY_NAME[32],
	WEAPON_P_MODEL[32],
	WEAPON_D_MODEL[32],
	WEAPON_PLAYER_ANIM[32],
	WEAPON_STAGE_LEVEL,
	WEAPON_AMMO,
	WEAPON_BPAMMO,
	HEADSHOT_DAMAGE,
	BODY_DAMAGE,
	LEG_DAMAGE,
	WEAPON_SPEED,
	INSPECT_ANIM,
	INSPECT_ANIM_FAST
}

enum 
{
	ASAMA_YOK = -1,
	ASAMA_1 = 0,
	ASAMA_2,
	ASAMA_3,
	ASAMA_FINAL
}

enum crossInfo
{
	CROSSHAIR_NAME[32],
	CROSSHAIR_SPRITE[32]
}

new const Crosshair_Info[][crossInfo] = 
{
	{"CROSSHAIR_WEAPON", ""}, // 0
	{"CROSSHAIR_NOKTA", "crosshair_nokta"}, // 1
	{"CROSSHAIR_NOKTA2", "crosshair_nokta2"}, // 1
	{"CROSSHAIR_ARTI1", "crosshair_arti1"}, // 2
	{"CROSSHAIR_ARTI2", "crosshair_arti2"}, // 3
	{"CROSSHAIR_ARTI3", "crosshair_arti3"}, // 4
	{"CROSSHAIR_ARTI4", "crosshair_arti4"}, // 5
	{"CROSSHAIR_ARTI5", "crosshair_arti5"}, // 6
	{"CROSSHAIR_ARTI6", "crosshair_arti6"}, // 7
	{"CROSSHAIR_ARTI7", "crosshair_arti7"}, // 8
	{"CROSSHAIR_ARTI8", "crosshair_arti8"}, // 9
	{"CROSSHAIR_ARTI9", "crosshair_arti9"}, // 10
	{"CROSSHAIR_ARTI10", "crosshair_arti10"}, // 11
	{"CROSSHAIR_ARTI11", "crosshair_arti11"}, // 12
	{"CROSSHAIR_ARTI12", "crosshair_arti12"}, // 13
	{"CROSSHAIR_ARTI13", "crosshair_arti13"}, // 14
	{"CROSSHAIR_ARTI14", "crosshair_arti14"} // 15
}

new const Weapon_Info[][weaponInfo] = 
{
	{"", "", "", "", "", 0, 0, 0, 0, 0, 0, 0, 0}, // 0
	{"", "", "", "", "", 0, 0, 0, 0, 0, 0, 0, 0}, // 1
	{"Ares", "weapon_ares", "weapon_m249", "p_ares", "d_ares", "m249", ASAMA_1, 50, 50, 72, 30, 25, 220, 10, 11}, // 2
	{"Bucky", "weapon_bucky", "weapon_m3", "p_bucky", "d_bucky", "shotgun", ASAMA_2, 5, 5, 40, 20, 17, 240, 13, 14}, // 3
	{"Bulldog", "weapon_bulldog", "weapon_aug", "p_bulldog", "d_bulldog", "rifle", ASAMA_2, 24, 24, 115, 35, 29, 240, 10, 11}, // 4
	{"Classic", "weapon_classic", "weapon_deagle", "p_classic", "", "onehanded", ASAMA_YOK, 12, 12, 78, 26, 22, 250, 7, 8}, // 5
	{"Frenzy", "weapon_frenzy", "weapon_deagle", "p_frenzy2", "", "onehanded", ASAMA_YOK, 13, 13, 78, 26, 22, 250, 7, 8}, // 6
	{"Ghost", "weapon_ghost", "weapon_deagle", "p_ghost", "", "onehanded", ASAMA_YOK, 15, 15, 105, 30, 25, 250, 7, 8}, // 7
	{"Guardian", "weapon_guardian", "weapon_galil", "p_guardian", "d_guardian", "rifle", ASAMA_2, 12, 12, 195, 65, 49, 230, 10, 11}, // 8
	{"Judge", "weapon_judge", "weapon_xm1014", "p_judge", "d_judge", "m249", ASAMA_3, 7, 7, 34, 17, 14, 230, 7, 8}, // 9
	{"Knife", "weapon_knife_base", "weapon_knife", "p_knife_base", "", "knife", ASAMA_YOK, 0, 0, 0, 75, 50, 260, 9, 10}, // 10
	{"Marshall", "weapon_marshall", "weapon_scout", "p_marshall", "d_marshall", "rifle", ASAMA_1, 5, 5, 202, 101, 85, 240, 10, 11}, // 11
	{"Odin", "weapon_odin", "weapon_m249", "p_odin", "d_odin", "m134", ASAMA_FINAL, 100, 100, 95, 38, 32, 210, 10, 11}, // 12
	{"Operator", "weapon_operator", "weapon_awp", "p_operator", "d_operator", "rifle", ASAMA_FINAL, 5, 5, 255, 150, 120, 220, 7, 8}, // 13
	{"Phantom", "weapon_phantom", "weapon_m4a1", "p_phantom", "d_phantom", "rifle", ASAMA_3, 30, 30, 156, 39, 33, 230, 10, 11}, // 14
	{"Sherrif", "weapon_sherrif", "weapon_deagle", "p_sherrif", "d_sherrif", "onehanded", ASAMA_1, 6, 6, 159, 55, 46, 250, 7, 8}, // 15
	{"Shorty", "weapon_shorty", "weapon_deagle", "p_shorty", "d_shorty", "onehanded", ASAMA_YOK, 2, 4, 22, 11, 9, 250, 7, 8}, // 16
	{"Spectre", "weapon_spectre", "weapon_p90", "p_spectre", "d_spectre", "mp5", ASAMA_2, 30, 30, 78, 26, 22, 240, 10, 11}, // 17
	{"Stinger", "weapon_stinger", "weapon_p90", "p_stinger", "d_stinger", "mp5", ASAMA_1, 20, 20, 67, 27, 22, 240, 10, 11}, // 18
	{"Vandal", "weapon_vandal", "weapon_ak47", "p_vandal", "d_vandal", "ak47", ASAMA_3, 25, 25, 160, 40, 34, 230, 10, 11} // 19
}	

new const Asama_Silahlari[][] = 
{
	{-1, CLASSIC, ASAMA_1, 125}, // 0
	{-1, FRENZY, ASAMA_1, 100}, // 1
	{-1, GHOST, ASAMA_1, 100}, // 2
	{-1, SHORTY, ASAMA_1, 100}, // 3

	{STINGER, -1, ASAMA_2, 150}, // 4
	{ARES, -1, ASAMA_2, 125}, // 5
	{-1, SHERRIF, ASAMA_2, 150}, // 6

	{BULLDOG, -1, ASAMA_3, 150}, // 7
	{GUARDIAN, -1, ASAMA_3, 125}, // 8
	{SPECTRE, -1, ASAMA_3, 150}, // 9
	{ARES, -1, ASAMA_3, 150}, // 10
	{BUCKY, -1, ASAMA_3, 125}, // 11

	{VANDAL, -1, ASAMA_FINAL, 150}, // 12
	{PHANTOM, -1, ASAMA_FINAL, 150}, // 13
	{BUCKY, -1, ASAMA_FINAL, 150} // 14
}

new const Head_Damage_Take[][] = 
{
	"Jenessee_Valorant/take_head_damage1.wav",
	"Jenessee_Valorant/take_head_damage2.wav",
	"Jenessee_Valorant/take_head_damage3.wav"
}

new const Head_Damage_Victim[][] = 
{
	"Jenessee_Valorant/head_damage1.wav",
	"Jenessee_Valorant/head_damage2.wav",
	"Jenessee_Valorant/head_damage3.wav"
}

new const Body_Damage_Take[][] = 
{
	"Jenessee_Valorant/body3.wav"
}

new const Body_Damage_Victim[][] = 
{
	"Jenessee_Valorant/body1.wav",
	"Jenessee_Valorant/body2.wav"
}

new const Barrier_Hit[][] = 
{
	"Jenessee_Valorant/god_hit1.wav",
	"Jenessee_Valorant/god_hit2.wav",
	"Jenessee_Valorant/god_hit3.wav"
}

new const Weapon_Fire_Sounds[][] = 
{
	"Jenessee_Valorant/weapons/ares/ares1.wav", // 0
	"Jenessee_Valorant/weapons/bucky/bucky1.wav", // 1
	"Jenessee_Valorant/weapons/bucky/bucky2.wav", // 2
	"Jenessee_Valorant/weapons/bulldog/bulldog1.wav", // 3
	"Jenessee_Valorant/weapons/bulldog/bulldog1.wav", // 4
	"Jenessee_Valorant/weapons/classic/classic1.wav", // 5
	"Jenessee_Valorant/weapons/classic/classic2.wav", // 6
	"Jenessee_Valorant/weapons/frenzy/frenzy1.wav", // 7
	"Jenessee_Valorant/weapons/ghost/ghost1.wav", // 8
	"Jenessee_Valorant/weapons/guardian/guardian_1.wav", // 9
	"Jenessee_Valorant/weapons/judge/judge1.wav", // 10
	"Jenessee_Valorant/weapons/marshall/marshall1.wav", // 11
	"Jenessee_Valorant/weapons/odin/odin_1.wav", // 12
	"Jenessee_Valorant/weapons/operator/operator1.wav", // 13
	"Jenessee_Valorant/weapons/phantom/phantom1.wav", // 14
	"Jenessee_Valorant/weapons/sherrif/sherrif1.wav", // 15
	"Jenessee_Valorant/weapons/shorty/shorty1.wav", // 16
	"Jenessee_Valorant/weapons/spectre/spectre1.wav", // 17
	"Jenessee_Valorant/weapons/stinger/stinger1.wav", // 18
	"Jenessee_Valorant/weapons/vandal/vandal1.wav", // 19
	"Jenessee_Valorant/weapons/zoom_open.wav", // 20
	"Jenessee_Valorant/weapons/zoom_close.wav", // 21

	"Jenessee_Valorant/weapons/knife/knife_hit1.wav", // 22
	"Jenessee_Valorant/weapons/knife/knife_hit2.wav", // 23
	"Jenessee_Valorant/weapons/knife/knife_hit3.wav", // 24
	"Jenessee_Valorant/weapons/knife/knife_hit4.wav", // 25
	"Jenessee_Valorant/weapons/knife/knife_slash1.wav", // 26
	"Jenessee_Valorant/weapons/knife/knife_slash2.wav", // 27
	"Jenessee_Valorant/weapons/knife/knife_slash3.wav", // 28
	"Jenessee_Valorant/weapons/knife/knife_wall.wav" // 29
}

new const Announcer_Sounds[][] = 
{
	"Jenessee_Valorant/announcer/baslarken_bilgilendirme1.wav", // 0
	"Jenessee_Valorant/announcer/baslarken_bilgilendirme2.wav", // 1

	"Jenessee_Valorant/announcer/baslama1.wav", // 2
	"Jenessee_Valorant/announcer/baslama2.wav", // 3
	"Jenessee_Valorant/announcer/baslama3.wav", // 4
	"Jenessee_Valorant/announcer/baslama4.wav", // 5
	"Jenessee_Valorant/announcer/baslama5.wav", // 6
	"Jenessee_Valorant/announcer/baslama6.wav", // 7

	"Jenessee_Valorant/announcer/bariyerden_cik1.wav", // 8
	"Jenessee_Valorant/announcer/bariyerden_cik2.wav", // 9
	"Jenessee_Valorant/announcer/bariyerden_cik3.wav", // 10

	"Jenessee_Valorant/announcer/10_saniye_asama.wav", // 11
	"Jenessee_Valorant/announcer/10_saniye_asama2.wav", // 12

	"Jenessee_Valorant/announcer/2_asama.wav", // 13
	"Jenessee_Valorant/announcer/2_asama2.wav", // 14
	"Jenessee_Valorant/announcer/3_asama.wav", // 15
	"Jenessee_Valorant/announcer/3_asama2.wav", // 16
	"Jenessee_Valorant/announcer/final_asamasi.wav", // 17
	"Jenessee_Valorant/announcer/final_asamasi2.wav", // 18
	
	"Jenessee_Valorant/announcer/10_saniye.wav", // 19
	"Jenessee_Valorant/announcer/10_saniye2.wav", // 20
	"Jenessee_Valorant/announcer/10_saniye3.wav", // 21

	"Jenessee_Valorant/announcer/30_saniye.wav", // 22
	"Jenessee_Valorant/announcer/30_saniye2.wav", // 23
	"Jenessee_Valorant/announcer/30_saniye3.wav", // 24

	"Jenessee_Valorant/announcer/60_saniye.wav", // 25
	"Jenessee_Valorant/announcer/60_saniye2.wav", // 26

	"Jenessee_Valorant/announcer/attacker_win.wav", // 27
	"Jenessee_Valorant/announcer/defender_win.wav" // 28
}

new const Background_Musics[][] = 
{
	"Jenessee_Valorant/music/background_final.mp3", // 0
	"Jenessee_Valorant/music/background_final2.mp3", // 1
	"Jenessee_Valorant/music/background_final3.mp3", // 2

	"Jenessee_Valorant/music/map_start_background1.mp3", // 3
	"Jenessee_Valorant/music/map_start_background2.mp3", // 4
	"Jenessee_Valorant/music/map_start_background3.mp3", // 5
	"Jenessee_Valorant/music/map_start_background4.mp3", // 6
	"Jenessee_Valorant/music/map_start_background5.mp3", // 7
	"Jenessee_Valorant/music/map_start_background6.mp3", // 8

	"Jenessee_Valorant/music/lose.mp3", // 9
	"Jenessee_Valorant/music/win.mp3" // 10
}

new const Kill_Mark[][][] = 
{
	{"Jenessee_Valorant/1kill.wav", "sprites/Jenessee_Valorant/1kill.spr"},
	{"Jenessee_Valorant/2kill.wav", "sprites/Jenessee_Valorant/2kill.spr"},
	{"Jenessee_Valorant/3kill.wav", "sprites/Jenessee_Valorant/3kill.spr"},
	{"Jenessee_Valorant/4kill.wav", "sprites/Jenessee_Valorant/4kill.spr"},
	{"Jenessee_Valorant/5kill.wav", "sprites/Jenessee_Valorant/5kill.spr"},
}

new const Roman_Numerals[][] = 
{
	"I", // 0	
	"II", // 1
	"III", // 2
	"IV", // 3
	"V", // 4
	"VI", // 5
	"VII", // 6
	"VIII", // 7
	"IX", // 8
	"X" // 9
}

enum 
{
	TEAM_UNASSIGNEDS = 0,
	TEAM_ATTACKERS,
	TEAM_DEFENDERS,
	TEAM_SPECTATORS
};

enum
{
	POINT_TYPE_INVISIBLE_WALL = 1,
	POINT_TYPE_ATTACKER_ENERGY_BARRIER,
	POINT_TYPE_DEFENDER_ENERGY_BARRIER,
	POINT_TYPE_WEAPON_POINT,
	POINT_TYPE_HEALTH_POINT,
	POINT_TYPE_SPEED_POINT,
	POINT_TYPE_ATTACKER_POINT,
	POINT_TYPE_DEFENDER_POINT,
	POINT_TYPE_BOT_FOLLOW
}

new const ItemLANG[][] = 
{
	"MENU_ITEM_INVISIBLE_WALL", // 0	
	"MENU_ITEM_ATTACKER_ENERGY_BARRIER", // 1
	"MENU_ITEM_DEFENDER_ENERGY_BARRIER", // 2
	"MENU_ITEM_WEAPON_POINT", // 3
	"MENU_ITEM_HEALTH_POINT", // 4
	"MENU_ITEM_SPEED_POINT", // 5
	"MENU_ITEM_ATTACKER_POINT", // 6
	"MENU_ITEM_DEFENDER_POINT", // 7
	"MENU_ITEM_BOT_FOLLOW" // 8
}

enum 
{
	TASK_CONFIG_MENU = 1366,
	TASK_BARRIER_LINES = 2732,
	TASK_PLAYER_IMMORTAL = 4098,
	TASK_REMOVE_ENTITY = 5464,
	TASK_ORB_COOLDOWN = 6830,
	TASK_PLAYER_REGENERATION = 8196,
	TASK_PLAYER_REGENERATION_END = 9562,
	TASK_PLAYER_SPEED_END = 10928,
	TASK_DAMAGEHUD = 12294,
	TASK_ROUND_STATES = 13660,
	TASK_WEAPON = 15026,
	TASK_WEAPON_UPGRADE = 16392,
	TASK_VIEWSPRITE = 17758,
	TASK_PLAYER_PUSH = 19124,
	TASK_PLAYER_DASH = 20490,
	TASK_BOMB = 21856,
	TASK_LEERBLIND = 23222,
	TASK_BOTDEATH = 24588,
	TASK_BOT_SEARCHENEMY = 25954,
	TASK_BOT_FIRE = 27320,
	TASK_FIX_ORIGIN = 28686
};

enum
{
	ORIENTED = 0,
	VP_PARALLEL = 2002,
	VP_PARALLEL_ORIENTED = 2003
};

enum
{
	ORBTYPE_SPEED = 0,
	ORBTYPE_HEAL,
	ORBTYPE_WEAPON
};

enum Forwards
{
	FW_ON_PLAYER_ASSIST = 0
}

new g_Forwards[Forwards], g_fwResult;

const EntVars:var_owner2 = var_iuser1; // for solid entities
const EntVars:var_parent = var_iuser2;
const EntVars:var_maxframe = var_enemy;
const EntVars:var_code = var_flTimeStepSound;
const EntVars:var_orbtype = var_iuser1;
const EntVars:var_orbweapon = var_enemy;
const EntVars:var_weapon_zoom = var_iuser1;
const EntVars:var_weapon_hold = var_iuser2;
const EntVars:var_weapon_right = var_iuser3;
const EntVars:var_bombtype = var_iuser2;

new const spriteBarrier[64] = "sprites/Jenessee_Valorant/barrier_effect.spr"
new const barrierLoopSound[64] = "Jenessee_Valorant/barrier_loop.wav"
new const barrierInsideSound[64] = "Jenessee_Valorant/barrier_inside.wav"
new const barrierDecaySound[64] = "Jenessee_Valorant/barrier_inside_decay.wav"
new const barrierQuitSound[64] = "Jenessee_Valorant/barrier_quit1.wav"

new const playerHealSound[64] = "Jenessee_Valorant/heal.wav"
new const orbHealIdleSound[64] = "Jenessee_Valorant/heal_orb_idle.wav"
new const orbHealTakeSound[64] = "Jenessee_Valorant/heal_orb_take.wav"

new const orbSpeedIdleSound[64] = "Jenessee_Valorant/weapon_idle.wav"
new const playerSpeedLoopSound[64] = "Jenessee_Valorant/speedboost_loop.wav"
new const orbSpeedStartSound[64] = "Jenessee_Valorant/speedboost_start.wav"
new const orbSpeedTakeSound[64] = "Jenessee_Valorant/speedboost_on.wav"

new const orbWeaponIdleSound[64] = "Jenessee_Valorant/weapon_idle.wav"
new const orbWeaponChargeSound[64] = "Jenessee_Valorant/weapon_charge.wav"
new const orbWeaponChargedSound[64] = "Jenessee_Valorant/weapon_charged.wav"
new const orbWeaponTakeSound[64] = "Jenessee_Valorant/weapon_take.wav"

new const Float:immortalTime = 15.0;
new const Float:decayHealth = 15.0;
new const Float:orbCooldownHEALTH = 30.0;
new const Float:orbCooldownSPEED = 40.0;
new const Float:orbCooldownWEAPON = 20.0;
new const Float:upgradeWeaponTIME = 5.0;

new const Float:orbActiveTIME_Heal = 5.0;
new const Float:orbActiveTIME_Speed = 5.0;
new const Float:regenerationTime = 10.0;
new const Float:speedTime = 10.0;
new const Float:regenerationDelay = 0.5;
new const Float:regenerationHeal = 15.0;
new const Float:orbSpeedPOWER = 100.0;
new const orbSpeedFOV = 105;
new const orbSpeedFOV2 = 120;

new const weaponChangeSPRITE[128] = ""
new const weaponChangeSOUND[64] = "Jenessee_Valorant/level_up.wav"

new const playerScreenHEAL[128] = "sprites/Jenessee_Valorant/heal_effect.spr"
new const playerScreenSPEED[128] = "sprites/Jenessee_Valorant/speed_effect.spr"

new const orbMODEL[128] = "models/Jenessee_Valorant/orb.mdl"
new const orbEFFECT[128] = "models/Jenessee_Valorant/ef_orb_effect.mdl"
new const orbGroundEFFECT[128] = "models/Jenessee_Valorant/ef_orb_ground.mdl"

new const orbFieldEFFECT[128] = "models/Jenessee_Valorant/speed_field_effect.mdl"
new const orbWindEFFECT[128] = "models/Jenessee_Valorant/heal_wind_effect.mdl"

new const playerHealEFFECT[128] = "models/Jenessee_Valorant/player_heal_effect.mdl"
new const playerSpeedEFFECT[128] = "models/Jenessee_Valorant/speed_player_effect.mdl"

new const orbFireHEALTH[128] = "models/Jenessee_Valorant/ef_orb_firegreen.mdl"
new const orbFireSPEED[128] = "models/Jenessee_Valorant/ef_orb_fireblue.mdl"

new const muzzleflashFire[128] = "sprites/Jenessee_Valorant/ef_chainsr_shadowshoot2.spr"
new const muzzleflashGhost[128] = "sprites/Jenessee_Valorant/muzzleflash283.spr"

new const weaponOrbBUTTON[128] = "sprites/Jenessee_Valorant/e_button01.spr"

new const agentSelectSOUND[64] = "Jenessee_Valorant/agent_selected.wav"

new Array:Array_playerCONNECTED, Array:Array_playerALIVE, Array:Array_playerDEAD, Array:Array_playerDEFENDERS, 
Array:Array_playerATTACKERS, playerTEAM[MAX_PLAYERS + 1];
new playerNAME[MAX_PLAYERS+1][32], playerCOUNTRY[MAX_PLAYERS+1][46], bool:bPlayerTurkish[MAX_PLAYERS+1];

new Array:Array_itemORIGIN, Array:Array_itemANGLEY, Array:Array_itemTYPE, Array:Array_boxDISTANCE,
Array:Array_itemORIGIN_Menu, Array:Array_itemANGLEY_Menu, Array:Array_itemTYPE_Menu, Array:Array_boxDISTANCE_Menu,
szFilepath[100], playerUsingMenu = NULLENT, closestPoint = NULLENT, bool:bSearchPoint, laserBeam;

new Array:Array_semiclipATTACKER, Array:Array_semiclipDEFENDER, TotalSemiclipATTACKER, TotalSemiclipDEFENDER, bool:bSemiclipATTACKER[1366], 
bool:bSemiclipDEFENDER[1366];

new Array:entityCHILDRENS[1366], entityTotalCHILDRENS[1366], entityPARENT[1366] = { NULLENT, ... }, bool:bEntityHavePARENT[1366];

new Array:Array_attackerSpawnOrigin_Map, Array:Array_defenderSpawnOrigin_Map, Array:Array_attackerSpawnAngle_Map, Array:Array_defenderSpawnAngle_Map;
new Array:Array_attackerSpawnOrigin, Array:Array_defenderSpawnOrigin, Array:Array_attackerSpawnAngle, Array:Array_defenderSpawnAngle;

new Array:Array_entitiesWillREMOVE, bool:entityWillREMOVE[1366];

new Array:Array_barrierENTITIES, bool:entityBARRIER[1366], bool:playerInBASE[MAX_PLAYERS + 1], bool:attackersHaveBARRIER, bool:defendersHaveBARRIER;

new playerDefaultFOV[MAX_PLAYERS + 1], Message_SetFOV;

new playerNextAgent[MAX_PLAYERS + 1] = { NULLENT, ... }, playerAgentID[MAX_PLAYERS + 1] = { NULLENT, ... }, 
Array:Array_DeathSounds[MAX_PLAYERS + 1], Array:Array_PainHeadSounds[MAX_PLAYERS + 1], Array:Array_PainBodySounds[MAX_PLAYERS + 1], Array:Array_HeadshotKillSounds[MAX_PLAYERS + 1], 
Array:Array_KillSounds[MAX_PLAYERS + 1], Array:Array_3KillSounds[MAX_PLAYERS + 1], Array:Array_4KillSounds[MAX_PLAYERS + 1], Array:Array_5KillSounds[MAX_PLAYERS + 1], Array:Array_AceSounds[MAX_PLAYERS + 1], Array:Array_HealSounds[MAX_PLAYERS + 1], Array:Array_AlmostWinSounds[MAX_PLAYERS + 1], Array:Array_WinSounds[MAX_PLAYERS + 1], Array:Array_CantUseSounds[MAX_PLAYERS + 1], Array:Array_UltReadySounds[MAX_PLAYERS + 1], Array:Array_Skill1Sounds[MAX_PLAYERS + 1], Array:Array_Skill2Sounds[MAX_PLAYERS + 1];

new Array:botFollowPoint, Array:botFollowPoint2[MAX_PLAYERS + 1], Array:playersEnemy[MAX_PLAYERS+1], Array:playersTotalDamage[MAX_PLAYERS+1], Array:playersDamageBody[MAX_PLAYERS+1][HIT_RIGHTLEG+1], Array:playersHitsBody[MAX_PLAYERS+1][HIT_RIGHTLEG+1];
new playerID[MAX_PLAYERS+1][MAX_PLAYERS+1], Float:myTotalDamage[MAX_PLAYERS+1], MyLastKiller[MAX_PLAYERS + 1] = { NULLENT, ... }, MyLastAttacker[MAX_PLAYERS + 1] = { NULLENT, ... },  MyLastWeaponName[MAX_PLAYERS+1][32];
new deathInfoSYNC;
new HookChain:HookChain_Killed_Post;

new Array:playersSTEAMID, Array:playersCONNECTED, Array:playersAGENT, Array:playersSCORE, Array:playersDEATH, Array:playersCOOLDOWN, Array:playersStageWEAPONS[ASAMA_FINAL + 1];
new mySteamCODE[MAX_PLAYERS + 1];

new playerTotalKILL[MAX_PLAYERS + 1], Float:playerQuoteDelay[MAX_PLAYERS + 1];

new Array:Array_weaponOrbENTITIES, bool:entityWeaponORB[1366];

new Array:ArrayWillRemoveEntities[MAX_PLAYERS+1];
new iTotalWillRemoveEntities[MAX_PLAYERS+1], bool:bEntityFullPack[1366], bool:bEntitySprite[1366];

new Float:delayHealing[MAX_PLAYERS + 1], Float:weaponSPEED[MAX_PLAYERS + 1], lastWeaponENTITY[MAX_PLAYERS + 1], currentWeaponENTITY[MAX_PLAYERS + 1], bool:bWeaponFast[MAX_PLAYERS + 1], bool:bAceSound[MAX_PLAYERS + 1], bool:bAceSound2[MAX_PLAYERS + 1];

new bool:bMuteEntity[1366];
new bool:bCustomAudio;
new currentSTAGE, selectedFinalBACKGROUND;
new stageWeaponMENU, mainMENU, MyStageWeapons[MAX_PLAYERS + 1][ASAMA_FINAL + 1], lastPage[MAX_PLAYERS + 1], myHideWeapon[MAX_PLAYERS + 1];

new crosshairSelectMENU, agentSelectMENU;

new bool:bSeeEye[MAX_PLAYERS+1], bEyeEntity[1366], bDeadlockEntity[1366], bProwlerEntity[1366];
new szLOGNAME[64], bool:weaponRight[MAX_PLAYERS + 1], bool:playerDECAY[MAX_PLAYERS + 1];
new BlockedObj_Forward;
new Message_ScoreInfo, muzzleFlashENTITY = NULLENT, muzzleFlashENTITY2 = NULLENT, playerCOOLDOWN[MAX_PLAYERS + 1], agentPAGE[MAX_PLAYERS + 1], crosshairPAGE[MAX_PLAYERS + 1], playerCROSSHAIR[MAX_PLAYERS + 1], myCROSSHAIR[MAX_PLAYERS + 1][32], spriteFRAME[MAX_PLAYERS + 1], myMuzzle[MAX_PLAYERS + 1], lastBODY[MAX_PLAYERS + 1], Float:lastSCALE[MAX_PLAYERS + 1], Message_CurWeapon, bool:Available, wallPuffEffect, Float:fLastValue, bool:bUpdateMenu[MAX_PLAYERS + 1], Message_WeapPickup, g_iBloods[2];
new bool:haveBot;
new HamHook:fwBuckShootTraceAttack_Post[8];
new const g_szBuckShootTraceAttack[][] =
{
	"info_target",
	"worldspawn",
	"func_breakable",
	"func_wall",
	"func_door",
	"func_door_rotating",
	"func_plat",
	"func_rotating"
};

//block all buy commands
new const Commands[][]=
{
    "galil",
    "defender",
    "ak47",
    "cv47",
    "scout",
    "sg552",
    "krieg552",
    "awp",
    "magnum",
    "g3sg1",
    "d3au1",
    "famas",
    "clarion",
    "m4a1",
    "aug",
    "bullpup",
    "krieg550",
    "glock",
    "9x19mm",
    "km45",
    "p228",
    "228compact",
    "nighthawk",
    "elites",
    "fn57",
    "fiveseven",
    "12gauge",
    "xm1014",
    "autoshotgun",
    "mac10",
    "tmp",
    "mp",
    "mp5",
    "smg",
    "ump45",
    "p90",
    "c90",
    "m249",
    "vest",
    "vesthelm",
    "flash",
    "hegren",
    "sgren",
    "nvgs",
    "shield",
    
    "cl_setautobuy", 
    "cl_autobuy",
    "cl_setrebuy",
    "cl_rebuy",
    "buyequip"
}

enum
{
    HIT_NONE = 0,
	HIT_ENEMY,
	HIT_WALL
}
new g_BuyzoneEnt;
new bool:bSkyBoxEntity[1366];
new mySkyBox[MAX_PLAYERS+1] = { NULLENT, ... };
new const g_fog_density[] = { 0, 0, 0, 0, 111, 18, 3, 58, 111, 18, 125, 58, 66, 96, 27, 59, 90, 101, 60, 59, 90,
			101, 68, 59, 10, 41, 95, 59, 111, 18, 125, 59, 111, 18, 3, 60, 68, 116, 19, 60 }
new bool:isPlayerBlind[MAX_PLAYERS + 1], bool:bHideTeammates[MAX_PLAYERS + 1];
new playerRoomType[MAX_PLAYERS + 1] = { NULLENT, ... }, Message_Fog;
new IDFormat[MAX_PLAYERS + 1][64], Crosshair[MAX_PLAYERS + 1][64], Vault;
new Float:vJettDashVelocity[MAX_PLAYERS + 1][3], bool:skillFastDRAW[MAX_PLAYERS + 1], lastdistancemeter[MAX_PLAYERS + 1], cameraEntity[MAX_PLAYERS+1] = { NULLENT, ... }, bool:bCameraEntity[1366], bool:bEntityHaveTeam[1366], Float:fBlockPlayerAnim[MAX_PLAYERS+1], Float:fBlockWeaponChange[MAX_PLAYERS+1], Float:fSkillDelay[MAX_PLAYERS+1];
new const szBotNames[][] = 
{
	"BOT", // 0
	"By Jenessee", // 1
	"Valorant", // 2
	"HackAfterBan", // 3
	"No1Knows", // 4
	"PlayAfterEat", // 5
	"DontBeToxic", // 6
	"Skynet", // 7
	"FirstDeadMan", // 8
	"CSBEST" // 9
}

new Array:playerBOT, totalBOT, maxBOT, bool:bRealBot[MAX_PLAYERS+1];
new Array:playerEnemy[MAX_PLAYERS+1], totalMyEnemy[MAX_PLAYERS+1], botEnemy[MAX_PLAYERS+1] = { NULLENT, ... };
new Float:vBotAngle[MAX_PLAYERS+1][3], Float:vBotTargetOrigin[MAX_PLAYERS+1][3];
new bool:bBotJumping[MAX_PLAYERS+1], bool:bBotDucking[MAX_PLAYERS+1], Float:vLastRandom[MAX_PLAYERS + 1][3];
new Forward_ServerFrame;
new Array:mapName;
new nextMAP[32];
new bool:bFovTYPE[MAX_PLAYERS + 1], HIDEPLAYERS[MAX_PLAYERS + 1][64], FOVTYPE[MAX_PLAYERS + 1][64], bool:bDeadlockEffect[1366], bool:bEntityMap[1366], bool:bRazeBomb[1366];
public plugin_init()
{
	Log("%s/plugin_init", PLUGIN);

	register_plugin(PLUGIN, VERSION, AUTHOR);

	register_dictionary("valorant_tdm.txt");

	unregister_forward(FM_Spawn, BlockedObj_Forward);

	Load_MapItems();
	Hooks();

	server_print( "Precache X System: Model Precache Reserved Slots: %i", 512 - ArraySize( ArModel ) )
	server_print( "Precache X System: Sound Precache Reserved Slots: %i", 512 - ArraySize( ArSound ) )

	new maps_ini_file[64]; get_cvar_string("mapcyclefile", maps_ini_file, 63)
	if (loadSettings(maps_ini_file))
	{
		new MapName[32], szMapName[32]; get_mapname(szMapName, 31);
		new currentMapID = -1;
		for(new index = 0; index < ArraySize(mapName); index++)
		{
			ArrayGetString(mapName, index, MapName, 32);

			if(equal(MapName, szMapName))
			{
				currentMapID = index;
			}
		}

		if(currentMapID == -1 || (currentMapID+1) >= ArraySize(mapName))
		{
			if(ArraySize(mapName))
				ArrayGetString(mapName, 0, nextMAP, 32);
		} else {
			ArrayGetString(mapName, currentMapID+1, nextMAP, 32);
		}

		if (contain(szMapName, "fy_iceworld16") >= 0 && strlen(nextMAP))
		{
			new cfgdir[32]; get_configsdir(cfgdir, charsmax(cfgdir));
			server_cmd("exec %s/valorant_tdm.cfg", cfgdir);
			server_cmd("changelevel %s", nextMAP);
		}	
	}
	register_clcmd("item_menu", "Item_Menu");
}

public plugin_natives()
{
	#if defined DEBUG
	Debug();
	#endif

	Log("%s/plugin_natives", PLUGIN);
	server_cmd("sv_auto_precache_sounds_in_models 1");
}

public plugin_precache()
{
	Log("%s/plugin_precache", PLUGIN);

	ArModel = ArrayCreate( 64, 1 ) 
	ArSound = ArrayCreate( 64, 1 ) 

	register_forward( FM_PrecacheModel, "fw_PrecacheModel" ) 
	register_forward( FM_PrecacheSound, "fw_PrecacheSound" ) 
	register_forward( FM_PrecacheModel, "fw_PrecacheModel_Post", 1 ) 
	register_forward( FM_PrecacheSound, "fw_PrecacheSound_Post", 1 ) 

	Arrays();

	BlockedObj_Forward = register_forward(FM_Spawn, "BlockedObj_Spawn");

	g_BuyzoneEnt=engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "func_buyzone"))

	dllfunc(DLLFunc_Spawn, g_BuyzoneEnt)
	set_entvar(g_BuyzoneEnt, var_solid, SOLID_NOT)    

	laserBeam = precache_model("sprites/laserbeam.spr");

	g_iBloods[0] = precache_model("sprites/blood.spr");
	g_iBloods[1] = precache_model("sprites/bloodspray.spr");

	if(strlen(spriteBarrier)) precache_model(spriteBarrier);
	if(strlen(orbMODEL)) precache_model(orbMODEL);
	if(strlen(orbEFFECT)) precache_model(orbEFFECT);
	if(strlen(orbGroundEFFECT)) precache_model(orbGroundEFFECT);
	if(strlen(orbFieldEFFECT)) precache_model(orbFieldEFFECT);
	if(strlen(orbWindEFFECT)) precache_model(orbWindEFFECT);
	if(strlen(playerHealEFFECT)) precache_model(playerHealEFFECT);
	if(strlen(playerSpeedEFFECT)) precache_model(playerSpeedEFFECT);
	if(strlen(orbFireHEALTH)) precache_model(orbFireHEALTH);
	if(strlen(orbFireSPEED)) precache_model(orbFireSPEED);
	if(strlen(weaponChangeSPRITE)) precache_model(weaponChangeSPRITE);
	if(strlen(playerScreenHEAL)) precache_model(playerScreenHEAL);
	if(strlen(playerScreenSPEED)) precache_model(playerScreenSPEED);
	if(strlen(muzzleflashFire)) 
	{
		precache_model(muzzleflashFire);
		muzzleFlashENTITY = rg_create_entity("env_sprite");
		if (!is_nullent(muzzleFlashENTITY))
		{
			engfunc(EngFunc_SetModel, muzzleFlashENTITY, muzzleflashFire);
			set_entvar(muzzleFlashENTITY, var_rendermode, kRenderTransAdd);  
			set_entvar(muzzleFlashENTITY, var_renderamt, 0.0);   
			set_entvar(muzzleFlashENTITY, var_movetype, MOVETYPE_FOLLOW);
			set_entvar(muzzleFlashENTITY, var_effects, EF_FORCEVISIBILITY);
		}
	}

	if(strlen(muzzleflashGhost)) 
	{
		precache_model(muzzleflashGhost);
		muzzleFlashENTITY2 = rg_create_entity("env_sprite");
		if (!is_nullent(muzzleFlashENTITY2))
		{
			engfunc(EngFunc_SetModel, muzzleFlashENTITY2, muzzleflashGhost);
			set_entvar(muzzleFlashENTITY2, var_rendermode, kRenderTransAdd);  
			set_entvar(muzzleFlashENTITY2, var_renderamt, 0.0);   
			set_entvar(muzzleFlashENTITY2, var_movetype, MOVETYPE_FOLLOW);
			set_entvar(muzzleFlashENTITY2, var_effects, EF_FORCEVISIBILITY);
		}
	}

	if(strlen(weaponOrbBUTTON)) precache_model(weaponOrbBUTTON);
	if(strlen(barrierLoopSound)) precache_sound(barrierLoopSound);
	if(strlen(barrierInsideSound)) precache_sound(barrierInsideSound);
	if(strlen(barrierDecaySound)) precache_sound(barrierDecaySound);
	if(strlen(barrierQuitSound)) precache_sound(barrierQuitSound);
	if(strlen(playerHealSound)) precache_sound(playerHealSound);
	if(strlen(orbHealIdleSound)) precache_sound(orbHealIdleSound);
	if(strlen(orbHealTakeSound)) precache_sound(orbHealTakeSound);
	if(strlen(orbSpeedIdleSound)) precache_sound(orbSpeedIdleSound);
	if(strlen(playerSpeedLoopSound)) precache_sound(playerSpeedLoopSound);
	if(strlen(orbSpeedStartSound)) precache_sound(orbSpeedStartSound);
	if(strlen(orbSpeedTakeSound)) precache_sound(orbSpeedTakeSound);
	if(strlen(orbWeaponIdleSound)) precache_sound(orbWeaponIdleSound);
	if(strlen(orbWeaponChargeSound)) precache_sound(orbWeaponChargeSound);
	if(strlen(orbWeaponChargedSound)) precache_sound(orbWeaponChargedSound);
	if(strlen(orbWeaponTakeSound)) precache_sound(orbWeaponTakeSound);
	if(strlen(weaponChangeSOUND)) precache_generic(fmt("sound/%s", weaponChangeSOUND));
	if(strlen(agentSelectSOUND)) precache_sound(agentSelectSOUND);

	for(new index = 0; index < sizeof(Announcer_Sounds); index++) 
		precache_generic(fmt("sound/%s", Announcer_Sounds[index]));

	for(new index = 0; index < sizeof(Background_Musics); index++) 
		precache_generic(fmt("sound/%s", Background_Musics[index]));

	for(new index = 0; index < sizeof(Kill_Mark); index++) 
	{
		precache_sound(Kill_Mark[index][0]);
		precache_model(Kill_Mark[index][1]);
	}

	for(new index = 0; index < sizeof(Agent_Info); index++) 
	{
		precache_model(fmt("models/player/%s/%s.mdl", Agent_Info[index][PLAYER_MODEL], Agent_Info[index][PLAYER_MODEL]));
		for(new index2 = ARES; index2 <= VANDAL; index2++)
		{
			precache_model(fmt("models/Jenessee_Valorant/weapons/%s.mdl", Agent_Info[index][index2]));
			UTIL_PrecacheSoundsFromModel(fmt("models/Jenessee_Valorant/weapons/%s.mdl", Agent_Info[index][index2]));
		}
	}

	for(new index = 0; index < sizeof(Agent_Skills); index++) 
	{
		UTIL_PrecacheWeaponList(Agent_Skills[index][SKILL_SPRITE]);

		if(strlen(Agent_Skills[index][SKILL_VIEWMODEL]))
		{
			precache_model(fmt("models/Jenessee_Valorant/skills/%s.mdl", Agent_Skills[index][SKILL_VIEWMODEL]));
			UTIL_PrecacheSoundsFromModel(fmt("models/Jenessee_Valorant/skills/%s.mdl", Agent_Skills[index][SKILL_VIEWMODEL]));
		}
		if(strlen(Agent_Skills[index][SKILL_PMODEL]))
		{
			precache_model(fmt("models/Jenessee_Valorant/skills/%s.mdl", Agent_Skills[index][SKILL_PMODEL]));
		}
	}

	for(new index = 0; index < sizeof(Skill_Resources); index++) 
	{
		if(contain(Skill_Resources[index], ".mdl") >= 0 || contain(Skill_Resources[index], ".spr") >= 0) 
		{
			precache_model(Skill_Resources[index]);
		} else if(contain(Skill_Resources[index], ".wav") >= 0) {
			precache_sound(Skill_Resources[index]);
		} 
	}

	for(new index = 2; index < sizeof(Weapon_Info); index++) 
	{
		if(index == PHANTOM || index == STINGER || index == SPECTRE || index == GUARDIAN || index == BULLDOG || index == VANDAL || index == ODIN || index == ARES)
		{
			UTIL_PrecacheWeaponList(fmt("%s_zoom", Weapon_Info[index][WEAPON_SPRITE_NAME]));
		}

		UTIL_PrecacheWeaponList(Weapon_Info[index][WEAPON_SPRITE_NAME]);
		precache_model(fmt("models/Jenessee_Valorant/weapons/%s.mdl", Weapon_Info[index][WEAPON_P_MODEL]));
		if(strlen(Weapon_Info[index][WEAPON_D_MODEL])) precache_model(fmt("models/Jenessee_Valorant/weapons/%s.mdl", Weapon_Info[index][WEAPON_D_MODEL]));
	}

	for(new index = 1; index < sizeof(Crosshair_Info); index++) 
		UTIL_PrecacheWeaponList(Crosshair_Info[index][CROSSHAIR_SPRITE]);
	for(new index = 0; index < sizeof(Weapon_Fire_Sounds); index++) 
		precache_sound(Weapon_Fire_Sounds[index]);
	for(new index = 0; index < sizeof(Agent_Quote_HeadShotKill); index++) 
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_HeadShotKill[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_Kill); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Kill[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_3Kill); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_3Kill[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_4Kill); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_4Kill[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_5Kill); index++)
		precache_sound(fmt("Jenessee_Valorant/announcer/%s.wav", Agent_Quote_5Kill[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_Ace); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Ace[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_AlmostWin); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_AlmostWin[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_Death); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Death[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_PainBody); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_PainBody[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_PainHead); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_PainHead[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_Healing); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Healing[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_Selected); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Selected[index]));
	for(new index = 0; index < sizeof(Agent_Quote_Win); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Win[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_CantUse); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_CantUse[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_UltReady); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_UltReady[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_Skill1); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Skill1[index][1]));
	for(new index = 0; index < sizeof(Agent_Quote_Skill2); index++)
		precache_sound(fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Skill2[index][1]));

	for(new index = 0; index < sizeof(Head_Damage_Take); index++)
		precache_sound(Head_Damage_Take[index]);
	for(new index = 0; index < sizeof(Head_Damage_Victim); index++)
		precache_sound(Head_Damage_Victim[index]);
	for(new index = 0; index < sizeof(Body_Damage_Take); index++)
		precache_sound(Body_Damage_Take[index]);
	for(new index = 0; index < sizeof(Body_Damage_Victim); index++)
		precache_sound(Body_Damage_Victim[index]);
	for(new index = 0; index < sizeof(Barrier_Hit); index++)
		precache_sound(Barrier_Hit[index]);
	
	precache_sound("weapons/dryfire_rifle.wav");
	precache_sound("weapons/dryfire_pistol.wav");
	precache_model("models/rpgrocket.mdl");

	wallPuffEffect = precache_model("sprites/black_smoke4.spr");

	new szMapName[32]; get_mapname(szMapName, 31);
	if (contain(szMapName, "warehouse") >= 0 || contain(szMapName, "bunnyyard") >= 0)
	{
		new linedata[128], Skyboxes[32]; formatex(Skyboxes, charsmax(Skyboxes), "decoy2");
		set_cvar_string("sv_skyname", Skyboxes);
		formatex(linedata, charsmax(linedata), "gfx/env/%sbk.tga", Skyboxes);
		precache_generic(linedata);
		formatex(linedata, charsmax(linedata), "gfx/env/%sdn.tga", Skyboxes);
		precache_generic(linedata);
		formatex(linedata, charsmax(linedata), "gfx/env/%sft.tga", Skyboxes);
		precache_generic(linedata);
		formatex(linedata, charsmax(linedata), "gfx/env/%slf.tga", Skyboxes);
		precache_generic(linedata);
		formatex(linedata, charsmax(linedata), "gfx/env/%srt.tga", Skyboxes);
		precache_generic(linedata);
		formatex(linedata, charsmax(linedata), "gfx/env/%sup.tga", Skyboxes);
		precache_generic(linedata);
	}


	Log("%s/plugin_precache_end", PLUGIN);
}

public plugin_end()
{
	Log("%s/plugin_end", PLUGIN);

	Destroy_Arrays();
}

public plugin_cfg()
{
	Log("%s/plugin_cfg", PLUGIN);

	Create_StageWeapon_Menu();
	Create_Agent_Menu();
	Create_Crosshair_Menu();
	Create_Main_Menu();
	RequestFrame("Apply_Cvars");
}

public Apply_Cvars()
{
	Log("%s/Apply_Cvars", PLUGIN);

	new cfgdir[32]; get_configsdir(cfgdir, charsmax(cfgdir));
	server_cmd("exec %s/valorant_tdm.cfg", cfgdir);
}

public BlockedObj_Spawn(entityIndex)
{
	Log("%s/BlockedObj_Spawn", PLUGIN);

	if(is_nullent(entityIndex))
		return FMRES_IGNORED;
	
	new classNAME[32], Float:vOrigin[3], Float:vAngle[3]; get_entvar(entityIndex, var_classname, classNAME, sizeof(classNAME));
	if(equal(classNAME, "info_player_deathmatch"))
	{
		get_entvar(entityIndex, var_origin, vOrigin);
		get_entvar(entityIndex, var_angles, vAngle);
		ArrayPushArray(Array_attackerSpawnOrigin_Map, vOrigin);
		ArrayPushCell(Array_attackerSpawnAngle_Map, floatround(vAngle[1]));
		return FMRES_IGNORED;
	} else if(equal(classNAME, "info_player_start")) {
		get_entvar(entityIndex, var_origin, vOrigin);
		get_entvar(entityIndex, var_angles, vAngle);
		ArrayPushArray(Array_defenderSpawnOrigin_Map, vOrigin);
		ArrayPushCell(Array_defenderSpawnAngle_Map, floatround(vAngle[1]));
		return FMRES_IGNORED;
	}

	new BlockedObj[][] =
	{
		"func_bomb_target",
		"info_bomb_target",
		"info_vip_start",
		"func_vip_safetyzone",
		"func_escapezone",
		"hostage_entity",
		"monster_scientist",
		"func_hostage_rescue",
		"info_hostage_rescue",
		"item_longjump",
		"func_vehicle",
		"func_buyzone",
		"env_rain",
		"env_snow",
		"env_fog",
		"weaponbox",
		"armoury_entity"
	}


	for(new index = 0; index < sizeof BlockedObj; index++)
	{
		if (equal(classNAME, BlockedObj[index]))
		{
			engfunc(EngFunc_RemoveEntity, entityIndex);
			return FMRES_SUPERCEDE;
		}
	}
	
	return FMRES_IGNORED;
}

// Arrays
public Arrays()
{
	Log("%s/Arrays", PLUGIN);

	mapName = ArrayCreate(32);

	Array_playerCONNECTED = ArrayCreate(1, 1);
	Array_playerALIVE = ArrayCreate(1, 1);
	Array_playerDEAD = ArrayCreate(1, 1);
	Array_playerDEFENDERS = ArrayCreate(1, 1);
	Array_playerATTACKERS = ArrayCreate(1, 1);

	Array_itemORIGIN = ArrayCreate(3, 1);
	Array_itemANGLEY = ArrayCreate(1, 1);
	Array_itemTYPE = ArrayCreate(1, 1);
	Array_boxDISTANCE = ArrayCreate(1, 1);

	Array_itemORIGIN_Menu = ArrayCreate(3, 1);
	Array_itemANGLEY_Menu = ArrayCreate(1, 1);
	Array_itemTYPE_Menu = ArrayCreate(1, 1);
	Array_boxDISTANCE_Menu = ArrayCreate(1, 1);

	Array_semiclipATTACKER = ArrayCreate(1, 1);
	Array_semiclipDEFENDER = ArrayCreate(1, 1);

	for(new entityIndex = 1; entityIndex < 1366; entityIndex++)
	{
		entityCHILDRENS[entityIndex] = ArrayCreate(1, 1);
	}

	Array_attackerSpawnOrigin_Map = ArrayCreate(3, 1);
	Array_attackerSpawnAngle_Map = ArrayCreate(1, 1);
	Array_defenderSpawnOrigin_Map = ArrayCreate(3, 1);
	Array_defenderSpawnAngle_Map = ArrayCreate(1, 1);

	Array_attackerSpawnOrigin = ArrayCreate(3, 1);
	Array_attackerSpawnAngle = ArrayCreate(1, 1);
	Array_defenderSpawnOrigin = ArrayCreate(3, 1);
	Array_defenderSpawnAngle = ArrayCreate(1, 1);

	Array_entitiesWillREMOVE = ArrayCreate(1, 1);

	Array_barrierENTITIES = ArrayCreate(1, 1);
	playerBOT = ArrayCreate(1, 1);

	botFollowPoint = ArrayCreate(3, 1);

	for(new clientIndex = 1, victimIndex, bodyGroup; clientIndex <= MAX_PLAYERS; clientIndex++)
	{
		botFollowPoint2[clientIndex] = ArrayCreate(1, 1);

		playerEnemy[clientIndex] = ArrayCreate(1, 1);

		for(new index = ASAMA_1; index <= ASAMA_FINAL; index++)
		{
			MyStageWeapons[clientIndex][index] = NULLENT;
		}

		Array_DeathSounds[clientIndex] = ArrayCreate(128, 1);
		Array_PainHeadSounds[clientIndex] = ArrayCreate(128, 1);
		Array_PainBodySounds[clientIndex] = ArrayCreate(128, 1);
		Array_HeadshotKillSounds[clientIndex] = ArrayCreate(128, 1);
		Array_KillSounds[clientIndex] = ArrayCreate(128, 1);
		Array_3KillSounds[clientIndex] = ArrayCreate(128, 1);
		Array_4KillSounds[clientIndex] = ArrayCreate(128, 1);
		Array_5KillSounds[clientIndex] = ArrayCreate(128, 1);
		Array_AceSounds[clientIndex] = ArrayCreate(128, 1);
		Array_HealSounds[clientIndex] = ArrayCreate(128, 1);
		Array_AlmostWinSounds[clientIndex] = ArrayCreate(128, 1);
		Array_WinSounds[clientIndex] = ArrayCreate(128, 1);
		Array_CantUseSounds[clientIndex] = ArrayCreate(128, 1);
		Array_UltReadySounds[clientIndex] = ArrayCreate(128, 1);
		Array_Skill1Sounds[clientIndex] = ArrayCreate(128, 1);
		Array_Skill2Sounds[clientIndex] = ArrayCreate(128, 1);

		playersEnemy[clientIndex] = ArrayCreate(1, 1);
		playersTotalDamage[clientIndex] = ArrayCreate(1, 1);

		for(bodyGroup = HIT_HEAD; bodyGroup <= HIT_RIGHTLEG; bodyGroup++) 
		{
			playersDamageBody[clientIndex][bodyGroup] = ArrayCreate(1, 1);
			playersHitsBody[clientIndex][bodyGroup] = ArrayCreate(1, 1);
		}

		for(victimIndex = 1; victimIndex <= MAX_PLAYERS; victimIndex++) 
		{
			playerID[clientIndex][victimIndex] = NULLENT;
		}
	}

	playersSTEAMID = ArrayCreate(32, 1);
	playersCONNECTED = ArrayCreate(1, 1);
	playersAGENT = ArrayCreate(1, 1);
	playersSCORE = ArrayCreate(1, 1);
	playersDEATH = ArrayCreate(1, 1);
	playersCOOLDOWN = ArrayCreate(1, 1);

	for(new index = ASAMA_1; index <= ASAMA_FINAL; index++) 
		playersStageWEAPONS[index] = ArrayCreate(1, 1);

	Array_weaponOrbENTITIES = ArrayCreate(1, 1);

	for(new clientIndex = 1; clientIndex <= MAX_PLAYERS; clientIndex++) 
	{
		ArrayWillRemoveEntities[clientIndex] = ArrayCreate(1, 1);
	}
}

public Destroy_Arrays()
{	
	Log("%s/Destroy_Arrays", PLUGIN);
	
	ArrayDestroy(mapName);

	ArrayDestroy(Array_playerCONNECTED);
	ArrayDestroy(Array_playerALIVE);
	ArrayDestroy(Array_playerDEAD);
	ArrayDestroy(Array_playerDEFENDERS);
	ArrayDestroy(Array_playerATTACKERS);

	ArrayDestroy(Array_itemORIGIN);
	ArrayDestroy(Array_itemANGLEY);
	ArrayDestroy(Array_itemTYPE);
	ArrayDestroy(Array_boxDISTANCE);

	ArrayDestroy(Array_itemORIGIN_Menu);
	ArrayDestroy(Array_itemANGLEY_Menu);
	ArrayDestroy(Array_itemTYPE_Menu);
	ArrayDestroy(Array_boxDISTANCE_Menu);

	ArrayDestroy(Array_semiclipATTACKER);
	ArrayDestroy(Array_semiclipDEFENDER);

	TotalSemiclipATTACKER = 0;
	TotalSemiclipDEFENDER = 0;

	for(new entityIndex = 1; entityIndex < 1366; entityIndex++)
	{
		ArrayDestroy(entityCHILDRENS[entityIndex]);
		entityTotalCHILDRENS[entityIndex] = 0;
	}

	ArrayDestroy(Array_attackerSpawnOrigin_Map);
	ArrayDestroy(Array_attackerSpawnAngle_Map);
	ArrayDestroy(Array_defenderSpawnOrigin_Map);
	ArrayDestroy(Array_defenderSpawnAngle_Map);

	ArrayDestroy(Array_attackerSpawnOrigin);
	ArrayDestroy(Array_attackerSpawnAngle);
	ArrayDestroy(Array_defenderSpawnOrigin);
	ArrayDestroy(Array_defenderSpawnAngle);

	ArrayDestroy(Array_entitiesWillREMOVE);

	ArrayDestroy(Array_barrierENTITIES);

	ArrayDestroy(playerBOT);
	ArrayDestroy(botFollowPoint);

	for(new clientIndex = 1, bodyGroup; clientIndex <= MAX_PLAYERS; clientIndex++)
	{
		ArrayDestroy(botFollowPoint2[clientIndex]);
		ArrayDestroy(playerEnemy[clientIndex]);
		ArrayDestroy(Array_DeathSounds[clientIndex]);
		ArrayDestroy(Array_PainHeadSounds[clientIndex]);
		ArrayDestroy(Array_PainBodySounds[clientIndex]);
		ArrayDestroy(Array_HeadshotKillSounds[clientIndex]);
		ArrayDestroy(Array_KillSounds[clientIndex]);
		ArrayDestroy(Array_3KillSounds[clientIndex]);
		ArrayDestroy(Array_4KillSounds[clientIndex]);
		ArrayDestroy(Array_5KillSounds[clientIndex]);
		ArrayDestroy(Array_AceSounds[clientIndex]);
		ArrayDestroy(Array_HealSounds[clientIndex]);
		ArrayDestroy(Array_AlmostWinSounds[clientIndex]);
		ArrayDestroy(Array_WinSounds[clientIndex]);
		ArrayDestroy(Array_CantUseSounds[clientIndex]);
		ArrayDestroy(Array_UltReadySounds[clientIndex]);
		ArrayDestroy(Array_Skill1Sounds[clientIndex]);
		ArrayDestroy(Array_Skill2Sounds[clientIndex]);

		ArrayDestroy(playersEnemy[clientIndex]);
		ArrayDestroy(playersTotalDamage[clientIndex]);
		for(bodyGroup = HIT_HEAD; bodyGroup <= HIT_RIGHTLEG; bodyGroup++) 
		{
			ArrayDestroy(playersDamageBody[clientIndex][bodyGroup]);
			ArrayDestroy(playersHitsBody[clientIndex][bodyGroup]);
		}
	}

	ArrayDestroy(playersSTEAMID);
	ArrayDestroy(playersCONNECTED);
	ArrayDestroy(playersAGENT);
	ArrayDestroy(playersSCORE);
	ArrayDestroy(playersDEATH);
	ArrayDestroy(playersCOOLDOWN);

	for(new index = ASAMA_1; index <= ASAMA_FINAL; index++) 
		ArrayDestroy(playersStageWEAPONS[index]);

	ArrayDestroy(Array_weaponOrbENTITIES);

	for(new clientIndex = 1; clientIndex <= MAX_PLAYERS; clientIndex++) 
	{
		ArrayDestroy(ArrayWillRemoveEntities[clientIndex]);
	}
}

public Debug()
{
	new mapNAME[32]; get_mapname(mapNAME, charsmax(mapNAME));
	new currentTIME[64]; get_time("%m-%d-%Y - %H-%M", currentTIME, charsmax(currentTIME));
	formatex(szLOGNAME, charsmax(szLOGNAME), "%s - %s", mapNAME, currentTIME);
}

public Log(const log[], any:...)
{
	#if defined DEBUG
	new logMESSAGE[128]; vformat(logMESSAGE, charsmax(logMESSAGE), log, 2);
	client_print(0, print_console, "Log: %s", logMESSAGE);
	
	static logLine;
	new Url[256]; get_configsdir(Url, charsmax(Url));
	format(Url, charsmax(Url), "%s/Log/%s.txt", Url, szLOGNAME);
	write_file(Url, logMESSAGE, logLine);
	logLine++;
	#endif
}

public Hooks()
{
	Log("%s/Hooks", PLUGIN);

	register_event("HLTV", "OnNewRound", "a", "1=0", "2=0");
	register_event("DeathMsg", "OnPlayerDeath", "a");
	register_event("TeamInfo", "OnChangeTeam" , "a");
	register_event("CurWeapon", "OnEventCurWeapon", "be", "1=1", "2!18");
	
	register_logevent("OnFreezeTimeEnd", 2, "1=Round_Start");
	
	register_forward(FM_UpdateClientData, "OnUpdateClientData", true);
	register_forward(FM_EmitSound, "OnEmitSound");
	register_forward(FM_OnFreeEntPrivateData, "OnRemovedEntity");
	register_forward(FM_AddToFullPack, "OnAddToFullPack", true);
	register_forward(FM_PlayerPreThink, "OnPreThink", true);
	register_forward(FM_PlayerPostThink, "OnPostThink");
	register_forward(FM_ClientUserInfoChanged, "OnClientUserInfoChanged");
	register_forward(FM_CheckVisibility, "OnCheckVisibility");
	register_forward(FM_GetGameDescription, "GetGameDesc");
	register_forward(FM_ClientCommand , "ClientCommands");

	RegisterHookChain(RG_CBasePlayerWeapon_DefaultDeploy, "OnDefaultDeploy", false);
	RegisterHookChain(RG_CBasePlayerWeapon_DefaultDeploy, "OnDefaultDeploy_Post", true);
	RegisterHookChain(RG_CBasePlayer_AddPlayerItem, "OnAddPlayerItem", false);
	RegisterHookChain(RG_CBasePlayer_Spawn, "OnPlayerSpawn", true);
	RegisterHookChain(RG_CBasePlayer_ResetMaxSpeed, "OnResetMaxSpeed");	
	RegisterHookChain(RG_CBasePlayer_Killed, "OnPlayerKilled", false);
	DisableHookChain((HookChain_Killed_Post = RegisterHookChain(RG_CBasePlayer_Killed, "OnPlayerKilled_Post", true)));
	RegisterHookChain(RG_IsPenetrableEntity, "OnPenetrableEntity_Post", true);
	RegisterHookChain(RG_ThrowHeGrenade, "OnThrowHeGrenade_Post", .post = true);
	RegisterHookChain(RG_CBasePlayer_SetAnimation, "OnSetAnimation");
	RegisterHookChain(RG_CGrenade_ExplodeFlashbang, "OnExplodeFlashbang_Pre", false);

	RegisterHam(Ham_TraceAttack, "player", "TraceAttack");
	RegisterHam(Ham_TraceAttack, "env_sprite", "TraceAttack");
	RegisterHam(Ham_TraceAttack, "info_target", "TraceAttack");
	RegisterHam(Ham_TraceAttack, "grenade", "TraceAttack");

	RegisterHam(Ham_TakeDamage, "func_breakable", "TakeDamage");
	RegisterHam(Ham_TakeDamage, "info_target", "TakeDamage");
	RegisterHam(Ham_TakeDamage, "env_sprite", "TakeDamage");
	RegisterHam(Ham_TakeDamage, "grenade", "TakeDamage");

	RegisterHam(Ham_TakeDamage, "player", "TakeDamage");
	RegisterHam(Ham_TakeDamage, "player", "TakeDamage_Post", true);
	RegisterHam(Ham_Think, "grenade", "OnThinkGrenade");

	deathInfoSYNC = CreateHudSyncObj();
	Message_SetFOV = get_user_msgid("SetFOV");
	Message_ScoreInfo = get_user_msgid("ScoreInfo");
	Message_CurWeapon = get_user_msgid("CurWeapon");
	Message_WeapPickup = get_user_msgid("WeapPickup");
	Message_Fog = get_user_msgid("Fog");

	g_Forwards[FW_ON_PLAYER_ASSIST] = CreateMultiForward("OnPlayerAssist", ET_IGNORE, FP_CELL, FP_CELL, FP_CELL);

	register_clcmd("chooseteam", "Agent_Menu");
	register_clcmd("jointeam", "Agent_Menu");
	register_clcmd("drop", "CMD_Drop");

	register_clcmd("nightvision", "Agent_Menu");

	register_clcmd("say /fps", "CMD_FPS");
	register_clcmd("say /crosshair", "CMD_Crosshair");
	register_clcmd("say /cross", "CMD_Crosshair");
	register_clcmd("say /agent", "CMD_Agent");
	register_clcmd("say /ajan", "CMD_Agent");
	register_clcmd("say /karakter", "CMD_Agent");
	register_clcmd("say /yetenekler", "CMD_Agent");
	register_clcmd("say /valomenu", "Agent_Menu");
	register_clcmd("say /menu", "Agent_Menu");
	register_clcmd("say /valorant", "Agent_Menu");
	register_clcmd("say /valo", "Agent_Menu");
	register_clcmd("say /dmmenu", "Agent_Menu");

	register_clcmd("buy_wpn", "vgui_menu_hook");
	register_clcmd("buy", "vgui_menu_hook");
	register_clcmd("say /buy", "vgui_menu_hook");

	register_clcmd("radio1", "Agent_Menu");
	register_clcmd("radio2", "Agent_Menu");
	register_clcmd("radio3", "Hook_C_Skill");

	register_clcmd("say /language", "CMD_Language");
	register_clcmd("say /dil", "CMD_Language");
	register_clcmd("say /reset", "CMD_Reset");
	register_clcmd("say /rs", "CMD_Reset");
	register_clcmd("say /rr", "CMD_Reset");
	register_clcmd("say .rr", "CMD_Reset");
	register_clcmd("say !language", "CMD_Language");
	register_clcmd("say !dil", "CMD_Language");
	register_clcmd("say !reset", "CMD_Reset");
	register_clcmd("say nextmap", "CMD_NextMAP");

	register_message(Message_SetFOV, "OnMessage_SetFOV");
	register_message(get_user_msgid("StatusIcon"), "OnMessage_StatusIcon");
	register_message(get_user_msgid("RoundTime"), "OnMessage_RoundTime");
	register_message(get_user_msgid("SendAudio"), "OnMessage_SendAudio");
	register_message(get_user_msgid("HideWeapon"), "OnMessage_HideWeapon");
	register_message(get_user_msgid("TextMsg"), "OnMessage_TextMsg");

	set_msg_block(Message_WeapPickup, BLOCK_SET);
	set_msg_block(get_user_msgid("AmmoPickup"), BLOCK_SET);

	Vault = nvault_open("player_crosshairs")

 	new weaponENTITYNAMES[][] = { "", "weapon_p228", "", "weapon_scout", "weapon_hegrenade", "weapon_xm1014", "weapon_c4", "weapon_mac10",
			"weapon_aug", "weapon_smokegrenade", "weapon_elite", "weapon_fiveseven", "weapon_ump45", "weapon_sg550",
			"weapon_galil", "weapon_famas", "weapon_usp", "weapon_glock18", "weapon_awp", "weapon_mp5navy", "weapon_m249",
			"weapon_m3", "weapon_m4a1", "weapon_tmp", "weapon_g3sg1", "weapon_flashbang", "weapon_deagle", "weapon_sg552",
			"weapon_ak47", "weapon_knife", "weapon_p90" };

	for(new i; i < sizeof(fwBuckShootTraceAttack_Post); i++)
	{
		DisableHamForward(fwBuckShootTraceAttack_Post[i] = RegisterHam(Ham_TraceAttack, g_szBuckShootTraceAttack[i], "HAM_BuckShoot_TraceAttack_Post", true));
	}

	for (new index = 1; index < sizeof (weaponENTITYNAMES); index++)
	{
		if (weaponENTITYNAMES[index][0]) 
		{
			RegisterHam(Ham_Item_PostFrame, weaponENTITYNAMES[index], "OnWeaponPostFrame");
		}
	}	

	for(new i; i<=charsmax(Commands); i++)
		register_clcmd(Commands[i], "BlockAutobuy")    

	for(new index = 2; index < sizeof(Weapon_Info); index++) 
	{
		if(index == PHANTOM || index == STINGER || index == SPECTRE || index == GUARDIAN || index == BULLDOG || index == VANDAL || index == ODIN || index == ARES)
		{
			register_clcmd(fmt("Jenessee_Valorant/weapons/%s_zoom", Weapon_Info[index][WEAPON_SPRITE_NAME]), fmt("Hook_%s", Weapon_Info[index][WEAPON_ENTITY_NAME]));
		}
		register_clcmd(fmt("Jenessee_Valorant/weapons/%s", Weapon_Info[index][WEAPON_SPRITE_NAME]), fmt("Hook_%s", Weapon_Info[index][WEAPON_ENTITY_NAME]));
	}

	for(new index = 0; index < sizeof(Agent_Skills); index++) 
	{
		register_clcmd(fmt("Jenessee_Valorant/weapons/%s", Agent_Skills[index][SKILL_SPRITE]), "Hook_C_Skill");
	}

	set_task(15.0, "Task_Show_Player_Info", .flags = "b");
	set_task(5.3, "Task_Player_Weapon_Huds", .flags = "b");
	set_task(1.0, "Show_Hud_Messages", .flags = "b");

	maxBOT = sizeof(szBotNames);
	if(ArraySize(botFollowPoint))
        {
                set_task(0.3, "Check_TotalBots", _, _, _, "b");
        } 
}

public BlockAutobuy(clientIndex)
    return PLUGIN_HANDLED

public vgui_menu_hook(clientIndex)
{
	if(!is_user_alive(clientIndex))
		return PLUGIN_CONTINUE

	message_begin(MSG_ONE, get_user_msgid("BuyClose"), _, clientIndex)
	message_end()

	Show_WeaponMenu(clientIndex);
	return PLUGIN_HANDLED
}

public OnNewRound()
{
	Log("%s/OnNewRound", PLUGIN);

	remove_task(TASK_ROUND_STATES, 1);

	currentSTAGE = ASAMA_1;

	for(new clientIndex = 1, bodyGroup, victimIndex; clientIndex <= MAX_PLAYERS; clientIndex++)
	{
		MyLastKiller[clientIndex] = NULLENT;

		if(is_user_connected(clientIndex)) client_cmd(clientIndex, "stopsound");
		myTotalDamage[clientIndex] = 0.0;

		ArrayClear(playersEnemy[clientIndex]);
		ArrayClear(playersTotalDamage[clientIndex]);

		for(bodyGroup = HIT_HEAD; bodyGroup <= HIT_RIGHTLEG; bodyGroup++) 
		{
			ArrayClear(playersDamageBody[clientIndex][bodyGroup]);
			ArrayClear(playersHitsBody[clientIndex][bodyGroup]);
		}

		for(victimIndex = 1; victimIndex <= MAX_PLAYERS; victimIndex++) 
		{
			playerID[clientIndex][victimIndex] = NULLENT;
		}
	}

	for(new arrayIndex = ArraySize(Array_entitiesWillREMOVE)-1, entityIndex; arrayIndex >= 0; arrayIndex--)
	{
		entityIndex = ArrayGetCell(Array_entitiesWillREMOVE, arrayIndex);
		UTIL_RemoveEntity(entityIndex, 0.0);
	}

	attackersHaveBARRIER = false;
	defendersHaveBARRIER = false;

	new Float:vOrigin[3], Float:vAngle[3], Float:vMins[3], Float:vMaxs[3], pointType, Float:boxDISTANCE;
	for(new arrayIndex = ArraySize(Array_itemTYPE)-1; arrayIndex >= 0; arrayIndex--)
	{
		ArrayGetArray(Array_itemORIGIN, arrayIndex, vOrigin, 3);

		if((vAngle[1] = float(ArrayGetCell(Array_itemANGLEY, arrayIndex))) == 1.0) vAngle[1] = 0.0;
		
		pointType = ArrayGetCell(Array_itemTYPE, arrayIndex);
		boxDISTANCE = float(ArrayGetCell(Array_boxDISTANCE, arrayIndex));

		if(pointType == POINT_TYPE_INVISIBLE_WALL || pointType == POINT_TYPE_ATTACKER_ENERGY_BARRIER || pointType == POINT_TYPE_DEFENDER_ENERGY_BARRIER)
		{
			if(vAngle[1] == 0.0 || vAngle[1] == 180.0) {
				vMins[1] = -boxDISTANCE;
				vMaxs[1] = boxDISTANCE;

				vMins[0] = -5.0;
				vMaxs[0] = 5.0;
			} else if(vAngle[1] == 90.0 || vAngle[1] == 270.0) {
				vMins[0] = -boxDISTANCE;
				vMaxs[0] = boxDISTANCE;

				vMins[1] = -5.0;
				vMaxs[1] = 5.0;
			}

			vMaxs[2] = boxDISTANCE*2.0;
		} else if(pointType != POINT_TYPE_ATTACKER_POINT && pointType != POINT_TYPE_DEFENDER_POINT && pointType != POINT_TYPE_BOT_FOLLOW) {
			vMins[0] = -boxDISTANCE;
			vMins[1] = -boxDISTANCE;

			vMaxs[0] = boxDISTANCE;
			vMaxs[1] = boxDISTANCE;
			vMaxs[2] = boxDISTANCE;
		}
		vAngle[1] -= 180.0;
		switch(pointType)
		{
			case POINT_TYPE_INVISIBLE_WALL:
			{
				Create_InvisibleWall(vOrigin, vAngle, vMins, vMaxs);
			}
			case POINT_TYPE_ATTACKER_ENERGY_BARRIER:
			{
				attackersHaveBARRIER = true
				Create_EnergyBarrier(vOrigin, vAngle, vMins, vMaxs, TEAM_ATTACKERS);
			}
			case POINT_TYPE_DEFENDER_ENERGY_BARRIER:
			{
				defendersHaveBARRIER = true
				Create_EnergyBarrier(vOrigin, vAngle, vMins, vMaxs, TEAM_DEFENDERS);
			}
			case POINT_TYPE_HEALTH_POINT:
			{
				if(strlen(orbMODEL)) Create_Orb(vOrigin, vAngle, Float:{-16.0, -16.0, 0.0}, Float:{16.0, 16.0, 16.0}, ORBTYPE_HEAL);
			}
			case POINT_TYPE_SPEED_POINT:
			{
				if(strlen(orbMODEL)) Create_Orb(vOrigin, vAngle, Float:{-16.0, -16.0, 0.0}, Float:{16.0, 16.0, 16.0}, ORBTYPE_SPEED);
			}
			case POINT_TYPE_WEAPON_POINT:
			{
				Create_Orb(vOrigin, vAngle, Float:{-16.0, -16.0, 0.0}, Float:{16.0, 16.0, 16.0}, ORBTYPE_WEAPON);
			}
		}
	}

	RequestFrame("Remove_MapEntities");
}

native find_ent_by_class(const fk, const szname[]);
native remove_entity(const entityIndex);
stock remove_entity_name(const eName[])
{
	new iEntity = find_ent_by_class(-1, eName);
	while (iEntity > 0)
	{
		remove_entity(iEntity);
		iEntity = find_ent_by_class(-1, eName);
	}

	return 1;
}

public Remove_MapEntities()
{
	Log("%s/Remove_MapEntities", PLUGIN);
	Remove_Breakable_Entities();
	remove_entity_name("armoury_entity");
}

public OnFreezeTimeEnd()
{
	Log("%s/OnFreezeTimeEnd", PLUGIN);

	for(new arrayIndex = ArraySize(Array_barrierENTITIES)-1, barrierEntity; arrayIndex >= 0; arrayIndex--)
	{
		barrierEntity = ArrayGetCell(Array_barrierENTITIES, arrayIndex);

		if(get_entvar(barrierEntity, var_solid) == SOLID_TRIGGER)
		{
			SetTouch(barrierEntity, "Touch_PlayerToBarrier");
		} else {
			Semiclip_Entity(barrierEntity, get_entvar(barrierEntity, var_team));
		}
	}

	bCustomAudio = true;
	rg_send_audio(0, Announcer_Sounds[random_num(2, 7)]);
	bCustomAudio = false;

	for(new arrayIndex = ArraySize(Array_playerALIVE)-1, clientIndex, weaponEntity; arrayIndex >= 0; arrayIndex--)
	{
		clientIndex = ArrayGetCell(Array_playerALIVE, arrayIndex);

		if(!playerCOOLDOWN[clientIndex])
		{
			playerCOOLDOWN[clientIndex] = Agent_Skills[playerAgentID[clientIndex]][SKILL_COOLDOWN];

			rg_set_user_bpammo(clientIndex, WEAPON_HEGRENADE, 0);
			weaponEntity = currentWeaponENTITY[clientIndex];
			if(weaponEntity != NULLENT && get_entvar(weaponEntity, var_impulse) == 0) 
			{
				ExecuteHamB(Ham_Weapon_RetireWeapon, weaponEntity);
			}
			rg_remove_items_by_slot(clientIndex, GRENADE_SLOT);
			lastWeaponENTITY[clientIndex] = NULLENT;
		}

		if((playerTEAM[clientIndex] == TEAM_ATTACKERS && attackersHaveBARRIER) || (playerTEAM[clientIndex] == TEAM_DEFENDERS && defendersHaveBARRIER)) {
			new params[1]; params[0] = clientIndex;
			set_task(immortalTime, "Task_Immortal_End", clientIndex+TASK_PLAYER_IMMORTAL, params, sizeof(params));
			set_task(0.1, "Task_BarrierInside_Sound", clientIndex+TASK_PLAYER_IMMORTAL, params, sizeof(params));
		} else {
			set_user_rendering(clientIndex);
			playerInBASE[clientIndex] = false;
		}
	}

	set_task(93.0, "Task_Stage_2_Warning", TASK_ROUND_STATES);
	set_task(103.0, "Task_Stage_2", TASK_ROUND_STATES);

	set_task(168.0, "Task_Stage_3_Warning", TASK_ROUND_STATES);
	set_task(178.0, "Task_Stage_3", TASK_ROUND_STATES);

	set_task(243.0, "Task_Stage_FINAL_Warning", TASK_ROUND_STATES);
	set_task(253.0, "Task_Stage_FINAL", TASK_ROUND_STATES);

	set_task(540.0, "Task_Last_60_Seconds", TASK_ROUND_STATES);

	set_task(567.0, "Task_Quote", TASK_ROUND_STATES);

	set_task(570.0, "Task_Last_30_Seconds", TASK_ROUND_STATES);
	set_task(590.0, "Task_Last_10_Seconds", TASK_ROUND_STATES);

	set_task(600.0, "Task_Game_End", TASK_ROUND_STATES);
}

public Task_Stage_2_Warning()
{
	Log("%s/Task_Stage_2_Warning", PLUGIN);

	bCustomAudio = true;
	rg_send_audio(0, Announcer_Sounds[random_num(11, 12)]);
	bCustomAudio = false;
}

public Remove_Breakable_Entities()
{
	new szMapName[32]; get_mapname(szMapName, sizeof (szMapName));
	if(equal(szMapName, "de_aztec"))
	{
		new iEntity = find_ent_by_class(-1, "func_breakable"), entityIndex;
		while (iEntity > entityIndex)
		{
			set_entvar(iEntity, var_health, 1.0);
			set_entvar(iEntity, var_takedamage, DAMAGE_YES);
			ExecuteHamB(Ham_TakeDamage, iEntity, 0, 0, 100.0, DMG_BULLET);
		
			entityIndex = find_ent_by_class(-1, "func_breakable");
			iEntity = entityIndex;
		}
	} else {
		remove_entity_name("func_breakable");
	}
}

public Task_Stage_2()
{
	Log("%s/Task_Stage_2", PLUGIN);

	bCustomAudio = true;
	rg_send_audio(0, Announcer_Sounds[random_num(13, 14)]);
	bCustomAudio = false;

	currentSTAGE = ASAMA_2;

	for(new arrayIndex = ArraySize(Array_playerALIVE)-1, clientIndex; arrayIndex >= 0; arrayIndex--)
	{
		clientIndex = ArrayGetCell(Array_playerALIVE, arrayIndex);

		bUpdateMenu[clientIndex] = true;

		remove_task(clientIndex+TASK_WEAPON_UPGRADE);
		if(upgradeWeaponTIME)
		{
			if(strlen(weaponChangeSPRITE)) 
			{
				for(new arrayIndex = iTotalWillRemoveEntities[clientIndex]-1, entityMODEL[128], entityIndex; arrayIndex >= 0; arrayIndex--)
				{	
					entityIndex = ArrayGetCell(ArrayWillRemoveEntities[clientIndex], arrayIndex);
					get_entvar(entityIndex, var_model, entityMODEL, charsmax(entityMODEL));

					if(equal(entityMODEL, weaponChangeSPRITE) || equal(entityMODEL, Kill_Mark[0][1]) || equal(entityMODEL, Kill_Mark[1][1]) || equal(entityMODEL, Kill_Mark[2][1]) || equal(entityMODEL, Kill_Mark[3][1]) || equal(entityMODEL, Kill_Mark[4][1]))
					{
						UTIL_RemoveEntity(entityIndex, 0.0);
					}
				}
				Create_View_Sprite(clientIndex, weaponChangeSPRITE, 4, 4096, 0.03, 0.0, upgradeWeaponTIME, 1.0, 19.0, 0.1, true, clientIndex, false);
			}

			if(strlen(weaponChangeSOUND)) PlaySound(clientIndex, weaponChangeSOUND);

			set_dhudmessage(255, 255, 255, -1.0, 0.6, 0, 0.0, upgradeWeaponTIME, 0.1, 0.0);
			show_dhudmessage(clientIndex, "%L", clientIndex, "WEAPON_UPGRADE_G");

			rg_send_bartime(clientIndex, floatround(upgradeWeaponTIME), false);
			new params[1]; params[0] = clientIndex;
			set_task(upgradeWeaponTIME, "Task_Change_Weapon_End", clientIndex+TASK_WEAPON_UPGRADE, params, sizeof(params));
		}
	}
	
	new Array:Array_SelectedWeapons; Array_SelectedWeapons = ArrayCreate(1, 1);
	for(new arrayIndex = ArraySize(Array_weaponOrbENTITIES)-1, orbEntity; arrayIndex >= 0; arrayIndex--)
	{
		orbEntity = ArrayGetCell(Array_weaponOrbENTITIES, arrayIndex);

		for(new index = 2; index < sizeof(Weapon_Info); index++)
		{
			if(currentSTAGE != Weapon_Info[index][WEAPON_STAGE_LEVEL])
				continue;
			if(!strlen(Weapon_Info[index][WEAPON_D_MODEL]))
				continue;

			ArrayPushCell(Array_SelectedWeapons, index);
		}
		if(ArraySize(Array_SelectedWeapons))
		{
			new randomWeapon = ArrayGetCell(Array_SelectedWeapons, random_num(0, ArraySize(Array_SelectedWeapons)-1));
			engfunc(EngFunc_SetModel, orbEntity, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Weapon_Info[randomWeapon][WEAPON_D_MODEL]));  
			set_entvar(orbEntity, var_code, randomWeapon);
		}
		
		ArrayClear(Array_SelectedWeapons);
	}

	ArrayDestroy(Array_SelectedWeapons);
}

public Task_Stage_3_Warning()
{
	Log("%s/Task_Stage_3_Warning", PLUGIN);

	bCustomAudio = true;
	rg_send_audio(0, Announcer_Sounds[random_num(11, 12)]);
	bCustomAudio = false;
}

public Task_Stage_3()
{
	Log("%s/Task_Stage_3", PLUGIN);

	bCustomAudio = true;
	rg_send_audio(0, Announcer_Sounds[random_num(15, 16)]);
	bCustomAudio = false;

	currentSTAGE = ASAMA_3;

	for(new arrayIndex = ArraySize(Array_playerALIVE)-1, clientIndex; arrayIndex >= 0; arrayIndex--)
	{
		clientIndex = ArrayGetCell(Array_playerALIVE, arrayIndex);

		bUpdateMenu[clientIndex] = true;

		remove_task(clientIndex+TASK_WEAPON_UPGRADE);
		if(upgradeWeaponTIME)
		{
			if(strlen(weaponChangeSPRITE)) 
			{
				for(new arrayIndex = iTotalWillRemoveEntities[clientIndex]-1, entityMODEL[128], entityIndex; arrayIndex >= 0; arrayIndex--)
				{	
					entityIndex = ArrayGetCell(ArrayWillRemoveEntities[clientIndex], arrayIndex);
					get_entvar(entityIndex, var_model, entityMODEL, charsmax(entityMODEL));

					if(equal(entityMODEL, weaponChangeSPRITE) || equal(entityMODEL, Kill_Mark[0][1]) || equal(entityMODEL, Kill_Mark[1][1]) || equal(entityMODEL, Kill_Mark[2][1]) || equal(entityMODEL, Kill_Mark[3][1]) || equal(entityMODEL, Kill_Mark[4][1]))
					{
						UTIL_RemoveEntity(entityIndex, 0.0);
					}
				}
				Create_View_Sprite(clientIndex, weaponChangeSPRITE, 4, 4096, 0.03, 0.0, upgradeWeaponTIME, 1.0, 19.0, 0.1, true, clientIndex, false);
			}

			if(strlen(weaponChangeSOUND)) PlaySound(clientIndex, weaponChangeSOUND);

			set_dhudmessage(255, 255, 255, -1.0, 0.6, 0, 0.0, upgradeWeaponTIME, 0.1, 0.0);
			show_dhudmessage(clientIndex, "%L", clientIndex, "WEAPON_UPGRADE_G");

			rg_send_bartime(clientIndex, floatround(upgradeWeaponTIME), false);
			new params[1]; params[0] = clientIndex;
			set_task(upgradeWeaponTIME, "Task_Change_Weapon_End", clientIndex+TASK_WEAPON_UPGRADE, params, sizeof(params));
		}
	}

	new Array:Array_SelectedWeapons; Array_SelectedWeapons = ArrayCreate(1, 1);
	for(new arrayIndex = ArraySize(Array_weaponOrbENTITIES)-1, orbEntity; arrayIndex >= 0; arrayIndex--)
	{
		orbEntity = ArrayGetCell(Array_weaponOrbENTITIES, arrayIndex);

		for(new index = 2; index < sizeof(Weapon_Info); index++)
		{
			if(currentSTAGE != Weapon_Info[index][WEAPON_STAGE_LEVEL])
				continue;
			if(!strlen(Weapon_Info[index][WEAPON_D_MODEL]))
				continue;

			ArrayPushCell(Array_SelectedWeapons, index);
		}
		if(ArraySize(Array_SelectedWeapons))
		{
			new randomWeapon = ArrayGetCell(Array_SelectedWeapons, random_num(0, ArraySize(Array_SelectedWeapons)-1));
			engfunc(EngFunc_SetModel, orbEntity, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Weapon_Info[randomWeapon][WEAPON_D_MODEL]));  
			set_entvar(orbEntity, var_code, randomWeapon);
		}
		
		ArrayClear(Array_SelectedWeapons);
	}

	ArrayDestroy(Array_SelectedWeapons);
}

public Task_Stage_FINAL_Warning()
{
	Log("%s/Task_Stage_FINAL_Warning", PLUGIN);

	bCustomAudio = true;
	rg_send_audio(0, Announcer_Sounds[random_num(11, 12)]);
	bCustomAudio = false;
}

public Task_Stage_FINAL()
{
	Log("%s/Task_Stage_FINAL", PLUGIN);

	bCustomAudio = true;
	rg_send_audio(0, Announcer_Sounds[random_num(17, 18)]);
	bCustomAudio = false;

	currentSTAGE = ASAMA_FINAL;

	for(new arrayIndex = ArraySize(Array_playerALIVE)-1, clientIndex; arrayIndex >= 0; arrayIndex--)
	{
		clientIndex = ArrayGetCell(Array_playerALIVE, arrayIndex);

		bUpdateMenu[clientIndex] = true;

		remove_task(clientIndex+TASK_WEAPON_UPGRADE);
		if(upgradeWeaponTIME)
		{
			if(strlen(weaponChangeSPRITE)) 
			{
				for(new arrayIndex = iTotalWillRemoveEntities[clientIndex]-1, entityMODEL[128], entityIndex; arrayIndex >= 0; arrayIndex--)
				{	
					entityIndex = ArrayGetCell(ArrayWillRemoveEntities[clientIndex], arrayIndex);
					get_entvar(entityIndex, var_model, entityMODEL, charsmax(entityMODEL));

					if(equal(entityMODEL, weaponChangeSPRITE) || equal(entityMODEL, Kill_Mark[0][1]) || equal(entityMODEL, Kill_Mark[1][1]) || equal(entityMODEL, Kill_Mark[2][1]) || equal(entityMODEL, Kill_Mark[3][1]) || equal(entityMODEL, Kill_Mark[4][1]))
					{
						UTIL_RemoveEntity(entityIndex, 0.0);
					}
				}
				Create_View_Sprite(clientIndex, weaponChangeSPRITE, 4, 4096, 0.03, 0.0, upgradeWeaponTIME, 1.0, 19.0, 0.1, true, clientIndex, false);
			}

			if(strlen(weaponChangeSOUND)) PlaySound(clientIndex, weaponChangeSOUND);

			set_dhudmessage(255, 255, 255, -1.0, 0.6, 0, 0.0, upgradeWeaponTIME, 0.1, 0.0);
			show_dhudmessage(clientIndex, "%L", clientIndex, "WEAPON_UPGRADE_G");

			rg_send_bartime(clientIndex, floatround(upgradeWeaponTIME), false);
			new params[1]; params[0] = clientIndex;
			set_task(upgradeWeaponTIME, "Task_Change_Weapon_End", clientIndex+TASK_WEAPON_UPGRADE, params, sizeof(params));
		}
	}
	
	new Array:Array_SelectedWeapons; Array_SelectedWeapons = ArrayCreate(1, 1);
	for(new arrayIndex = ArraySize(Array_weaponOrbENTITIES)-1, orbEntity; arrayIndex >= 0; arrayIndex--)
	{
		orbEntity = ArrayGetCell(Array_weaponOrbENTITIES, arrayIndex);

		for(new index = 2; index < sizeof(Weapon_Info); index++)
		{
			if(currentSTAGE != Weapon_Info[index][WEAPON_STAGE_LEVEL])
				continue;
			if(!strlen(Weapon_Info[index][WEAPON_D_MODEL]))
				continue;

			ArrayPushCell(Array_SelectedWeapons, index);
		}
		if(ArraySize(Array_SelectedWeapons))
		{
			new randomWeapon = ArrayGetCell(Array_SelectedWeapons, random_num(0, ArraySize(Array_SelectedWeapons)-1));
			engfunc(EngFunc_SetModel, orbEntity, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Weapon_Info[randomWeapon][WEAPON_D_MODEL]));  
			set_entvar(orbEntity, var_code, randomWeapon);
		}
		
		ArrayClear(Array_SelectedWeapons);
	}

	ArrayDestroy(Array_SelectedWeapons);
}

public Task_Last_60_Seconds()
{
	Log("%s/Task_Last_60_Seconds", PLUGIN);

	bCustomAudio = true;
	rg_send_audio(0, Announcer_Sounds[random_num(25, 26)]);
	bCustomAudio = false;
}

public Task_Quote()
{
	Log("%s/Task_Quote", PLUGIN);

	for(new arrayIndex = ArraySize(Array_playerALIVE)-1, clientIndex; arrayIndex >= 0; arrayIndex--)
	{
		clientIndex = ArrayGetCell(Array_playerALIVE, arrayIndex);

		Character_Quote(clientIndex, QUOTE_ALMOST_WIN);
	}
}

public Task_Final_Background_Loop()
{
	Log("%s/Task_Final_Background_Loop", PLUGIN);

	PlaySound(0, Background_Musics[selectedFinalBACKGROUND]);
}

public Task_Last_30_Seconds()
{
	Log("%s/Task_Last_30_Seconds", PLUGIN);

	bCustomAudio = true;
	rg_send_audio(0, Announcer_Sounds[random_num(22, 24)]);
	bCustomAudio = false;

	selectedFinalBACKGROUND = random_num(0, 2);

	set_task(0.5, "Task_Final_Background_Loop", TASK_ROUND_STATES);
}

public Task_Last_10_Seconds()
{
	Log("%s/Task_Last_10_Seconds", PLUGIN);

	bCustomAudio = true;
	rg_send_audio(0, Announcer_Sounds[random_num(19, 21)]);
	bCustomAudio = false;
}

public Task_Game_End()
{
	Log("%s/Task_Game_End", PLUGIN);

	remove_task(TASK_ROUND_STATES);
	set_task(2.0, "Task_Game_End_Sound", TASK_ROUND_STATES);
	if(strlen(nextMAP)) set_task(6.0, "Task_Game_ChangeLevel", TASK_ROUND_STATES);

	new bool:bAttackerWin, bool:bDraw;
	if(get_member_game(m_iNumTerroristWins) > get_member_game(m_iNumCTWins)) bAttackerWin = true;
	if(get_member_game(m_iNumTerroristWins) == get_member_game(m_iNumCTWins)) bDraw = true;
	if(get_member_game(m_iNumCTWins) > get_member_game(m_iNumTerroristWins)) bAttackerWin = false;

	if(!bDraw)
	{
		if(bAttackerWin)
		{
			PlaySound(0, Announcer_Sounds[27]);
		} else {
			PlaySound(0, Announcer_Sounds[28]);
		}
	}
}

public Task_Game_End_Sound()
{
	Log("%s/Task_Game_End_Sound", PLUGIN);

	new bool:bAttackerWin, bool:bDraw;
	if(get_member_game(m_iNumTerroristWins) > get_member_game(m_iNumCTWins)) bAttackerWin = true;
	if(get_member_game(m_iNumTerroristWins) == get_member_game(m_iNumCTWins)) bDraw = true;
	if(get_member_game(m_iNumCTWins) > get_member_game(m_iNumTerroristWins)) bAttackerWin = false;

	for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, clientIndex; arrayIndex >= 0; arrayIndex--)
	{
		clientIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);
		CMD_NextMAP(clientIndex);
		if(bDraw)
		{
			PlaySound(clientIndex, Background_Musics[10]);
			continue;
		}
		if(bAttackerWin)
		{
			if(playerTEAM[clientIndex] == TEAM_ATTACKERS)
			{
				Character_Quote(clientIndex, QUOTE_WIN);
				PlaySound(clientIndex, Background_Musics[10]);
			} else {
				PlaySound(clientIndex, Background_Musics[9]);
			}
		} else {
			if(playerTEAM[clientIndex] == TEAM_DEFENDERS)
			{
				Character_Quote(clientIndex, QUOTE_WIN);
				PlaySound(clientIndex, Background_Musics[10]);
			} else {
				PlaySound(clientIndex, Background_Musics[9]);
			}
		}
	}
}

public Task_Game_ChangeLevel()
{
	Log("%s/Task_Game_ChangeLevel", PLUGIN);
	server_cmd("changelevel %s", nextMAP);
}

public CMD_Drop(const clientIndex)
{
	if(!is_user_alive(clientIndex))
		return PLUGIN_CONTINUE

	Log("%s/CMD_Drop", PLUGIN);

	if(task_exists(clientIndex+TASK_WEAPON_UPGRADE, 1))
	{
		rg_send_bartime(clientIndex, 0, false);

		remove_task(clientIndex+TASK_WEAPON_UPGRADE, 1);

		new weaponID = Asama_Silahlari[MyStageWeapons[clientIndex][currentSTAGE]][1];
		if(weaponID != NULLENT)
		{
			set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 0);
		} else if(currentSTAGE > ASAMA_1) {
			weaponID = Asama_Silahlari[MyStageWeapons[clientIndex][ASAMA_1]][1];
			if(weaponID != NULLENT)
			{
				set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 0);
			} 
		} 

		weaponID = Asama_Silahlari[MyStageWeapons[clientIndex][currentSTAGE]][0];
		if(weaponID != NULLENT)
		{
			set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 0);
		} else if(currentSTAGE != ASAMA_1){
			rg_remove_items_by_slot(clientIndex, PRIMARY_WEAPON_SLOT);
		}
	}
	return PLUGIN_HANDLED
}

public Task_Change_Weapon_End(params[], taskid)
{
	//new clientIndex = params[0];

	Log("%s/Task_Change_Weapon_End", PLUGIN);
}

public Task_BarrierInside_Sound(params[], taskid)
{
	new clientIndex = params[0];

	Log("%s/Task_BarrierInside_Sound", PLUGIN);

	if(strlen(barrierInsideSound)) 
	{
		rh_emit_sound(clientIndex, clientIndex, CHAN_ITEM, barrierInsideSound, 0.15, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	}
}

public OnUpdateClientData(const clientIndex, const sendweapons, const cd_handle)
{
	set_cd(cd_handle, CD_flNextAttack, get_gametime() + 1000.0);  
	return FMRES_HANDLED;   
}

public OnWeaponPostFrame(const weaponEntity)
{	
	new clientIndex = get_member(weaponEntity, m_pPlayer);
	if(clientIndex > 0 && clientIndex <= MAX_PLAYERS)
	{	
		if(get_member(weaponEntity, m_iId) != WEAPON_HEGRENADE || (playerAgentID[clientIndex] != AGENT_RAZE && playerAgentID[clientIndex] != AGENT_DEADLOCK))
		{
			set_member(clientIndex, m_flNextAttack, 1000.0);
			return HAM_SUPERCEDE;
		}
	}
	return HAM_IGNORED;
}

public OnEmitSound(const clientIndex, const channel, const sample[], const Float:volume, const Float:attn, const flags, const pitch)
{
	if(clientIndex > 0 && clientIndex <= MAX_PLAYERS)
	{
		Log("%s/OnEmitSound", PLUGIN);

		if (sample[7] == 'b' && sample[8] == 'h' && sample[9] == 'i' && sample[10] == 't')
		{
			Character_Quote(clientIndex, QUOTE_PAIN);

			static Float:delaysound;
			if(delaysound <= get_gametime())
			{
				rh_emit_sound(clientIndex, clientIndex, CHAN_STATIC, Body_Damage_Take[random_num(0, sizeof(Body_Damage_Take)-1)], 0.4, attn, flags, pitch, SND_EMIT2_NOPAS);
				if(MyLastAttacker[clientIndex] != NULLENT && is_user_connected(MyLastAttacker[clientIndex]))
				{
					rh_emit_sound(clientIndex, MyLastAttacker[clientIndex], CHAN_STATIC, Body_Damage_Victim[random_num(0, sizeof(Body_Damage_Victim)-1)], 0.6, ATTN_NONE, flags, pitch, SND_EMIT2_NOPAS);
				}
				delaysound = get_gametime() + 0.1;
			}
			return FMRES_SUPERCEDE;
		}	

		if(sample[7] == 'h' && sample[8] == 'e' && sample[9] == 'a' && sample[10] == 'd')
		{
			Character_Quote(clientIndex, QUOTE_PAIN_HEAD);

			static Float:delaysound;
			if(delaysound <= get_gametime())
			{
				rh_emit_sound(clientIndex, clientIndex, CHAN_STATIC, Head_Damage_Take[random_num(0, sizeof(Head_Damage_Take)-1)], 1.0, attn, flags, pitch, SND_EMIT2_NOPAS);
				if(MyLastAttacker[clientIndex] != NULLENT && is_user_connected(MyLastAttacker[clientIndex]))
				{
					rh_emit_sound(clientIndex, MyLastAttacker[clientIndex], CHAN_STATIC, Head_Damage_Victim[random_num(0, sizeof(Head_Damage_Victim)-1)], 0.6, ATTN_NONE, flags, pitch, SND_EMIT2_NOPAS);
				}
				delaysound = get_gametime() + 0.1;
			}
			return FMRES_SUPERCEDE;
		}

		if (sample[7] == 'd' && ((sample[8] == 'i' && sample[9] == 'e') || (sample[8] == 'e' && sample[9] == 'a')))
		{
			if(ArraySize(Array_DeathSounds[clientIndex]))
			{
				new szSound[128]; ArrayGetString(Array_DeathSounds[clientIndex], random_num(0, ArraySize(Array_DeathSounds[clientIndex])-1), szSound, charsmax(szSound));
				rh_emit_sound(clientIndex, 0, channel, szSound, volume, attn, flags, pitch, SND_EMIT2_NOPAS);
				return FMRES_SUPERCEDE;
			}
		}	

		if(sample[14] == 'd' && sample[15] == 'e' && sample[16] == 'p' || contain(sample, "wpn_denyselect")) 
		{
			return FMRES_SUPERCEDE;
		}
	}	

	return FMRES_IGNORED;
}

public OnRemovedEntity(const entityIndex)
{
	Log("%s/OnRemovedEntity %i", PLUGIN, entityIndex);

	if(bSemiclipATTACKER[entityIndex])
	{
		bSemiclipATTACKER[entityIndex] = false;

		new arrayIndex;
		if((arrayIndex = ArrayFindValue(Array_semiclipATTACKER, entityIndex)) != -1)
		{
			ArrayDeleteItem(Array_semiclipATTACKER, arrayIndex);
			TotalSemiclipATTACKER--;
		}
	} 

	if(bSemiclipDEFENDER[entityIndex]) 
	{
		bSemiclipDEFENDER[entityIndex] = false;

		new arrayIndex;
		if((arrayIndex = ArrayFindValue(Array_semiclipDEFENDER, entityIndex)) != -1)
		{
			ArrayDeleteItem(Array_semiclipDEFENDER, arrayIndex);
			TotalSemiclipDEFENDER--;
		}
	}

	if(bEntityHavePARENT[entityIndex])
	{
		Log("%s/OnRemovedEntity %i PARENT", PLUGIN, entityIndex);

		bEntityHavePARENT[entityIndex] = false;

		new parentEntity = entityPARENT[entityIndex];
		if(parentEntity != NULLENT)
		{
			new arrayIndex;
			if((arrayIndex = ArrayFindValue(entityCHILDRENS[parentEntity], entityIndex)) != -1)
			{
				ArrayDeleteItem(entityCHILDRENS[parentEntity], arrayIndex);
				entityTotalCHILDRENS[parentEntity]--;
			}
			entityPARENT[entityIndex] = NULLENT;
		}
	}

	if(entityTotalCHILDRENS[entityIndex] > 0)
	{
		Log("%s/OnRemovedEntity %i CHILDRENS", PLUGIN, entityIndex);

		for(new arrayIndex = entityTotalCHILDRENS[entityIndex]-1, childrenEntity; arrayIndex >= 0; arrayIndex--)
		{
			childrenEntity = ArrayGetCell(entityCHILDRENS[entityIndex], arrayIndex);

			if(bProwlerEntity[childrenEntity])
				set_entvar(childrenEntity, var_parent, 0);

			UTIL_RemoveEntity(childrenEntity, 0.0);
		}
	}

	if(entityWillREMOVE[entityIndex])
	{
		Log("%s/OnRemovedEntity %i WILLREMOVE", PLUGIN, entityIndex);

		new arrayIndex;
		if((arrayIndex = ArrayFindValue(Array_entitiesWillREMOVE, entityIndex)) != -1)
			ArrayDeleteItem(Array_entitiesWillREMOVE, arrayIndex);

		entityWillREMOVE[entityIndex] = false;
	}

	if(entityBARRIER[entityIndex])
	{
		Log("%s/OnRemovedEntity %i BARRIER", PLUGIN, entityIndex);

		remove_task(entityIndex+TASK_BARRIER_LINES);

		new arrayIndex;
		if((arrayIndex = ArrayFindValue(Array_barrierENTITIES, entityIndex)) != -1)
			ArrayDeleteItem(Array_barrierENTITIES, arrayIndex);

		entityBARRIER[entityIndex] = false;
	}

	if(task_exists(entityIndex+TASK_REMOVE_ENTITY, 1))
	{
		remove_task(entityIndex+TASK_REMOVE_ENTITY);
	}

	if(task_exists(entityIndex+TASK_ORB_COOLDOWN, 1))
	{
		remove_task(entityIndex+TASK_ORB_COOLDOWN);
	}

	if(task_exists(entityIndex+TASK_WEAPON, 1))
	{
		remove_task(entityIndex+TASK_WEAPON);
	}

	if(task_exists(entityIndex+TASK_BOMB, 1))
	{
		remove_task(entityIndex+TASK_BOMB);
	}

	if(bMuteEntity[entityIndex])
	{
		rh_emit_sound(entityIndex, 0, CHAN_ITEM, "common/null.wav", VOL_NORM, ATTN_IDLE, SND_STOP, PITCH_NORM, SND_EMIT2_NOPAS);
		rh_emit_sound(entityIndex, 0, CHAN_ITEM, "common/null.wav", VOL_NORM, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		bMuteEntity[entityIndex] = false;
	}

	if(entityWeaponORB[entityIndex])
	{
		new arrayIndex;
		if((arrayIndex = ArrayFindValue(Array_weaponOrbENTITIES, entityIndex)) != -1)
			ArrayDeleteItem(Array_weaponOrbENTITIES, arrayIndex);

		entityWeaponORB[entityIndex] = false;
	}

	if(bEntityHaveTeam[entityIndex])
	{
		bEntityHaveTeam[entityIndex] = false;
	}

	if(bEntitySprite[entityIndex])
	{
		Log("%s/OnRemovedEntity %i SPRITE", PLUGIN, entityIndex);

		bEntitySprite[entityIndex] = false;
		bEntityFullPack[entityIndex] = false;

		remove_task(entityIndex+TASK_VIEWSPRITE, 1);

		new clientIndex = get_entvar(entityIndex, var_owner);
		if(clientIndex > 0 && clientIndex <= MAX_PLAYERS)
		{
			new iArrayID;
			if((iArrayID = ArrayFindValue(ArrayWillRemoveEntities[clientIndex], entityIndex)) != -1)
			{
				ArrayDeleteItem(ArrayWillRemoveEntities[clientIndex], iArrayID);
				iTotalWillRemoveEntities[clientIndex]--;
			}
		}
	}

	if(bSkyBoxEntity[entityIndex])
	{
		new clientIndex = get_entvar(entityIndex, var_owner);
		if(clientIndex > 0 && clientIndex <= MAX_PLAYERS)
		{
			mySkyBox[clientIndex] = -1;
		}
		bSkyBoxEntity[entityIndex] = false;
	}

	if(bEyeEntity[entityIndex])
	{
		new Float:vEyeOrigin[3]; get_entvar(entityIndex, var_origin, vEyeOrigin);
		Create_Model_Sprite(0, Skill_Resources[27], vEyeOrigin, VP_PARALLEL, 0, 0.04, 0.0, 0.0, 0, 0.0, 11, false, false);
		rh_emit_sound(entityIndex, 0, CHAN_NETWORKVOICE_END, Skill_Resources[26], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		bEyeEntity[entityIndex] = false;
	}

	if(bDeadlockEntity[entityIndex])
	{
		new Float:vOrigin[3]; get_entvar(entityIndex, var_origin, vOrigin);
		vOrigin[2] += 30.0;
		Create_Model_Sprite(0, Skill_Resources[37], vOrigin, VP_PARALLEL, 0, 0.04, 0.0, 0.0, 0, 0.0, 18, false, false);
		rh_emit_sound(entityIndex, 0, CHAN_ITEM, Skill_Resources[34], 1.0, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		bDeadlockEntity[entityIndex] = false;
	}
	
	if(bProwlerEntity[entityIndex])
	{
		new Float:vOrigin[3]; get_entvar(entityIndex, var_origin, vOrigin);
		Create_Model_Sprite(0, Skill_Resources[41], vOrigin, VP_PARALLEL, 0, 0.08, 0.0, 0.0, 0, 0.0, 14, false, false);
		
		if(!get_entvar(entityIndex, var_iuser3))
			rh_emit_sound(entityIndex, 0, CHAN_ITEM, Skill_Resources[get_entvar(entityIndex, var_health) > 0.0 ? 53 : 52], 1.0, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		
		if(get_entvar(entityIndex, var_parent) > 0)
		{
			UTIL_RemoveEntity(get_entvar(entityIndex, var_parent), 0.0);
		}

		new enemyIndex = get_entvar(entityIndex, var_enemy);
		if(!is_nullent(enemyIndex))
		{
			set_entvar(enemyIndex, var_flags, get_entvar(enemyIndex, var_flags) & ~FL_FROZEN);
		}

		bProwlerEntity[entityIndex] = false;
	}

	if(bDeadlockEffect[entityIndex]) bDeadlockEffect[entityIndex] = false;
	if(bEntityMap[entityIndex]) bEntityMap[entityIndex] = false;
	if(bRazeBomb[entityIndex]) bRazeBomb[entityIndex] = false;

	if(bCameraEntity[entityIndex])
	{
		bCameraEntity[entityIndex] = false;
		
		new clientIndex = get_entvar(entityIndex, var_owner);
		if(clientIndex > 0 && clientIndex <= MAX_PLAYERS)
		{
			if(cameraEntity[clientIndex] == entityIndex)	
			{
				if(is_user_connected(clientIndex) && get_viewent(clientIndex) == entityIndex) 
				{
					engset_view(clientIndex, clientIndex);
				}
				cameraEntity[clientIndex] = NULLENT;
			}
		}
	}
}

public client_authorized(clientIndex)
{    
    set_user_info(clientIndex, "_vgui_menus", "0")
    
    client_cmd(clientIndex, "setinfo _vgui_menus 0")
    client_cmd(clientIndex, "unbind b")
    client_cmd(clientIndex, "bind b buy")
}

public client_putinserver(clientIndex)
{
	if(!is_user_connected(clientIndex))
		return;
	
	static bool:hamBOT;
	if(!hamBOT && !bRealBot[clientIndex] && is_user_bot(clientIndex))
	{
		haveBot = true;

		hamBOT = true
		//set_task(0.1, "RegisterHamBot", clientIndex)
	}

	Log("%s/client_putinserver (client %i)", PLUGIN, clientIndex);

	client_cmd(clientIndex, "crosshair 1");

	get_user_name(clientIndex, playerNAME[clientIndex], sizeof(playerNAME));
	if(!is_user_bot(clientIndex))
	{
		static szPlayerIP[17]; get_user_ip(clientIndex, szPlayerIP, charsmax(szPlayerIP));
		geoip_country_ex(szPlayerIP, playerCOUNTRY[clientIndex], charsmax(playerCOUNTRY));
		if(!strlen(playerCOUNTRY[clientIndex])) playerCOUNTRY[clientIndex] = "-";

		bPlayerTurkish[clientIndex] = equal(playerCOUNTRY[clientIndex], "Turkey") ? true : false;

		client_cmd(clientIndex, "setinfo ^"lang^" ^"%s^"", bPlayerTurkish[clientIndex] ? "tr" : "en");
		set_user_info(clientIndex, "lang", bPlayerTurkish[clientIndex] ? "tr" : "en");
	
		for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, playerIndex; arrayIndex >= 0; arrayIndex--)
		{
			playerIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);

			if(is_user_bot(playerIndex))
				continue;

			Color_Chat(playerIndex, 0, "!g[%s]!n %L", PLUGIN, playerIndex, "PLAYER_CONNECTED", playerNAME[clientIndex], playerCOUNTRY[clientIndex]);	
		}
	} 

	if(ArrayFindValue(Array_playerCONNECTED, clientIndex) == -1)
		ArrayPushCell(Array_playerCONNECTED, clientIndex);

	if(ArrayFindValue(Array_playerDEAD, clientIndex) == -1)
		ArrayPushCell(Array_playerDEAD, clientIndex);

	playerNextAgent[clientIndex] = random_num(AGENT_JETT, AGENT_DEADLOCK);
	bUpdateMenu[clientIndex] = true;
	bFovTYPE[clientIndex] = false;
	if(!is_user_bot(clientIndex))
	{
		new steamID[32]; get_user_authid(clientIndex, steamID, charsmax(steamID));
		formatex(IDFormat[clientIndex], charsmax(IDFormat), "%s-Crosshair", steamID)
		nvault_get(Vault, IDFormat[clientIndex], Crosshair[clientIndex], charsmax(IDFormat))
		playerCROSSHAIR[clientIndex] = str_to_num(Crosshair[clientIndex])
		if(playerCROSSHAIR[clientIndex] < 0 || playerCROSSHAIR[clientIndex] >= sizeof(Crosshair_Info))   
		{
			playerCROSSHAIR[clientIndex] = 0;
			num_to_str(playerCROSSHAIR[clientIndex], Crosshair[clientIndex], charsmax(Crosshair))
			nvault_set(Vault, IDFormat[clientIndex], Crosshair[clientIndex])
		}

		formatex(IDFormat[clientIndex], charsmax(IDFormat), "%s-FOV", steamID);
		nvault_get(Vault, IDFormat[clientIndex], FOVTYPE[clientIndex], charsmax(IDFormat))
		bFovTYPE[clientIndex] = str_to_num(FOVTYPE[clientIndex]) > 0 ? true : false;

		formatex(IDFormat[clientIndex], charsmax(IDFormat), "%s-HIDE", steamID);
		nvault_get(Vault, IDFormat[clientIndex], HIDEPLAYERS[clientIndex], charsmax(IDFormat))
		bHideTeammates[clientIndex] = str_to_num(HIDEPLAYERS[clientIndex]) > 0 ? true : false;

		if((mySteamCODE[clientIndex] = ArrayFindString(playersSTEAMID, steamID)) == -1) 
		{
			mySteamCODE[clientIndex] = ArrayPushString(playersSTEAMID, steamID);
			ArrayPushCell(playersCONNECTED, 1);
			ArrayPushCell(playersAGENT, playerNextAgent[clientIndex]);
			ArrayPushCell(playersSCORE, 0);
			ArrayPushCell(playersDEATH, 0);
			ArrayPushCell(playersCOOLDOWN, 0);

			for(new index = ASAMA_1; index <= ASAMA_FINAL; index++) 
				ArrayPushCell(playersStageWEAPONS[index], NULLENT);
		} else {
			ArraySetCell(playersCONNECTED, mySteamCODE[clientIndex], 1);
			playerNextAgent[clientIndex] = ArrayGetCell(playersAGENT, mySteamCODE[clientIndex]);
			set_member(clientIndex, m_iDeaths, ArrayGetCell(playersDEATH, mySteamCODE[clientIndex]));
			UpdateFrags(clientIndex, 0, ArrayGetCell(playersSCORE, mySteamCODE[clientIndex]), 0, true);
			playerCOOLDOWN[clientIndex] = ArrayGetCell(playersCOOLDOWN, mySteamCODE[clientIndex]);
			for(new index = ASAMA_1; index <= ASAMA_FINAL; index++) 
			{
				MyStageWeapons[clientIndex][index] = ArrayGetCell(playersStageWEAPONS[index], mySteamCODE[clientIndex]);
			}
		}	
	} else {		

		for(new index = ASAMA_1; index <= ASAMA_FINAL; index++)
		{
			MyStageWeapons[clientIndex][index] = NULLENT;
		}
		
		playerCROSSHAIR[clientIndex] = 0;
		if(playerCROSSHAIR[clientIndex] >= sizeof(Crosshair_Info)) playerCROSSHAIR[clientIndex] = 0;
	}

	playerDefaultFOV[clientIndex] = bFovTYPE[clientIndex] ? 105 : 90;

	new totalPlayer;
	for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, playerIndex; arrayIndex >= 0; arrayIndex--)
	{
		playerIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);

		if(is_user_bot(playerIndex))
			continue;

		totalPlayer++;	
	}

	if(!Available)
	{
		if(haveBot)
		{
			if(totalPlayer == 1)
			{
				Available = true;
				server_cmd("sv_restart 1");
			}
		} else {
			if(totalPlayer == 2)
			{
				Available = true;
				server_cmd("sv_restart 1");
			}
		}
	}

	formatex(myCROSSHAIR[clientIndex], charsmax(myCROSSHAIR), Crosshair_Info[playerCROSSHAIR[clientIndex]][CROSSHAIR_SPRITE]);

	crosshairPAGE[clientIndex] = (playerCROSSHAIR[clientIndex]) <= 6 ? 0 : ((playerCROSSHAIR[clientIndex]) / 7);
	agentPAGE[clientIndex] = (playerNextAgent[clientIndex]) <= 6 ? 0 : ((playerNextAgent[clientIndex]) / 7);

	RequestFrame("balance_teams");
}

public RegisterHamBot(clientIndex)
{
	RegisterHamFromEntity(Ham_TraceAttack, clientIndex, "TraceAttack");
	RegisterHamFromEntity(Ham_TakeDamage, clientIndex, "TakeDamage");
	RegisterHamFromEntity(Ham_TakeDamage, clientIndex, "TakeDamage_Post", true);
}

public client_disconnected(clientIndex)
{
	if(!is_user_connected(clientIndex))
		return;

	Log("%s/client_disconnected (client %i)", PLUGIN, clientIndex);

	new arrayIndex;
	if((arrayIndex = ArrayFindValue(Array_playerATTACKERS, clientIndex)) != -1)
		ArrayDeleteItem(Array_playerATTACKERS, arrayIndex);
	if((arrayIndex = ArrayFindValue(Array_playerDEFENDERS, clientIndex)) != -1)
		ArrayDeleteItem(Array_playerDEFENDERS, arrayIndex);
	if((arrayIndex = ArrayFindValue(Array_playerCONNECTED, clientIndex)) != -1)
		ArrayDeleteItem(Array_playerCONNECTED, arrayIndex);
	if((arrayIndex = ArrayFindValue(Array_playerALIVE, clientIndex)) != -1)
		ArrayDeleteItem(Array_playerALIVE, arrayIndex);
	if((arrayIndex = ArrayFindValue(Array_playerDEAD, clientIndex)) != -1)
		ArrayDeleteItem(Array_playerDEAD, arrayIndex);
	if((arrayIndex = ArrayFindValue(Array_semiclipATTACKER, clientIndex)) != -1)
	{
		ArrayDeleteItem(Array_semiclipATTACKER, arrayIndex);
		TotalSemiclipATTACKER--;
	}
	if((arrayIndex = ArrayFindValue(Array_semiclipDEFENDER, clientIndex)) != -1)
	{
		ArrayDeleteItem(Array_semiclipDEFENDER, arrayIndex);
		TotalSemiclipDEFENDER--;
	}

	bSemiclipATTACKER[clientIndex] = false;
	bSemiclipDEFENDER[clientIndex] = false;
	bPlayerTurkish[clientIndex] = false;
	bUpdateMenu[clientIndex] = false;
	lastBODY[clientIndex] = 0;
	MyLastKiller[clientIndex] = NULLENT;

	if(entityTotalCHILDRENS[clientIndex] > 0)
	{
		for(new arrayIndex = entityTotalCHILDRENS[clientIndex]-1, childrenEntity; arrayIndex >= 0; arrayIndex--)
		{
			childrenEntity = ArrayGetCell(entityCHILDRENS[clientIndex], arrayIndex);
			UTIL_RemoveEntity(childrenEntity, 0.0);
		}
	}

	if(playerUsingMenu == clientIndex) playerUsingMenu = NULLENT;

	remove_task(clientIndex+TASK_CONFIG_MENU, 1);
	remove_task(clientIndex+TASK_PLAYER_IMMORTAL, 1);
	remove_task(clientIndex+TASK_PLAYER_PUSH, 1);
	remove_task(clientIndex+TASK_PLAYER_DASH, 1);
	remove_task(clientIndex+TASK_LEERBLIND, 1);
	remove_task(clientIndex+TASK_PLAYER_REGENERATION, 1);
	remove_task(clientIndex+TASK_PLAYER_REGENERATION_END, 1);
	remove_task(clientIndex+TASK_PLAYER_SPEED_END, 1);
	remove_task(clientIndex+TASK_DAMAGEHUD, 1);
	remove_task(clientIndex+TASK_WEAPON_UPGRADE, 1);
	remove_task(clientIndex+TASK_FIX_ORIGIN, 1);

	playerTEAM[clientIndex] = TEAM_UNASSIGNEDS;
	set_entvar(clientIndex, var_team, TEAM_UNASSIGNEDS);

	ArrayClear(Array_DeathSounds[clientIndex]);
	ArrayClear(Array_PainHeadSounds[clientIndex]);
	ArrayClear(Array_PainBodySounds[clientIndex]);
	ArrayClear(Array_HeadshotKillSounds[clientIndex]);
	ArrayClear(Array_KillSounds[clientIndex]);
	ArrayClear(Array_3KillSounds[clientIndex]);
	ArrayClear(Array_4KillSounds[clientIndex]);
	ArrayClear(Array_5KillSounds[clientIndex]);
	ArrayClear(Array_AceSounds[clientIndex]);
	ArrayClear(Array_HealSounds[clientIndex]);
	ArrayClear(Array_AlmostWinSounds[clientIndex]);
	ArrayClear(Array_WinSounds[clientIndex]);
	ArrayClear(Array_CantUseSounds[clientIndex]);
	ArrayClear(Array_UltReadySounds[clientIndex]);
	ArrayClear(Array_Skill1Sounds[clientIndex]);
	ArrayClear(Array_Skill2Sounds[clientIndex]);

	playerAgentID[clientIndex] = NULLENT;

	ArrayClear(playersEnemy[clientIndex]);
	ArrayClear(playersTotalDamage[clientIndex]);

	remove_task(clientIndex+TASK_BOTDEATH, 1);
	remove_task(clientIndex+TASK_BOT_SEARCHENEMY, 1);
	remove_task(clientIndex+TASK_BOT_FIRE, 1);
	
	for(new bodyGroup = HIT_HEAD; bodyGroup <= HIT_RIGHTLEG; bodyGroup++) 
	{
		ArrayClear(playersDamageBody[clientIndex][bodyGroup]);
		ArrayClear(playersHitsBody[clientIndex][bodyGroup]);
	}

	for(new victimIndex = 1; victimIndex <= MAX_PLAYERS; victimIndex++) 
	{
		playerID[clientIndex][victimIndex] = NULLENT;
	}
	
	Reset_Player_From_Attackers(clientIndex);

	if(!is_user_bot(clientIndex))
	{
		for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, playerIndex; arrayIndex >= 0; arrayIndex--)
		{
			playerIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);

			if(is_user_bot(playerIndex))
				continue;

			Color_Chat(playerIndex, 0, "!g[%s]!n %L", PLUGIN, playerIndex, "PLAYER_DISCONNECTED", playerNAME[clientIndex], playerCOUNTRY[clientIndex]);	
		}

		ArraySetCell(playersCONNECTED, mySteamCODE[clientIndex], 0);
		ArraySetCell(playersAGENT, mySteamCODE[clientIndex], playerNextAgent[clientIndex]);
		ArraySetCell(playersSCORE, mySteamCODE[clientIndex], floatround(get_entvar(clientIndex, var_frags)));
		ArraySetCell(playersDEATH, mySteamCODE[clientIndex], get_member(clientIndex, m_iDeaths));
		ArraySetCell(playersCOOLDOWN, mySteamCODE[clientIndex], playerCOOLDOWN[clientIndex]);
		
		for(new index = ASAMA_1; index <= ASAMA_FINAL; index++) 
		{
			ArraySetCell(playersStageWEAPONS[index], mySteamCODE[clientIndex], MyStageWeapons[clientIndex][index]);
		}
	}

	bHideTeammates[clientIndex] = false;

	new totalPlayer;
	for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, playerIndex; arrayIndex >= 0; arrayIndex--)
	{
		playerIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);

		if(is_user_bot(playerIndex))
			continue;

		totalPlayer++;	
	}

	if(Available)
	{
		if(haveBot)
		{
			if(!totalPlayer)
			{
				Available = false;
			}
		} else {
			if(totalPlayer <= 1)
			{
				Available = false;
			}
		}
	}

	Reset_Player(clientIndex); 
	if(bRealBot[clientIndex])
	{
		bRealBot[clientIndex] = false;

		new iArrayID;
		if((iArrayID = ArrayFindValue(playerBOT, clientIndex)) != -1)
		{
			ArrayDeleteItem(playerBOT, iArrayID);
			if(--totalBOT <= 0)
			{
				unregister_forward(FM_StartFrame, Forward_ServerFrame, true);
			}
		}
	} 

	RequestFrame("balance_teams");
}

public Check_TotalBots()
{
	if(ArraySize(Array_playerCONNECTED))
	{
		server_cmd("sys_ticrate 4000");
	}

	new totalPlayer;
	for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, clientIndex; arrayIndex >= 0; arrayIndex--)
	{
		clientIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);

		if(is_user_bot(clientIndex))
			continue;

		totalPlayer++;
	}

	new forceBOT;
	switch(totalPlayer)
	{
		case 0: forceBOT = 0;
		case 1: forceBOT = 7;
		case 2: forceBOT = 6;
		case 3: forceBOT = 5;
		case 4: forceBOT = 4;
		case 5: forceBOT = 3;
		case 6: forceBOT = 2;
		case 7: forceBOT = 1;
	}

	if(totalBOT > forceBOT) 
	{
		if(totalBOT > 0)
		{
			new szName[32]

			for(new arrayIndex = totalBOT-1, botIndex; arrayIndex >= 0; arrayIndex--)
			{
				botIndex = ArrayGetCell(playerBOT, arrayIndex);

				get_entvar(botIndex, var_netname, szName, charsmax(szName));
				server_cmd("kick ^"%s^"", szName);

				break;
			}
		}
	} else if(totalBOT < forceBOT) {
		AddBot();
	}
}

public AddBot()
{
	if((totalBOT+1) > maxBOT)
		return false;

	new szName[32]; copy(szName, charsmax(szName), szBotNames[totalBOT]);
	new clientIndex = engfunc(EngFunc_CreateFakeClient, szName);
	if (pev_valid(clientIndex))
	{	
		if(ArrayFindValue(playerBOT, clientIndex) == -1)
		{
			ArrayPushCell(playerBOT, clientIndex);
			if(++totalBOT == 1)
			{
				Forward_ServerFrame = register_forward(FM_StartFrame, "Server_Frame", true);
			}
		}

		bRealBot[clientIndex] = true;
		bBotDucking[clientIndex] = false;
		bBotJumping[clientIndex] = false;
		botEnemy[clientIndex] = NULLENT;

		engfunc(EngFunc_FreeEntPrivateData, clientIndex);
		dllfunc(MetaFunc_CallGameEntity, "player", clientIndex);
		set_user_info(clientIndex, "rate", "3500");
		set_user_info(clientIndex, "cl_updaterate", "25");
		set_user_info(clientIndex, "cl_lw", "1");
		set_user_info(clientIndex, "cl_lc", "1");
		set_user_info(clientIndex, "cl_dlmax", "128");
		set_user_info(clientIndex, "cl_righthand", "1");
		set_user_info(clientIndex, "_vgui_menus", "0");
		set_user_info(clientIndex, "_ah", "0");
		set_user_info(clientIndex, "dm", "0");
		set_user_info(clientIndex, "tracker", "0");
		set_user_info(clientIndex, "friends", "0");
		set_user_info(clientIndex, "*bot", "1");
		set_entvar(clientIndex, var_flags, get_entvar(clientIndex, var_flags) | FL_FAKECLIENT);
		set_entvar(clientIndex, var_colormap, clientIndex);
		
		new szMessage[32];
		dllfunc(DLLFunc_ClientConnect, clientIndex, szName, "127.0.0.1", szMessage);
		dllfunc(DLLFunc_ClientPutInServer, clientIndex);
		engfunc(EngFunc_RunPlayerMove, clientIndex, Float:{0.0,0.0,0.0}, 0.0, 0.0, 0.0, 0, 0, 76);
		rg_round_respawn(clientIndex);
		return true;
	}

	return false;
}

public Server_Frame() 
{
	static arrayIndex, clientIndex, Float:msecval, msec; 
	global_get(glb_frametime, msecval);
	msec = floatround(msecval * 1000.0);

	for(arrayIndex = totalBOT-1; arrayIndex >= 0; arrayIndex--)
	{
		clientIndex = ArrayGetCell(playerBOT, arrayIndex);
		
		if(get_entvar(clientIndex, var_movetype) == MOVETYPE_FLY) bBotJumping[clientIndex] = true;
		
		if(!get_member_game(m_bFreezePeriod) && !(get_entvar(clientIndex, var_flags) & FL_FROZEN) && botEnemy[clientIndex] != NULLENT && currentWeaponENTITY[clientIndex] != NULLENT && !isPlayerBlind[clientIndex]) 
		{
			if((get_entvar(currentWeaponENTITY[clientIndex], var_impulse) == 0 && get_member(clientIndex, m_flNextAttack) != -1.0) || (!task_exists(clientIndex+TASK_BOT_FIRE, 1) && get_member(currentWeaponENTITY[clientIndex], m_Weapon_iClip)))
			{
				engfunc(EngFunc_RunPlayerMove, clientIndex, vBotAngle[clientIndex], 0.0, 0.0, 0.0, bBotJumping[clientIndex] ? IN_JUMP | IN_ATTACK : bBotDucking[clientIndex] ? IN_DUCK | IN_ATTACK : IN_ATTACK, 0, msec);
			} else {
				engfunc(EngFunc_RunPlayerMove, clientIndex, vBotAngle[clientIndex], !task_exists(clientIndex+TASK_BOT_FIRE, 1) && !get_member_game(m_bFreezePeriod) && !(get_entvar(clientIndex, var_flags) & FL_FROZEN) && !isPlayerBlind[clientIndex] ? get_entvar(clientIndex, var_maxspeed) : 0.0, 0.0, 0.0, bBotJumping[clientIndex] ? IN_JUMP : bBotDucking[clientIndex] ? IN_DUCK : 0, 0, msec);
			}
		} else engfunc(EngFunc_RunPlayerMove, clientIndex, vBotAngle[clientIndex], !task_exists(clientIndex+TASK_BOT_FIRE, 1) && !get_member_game(m_bFreezePeriod) && !(get_entvar(clientIndex, var_flags) & FL_FROZEN) && !isPlayerBlind[clientIndex] ? get_entvar(clientIndex, var_maxspeed) : 0.0, 0.0, 0.0, bBotJumping[clientIndex] ? IN_JUMP : bBotDucking[clientIndex] ? IN_DUCK : 0, 0, msec);
	
		if(is_user_alive(clientIndex) && !get_member_game(m_bFreezePeriod) && !(get_entvar(clientIndex, var_flags) & FL_FROZEN)) 
		{	
			Think_Bot(clientIndex);
		} 

		if(bBotJumping[clientIndex])
		{
			bBotJumping[clientIndex] = false;
		} 
	}
}

public Think_Bot(const clientIndex)
{
	new Float:origin[3]; get_entvar(clientIndex, var_origin, origin);
	new iNodeOrigin = NavBox_GetNode(origin);
	if (iNodeOrigin < 0)		// The map has no nav nodes
	{
		return
	}
	new Float:goal[3]; goal = vBotTargetOrigin[clientIndex];
	new iNodeGoal = NavBox_GetNodeNearest(goal);
	static Float:vOldOrigin[MAX_PLAYERS + 1][3];

	if (iNodeOrigin == iNodeGoal || (floatpower(floatpower(vOldOrigin[clientIndex][0]-origin[0], 2.0)+floatpower(vOldOrigin[clientIndex][1]-origin[1], 2.0), 0.5) < 0.1 && botEnemy[clientIndex] == NULLENT))	
	{
		new Float:vVelocity[3]; get_entvar(clientIndex, var_velocity, vVelocity);
		if(vector_length(vVelocity) < 10.0)
		{
			vOldOrigin[clientIndex] = origin;

			if(ArraySize(botFollowPoint2[clientIndex]) == ArraySize(botFollowPoint))
			{
				ArrayClear(botFollowPoint2[clientIndex]);
			}
			new arrayIndex, Float:vTarget[3];
			while(arrayIndex > -1)
			{
				arrayIndex = random_num(0, ArraySize(botFollowPoint)-1)
				if(ArrayFindValue(botFollowPoint2[clientIndex], arrayIndex) == -1)
				{
					ArrayGetArray(botFollowPoint, arrayIndex, vTarget, 3);
					ArrayPushCell(botFollowPoint2[clientIndex], arrayIndex);
					vBotTargetOrigin[clientIndex] = vTarget;
					break;
				}
			}
			goal = vBotTargetOrigin[clientIndex];
			iNodeGoal = NavBox_GetNodeNearest(goal);
		}
	}
	vOldOrigin[clientIndex] = origin;

	new iWaypointFinal
	new Array:arrayWaypoint = NavSys_Pathfinding(iNodeOrigin, iNodeGoal, iWaypointFinal, 0);
	if (iWaypointFinal < 0) iWaypointFinal = NavSys_GetWaypointFinal(arrayWaypoint, goal);

	new waypoint[7]
	NavSys_GetWaypointSecond(arrayWaypoint, iWaypointFinal, waypoint)	// If the NPC is not at the starting point, use "NavSys_GetWaypointPathInfo" to find the next waypoint
	
	new iNodeCurrent = waypoint[4]
	new iNodeNext = waypoint[0]
	new iPath = waypoint[6]
	new PathFlags:flags, Float:height, Float:dest[3]
	NavNode_GetPathCoord2(iNodeCurrent, iNodeNext, iPath, flags, height, dest)	// "NavNode_GetPathCoord" or "NavNode_GetPathCoord2" will tell you more about the current path
	
	ArrayDestroy(arrayWaypoint)

	if (flags & PF_CrouchRun) bBotDucking[clientIndex] = true;
	else bBotDucking[clientIndex] = false;	

	if(botEnemy[clientIndex] != NULLENT)
	{
		get_entvar(botEnemy[clientIndex], var_origin, dest);
		if(get_entvar(clientIndex, var_button) & IN_ATTACK)
		{
			vLastRandom[clientIndex] = dest;
			vLastRandom[clientIndex][0] += random_float(-20.0, 20.0);
			vLastRandom[clientIndex][1] += random_float(-20.0, 20.0);
			vLastRandom[clientIndex][2] += random_float(-20.0, 20.0);	
		}
	} else {
		if(get_entvar(clientIndex, var_flags) & FL_ONGROUND)
		{
			if (height > 0.0 && GetZDistance(origin, dest) > 18.0) 
			{
				set_member(clientIndex, m_flVelocityModifier, 1.0);
				new Float:vVelocity[3]; get_entvar(clientIndex, var_velocity, vVelocity);
				vVelocity[2] = bBotDucking[clientIndex] ? 420.0 : 360.0;
				set_entvar(clientIndex, var_velocity, vVelocity);
				rg_set_animation(clientIndex, PLAYER_JUMP);
			} 
		} 
	}

	if(!isPlayerBlind[clientIndex])
	{	
		new Float:vVector[3];
		xs_vec_sub(origin, dest, vVector);
		xs_vec_normalize(vVector, vVector);
		vector_to_angle(vVector, vBotAngle[clientIndex]);
		vBotAngle[clientIndex][1] -= 180.0;

		new Float:ViewAngle[3]; ViewAngle = vBotAngle[clientIndex];
		ViewAngle[0] *= -1.0;
		set_pev(clientIndex, pev_angles, ViewAngle);
		set_pev(clientIndex, pev_v_angle, vBotAngle[clientIndex]);
	}
}

Float:GetZDistance(const Float:vOrigin1[3], const Float:vOrigin2[3])
{
	return floatabs(vOrigin1[2] - vOrigin2[2]);
}

public OnEventCurWeapon(const clientIndex) 
{
	if(!is_user_connected(clientIndex) || is_user_bot(clientIndex))
		return;

	Log("%s/OnEventCurWeapon", PLUGIN);

	new weaponEntity = currentWeaponENTITY[clientIndex];
	if(weaponEntity == NULLENT)
		return;

	Change_Crosshair(clientIndex, weaponEntity);
}

Change_Crosshair(const clientIndex, const weaponEntity) 
{
	Log("%s/Change_Crosshair", PLUGIN);

	new impulse = get_entvar(weaponEntity, var_impulse);
	if(!impulse)
	{
		Change_WeaponList(clientIndex, weaponEntity, fmt("Jenessee_Valorant/weapons/%s", Agent_Skills[playerAgentID[clientIndex]][SKILL_SPRITE]), true);
		return;
	}

	if(impulse == OPERATOR || impulse == MARSHALL || impulse == KNIFE)
	{
		Change_WeaponList(clientIndex, weaponEntity, fmt("Jenessee_Valorant/weapons/%s", Weapon_Info[impulse][WEAPON_SPRITE_NAME]), true);
		
		if(impulse != KNIFE)
		{
			new weaponClip = get_member(weaponEntity, m_Weapon_iClip);
			new iId = rg_get_iteminfo(weaponEntity, ItemInfo_iId);
			message_begin(MSG_ONE_UNRELIABLE, Message_CurWeapon, _, clientIndex);
			write_byte(1);
			write_byte(impulse == OPERATOR ? CSW_AWP : iId);
			write_byte(weaponClip);
			message_end();
		}
		return;
	}

	if(get_entvar(weaponEntity, var_weapon_zoom) && (impulse == PHANTOM || impulse == STINGER || impulse == SPECTRE || impulse == GUARDIAN || impulse == BULLDOG || impulse == VANDAL || impulse == ODIN || impulse == ARES))
	{
		rg_set_iteminfo(weaponEntity, ItemInfo_pszName, fmt("Jenessee_Valorant/weapons/%s_zoom", Weapon_Info[impulse][WEAPON_SPRITE_NAME]));
		Change_WeaponList(clientIndex, weaponEntity, fmt("Jenessee_Valorant/weapons/%s_zoom", Weapon_Info[impulse][WEAPON_SPRITE_NAME]), true);
		
	} else {
		rg_set_iteminfo(weaponEntity, ItemInfo_pszName, fmt("Jenessee_Valorant/weapons/%s", Weapon_Info[impulse][WEAPON_SPRITE_NAME]));
		Change_WeaponList(clientIndex, weaponEntity, fmt("Jenessee_Valorant/weapons/%s", Weapon_Info[impulse][WEAPON_SPRITE_NAME]), true);
	}


	Player_FOV(clientIndex, 89, false);
	new weaponClip = get_member(weaponEntity, m_Weapon_iClip);
	message_begin(MSG_ONE, Message_CurWeapon, _, clientIndex);
	write_byte(1);
	write_byte(2);
	write_byte(weaponClip);
	message_end();
	Player_FOV(clientIndex, playerDefaultFOV[clientIndex], false);
}

Change_WeaponList(const clientIndex, const weaponEntity, szSpriteName[], bool:bCrosshair)
{
	Log("%s/Change_WeaponList", PLUGIN);

	static Message_WeaponList;
	if(!Message_WeaponList) Message_WeaponList = get_user_msgid("WeaponList");

	if(weaponEntity > 0)
	{
		static WEAPON_ID; WEAPON_ID = rg_get_iteminfo(weaponEntity, ItemInfo_iId);

		if(bCrosshair && strlen(myCROSSHAIR[clientIndex]) && contain(szSpriteName, "_zoom") == -1 && contain(szSpriteName, "bucky") == -1 && contain(szSpriteName, "judge") == -1 && contain(szSpriteName, "shorty") == -1) 
			formatex(szSpriteName, 64, "Jenessee_Valorant/weapons/%s", myCROSSHAIR[clientIndex]);
		
		message_begin(MSG_ONE, Message_WeaponList, _, clientIndex);  
		write_string(szSpriteName);				
		write_byte(WEAPON_ID == CSW_HEGRENADE ? 12 : rg_get_weapon_info(WEAPON_ID, WI_AMMO_TYPE));
		write_byte(WEAPON_ID == CSW_HEGRENADE ? 1 : rg_get_iteminfo(weaponEntity, ItemInfo_iMaxAmmo1));				
		write_byte(-1);												
		write_byte(-1);												
		write_byte(bCrosshair ? 0 : rg_get_iteminfo(weaponEntity, ItemInfo_iSlot));			
		write_byte(bCrosshair ? 11 : rg_get_iteminfo(weaponEntity, ItemInfo_iPosition));		
		write_byte(bCrosshair ? 2 : WEAPON_ID);									
		write_byte(0);												
		message_end();
	} else {
		message_begin(MSG_ONE, Message_WeaponList, _, clientIndex);
		write_string(szSpriteName);
		write_byte(12)
		write_byte(1)
		write_byte(-1)
		write_byte(-1)
		write_byte(3);
		write_byte(1);
		write_byte(CSW_HEGRENADE);
		write_byte(24);
		message_end();
	}
}

public OnDefaultDeploy(const weaponEntity, const szViewModel[], const szWeaponModel[], const iAnim, const szAnimExt[], const skiplocal) 
{
	new clientIndex = get_member(weaponEntity, m_pPlayer), Impulse = get_entvar(weaponEntity, var_impulse); 
	
	Log("%s/OnDefaultDeploy", PLUGIN);
	
	for(new arrayIndex = iTotalWillRemoveEntities[clientIndex]-1, entityMODEL[128], entityIndex; arrayIndex >= 0; arrayIndex--)
	{	
		entityIndex = ArrayGetCell(ArrayWillRemoveEntities[clientIndex], arrayIndex);
		get_entvar(entityIndex, var_model, entityMODEL, charsmax(entityMODEL));
		if(equal(entityMODEL, weaponChangeSPRITE) || equal(entityMODEL, Kill_Mark[0][1]) || equal(entityMODEL, Kill_Mark[1][1]) || equal(entityMODEL, Kill_Mark[2][1]) || equal(entityMODEL, Kill_Mark[3][1]) || equal(entityMODEL, Kill_Mark[4][1]))
			continue;

		UTIL_RemoveEntity(entityIndex, 0.0);
	}
	
	if(currentWeaponENTITY[clientIndex] != NULLENT) 
	{
		lastWeaponENTITY[clientIndex] = currentWeaponENTITY[clientIndex];

		remove_task(currentWeaponENTITY[clientIndex]+TASK_WEAPON);
		
		if(!is_nullent(currentWeaponENTITY[clientIndex])) SetThink(currentWeaponENTITY[clientIndex], "");
		currentWeaponENTITY[clientIndex] = NULLENT;
	} 

	currentWeaponENTITY[clientIndex] = weaponEntity;
	lastBODY[clientIndex] = 0;

	remove_task(weaponEntity+TASK_WEAPON, 1);

	if(Impulse == 0)
	{	
		if(get_member(weaponEntity, m_iId) != WEAPON_HEGRENADE)
			return;
		if(playerAgentID[clientIndex] == NULLENT)
			return;
		if(fSkillDelay[clientIndex] > get_gametime())
			return;

		if(strlen(Agent_Skills[playerAgentID[clientIndex]][SKILL_VIEWMODEL]))
		{
			set_entvar(clientIndex, var_viewmodel, fmt("models/Jenessee_Valorant/skills/%s.mdl", Agent_Skills[playerAgentID[clientIndex]][SKILL_VIEWMODEL]));
			SetHookChainArg(2, ATYPE_STRING, fmt("models/Jenessee_Valorant/skills/%s.mdl", Agent_Skills[playerAgentID[clientIndex]][SKILL_VIEWMODEL]));
		}

		if(strlen(Agent_Skills[playerAgentID[clientIndex]][SKILL_PMODEL]))
		{
			SetHookChainArg(3, ATYPE_STRING, fmt("models/Jenessee_Valorant/skills/%s.mdl", Agent_Skills[playerAgentID[clientIndex]][SKILL_PMODEL]));
		} else {
			SetHookChainArg(3, ATYPE_STRING, "");
		}

		if(strlen(Agent_Skills[playerAgentID[clientIndex]][SKILL_PLAYERANIMATION]))
		{
			SetHookChainArg(5, ATYPE_STRING, Agent_Skills[playerAgentID[clientIndex]][SKILL_PLAYERANIMATION]);
		}

		weaponSPEED[clientIndex] = float(Agent_Skills[playerAgentID[clientIndex]][SKILL_SPEED]);

		new params[1]; params[0] = weaponEntity;
		switch(playerAgentID[clientIndex])
		{
			case AGENT_DEADLOCK:
			{
				SetHookChainArg(4, ATYPE_INTEGER, 1);
				set_task(1.5, "Task_Skill_Apply_Button", weaponEntity+TASK_WEAPON, params, sizeof(params));
				set_task(2.0, "Task_Skill_Idle", weaponEntity+TASK_WEAPON, params, sizeof(params));
			}
			case AGENT_FADE:
			{
				SetHookChainArg(4, ATYPE_INTEGER, 1);
				set_task(1.2, "Task_Skill_Apply_Button", weaponEntity+TASK_WEAPON, params, sizeof(params));
				set_task(1.3, "Task_Skill_Idle", weaponEntity+TASK_WEAPON, params, sizeof(params));
			}
			case AGENT_RAZE:
			{
				SetHookChainArg(4, ATYPE_INTEGER, 3);

				set_task(0.6, "Task_Skill_Apply_Button", weaponEntity+TASK_WEAPON, params, sizeof(params));
				set_task(4.5, "Task_Skill_Idle", weaponEntity+TASK_WEAPON, params, sizeof(params));
			}
			case AGENT_REYNA:
			{
				SetHookChainArg(4, ATYPE_INTEGER, 0);
				
				Create_View_Sprite(clientIndex, Skill_Resources[15], 1, 0, 0.035, 0.6, 0.0, 1.0, 11.0, 0.06, true, clientIndex, true);
				Create_View_Sprite(clientIndex, Skill_Resources[14], 2, 4096, 0.2, 0.0, 0.0, 1.0, 12.0, 0.1, false, clientIndex, true);
				
				new helperEntity = Create_Model_Sprite(clientIndex, Skill_Resources[16], Float:{0.0, 0.0, 0.0}, ORIENTED, 0, 0.0, 0.0, 20.0, 0, 0.0, 0, false, false);
				if(helperEntity != NULLENT)
				{
					set_entvar(helperEntity, var_effects, EF_FORCEVISIBILITY | EF_OWNER_VISIBILITY);
					set_entvar(helperEntity, var_body, 1);
					bSeeEye[clientIndex] = false;
					Think_Leer_Helper(helperEntity);
					SetThink(helperEntity, "Think_Leer_Helper");
					set_entvar(helperEntity, var_nextthink, get_gametime());

					bEntitySprite[helperEntity] = true;
					if(ArrayFindValue(ArrayWillRemoveEntities[clientIndex], helperEntity) == -1)
					{
						ArrayPushCell(ArrayWillRemoveEntities[clientIndex], helperEntity);
						iTotalWillRemoveEntities[clientIndex]++;
					}
				}
				set_task(0.5, "Task_Skill_Apply_Button", weaponEntity+TASK_WEAPON, params, sizeof(params));
				set_task(0.8, "Task_Skill_Idle", weaponEntity+TASK_WEAPON, params, sizeof(params));
			}
			case AGENT_JETT:
			{
				cs_set_user_zoom(clientIndex, CS_SET_NO_ZOOM, 1);
				
				fBlockWeaponChange[clientIndex] = get_gametime() + 0.7;

				playerCOOLDOWN[clientIndex] = Agent_Skills[playerAgentID[clientIndex]][SKILL_COOLDOWN];
				Character_Quote(clientIndex, QUOTE_SKILL1);
				rg_set_user_bpammo(clientIndex, get_member(weaponEntity, m_iId), 0);
				
				remove_task(clientIndex+TASK_PLAYER_DASH, 1);
				new param[1]; param[0] = clientIndex;
				set_task(0.3, "Task_Jett_Dash_End", clientIndex+TASK_PLAYER_DASH, param, sizeof(param));
				set_task(0.6, "Task_Jett_Dash_Remove", weaponEntity+TASK_WEAPON, params, sizeof(params));

				new jettAnimation = Create_Model_Sprite(clientIndex, Skill_Resources[2], Float:{0.0, 0.0, 0.0}, ORIENTED, 0, 0.0, 0.6, 1.0, clientIndex, 0.0, 0, false, false);
				set_entvar(clientIndex, var_effects, get_entvar(clientIndex, var_effects) | EF_NODRAW);
				set_entvar(jettAnimation, var_movetype, MOVETYPE_FLY);
				if(get_viewent(clientIndex) == clientIndex) set_entvar(jettAnimation, var_effects, 8192);

				set_entvar(jettAnimation, var_renderfx, get_entvar(clientIndex, var_renderfx));
				set_entvar(jettAnimation, var_rendermode, get_entvar(clientIndex, var_rendermode));
				set_entvar(jettAnimation, var_renderamt, get_entvar(clientIndex, var_renderamt));
				new colors[3];
				get_entvar(clientIndex, var_rendercolor, colors);
				set_entvar(jettAnimation, var_rendercolor, colors);
				set_entvar(jettAnimation, var_team, get_entvar(clientIndex, var_team));
				bEntityHaveTeam[jettAnimation] = true;

				new Button = get_entvar(clientIndex, var_button), Float:vAngle[3];  
				get_entvar(clientIndex, var_v_angle, vAngle);
				vAngle[0] = 0.0;
				if(Button & IN_BACK)
				{
					vAngle[1] -= 180.0;

					rh_emit_sound(clientIndex, 0, CHAN_STATIC, Skill_Resources[0], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
					SetHookChainArg(4, ATYPE_INTEGER, 3);
					UTIL_SendWeaponAnim(clientIndex, 3); // Draw Animation
					
					if(Button & IN_MOVERIGHT) {
						vAngle[1] += 45.0;
						Play_Animation(jettAnimation, "jett_dash_right", 0.7);
					} else if(Button & IN_MOVELEFT) {
						vAngle[1] -= 45.0;
						Play_Animation(jettAnimation, "jett_dash_left", 0.7);
					} else Play_Animation(jettAnimation, "jett_dash_back", 0.7);
				} else {
					rh_emit_sound(clientIndex, 0, CHAN_STATIC, Skill_Resources[1], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
					SetHookChainArg(4, ATYPE_INTEGER, 2);
					UTIL_SendWeaponAnim(clientIndex, 2); 
					if(Button & IN_FORWARD)
					{
						if(Button & IN_MOVERIGHT) {
							vAngle[1] -= 45.0;
							Play_Animation(jettAnimation, "jett_dash_right", 0.7);
						} else if(Button & IN_MOVELEFT) {
							vAngle[1] += 45.0;
							Play_Animation(jettAnimation, "jett_dash_left", 0.7);
						} else Play_Animation(jettAnimation, "Jenessee", 0.7);
					} else {
						if(Button & IN_MOVERIGHT) {
							SetHookChainArg(4, ATYPE_INTEGER, 0);
							UTIL_SendWeaponAnim(clientIndex, 0); 
							Play_Animation(jettAnimation, "jett_dash_right", 0.7);
							vAngle[1] -= 90.0;
						} else if(Button & IN_MOVELEFT) {
							SetHookChainArg(4, ATYPE_INTEGER, 1);
							UTIL_SendWeaponAnim(clientIndex, 1); 
							Play_Animation(jettAnimation, "jett_dash_left", 0.7);
							vAngle[1] += 90.0;
						} else Play_Animation(jettAnimation, "Jenessee", 0.7);
					}
				}

				new Float:vTarget[3]; get_entvar(clientIndex, var_origin, vTarget);
				GetPosition(0, 100.0, 0.0, 0.0, vTarget, vAngle, true, vTarget, true);
				HookEnt(clientIndex, vTarget, 1000.0, true);

				vJettDashVelocity[clientIndex] = vAngle;

				RequestFrame("Think_Player_Dash", clientIndex);
			}
		}
		return;
	}

	set_entvar(weaponEntity, var_weapon_zoom, 0);
	set_entvar(weaponEntity, var_weapon_hold, 1);
	set_member(weaponEntity, m_Weapon_iShotsFired, 0);
	set_member(weaponEntity, m_Weapon_fInReload, 0);
	set_member(weaponEntity, m_Weapon_iDirection, -1);
	set_entvar(weaponEntity, var_fuser2, 0.0);

	if(playerAgentID[clientIndex] != NULLENT)
		SetHookChainArg(2, ATYPE_STRING, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Agent_Info[playerAgentID[clientIndex]][Impulse])); 
	SetHookChainArg(3, ATYPE_STRING, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Weapon_Info[Impulse][WEAPON_P_MODEL]));

	switch(Impulse)
	{
		case ARES, BULLDOG, GUARDIAN, SPECTRE, STINGER, VANDAL:
		{
			SetHookChainArg(4, ATYPE_INTEGER, (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 5 : 4); // Draw Animation
		}
		case BUCKY:
		{
			SetHookChainArg(4, ATYPE_INTEGER, (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 12 : 11); // Draw Animation
		}
		case CLASSIC, FRENZY, JUDGE, KNIFE, GHOST, OPERATOR, SHERRIF, SHORTY:
		{
			SetHookChainArg(4, ATYPE_INTEGER, (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 6 : 5); // Draw Animation
		}	
		case MARSHALL:
		{
			SetHookChainArg(4, ATYPE_INTEGER, (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 9 : 8); // Draw Animation
		}
		case ODIN, PHANTOM:
		{
			SetHookChainArg(4, ATYPE_INTEGER, (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 9 : 8); // Draw Animation
		}
	}

	SetHookChainArg(5, ATYPE_STRING, Weapon_Info[Impulse][WEAPON_PLAYER_ANIM]);

	weaponSPEED[clientIndex] = float(Weapon_Info[Impulse][WEAPON_SPEED]);
}

public OnDefaultDeploy_Post(const weaponEntity, const szViewModel[], const szWeaponModel[], const iAnim, const szAnimExt[], const skiplocal) 
{
	new clientIndex = get_member(weaponEntity, m_pPlayer), Impulse = get_entvar(weaponEntity, var_impulse); 
	
	Log("%s/OnDefaultDeploy_Post", PLUGIN);

	if(Impulse == 0)
	{	
		if(get_member(weaponEntity, m_iId) == WEAPON_HEGRENADE && playerAgentID[clientIndex] != NULLENT)
		{
			if(fSkillDelay[clientIndex] <= get_gametime())
			{
				switch(playerAgentID[clientIndex])
				{
					case AGENT_RAZE:
					{	
						set_member(clientIndex, m_flNextAttack, 9999.0);
						set_pdata_float(weaponEntity, 48, get_gametime() + 4.5, 4);
					}
					case AGENT_DEADLOCK:
					{	
						set_member(clientIndex, m_flNextAttack, 9999.0);
						set_pdata_float(weaponEntity, 48, get_gametime() + 2.0, 4);
					}
				}
			} else {
				engclient_cmd(clientIndex, "weapon_knife");
			}
		}

		rg_reset_maxspeed(clientIndex);
		return;
	}

	switch(Impulse)
	{
		case ARES, BULLDOG, GUARDIAN, SPECTRE, STINGER, VANDAL:
		{
			UTIL_SendWeaponAnim(clientIndex, (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 5 : 4); // Draw Animation
		}
		case BUCKY:
		{
			UTIL_SendWeaponAnim(clientIndex, (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 12 : 11); // Draw Animation
		}
		case CLASSIC, FRENZY, JUDGE, KNIFE, GHOST, OPERATOR, SHERRIF, SHORTY:
		{
			UTIL_SendWeaponAnim(clientIndex, (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 6 : 5); // Draw Animation
		}	
		case MARSHALL:
		{
			UTIL_SendWeaponAnim(clientIndex, (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 9 : 8); // Draw Animation
		}
		case ODIN, PHANTOM:
		{
			UTIL_SendWeaponAnim(clientIndex, (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 9 : 8); // Draw Animation
		}
	}
	rg_reset_maxspeed(clientIndex);
	new params[1]; params[0] = weaponEntity;
	set_task(0.2, "Task_Apply_Button", weaponEntity+TASK_WEAPON, params, sizeof(params));
}

public Task_Skill_Apply_Button(params[], taskid)
{
	new weaponEntity = params[0];

	set_member(weaponEntity, m_flStartThrow, get_gametime());
	set_member(weaponEntity, m_flReleaseThrow, 0.0);
	
	SetThink(weaponEntity, "Think_Skill_Buttons");
	set_entvar(weaponEntity, var_nextthink, get_gametime()); 
}

public Think_Skill_Buttons(const weaponEntity)
{
	new clientIndex = get_entvar(weaponEntity, var_owner); 
	if(clientIndex <= 0 || clientIndex > MAX_PLAYERS || currentWeaponENTITY[clientIndex] != weaponEntity)
		return;

	static Button; Button = get_entvar(clientIndex, var_button); 
	static Float:Time; Time = get_gametime();
	static agentID; agentID = playerAgentID[clientIndex];

	new params[1]; params[0] = weaponEntity;
	if(Button & IN_ATTACK && !playerInBASE[clientIndex])
	{
		switch(agentID)
		{
			case AGENT_DEADLOCK:
			{
				set_member(clientIndex, m_flNextAttack, -1.0);
				ExecuteHamB(Ham_Weapon_PrimaryAttack, weaponEntity);
				set_pdata_float(weaponEntity, 48, 0.0, 4);
				return;
			}
			case AGENT_REYNA:
			{
				for(new arrayIndex = iTotalWillRemoveEntities[clientIndex]-1, entityMODEL[128], spriteEntity; arrayIndex >= 0; arrayIndex--)
				{	
					spriteEntity = ArrayGetCell(ArrayWillRemoveEntities[clientIndex], arrayIndex);
					get_entvar(spriteEntity, var_model, entityMODEL, charsmax(entityMODEL));
					if(equal(entityMODEL, weaponChangeSPRITE) || equal(entityMODEL, Kill_Mark[0][1]) || equal(entityMODEL, Kill_Mark[1][1]) || equal(entityMODEL, Kill_Mark[2][1]) || equal(entityMODEL, Kill_Mark[3][1]) || equal(entityMODEL, Kill_Mark[4][1]))
						continue;

					UTIL_RemoveEntity(spriteEntity, 0.0);
				}
	
				Character_Quote(clientIndex, QUOTE_SKILL1);
				Create_Reyna_Leer(clientIndex);
				remove_task(weaponEntity+TASK_WEAPON);
				UTIL_SendWeaponAnim(clientIndex, 2); 
				fBlockWeaponChange[clientIndex] = get_gametime() + 0.8;
				playerCOOLDOWN[clientIndex] = Agent_Skills[agentID][SKILL_COOLDOWN];
				rg_set_user_bpammo(clientIndex, get_member(weaponEntity, m_iId), 0);
				set_task(0.7, "Task_Raze_Bomb_Remove", weaponEntity+TASK_WEAPON, params, sizeof(params));
				rg_set_animation(clientIndex, PLAYER_ATTACK1);
				return;
			}
			case AGENT_RAZE:
			{
				set_member(clientIndex, m_flNextAttack, -1.0);
				weaponRight[clientIndex] = false;
				ExecuteHamB(Ham_Weapon_PrimaryAttack, weaponEntity);
				set_pdata_float(weaponEntity, 48, 0.0, 4);
				return;
			}
			case AGENT_FADE:
			{
				Character_Quote(clientIndex, QUOTE_SKILL1);
				remove_task(weaponEntity+TASK_WEAPON);
				UTIL_SendWeaponAnim(clientIndex, 2); 
				fBlockWeaponChange[clientIndex] = get_gametime() + 0.5;
				playerCOOLDOWN[clientIndex] = Agent_Skills[agentID][SKILL_COOLDOWN];
				rg_set_user_bpammo(clientIndex, get_member(weaponEntity, m_iId), 0);
				set_task(0.4, "Task_Raze_Bomb_Remove", weaponEntity+TASK_WEAPON, params, sizeof(params));
				rg_set_animation(clientIndex, PLAYER_ATTACK1);
				Create_Fade_Prowler(clientIndex);
				return;
			}
		}
	}

	if(agentID == AGENT_RAZE && !playerInBASE[clientIndex])
	{
		if(Button & IN_ATTACK2)
		{
			set_member(clientIndex, m_flNextAttack, -1.0);
			weaponRight[clientIndex] = true;
			
			ExecuteHamB(Ham_Weapon_PrimaryAttack, weaponEntity);
			set_pdata_float(weaponEntity, 48, 0.0, 4);
			return;
		}
	}

	set_pdata_float(weaponEntity, 48, Time, 4);
	set_entvar(weaponEntity, var_nextthink, Time); 
}

public Frame_Bomb_Animation(const weaponEntity)
{
	if(is_nullent(weaponEntity))
		return;
	if(!task_exists(weaponEntity+TASK_WEAPON, 1))
		return;

	new clientIndex = get_entvar(weaponEntity, var_owner);
	UTIL_SendWeaponAnim(clientIndex, 1); 
}

public Task_Skill_Idle(params[], taskid)
{
	new weaponEntity = params[0];

	new clientIndex = get_member(weaponEntity, m_pPlayer);
	switch(playerAgentID[clientIndex])
	{
		case AGENT_DEADLOCK: UTIL_SendWeaponAnim(clientIndex, 0);
		case AGENT_FADE: UTIL_SendWeaponAnim(clientIndex, 0);
		case AGENT_RAZE: UTIL_SendWeaponAnim(clientIndex, 0);
		case AGENT_REYNA: UTIL_SendWeaponAnim(clientIndex, 1);
	}
}

public Task_Jett_Dash_Remove(params[], taskid)
{
	new weaponEntity = params[0];

	new clientIndex = get_entvar(weaponEntity, var_owner); 

	skillFastDRAW[clientIndex] = true;
	set_entvar(clientIndex, var_effects, get_entvar(clientIndex, var_effects) & ~EF_NODRAW);
	ExecuteHamB(Ham_Weapon_RetireWeapon, weaponEntity);
	rg_remove_items_by_slot(clientIndex, GRENADE_SLOT);
	lastWeaponENTITY[clientIndex] = NULLENT;

	new Float:vVelocity[3]; get_entvar(clientIndex, var_velocity, vVelocity);
	xs_vec_mul_scalar(vVelocity, 0.3, vVelocity);
	set_entvar(clientIndex, var_velocity, vVelocity);
}

public Task_Raze_Bomb_Remove(params[], taskid)
{
	new weaponEntity = params[0];

	new clientIndex = get_entvar(weaponEntity, var_owner); 
	skillFastDRAW[clientIndex] = true;
	ExecuteHamB(Ham_Weapon_RetireWeapon, weaponEntity);
	rg_remove_items_by_slot(clientIndex, GRENADE_SLOT);
	lastWeaponENTITY[clientIndex] = NULLENT;
}

public Task_Jett_Dash_End(params[], taskid)
{
	new clientIndex = params[0]; 

	remove_task(clientIndex+TASK_PLAYER_DASH, 1);
}

public Think_Player_Dash(const clientIndex)
{
	if(!task_exists(clientIndex+TASK_PLAYER_DASH, 1))
		return;

	new Float:vTarget[3]; get_entvar(clientIndex, var_origin, vTarget);
	GetPosition(0, 100.0, 0.0, 0.0, vTarget, vJettDashVelocity[clientIndex], true, vTarget, true);
	HookEnt(clientIndex, vTarget, 1000.0, true);
	RequestFrame("Think_Player_Dash", clientIndex);
}

public client_impulse(const clientIndex, const Impulse)
{
	if(Impulse == 100)
	{
		Log("%s/client_impulse", PLUGIN);

		new weaponEntity = currentWeaponENTITY[clientIndex];

		if(weaponEntity != NULLENT)
		{
			new weaponCODE = get_entvar(weaponEntity, var_impulse);
			if(weaponCODE && get_entvar(weaponEntity, var_nextthink) <= (get_gametime() + 0.05) && !get_entvar(weaponEntity, var_weapon_zoom))
			{
				if(!task_exists(weaponEntity+TASK_WEAPON, 1))
				{
					UTIL_SendWeaponAnim(clientIndex, Weapon_Info[weaponCODE][bWeaponFast[clientIndex] ? INSPECT_ANIM_FAST : INSPECT_ANIM]);
				}
			}
		}
		return PLUGIN_HANDLED;
	}

	return PLUGIN_CONTINUE
}  

public Think_Weapon_Buttons(const weaponEntity) 
{
	new clientIndex = get_entvar(weaponEntity, var_owner); 
	if(clientIndex <= 0 || clientIndex > MAX_PLAYERS || currentWeaponENTITY[clientIndex] != weaponEntity)
		return;

	static Button; Button = get_entvar(clientIndex, var_button); 
	static Float:Time; Time = get_gametime();
	static weaponClip;
	static weaponAmmo;
	static weaponID; weaponID = get_entvar(weaponEntity, var_impulse);
	if(weaponID != KNIFE)
	{
		weaponClip = get_member(weaponEntity, m_Weapon_iClip);
		weaponAmmo = rg_get_user_bpammo(clientIndex, get_member(weaponEntity, m_iId));
	}

	if(bRealBot[clientIndex] && get_entvar(weaponEntity, var_weapon_hold))
	{
		Time += 0.15;
		set_entvar(weaponEntity, var_nextthink, Time);
		set_entvar(weaponEntity, var_weapon_hold, 0);
		return;
	}

	if(Button & IN_ATTACK)
	{
		if(weaponID != KNIFE && !weaponClip)
		{
			rh_emit_sound(clientIndex, 0, CHAN_STATIC, (weaponID == CLASSIC || weaponID == FRENZY || weaponID == GHOST || weaponID == SHERRIF || weaponID == SHORTY) ? "weapons/dryfire_pistol.wav" : "weapons/dryfire_rifle.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM);
			set_entvar(weaponEntity, var_nextthink, Time + 0.2);
			return;
		}

		Log("%s/Think_Weapon_Buttons ATTACK1", PLUGIN);

		new params[1]; params[0] = weaponEntity;
		new bool:weaponZOOM = get_entvar(weaponEntity, var_weapon_zoom) ? true : false;
		switch(weaponID)
		{
			case ARES:
			{
				CBasePlayerWeapon__Fire(weaponEntity);
				
				Muzzleflash_Fire2(clientIndex, 0.02);
				remove_task(weaponEntity+TASK_WEAPON);
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[0], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, weaponZOOM ? (bWeaponFast[clientIndex] ? 9 : 8) : (bWeaponFast[clientIndex] ? 7 : 6));
				Time += bWeaponFast[clientIndex] ? 0.06 : 0.08;
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
			}
			case BUCKY:
			{
				if(get_entvar(weaponEntity, var_weapon_hold))
				{
					set_entvar(weaponEntity, var_nextthink, Time);
					return;
				}

				set_entvar(weaponEntity, var_weapon_right, 0);
				CBasePlayerWeapon__BuckFire(weaponEntity, 15);
				
				rg_set_animation(clientIndex, PLAYER_ATTACK1);

				Muzzleflash_Fire(clientIndex, 0.03);
				remove_task(weaponEntity+TASK_WEAPON);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				set_entvar(weaponEntity, var_weapon_hold, 1);
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[1], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 2 : 1);
				Time += bWeaponFast[clientIndex] ? 0.5 : 0.9;
				set_member(weaponEntity, m_Weapon_fInReload, 0);
			}
			case BULLDOG:
			{
				if(weaponZOOM)
				{
					if(get_entvar(weaponEntity, var_weapon_hold))
					{
						set_entvar(weaponEntity, var_nextthink, Time);
						return;
					}
					CBasePlayerWeapon__Fire(weaponEntity);
					
					remove_task(weaponEntity+TASK_WEAPON);
					set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
					UTIL_SendWeaponAnim(clientIndex, (bWeaponFast[clientIndex] ? 9 : 8));
					rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[3], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
					Muzzleflash_Fire2(clientIndex, 0.02, true);
					if(weaponClip)
					{
						RequestFrame("Frame_Bulldog_Shoot1", weaponEntity);
						set_task(0.3, "Task_Reset_Weapon", weaponEntity+TASK_WEAPON, params, sizeof(params));
						return;
					} else {
						Time += bWeaponFast[clientIndex] ? 0.09 : 0.1;
						set_entvar(weaponEntity, var_weapon_hold, 1);
					}
				} else {
					CBasePlayerWeapon__Fire(weaponEntity);
					
					remove_task(weaponEntity+TASK_WEAPON);
					set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
					rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[4], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
					UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 7 : 6);
					Time += bWeaponFast[clientIndex] ? 0.09 : 0.1;
					Muzzleflash_Fire2(clientIndex, 0.02);
				}
			}
			case CLASSIC:
			{
				if(get_entvar(weaponEntity, var_weapon_hold))
				{
					set_entvar(weaponEntity, var_nextthink, Time);
					return;
				}

				CBasePlayerWeapon__Fire(weaponEntity);
				
				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Fire2(clientIndex, 0.02);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				set_entvar(weaponEntity, var_weapon_hold, 1);
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[5], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 2 : 1);
				Time += bWeaponFast[clientIndex] ? 0.08 : 0.12;
			}	
			case FRENZY:
			{
				CBasePlayerWeapon__Fire(weaponEntity);
				
				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Fire2(clientIndex, 0.02);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[7], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 2 : 1);
				Time += bWeaponFast[clientIndex] ? 0.068 : 0.1;
			}
			case GHOST:
			{
				if(get_entvar(weaponEntity, var_weapon_hold))
				{
					set_entvar(weaponEntity, var_nextthink, Time);
					return;
				}
				CBasePlayerWeapon__Fire(weaponEntity);
				
				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Ghost(clientIndex, 0.015);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				set_entvar(weaponEntity, var_weapon_hold, 1);
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[8], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 2 : 1);
				Time += bWeaponFast[clientIndex] ? 0.08 : 0.12;
			}
			case GUARDIAN:
			{
				if(get_entvar(weaponEntity, var_weapon_hold))
				{
					set_entvar(weaponEntity, var_nextthink, Time);
					return;
				}
				CBasePlayerWeapon__Fire(weaponEntity);
				
				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Fire(clientIndex, 0.026, weaponZOOM ? true : false);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				set_entvar(weaponEntity, var_weapon_hold, 1);
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[9], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, weaponZOOM ? (bWeaponFast[clientIndex] ? 9 : 8) : (bWeaponFast[clientIndex] ? 7 : 6));
				Time += bWeaponFast[clientIndex] ? 0.15 : 0.2;
			}
			case JUDGE:
			{
				CBasePlayerWeapon__BuckFire(weaponEntity, 12);
				
				rg_set_animation(clientIndex, PLAYER_ATTACK1);

				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Fire(clientIndex, 0.03);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[10], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 2 : 1);
				Time += bWeaponFast[clientIndex] ? 0.2 : 0.3;
			}
			case KNIFE:
			{
				set_entvar(weaponEntity, var_weapon_right, 0);

				rg_set_animation(clientIndex, PLAYER_ATTACK1);

				remove_task(weaponEntity+TASK_WEAPON);
				set_task(0.1, "Task_Knife_Hit", weaponEntity+TASK_WEAPON, params, sizeof(params));

				static bool:switchSlash[MAX_PLAYERS + 1];
				UTIL_SendWeaponAnim(clientIndex, switchSlash[clientIndex] ? (bWeaponFast[clientIndex] ? 4 : 3) : (bWeaponFast[clientIndex] ? 2 : 1));
				switchSlash[clientIndex] = !switchSlash[clientIndex];
				Time += bWeaponFast[clientIndex] ? 0.3 : 0.5;
			}
			case MARSHALL:
			{
				if(get_entvar(weaponEntity, var_weapon_hold))
				{
					set_entvar(weaponEntity, var_nextthink, Time);
					return;
				}

				CBasePlayerWeapon__Fire(weaponEntity);

				if(weaponZOOM)
				{
					set_entvar(clientIndex, var_viewmodel, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Agent_Info[playerAgentID[clientIndex]][weaponID]));
					cs_set_user_zoom(clientIndex, CS_SET_NO_ZOOM, 1);
					set_entvar(weaponEntity, var_weapon_zoom, 0);
				}

				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Fire(clientIndex, 0.04);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				set_entvar(weaponEntity, var_weapon_hold, 1);
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[11], VOL_NORM, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 2 : 1);
				Time += bWeaponFast[clientIndex] ? 0.4 : 0.6;
				set_member(weaponEntity, m_Weapon_fInReload, 0);
			}
			case ODIN:
			{
				CBasePlayerWeapon__Fire(weaponEntity);
				
				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Fire2(clientIndex, 0.02, weaponZOOM ? true : false);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[12], 0.8, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, weaponZOOM ? (bWeaponFast[clientIndex] ? 5 : 4) : (bWeaponFast[clientIndex] ? 3 : 2));
				Time += bWeaponFast[clientIndex] ? 0.05 : 0.07;
			}
			case OPERATOR:
			{
				if(get_entvar(weaponEntity, var_weapon_hold))
				{
					set_entvar(weaponEntity, var_nextthink, Time);
					return;
				}

				CBasePlayerWeapon__Fire(weaponEntity);
				
				if(weaponZOOM)
				{
					set_entvar(clientIndex, var_viewmodel, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Agent_Info[playerAgentID[clientIndex]][weaponID]));
					cs_set_user_zoom(clientIndex, CS_SET_NO_ZOOM, 1);
					set_entvar(weaponEntity, var_weapon_zoom, 0);
				}

				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Fire(clientIndex, 0.05);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				set_entvar(weaponEntity, var_weapon_hold, 1);
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[13], VOL_NORM, ATTN_NONE, 0, PITCH_NORM);
				UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 2 : 1);
				Time += bWeaponFast[clientIndex] ? 1.0 : 1.5;
			}
			case PHANTOM:
			{	
				CBasePlayerWeapon__Fire(weaponEntity);
				
				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Ghost(clientIndex, 0.015, weaponZOOM ? true : false, 1);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[14], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, weaponZOOM ? (bWeaponFast[clientIndex] ? 5 : 4) : (bWeaponFast[clientIndex] ? 3 : 2));
				Time += bWeaponFast[clientIndex] ? 0.065 : 0.085;
			}
			case SHERRIF:
			{
				if(get_entvar(weaponEntity, var_weapon_hold))
				{
					set_entvar(weaponEntity, var_nextthink, Time);
					return;
				}

				CBasePlayerWeapon__Fire(weaponEntity);
		
				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Fire(clientIndex, 0.03);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				set_entvar(weaponEntity, var_weapon_hold, 1);
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[15], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 2 : 1);
				Time += bWeaponFast[clientIndex] ? 0.1 : 0.2;
			}
			case SHORTY:
			{
				if(get_entvar(weaponEntity, var_weapon_hold))
				{
					set_entvar(weaponEntity, var_nextthink, Time);
					return;
				}
				CBasePlayerWeapon__BuckFire(weaponEntity, 15);
				
				rg_set_animation(clientIndex, PLAYER_ATTACK1);

				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Fire(clientIndex, 0.03);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				set_entvar(weaponEntity, var_weapon_hold, 1);
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[16], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 2 : 1);
				Time += bWeaponFast[clientIndex] ? 0.15 : 0.25;
			}
			case SPECTRE:
			{
				CBasePlayerWeapon__Fire(weaponEntity);

				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Ghost(clientIndex, 0.015, weaponZOOM ? true : false, 1);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[17], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, weaponZOOM ? (bWeaponFast[clientIndex] ? 9 : 8) : (bWeaponFast[clientIndex] ? 7 : 6));
				Time += bWeaponFast[clientIndex] ? 0.06 : 0.08;
			} 
			case STINGER:
			{
				if(weaponZOOM)
				{
					if(get_entvar(weaponEntity, var_weapon_hold))
					{
						set_entvar(weaponEntity, var_nextthink, Time);
						return;
					}
					CBasePlayerWeapon__Fire(weaponEntity);

					set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
					remove_task(weaponEntity+TASK_WEAPON);
					UTIL_SendWeaponAnim(clientIndex, (bWeaponFast[clientIndex] ? 9 : 8));
					rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[18], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
					Muzzleflash_Fire2(clientIndex, 0.02, true);

					if(weaponClip)
					{
						RequestFrame("Frame_Stinger_Shoot1", weaponEntity);
						set_task(0.3, "Task_Reset_Weapon", weaponEntity+TASK_WEAPON, params, sizeof(params));
						return;
					} else {
						Time += bWeaponFast[clientIndex] ? 0.04 : 0.06;
						set_entvar(weaponEntity, var_weapon_hold, 1);
					}
				} else {
					CBasePlayerWeapon__Fire(weaponEntity);

					Muzzleflash_Fire2(clientIndex, 0.02);
					set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
					remove_task(weaponEntity+TASK_WEAPON);
					rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[18], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
					UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 7 : 6);
					Time += bWeaponFast[clientIndex] ? 0.04 : 0.06;
				}
			}
			case VANDAL:
			{
				CBasePlayerWeapon__Fire(weaponEntity);

				remove_task(weaponEntity+TASK_WEAPON);
				Muzzleflash_Fire2(clientIndex, 0.02, weaponZOOM ? true : false);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[19], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, weaponZOOM ? (bWeaponFast[clientIndex] ? 9 : 8) : (bWeaponFast[clientIndex] ? 7 : 6));
				Time += bWeaponFast[clientIndex] ? 0.075 : 0.1;
			}
		}	

		set_task(0.3, "Task_Reset_Weapon", weaponEntity+TASK_WEAPON, params, sizeof(params));
		set_entvar(weaponEntity, var_nextthink, Time); 
		return;
	}

	if(Button & IN_ATTACK2)
	{
		Log("%s/Think_Weapon_Buttons ATTACK2", PLUGIN);
		new params[1]; params[0] = weaponEntity;
		switch(weaponID)
		{
			case BULLDOG, GUARDIAN, MARSHALL, OPERATOR, PHANTOM, SPECTRE, STINGER, VANDAL, ARES, ODIN:
			{
				if(get_entvar(weaponEntity, var_fuser2) <= Time)
				{	
					remove_task(weaponEntity+TASK_WEAPON);
					Task_Reset_Weapon(params, weaponEntity+TASK_WEAPON);
					new zoomMode = get_entvar(weaponEntity, var_weapon_zoom);
					if(weaponID == OPERATOR || weaponID == MARSHALL)
					{
						PlaySound(clientIndex, "weapons/zoom.wav");
						switch(zoomMode)
						{
							case 2:
							{
								set_entvar(clientIndex, var_viewmodel, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Agent_Info[playerAgentID[clientIndex]][weaponID]));
								cs_set_user_zoom(clientIndex, CS_SET_NO_ZOOM, 1);
								set_entvar(weaponEntity, var_weapon_zoom, 0);
								UTIL_SendWeaponAnim(clientIndex, 0);
							}
							case 1:
							{
								if(weaponID == OPERATOR)
								{
									set_entvar(clientIndex, var_viewmodel, "");
									cs_set_user_zoom(clientIndex, CS_SET_SECOND_ZOOM, 1);
									set_entvar(weaponEntity, var_weapon_zoom, 2);
								} else {
									set_entvar(clientIndex, var_viewmodel, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Agent_Info[playerAgentID[clientIndex]][weaponID]));
									cs_set_user_zoom(clientIndex, CS_SET_NO_ZOOM, 1);
									set_entvar(weaponEntity, var_weapon_zoom, 0);
									UTIL_SendWeaponAnim(clientIndex, 0);
								}
							}
							case 0:
							{
								set_entvar(clientIndex, var_viewmodel, "");
								cs_set_user_zoom(clientIndex, CS_SET_FIRST_ZOOM, 1);
								set_entvar(weaponEntity, var_weapon_zoom, 1);
							}
						}
					} else {
						set_entvar(weaponEntity, var_weapon_hold, 1);
						set_member(weaponEntity, m_Weapon_fInReload, 0);
						set_entvar(weaponEntity, var_weapon_zoom, !zoomMode);
						cs_set_user_zoom(clientIndex, zoomMode ? CS_SET_NO_ZOOM : CS_SET_AUGSG552_ZOOM, 1);
						PlaySound(clientIndex, Weapon_Fire_Sounds[20+zoomMode]);
						UTIL_SendWeaponAnim(clientIndex, !zoomMode);
						Change_Crosshair(clientIndex, weaponEntity);
					}
					set_entvar(weaponEntity, var_fuser2, Time + 0.2);
				}
			}
			case CLASSIC:
			{
				if(!weaponClip)
				{
					rh_emit_sound(clientIndex, 0, CHAN_STATIC, "weapons/dryfire_pistol.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
					set_entvar(weaponEntity, var_nextthink, Time + 0.2);
					return;
				}

				if(get_entvar(weaponEntity, var_weapon_hold))
				{
					set_entvar(weaponEntity, var_nextthink, Time);
					return;
				}

				set_member(weaponEntity, m_Weapon_iClip, max(weaponClip - 3, 0));
				set_entvar(weaponEntity, var_weapon_hold, 1);

				Muzzleflash_Fire(clientIndex, 0.03);

				rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[weaponClip == 1 ? 5 : 6], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 2 : 1);
				if(weaponClip == 1) 
				{
					CBasePlayerWeapon__Fire(weaponEntity);
					Time += bWeaponFast[clientIndex] ? 0.115 : 0.175;
				} else {
					Time += bWeaponFast[clientIndex] ? 0.3 : 0.4;
					CBasePlayerWeapon__BuckFire(weaponEntity, min(weaponClip, 3));
				}

				

				rg_set_animation(clientIndex, PLAYER_ATTACK1);

				remove_task(weaponEntity+TASK_WEAPON);
				set_entvar(weaponEntity, var_nextthink, Time); 
				return;
			}
			case BUCKY:
			{
				if(!weaponClip)
				{
					rh_emit_sound(clientIndex, 0, CHAN_STATIC, "weapons/dryfire_rifle.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
					set_entvar(weaponEntity, var_nextthink, Time + 0.2);
					return;
				}

				if(get_entvar(weaponEntity, var_weapon_hold))
				{
					set_entvar(weaponEntity, var_nextthink, Time);
					return;
				}

				set_entvar(weaponEntity, var_weapon_right, 1);
				
				new Float:vOrigin[3], Float:vTarget[3];
				GetPosition(clientIndex, 0.0, 0.0, 0.0, vOrigin, Float:{0.0, 0.0, 0.0}, true, Float:{0.0, 0.0, 0.0}, false);
				GetPosition(clientIndex, 260.0, 0.0, 0.0, vTarget, Float:{0.0, 0.0, 0.0}, false, vOrigin, true);

				engfunc(EngFunc_TraceLine, vOrigin, vTarget, DONT_IGNORE_MONSTERS, clientIndex, 0); 
				new Float:fFraction; get_tr2(0, TR_flFraction, fFraction);

				if(fFraction >= 1.0)
				{
					CBasePlayerWeapon__BuckFire(weaponEntity, 7);
					rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[1], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				} else {
					CBasePlayerWeapon__Fire(weaponEntity);
					rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[2], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				}

				rg_set_animation(clientIndex, PLAYER_ATTACK1);

				Muzzleflash_Fire(clientIndex, 0.03);
				set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
				set_entvar(weaponEntity, var_weapon_hold, 1);
				UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 4 : 3);
				Time += bWeaponFast[clientIndex] ? 0.5 : 0.9;
				remove_task(weaponEntity+TASK_WEAPON);
				set_entvar(weaponEntity, var_nextthink, Time); 
				set_member(weaponEntity, m_Weapon_fInReload, 0);
				return;
			}
			case KNIFE:
			{
				set_entvar(weaponEntity, var_weapon_right, 1);

				rg_set_animation(clientIndex, PLAYER_ATTACK1);

				remove_task(weaponEntity+TASK_WEAPON);
				set_task(0.1, "Task_Knife_Hit", weaponEntity+TASK_WEAPON, params, sizeof(params));

				UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 8 : 7);

				Time += bWeaponFast[clientIndex] ? 0.7 : 1.2;
				set_entvar(weaponEntity, var_nextthink, Time); 
				return;
			}
		}
	}

	if(get_entvar(weaponEntity, var_orbweapon) && !weaponClip && !weaponAmmo)
	{
		Log("%s/Think_Weapon_Buttons WeaponChange", PLUGIN);

		if(weaponID == CLASSIC || weaponID == FRENZY || weaponID == GHOST || weaponID == SHERRIF || weaponID == SHORTY)
		{
			weaponID = Asama_Silahlari[MyStageWeapons[clientIndex][currentSTAGE]][1];
			if(weaponID != NULLENT)
			{
				set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 0);
			} else if(currentSTAGE > ASAMA_1) {
				weaponID = Asama_Silahlari[MyStageWeapons[clientIndex][ASAMA_1]][1];
				if(weaponID != NULLENT)
				{
					set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 0);
				} 
			} 
		} else {
			weaponID = Asama_Silahlari[MyStageWeapons[clientIndex][currentSTAGE]][0];
			if(weaponID != NULLENT)
			{
				set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 0);
			} else {
				rg_remove_items_by_slot(clientIndex, PRIMARY_WEAPON_SLOT);
			}
		}
		return;
	}

	if(get_entvar(weaponEntity, var_weapon_hold))
	{
		set_entvar(weaponEntity, var_weapon_hold, 0);
	}

	if(weaponID != MARSHALL && weaponID != BUCKY && weaponID != KNIFE)
	{
		if(Button & IN_RELOAD || !weaponClip)
		{
			if(rg_get_iteminfo(weaponEntity, ItemInfo_iMaxClip) > weaponClip && weaponAmmo)
			{
				Log("%s/Think_Weapon_Buttons WeaponReload1", PLUGIN);

				if(get_entvar(weaponEntity, var_weapon_zoom))
				{
					set_entvar(clientIndex, var_viewmodel, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Agent_Info[playerAgentID[clientIndex]][weaponID]));
					cs_set_user_zoom(clientIndex, CS_SET_NO_ZOOM, 1);
					set_entvar(weaponEntity, var_weapon_zoom, 0);
				}

				set_member(weaponEntity, m_Weapon_iDirection, -1);
				set_member(weaponEntity, m_Weapon_fInReload, 1);
				set_member(weaponEntity, m_Weapon_iShotsFired, 0);

				rg_set_animation(clientIndex, PLAYER_RELOAD);

				new Float:refillTIME, Float:completeTIME, weaponANIM;
				switch(weaponID)
				{
					case ARES:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 3 : 2;
						refillTIME = bWeaponFast[clientIndex] ? 1.35 : 2.0;
						completeTIME = bWeaponFast[clientIndex] ? 2.25 : 3.3;
					}
					case BULLDOG:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 3 : 2;
						refillTIME = bWeaponFast[clientIndex] ? 1.15 : 1.7;
						completeTIME = bWeaponFast[clientIndex] ? 1.65 : 2.6;
					}
					case CLASSIC:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 4 : 3;
						refillTIME = bWeaponFast[clientIndex] ? 0.68 : 1.0;
						completeTIME = bWeaponFast[clientIndex] ? 1.25 : 1.85;
					}	
					case FRENZY:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 4 : 3;
						refillTIME = bWeaponFast[clientIndex] ? 0.74 : 1.1;
						completeTIME = bWeaponFast[clientIndex] ? 1.1 : 1.6;
					}
					case GHOST:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 4 : 3;
						refillTIME = bWeaponFast[clientIndex] ? 0.5 : 0.75;
						completeTIME = bWeaponFast[clientIndex] ? 1.1 : 1.6;
					}
					case GUARDIAN:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 3 : 2;
						refillTIME = bWeaponFast[clientIndex] ? 0.9 : 1.3;
						completeTIME = bWeaponFast[clientIndex] ? 1.85 : 2.75;
					}
					case JUDGE:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 4 : 3;
						refillTIME = bWeaponFast[clientIndex] ? 0.74 : 1.1;
						completeTIME = bWeaponFast[clientIndex] ? 1.6 : 2.4;
					}
					case ODIN:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 7 : 6;
						refillTIME = bWeaponFast[clientIndex] ? 1.9 : 2.9;
						completeTIME = bWeaponFast[clientIndex] ? 3.6 : 5.3;
					}
					case OPERATOR:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 4 : 3;
						refillTIME = bWeaponFast[clientIndex] ? 1.2 : 2.0;
						completeTIME = bWeaponFast[clientIndex] ? 2.68 : 4.0;
					}
					case PHANTOM:
					{	
						weaponANIM = bWeaponFast[clientIndex] ? 7 : 6;
						refillTIME = bWeaponFast[clientIndex] ? 1.0 : 1.5;
						completeTIME = bWeaponFast[clientIndex] ? 1.75 : 2.6;
					}
					case SHERRIF:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 4 : 3;
						refillTIME = bWeaponFast[clientIndex] ? 0.68 : 1.0;
						completeTIME = bWeaponFast[clientIndex] ? 1.55 : 2.35;
					}
					case SHORTY:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 4 : 3;
						refillTIME = bWeaponFast[clientIndex] ? 0.68 : 1.0;
						completeTIME = bWeaponFast[clientIndex] ? 1.45 : 2.1;
					}
					case SPECTRE:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 3 : 2;
						refillTIME = bWeaponFast[clientIndex] ? 0.9 : 1.3;
						completeTIME = bWeaponFast[clientIndex] ? 1.5 : 2.3;
					} 
					case STINGER:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 3 : 2;
						refillTIME = bWeaponFast[clientIndex] ? 0.68 : 1.0;
						completeTIME = bWeaponFast[clientIndex] ? 1.45 : 2.2;
					}
					case VANDAL:
					{
						weaponANIM = bWeaponFast[clientIndex] ? 3 : 2;
						refillTIME = bWeaponFast[clientIndex] ? 1.0 : 1.5;
						completeTIME = bWeaponFast[clientIndex] ? 1.75 : 2.6;
					}
				}	

				UTIL_SendWeaponAnim(clientIndex, weaponANIM);
				remove_task(weaponEntity+TASK_WEAPON);
				new params[1]; params[0] = weaponEntity;
				set_task(refillTIME, "Refill_Ammo", weaponEntity+TASK_WEAPON, params, sizeof(params));
				Time += completeTIME;
				set_entvar(weaponEntity, var_nextthink, Time);
				return;
			}
		}
	} else if(weaponID != KNIFE) {
		if(Button & IN_RELOAD || !weaponClip)
		{
			if(!get_member(weaponEntity, m_Weapon_fInReload) && rg_get_iteminfo(weaponEntity, ItemInfo_iMaxClip) > weaponClip && weaponAmmo)
			{
				Log("%s/Think_Weapon_Buttons WeaponReload2", PLUGIN);

				if(get_entvar(weaponEntity, var_weapon_zoom))
				{
					set_entvar(clientIndex, var_viewmodel, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Agent_Info[playerAgentID[clientIndex]][weaponID]));
					cs_set_user_zoom(clientIndex, CS_SET_NO_ZOOM, 1);
					set_entvar(weaponEntity, var_weapon_zoom, 0);
				}

				set_member(weaponEntity, m_Weapon_iDirection, -1);
				set_member(weaponEntity, m_Weapon_fInReload, 1);
				set_member(weaponEntity, m_Weapon_iShotsFired, 0);

				rg_set_animation(clientIndex, PLAYER_RELOAD);

				remove_task(weaponEntity+TASK_WEAPON);
				new params[1]; params[0] = weaponEntity;
				switch(weaponID)
				{
					case MARSHALL:
					{
						UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 5 : 4);
						set_task(bWeaponFast[clientIndex] ? 0.1 : 0.2, "Refill_Ammo_Buck", weaponEntity+TASK_WEAPON, params, sizeof(params));
					}
					case BUCKY:
					{
						UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 10 : 9);
						set_task(bWeaponFast[clientIndex] ? 0.1 : 0.2, "Refill_Ammo_Buck", weaponEntity+TASK_WEAPON, params, sizeof(params));
					}
				}
				return;
			}
		}
	}

	set_entvar(weaponEntity, var_nextthink, Time); 
}

public Task_Knife_Hit(params[], taskid)
{
	new weaponEntity = params[0];

	Log("%s/Task_Knife_Hit", PLUGIN);
	new clientIndex = get_entvar(weaponEntity, var_owner);
	rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[random_num(26, 28)], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);

	switch(Knife_Damage(clientIndex, weaponEntity, 80.0))
	{
		case HIT_ENEMY:
		{
			rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[random_num(22, 25)], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		}
		case HIT_WALL:
		{
			rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[29], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		}
	}
}		

public Task_Reset_Weapon(params[], taskid)
{
	new weaponEntity = params[0];

	Log("%s/Task_Reset_Weapon", PLUGIN);

	set_member(weaponEntity, m_Weapon_iDirection, -1);
	set_member(weaponEntity, m_Weapon_iShotsFired, 0);
}

public Refill_Ammo(params[], taskid)
{
	new weaponEntity = params[0];

	Log("%s/Refill_Ammo", PLUGIN);

	new clientIndex = get_entvar(weaponEntity, var_owner);
	new iId = get_member(weaponEntity, m_iId);
	new weaponAmmo = rg_get_user_bpammo(clientIndex, WeaponIdType:iId);
	new weaponClip = get_member(weaponEntity, m_Weapon_iClip);
	new weaponMaxClip = rg_get_iteminfo(weaponEntity, ItemInfo_iMaxClip);
	new addAmmo = clamp(weaponMaxClip - weaponClip, 0, weaponAmmo);

	set_member(weaponEntity, m_Weapon_iClip, weaponClip+addAmmo);
	message_begin(MSG_ONE_UNRELIABLE, Message_CurWeapon, _, clientIndex);
	write_byte(1);
	write_byte(iId);
	write_byte(weaponClip+addAmmo);
	message_end();

	set_member(weaponEntity, m_Weapon_fInReload, 0);
	if(get_entvar(weaponEntity, var_orbweapon)) rg_set_user_bpammo(clientIndex, WeaponIdType:iId, weaponAmmo-addAmmo);

	OnEventCurWeapon(clientIndex);
	new param[1]; param[0] = weaponEntity;
	set_task(0.1, "Task_Crosshair", weaponEntity+TASK_WEAPON, param, sizeof(param));
}

stock Muzzleflash_Fire(clientIndex, Float:Scale, bool:bZoom = false)
{
	if(strlen(muzzleflashFire)) 
	{
		Log("%s/Muzzleflash_Fire", PLUGIN);
		new random, bool:loop = true;
		while(loop)
		{
			random = random_num(0, 11);
			if(random != 2 && random != 3 && random != 6 && random != 7 && random != 10 && random != 11)
			{
				loop = false;
			}
			
		}
		myMuzzle[clientIndex] = 0;
		lastSCALE[clientIndex] = Scale
		lastBODY[clientIndex] = bZoom ? 2 : 1;
		spriteFRAME[clientIndex] = random;
	}
}

stock Muzzleflash_Fire2(clientIndex, Float:Scale, bool:bZoom = false)
{
	if(strlen(muzzleflashFire)) 
	{
		Log("%s/Muzzleflash_Fire2", PLUGIN);
		myMuzzle[clientIndex] = 0;
		lastSCALE[clientIndex] = Scale
		lastBODY[clientIndex] = bZoom ? 2 : 1;
		spriteFRAME[clientIndex] = random_num(0, 11);
	}
}

stock Muzzleflash_Ghost(clientIndex, Float:Scale, bool:bZoom = false, fast = 0)
{
	if(strlen(muzzleflashGhost)) 
	{
		Log("%s/Muzzleflash_Ghost", PLUGIN);
		myMuzzle[clientIndex] = 1;
		lastSCALE[clientIndex] = Scale
		lastBODY[clientIndex] = bZoom ? 2 : 1;
		spriteFRAME[clientIndex] = 0;

		SetThink(clientIndex, fast ? "Muzzle_Fast" : "Muzzle");
		set_entvar(clientIndex, var_nextthink, get_gametime());
	}
}

public Muzzle_Fast(const clientIndex)
{
	if(spriteFRAME[clientIndex] < 14 && myMuzzle[clientIndex])
	{
		spriteFRAME[clientIndex]++
		set_entvar(clientIndex, var_nextthink, get_gametime() + 0.025);
	}
}

public Muzzle(const clientIndex)
{
	if(spriteFRAME[clientIndex] < 14 && myMuzzle[clientIndex])
	{
		spriteFRAME[clientIndex]++
		set_entvar(clientIndex, var_nextthink, get_gametime() + 0.05);
	}
}

public Refill_Ammo_Buck(params[], taskid)
{
	new weaponEntity = params[0];

	Log("%s/Refill_Ammo_Buck", PLUGIN);

	new clientIndex = get_entvar(weaponEntity, var_owner);
	new iId = get_member(weaponEntity, m_iId);
	new weaponAmmo = rg_get_user_bpammo(clientIndex, WeaponIdType:iId);
	new weaponID = get_entvar(weaponEntity, var_impulse);
	if(weaponAmmo > 0 && get_member(weaponEntity, m_Weapon_fInReload))
	{
		new weaponClip = get_member(weaponEntity, m_Weapon_iClip);
		new weaponMaxClip = rg_get_iteminfo(weaponEntity, ItemInfo_iMaxClip);
		new param[1]; param[0] = weaponEntity;
		if(weaponAmmo && weaponClip < weaponMaxClip) 
		{
			switch(weaponID)
			{
				case BUCKY:
				{
					UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 6 : 5);
					set_task(0.1, "Add_Ammo", weaponEntity+TASK_WEAPON, param, sizeof(param));
				}
				case MARSHALL:
				{
					UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 7 : 6);
					set_task(bWeaponFast[clientIndex] ? 0.2 : 0.3, "Add_Ammo", weaponEntity+TASK_WEAPON, param, sizeof(param));
				}
			}
		} else {
			if(weaponID == BUCKY) UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 8 : 7);
			set_member(weaponEntity, m_Weapon_fInReload, 0);
		}
		
	} else {
		if(weaponID == BUCKY) UTIL_SendWeaponAnim(clientIndex, bWeaponFast[clientIndex] ? 8 : 7);
		set_member(weaponEntity, m_Weapon_fInReload, 0);
	}
}

public Add_Ammo(params[], taskid)
{
	new weaponEntity = params[0];

	Log("%s/Add_Ammo", PLUGIN);

	new clientIndex = get_entvar(weaponEntity, var_owner);
	new iId = get_member(weaponEntity, m_iId);
	new weaponAmmo = rg_get_user_bpammo(clientIndex, WeaponIdType:iId);
	if(weaponAmmo > 0 && get_member(weaponEntity, m_Weapon_fInReload))
	{
		new weaponClip = get_member(weaponEntity, m_Weapon_iClip);
		new weaponMaxClip = rg_get_iteminfo(weaponEntity, ItemInfo_iMaxClip);
		new addAmmo = clamp(weaponMaxClip - weaponClip, 0, 1);

		set_member(weaponEntity, m_Weapon_iClip, weaponClip+addAmmo);
		if(get_entvar(weaponEntity, var_orbweapon)) rg_set_user_bpammo(clientIndex, WeaponIdType:iId, weaponAmmo-addAmmo);

		new param[1]; param[0] = weaponEntity;
		set_task(bWeaponFast[clientIndex] ? 0.1 : 0.2, "Refill_Ammo_Buck", weaponEntity+TASK_WEAPON, param, sizeof(param));
		set_entvar(weaponEntity, var_nextthink, get_gametime());

		set_task(0.1, "Task_Crosshair", weaponEntity+TASK_WEAPON, param, sizeof(param));
		OnEventCurWeapon(clientIndex);
	}
}

public Task_Crosshair(params[], taskid)
{
	new weaponEntity = params[0];

	new clientIndex = get_entvar(weaponEntity, var_owner);
	OnEventCurWeapon(clientIndex);
}

public Frame_Bulldog_Shoot1(weaponEntity)
{
	if(is_nullent(weaponEntity))
		return;
	
	new clientIndex = get_entvar(weaponEntity, var_owner);
	if(currentWeaponENTITY[clientIndex] != weaponEntity)
		return;

	SetThink(weaponEntity, "Think_Bulldog_Shoot1");
	new Float:Time = get_gametime();
	Time += bWeaponFast[clientIndex] ? 0.05 : 0.075;
	set_entvar(weaponEntity, var_nextthink, Time);
}

public Think_Bulldog_Shoot1(weaponEntity)
{
	Log("%s/Think_Bulldog_Shoot1", PLUGIN);

	new clientIndex = get_entvar(weaponEntity, var_owner);
	new Float:Time = get_gametime();
	new weaponClip = get_member(weaponEntity, m_Weapon_iClip);

	CBasePlayerWeapon__Fire(weaponEntity);

	UTIL_SendWeaponAnim(clientIndex, (bWeaponFast[clientIndex] ? 9 : 8));
	rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[3], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
	Muzzleflash_Fire2(clientIndex, 0.02, true);
	
	if(weaponClip) 
	{
		RequestFrame("Frame_Bulldog_Shoot2", weaponEntity);
	} else {
		SetThink(weaponEntity, "Think_Weapon_Buttons");
		Time += bWeaponFast[clientIndex] ? 0.2 : 0.3;
		set_entvar(weaponEntity, var_nextthink, Time);
	}
}

public Frame_Bulldog_Shoot2(weaponEntity)
{
	if(is_nullent(weaponEntity))
		return;
	
	new clientIndex = get_entvar(weaponEntity, var_owner);
	if(currentWeaponENTITY[clientIndex] != weaponEntity)
		return;

	SetThink(weaponEntity, "Think_Bulldog_Shoot2");
	new Float:Time = get_gametime();
	Time += bWeaponFast[clientIndex] ? 0.05 : 0.075;
	set_entvar(weaponEntity, var_nextthink, Time);
}

public Think_Bulldog_Shoot2(weaponEntity)
{
	Log("%s/Think_Bulldog_Shoot2", PLUGIN);

	new clientIndex = get_entvar(weaponEntity, var_owner);
	new Float:Time = get_gametime();
	new weaponClip = get_member(weaponEntity, m_Weapon_iClip);

	CBasePlayerWeapon__Fire(weaponEntity);
	
	UTIL_SendWeaponAnim(clientIndex, (bWeaponFast[clientIndex] ? 9 : 8));
	rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[3], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
	Muzzleflash_Fire2(clientIndex, 0.02, true);

	SetThink(weaponEntity, "Think_Weapon_Buttons");
	Time += bWeaponFast[clientIndex] ? 0.2 : 0.3;
	set_entvar(weaponEntity, var_nextthink, Time);
	set_entvar(weaponEntity, var_weapon_hold, 1);
}

public Frame_Stinger_Shoot1(weaponEntity)
{
	if(is_nullent(weaponEntity))
		return;
	
	new clientIndex = get_entvar(weaponEntity, var_owner);
	if(currentWeaponENTITY[clientIndex] != weaponEntity)
		return;

	SetThink(weaponEntity, "Think_Stinger_Shoot1");
	new Float:Time = get_gametime();
	Time += bWeaponFast[clientIndex] ? 0.05 : 0.075;
	set_entvar(weaponEntity, var_nextthink, Time);
}

public Think_Stinger_Shoot1(weaponEntity)
{
	Log("%s/Think_Stinger_Shoot1", PLUGIN);

	new clientIndex = get_entvar(weaponEntity, var_owner);
	new Float:Time = get_gametime();
	new weaponClip = get_member(weaponEntity, m_Weapon_iClip);

	CBasePlayerWeapon__Fire(weaponEntity);
	
	UTIL_SendWeaponAnim(clientIndex, (bWeaponFast[clientIndex] ? 9 : 8));
	rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[18], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
	Muzzleflash_Fire2(clientIndex, 0.02, true);

	if(weaponClip) 
	{
		RequestFrame("Frame_Stinger_Shoot2", weaponEntity);
	} else {
		SetThink(weaponEntity, "Think_Weapon_Buttons");
		Time += bWeaponFast[clientIndex] ? 0.2 : 0.3;
		set_entvar(weaponEntity, var_nextthink, Time);
	}
}

public Frame_Stinger_Shoot2(weaponEntity)
{
	if(is_nullent(weaponEntity))
		return;
	
	new clientIndex = get_entvar(weaponEntity, var_owner);
	if(currentWeaponENTITY[clientIndex] != weaponEntity)
		return;

	SetThink(weaponEntity, "Think_Stinger_Shoot2");
	new Float:Time = get_gametime();
	Time += bWeaponFast[clientIndex] ? 0.05 : 0.075;
	set_entvar(weaponEntity, var_nextthink, Time);
}

public Think_Stinger_Shoot2(weaponEntity)
{
	Log("%s/Think_Stinger_Shoot2", PLUGIN);

	new clientIndex = get_entvar(weaponEntity, var_owner);
	new Float:Time = get_gametime();
	new weaponClip = get_member(weaponEntity, m_Weapon_iClip);

	CBasePlayerWeapon__Fire(weaponEntity);
	
	UTIL_SendWeaponAnim(clientIndex, (bWeaponFast[clientIndex] ? 9 : 8));
	rh_emit_sound(clientIndex, 0, CHAN_WEAPON, Weapon_Fire_Sounds[18], VOL_NORM, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	set_member(weaponEntity, m_Weapon_iClip, max(--weaponClip, 0));
	Muzzleflash_Fire2(clientIndex, 0.02, true);

	SetThink(weaponEntity, "Think_Weapon_Buttons");
	Time += bWeaponFast[clientIndex] ? 0.2 : 0.3;
	set_entvar(weaponEntity, var_nextthink, Time);
	set_entvar(weaponEntity, var_weapon_hold, 1);
}

public OnAddPlayerItem(const clientIndex, const weaponEntity)
{
	new impulse = get_entvar(weaponEntity, var_impulse);
	if(!impulse) 
	{
		return HC_CONTINUE;
	}

	Log("%s/OnAddPlayerItem %i", PLUGIN, impulse);

	set_entvar(weaponEntity, var_netname, Weapon_Info[impulse][WEAPON_NAME]);
	rg_set_iteminfo(weaponEntity, ItemInfo_pszName, fmt("Jenessee_Valorant/weapons/%s", Weapon_Info[impulse][WEAPON_SPRITE_NAME]));
	if(impulse != KNIFE)
	{
		set_member(weaponEntity, m_Weapon_iClip, Weapon_Info[impulse][WEAPON_AMMO])
		set_member(weaponEntity, m_Weapon_iDefaultAmmo,  Weapon_Info[impulse][WEAPON_BPAMMO]);
	
		rg_set_iteminfo(weaponEntity, ItemInfo_iMaxClip, Weapon_Info[impulse][WEAPON_AMMO]);
		rg_set_iteminfo(weaponEntity, ItemInfo_iMaxAmmo1, Weapon_Info[impulse][WEAPON_BPAMMO]);
		RequestFrame("Refresh_Ammo", weaponEntity);
	}

	Change_WeaponList(clientIndex, weaponEntity, fmt("Jenessee_Valorant/weapons/%s", Weapon_Info[impulse][WEAPON_SPRITE_NAME]), false);
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, Weapon_Info[impulse][WEAPON_ENTITY_NAME]);
	return HC_CONTINUE;
}

public Refresh_Ammo(const weaponEntity)
{
	if(is_nullent(weaponEntity))
		return;

	Log("%s/Refresh_Ammo", PLUGIN);

	new clientIndex = get_entvar(weaponEntity, var_owner);
	if(get_entvar(weaponEntity, var_impulse) == OPERATOR)
	{
		new weaponClip = get_member(weaponEntity, m_Weapon_iClip);
		message_begin(MSG_ONE_UNRELIABLE, Message_CurWeapon, _, clientIndex);
		write_byte(1);
		write_byte(CSW_AWP);
		write_byte(weaponClip);
		message_end();
	}

	rg_set_user_bpammo(clientIndex, WeaponIdType:get_member(weaponEntity, m_iId), Weapon_Info[get_entvar(weaponEntity, var_impulse)][WEAPON_BPAMMO]);
}

public Task_Fix_Origin(params[], taskid)
{
	new clientIndex = params[0]; 
	if(playerTEAM[clientIndex] == TEAM_ATTACKERS) {
		new arraySize = ArraySize(Array_attackerSpawnOrigin);
		if(arraySize)
		{
			new arrayIndex = random_num(0, arraySize-1);
			new Float:vOrigin[3], Float:vAngle[3];
			ArrayGetArray(Array_attackerSpawnOrigin, arrayIndex, vOrigin);
			vAngle[1] = Float:ArrayGetCell(Array_attackerSpawnAngle, arrayIndex);

			set_entvar(clientIndex, var_origin, vOrigin);
			set_entvar(clientIndex, var_angles, vAngle);
			set_entvar(clientIndex, var_v_angle, vAngle);
			set_entvar(clientIndex, var_fixangle, 1);
		} else {
			arraySize = ArraySize(Array_attackerSpawnOrigin_Map);
			if(arraySize)
			{
				new arrayIndex = random_num(0, arraySize-1);
				new Float:vOrigin[3], Float:vAngle[3];
				ArrayGetArray(Array_attackerSpawnOrigin_Map, arrayIndex, vOrigin);
				vAngle[1] = Float:ArrayGetCell(Array_attackerSpawnAngle_Map, arrayIndex);

				set_entvar(clientIndex, var_origin, vOrigin);
				set_entvar(clientIndex, var_angles, vAngle);
				set_entvar(clientIndex, var_v_angle, vAngle);
				set_entvar(clientIndex, var_fixangle, 1);
			}
		}

		new arrayIndex;
		if((arrayIndex = ArrayFindValue(Array_semiclipDEFENDER, clientIndex)) != -1)
		{
			ArrayDeleteItem(Array_semiclipDEFENDER, arrayIndex);
			TotalSemiclipDEFENDER--;
		}

		if(ArrayFindValue(Array_semiclipATTACKER, clientIndex) == -1)
		{
			ArrayPushCell(Array_semiclipATTACKER, clientIndex);
			TotalSemiclipATTACKER++;
		}

		bSemiclipDEFENDER[clientIndex] = false;
		bSemiclipATTACKER[clientIndex] = true;
	} else if(playerTEAM[clientIndex] == TEAM_DEFENDERS) {
		new arraySize = ArraySize(Array_defenderSpawnOrigin);
		if(arraySize)
		{
			new arrayIndex = random_num(0, arraySize-1);
			new Float:vOrigin[3], Float:vAngle[3];
			ArrayGetArray(Array_defenderSpawnOrigin, arrayIndex, vOrigin);
			vAngle[1] = Float:ArrayGetCell(Array_defenderSpawnAngle, arrayIndex);

			set_entvar(clientIndex, var_origin, vOrigin);
			set_entvar(clientIndex, var_angles, vAngle);
			set_entvar(clientIndex, var_v_angle, vAngle);
			set_entvar(clientIndex, var_fixangle, 1);
		} else {
			arraySize = ArraySize(Array_defenderSpawnOrigin_Map);
			if(arraySize)
			{
				new arrayIndex = random_num(0, arraySize-1);
				new Float:vOrigin[3], Float:vAngle[3];
				ArrayGetArray(Array_defenderSpawnOrigin_Map, arrayIndex, vOrigin);
				vAngle[1] = Float:ArrayGetCell(Array_defenderSpawnAngle_Map, arrayIndex);

				set_entvar(clientIndex, var_origin, vOrigin);
				set_entvar(clientIndex, var_angles, vAngle);
				set_entvar(clientIndex, var_v_angle, vAngle);
				set_entvar(clientIndex, var_fixangle, 1);
			}
		}

		new arrayIndex;
		if((arrayIndex = ArrayFindValue(Array_semiclipATTACKER, clientIndex)) != -1)
		{
			ArrayDeleteItem(Array_semiclipATTACKER, arrayIndex);
			TotalSemiclipATTACKER--;
		}

		if(ArrayFindValue(Array_semiclipDEFENDER, clientIndex) == -1)
		{
			ArrayPushCell(Array_semiclipDEFENDER, clientIndex);
			TotalSemiclipDEFENDER++;
		}

		bSemiclipATTACKER[clientIndex] = false;
		bSemiclipDEFENDER[clientIndex] = true;
	}		
}

public OnPlayerSpawn(const clientIndex)
{
	if(!is_user_alive(clientIndex))
		return;

	Log("%s/OnPlayerSpawn (client %i)", PLUGIN, clientIndex);
	if(ArrayFindValue(Array_playerALIVE, clientIndex) == -1)
		ArrayPushCell(Array_playerALIVE, clientIndex);

	new arrayIndex;
	if((arrayIndex = ArrayFindValue(Array_playerDEAD, clientIndex)) != -1)
		ArrayDeleteItem(Array_playerDEAD, arrayIndex);

	if(playerTEAM[clientIndex] == TEAM_ATTACKERS) {
		new arrayIndex;
		if((arrayIndex = ArrayFindValue(Array_semiclipDEFENDER, clientIndex)) != -1)
		{
			ArrayDeleteItem(Array_semiclipDEFENDER, arrayIndex);
			TotalSemiclipDEFENDER--;
		}

		if(ArrayFindValue(Array_semiclipATTACKER, clientIndex) == -1)
		{
			ArrayPushCell(Array_semiclipATTACKER, clientIndex);
			TotalSemiclipATTACKER++;
		}

		bSemiclipDEFENDER[clientIndex] = false;
		bSemiclipATTACKER[clientIndex] = true;

		new arraySize = ArraySize(Array_attackerSpawnOrigin);
		if(arraySize)
		{
			new arrayIndex = random_num(0, arraySize-1);
			new Float:vOrigin[3], Float:vAngle[3];
			ArrayGetArray(Array_attackerSpawnOrigin, arrayIndex, vOrigin);
			vAngle[1] = Float:ArrayGetCell(Array_attackerSpawnAngle, arrayIndex);

			set_entvar(clientIndex, var_origin, vOrigin);
			set_entvar(clientIndex, var_angles, vAngle);
			set_entvar(clientIndex, var_v_angle, vAngle);
			set_entvar(clientIndex, var_fixangle, 1);
		} else {
			arraySize = ArraySize(Array_attackerSpawnOrigin_Map);
			if(arraySize)
			{
				new arrayIndex = random_num(0, arraySize-1);
				new Float:vOrigin[3], Float:vAngle[3];
				ArrayGetArray(Array_attackerSpawnOrigin_Map, arrayIndex, vOrigin);
				vAngle[1] = Float:ArrayGetCell(Array_attackerSpawnAngle_Map, arrayIndex);

				set_entvar(clientIndex, var_origin, vOrigin);
				set_entvar(clientIndex, var_angles, vAngle);
				set_entvar(clientIndex, var_v_angle, vAngle);
				set_entvar(clientIndex, var_fixangle, 1);
			}
		}

	} else if(playerTEAM[clientIndex] == TEAM_DEFENDERS) {
		new arrayIndex;
		if((arrayIndex = ArrayFindValue(Array_semiclipATTACKER, clientIndex)) != -1)
		{
			ArrayDeleteItem(Array_semiclipATTACKER, arrayIndex);
			TotalSemiclipATTACKER--;
		}

		if(ArrayFindValue(Array_semiclipDEFENDER, clientIndex) == -1)
		{
			ArrayPushCell(Array_semiclipDEFENDER, clientIndex);
			TotalSemiclipDEFENDER++;
		}
		bSemiclipATTACKER[clientIndex] = false;
		bSemiclipDEFENDER[clientIndex] = true;
	
		new arraySize = ArraySize(Array_defenderSpawnOrigin);
		if(arraySize)
		{
			new arrayIndex = random_num(0, arraySize-1);
			new Float:vOrigin[3], Float:vAngle[3];
			ArrayGetArray(Array_defenderSpawnOrigin, arrayIndex, vOrigin);
			vAngle[1] = Float:ArrayGetCell(Array_defenderSpawnAngle, arrayIndex);

			set_entvar(clientIndex, var_origin, vOrigin);
			set_entvar(clientIndex, var_angles, vAngle);
			set_entvar(clientIndex, var_v_angle, vAngle);
			set_entvar(clientIndex, var_fixangle, 1);
		} else {
			arraySize = ArraySize(Array_defenderSpawnOrigin_Map);
			if(arraySize)
			{
				new arrayIndex = random_num(0, arraySize-1);
				new Float:vOrigin[3], Float:vAngle[3];
				ArrayGetArray(Array_defenderSpawnOrigin_Map, arrayIndex, vOrigin);
				vAngle[1] = Float:ArrayGetCell(Array_defenderSpawnAngle_Map, arrayIndex);

				set_entvar(clientIndex, var_origin, vOrigin);
				set_entvar(clientIndex, var_angles, vAngle);
				set_entvar(clientIndex, var_v_angle, vAngle);
				set_entvar(clientIndex, var_fixangle, 1);
			}
		}
	}	

	set_entvar(clientIndex, var_team, playerTEAM[clientIndex]);
	new deadlockBarrier = NULLENT;
	if(entityTotalCHILDRENS[clientIndex] > 0)
	{
		for(new arrayIndex = entityTotalCHILDRENS[clientIndex]-1, entityMODEL[128], childrenEntity; arrayIndex >= 0; arrayIndex--)
		{
			childrenEntity = ArrayGetCell(entityCHILDRENS[clientIndex], arrayIndex);
			get_entvar(childrenEntity, var_model, entityMODEL, charsmax(entityMODEL));
			if(equal(entityMODEL, Skill_Resources[17]) || equal(entityMODEL, Skill_Resources[4]))
			{
				if(get_entvar(clientIndex, var_team) == get_entvar(childrenEntity, var_team))
					continue;
			}

			if(equal(entityMODEL, Skill_Resources[28]))
			{
				if(!(get_entvar(childrenEntity, var_flags) & FL_KILLME) && !get_entvar(childrenEntity, var_iuser1) && get_entvar(clientIndex, var_team) == get_entvar(childrenEntity, var_team))
				{
					if(entityTotalCHILDRENS[childrenEntity] > 0)
					{
						for(new arrayIndex2 = entityTotalCHILDRENS[childrenEntity]-1, childrenEntity2; arrayIndex2 >= 0; arrayIndex2--)
						{
							childrenEntity2 = ArrayGetCell(entityCHILDRENS[childrenEntity], arrayIndex2);
							get_entvar(childrenEntity2, var_model, entityMODEL, charsmax(entityMODEL));
							if(equal(entityMODEL, Skill_Resources[29]))
							{
								UTIL_RemoveEntity(childrenEntity2, 0.0);
							}
							if(equal(entityMODEL, Skill_Resources[36]))
							{
								Play_Animation(childrenEntity2, "spin_idle", 6.0);
							}
						}
					}
					deadlockBarrier = childrenEntity;
					continue;
				}
			}

			UTIL_RemoveEntity(childrenEntity, 0.0);
		}
	}
	
	if(playerUsingMenu == clientIndex) playerUsingMenu = NULLENT;

	remove_task(clientIndex+TASK_CONFIG_MENU, 1);
	remove_task(clientIndex+TASK_PLAYER_IMMORTAL, 1);
	remove_task(clientIndex+TASK_PLAYER_PUSH, 1);
	remove_task(clientIndex+TASK_PLAYER_DASH, 1);
	remove_task(clientIndex+TASK_LEERBLIND, 1);
	remove_task(clientIndex+TASK_PLAYER_REGENERATION, 1);
	remove_task(clientIndex+TASK_PLAYER_REGENERATION_END, 1);
	remove_task(clientIndex+TASK_PLAYER_SPEED_END, 1);
	remove_task(clientIndex+TASK_DAMAGEHUD, 1);
	remove_task(clientIndex+TASK_WEAPON_UPGRADE, 1);
	remove_task(clientIndex+TASK_BOTDEATH, 1);
	remove_task(clientIndex+TASK_BOT_SEARCHENEMY, 1);
	remove_task(clientIndex+TASK_BOT_FIRE, 1);

	new params[1]; params[0] = clientIndex;
	if(deadlockBarrier == NULLENT && (get_member_game(m_bFreezePeriod) || ((playerTEAM[clientIndex] == TEAM_ATTACKERS && attackersHaveBARRIER) || (playerTEAM[clientIndex] == TEAM_DEFENDERS && defendersHaveBARRIER)))) {
		set_user_rendering(clientIndex, kRenderFxGlowShell, 255, 255, 255, kRenderNormal, 1);
		
		if(!get_member_game(m_bFreezePeriod)) 
		{
			set_task(immortalTime, "Task_Immortal_End", clientIndex+TASK_PLAYER_IMMORTAL, params, sizeof(params));
			set_task(0.1, "Task_BarrierInside_Sound", clientIndex+TASK_PLAYER_IMMORTAL, params, sizeof(params));
		} else {
			PlaySound(clientIndex, Background_Musics[random_num(3, 8)])
			bCustomAudio = true;
			PlaySound(clientIndex, Announcer_Sounds[random_num(0, 1)]);
			bCustomAudio = false;
		}
		playerInBASE[clientIndex] = true;
	} else {
		set_user_rendering(clientIndex, kRenderFxGlowShell, 255, 255, 255, kRenderNormal, 1);
		playerInBASE[clientIndex] = false;

		set_task(2.0, "Task_Immortal", clientIndex+TASK_PLAYER_IMMORTAL, params, sizeof(params));
	}
	
	rg_send_bartime(clientIndex, 0, false);
	rg_remove_all_items(clientIndex);
	currentWeaponENTITY[clientIndex] = NULLENT;
	SetThink(clientIndex, "");
	lastBODY[clientIndex] = 0;
	fBlockWeaponChange[clientIndex] = 0.0;
	fBlockPlayerAnim[clientIndex] = 0.0;
	currentWeaponENTITY[clientIndex] = NULLENT;
	lastWeaponENTITY[clientIndex] = NULLENT;
	cameraEntity[clientIndex] = NULLENT;
	playerDECAY[clientIndex] = false;
	skillFastDRAW[clientIndex] = false;

	ArrayClear(playersEnemy[clientIndex]);
	ArrayClear(playersTotalDamage[clientIndex]);

	set_entvar(clientIndex, var_effects, get_entvar(clientIndex, var_effects) & ~EF_NODRAW);
	set_entvar(clientIndex, var_flags, get_entvar(clientIndex, var_flags) & ~FL_FROZEN);

	for(new bodyGroup = HIT_HEAD; bodyGroup <= HIT_RIGHTLEG; bodyGroup++) 
	{
		ArrayClear(playersDamageBody[clientIndex][bodyGroup]);
		ArrayClear(playersHitsBody[clientIndex][bodyGroup]);
	}

	for(new victimIndex = 1; victimIndex <= MAX_PLAYERS; victimIndex++) 
	{
		playerID[clientIndex][victimIndex] = NULLENT;
	}
	
	set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[KNIFE][WEAPON_ENTITY_NAME], GT_REPLACE, KNIFE), var_orbweapon, 0);

	if(MyLastKiller[clientIndex] != NULLENT)
	{
		static param[3]; param[0] = MyLastKiller[clientIndex];
		param[1] = 31;
		param[2] = clientIndex;
		//set_task(0.1, "Show_DamageHud_Victim", clientIndex+TASK_DAMAGEHUD, params, sizeof(params));
		MyLastKiller[clientIndex] = NULLENT;
	} else Reset_Player_From_Attackers(clientIndex);

	Load_Player_Agent(clientIndex);

	playerQuoteDelay[clientIndex] = 0.0;
	playerTotalKILL[clientIndex] = 0;
	delayHealing[clientIndex] = 0.0;
	bWeaponFast[clientIndex] = false;
	Player_FOV(clientIndex, bFovTYPE[clientIndex] ? 105 : 90, true);
	bAceSound[clientIndex] = true;
	bAceSound2[clientIndex] = true;

	new Array:Array_weaponID = ArrayCreate(1, 1);
	for(new index = ASAMA_1; index <= ASAMA_FINAL; index++)
	{
		if(MyStageWeapons[clientIndex][index] != NULLENT)
			continue;

		for(new index2 = 0; index2 < sizeof(Asama_Silahlari); index2++)
		{
			if(Asama_Silahlari[index2][2] != index)
				continue;
		
			ArrayPushCell(Array_weaponID, index2);
		}
		if(ArraySize(Array_weaponID))
			MyStageWeapons[clientIndex][index] = ArrayGetCell(Array_weaponID, random_num(0, ArraySize(Array_weaponID)-1));

		ArrayClear(Array_weaponID);
	}
	ArrayDestroy(Array_weaponID);

	set_entvar(clientIndex, var_health, float(Asama_Silahlari[MyStageWeapons[clientIndex][currentSTAGE]][3]));
	set_entvar(clientIndex, var_max_health, float(Asama_Silahlari[MyStageWeapons[clientIndex][currentSTAGE]][3]));

	Set_Player_RoomType(clientIndex, false);
	client_cmd(clientIndex, "gl_fog 1");
	SetPlayerLight(clientIndex, "n");
	Change_Fog(clientIndex, 0, 0, 0, 0);
	isPlayerBlind[clientIndex] = false;
	Reset_Player(clientIndex); 
	Color_Chat(clientIndex, 0, "!g[%s]!n %L", PLUGIN, clientIndex, "INFO_OPEN_MAIN_MENU");

	new weaponID = Asama_Silahlari[MyStageWeapons[clientIndex][currentSTAGE]][1];
	if(weaponID != NULLENT)
	{
		set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 0);
	} else 	if(currentSTAGE > ASAMA_1) {
		weaponID = Asama_Silahlari[MyStageWeapons[clientIndex][ASAMA_1]][1];
		if(weaponID != NULLENT)
		{
			set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 0);
		} 
	} 

	weaponID = Asama_Silahlari[MyStageWeapons[clientIndex][currentSTAGE]][0];
	if(weaponID != NULLENT)
	{
		set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 0);
	} 

	new weaponEntity = currentWeaponENTITY[clientIndex];
	if(weaponEntity != NULLENT)
	{
		ExecuteHamB(Ham_Item_Deploy, weaponEntity);
	}

	set_task(0.1, "Task_Check_Player", clientIndex+TASK_BOT_SEARCHENEMY, params, sizeof(params));

	if(deadlockBarrier != NULLENT)
	{
		UTIL_PlayerAnimation(clientIndex, "skill_revive");
		rh_emit_sound(deadlockBarrier, 0, CHAN_STATIC, Skill_Resources[35], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		set_task(1.7, "Task_Deadlock_Quote", clientIndex+TASK_PLAYER_IMMORTAL, params, sizeof(params));

		RequestFrame("Task_Camera", clientIndex);

		new Float:vOrigin[3], Float:vAngle[3];
		get_entvar(deadlockBarrier, var_origin, vOrigin);
		new respawnEffect = Create_Model_Sprite(clientIndex, Skill_Resources[30], vOrigin, ORIENTED, 0, 0.0, 1.7, 1.0, 0, 0.0, 0, false, false);
		bEntityHaveTeam[respawnEffect] = true;
		set_entvar(respawnEffect, var_team, playerTEAM[clientIndex]);
		vOrigin[2] += 36.0;
		get_entvar(deadlockBarrier, var_angles, vAngle);
		vAngle[0] = 0.0;

		set_entvar(clientIndex, var_origin, vOrigin);
		set_entvar(clientIndex, var_angles, vAngle);
		set_entvar(clientIndex, var_v_angle, vAngle);
		set_entvar(clientIndex, var_fixangle, 1);
		Kurtar(clientIndex, 32, 128);
		UTIL_RemoveEntity(deadlockBarrier, 2.0);
		fBlockWeaponChange[clientIndex] = get_gametime() + 1.8;
		fBlockPlayerAnim[clientIndex] = get_gametime() + 1.6;
		set_entvar(clientIndex, var_maxspeed, 1.0);
		set_entvar(clientIndex, var_weaponmodel, "");

		new weaponEntity = currentWeaponENTITY[clientIndex];
		if(weaponEntity != NULLENT)
		{
			remove_task(weaponEntity+TASK_WEAPON);
		}
	} else {
		Kurtar(clientIndex, 32, 128);
		if(bUpdateMenu[clientIndex]) Show_WeaponMenu(clientIndex);
	}
}

public Task_Check_Player(params[], taskid)
{
	new clientIndex = params[0]; 
	if(bRealBot[clientIndex])
	{
		ArrayClear(botFollowPoint2[clientIndex]);
		new Float:vTarget[3]; ArrayGetArray(botFollowPoint, random_num(0, ArraySize(botFollowPoint)-1), vTarget, 3);
		vBotTargetOrigin[clientIndex] = vTarget;
		new param[1]; param[0] = clientIndex;
		set_task(0.2, "Task_Bot_SearchEnemy", clientIndex+TASK_BOT_SEARCHENEMY, param, sizeof(param));
	}
}

public OnSetAnimation(const clientIndex, PLAYER_ANIM:playerAnim)
{ 
	if(fBlockPlayerAnim[clientIndex] > get_gametime())
		return HC_SUPERCEDE;
	
	return HC_CONTINUE;	
}

public Task_Camera(clientIndex)
{
	if(!task_exists(clientIndex+TASK_PLAYER_IMMORTAL, 1))
		return;
	if(!is_user_alive(clientIndex))
		return;

	Set_Player_View(clientIndex, 0.0, 0.0, 0.0, 100.0, clientIndex);
}

public Task_Deadlock_Quote(params[], taskid)
{
	new clientIndex = params[0]; 
	if(playerAgentID[clientIndex] == AGENT_DEADLOCK)
	{
		Character_Quote(clientIndex, QUOTE_SKILL2);
	}		
	rg_reset_maxspeed(clientIndex);

	if(Get_Player_ViewEntity(clientIndex) > 0) UTIL_RemoveEntity(Get_Player_ViewEntity(clientIndex), 0.0);

	new weaponEntity = currentWeaponENTITY[clientIndex];
	if(weaponEntity != NULLENT)
	{
		ExecuteHamB(Ham_Item_Deploy, weaponEntity);
	}
}

public OnResetMaxSpeed(const clientIndex)
{
	if(is_user_alive(clientIndex))
	{
		Log("%s/OnResetMaxSpeed", PLUGIN);

		if(get_member_game(m_bFreezePeriod))
		{
			if((playerTEAM[clientIndex] == TEAM_ATTACKERS && !attackersHaveBARRIER) || (playerTEAM[clientIndex] == TEAM_DEFENDERS && !defendersHaveBARRIER))
				return HC_CONTINUE;
		}

		if(fBlockPlayerAnim[clientIndex] > get_gametime())
		{
			set_entvar(clientIndex, var_maxspeed, 1.0);
			return HC_SUPERCEDE;
		}

		new Float:speedWEAPON = weaponSPEED[clientIndex];
		if(weaponSPEED[clientIndex] > 0.0) 
		{
			if(bWeaponFast[clientIndex]) speedWEAPON += orbSpeedPOWER;
			if(get_entvar(clientIndex, var_maxspeed) != speedWEAPON) 
			{
				set_entvar(clientIndex, var_maxspeed, speedWEAPON);
			}
			return HC_SUPERCEDE;
		}
	}
	return HC_CONTINUE
}	

Character_Quote(const clientIndex, const QuoteType)
{
	Log("%s/Character_Quote", PLUGIN);

	new szSound[128];
	switch(QuoteType)
	{
		case QUOTE_KILL_HEADSHOT:
		{
			if(playerQuoteDelay[clientIndex] <= get_gametime() && ArraySize(Array_HeadshotKillSounds[clientIndex]))
			{
				ArrayGetString(Array_HeadshotKillSounds[clientIndex], random_num(0, ArraySize(Array_HeadshotKillSounds[clientIndex])-1), szSound, charsmax(szSound));
				playerQuoteDelay[clientIndex] = get_gametime() + 2.0;
			}
		}
		case QUOTE_KILL:
		{
			if(playerQuoteDelay[clientIndex] <= get_gametime() && ArraySize(Array_KillSounds[clientIndex]))
			{
				ArrayGetString(Array_KillSounds[clientIndex], random_num(0, ArraySize(Array_KillSounds[clientIndex])-1), szSound, charsmax(szSound));
				playerQuoteDelay[clientIndex] = get_gametime() + 2.0;
			}
		}
		case QUOTE_3KILL:
		{
			if(ArraySize(Array_3KillSounds[clientIndex]))
			{
				ArrayGetString(Array_3KillSounds[clientIndex], random_num(0, ArraySize(Array_3KillSounds[clientIndex])-1), szSound, charsmax(szSound));
			}
		}
		case QUOTE_4KILL:
		{
			if(ArraySize(Array_4KillSounds[clientIndex]))
			{
				ArrayGetString(Array_4KillSounds[clientIndex], random_num(0, ArraySize(Array_4KillSounds[clientIndex])-1), szSound, charsmax(szSound));
			}
		}
		case QUOTE_5KILL:
		{
			if(ArraySize(Array_5KillSounds[clientIndex]))
			{
				ArrayGetString(Array_5KillSounds[clientIndex], random_num(0, ArraySize(Array_5KillSounds[clientIndex])-1), szSound, charsmax(szSound));
			}
		}
		case QUOTE_ACE:
		{
			if(ArraySize(Array_AceSounds[clientIndex]))
			{
				ArrayGetString(Array_AceSounds[clientIndex], random_num(0, ArraySize(Array_AceSounds[clientIndex])-1), szSound, charsmax(szSound));
				playerQuoteDelay[clientIndex] = get_gametime() + 5.0;
			}
		}
		case QUOTE_PAIN_HEAD:
		{
			if(playerQuoteDelay[clientIndex] <= get_gametime() && ArraySize(Array_PainHeadSounds[clientIndex]))
			{
				ArrayGetString(Array_PainHeadSounds[clientIndex], random_num(0, ArraySize(Array_PainHeadSounds[clientIndex])-1), szSound, charsmax(szSound));
			}
		}
		case QUOTE_PAIN:
		{
			if(playerQuoteDelay[clientIndex] <= get_gametime() && ArraySize(Array_PainBodySounds[clientIndex]))
			{
				ArrayGetString(Array_PainBodySounds[clientIndex], random_num(0, ArraySize(Array_PainBodySounds[clientIndex])-1), szSound, charsmax(szSound));
			}
		}
		case QUOTE_ALMOST_WIN:
		{
			if(ArraySize(Array_AlmostWinSounds[clientIndex]))
			{
				ArrayGetString(Array_AlmostWinSounds[clientIndex], random_num(0, ArraySize(Array_AlmostWinSounds[clientIndex])-1), szSound, charsmax(szSound));
			}
		}
		case QUOTE_HEALING:
		{
			if(playerQuoteDelay[clientIndex] <= get_gametime() && ArraySize(Array_HealSounds[clientIndex]))
			{
				ArrayGetString(Array_HealSounds[clientIndex], random_num(0, ArraySize(Array_HealSounds[clientIndex])-1), szSound, charsmax(szSound));
			}
		}
		case QUOTE_WIN:
		{
			if(ArraySize(Array_WinSounds[clientIndex]))
			{
				ArrayGetString(Array_WinSounds[clientIndex], random_num(0, ArraySize(Array_WinSounds[clientIndex])-1), szSound, charsmax(szSound));
			}
		}
		case QUOTE_CANTUSE:
		{
			static Float:antiFlood[MAX_PLAYERS + 1];
			if(playerQuoteDelay[clientIndex] <= get_gametime() && antiFlood[clientIndex] <= get_gametime() && ArraySize(Array_CantUseSounds[clientIndex]))
			{
				ArrayGetString(Array_CantUseSounds[clientIndex], random_num(0, ArraySize(Array_CantUseSounds[clientIndex])-1), szSound, charsmax(szSound));
				antiFlood[clientIndex] = get_gametime() + 2.0;
			}
		}
		case QUOTE_ULTREADY:
		{
			if(ArraySize(Array_UltReadySounds[clientIndex]))
			{
				ArrayGetString(Array_UltReadySounds[clientIndex], random_num(0, ArraySize(Array_UltReadySounds[clientIndex])-1), szSound, charsmax(szSound));
			}
		}
		case QUOTE_SKILL1:
		{
			if(playerQuoteDelay[clientIndex] <= get_gametime() && ArraySize(Array_Skill1Sounds[clientIndex]))
			{
				ArrayGetString(Array_Skill1Sounds[clientIndex], random_num(0, ArraySize(Array_Skill1Sounds[clientIndex])-1), szSound, charsmax(szSound));
			}
		}
		case QUOTE_SKILL2:
		{
			if(playerQuoteDelay[clientIndex] <= get_gametime() && ArraySize(Array_Skill2Sounds[clientIndex]))
			{
				ArrayGetString(Array_Skill2Sounds[clientIndex], random_num(0, ArraySize(Array_Skill2Sounds[clientIndex])-1), szSound, charsmax(szSound));
				playerQuoteDelay[clientIndex] = get_gametime() + 2.0;
			}
		}
	}

	if(!strlen(szSound))
		return;

	if(QuoteType == QUOTE_5KILL) 
	{
		bCustomAudio = true;
		rg_send_audio(0, szSound, PITCH_NORM);
		bCustomAudio = false;
	} else if(QuoteType == QUOTE_SKILL1) {
		for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, playerIndex; arrayIndex >= 0; arrayIndex--)
		{
			playerIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);
			if(playerTEAM[playerIndex] != playerTEAM[clientIndex])
				continue;

			rh_emit_sound(clientIndex, playerIndex, CHAN_VOICE, szSound, 0.75, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		}
	} else {
		rh_emit_sound(clientIndex, clientIndex, CHAN_VOICE, szSound, 0.75, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	}
}

Load_Player_Agent(const clientIndex)
{
	Log("%s/Load_Player_Agent", PLUGIN);

	if(playerNextAgent[clientIndex] == NULLENT)
		return;

	new Float:Mins[3] = { -16.0, -16.0, -36.0 }; 
	new Float:Maxs[3] = { 16.0, 16.0, 72.0 };

	engfunc(EngFunc_SetSize, clientIndex, Mins, Maxs);
	set_entvar(clientIndex, var_mins, Mins); 
	set_entvar(clientIndex, var_maxs, Maxs); 
	set_entvar(clientIndex, var_absmin, Mins);
	set_entvar(clientIndex, var_absmax, Maxs);

	rg_set_user_model(clientIndex, Agent_Info[playerNextAgent[clientIndex]][PLAYER_MODEL], true);
	
	rg_remove_items_by_slot(clientIndex, GRENADE_SLOT);
	if(!playerCOOLDOWN[clientIndex] && !get_member_game(m_bFreezePeriod))
	{
		fSkillDelay[clientIndex] = get_gametime() + 0.01;

		new weaponEntity = rg_give_custom_item(clientIndex, "weapon_hegrenade", GT_APPEND);
		if(weaponEntity != NULLENT)
		{
			remove_task(weaponEntity+TASK_WEAPON, 1);

			Change_WeaponList(clientIndex, weaponEntity, fmt("Jenessee_Valorant/weapons/%s", Agent_Skills[playerNextAgent[clientIndex]][SKILL_SPRITE]), false);
			
			rg_set_iteminfo(weaponEntity, ItemInfo_pszName, fmt("Jenessee_Valorant/weapons/%s", Agent_Skills[playerNextAgent[clientIndex]][SKILL_SPRITE]));
			set_entvar(weaponEntity, var_netname, fmt("%L", LANG_PLAYER, Agent_Skills[playerNextAgent[clientIndex]][SKILL_NAME]));
		}
	} else {
		Change_WeaponList(clientIndex, 0, fmt("Jenessee_Valorant/weapons/%s", Agent_Skills[playerNextAgent[clientIndex]][SKILL_SPRITE]), false);
	}

	if(playerNextAgent[clientIndex] == playerAgentID[clientIndex])
		return;

	playerAgentID[clientIndex] = playerNextAgent[clientIndex];

	ArrayClear(Array_DeathSounds[clientIndex]);
	ArrayClear(Array_PainHeadSounds[clientIndex]);
	ArrayClear(Array_PainBodySounds[clientIndex]);
	ArrayClear(Array_HeadshotKillSounds[clientIndex]);
	ArrayClear(Array_KillSounds[clientIndex]);
	ArrayClear(Array_3KillSounds[clientIndex]);
	ArrayClear(Array_4KillSounds[clientIndex]);
	ArrayClear(Array_5KillSounds[clientIndex]);
	ArrayClear(Array_AceSounds[clientIndex]);
	ArrayClear(Array_HealSounds[clientIndex]);
	ArrayClear(Array_AlmostWinSounds[clientIndex]);
	ArrayClear(Array_WinSounds[clientIndex]);
	ArrayClear(Array_CantUseSounds[clientIndex]);
	ArrayClear(Array_UltReadySounds[clientIndex]);
	ArrayClear(Array_Skill1Sounds[clientIndex]);
	ArrayClear(Array_Skill2Sounds[clientIndex]);

	for(new index = 0; index < sizeof(Agent_Quote_HeadShotKill); index++) 
	{
		if(Agent_Quote_HeadShotKill[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_HeadshotKillSounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_HeadShotKill[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_Kill); index++)
	{
		if(Agent_Quote_Kill[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_KillSounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Kill[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_3Kill); index++)
	{
		if(Agent_Quote_3Kill[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_3KillSounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_3Kill[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_4Kill); index++)
	{
		if(Agent_Quote_4Kill[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_4KillSounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_4Kill[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_5Kill); index++)
	{
		if(Agent_Quote_5Kill[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_5KillSounds[clientIndex], fmt("Jenessee_Valorant/announcer/%s.wav", Agent_Quote_5Kill[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_Ace); index++)
	{
		if(Agent_Quote_Ace[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_AceSounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Ace[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_AlmostWin); index++)
	{
		if(Agent_Quote_AlmostWin[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_AlmostWinSounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_AlmostWin[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_Win); index++)
	{
		if(Agent_Quote_Win[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_WinSounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Win[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_CantUse); index++)
	{
		if(Agent_Quote_CantUse[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_CantUseSounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_CantUse[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_UltReady); index++)
	{
		if(Agent_Quote_UltReady[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_UltReadySounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_UltReady[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_Skill1); index++)
	{
		if(Agent_Quote_Skill1[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_Skill1Sounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Skill1[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_Skill2); index++)
	{
		if(Agent_Quote_Skill2[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_Skill2Sounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Skill2[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_Death); index++)
	{
		if(Agent_Quote_Death[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_DeathSounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Death[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_PainBody); index++)
	{
		if(Agent_Quote_PainBody[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_PainBodySounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_PainBody[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_PainHead); index++)
	{
		if(Agent_Quote_PainHead[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_PainHeadSounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_PainHead[index][1]));
	}
	for(new index = 0; index < sizeof(Agent_Quote_Healing); index++)
	{
		if(Agent_Quote_Healing[index][0] != playerAgentID[clientIndex])
			continue;

		ArrayPushString(Array_HealSounds[clientIndex], fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Healing[index][1]));
	}
}

public Task_Immortal(params[], taskid)
{
	new clientIndex = params[0]; 
	Log("%s/Task_Immortal", PLUGIN);

	playerDECAY[clientIndex] = false;
	remove_task(clientIndex+TASK_PLAYER_IMMORTAL, 1);
	set_user_rendering(clientIndex);
}

public Task_Immortal_End(params[], taskid)
{
	new clientIndex = params[0]; 
	Log("%s/Task_Immortal_End", PLUGIN);

	if(playerInBASE[clientIndex])
	{
		if(strlen(barrierDecaySound)) 
		{
			rh_emit_sound(clientIndex, clientIndex, CHAN_ITEM, barrierDecaySound, 0.4, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		}
		playerDECAY[clientIndex] = true;
		bCustomAudio = true;
		rg_send_audio(clientIndex, Announcer_Sounds[random_num(8, 10)]);
		bCustomAudio = false;
		Task_Decay_Inside_Barrier(params, clientIndex+TASK_PLAYER_IMMORTAL);
		return;	
	}

	remove_task(clientIndex+TASK_PLAYER_IMMORTAL, 1);
	set_user_rendering(clientIndex);
}

public Task_Decay_Inside_Barrier(params[], taskid)
{
	new clientIndex = params[0]; 
	Log("%s/Task_Decay_Inside_Barrier", PLUGIN);

	new Float:fHealth = get_entvar(clientIndex, var_health);
	if((fHealth -= decayHealth) <= 0.0)
	{
		user_silentkill(clientIndex);
		return;
	}  
	
	Character_Quote(clientIndex, QUOTE_PAIN);

	set_entvar(clientIndex, var_health, fHealth);
	new param[1]; param[0] = clientIndex;
	set_task(1.0, "Task_Decay_Inside_Barrier", clientIndex+TASK_PLAYER_IMMORTAL, param, sizeof(param));
}

public OnPlayerDeath()
{
	new attackerIndex = read_data(1), bHeadshot = read_data(3); 
	new clientIndex = read_data(2)
	Log("%s/OnPlayerDeath (client %i)", PLUGIN, clientIndex);

	if(ArrayFindValue(Array_playerDEAD, clientIndex) == -1)
		ArrayPushCell(Array_playerDEAD, clientIndex);

	new arrayIndex;
	if((arrayIndex = ArrayFindValue(Array_playerALIVE, clientIndex)) != -1)
		ArrayDeleteItem(Array_playerALIVE, arrayIndex);

	if((arrayIndex = ArrayFindValue(Array_semiclipATTACKER, clientIndex)) != -1)
	{
		ArrayDeleteItem(Array_semiclipATTACKER, arrayIndex);
		TotalSemiclipATTACKER--;
	}

	if((arrayIndex = ArrayFindValue(Array_semiclipDEFENDER, clientIndex)) != -1)
	{
		ArrayDeleteItem(Array_semiclipDEFENDER, arrayIndex);
		TotalSemiclipDEFENDER--;
	}

	bSemiclipATTACKER[clientIndex] = false;
	bSemiclipDEFENDER[clientIndex] = false;

	if(entityTotalCHILDRENS[clientIndex] > 0)
	{
		for(new arrayIndex = entityTotalCHILDRENS[clientIndex]-1, entityMODEL[128], childrenEntity; arrayIndex >= 0; arrayIndex--)
		{
			childrenEntity = ArrayGetCell(entityCHILDRENS[clientIndex], arrayIndex);
			get_entvar(childrenEntity, var_model, entityMODEL, charsmax(entityMODEL));
			if(equal(entityMODEL, Skill_Resources[17]) || equal(entityMODEL, Skill_Resources[4]) || (equal(entityMODEL, Skill_Resources[28]) && !get_entvar(childrenEntity, var_iuser1)))
				continue;

			UTIL_RemoveEntity(childrenEntity, 0.0);
		}
	}

	if(playerUsingMenu == clientIndex) playerUsingMenu = NULLENT;

	remove_task(clientIndex+TASK_CONFIG_MENU, 1);
	remove_task(clientIndex+TASK_PLAYER_IMMORTAL, 1);
	remove_task(clientIndex+TASK_PLAYER_PUSH, 1);
	remove_task(clientIndex+TASK_PLAYER_DASH, 1);
	remove_task(clientIndex+TASK_LEERBLIND, 1);
	remove_task(clientIndex+TASK_PLAYER_REGENERATION, 1);
	remove_task(clientIndex+TASK_PLAYER_REGENERATION_END, 1);
	remove_task(clientIndex+TASK_PLAYER_SPEED_END, 1);
	remove_task(clientIndex+TASK_WEAPON_UPGRADE, 1);
	remove_task(clientIndex+TASK_BOTDEATH, 1);
	remove_task(clientIndex+TASK_BOT_SEARCHENEMY, 1);
	remove_task(clientIndex+TASK_BOT_FIRE, 1);
	remove_task(clientIndex+TASK_FIX_ORIGIN, 1);
	
	if(bHeadshot) rh_emit_sound(clientIndex, clientIndex, CHAN_BODY, Head_Damage_Take[random_num(0, sizeof(Head_Damage_Take)-1)], 0.6, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);

	MyLastKiller[clientIndex] = NULLENT;
	if(attackerIndex > 0 && attackerIndex <= MAX_PLAYERS)
	{
		if(attackerIndex != clientIndex)
		{
			if(playerTEAM[attackerIndex] == TEAM_DEFENDERS) rg_update_teamscores(1, 0, true);
			else if(playerTEAM[attackerIndex] == TEAM_ATTACKERS) rg_update_teamscores(0, 1, true);

			static params[4];
			new weapon[32]; read_data(4, weapon, charsmax(weapon));

			params[0] = clientIndex;
			params[1] = bHeadshot;
			params[2] = equal(weapon, "grenade") ? 1 : 0;
			params[3] = attackerIndex;
			remove_task(attackerIndex+TASK_DAMAGEHUD, 1);
			set_task(0.1, "Show_DamageHud_Attacker", attackerIndex+TASK_DAMAGEHUD, params, sizeof(params));
			set_task(1.0, "Player_Kill_Quote", attackerIndex+TASK_DAMAGEHUD, params, sizeof(params));

			MyLastKiller[clientIndex] = attackerIndex;
			params[0] = attackerIndex;
			params[1] = 0;
			params[2] = clientIndex;
			remove_task(clientIndex+TASK_DAMAGEHUD, 1);
			//set_task(0.1, "Show_DamageHud_Victim", clientIndex+TASK_DAMAGEHUD, params, 3);
		}
	}
	
	set_user_rendering(clientIndex);

	set_entvar(clientIndex, var_effects, get_entvar(clientIndex, var_effects) & ~EF_NODRAW);
	set_entvar(clientIndex, var_flags, get_entvar(clientIndex, var_flags) & ~FL_FROZEN);

	Player_FOV(clientIndex, bFovTYPE[clientIndex] ? 105 : 90, true);
	Reset_Player(clientIndex); 
	rg_send_bartime(clientIndex, 0, false);
	SetThink(clientIndex, "");
	rg_remove_all_items(clientIndex);
	currentWeaponENTITY[clientIndex] = NULLENT;
	Set_Player_RoomType(clientIndex, false);
	Change_Fog(clientIndex, 0, 0, 0, 0);
	SetPlayerLight(clientIndex, "n");
	lastBODY[clientIndex] = 0;
	isPlayerBlind[clientIndex] = false;

	rh_emit_sound(clientIndex, clientIndex, 501, "common/null.wav", 0.8, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	rh_emit_sound(clientIndex, clientIndex, CHAN_ITEM, "common/null.wav", VOL_NORM, ATTN_NORM, SND_STOP, PITCH_NORM, SND_EMIT2_NOPAS);
	rh_emit_sound(clientIndex, clientIndex, CHAN_VOICE, "common/null.wav", VOL_NORM, ATTN_NORM, SND_STOP, PITCH_NORM, SND_EMIT2_NOPAS);
}

public OnChangeTeam()
{
	new clientIndex = read_data(1);
	new Team[2]; read_data(2, Team, 1);

	Log("%s/OnChangeTeam (client %d team %s)", PLUGIN, clientIndex, Team);
	new params[1]; params[0] = clientIndex;
	new arrayIndex;
	switch(Team[0])
	{
		case 'T': 
		{
			playerTEAM[clientIndex] = TEAM_ATTACKERS;
			set_entvar(clientIndex, var_team, TEAM_ATTACKERS);

			if(ArrayFindValue(Array_playerATTACKERS, clientIndex) == -1)
				ArrayPushCell(Array_playerATTACKERS, clientIndex);

			if((arrayIndex = ArrayFindValue(Array_playerDEFENDERS, clientIndex)) != -1)
				ArrayDeleteItem(Array_playerDEFENDERS, arrayIndex);

			if(is_user_alive(clientIndex))
			{
				Load_Player_Agent(clientIndex);
				Task_Fix_Origin(params, clientIndex+TASK_FIX_ORIGIN);
			}
		}
		case 'C': 
		{
			playerTEAM[clientIndex] = TEAM_DEFENDERS; 
			set_entvar(clientIndex, var_team, TEAM_DEFENDERS);

			if(ArrayFindValue(Array_playerDEFENDERS, clientIndex) == -1)
				ArrayPushCell(Array_playerDEFENDERS, clientIndex);

			if((arrayIndex = ArrayFindValue(Array_playerATTACKERS, clientIndex)) != -1)
				ArrayDeleteItem(Array_playerATTACKERS, arrayIndex);

			if(is_user_alive(clientIndex))
			{
				Load_Player_Agent(clientIndex);
				Task_Fix_Origin(params, clientIndex+TASK_FIX_ORIGIN);
			}
		}
		case 'S': 
		{
			playerTEAM[clientIndex] = TEAM_SPECTATORS; 
			set_entvar(clientIndex, var_team, TEAM_SPECTATORS);

			if((arrayIndex = ArrayFindValue(Array_playerDEFENDERS, clientIndex)) != -1)
				ArrayDeleteItem(Array_playerDEFENDERS, arrayIndex);
			if((arrayIndex = ArrayFindValue(Array_playerATTACKERS, clientIndex)) != -1)
				ArrayDeleteItem(Array_playerATTACKERS, arrayIndex);

			if((arrayIndex = ArrayFindValue(Array_semiclipATTACKER, clientIndex)) != -1)
			{
				ArrayDeleteItem(Array_semiclipATTACKER, arrayIndex);
				TotalSemiclipATTACKER--;
			}
			if((arrayIndex = ArrayFindValue(Array_semiclipDEFENDER, clientIndex)) != -1)
			{
				ArrayDeleteItem(Array_semiclipDEFENDER, arrayIndex);
				TotalSemiclipDEFENDER--;
			}

			bSemiclipATTACKER[clientIndex] = false;
			bSemiclipDEFENDER[clientIndex] = false;
		}
		default: 
		{
			playerTEAM[clientIndex] = TEAM_UNASSIGNEDS; 
			set_entvar(clientIndex, var_team, TEAM_UNASSIGNEDS);

			if((arrayIndex = ArrayFindValue(Array_playerDEFENDERS, clientIndex)) != -1)
				ArrayDeleteItem(Array_playerDEFENDERS, arrayIndex);
			if((arrayIndex = ArrayFindValue(Array_playerATTACKERS, clientIndex)) != -1)
				ArrayDeleteItem(Array_playerATTACKERS, arrayIndex);

			if((arrayIndex = ArrayFindValue(Array_semiclipATTACKER, clientIndex)) != -1)
			{
				ArrayDeleteItem(Array_semiclipATTACKER, arrayIndex);
				TotalSemiclipATTACKER--;
			}
			if((arrayIndex = ArrayFindValue(Array_semiclipDEFENDER, clientIndex)) != -1)
			{
				ArrayDeleteItem(Array_semiclipDEFENDER, arrayIndex);
				TotalSemiclipDEFENDER--;
			}

			bSemiclipATTACKER[clientIndex] = false;
			bSemiclipDEFENDER[clientIndex] = false;
		}
	}
} 

public OnMessage_StatusIcon(Index, Dest, clientIndex)
{
	static spriteIcon[8]; get_msg_arg_string(2, spriteIcon, charsmax(spriteIcon))
	if (equal(spriteIcon, "buyzone") && get_msg_arg_int(1))
	{
		set_msg_arg_int(3, get_msg_argtype(1), 0)
		set_msg_arg_int(4, get_msg_argtype(1), 0)
		set_msg_arg_int(5, get_msg_argtype(1), 0)
	}
	
	return PLUGIN_CONTINUE;
}

public OnMessage_RoundTime()
{
	if(!get_member_game(m_bFreezePeriod))
		set_msg_arg_int(1, ARG_SHORT, get_timeleft() + 1);
}

public OnMessage_SendAudio()
{
	return bCustomAudio ? PLUGIN_CONTINUE : PLUGIN_HANDLED;
}

public OnMessage_TextMsg(msg_id, msg_dest, clientIndex)
{
	new szMessage[22]; get_msg_arg_string(2, szMessage, charsmax(szMessage));
	if (equal(szMessage, "#Hostages_Not_Rescued") || equal(szMessage, "#Round_Draw") || equal(szMessage, "#CTs_Win") || equal(szMessage, "#Terrorists_Win"))
		return PLUGIN_HANDLED

	if(get_msg_args() == 5) {
		if(get_msg_argtype(5) == ARG_STRING)
		{
			new value5[64]; get_msg_arg_string(5, value5 ,63);
			if(equal(value5, "#Fire_in_the_hole"))
			{
				return PLUGIN_HANDLED;
			}
		}
	} else if(get_msg_args() == 6) {
		if(get_msg_argtype(6) == ARG_STRING)
		{
			new value6[64]; get_msg_arg_string(6, value6 ,63);
			if(equal(value6 ,"#Fire_in_the_hole"))
			{
				return PLUGIN_HANDLED;
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public OnMessage_HideWeapon(iMsgId, iMsgDest, clientIndex)
{
	myHideWeapon[clientIndex] = get_msg_arg_int(1) | (1<<5);
	set_msg_arg_int(1, ARG_BYTE, myHideWeapon[clientIndex] | (1<<6));
}

public OnMessage_SetFOV(iMsgId, iMsgDest, clientIndex) 
{
	if(get_msg_arg_int(1) == 90)
	{
		set_msg_arg_int(1, get_msg_argtype(1), playerDefaultFOV[clientIndex]);
	}
}

public OnAddToFullPack(es, e, entityIndex, clientIndex, hostflags, EntityIsPlayer, pSet)
{
 	if(is_nullent(entityIndex))
	{
		return FMRES_IGNORED;
	}

	if(bSemiclipATTACKER[entityIndex] || bSemiclipDEFENDER[entityIndex]) 
	{
		set_es(es, ES_Solid, SOLID_NOT);
	}

	if(is_user_bot(clientIndex))
	{
		if(entityIndex <= MAX_PLAYERS && !playerInBASE[entityIndex] && playerInBASE[clientIndex])
		{
			set_es(es, ES_Effects, get_es(es, ES_Effects) | EF_NODRAW);
			return FMRES_HANDLED;	
		}

		return FMRES_IGNORED;
	}

	static codeParallel; codeParallel = get_entvar(entityIndex, var_code);
	if(codeParallel == VP_PARALLEL || codeParallel == VP_PARALLEL_ORIENTED) 
	{
		/*static viewEntity, Float:vEntityOrigin[3], Float:vClientOrigin[3], Float:vAngles[3], Float:vUp[3], Float:vDirection[3]; 
		if((viewEntity = get_viewent(clientIndex)) == NULLENT) viewEntity = clientIndex;
		get_entvar(viewEntity, var_origin, vClientOrigin);
		if(viewEntity <= MAX_PLAYERS) 
		{	
			get_entvar(viewEntity, var_view_ofs, vUp);
			xs_vec_add(vClientOrigin, vUp, vClientOrigin);
		}
		get_entvar(entityIndex, var_origin, vEntityOrigin);

		if(codeParallel == VP_PARALLEL_ORIENTED) vEntityOrigin[2] = vClientOrigin[2];	
		xs_vec_sub(vEntityOrigin, vClientOrigin, vDirection);
		xs_vec_normalize(vDirection, vDirection);
		vector_to_angle(vDirection, vAngles);
		vAngles[0] += 90.0;
		set_es(es, ES_Angles, vAngles);*/

		static viewEntity, Float:vAngles[3]; 
		if((viewEntity = get_viewent(clientIndex)) == NULLENT) viewEntity = clientIndex;
		if(viewEntity > MAX_PLAYERS) get_entvar(viewEntity, var_angles, vAngles);
		else get_entvar(viewEntity, var_v_angle, vAngles);
		if(codeParallel == VP_PARALLEL_ORIENTED) vAngles[0] = 90.0;	
		else {
			vAngles[1] -= 180.0;
			vAngles[0] -= 90.0;
		} 
		set_es(es, ES_Angles, vAngles);
	}

	if(bEntityFullPack[entityIndex] && get_viewent(clientIndex) == clientIndex && cs_get_user_zoom(clientIndex) <= CS_SET_NO_ZOOM) 
	{
		set_es(es, ES_AimEnt, clientIndex);
		set_es(es, ES_Skin, clientIndex);
	}

	if(entityIndex == muzzleFlashENTITY && lastBODY[clientIndex] > 0 && !myMuzzle[clientIndex]) 
	{
		set_es(es, ES_Scale, lastSCALE[clientIndex]);
		set_es(es, ES_Body, lastBODY[clientIndex]);
		set_es(es, ES_AimEnt, clientIndex);
		set_es(es, ES_Skin, clientIndex);
		set_es(es, ES_Frame, float(spriteFRAME[clientIndex]));
		set_es(es, ES_RenderAmt, 255);

		lastBODY[clientIndex] = 0;
	}

	if(entityIndex == muzzleFlashENTITY2 && lastBODY[clientIndex] > 0 && spriteFRAME[clientIndex] < 14 && myMuzzle[clientIndex]) 
	{
		set_es(es, ES_Scale, lastSCALE[clientIndex]);
		set_es(es, ES_Body, lastBODY[clientIndex]);
		set_es(es, ES_AimEnt, clientIndex);
		set_es(es, ES_Skin, clientIndex);
		set_es(es, ES_Frame, float(spriteFRAME[clientIndex]));
		set_es(es, ES_RenderAmt, 100);
	}

	if(isPlayerBlind[clientIndex])
	{
		if(entityIndex != muzzleFlashENTITY && entityIndex != muzzleFlashENTITY2 && get_entvar(entityIndex, var_owner) != clientIndex && !bEyeEntity[entityIndex] && !entityBARRIER[entityIndex])
		{
			new classNAME[32]; get_entvar(entityIndex, var_classname, classNAME, sizeof(classNAME));
			if(get_entvar(entityIndex, var_rendermode) == kRenderTransAdd || (!bProwlerEntity[entityIndex] && equal(classNAME, "info_target")))
			{
				set_es(es, ES_Effects, get_es(es, ES_Effects) | EF_NODRAW);
				return FMRES_HANDLED;	
			}
		}
	}

	if(bEntityMap[entityIndex])
	{
		if(!CanSee(clientIndex, entityIndex))
		{
			set_es(es, ES_Effects, get_es(es, ES_Effects) | EF_NODRAW);
			return FMRES_HANDLED;	
		}
	}

	if(entityIndex <= MAX_PLAYERS || bEntityHaveTeam[entityIndex])
	{
		if(entityIndex <= MAX_PLAYERS && ((!playerInBASE[clientIndex] && playerInBASE[entityIndex]) || !CanSee(clientIndex, entityIndex) || isPlayerBlind[clientIndex]))
		{
			set_es(es, ES_Effects, get_es(es, ES_Effects) | EF_NODRAW);
			return FMRES_HANDLED;
		}
		if(entityIndex <= MAX_PLAYERS)
		{
			if(playerTEAM[entityIndex] == playerTEAM[clientIndex])
			{
				if(entityIndex != clientIndex && bHideTeammates[clientIndex])
				{
					set_es(es, ES_Effects, get_es(es, ES_Effects) | EF_NODRAW);
					return FMRES_HANDLED;
				}
				return FMRES_IGNORED;
			} else {
				if(playerInBASE[clientIndex])
				{
					set_es(es, ES_Effects, get_es(es, ES_Effects) | EF_NODRAW);
					return FMRES_HANDLED;
				}
			}
		} else {
			if(get_entvar(entityIndex, var_team) == playerTEAM[clientIndex])
			{
				if(get_entvar(entityIndex, var_owner) != clientIndex && bHideTeammates[clientIndex] && !bProwlerEntity[entityIndex] && !bRazeBomb[entityIndex])
				{
					set_es(es, ES_Effects, get_es(es, ES_Effects) | EF_NODRAW);
					return FMRES_HANDLED;
				}
				return FMRES_IGNORED;
			} else {
				if(playerInBASE[clientIndex] && !bProwlerEntity[entityIndex] && !bRazeBomb[entityIndex])
				{
					set_es(es, ES_Effects, get_es(es, ES_Effects) | EF_NODRAW);
					return FMRES_HANDLED;
				}
			}
		}
		if(get_entvar(entityIndex, var_flags) & EF_NODRAW)
			return FMRES_IGNORED;
		if(bDeadlockEffect[entityIndex])
		{
			set_es(es, ES_Skin, 1);
			return FMRES_IGNORED;
		}
		if(get_entvar(entityIndex, var_renderfx) != kRenderFxNone)
			return FMRES_IGNORED;
		if(get_entvar(entityIndex, var_rendermode) != kRenderNormal)
			return FMRES_IGNORED;

		set_es(es, ES_RenderFx, kRenderFxGlowShell);
		set_es(es, ES_RenderColor, {255, 0, 0});
		set_es(es, ES_RenderAmt, 8);
	}

	return FMRES_HANDLED;
}

public OnCheckVisibility(entityIndex, pset)
{
	if(entityIndex == muzzleFlashENTITY || entityIndex == muzzleFlashENTITY2)
	{
		forward_return(FMV_CELL, 1);
		return FMRES_SUPERCEDE;
	}
	
	return FMRES_IGNORED;
}


public GetGameDesc()
{
	forward_return(FMV_STRING, GameName)
	return FMRES_SUPERCEDE
}

public OnPreThink(const clientIndex)
{
	if(!is_user_alive(clientIndex))
		return;

	dllfunc(DLLFunc_Touch, g_BuyzoneEnt, clientIndex);

	if(playerTEAM[clientIndex] == TEAM_ATTACKERS) {
		if(TotalSemiclipATTACKER)
		{
			for(new arrayIndex = TotalSemiclipATTACKER-1, entityIndex; arrayIndex >= 0; arrayIndex--)
			{
				entityIndex = ArrayGetCell(Array_semiclipATTACKER, arrayIndex);
				if(entityIndex == clientIndex)
					continue;

				set_entvar(entityIndex, var_solid, SOLID_NOT);
			}
		}
	} else if(playerTEAM[clientIndex] == TEAM_DEFENDERS) {
		if(TotalSemiclipDEFENDER)
		{
			for(new arrayIndex = TotalSemiclipDEFENDER-1, entityIndex; arrayIndex >= 0; arrayIndex--)
			{
				entityIndex = ArrayGetCell(Array_semiclipDEFENDER, arrayIndex);
				if(entityIndex == clientIndex)
					continue;

				set_entvar(entityIndex, var_solid, SOLID_NOT);
			}
		}
	}
}

public OnPostThink(const clientIndex)
{
	if(!is_user_alive(clientIndex))
		return;

	if(playerTEAM[clientIndex] == TEAM_ATTACKERS) {
		if(TotalSemiclipATTACKER)
		{
			for(new arrayIndex = TotalSemiclipATTACKER-1, entityIndex; arrayIndex >= 0; arrayIndex--)
			{
				entityIndex = ArrayGetCell(Array_semiclipATTACKER, arrayIndex);
				if(entityIndex == clientIndex)
					continue;

				set_entvar(entityIndex, var_solid, SOLID_BBOX);
			}
		}
	} else if(playerTEAM[clientIndex] == TEAM_DEFENDERS) {
		if(TotalSemiclipDEFENDER)
		{
			for(new arrayIndex = TotalSemiclipDEFENDER-1, entityIndex; arrayIndex >= 0; arrayIndex--)
			{
				entityIndex = ArrayGetCell(Array_semiclipDEFENDER, arrayIndex);
				if(entityIndex == clientIndex)
					continue;

				set_entvar(entityIndex, var_solid, SOLID_BBOX);
			}
		}
	}
} 

public SemiclipEntity(const clientIndex)
{
	if(!is_user_alive(clientIndex))
		return;

	if(playerTEAM[clientIndex] == TEAM_ATTACKERS) {
		if(TotalSemiclipATTACKER)
		{
			for(new arrayIndex = TotalSemiclipATTACKER-1, entityIndex; arrayIndex >= 0; arrayIndex--)
			{
				entityIndex = ArrayGetCell(Array_semiclipATTACKER, arrayIndex);
				if(entityIndex == clientIndex)
					continue;
				if(entityBARRIER[entityIndex] || bEyeEntity[entityIndex] || bProwlerEntity[entityIndex] || bDeadlockEntity[entityIndex])
					continue;

				set_entvar(entityIndex, var_solid, SOLID_NOT);
			}
		}
	} else if(playerTEAM[clientIndex] == TEAM_DEFENDERS) {
		if(TotalSemiclipDEFENDER)
		{
			for(new arrayIndex = TotalSemiclipDEFENDER-1, entityIndex; arrayIndex >= 0; arrayIndex--)
			{
				entityIndex = ArrayGetCell(Array_semiclipDEFENDER, arrayIndex);
				if(entityIndex == clientIndex)
					continue;
				if(entityBARRIER[entityIndex] || bEyeEntity[entityIndex] || bProwlerEntity[entityIndex] || bDeadlockEntity[entityIndex])
					continue;

				set_entvar(entityIndex, var_solid, SOLID_NOT);
			}
		}
	}
}

public UnSemiclipEntity(const clientIndex)
{
	if(!is_user_alive(clientIndex))
		return;

	if(playerTEAM[clientIndex] == TEAM_ATTACKERS) {
		if(TotalSemiclipATTACKER)
		{
			for(new arrayIndex = TotalSemiclipATTACKER-1, entityIndex; arrayIndex >= 0; arrayIndex--)
			{
				entityIndex = ArrayGetCell(Array_semiclipATTACKER, arrayIndex);
				if(entityIndex == clientIndex)
					continue;
				if(entityBARRIER[entityIndex] || bEyeEntity[entityIndex] || bProwlerEntity[entityIndex] || bDeadlockEntity[entityIndex])
					continue;

				set_entvar(entityIndex, var_solid, SOLID_BBOX);
			}
		}
	} else if(playerTEAM[clientIndex] == TEAM_DEFENDERS) {
		if(TotalSemiclipDEFENDER)
		{
			for(new arrayIndex = TotalSemiclipDEFENDER-1, entityIndex; arrayIndex >= 0; arrayIndex--)
			{
				entityIndex = ArrayGetCell(Array_semiclipDEFENDER, arrayIndex);
				if(entityIndex == clientIndex)
					continue;
				if(entityBARRIER[entityIndex] || bEyeEntity[entityIndex] || bProwlerEntity[entityIndex] || bDeadlockEntity[entityIndex])
					continue;

				set_entvar(entityIndex, var_solid, SOLID_BBOX);
			}
		}
	}
} 

public OnClientUserInfoChanged(const clientIndex, const buffer)
{
	static szName[32]; engfunc(EngFunc_InfoKeyValue, buffer, "name", szName, charsmax(szName));
	formatex(playerNAME[clientIndex], charsmax(playerNAME), szName);

	static szClientValue[2];	
	if(get_user_info(clientIndex, "cl_lw", szClientValue, charsmax(szClientValue)))
	{
		set_user_info(clientIndex, "cl_lw", "0");
		return FMRES_SUPERCEDE;
	}

	return FMRES_IGNORED;
}

public Player_FOV(const clientIndex, const FOV, const bool:defaultFOV)
{
	if(defaultFOV) playerDefaultFOV[clientIndex] = FOV;

	if(cs_get_user_zoom(clientIndex) <= CS_SET_NO_ZOOM)
	{
		message_begin(MSG_ONE, Message_SetFOV, _, clientIndex);
		write_byte(FOV);
		message_end();
	}
}

public Semiclip_Entity(const entityIndex, entityTEAM) 
{
	if(entityTEAM == TEAM_ATTACKERS) {
		/*new arrayIndex;
		if((arrayIndex = ArrayFindValue(Array_semiclipDEFENDER, entityIndex)) != -1)
		{
			ArrayDeleteItem(Array_semiclipDEFENDER, arrayIndex);
			TotalSemiclipDEFENDER--;
			bSemiclipDEFENDER[entityIndex] = false;
		}*/

		if(ArrayFindValue(Array_semiclipATTACKER, entityIndex) == -1)
		{
			ArrayPushCell(Array_semiclipATTACKER, entityIndex);
			TotalSemiclipATTACKER++;
		}

		bSemiclipATTACKER[entityIndex] = true;
	} else if(entityTEAM == TEAM_DEFENDERS) {
		/*new arrayIndex;
		if((arrayIndex = ArrayFindValue(Array_semiclipATTACKER, entityIndex)) != -1)
		{
			ArrayDeleteItem(Array_semiclipATTACKER, arrayIndex);
			TotalSemiclipATTACKER--;
			bSemiclipATTACKER[entityIndex] = false;
		}*/

		if(ArrayFindValue(Array_semiclipDEFENDER, entityIndex) == -1)
		{
			ArrayPushCell(Array_semiclipDEFENDER, entityIndex);
			TotalSemiclipDEFENDER++;
		}
		bSemiclipDEFENDER[entityIndex] = true;
	}	
}

public ChildrenParent_Entity(const parentEntity, const childrenEntity) 
{
	if(bEntityHavePARENT[childrenEntity])
	{
		new oldParent = entityPARENT[childrenEntity];
		if(oldParent != NULLENT)
		{
			new arrayIndex;
			if((arrayIndex = ArrayFindValue(entityCHILDRENS[oldParent], childrenEntity)) != -1)
			{
				ArrayDeleteItem(entityCHILDRENS[oldParent], arrayIndex);
				entityTotalCHILDRENS[oldParent]--;
			}
		}
	}

	bEntityHavePARENT[childrenEntity] = true;
	entityPARENT[childrenEntity] = parentEntity;

	if(ArrayFindValue(entityCHILDRENS[parentEntity], childrenEntity) == -1)
	{
		ArrayPushCell(entityCHILDRENS[parentEntity], childrenEntity);
		entityTotalCHILDRENS[parentEntity]++;
	}
}

public Entity_Will_Remove_NewRound(const entityIndex, const bool:bSet) 
{
	if(bSet)
	{
		if(ArrayFindValue(Array_entitiesWillREMOVE, entityIndex) == -1)
			ArrayPushCell(Array_entitiesWillREMOVE, entityIndex);

		entityWillREMOVE[entityIndex] = true;
	} else {
		new arrayIndex;
		if((arrayIndex = ArrayFindValue(Array_entitiesWillREMOVE, entityIndex)) != -1)
			ArrayDeleteItem(Array_entitiesWillREMOVE, arrayIndex);

		entityWillREMOVE[entityIndex] = false;
	}
}

public Item_Menu(const clientIndex)
{
	if(!(get_user_flags(clientIndex) & ADMIN_RCON))
	{
		return;
	}
	if(playerUsingMenu != clientIndex && playerUsingMenu != NULLENT)
		return;

	if(playerUsingMenu == NULLENT)
	{
		playerUsingMenu = clientIndex;
		closestPoint = NULLENT;

		remove_task(clientIndex+TASK_CONFIG_MENU, 1);
		new params[1]; params[0] = clientIndex;
		Task_Show_Menu_Points(params, clientIndex+TASK_CONFIG_MENU);
	}
	
	bSearchPoint = true;

	new menuITEM[64]; formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_TITLE_ITEM_CONFIG"); 
	new menu = menu_create(menuITEM, "itemMenu_Handler");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_CHOOSE_PUT_ITEM"); 
	menu_additem(menu, menuITEM, "0");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_CHOOSE_EDIT_ITEM"); 
	menu_additem(menu, menuITEM, "1");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_CHOOSE_SAVE_ITEM"); 
	menu_additem(menu, menuITEM, "2");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_CHOOSE_RETURN_BACK_ORIGINAL"); 
	menu_additem(menu, menuITEM, "3");

	menu_setprop(menu, MPROP_EXITNAME, fmt("\w%L", clientIndex, "EXIT_MENU"));
	menu_display(clientIndex, menu, 0);	
}

public Task_Show_Menu_Points(params[], taskid)
{
	new clientIndex = params[0]; 

	new param[1]; param[0] = clientIndex;
	set_task(0.1, "Task_Show_Menu_Points", clientIndex+TASK_CONFIG_MENU, param, sizeof(param));

	new Float:vOrigin[3], Float:vAngle[3], pointType, Float:boxDISTANCE;
	if(bSearchPoint)
	{
		new Float:vPlayerOrigin[3], Float:fDistance, Float:fMinDistance = -1.0;
		get_entvar(clientIndex, var_origin, vPlayerOrigin);

		for(new arrayIndex = ArraySize(Array_itemTYPE_Menu)-1; arrayIndex >= 0; arrayIndex--)
		{
			ArrayGetArray(Array_itemORIGIN_Menu, arrayIndex, vOrigin, 3);
			fDistance = get_distance_f(vOrigin, vPlayerOrigin);
			if(fMinDistance == -1.0 || fMinDistance > fDistance)
			{
				closestPoint = arrayIndex;
				fMinDistance = fDistance;
			}
		}
	}

	new Float:vTarget[3], Float:vMins[3], Float:vMaxs[3], Color[3];
	for(new arrayIndex = ArraySize(Array_itemTYPE_Menu)-1; arrayIndex >= 0; arrayIndex--)
	{
		ArrayGetArray(Array_itemORIGIN_Menu, arrayIndex, vOrigin, 3);
		pointType = ArrayGetCell(Array_itemTYPE_Menu, arrayIndex);
		if(pointType == POINT_TYPE_ATTACKER_POINT || pointType == POINT_TYPE_DEFENDER_POINT || pointType == POINT_TYPE_BOT_FOLLOW) vOrigin[2] -= 36.0;

		if((vAngle[1] = float(ArrayGetCell(Array_itemANGLEY_Menu, arrayIndex))) == 1.0) vAngle[1] = 0.0;
	
		boxDISTANCE = float(ArrayGetCell(Array_boxDISTANCE_Menu, arrayIndex));

		vMins = vOrigin;
		vMaxs = vOrigin;

		if(arrayIndex == closestPoint)
		{
			Color[0] = 255;
			Color[1] = 0;
			Color[2] = 0;

			client_print(clientIndex, print_center, "%L", clientIndex, ItemLANG[pointType-1]);
			if(pointType == POINT_TYPE_INVISIBLE_WALL || pointType == POINT_TYPE_ATTACKER_ENERGY_BARRIER || pointType == POINT_TYPE_DEFENDER_ENERGY_BARRIER)
			{
				if(vAngle[1] == 0.0 || vAngle[1] == 180.0) {
					vMins[1] -= boxDISTANCE;
					vMaxs[1] += boxDISTANCE;

					vMins[0] -= 5.0;
					vMaxs[0] += 5.0;
				} else if(vAngle[1] == 90.0 || vAngle[1] == 270.0) {
					vMins[0] -= boxDISTANCE;
					vMaxs[0] += boxDISTANCE;

					vMins[1] -= 5.0;
					vMaxs[1] += 5.0;
				}

				vMaxs[2] += boxDISTANCE*2.0;
			} else if(pointType == POINT_TYPE_ATTACKER_POINT || pointType == POINT_TYPE_DEFENDER_POINT || pointType == POINT_TYPE_BOT_FOLLOW) {
				vMins[0] -= 16.0;
				vMins[1] -= 16.0;

				vMaxs[0] += 16.0;
				vMaxs[1] += 16.0;
				vMaxs[2] += boxDISTANCE;
			} else {
				vMins[0] -= boxDISTANCE;
				vMins[1] -= boxDISTANCE;

				vMaxs[0] += boxDISTANCE;
				vMaxs[1] += boxDISTANCE;
				vMaxs[2] += boxDISTANCE;
			}
		} else {
			switch(pointType)
			{
				case POINT_TYPE_INVISIBLE_WALL:
				{
					Color[0] = 255;
					Color[1] = 255;
					Color[2] = 255;
				}
				case POINT_TYPE_ATTACKER_ENERGY_BARRIER:
				{
					Color[0] = 42;
					Color[1] = 212;
					Color[2] = 255;
				}
				case POINT_TYPE_DEFENDER_ENERGY_BARRIER:
				{
					Color[0] = 42;
					Color[1] = 212;
					Color[2] = 255;
				}
				case POINT_TYPE_WEAPON_POINT:
				{
					Color[0] = 255;
					Color[1] = 0;
					Color[2] = 255;
				}
				case POINT_TYPE_HEALTH_POINT:
				{
					Color[0] = 42;
					Color[1] = 255;
					Color[2] = 42;
				}
				case POINT_TYPE_SPEED_POINT:
				{
					Color[0] = 255;
					Color[1] = 255;
					Color[2] = 0;
				}
				case POINT_TYPE_ATTACKER_POINT:
				{
					Color[0] = 255;
					Color[1] = 155;
					Color[2] = 0;
				}
				case POINT_TYPE_DEFENDER_POINT:
				{
					Color[0] = 0;
					Color[1] = 0;
					Color[2] = 255;
				}
				case POINT_TYPE_BOT_FOLLOW:
				{
					Color[0] = 0;
					Color[1] = 255;
					Color[2] = 255;
				}
			}
		}

		vAngle[1] -= 180.0;
		GetPosition(0, pointType == POINT_TYPE_INVISIBLE_WALL || pointType == POINT_TYPE_ATTACKER_ENERGY_BARRIER || pointType == POINT_TYPE_DEFENDER_ENERGY_BARRIER ? 50.0 : boxDISTANCE, 0.0, boxDISTANCE*0.5, vTarget, vAngle, true, vOrigin, true);
		draw_line(Color[0], Color[1], Color[2], vOrigin[0], vOrigin[1], vOrigin[2] + (boxDISTANCE*0.5), vTarget[0], vTarget[1], vTarget[2], true);

		if(arrayIndex == closestPoint)
		{
			draw_line(Color[0], Color[1], Color[2], vMaxs[0], vMaxs[1], vMaxs[2], vMins[0], vMaxs[1], vMaxs[2]);
			draw_line(Color[0], Color[1], Color[2], vMaxs[0], vMaxs[1], vMaxs[2], vMaxs[0], vMins[1], vMaxs[2]);
			draw_line(Color[0], Color[1], Color[2], vMaxs[0], vMaxs[1], vMaxs[2], vMaxs[0], vMaxs[1], vMins[2]);
			draw_line(Color[0], Color[1], Color[2], vMins[0], vMins[1], vMins[2], vMaxs[0], vMins[1], vMins[2]);
			draw_line(Color[0], Color[1], Color[2], vMins[0], vMins[1], vMins[2], vMins[0], vMaxs[1], vMins[2]);
			draw_line(Color[0], Color[1], Color[2], vMins[0], vMins[1], vMins[2], vMins[0], vMins[1], vMaxs[2]);
			draw_line(Color[0], Color[1], Color[2], vMins[0], vMaxs[1], vMaxs[2], vMins[0], vMaxs[1], vMins[2]);
			draw_line(Color[0], Color[1], Color[2], vMins[0], vMaxs[1], vMins[2], vMaxs[0], vMaxs[1], vMins[2]);
			draw_line(Color[0], Color[1], Color[2], vMaxs[0], vMaxs[1], vMins[2], vMaxs[0], vMins[1], vMins[2]);
			draw_line(Color[0], Color[1], Color[2], vMaxs[0], vMins[1], vMins[2], vMaxs[0], vMins[1], vMaxs[2]);
			draw_line(Color[0], Color[1], Color[2], vMaxs[0], vMins[1], vMaxs[2], vMins[0], vMins[1], vMaxs[2]);
			draw_line(Color[0], Color[1], Color[2], vMins[0], vMins[1], vMaxs[2], vMins[0], vMaxs[1], vMaxs[2]);
		}
	}
}

public itemMenu_Handler(const clientIndex, const iMenu, const item)
{
	if(playerUsingMenu != clientIndex) 
	{
		remove_task(clientIndex+TASK_CONFIG_MENU, 1);
		menu_destroy(iMenu);
		return;
	}

	if(item == MENU_EXIT)
	{
		playerUsingMenu = NULLENT;
		remove_task(clientIndex+TASK_CONFIG_MENU, 1);
		menu_destroy(iMenu);
		return;
	}
	
	switch(item)
	{
		case 0:
		{
			AddItem_Menu(clientIndex);
		}
		case 1:
		{
			if(closestPoint != NULLENT)
			{
				bSearchPoint = false;
				EditItem_Menu(clientIndex);
			} else {
				Item_Menu(clientIndex);
			}
		}
		case 2:
		{
			playerUsingMenu = NULLENT;
			remove_task(clientIndex+TASK_CONFIG_MENU, 1);
			Save_MapItems();
			Load_MapItems();
		}
		case 3:
		{
			Load_MapItems();

			closestPoint = NULLENT;
			remove_task(clientIndex+TASK_CONFIG_MENU, 1);
			new params[1]; params[0] = clientIndex;
			Task_Show_Menu_Points(params, clientIndex+TASK_CONFIG_MENU);
			Item_Menu(clientIndex);
		}
	}
	menu_destroy(iMenu);
}

stock AddItem_Menu(clientIndex, menuPages = 0)
{
	new menuITEM[64]; formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_TITLE_ADD_ITEM"); 
	new menu = menu_create(menuITEM, "itemAddMenu_Handler");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_ITEM_GO_BACK"); 
	menu_additem(menu, menuITEM, "0");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_ITEM_INVISIBLE_WALL"); 
	menu_additem(menu, menuITEM, "1");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_ITEM_ATTACKER_ENERGY_BARRIER"); 
	menu_additem(menu, menuITEM, "2");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_ITEM_DEFENDER_ENERGY_BARRIER"); 
	menu_additem(menu, menuITEM, "3");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_ITEM_WEAPON_POINT"); 
	menu_additem(menu, menuITEM, "4");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_ITEM_HEALTH_POINT"); 
	menu_additem(menu, menuITEM, "5");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_ITEM_SPEED_POINT"); 
	menu_additem(menu, menuITEM, "6");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_ITEM_ATTACKER_POINT"); 
	menu_additem(menu, menuITEM, "7");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_ITEM_DEFENDER_POINT"); 
	menu_additem(menu, menuITEM, "8");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_ITEM_BOT_FOLLOW"); 
	menu_additem(menu, menuITEM, "9");

	menu_setprop(menu, MPROP_EXIT, MEXIT_NEVER);
	menu_display(clientIndex, menu, menuPages);	
}

public itemAddMenu_Handler(const clientIndex, const iMenu, const item)
{
	if(playerUsingMenu != clientIndex) 
	{
		remove_task(clientIndex+TASK_CONFIG_MENU, 1);
		menu_destroy(iMenu);
		return;
	}

	if(item == MENU_EXIT)
	{
		playerUsingMenu = NULLENT;
		remove_task(clientIndex+TASK_CONFIG_MENU, 1);
		menu_destroy(iMenu);
		return;
	}

	switch(item)
	{
		case 0:
		{
			Item_Menu(clientIndex);
		}
		default:
		{
			new Float:vOrigin[3], Float:vAngle[3]; get_entvar(clientIndex, var_origin, vOrigin);
			if(get_entvar(clientIndex, var_flags) & FL_DUCKING) vOrigin[2] -= 18.0;
			else vOrigin[2] -= 36.0;
			get_entvar(clientIndex, var_v_angle, vAngle);

			vAngle[1] += 180.0;
			new output;
			for(new multiplier = 0, value1 = floatround(vAngle[1]), value2, value3, value4 = -1; multiplier <= 4; multiplier++)
			{
				value2 = multiplier*90;
				value3 = abs(value1 - value2);
				if(value4 == -1 || value4 > value3)
				{
					value4 = value3;
					if(multiplier == 4) output = 0;
					else output = multiplier;
				}
			}

			new boxDISTANCE;
			switch(item)
			{
				case POINT_TYPE_INVISIBLE_WALL: boxDISTANCE = 50;
				case POINT_TYPE_ATTACKER_ENERGY_BARRIER, POINT_TYPE_DEFENDER_ENERGY_BARRIER: boxDISTANCE = 50;
				case POINT_TYPE_WEAPON_POINT: boxDISTANCE = 8;
				case POINT_TYPE_HEALTH_POINT: boxDISTANCE = 8;
				case POINT_TYPE_SPEED_POINT: boxDISTANCE = 8;
				case POINT_TYPE_ATTACKER_POINT: boxDISTANCE = 72, vOrigin[2] += 36.0;
				case POINT_TYPE_DEFENDER_POINT: boxDISTANCE = 72, vOrigin[2] += 36.0;
				case POINT_TYPE_BOT_FOLLOW: boxDISTANCE = 72, vOrigin[2] += 36.0;
			} 

			output *= 90;
			ArrayPushArray(Array_itemORIGIN_Menu, vOrigin);
			ArrayPushCell(Array_itemANGLEY_Menu, output == 0 ? 1 : output);
			ArrayPushCell(Array_itemTYPE_Menu, item);


			ArrayPushCell(Array_boxDISTANCE_Menu, boxDISTANCE);

			closestPoint = NULLENT;
			remove_task(clientIndex+TASK_CONFIG_MENU, 1);
			new params[1]; params[0] = clientIndex;
			Task_Show_Menu_Points(params, clientIndex+TASK_CONFIG_MENU);
			AddItem_Menu(clientIndex, item <= 6 ? 0 : (item / 7));
		}
	}

	menu_destroy(iMenu);
}

public EditItem_Menu(clientIndex)
{
	new menuITEM[64]; formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_TITLE_EDIT_ITEM"); 
	new menu = menu_create(menuITEM, "itemEditMenu_Handler");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_ITEM_GO_BACK"); 
	menu_additem(menu, menuITEM, "0");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_EDIT_ITEM_CHANGE_ORIGIN"); 
	menu_additem(menu, menuITEM, "1");

	formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_EDIT_ITEM_DELETE"); 
	menu_additem(menu, menuITEM, "2");

	if(closestPoint != NULLENT)
	{
		new pointType = ArrayGetCell(Array_itemTYPE_Menu, closestPoint);
		if(pointType == POINT_TYPE_INVISIBLE_WALL || pointType == POINT_TYPE_ATTACKER_ENERGY_BARRIER || pointType == POINT_TYPE_DEFENDER_ENERGY_BARRIER)
		{
			formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_EDIT_ITEM_INCREASE_SCALE"); 
			menu_additem(menu, menuITEM, "3");

			formatex(menuITEM, charsmax(menuITEM), "%L", clientIndex, "MENU_EDIT_ITEM_DECREASE_SCALE"); 
			menu_additem(menu, menuITEM, "4");
		}
	}
	menu_setprop(menu, MPROP_EXIT, MEXIT_NEVER);
	menu_display(clientIndex, menu, 0);	
}

public itemEditMenu_Handler(const clientIndex, const iMenu, const item)
{
	if(playerUsingMenu != clientIndex) 
	{
		remove_task(clientIndex+TASK_CONFIG_MENU, 1);
		menu_destroy(iMenu);
		return;
	}

	if(item == MENU_EXIT)
	{
		playerUsingMenu = NULLENT;
		remove_task(clientIndex+TASK_CONFIG_MENU, 1);
		menu_destroy(iMenu);
		return;
	}

	switch(item)
	{
		case 0:
		{
			bSearchPoint = true;
			Item_Menu(clientIndex);
		}
		case 1:
		{
			if(closestPoint != NULLENT)
			{
				new Float:vOrigin[3], Float:vAngle[3]; get_entvar(clientIndex, var_origin, vOrigin);
				if(get_entvar(clientIndex, var_flags) & FL_DUCKING) vOrigin[2] -= 18.0;
				else vOrigin[2] -= 36.0;
				get_entvar(clientIndex, var_v_angle, vAngle);

				vAngle[1] += 180.0;
				new output;
				for(new multiplier = 0, value1 = floatround(vAngle[1]), value2, value3, value4 = -1; multiplier <= 4; multiplier++)
				{
					value2 = multiplier*90;
					value3 = abs(value1 - value2);
					if(value4 == -1 || value4 > value3)
					{
						value4 = value3;
						if(multiplier == 4) output = 0;
						else output = multiplier;
					}
				}

				if(ArrayGetCell(Array_itemTYPE_Menu, closestPoint) == POINT_TYPE_DEFENDER_POINT || ArrayGetCell(Array_itemTYPE_Menu, closestPoint) == POINT_TYPE_ATTACKER_POINT || ArrayGetCell(Array_itemTYPE_Menu, closestPoint) == POINT_TYPE_BOT_FOLLOW)
				{
					vOrigin[2] += 36.0;
				}

				output *= 90;
				ArraySetArray(Array_itemORIGIN_Menu, closestPoint, vOrigin);
				ArraySetCell(Array_itemANGLEY_Menu, closestPoint, output == 0 ? 1 : output);

				remove_task(clientIndex+TASK_CONFIG_MENU, 1);
				new params[1]; params[0] = clientIndex;
				Task_Show_Menu_Points(params, clientIndex+TASK_CONFIG_MENU);

				EditItem_Menu(clientIndex);
			} else {
				bSearchPoint = true;
				Item_Menu(clientIndex);
			}
		}
		case 2:
		{
			bSearchPoint = true;
			if(closestPoint != NULLENT)
			{
				ArrayDeleteItem(Array_itemORIGIN_Menu, closestPoint);
				ArrayDeleteItem(Array_itemANGLEY_Menu, closestPoint);
				ArrayDeleteItem(Array_itemTYPE_Menu, closestPoint);
				ArrayDeleteItem(Array_boxDISTANCE_Menu, closestPoint);

				closestPoint = NULLENT;

				remove_task(clientIndex+TASK_CONFIG_MENU, 1);
				new params[1]; params[0] = clientIndex;
				Task_Show_Menu_Points(params, clientIndex+TASK_CONFIG_MENU);
			} 
			
			Item_Menu(clientIndex);
		}
		case 3, 4:
		{
			if(closestPoint != NULLENT)
			{
				new boxDISTANCE = ArrayGetCell(Array_boxDISTANCE_Menu, closestPoint);
				if(item == 4) boxDISTANCE -= 10, boxDISTANCE = max(10, boxDISTANCE);
				else boxDISTANCE += 10;
				ArraySetCell(Array_boxDISTANCE_Menu, closestPoint, boxDISTANCE);

				remove_task(clientIndex+TASK_CONFIG_MENU, 1);
				new params[1]; params[0] = clientIndex;
				Task_Show_Menu_Points(params, clientIndex+TASK_CONFIG_MENU);

				EditItem_Menu(clientIndex);
			} else {
				bSearchPoint = true;
				Item_Menu(clientIndex);
			}
		}
	}

	menu_destroy(iMenu);
}

Load_MapItems()
{
	new bool:bScratch;
	if(!strlen(szFilepath))
	{
		new cfgdir[32], mapname[32];
		get_configsdir(cfgdir, charsmax(cfgdir));
		get_mapname(mapname, charsmax(mapname));
		formatex(szFilepath, charsmax(szFilepath), "%s/Jenessee_Valorant/%s.cfg", cfgdir, mapname);

		bScratch = true;
	}

	if(!file_exists(szFilepath))
		return;
	
	ArrayClear(Array_itemORIGIN_Menu);
	ArrayClear(Array_itemANGLEY_Menu);
	ArrayClear(Array_itemTYPE_Menu);
	ArrayClear(Array_boxDISTANCE_Menu);

	new linedata[64];
	new Float:vOrigin[3], data[7][6], file = fopen(szFilepath, "rt");
	while (file && !feof(file))
	{
		fgets(file, linedata, charsmax(linedata));

		if(!linedata[0] || str_count(linedata, ' ') < 2) continue;
		
		parse(linedata, data[0], 5, data[1], 5, data[2], 5, data[3], 5, data[4], 5, data[5], 5);
		
		vOrigin[0] = floatstr(data[0]);
		vOrigin[1] = floatstr(data[1]);
		vOrigin[2] = floatstr(data[2]);

		if(vOrigin[0] == 0.0 && vOrigin[1] == 0.0 && vOrigin[2] == 0.0)
			continue;

		if(bScratch) 
		{
			ArrayPushArray(Array_itemORIGIN, vOrigin);
			ArrayPushCell(Array_itemANGLEY, str_to_num(data[3]));
			ArrayPushCell(Array_itemTYPE, str_to_num(data[4]));
			ArrayPushCell(Array_boxDISTANCE, str_to_num(data[5]));

			switch(str_to_num(data[4]))
			{
				case POINT_TYPE_ATTACKER_POINT:
				{
					ArrayPushArray(Array_attackerSpawnOrigin, vOrigin);
					ArrayPushCell(Array_attackerSpawnAngle, str_to_num(data[3]));
				}
				case POINT_TYPE_DEFENDER_POINT:
				{
					ArrayPushArray(Array_defenderSpawnOrigin, vOrigin);
					ArrayPushCell(Array_defenderSpawnAngle, str_to_num(data[3]));
				}
				case POINT_TYPE_BOT_FOLLOW:
				{
					ArrayPushArray(botFollowPoint, vOrigin);
				}
			}
		}

		ArrayPushArray(Array_itemORIGIN_Menu, vOrigin);
		ArrayPushCell(Array_itemANGLEY_Menu, str_to_num(data[3]));
		ArrayPushCell(Array_itemTYPE_Menu, str_to_num(data[4]));
		ArrayPushCell(Array_boxDISTANCE_Menu, str_to_num(data[5]));
	}

	if(file) fclose(file);
}

Save_MapItems()
{
 	if(file_exists(szFilepath)) delete_file(szFilepath);

   	new mapname[32], line[128]; get_mapname(mapname, charsmax(mapname));
   	formatex(line, charsmax(line) ,"/* originx, originy, originz, angley, pointType, boxDISTANCE */ %s", mapname);
   	write_file(szFilepath, line, -1);

	new Float:vOrigin[3];
	new arraySize = ArraySize(Array_itemTYPE_Menu);
	for(new arrayIndex = 0; arrayIndex < arraySize; arrayIndex++)
	{
		ArrayGetArray(Array_itemORIGIN_Menu, arrayIndex, vOrigin);
		if(vOrigin[0] == 0.0 && vOrigin[1] == 0.0 && vOrigin[2] == 0.0)
			continue;

		formatex(line, charsmax(line), "%d %d %d %d %d %d", floatround(vOrigin[0]), floatround(vOrigin[1]), floatround(vOrigin[2]), 
		ArrayGetCell(Array_itemANGLEY_Menu, arrayIndex), ArrayGetCell(Array_itemTYPE_Menu, arrayIndex), ArrayGetCell(Array_boxDISTANCE_Menu, arrayIndex));
		write_file(szFilepath, line, -1);
	}
}

Create_InvisibleWall(const Float:vOrigin[3], const Float:vAngle[3], const Float:vMins[3], const Float:vMaxs[3])
{
	new wallEntity = rg_create_entity("info_target");
	if(is_nullent(wallEntity))
		return NULLENT;

	set_entvar(wallEntity, var_movetype, MOVETYPE_NOCLIP);
	set_entvar(wallEntity, var_solid, SOLID_BBOX);

	set_entvar(wallEntity, var_origin, vOrigin);
	set_entvar(wallEntity, var_angles, vAngle);

	engfunc(EngFunc_SetSize, wallEntity, vMins, vMaxs);
	set_entvar(wallEntity, var_mins, vMins); 
	set_entvar(wallEntity, var_maxs, vMaxs); 
	set_entvar(wallEntity, var_absmin, vMins);
	set_entvar(wallEntity, var_absmax, vMaxs);

	Entity_Will_Remove_NewRound(wallEntity, true);
	return wallEntity;
}

Create_EnergyBarrier(Float:vOrigin[3], Float:vAngle[3], const Float:vMins[3], const Float:vMaxs[3], const entityTEAM)
{
	new barrierEntity = rg_create_entity("info_target");
	if(!is_nullent(barrierEntity))
	{
		set_entvar(barrierEntity, var_movetype, MOVETYPE_NOCLIP);
		set_entvar(barrierEntity, var_solid, SOLID_BBOX);

		set_entvar(barrierEntity, var_origin, vOrigin);
		set_entvar(barrierEntity, var_angles, vAngle);

		set_entvar(barrierEntity, var_team, entityTEAM);

		engfunc(EngFunc_SetSize, barrierEntity, vMins, vMaxs);
		set_entvar(barrierEntity, var_mins, vMins); 
		set_entvar(barrierEntity, var_maxs, vMaxs); 
		set_entvar(barrierEntity, var_absmin, vMins);
		set_entvar(barrierEntity, var_absmax, vMaxs);

		Entity_Will_Remove_NewRound(barrierEntity, true);

		if(ArrayFindValue(Array_barrierENTITIES, barrierEntity) == -1)
			ArrayPushCell(Array_barrierENTITIES, barrierEntity);

		entityBARRIER[barrierEntity] = true;

		remove_task(barrierEntity+TASK_BARRIER_LINES);
		new params[1]; params[0] = barrierEntity;
		set_task(1.0, "Task_Barrier_Lines", barrierEntity+TASK_BARRIER_LINES, params, sizeof(params), "b");
	}

	new barrierTrigger = rg_create_entity("info_target");
	if(!is_nullent(barrierTrigger))
	{
		set_entvar(barrierTrigger, var_movetype, MOVETYPE_NOCLIP);
		set_entvar(barrierTrigger, var_solid, SOLID_TRIGGER);

		set_entvar(barrierTrigger, var_origin, vOrigin);
		set_entvar(barrierTrigger, var_angles, vAngle);

		set_entvar(barrierTrigger, var_team, entityTEAM);

		engfunc(EngFunc_SetSize, barrierTrigger, vMins, vMaxs);
		set_entvar(barrierTrigger, var_mins, vMins); 
		set_entvar(barrierTrigger, var_maxs, vMaxs); 
		set_entvar(barrierTrigger, var_absmin, vMins);
		set_entvar(barrierTrigger, var_absmax, vMaxs);

		ChildrenParent_Entity(barrierEntity, barrierTrigger);

		if(ArrayFindValue(Array_barrierENTITIES, barrierTrigger) == -1)
			ArrayPushCell(Array_barrierENTITIES, barrierTrigger);

		entityBARRIER[barrierTrigger] = true;
	}

	if(strlen(spriteBarrier))
	{
		vOrigin[2] += (vMaxs[2] * 0.5);
		
		GetPosition(0, -5.0, 0.0, 0.0, vOrigin, vAngle, true, vOrigin, true);
		new barrierSprite1 = rg_create_entity("env_sprite");
		if(!is_nullent(barrierSprite1))
		{
			engfunc(EngFunc_SetModel, barrierSprite1, spriteBarrier); 

			set_entvar(barrierSprite1, var_origin, vOrigin);

			set_entvar(barrierSprite1, var_angles, vAngle);

			set_entvar(barrierSprite1, var_scale, vMaxs[2] * 0.00395);

			set_entvar(barrierSprite1, var_effects, EF_FORCEVISIBILITY);
			set_entvar(barrierSprite1, var_rendermode, kRenderTransAdd);  
			set_entvar(barrierSprite1, var_renderamt, 255.0);   

			ChildrenParent_Entity(barrierEntity, barrierSprite1);

			SetThink(barrierSprite1, "Think_Barrier_SpriteFrame");
			set_entvar(barrierSprite1, var_nextthink, get_gametime());
		}

		GetPosition(0, 10.0, 0.0, 0.0, vOrigin, vAngle, true, vOrigin, true);
		vAngle[1] += 180.0;

		new barrierSprite2 = rg_create_entity("env_sprite");
		if(!is_nullent(barrierSprite2))
		{
			engfunc(EngFunc_SetModel, barrierSprite2, spriteBarrier); 

			set_entvar(barrierSprite2, var_origin, vOrigin);

			set_entvar(barrierSprite2, var_angles, vAngle);

			set_entvar(barrierSprite2, var_scale, vMaxs[2] * 0.00395);

			set_entvar(barrierSprite2, var_effects, EF_FORCEVISIBILITY);

			ChildrenParent_Entity(barrierEntity, barrierSprite2);

			SetThink(barrierSprite2, "Think_Barrier_SpriteFrame");
			set_entvar(barrierSprite2, var_nextthink, get_gametime());
		}
	}
}

public Touch_PlayerToBarrier(const barrierEntity, const clientIndex)
{
	if(!is_user_alive(clientIndex))
		return;
	if(get_entvar(barrierEntity, var_team) == playerTEAM[clientIndex])
	{
		new param[2];
		param[0] = barrierEntity;
		param[1] = clientIndex;
		remove_task(clientIndex+TASK_PLAYER_PUSH);
		set_task(0.1, "Task_Barrier_Out", clientIndex+TASK_PLAYER_PUSH, param, sizeof(param));

		if(is_user_bot(clientIndex))
		{
			if(!playerInBASE[clientIndex])
				return;
		}
	}

	static bCheckMap;
	if(!bCheckMap)
	{
		new szMapName[32]; get_mapname(szMapName, 31);
		if(contain(szMapName, "dm_industry2") >= 0 || contain(szMapName, "dm_gallery") >= 0) bCheckMap = 1;
		else bCheckMap = 2;
	}

	static Float:vTargetOrigin[3], Float:vVictimOrigin[3], Float:vOrigin2[3], Float:vOrigin[3], Float:vAngles[3]; 

	if(bCheckMap == 2) get_entvar(barrierEntity, var_origin, vOrigin), get_entvar(clientIndex, var_origin, vOrigin2);
	else get_entvar(clientIndex, var_origin, vOrigin), vOrigin2 = vOrigin;

	get_entvar(barrierEntity, var_angles, vAngles);

	GetPosition(0, 100.0, 0.0, 0.0, vTargetOrigin, vAngles, true, vOrigin, true);
	
	if(get_entvar(barrierEntity, var_team) == playerTEAM[clientIndex])
	{
		HookEnt(clientIndex, vTargetOrigin, 250.0, false);

		switch(playerTEAM[clientIndex])
		{
			case TEAM_DEFENDERS:
			{
				for(new arrayIndex = ArraySize(Array_playerATTACKERS)-1, playerIndex; arrayIndex >= 0; arrayIndex--)
				{
					playerIndex = ArrayGetCell(Array_playerATTACKERS, arrayIndex);
					get_entvar(playerIndex, var_origin, vVictimOrigin);

					if(get_distance_f(vVictimOrigin, vOrigin2) <= 50.0)
					{
						HookEnt(playerIndex, vTargetOrigin, 400.0, false);
					}
				}
			}
			case TEAM_ATTACKERS:
			{
				for(new arrayIndex = ArraySize(Array_playerDEFENDERS)-1, playerIndex; arrayIndex >= 0; arrayIndex--)
				{
					playerIndex = ArrayGetCell(Array_playerDEFENDERS, arrayIndex);
					get_entvar(playerIndex, var_origin, vVictimOrigin);

					if(get_distance_f(vVictimOrigin, vOrigin2) <= 50.0)
					{
						HookEnt(playerIndex, vTargetOrigin, 400.0, false);
					}
				}
			}
		}

	} else HookEnt(clientIndex, vTargetOrigin, 400.0, false);
}

public Task_Barrier_Out(params[], clientIndex)
{
	new clientIndex = params[1]; 
	new barrierEntity = params[0];
	if(is_nullent(barrierEntity))
		return;

	static Float:vTargetOrigin[3], Float:vBarrierOrigin[3], Float:vOrigin[3], Float:vAngles[3], Float:Distance_Forward; 
	get_entvar(clientIndex, var_origin, vOrigin);
	get_entvar(barrierEntity, var_origin, vBarrierOrigin);
	get_entvar(barrierEntity, var_angles, vAngles);

	GetPosition(0, 100.0, 0.0, 0.0, vTargetOrigin, vAngles, true, vBarrierOrigin, true);
	
	Distance_Forward = get_distance_f(vOrigin, vTargetOrigin);

	GetPosition(0, -100.0, 0.0, 0.0, vTargetOrigin, vAngles, true, vBarrierOrigin, true);
	if(get_distance_f(vOrigin, vTargetOrigin) > Distance_Forward)
	{
		if(task_exists(clientIndex+TASK_PLAYER_IMMORTAL, 1))
		{
			playerDECAY[clientIndex] = false;

			rh_emit_sound(clientIndex, clientIndex, CHAN_ITEM, "common/null.wav", VOL_NORM, ATTN_NORM, SND_STOP, PITCH_NORM, SND_EMIT2_NOPAS);
			if(strlen(barrierQuitSound)) rh_emit_sound(clientIndex, 0, CHAN_ITEM, barrierQuitSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			
			playerInBASE[clientIndex] = false;
			new params[1]; params[0] = clientIndex;
			Task_Immortal_End(params, clientIndex+TASK_PLAYER_IMMORTAL);
		}
	}
}

public Think_Barrier_SpriteFrame(const spriteEntity)
{
	static Float:Frame; Frame = get_entvar(spriteEntity, var_frame);
	if((Frame += 1.0) > 29.0) 
	{
		Frame = 0.0;
	} 
	set_entvar(spriteEntity, var_frame, Frame);
	set_entvar(spriteEntity, var_nextthink, get_gametime() + 0.035);
}

public Task_Barrier_Lines(params[], taskid)
{
	new barrierEntity = params[0];

	if(!get_member_game(m_bFreezePeriod) && strlen(barrierLoopSound)) 
	{
		rh_emit_sound(barrierEntity, 0, CHAN_STATIC, barrierLoopSound, 0.2, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	}

	/*static Float:vOrigin[3], Float:vMins[3], Float:vMaxs[3];
	get_entvar(barrierEntity, var_origin, vOrigin); 
	get_entvar(barrierEntity, var_mins, vMins); 
	get_entvar(barrierEntity, var_maxs, vMaxs); 

	xs_vec_add(vMins, vOrigin, vMins);
	xs_vec_add(vMaxs, vOrigin, vMaxs);

	draw_line_barrier(42, 212, 255, vMaxs[0], vMaxs[1], vMaxs[2], vMins[0], vMaxs[1], vMaxs[2], 10, 11);
	draw_line_barrier(42, 212, 255, vMaxs[0], vMaxs[1], vMaxs[2], vMaxs[0], vMins[1], vMaxs[2], 10, 11);
	draw_line_barrier(42, 212, 255, vMaxs[0], vMaxs[1], vMaxs[2], vMaxs[0], vMaxs[1], vMins[2], 10, 11);
	draw_line_barrier(42, 212, 255, vMins[0], vMins[1], vMins[2], vMaxs[0], vMins[1], vMins[2], 10, 11);
	draw_line_barrier(42, 212, 255, vMins[0], vMins[1], vMins[2], vMins[0], vMaxs[1], vMins[2], 10, 11);
	draw_line_barrier(42, 212, 255, vMins[0], vMins[1], vMins[2], vMins[0], vMins[1], vMaxs[2], 10, 11);
	draw_line_barrier(42, 212, 255, vMins[0], vMaxs[1], vMaxs[2], vMins[0], vMaxs[1], vMins[2], 10, 11);
	draw_line_barrier(42, 212, 255, vMins[0], vMaxs[1], vMins[2], vMaxs[0], vMaxs[1], vMins[2], 10, 11);
	draw_line_barrier(42, 212, 255, vMaxs[0], vMaxs[1], vMins[2], vMaxs[0], vMins[1], vMins[2], 10, 11);
	draw_line_barrier(42, 212, 255, vMaxs[0], vMins[1], vMins[2], vMaxs[0], vMins[1], vMaxs[2], 10, 11);
	draw_line_barrier(42, 212, 255, vMaxs[0], vMins[1], vMaxs[2], vMins[0], vMins[1], vMaxs[2], 10, 11);
	draw_line_barrier(42, 212, 255, vMins[0], vMins[1], vMaxs[2], vMins[0], vMaxs[1], vMaxs[2], 10, 11);*/
}

stock str_count(const str[], searchchar)
{
	new count, i, len = strlen(str)
	
	for (i = 0; i <= len; i++)
	{
		if(str[i] == searchchar)
			count++
	}
	
	return count;
}

draw_line(const colorR, const colorG, const colorB, const Float:originx, const Float:originy, const Float:originz, const Float:origin2x, const Float:origin2y, const Float:origin2z, bool:bAngleBeam = false)
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(TE_BEAMPOINTS);
	write_coord_f(originx);
	write_coord_f(originy);
	write_coord_f(originz);
	write_coord_f(origin2x);
	write_coord_f(origin2y);
	write_coord_f(origin2z);
	write_short(laserBeam);
	write_byte(0);
	write_byte(0);
	write_byte(2);
	write_byte(bAngleBeam ? 15 : 5);
	write_byte(0);
	write_byte(colorR);
	write_byte(colorG);
	write_byte(colorB);
	write_byte(255);
	write_byte(0);
	message_end();
}

GetPosition(const entityIndex, const Float:fForwardAdd, const Float:fRightAdd, const Float:fUpAdd, Float:vPosition[3], const Float:vCustomAngle[3], const bool:WorkCustomAngle, const Float:vCustomOrigin[3], const bool:WorkCustomOrigin)
{
	static Float:vEntityAngle[3], Float:vForward[3], Float:vRight[3], Float:vUp[3];
	
	if(WorkCustomOrigin) {
		vPosition = vCustomOrigin;
	} else {
		get_entvar(entityIndex, var_origin, vPosition);
		get_entvar(entityIndex, var_view_ofs, vUp);
		xs_vec_add(vPosition, vUp, vPosition);
	}
	
	if(!WorkCustomAngle)
	{
		if(entityIndex > MAX_PLAYERS) get_entvar(entityIndex, var_angles, vEntityAngle);
		else get_entvar(entityIndex, var_v_angle, vEntityAngle);
	} else {
		vEntityAngle = vCustomAngle;
	}

	if(fForwardAdd != 0.0) angle_vector(vEntityAngle, ANGLEVECTOR_FORWARD, vForward);
	if(fRightAdd != 0.0) angle_vector(vEntityAngle, ANGLEVECTOR_RIGHT, vRight);
	if(fUpAdd != 0.0) angle_vector(vEntityAngle, ANGLEVECTOR_UP, vUp);
	
	vPosition[0] += vForward[0] * fForwardAdd + vRight[0] * fRightAdd + vUp[0] * fUpAdd;
	vPosition[1] += vForward[1] * fForwardAdd + vRight[1] * fRightAdd + vUp[1] * fUpAdd;
	vPosition[2] += vForward[2] * fForwardAdd + vRight[2] * fRightAdd + vUp[2] * fUpAdd;
}    

Play_Animation(const entityIndex, const animName[], Float:frameRate)
{
	static AnimNum, Float:FrameRate, Float:GroundSpeed, bool:Loops
	if ((AnimNum = lookup_sequence(entityIndex, animName, FrameRate, Loops, GroundSpeed)) == -1) AnimNum = 0

	set_entvar(entityIndex, var_animtime, get_gametime());
	set_entvar(entityIndex, var_frame, 0.0);
	set_entvar(entityIndex, var_framerate, frameRate);
	set_entvar(entityIndex, var_sequence, AnimNum);

	return AnimNum;
}  
/*
draw_line_barrier(const colorR, const colorG, const colorB, const Float:originx, const Float:originy, const Float:originz, const Float:origin2x, const Float:origin2y, const Float:origin2z, const scale, const life)
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(TE_BEAMPOINTS);
	write_coord_f(originx);
	write_coord_f(originy);
	write_coord_f(originz);
	write_coord_f(origin2x);
	write_coord_f(origin2y);
	write_coord_f(origin2z);
	write_short(laserBeam);
	write_byte(0);
	write_byte(0);
	write_byte(life);
	write_byte(scale);
	write_byte(2);
	write_byte(colorR);
	write_byte(colorG);
	write_byte(colorB);
	write_byte(255);
	write_byte(0);
	message_end();
}*/

HookEnt(const clientIndex, const Float:vTargetOrigin[3], Float:fSpeed, bool:zSpeed)
{
	static Float:vOrigin[3];
	static Float:vVelocity[3];

	get_entvar(clientIndex, var_velocity, vVelocity);
	get_entvar(clientIndex, var_origin, vOrigin);

	static Float:fDistance; fDistance = get_distance_f(vOrigin, vTargetOrigin);
	static Float:fTime; fTime = fDistance / fSpeed;

	vVelocity[0] = (vTargetOrigin[0] - vOrigin[0]) / fTime;
	vVelocity[1] = (vTargetOrigin[1] - vOrigin[1]) / fTime;
	if(zSpeed) 
	{
		vVelocity[2] = (vTargetOrigin[2] - vOrigin[2]) / fTime;
	}

	set_entvar(clientIndex, var_velocity, vVelocity);
}    

UTIL_RemoveEntity(const entityIndex, const Float:delayTime)
{
	remove_task(entityIndex+TASK_REMOVE_ENTITY, 1);
	new params[1]; params[0] = entityIndex;
	if(delayTime > 0.0) set_task(delayTime, "Task_Remove_Entity", entityIndex+TASK_REMOVE_ENTITY, params, sizeof(params));
	else Task_Remove_Entity(params, entityIndex+TASK_REMOVE_ENTITY);
}

public Task_Remove_Entity(params[], taskid)
{
	new entityIndex = params[0];

	Log("%s/Task_Remove_Entity", PLUGIN);

	//engfunc(EngFunc_RemoveEntity, entityIndex);
	set_entvar(entityIndex, var_effects, get_entvar(entityIndex, var_effects) | EF_NODRAW);
	set_entvar(entityIndex, var_flags, FL_KILLME);
}

Create_Model_Sprite(const ownerIndex, const szModel[], Float:vEffectPosition[3], const iCode, const fadeOut, const Float:fThinkUpdate, const Float:fShowTime, const Float:fFrameRate, const iParentIndex, const Float:fUpParentPosition, const iMaxFrame, const bool:Loop, const bool:Solid)
{
	Log("%s/Create_Model_Sprite", PLUGIN);

	static bool:bSprite; bSprite = equal(szModel[strlen(szModel)-4], ".spr") ? true : false;
	new entityIndex = bSprite ? rg_create_entity("env_sprite") : rg_create_entity("info_target");
	if (!is_nullent(entityIndex))
	{
		if(fShowTime > 0.0) UTIL_RemoveEntity(entityIndex, fShowTime);

		engfunc(EngFunc_SetModel, entityIndex, szModel);  

		set_entvar(entityIndex, Solid ? var_owner2 : var_owner, ownerIndex);
		set_entvar(entityIndex, var_maxframe, iMaxFrame);

		new Float:fData[3]; 
		fData[0] = fThinkUpdate; 
		fData[1] = fFrameRate; 
		fData[2] = Loop ? 1.0 : 0.0;
		set_entvar(entityIndex, var_vuser1, fData);   

		set_entvar(entityIndex, var_rendermode, kRenderTransAdd);   
		set_entvar(entityIndex, var_renderamt, 255.0);   

		set_entvar(entityIndex, var_movetype, MOVETYPE_FLY);
		if(ownerIndex > 0) ChildrenParent_Entity(ownerIndex, entityIndex);

		if(bSprite) 
		{
			if(iCode != 0) set_entvar(entityIndex, var_effects, EF_FORCEVISIBILITY | iCode);
			else set_entvar(entityIndex, var_effects, EF_FORCEVISIBILITY);
			set_entvar(entityIndex, var_frame, 0.0);
		} else {
			set_entvar(entityIndex, var_effects, EF_FORCEVISIBILITY);
			set_entvar(entityIndex, var_code, iCode);
			if(fFrameRate > 0.0)
			{
				set_entvar(entityIndex, var_animtime, get_gametime());
				set_entvar(entityIndex, var_frame, 0.0);
				set_entvar(entityIndex, var_framerate, fFrameRate);
				set_entvar(entityIndex, var_sequence, 0);
			}
		}

		if(iParentIndex > 0) 
		{
			set_entvar(entityIndex, var_parent, iParentIndex);
			fData[0] = fUpParentPosition; 
			fData[1] = fadeOut ? 1.0 : 0.0; 
			if(ownerIndex != iParentIndex && is_user_connected(iParentIndex)) 
			{
				ChildrenParent_Entity(iParentIndex, entityIndex);
			}
			set_entvar(entityIndex, var_vuser2, fData);  
			FrameParent_Follow(entityIndex);
		} else {
			fData[1] = fadeOut ? 1.0 : 0.0; 
			set_entvar(entityIndex, var_vuser2, fData);  
			set_entvar(entityIndex, var_origin, vEffectPosition);
		}

		if(iMaxFrame > 0) 
		{
			SetThink(entityIndex, bSprite ? "SpriteFrame_Think" : "ModelFrame_Think");
			set_entvar(entityIndex, var_nextthink, get_gametime());
		}

		return entityIndex;
	} 

	return NULLENT;
}

public FrameParent_Follow(entityIndex)
{
	if(is_nullent(entityIndex))
		return;

	static iParentIndex; iParentIndex = get_entvar(entityIndex, var_parent);
	static Float:vEffectPosition[3]; get_entvar(iParentIndex, var_origin, vEffectPosition); 
	static Float:vEffectAngle[3]; get_entvar(iParentIndex, iParentIndex <= MAX_PLAYERS ? var_v_angle : var_angles, vEffectAngle); 
	vEffectAngle[0] = 0.0;
	static Float:fData[3]; get_entvar(entityIndex, var_vuser2, fData);
	vEffectPosition[2] += fData[0];
	set_entvar(entityIndex, var_angles, vEffectAngle);
	set_entvar(entityIndex, var_velocity, {0.1, 0.1, 0.1});
	set_entvar(entityIndex, var_origin, vEffectPosition);
	RequestFrame("FrameParent_Follow", entityIndex);
}

public SpriteFrame_Think(const spriteEntity)
{
	static Float:Frame, Float:fData[3], Float:fMaxFrame; 
	Frame = get_entvar(spriteEntity, var_frame);
	fMaxFrame = float(get_entvar(spriteEntity, var_maxframe));
	get_entvar(spriteEntity, var_vuser1, fData);
	if((Frame += fData[1]) > fMaxFrame) 
	{
		if(fData[2]) Frame = 0.0;
		else {
			UTIL_RemoveEntity(spriteEntity, 0.0);
			return;
		}
	} 
	set_entvar(spriteEntity, var_frame, Frame);
	set_entvar(spriteEntity, var_nextthink, get_gametime() + fData[0]);
}

public ModelFrame_Think(const entityIndex)
{
	static Float:fData[3]; get_entvar(entityIndex, var_vuser1, fData);
	static iSkin; iSkin = get_entvar(entityIndex, var_skin);

	if((iSkin += 1) > get_entvar(entityIndex, var_maxframe))
	{
		if(fData[2]) iSkin = 0;
		else {
			UTIL_RemoveEntity(entityIndex, 0.0);
			return;
		}	
	}
	set_entvar(entityIndex, var_skin, iSkin);
	set_entvar(entityIndex, var_nextthink, get_gametime() + fData[0]);
}

Create_Orb(Float:vOrigin[3], Float:vAngle[3], const Float:vMins[3], const Float:vMaxs[3], OrbType)
{
	new orbEntity = rg_create_entity("info_target");
	if(!is_nullent(orbEntity))
	{
		if(OrbType == ORBTYPE_HEAL || OrbType == ORBTYPE_SPEED) engfunc(EngFunc_SetModel, orbEntity, orbMODEL);  
		else if(OrbType == ORBTYPE_WEAPON) {
			new Array:Array_SelectedWeapons; Array_SelectedWeapons = ArrayCreate(1, 1);

			for(new index = 2; index < sizeof(Weapon_Info); index++)
			{
				if(currentSTAGE != Weapon_Info[index][WEAPON_STAGE_LEVEL])
					continue;
				if(!strlen(Weapon_Info[index][WEAPON_D_MODEL]))
					continue;

				ArrayPushCell(Array_SelectedWeapons, index);
			}
			if(ArraySize(Array_SelectedWeapons))
			{
				new randomWeapon = ArrayGetCell(Array_SelectedWeapons, random_num(0, ArraySize(Array_SelectedWeapons)-1));
				engfunc(EngFunc_SetModel, orbEntity, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Weapon_Info[randomWeapon][WEAPON_D_MODEL]));  
				set_entvar(orbEntity, var_code, randomWeapon);
			}

			ArrayClear(Array_SelectedWeapons);
			ArrayDestroy(Array_SelectedWeapons);
			
			vOrigin[2] += 19.0;
		}

		set_entvar(orbEntity, var_movetype, MOVETYPE_NOCLIP);
		set_entvar(orbEntity, var_solid, SOLID_TRIGGER);

		set_entvar(orbEntity, var_orbtype, OrbType);
	
		set_entvar(orbEntity, var_origin, vOrigin);
		set_entvar(orbEntity, var_angles, vAngle);

		engfunc(EngFunc_SetSize, orbEntity, vMins, vMaxs);
		set_entvar(orbEntity, var_mins, vMins); 
		set_entvar(orbEntity, var_maxs, vMaxs); 
		set_entvar(orbEntity, var_absmin, vMins);
		set_entvar(orbEntity, var_absmax, vMaxs);
		bEntityMap[orbEntity] = true;
		if(OrbType != ORBTYPE_WEAPON) 
		{
			set_entvar(orbEntity, var_renderfx, kRenderFxHologram);  
			Play_Animation(orbEntity, "idle", 1.0);
		} else {
			Play_Animation(orbEntity, "Jenessee", 1.0);

			if(ArrayFindValue(Array_weaponOrbENTITIES, orbEntity) == -1)
				ArrayPushCell(Array_weaponOrbENTITIES, orbEntity);

			entityWeaponORB[orbEntity] = true;
		}

		if(OrbType == ORBTYPE_HEAL) set_entvar(orbEntity, var_skin, 1);
	
		Entity_Will_Remove_NewRound(orbEntity, true);
		
		SetTouch(orbEntity, "OnPlayerTouchOrb");

		bMuteEntity[orbEntity] = true;

		switch(OrbType) 
		{
			case ORBTYPE_HEAL: if(strlen(orbHealIdleSound)) rh_emit_sound(orbEntity, 0, CHAN_ITEM, orbHealIdleSound, 0.6, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			case ORBTYPE_SPEED: if(strlen(orbSpeedIdleSound)) rh_emit_sound(orbEntity, 0, CHAN_ITEM, orbSpeedIdleSound, 0.6, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			case ORBTYPE_WEAPON: if(strlen(orbWeaponIdleSound)) rh_emit_sound(orbEntity, 0, CHAN_ITEM, orbWeaponIdleSound, 0.6, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		}
	}
	if(OrbType == ORBTYPE_WEAPON) vOrigin[2] -= 19.0;
	if(strlen(orbEFFECT))
	{
		new orbEffectENTITY = rg_create_entity("info_target");
		if(!is_nullent(orbEffectENTITY))
		{
			engfunc(EngFunc_SetModel, orbEffectENTITY, orbEFFECT);  

			set_entvar(orbEffectENTITY, var_movetype, MOVETYPE_NOCLIP);
			set_entvar(orbEffectENTITY, var_solid, SOLID_TRIGGER);

			set_entvar(orbEffectENTITY, var_origin, vOrigin);
			set_entvar(orbEffectENTITY, var_angles, vAngle);
			bEntityMap[orbEffectENTITY] = true;
			switch(OrbType) 
			{
				case ORBTYPE_HEAL: set_entvar(orbEffectENTITY, var_skin, 2);
				case ORBTYPE_SPEED: set_entvar(orbEffectENTITY, var_skin, 1);
				case ORBTYPE_WEAPON: set_entvar(orbEffectENTITY, var_skin, 0);
			}

			ChildrenParent_Entity(orbEntity, orbEffectENTITY);
			Play_Animation(orbEffectENTITY, "idle", 1.0);
		}

		new orbEffectENTITY2 = rg_create_entity("info_target");
		if(!is_nullent(orbEffectENTITY2))
		{
			engfunc(EngFunc_SetModel, orbEffectENTITY2, orbEFFECT);  

			set_entvar(orbEffectENTITY2, var_movetype, MOVETYPE_NOCLIP);
			set_entvar(orbEffectENTITY2, var_solid, SOLID_TRIGGER);

			set_entvar(orbEffectENTITY2, var_origin, vOrigin);
			set_entvar(orbEffectENTITY2, var_angles, vAngle);

			set_entvar(orbEffectENTITY2, var_body, 1);   

			set_entvar(orbEffectENTITY2, var_renderfx, kRenderFxHologram);  
			set_entvar(orbEffectENTITY2, var_rendermode, kRenderTransAdd);  
			set_entvar(orbEffectENTITY2, var_renderamt, 75.0);   
			bEntityMap[orbEffectENTITY2] = true;
			switch(OrbType) 
			{
				case ORBTYPE_HEAL: set_entvar(orbEffectENTITY2, var_skin, 2);
				case ORBTYPE_SPEED: set_entvar(orbEffectENTITY2, var_skin, 1);
				case ORBTYPE_WEAPON: set_entvar(orbEffectENTITY2, var_skin, 0);
			}

			ChildrenParent_Entity(orbEntity, orbEffectENTITY2);
			Play_Animation(orbEffectENTITY2, "idle", 1.0);
		}
	}
	
	if((OrbType == ORBTYPE_HEAL && strlen(orbFireHEALTH)) || (OrbType == ORBTYPE_SPEED && strlen(orbFireSPEED)) || (OrbType == ORBTYPE_WEAPON && strlen(weaponOrbBUTTON)))
	{
		vOrigin[2] += OrbType == ORBTYPE_WEAPON ? 35.0 : 6.0;
		new orbFireENTITY = Create_Model_Sprite(0, OrbType == ORBTYPE_HEAL ? orbFireHEALTH : OrbType == ORBTYPE_SPEED ? orbFireSPEED : weaponOrbBUTTON, vOrigin, OrbType == ORBTYPE_WEAPON ? 0 : VP_PARALLEL_ORIENTED, 0, OrbType != ORBTYPE_WEAPON ? 0.04 : 0.0, 0.0, 0.0, 0, 0.0, OrbType != ORBTYPE_WEAPON ? 14 : 0, OrbType != ORBTYPE_WEAPON ? true : false, false);
		if(orbFireENTITY != NULLENT)
		{
			bEntityMap[orbFireENTITY] = true;

			ChildrenParent_Entity(orbEntity, orbFireENTITY);
			if(OrbType != ORBTYPE_WEAPON)
			{
				set_entvar(orbFireENTITY, var_renderfx, kRenderFxHologram);  
				set_entvar(orbFireENTITY, var_renderamt, 75.0);
			} else {
				set_entvar(orbFireENTITY, var_renderfx, kRenderFxHologram);  
				set_entvar(orbFireENTITY, var_scale, 0.075);  
			}
		}
	}	
}

public OnPlayerTouchOrb(const orbEntity, const clientIndex)
{
	if(!is_user_alive(clientIndex))
		return;
	
	new orbType = get_entvar(orbEntity, var_orbtype);
	switch(orbType)
	{
		case ORBTYPE_HEAL:
		{
			if(get_entvar(clientIndex, var_max_health) <= get_entvar(clientIndex, var_health))
				return;
			
			Log("%s/OnPlayerTouchOrb Heal", PLUGIN);

			if(strlen(orbHealTakeSound))
			{
				rh_emit_sound(orbEntity, 0, CHAN_ITEM, "common/null.wav", VOL_NORM, ATTN_IDLE, SND_STOP, PITCH_NORM, SND_EMIT2_NOPAS);
				rh_emit_sound(orbEntity, 0, CHAN_ITEM, orbHealTakeSound, 0.5, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			}

			remove_task(orbEntity+TASK_ORB_COOLDOWN);
			new params[1]; params[0] = orbEntity;
			if(orbCooldownHEALTH > 0.0) set_task(orbCooldownHEALTH, "Task_Orb_Cooldown_End", orbEntity+TASK_ORB_COOLDOWN, params, sizeof(params));
			set_entvar(orbEntity, var_effects, get_entvar(orbEntity, var_effects) | EF_NODRAW);
		}
		case ORBTYPE_SPEED:
		{
			if(strlen(orbSpeedTakeSound))
			{
				rh_emit_sound(orbEntity, 0, CHAN_ITEM, "common/null.wav", VOL_NORM, ATTN_IDLE, SND_STOP, PITCH_NORM, SND_EMIT2_NOPAS);
				rh_emit_sound(orbEntity, 0, CHAN_ITEM, "common/null.wav", 0.5, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				rh_emit_sound(orbEntity, 0, CHAN_STATIC, orbSpeedTakeSound, 0.5, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			}

			Log("%s/OnPlayerTouchOrb Speed", PLUGIN);

			remove_task(orbEntity+TASK_ORB_COOLDOWN);
			new params[1]; params[0] = orbEntity;
			if(orbCooldownSPEED > 0.0) set_task(orbCooldownSPEED, "Task_Orb_Cooldown_End", orbEntity+TASK_ORB_COOLDOWN, params, sizeof(params));

			if(strlen(playerSpeedLoopSound)) 
			{
				rh_emit_sound(orbEntity, 0, CHAN_ITEM, playerSpeedLoopSound, VOL_NORM, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				set_task(orbActiveTIME_Speed, "Task_Orb_StopSound", orbEntity+TASK_ORB_COOLDOWN, params, sizeof(params));
			}
			set_entvar(orbEntity, var_effects, get_entvar(orbEntity, var_effects) | EF_NODRAW);
		}
		case ORBTYPE_WEAPON:
		{
			if(!(get_entvar(clientIndex, var_button) & IN_USE))
				return;

			Log("%s/OnPlayerTouchOrb Weapon", PLUGIN);

			if(strlen(orbWeaponTakeSound))
			{
				rh_emit_sound(orbEntity, 0, CHAN_ITEM, "common/null.wav", VOL_NORM, ATTN_IDLE, SND_STOP, PITCH_NORM, SND_EMIT2_NOPAS);
				rh_emit_sound(orbEntity, 0, CHAN_ITEM, "common/null.wav", VOL_NORM, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				rh_emit_sound(orbEntity, 0, CHAN_STATIC, orbWeaponTakeSound, 0.5, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			}

			if(strlen(orbWeaponChargeSound)) 
			{
				rh_emit_sound(orbEntity, 0, CHAN_ITEM, orbWeaponChargeSound, 0.5, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			}

			new weaponID = get_entvar(orbEntity, var_code);
			set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 1);

			new Array:Array_SelectedWeapons; Array_SelectedWeapons = ArrayCreate(1, 1);
			for(new index = 2; index < sizeof(Weapon_Info); index++)
			{
				if(currentSTAGE != Weapon_Info[index][WEAPON_STAGE_LEVEL])
					continue;
				if(!strlen(Weapon_Info[index][WEAPON_D_MODEL]))
					continue;

				ArrayPushCell(Array_SelectedWeapons, index);
			}
			if(ArraySize(Array_SelectedWeapons))
			{
				new randomWeapon = ArrayGetCell(Array_SelectedWeapons, random_num(0, ArraySize(Array_SelectedWeapons)-1));
				engfunc(EngFunc_SetModel, orbEntity, fmt("models/Jenessee_Valorant/weapons/%s.mdl", Weapon_Info[randomWeapon][WEAPON_D_MODEL]));  
				set_entvar(orbEntity, var_code, randomWeapon);
			}

			ArrayClear(Array_SelectedWeapons);
			ArrayDestroy(Array_SelectedWeapons);

			set_entvar(orbEntity, var_renderfx, kRenderFxHologram);  
			set_entvar(orbEntity, var_rendermode, kRenderTransAdd);  
			set_entvar(orbEntity, var_renderamt, 5.0);  
			set_entvar(orbEntity, var_body, 5);  

			remove_task(orbEntity+TASK_ORB_COOLDOWN);
			if(orbCooldownWEAPON > 0.0) 
			{
				new params[1]; params[0] = orbEntity;
				set_task(orbCooldownWEAPON/5, "Task_Weapon_Orb_Effect", orbEntity+TASK_ORB_COOLDOWN, params, sizeof(params), "b");
				set_task(orbCooldownWEAPON, "Task_Orb_Cooldown_End", orbEntity+TASK_ORB_COOLDOWN, params, sizeof(params));
			}
		}
	}
	new Float:vOrigin[3]; get_entvar(orbEntity, var_origin, vOrigin);
	vOrigin[2] += 2.0;
	if((orbType == ORBTYPE_HEAL || orbType == ORBTYPE_SPEED) && strlen(orbGroundEFFECT))
	{
		new energyWAVE = Create_Model_Sprite(0, orbGroundEFFECT, vOrigin, ORIENTED, 0, 0.0, orbType == ORBTYPE_HEAL ? orbActiveTIME_Heal : orbActiveTIME_Speed, 1.0, 0, 0.0, 0, false, true);
		if(energyWAVE != NULLENT)
		{
			ChildrenParent_Entity(orbEntity, energyWAVE);
			Entity_Will_Remove_NewRound(energyWAVE, true);
			if(orbType == ORBTYPE_HEAL) set_entvar(energyWAVE, var_skin, 1); 
			set_entvar(energyWAVE, var_movetype, MOVETYPE_NOCLIP);
			set_entvar(energyWAVE, var_solid, SOLID_TRIGGER);

			set_entvar(energyWAVE, var_orbtype, orbType);
			set_entvar(energyWAVE, var_origin, vOrigin);
			static Float:vMins[3] = {-100.0, -100.0, 0.0};
			static Float:vMaxs[3]= {100.0, 100.0, 20.0};

			engfunc(EngFunc_SetSize, energyWAVE, vMins, vMaxs);
			set_entvar(energyWAVE, var_mins, vMins); 
			set_entvar(energyWAVE, var_maxs, vMaxs); 
			set_entvar(energyWAVE, var_absmin, vMins);
			set_entvar(energyWAVE, var_absmax, vMaxs);

			SetTouch(energyWAVE, "OnPlayerTouchEnergy");
		}
	}

	if((orbType == ORBTYPE_HEAL && strlen(orbWindEFFECT)) || (orbType == ORBTYPE_SPEED && strlen(orbFieldEFFECT)))
	{
		new waveEffect = Create_Model_Sprite(0, orbType == ORBTYPE_HEAL ? orbWindEFFECT : orbFieldEFFECT, vOrigin, ORIENTED, 0, 0.0, orbType == ORBTYPE_HEAL ? orbActiveTIME_Heal : orbActiveTIME_Speed, 1.0, 0, 0.0, 0, false, false);
		if(waveEffect != NULLENT)
		{
			ChildrenParent_Entity(orbEntity, waveEffect);
			Entity_Will_Remove_NewRound(waveEffect, true);
		}
	}

	SetTouch(orbEntity, "");
	if(entityTotalCHILDRENS[orbEntity] > 0)
	{
		new entityMODEL[128];
		for(new arrayIndex = entityTotalCHILDRENS[orbEntity]-1, childrenEntity; arrayIndex >= 0; arrayIndex--)
		{
			childrenEntity = ArrayGetCell(entityCHILDRENS[orbEntity], arrayIndex);
			get_entvar(childrenEntity, var_model, entityMODEL, charsmax(entityMODEL));

			if(equal(entityMODEL, orbEFFECT)) {
				if(orbType != ORBTYPE_WEAPON && get_entvar(childrenEntity, var_body) == 1)
				{
					set_entvar(childrenEntity, var_effects, get_entvar(childrenEntity, var_effects) | EF_NODRAW);
				}
			} else if(equal(entityMODEL, orbFireHEALTH) || equal(entityMODEL, orbFireSPEED) || equal(entityMODEL, weaponOrbBUTTON)) {
				SetThink(childrenEntity, "");
				set_entvar(childrenEntity, var_effects, get_entvar(childrenEntity, var_effects) | EF_NODRAW);
			}
		}
	}
}

public Task_Weapon_Orb_Effect(params[], taskid)
{
	new orbEntity = params[0];

	new Float:renderAMT = get_entvar(orbEntity, var_renderamt);
	set_entvar(orbEntity, var_renderamt, floatmin(255.0, renderAMT += 50.0));  

	if(get_entvar(orbEntity, var_body) > 0)
	{
		set_entvar(orbEntity, var_body, get_entvar(orbEntity, var_body) - 1);
	}
}

public Task_Orb_StopSound(params[], taskid)
{
	new orbEntity = params[0];

	rh_emit_sound(orbEntity, 0, CHAN_ITEM, playerSpeedLoopSound, 0.8, ATTN_IDLE, SND_STOP, PITCH_NORM, SND_EMIT2_NOPAS);
}

public Task_Orb_Cooldown_End(params[], taskid)
{
	new orbEntity = params[0];

	switch(get_entvar(orbEntity, var_orbtype)) 
	{
		case ORBTYPE_HEAL: if(strlen(orbHealIdleSound)) rh_emit_sound(orbEntity, 0, CHAN_ITEM, orbHealIdleSound, 0.6, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		case ORBTYPE_SPEED: if(strlen(orbSpeedIdleSound)) rh_emit_sound(orbEntity, 0, CHAN_ITEM, orbSpeedIdleSound, 0.6, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		case ORBTYPE_WEAPON: 
		{
			set_entvar(orbEntity, var_renderfx, kRenderFxNone);  
			set_entvar(orbEntity, var_rendermode, kRenderNormal);  
			set_entvar(orbEntity, var_renderamt, 255.0);  
			set_entvar(orbEntity, var_body, 0);
			if(strlen(orbWeaponChargedSound)) rh_emit_sound(orbEntity, 0, CHAN_STATIC, orbWeaponChargedSound, 0.5, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			if(strlen(orbWeaponIdleSound)) rh_emit_sound(orbEntity, 0, CHAN_ITEM, orbWeaponIdleSound, 0.6, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		}
	}

	SetTouch(orbEntity, "OnPlayerTouchOrb");
	set_entvar(orbEntity, var_effects, get_entvar(orbEntity, var_effects) & ~EF_NODRAW);
	if(entityTotalCHILDRENS[orbEntity] > 0)
	{
		new entityMODEL[128];
		for(new arrayIndex = entityTotalCHILDRENS[orbEntity]-1, childrenEntity; arrayIndex >= 0; arrayIndex--)
		{
			childrenEntity = ArrayGetCell(entityCHILDRENS[orbEntity], arrayIndex);
			get_entvar(childrenEntity, var_model, entityMODEL, charsmax(entityMODEL));

			if(equal(entityMODEL, orbEFFECT)) {
				if(get_entvar(childrenEntity, var_body) == 1)
				{
					set_entvar(childrenEntity, var_effects, get_entvar(childrenEntity, var_effects) & ~EF_NODRAW);
				}
			} else if(equal(entityMODEL, orbFireHEALTH) || equal(entityMODEL, orbFireSPEED) || equal(entityMODEL, weaponOrbBUTTON)) {
				if(get_entvar(childrenEntity, var_maxframe))
				{
					SetThink(childrenEntity, equal(entityMODEL[strlen(entityMODEL)-4], ".spr") ? "SpriteFrame_Think" : "ModelFrame_Think");
					set_entvar(childrenEntity, var_nextthink, get_gametime());
				}
				set_entvar(childrenEntity, var_effects, get_entvar(childrenEntity, var_effects) & ~EF_NODRAW);
			}
		}
	}	
}

public OnPlayerTouchEnergy(const orbEntity, const clientIndex)
{
	if(!is_user_alive(clientIndex))
		return;
	
	new orbType = get_entvar(orbEntity, var_orbtype);

	new params[1]; params[0] = clientIndex;
	switch(orbType)
	{
		case ORBTYPE_HEAL:
		{
			if(get_entvar(clientIndex, var_max_health) <= get_entvar(clientIndex, var_health))
				return;
			
			if(task_exists(clientIndex+TASK_PLAYER_REGENERATION_END, 1))
			{
				remove_task(clientIndex+TASK_PLAYER_REGENERATION_END, 1);
				set_task(regenerationTime, "Task_Regeneration_End", clientIndex+TASK_PLAYER_REGENERATION_END, params, sizeof(params));
				return;
			}
			if(regenerationTime > 0.0) 
			{
				remove_task(clientIndex+TASK_PLAYER_REGENERATION, 1);
				if(regenerationDelay > 0.0) set_task(regenerationDelay, "Task_Regeneration", clientIndex+TASK_PLAYER_REGENERATION, params, sizeof(params));

				if(strlen(playerHealSound)) 
					rh_emit_sound(clientIndex, clientIndex, CHAN_ITEM, playerHealSound, 0.2, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);

				if(strlen(playerScreenHEAL))
				{
					set_entvar(Create_View_Sprite(clientIndex, playerScreenHEAL, 3, 4096, 0.275, 0.0, 0.0, 1.0, 16.0, 0.05, true, clientIndex, false), var_renderamt, 125.0);
				} 
					
				if(strlen(playerHealEFFECT))
				{
					new healEffect = Create_Model_Sprite(clientIndex, playerHealEFFECT, Float:{0.0, 0.0, 0.0}, ORIENTED, 0, 0.0, 0.0, 1.0, clientIndex, 0.0, 0, false, false);
					bEntityHaveTeam[healEffect] = true;
					set_entvar(healEffect, var_team, playerTEAM[clientIndex]);
					set_entvar(healEffect, var_effects, 8192);
				}
					
				set_task(regenerationTime, "Task_Regeneration_End", clientIndex+TASK_PLAYER_REGENERATION_END);
			}
		}
		case ORBTYPE_SPEED:
		{
			if(task_exists(clientIndex+TASK_PLAYER_SPEED_END, 1))
			{
				remove_task(clientIndex+TASK_PLAYER_SPEED_END, 1);
				set_task(speedTime, "Task_Speed_End", clientIndex+TASK_PLAYER_SPEED_END, params, sizeof(params));
				return;
			}

			if(strlen(orbSpeedStartSound)) 
				rh_emit_sound(clientIndex, clientIndex, CHAN_STATIC, orbSpeedStartSound, 0.5, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);

			new fovEntity = rg_create_entity("info_target");
			if(!is_nullent(fovEntity))
			{
				set_entvar(fovEntity, var_owner, clientIndex);
				ChildrenParent_Entity(clientIndex, fovEntity);

				SetThink(fovEntity, "Think_Speed_Fov_Up");
				set_entvar(fovEntity, var_nextthink, get_gametime() + 0.05); 
			}
			
			if(strlen(playerSpeedEFFECT)) 
			{
				new speedEffect = Create_Model_Sprite(clientIndex, playerSpeedEFFECT, Float:{0.0, 0.0, 0.0}, ORIENTED, 0, 0.0, 0.0, 1.0, clientIndex, 0.0, 0, false, false);
				bEntityHaveTeam[speedEffect] = true;
				set_entvar(speedEffect, var_team, playerTEAM[clientIndex]);
				set_entvar(speedEffect, var_effects, 8192);
			}

			if(speedTime > 0.0) set_task(speedTime, "Task_Speed_End", clientIndex+TASK_PLAYER_SPEED_END, params, sizeof(params));

			bWeaponFast[clientIndex] = true;

			rg_reset_maxspeed(clientIndex);
		}
	}	
}

public Think_Speed_Fov_Up(const entityIndex)
{
	new clientIndex = get_entvar(entityIndex, var_owner);
	if(bFovTYPE[clientIndex])
	{
		if((playerDefaultFOV[clientIndex] += 1) >= orbSpeedFOV2)
		{
			if(strlen(playerScreenSPEED)) Create_View_Sprite(clientIndex, playerScreenSPEED, 3, 4096, 0.15, 0.0, 0.0, 1.0, 9.0, 0.075, true, clientIndex, false);
			playerDefaultFOV[clientIndex] = orbSpeedFOV2;
			Player_FOV(clientIndex, playerDefaultFOV[clientIndex], false);
			UTIL_RemoveEntity(entityIndex, 0.0);
			return;
		} 
	} else {
		if((playerDefaultFOV[clientIndex] += 1) >= orbSpeedFOV)
		{
			if(strlen(playerScreenSPEED)) Create_View_Sprite(clientIndex, playerScreenSPEED, 3, 4096, 0.15, 0.0, 0.0, 1.0, 9.0, 0.075, true, clientIndex, false);
			playerDefaultFOV[clientIndex] = orbSpeedFOV;
			Player_FOV(clientIndex, playerDefaultFOV[clientIndex], false);
			UTIL_RemoveEntity(entityIndex, 0.0);
			return;
		} 
	}

	Player_FOV(clientIndex, playerDefaultFOV[clientIndex], false);
	set_entvar(entityIndex, var_nextthink, get_gametime() + 0.025); 
}

public Task_Speed_Fov_Down(const entityIndex)
{
	new clientIndex = get_entvar(entityIndex, var_owner);
	if(bFovTYPE[clientIndex])
	{
		if((playerDefaultFOV[clientIndex] -= 1) <= 105)
		{
			rg_reset_maxspeed(clientIndex);
			playerDefaultFOV[clientIndex] = 105;
			Player_FOV(clientIndex, playerDefaultFOV[clientIndex], false);
			UTIL_RemoveEntity(entityIndex, 0.0);
			return;
		} 
	} else {
		if((playerDefaultFOV[clientIndex] -= 1) <= 90)
		{
			rg_reset_maxspeed(clientIndex);
			playerDefaultFOV[clientIndex] = 90;
			Player_FOV(clientIndex, playerDefaultFOV[clientIndex], false);
			UTIL_RemoveEntity(entityIndex, 0.0);
			return;
		} 
	}

	Player_FOV(clientIndex, playerDefaultFOV[clientIndex], false);
	set_entvar(entityIndex, var_nextthink, get_gametime() + 0.025); 
}

public Task_Regeneration(params[], taskid)
{
	new clientIndex = params[0]; 

	if(regenerationHeal > 0.0 && delayHealing[clientIndex] <= get_gametime())
	{
		new Float:currentHealth, Float:maxHealth;
		currentHealth = get_entvar(clientIndex, var_health);
		maxHealth = get_entvar(clientIndex, var_max_health);

		if(maxHealth > currentHealth)
		{
			currentHealth = floatclamp(currentHealth+regenerationHeal, 1.0, maxHealth);
			set_entvar(clientIndex, var_health, currentHealth);
			if(currentHealth == maxHealth) Character_Quote(clientIndex, QUOTE_HEALING);
		}
	}
	new param[1]; param[0] = clientIndex;
	set_task(regenerationDelay, "Task_Regeneration", clientIndex+TASK_PLAYER_REGENERATION, param, sizeof(param));
}

public Task_Regeneration_End(params[], taskid)
{
	new clientIndex = params[0]; 

	remove_task(clientIndex+TASK_PLAYER_REGENERATION, 1);

	new entityMODEL[128];
	for(new arrayIndex = entityTotalCHILDRENS[clientIndex]-1, childrenEntity; arrayIndex >= 0; arrayIndex--)
	{
		childrenEntity = ArrayGetCell(entityCHILDRENS[clientIndex], arrayIndex);
		get_entvar(childrenEntity, var_model, entityMODEL, charsmax(entityMODEL));

		if(equal(entityMODEL, playerHealEFFECT) || equal(entityMODEL, playerScreenHEAL)) {
			UTIL_RemoveEntity(childrenEntity, 0.0);
		} 
	}	
}

public Task_Speed_End(params[], taskid)
{
	new clientIndex = params[0]; 

	new entityMODEL[128];
	for(new arrayIndex = entityTotalCHILDRENS[clientIndex]-1, childrenEntity; arrayIndex >= 0; arrayIndex--)
	{
		childrenEntity = ArrayGetCell(entityCHILDRENS[clientIndex], arrayIndex);
		get_entvar(childrenEntity, var_model, entityMODEL, charsmax(entityMODEL));

		if(equal(entityMODEL, playerScreenSPEED) || equal(entityMODEL, playerSpeedEFFECT)) {
			UTIL_RemoveEntity(childrenEntity, 0.0);
		} 
	}	

	new fovEntity = rg_create_entity("info_target");
	if(!is_nullent(fovEntity))
	{
		set_entvar(fovEntity, var_owner, clientIndex);
		ChildrenParent_Entity(clientIndex, fovEntity);

		SetThink(fovEntity, "Task_Speed_Fov_Down");
		set_entvar(fovEntity, var_nextthink, get_gametime() + 0.05); 
	}

	bWeaponFast[clientIndex] = false;
}

public Show_DamageHud_Attacker(params[], taskid)
{
	new clientIndex = params[0];
	new attackerIndex = params[3];
	new arrayIndex = playerID[attackerIndex][clientIndex];
	if(arrayIndex == NULLENT)
		return;

	new Float:maxFrame; 
	switch(playerTotalKILL[attackerIndex])
	{
		case 1: maxFrame = 13.0;
		case 2: maxFrame = 20.0;
		case 3: maxFrame = 21.0;
		case 4: maxFrame = 17.0;
		default: maxFrame = 22.0;
	}

	for(new arrayIndex2 = iTotalWillRemoveEntities[attackerIndex]-1, entityMODEL[128], entityIndex; arrayIndex2 >= 0; arrayIndex2--)
	{	
		entityIndex = ArrayGetCell(ArrayWillRemoveEntities[attackerIndex], arrayIndex2);
		get_entvar(entityIndex, var_model, entityMODEL, charsmax(entityMODEL));

		if(equal(entityMODEL, weaponChangeSPRITE) || equal(entityMODEL, Kill_Mark[0][1]) || equal(entityMODEL, Kill_Mark[1][1]) || equal(entityMODEL, Kill_Mark[2][1]) || equal(entityMODEL, Kill_Mark[3][1]) || equal(entityMODEL, Kill_Mark[4][1]))
		{
			UTIL_RemoveEntity(entityIndex, 0.0);
		}
	}

	set_entvar(Create_View_Sprite(attackerIndex, Kill_Mark[min(4, playerTotalKILL[attackerIndex]-1)][1], 4, 4096, 0.03, 0.0, 0.0, 1.0, maxFrame, 0.1, false, attackerIndex, true), var_rendermode, kRenderTransAlpha);
	rh_emit_sound(attackerIndex, attackerIndex, 501, Kill_Mark[min(4, playerTotalKILL[attackerIndex]-1)][0], 0.8, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	
	static szDeathMessage[512], len; 

	len = format(szDeathMessage, charsmax(szDeathMessage), "%L", attackerIndex, "KILLINFO_ATTACKER_PLAYERDEATH", playerNAME[clientIndex]);

	if(is_user_connected(clientIndex))
	{
		new vOriginAttacker[3], vOriginVictim[3];
		get_user_origin(attackerIndex, vOriginAttacker);
		get_user_origin(clientIndex, vOriginVictim);

		len += format(szDeathMessage[len], charsmax(szDeathMessage)-len, "^n%L %im", attackerIndex, "KILLINFO_DISTANCE", get_distance(vOriginAttacker, vOriginVictim)/40);
	}
	
	if(arrayIndex != NULLENT)
	{
		new totalDamage = floatround(Float:ArrayGetCell(playersTotalDamage[attackerIndex], arrayIndex));

		len += format(szDeathMessage[len], charsmax(szDeathMessage)-len, "^n*%L", attackerIndex, "KILLINFO_ATTACKER_TOTALDAMAGE", MyLastWeaponName[clientIndex], totalDamage);
	
		for(new bodyGroup = HIT_HEAD, bodyGroupDamage, bodyGroupHit; bodyGroup <= HIT_RIGHTLEG; bodyGroup++) 
		{
			bodyGroupDamage = floatround(Float:ArrayGetCell(playersDamageBody[attackerIndex][bodyGroup], arrayIndex));
			bodyGroupHit = ArrayGetCell(playersHitsBody[attackerIndex][bodyGroup], arrayIndex);
			if(bodyGroupDamage <= 0 && bodyGroupHit <= 0)	
				continue;

			len += format(szDeathMessage[len], charsmax(szDeathMessage)-len, "^n%L", attackerIndex, fmt("KILLINFO_DAMAGE_HITGROUP%i", bodyGroup), bodyGroupDamage);
		}
	} else {
		len += format(szDeathMessage[len], charsmax(szDeathMessage)-len, "^n*%L", attackerIndex, "KILLINFO_ATTACKER_USED_WEAPON", MyLastWeaponName[clientIndex]);
	}

	set_hudmessage(50, 155, 253, 0.55, 0.65, 0, 0.0, 5.0);
	ShowSyncHudMsg(attackerIndex, deathInfoSYNC, szDeathMessage);
}

public Player_Kill_Quote(params[], taskid)
{
	new attackerIndex = params[3];

	switch(playerTotalKILL[attackerIndex])
	{
		case 3: 
		{
			Character_Quote(attackerIndex, (params[2] && playerAgentID[attackerIndex] == AGENT_RAZE) ? QUOTE_SKILL2 : QUOTE_3KILL);
		}
		case 4:
		{
			Character_Quote(attackerIndex, (params[2] && playerAgentID[attackerIndex] == AGENT_RAZE) ? QUOTE_SKILL2 : QUOTE_4KILL);
		}
		case 5:
		{
			Character_Quote(attackerIndex, QUOTE_5KILL);
			bAceSound[attackerIndex] = false;
		}
		case 6:
		{
			Character_Quote(attackerIndex, QUOTE_ACE);
			bAceSound2[attackerIndex] = false;
		}
		default:
		{
			if(playerTotalKILL[attackerIndex] > 6 && bAceSound2[attackerIndex] && !bAceSound[attackerIndex])
			{
				Character_Quote(attackerIndex, QUOTE_ACE);
				bAceSound2[attackerIndex] = false;
			}

			if(playerTotalKILL[attackerIndex] > 5 && bAceSound[attackerIndex])
			{
				Character_Quote(attackerIndex, QUOTE_5KILL);
				bAceSound[attackerIndex] = false;
			} else Character_Quote(attackerIndex, (params[2] && playerAgentID[attackerIndex] == AGENT_RAZE) ? QUOTE_SKILL2 : (params[1] ? QUOTE_KILL_HEADSHOT : QUOTE_KILL));
		}
	}
}

public Show_DamageHud_Victim(params[], taskid)
{
	new clientIndex = params[2]; 
	new attackerIndex = params[0];
	new arrayIndex = playerID[attackerIndex][clientIndex];
	if(arrayIndex == NULLENT)
	{
		if(params[1] == 31) Reset_Player_From_Attackers(clientIndex);
		return;
	}

	new remainingHP, remainingAP;

	static szDeathMessage[512], len; 

	len = formatex(szDeathMessage, charsmax(szDeathMessage), "%L", clientIndex, "KILLINFO_VICTIM_PLAYERDEATH", playerNAME[attackerIndex]);

	if(is_user_connected(attackerIndex))
	{
		remainingHP = floatround(get_entvar(attackerIndex, var_health));
		remainingAP = floatround(get_entvar(attackerIndex, var_armorvalue));

		new vOriginAttacker[3], vOriginVictim[3];
		get_user_origin(clientIndex, vOriginVictim);
		get_user_origin(attackerIndex, vOriginAttacker);

		if(params[1] != 31)
		{
			lastdistancemeter[clientIndex] = get_distance(vOriginAttacker, vOriginVictim)/40
		}
		len += format(szDeathMessage[len], charsmax(szDeathMessage)-len, "^n%L %im", clientIndex, "KILLINFO_DISTANCE", lastdistancemeter[clientIndex]);
	}

	if(arrayIndex != NULLENT)
	{
		new totalDamage = floatround(Float:ArrayGetCell(playersTotalDamage[attackerIndex], arrayIndex));

		len += format(szDeathMessage[len], charsmax(szDeathMessage)-len, "^n*%L", clientIndex, "KILLINFO_VICTIM_TOTALDAMAGE", MyLastWeaponName[clientIndex], totalDamage);
	
		for(new bodyGroup = HIT_HEAD, bodyGroupDamage, bodyGroupHit; bodyGroup <= HIT_RIGHTLEG; bodyGroup++) 
		{
			bodyGroupDamage = floatround(Float:ArrayGetCell(playersDamageBody[attackerIndex][bodyGroup], arrayIndex));
			bodyGroupHit = ArrayGetCell(playersHitsBody[attackerIndex][bodyGroup], arrayIndex);
			if(bodyGroupDamage <= 0 && bodyGroupHit <= 0)	
				continue;

			len += format(szDeathMessage[len], charsmax(szDeathMessage)-len, "^n%L", clientIndex, fmt("KILLINFO_DAMAGE_HITGROUP%i", bodyGroup), bodyGroupDamage);
		}
	} else {
		len += format(szDeathMessage[len], charsmax(szDeathMessage)-len, "^n*%L^n", clientIndex, "KILLINFO_VICTIM_USED_WEAPON", MyLastWeaponName[clientIndex]);
	}

	if(remainingHP || remainingAP)
	{
		len += format(szDeathMessage[len], charsmax(szDeathMessage)-len, "^n^n%L", clientIndex, "KILLINFO_VICTIM_HEALTH_AP", remainingHP, remainingAP);
	}

	set_hudmessage(239, 155, 55, 0.40, 0.60, 0, 0.0, 5.0);
	ShowSyncHudMsg(clientIndex, deathInfoSYNC, szDeathMessage);

	if(params[1] == 31) Reset_Player_From_Attackers(clientIndex);
}

public Reset_Player_From_Attackers(const clientIndex)
{
	for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, playerIndex, damageID; arrayIndex >= 0; arrayIndex--) 
	{
		playerIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);
		if(playerIndex == clientIndex)
			continue;
		damageID = playerID[playerIndex][clientIndex];
		if(damageID == NULLENT)
			continue;

		ArrayDeleteItem(playersEnemy[playerIndex], damageID);
		ArrayDeleteItem(playersTotalDamage[playerIndex], damageID);

		for(new bodyGroup = HIT_HEAD; bodyGroup <= HIT_RIGHTLEG; bodyGroup++) 
		{
			ArrayDeleteItem(playersDamageBody[playerIndex][bodyGroup], damageID);
			ArrayDeleteItem(playersHitsBody[playerIndex][bodyGroup], damageID);
		}

		playerID[playerIndex][clientIndex] = NULLENT;
	}

	for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, playerIndex, damageID; arrayIndex >= 0; arrayIndex--) 
	{
		playerIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);
		if(playerIndex == clientIndex)
			continue;

		for(damageID = ArraySize(playersEnemy[playerIndex])-1; damageID >= 0; damageID--)
		{
			playerID[playerIndex][ArrayGetCell(playersEnemy[playerIndex], damageID)] = damageID;
		}
	}
}

public TraceAttack(const clientIndex, const attackerIndex, Float:fDamage, const Float:vDirection[3], const iTracehandle, const iDamageType)
{
	if(is_user_connected(clientIndex))
	{
		if(is_user_connected(attackerIndex))
		{
			if(task_exists(clientIndex+TASK_PLAYER_IMMORTAL, 1))
			{
				static Float:vecPlaneNormal[3]; get_tr2(iTracehandle, TR_vecPlaneNormal, vecPlaneNormal);	
				static Float:vecEnd[3];	get_tr2(iTracehandle, TR_vecEndPos, vecEnd);	

				message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
				write_byte(TE_STREAK_SPLASH);
				write_coord_f(vecEnd[0]);
				write_coord_f(vecEnd[1]);
				write_coord_f(vecEnd[2]);
				write_coord_f(vecPlaneNormal[0] * random_float(25.0, 30.0));
				write_coord_f(vecPlaneNormal[1] * random_float(25.0, 30.0));
				write_coord_f(vecPlaneNormal[2] * random_float(25.0, 30.0));
				write_byte(0);
				write_short(0);
				write_short(3);
				write_short(75);
				message_end();

				static Float:delaysound;
				if(delaysound <= get_gametime())
				{
					rh_emit_sound(clientIndex, attackerIndex, CHAN_STATIC, Barrier_Hit[random_num(0, sizeof(Barrier_Hit)-1)], 0.6, ATTN_NONE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
					delaysound = get_gametime() + 0.1;
				}

				SetHamParamFloat(3, 0.0);
				return HAM_SUPERCEDE;
			}
		}
	} else if(!is_nullent(clientIndex)) {
		if(bEyeEntity[clientIndex])
		{
			if(get_entvar(clientIndex, var_team) != get_entvar(attackerIndex, var_team))
			{
				rh_emit_sound(clientIndex, attackerIndex, 499, Skill_Resources[38], 0.8, ATTN_NONE, 0, PITCH_NORM, SND_EMIT2_NOPAS);

				new Float:vecEnd[3]; get_entvar(clientIndex, var_origin, vecEnd);
				SpawnBlood(vecEnd, HIT_HEAD, 7, 144);
			}
		} else if(bProwlerEntity[clientIndex]) {
			if(get_entvar(clientIndex, var_team) != get_entvar(attackerIndex, var_team))
			{
				rh_emit_sound(clientIndex, attackerIndex, 499, Skill_Resources[38], 0.8, ATTN_NONE, 0, PITCH_NORM, SND_EMIT2_NOPAS);

				new Float:vecEnd[3]; get_tr2(iTracehandle, TR_vecEndPos, vecEnd);	
				SpawnBlood(vecEnd, HIT_HEAD, 7, 77);
			}
		} else if(bDeadlockEntity[clientIndex]) {
			if(get_entvar(clientIndex, var_team) != get_entvar(attackerIndex, var_team))
			{
				rh_emit_sound(clientIndex, attackerIndex, 499, Skill_Resources[56], 0.8, ATTN_NONE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			}
			new Float:vecPlaneNormal[3]; get_tr2(iTracehandle, TR_vecPlaneNormal, vecPlaneNormal);	
			new Float:vecEnd[3]; get_tr2(iTracehandle, TR_vecEndPos, vecEnd);	

			message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
			write_byte(TE_STREAK_SPLASH);
			write_coord_f(vecEnd[0]);
			write_coord_f(vecEnd[1]);
			write_coord_f(vecEnd[2]);
			write_coord_f(vecPlaneNormal[0] * random_float(25.0, 30.0));
			write_coord_f(vecPlaneNormal[1] * random_float(25.0, 30.0));
			write_coord_f(vecPlaneNormal[2] * random_float(25.0, 30.0));
			write_byte(0);
			write_short(0);
			write_short(3);
			write_short(75);
			message_end();
		}
	}

	return HAM_IGNORED;
}

public TakeDamage(const clientIndex, const iInflictor, const attackerIndex, Float:fDamage, DamageBits)
{
	if(is_user_connected(attackerIndex) && !is_nullent(clientIndex))
	{
		if(is_user_connected(clientIndex)) 
		{
			if(task_exists(clientIndex+TASK_PLAYER_IMMORTAL, 1) || playerInBASE[clientIndex] || playerInBASE[attackerIndex] || (attackerIndex != clientIndex && playerTEAM[attackerIndex] == playerTEAM[clientIndex]))
			{
				SetHamParamFloat(4, 0.0);
				return HAM_SUPERCEDE;
			}

			if(!is_nullent(iInflictor))
			{
				get_entvar(iInflictor, var_netname, MyLastWeaponName[clientIndex], charsmax(MyLastWeaponName));
			}

			MyLastAttacker[clientIndex] = attackerIndex;

			if(DamageBits & DMG_CLUB)
			{
				new Float:vecAiming[3]; get_entvar(clientIndex, var_punchangle, vecAiming);
				vecAiming[0] -= 6.0; 
				vecAiming[1] += random_float(-6.0, 6.0); 
				set_entvar(clientIndex, var_punchangle, vecAiming);		
				set_member(clientIndex, m_LastHitGroup, HIT_STOMACH);
			}	
		}

		new weaponEntity = currentWeaponENTITY[attackerIndex];
		if(DamageBits & DMG_BULLET && get_entvar(attackerIndex, var_team) != get_entvar(clientIndex, var_team) && weaponEntity != NULLENT)
		{
			new weaponCODE = get_entvar(weaponEntity, var_impulse);
			if(weaponCODE)
			{
				new Float:damage, hitGroup;
				if(clientIndex > MAX_PLAYERS) hitGroup = HIT_STOMACH;
				else hitGroup = get_member(clientIndex, m_LastHitGroup);
				switch (hitGroup)
				{
					case HIT_HEAD: 
					{
						damage = float(Weapon_Info[weaponCODE][HEADSHOT_DAMAGE]);
					}
					case HIT_CHEST, HIT_STOMACH, HIT_LEFTARM, HIT_RIGHTARM: 
					{
						damage = float(Weapon_Info[weaponCODE][BODY_DAMAGE]);
					}
					default: 
					{
						damage = float(Weapon_Info[weaponCODE][LEG_DAMAGE]);
					}
				}
				
				switch(weaponCODE)
				{
					case KNIFE:
					{
						damage = float(Weapon_Info[weaponCODE][get_entvar(weaponEntity, var_weapon_right) ? BODY_DAMAGE : LEG_DAMAGE]);
						if(clientIndex <= MAX_PLAYERS) if(!Distance_Entity_Angles(clientIndex, attackerIndex, 90.0)) damage *= 2.0;
					}
					case ARES, ODIN, CLASSIC, FRENZY, GHOST, SHERRIF:
					{
						new Float:vOrigin[3], Float:vTarget[3];
						get_entvar(attackerIndex, var_origin, vOrigin);
						Get_Origin_MapEntities(clientIndex, vTarget)
						if(get_distance_f(vOrigin, vTarget) > 1200.0)
						{
							if(weaponCODE == CLASSIC || weaponCODE == FRENZY || weaponCODE == GHOST || weaponCODE == SHERRIF) damage *= 0.8;
							else damage *= 0.9;
						}
					}
					case JUDGE:
					{
						new Float:vOrigin[3], Float:vTarget[3];
						get_entvar(attackerIndex, var_origin, vOrigin);
						Get_Origin_MapEntities(clientIndex, vTarget)
						new Float:distance = get_distance_f(vOrigin, vTarget)
						if(distance > 600.0)
						{
							damage *= 0.45;
						} else if(distance > 400.0) {
							damage *= 0.55;
						}
					}
					case BUCKY:
					{
						new Float:vOrigin[3], Float:vTarget[3];
						get_entvar(attackerIndex, var_origin, vOrigin);
						Get_Origin_MapEntities(clientIndex, vTarget)
						new Float:distance = get_distance_f(vOrigin, vTarget)
						if(distance > 480.0)
						{
							damage *= 0.45;
						} else if(distance > 320.0) {
							damage *= 0.55;
						}
					}
					case PHANTOM, SPECTRE, STINGER:
					{
						new Float:vOrigin[3], Float:vTarget[3];
						get_entvar(attackerIndex, var_origin, vOrigin);
						Get_Origin_MapEntities(clientIndex, vTarget)
						new Float:distance = get_distance_f(vOrigin, vTarget)
						if(distance > 600.0)
						{
							damage *= 0.9;
						} else if(distance > 1200.0 && weaponCODE != STINGER) {
							damage *= 0.7;
						}	
					}
					case SHORTY:
					{
						new Float:vOrigin[3], Float:vTarget[3];
						get_entvar(attackerIndex, var_origin, vOrigin);
						Get_Origin_MapEntities(clientIndex, vTarget)
						new Float:distance = get_distance_f(vOrigin, vTarget)
						if(distance > 600.0)
						{
							damage *= 0.4;
						} else if(distance > 280.0) {
							damage *= 0.55;
						}
					}
				}

				if(damage > 0.0)
				{
					SetHamParamFloat(4, damage);
				}
			}
		}
	}
	
	if(!is_user_connected(clientIndex)) 
	{
		if(!is_nullent(attackerIndex))
		{
			if(get_entvar(attackerIndex, var_team) == get_entvar(clientIndex, var_team))
			{
				SetHamParamFloat(4, 0.0);
				return HAM_SUPERCEDE;
			}
		}
	}

	return HAM_IGNORED;
}

public TakeDamage_Post(const clientIndex, const iInflictor, const attackerIndex, Float:fDamage, DamageBits)
{
	if(is_user_connected(clientIndex))
	{
		if(playerInBASE[clientIndex] || (is_user_connected(attackerIndex) && playerInBASE[attackerIndex]))
		{
			SetHamParamFloat(4, 0.0);
			return HAM_SUPERCEDE;
		}

		if(DamageBits & DMG_CLUB)
		{
			set_member(clientIndex, m_flVelocityModifier, 1.0);
		}	

		MyLastAttacker[clientIndex] = NULLENT;
		if(is_user_connected(attackerIndex))
		{
			if(clientIndex == attackerIndex)
				return HAM_IGNORED;
			if(get_entvar(attackerIndex, var_team) == get_entvar(clientIndex, var_team))
				return HAM_IGNORED;


			delayHealing[clientIndex] = get_gametime() + 2.0;
			
			if(playerID[attackerIndex][clientIndex] == NULLENT)
			{
				new hitGroup = get_member(clientIndex, m_LastHitGroup);
				hitGroup = clamp(hitGroup == 0 ? HIT_STOMACH : hitGroup, HIT_HEAD, HIT_RIGHTLEG);
				new arrayIndex = ArrayPushCell(playersEnemy[attackerIndex], clientIndex);  
				ArrayPushCell(playersTotalDamage[attackerIndex], fDamage); 
				for(new bodyGroup = HIT_HEAD; bodyGroup <= HIT_RIGHTLEG; bodyGroup++) 
				{
					ArrayPushCell(playersDamageBody[attackerIndex][bodyGroup], hitGroup == bodyGroup ? fDamage : 0.0); 
					ArrayPushCell(playersHitsBody[attackerIndex][bodyGroup], hitGroup == bodyGroup ? 1 : 0); 
				}
				playerID[attackerIndex][clientIndex] = arrayIndex;
			} else {
				new hitGroup = get_member(clientIndex, m_LastHitGroup);
				hitGroup = clamp(hitGroup == 0 ? HIT_STOMACH : hitGroup, HIT_HEAD, HIT_RIGHTLEG);

				static arrayIndex; arrayIndex = playerID[attackerIndex][clientIndex];
				ArraySetCell(playersTotalDamage[attackerIndex], arrayIndex, Float:ArrayGetCell(playersTotalDamage[attackerIndex], arrayIndex) + fDamage);
				ArraySetCell(playersDamageBody[attackerIndex][hitGroup], arrayIndex, Float:ArrayGetCell(playersDamageBody[attackerIndex][hitGroup], arrayIndex) + fDamage); 
				ArraySetCell(playersHitsBody[attackerIndex][hitGroup], arrayIndex, ArrayGetCell(playersHitsBody[attackerIndex][hitGroup], arrayIndex) + 1); 
			}

			myTotalDamage[attackerIndex] += fDamage;
		}
	}

	return HAM_IGNORED;
}

UTIL_PrecacheSoundsFromModel(const szModelPath[])
{
	new pFile;
	if (!(pFile = fopen(szModelPath, "rt")))
		return;
	
	new szSoundPath[64];
	new iNumSeq, iSeqIndex;
	new iEvent, iNumEvents, iEventIndex;
	
	fseek(pFile, 164, SEEK_SET);
	fread(pFile, iNumSeq, BLOCK_INT);
	fread(pFile, iSeqIndex, BLOCK_INT);
	
	for(new i = 0; i < iNumSeq; i++)
	{
		fseek(pFile, iSeqIndex + 48 + 176 * i, SEEK_SET);
		fread(pFile, iNumEvents, BLOCK_INT);
		fread(pFile, iEventIndex, BLOCK_INT);
		fseek(pFile, iEventIndex + 176 * i, SEEK_SET);
		
		for(new k = 0; k < iNumEvents; k++)
		{
			fseek(pFile, iEventIndex + 4 + 76 * k, SEEK_SET);
			fread(pFile, iEvent, BLOCK_INT);
			fseek(pFile, 4, SEEK_CUR);
			
			if(iEvent != 5004)
				continue;
			
			fread_blocks(pFile, szSoundPath, 64, BLOCK_CHAR);
			
			if (strlen(szSoundPath))
			{
				strtolower(szSoundPath);
				format(szSoundPath, charsmax(szSoundPath), "sound/%s", szSoundPath);
				if(file_exists(szSoundPath)) engfunc(EngFunc_PrecacheGeneric, szSoundPath);
			}
		}
	}
	
	fclose(pFile);
}


stock UTIL_PlayerAnimation(const clientIndex, const szAnim[], Float:frameRate = 1.0) 
{
	new iAnimDesired, Float: flFrameRate, Float: flGroundSpeed, bool: bLoops;
	if ((iAnimDesired = lookup_sequence(clientIndex, szAnim, flFrameRate, bLoops, flGroundSpeed)) == -1) 
		iAnimDesired = 0;

	new Float:flGameTime = get_gametime();

	set_entvar(clientIndex, var_animtime, get_gametime());
	set_entvar(clientIndex, var_frame, 0.0);
	set_entvar(clientIndex, var_framerate, frameRate);
	set_entvar(clientIndex, var_sequence, iAnimDesired);

	set_member(clientIndex, m_fSequenceLoops, bLoops);
	set_member(clientIndex, m_fSequenceFinished, 0);
	set_member(clientIndex, m_flFrameRate, flFrameRate);
	set_member(clientIndex, m_flGroundSpeed, flGroundSpeed);
	set_member(clientIndex, m_flLastEventCheck, flGameTime);
	set_member(clientIndex, m_Activity, ACT_RANGE_ATTACK1);
	set_member(clientIndex, m_IdealActivity, ACT_RANGE_ATTACK1);
	set_member(clientIndex, m_flLastFired, flGameTime);
}

public OnPlayerKilled(const clientIndex, const attackerIndex)
{
	if(attackerIndex == clientIndex)
		return;
	if(attackerIndex <= 0 || attackerIndex > MAX_PLAYERS) return;

	Log("%s/OnPlayerKilled", PLUGIN);

	playerTotalKILL[attackerIndex]++;

	new assistIndex = -1;
	for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, playerIndex, damageID, Float:fMaxDamage = -1.0; arrayIndex >= 0; arrayIndex--) 
	{
		playerIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);
		if(attackerIndex == playerIndex)
			continue
		damageID = playerID[playerIndex][clientIndex];
		if(damageID == -1)
			continue;
		if(fMaxDamage >= Float:ArrayGetCell(playersTotalDamage[playerIndex], damageID))
			continue;

		assistIndex = playerIndex;
		ExecuteForward(g_Forwards[FW_ON_PLAYER_ASSIST], g_fwResult, playerIndex, attackerIndex, clientIndex);
	}

	static szBuffer[64];
	if(assistIndex != -1)
	{
		static szAssistName[32], szAttackerName[32], iLen[2];
		szAssistName = playerNAME[assistIndex];
		szAttackerName = playerNAME[attackerIndex];

		iLen[0] = strlen(szAttackerName);
		iLen[1] = strlen(szAssistName);
		if(iLen[0] > 28 / 2)
		{
			if(iLen[1] > 28 / 2)
			{
				if(iLen[0] - 28 / 2 > 1)
				{
					if(iLen[1] - 28 / 2 > 1)
					{
						strclip(szAttackerName, charsmax(szAttackerName), 28 / 2);
						strclip(szAssistName, charsmax(szAssistName), 28 / 2);
					}
					else strclip(szAttackerName, charsmax(szAttackerName), 28 / 2 - (iLen[1] - 28 / 2));
				}
				else strclip(szAssistName, charsmax(szAssistName), 28 / 2 - (iLen[0] - 28 / 2));
			}
			else strclip(szAttackerName, charsmax(szAttackerName), 28 - iLen[1]);
		}
		else if(iLen[1] > 28 / 2) strclip(szAssistName, charsmax(szAssistName), 28 - iLen[0]);
		
		formatex(szBuffer, charsmax(szBuffer), "%s %s + %s", Roman_Numerals[min(9, playerTotalKILL[attackerIndex]-1)], szAttackerName, szAssistName);

		Set_Fake_Name(attackerIndex, szBuffer);
		EnableHookChain(HookChain_Killed_Post);
	} else {
		formatex(szBuffer, charsmax(szBuffer), "%s %s", Roman_Numerals[min(9, playerTotalKILL[attackerIndex]-1)], playerNAME[attackerIndex]);

		Set_Fake_Name(attackerIndex, szBuffer);
		EnableHookChain(HookChain_Killed_Post);
	}
}

stock strclip(szString[], iSize, iClip)
{
	copy(szString, iClip - 2, szString)
	add(szString, iSize, "..")
}

public OnPlayerKilled_Post(const clientIndex, const attackerIndex)
{
	DisableHookChain(HookChain_Killed_Post);

	#if AMXX_VERSION_NUM >= 183 && defined HLTV_FIX
		set_task(0.1, "Task_Reset_Info", attackerIndex + 64)
	#else
		Reset_User_Info(attackerIndex)
	#endif
}

#if AMXX_VERSION_NUM >= 183 && defined HLTV_FIX
public Task_Reset_Info(clientIndex) Reset_User_Info(clientIndex - 64)
#endif

Reset_User_Info(clientIndex)
{
	new szUserInfo[256]; copy_infokey_buffer(engfunc(EngFunc_GetInfoKeyBuffer, clientIndex), szUserInfo, charsmax(szUserInfo))
	#if defined HLTV_FIX
	for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, clientIndex; arrayIndex >= 0; arrayIndex--)
	{
		clientIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);
		if(!is_user_hltv(clientIndex))
		{
			message_begin(MSG_ONE, SVC_UPDATEUSERINFO, _, clientIndex)
	#else
			message_begin(MSG_ALL, SVC_UPDATEUSERINFO)
	#endif
			write_byte(clientIndex - 1)
			write_long(get_user_userid(clientIndex))
			write_string(szUserInfo)
			write_long(0)
			write_long(0)
			write_long(0)
			write_long(0)
			message_end()
	#if defined HLTV_FIX
		}
	}
	#endif
}

Set_Fake_Name(const clientIndex, const szName[])
{
	#if defined HLTV_FIX
	for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, clientIndex; arrayIndex >= 0; arrayIndex--)
	{
		clientIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);
		if(!is_user_hltv(clientIndex))
		{
			message_begin(MSG_ONE, SVC_UPDATEUSERINFO, _, clientIndex);
	#else
			message_begin(MSG_ALL, SVC_UPDATEUSERINFO);
	#endif
			write_byte(clientIndex - 1);
			write_long(get_user_userid(clientIndex));
			write_char('\');
			write_char('n');
			write_char('a');
			write_char('m');
			write_char('e');
			write_char('\');
			write_string(szName);
			for(new index; index < 16; index++) write_byte(0);
			message_end();
	#if defined HLTV_FIX
		}
	}
	#endif
}

UpdateFrags(const attackerIndex, const victimIndex, const AddScore, const AddDeath, bool:Update)
{
	Log("%s/UpdateFrags", PLUGIN);
	if(attackerIndex && is_user_connected(attackerIndex))
	{
		set_entvar(attackerIndex, var_frags, float(get_entvar(attackerIndex, var_frags) + AddScore));
		
		if(Update)
		{
			message_begin(MSG_BROADCAST, Message_ScoreInfo);
			write_byte(attackerIndex);
			write_short(get_entvar(attackerIndex, var_frags));
			write_short(get_member(attackerIndex, m_iDeaths));
			write_short(0);
			write_short(get_member(attackerIndex, m_iTeam));
			message_end();
		}
	}
	
	if(victimIndex && is_user_connected(victimIndex))
	{
		set_member(victimIndex, m_iDeaths, get_member(victimIndex, m_iDeaths) + AddDeath);

		if(Update)
		{
			message_begin(MSG_BROADCAST, Message_ScoreInfo);
			write_byte(victimIndex);
			write_short(get_entvar(victimIndex, var_frags));
			write_short(get_member(victimIndex, m_iDeaths));
			write_short(0);
			write_short(get_member(victimIndex, m_iTeam));
			message_end();
		}
	}
}

PlaySound(const clientIndex, const szSound[])
{
	if(equal(szSound[strlen(szSound)-4], ".mp3")) 
	{ 
		client_cmd(clientIndex, "mp3 play ^"sound/%s^"", szSound);
	} else client_cmd(clientIndex, "spk ^"%s^"", szSound);
}

UTIL_SendWeaponAnim(const clientIndex, const iSequence) 
{
	new bodyIndex;
	new weaponEntity = currentWeaponENTITY[clientIndex];
	if(weaponEntity != NULLENT && get_entvar(weaponEntity, var_impulse) > 0 && playerAgentID[clientIndex] != NULLENT) 
	{
		bodyIndex = Agent_BodyCode[playerAgentID[clientIndex]];
	}

	set_entvar(clientIndex, var_weaponanim, iSequence);
	
	message_begin(MSG_ONE, SVC_WEAPONANIM, _, clientIndex);
	write_byte(iSequence);
	write_byte(bodyIndex);
	message_end();	

	if(get_entvar(clientIndex, var_iuser1))
		return;

	for(new arrayIndex = ArraySize(Array_playerDEAD)-1, playerIndex; arrayIndex >= 0; arrayIndex--)
	{
		playerIndex = ArrayGetCell(Array_playerDEAD, arrayIndex);

		if (get_entvar(playerIndex, var_iuser1) != OBS_IN_EYE)
			continue;
		if (get_entvar(playerIndex, var_iuser2) != clientIndex)
			continue;

		set_entvar(playerIndex, var_weaponanim, iSequence);

		message_begin(MSG_ONE_UNRELIABLE, SVC_WEAPONANIM, .player = playerIndex);
		write_byte(iSequence);
		write_byte(bodyIndex);
		message_end();
	}
}

Create_StageWeapon_Menu()
{
	new szMenuTitle[64]; formatex(szMenuTitle, charsmax(szMenuTitle), "%L", LANG_PLAYER, "WEAPON_MENUTITLE"); 
	stageWeaponMENU = menu_create(szMenuTitle, "MenuHandle_Weapon");
	new callBack = menu_makecallback("MenuCallback_Weapon");
	for(new index = 0, lastStage = ASAMA_YOK, totalweapon = -1, bool:stopfix; index < sizeof(Asama_Silahlari); index++)
	{
		if(lastStage != Asama_Silahlari[index][2])
		{
			if(!stopfix)
			{
				if(totalweapon == -1) totalweapon++
				else {
					if(totalweapon < 6)
					{
						for(new index2 = totalweapon; index2 < 6; index2++) 
							menu_additem(stageWeaponMENU, "-", "bosluk", _, callBack);
					} if(totalweapon > 6) {
						stopfix = true;
					}
					totalweapon = 0;
				}
			}

			lastStage = Asama_Silahlari[index][2];
			menu_additem(stageWeaponMENU, fmt("stage%i", lastStage), fmt("stage%i", lastStage), _, callBack);
		}

		totalweapon++;
		menu_additem(stageWeaponMENU, fmt("%i", index), fmt("%i", index), _, callBack);
	}
}

public MenuCallback_Weapon(const clientIndex, const iMenu, const Item)
{
	new szInfo[12], szMenuItem_Name[128];
	menu_item_getinfo(iMenu, Item, _, szInfo, charsmax(szInfo), _, _, _);

	if(equal(szInfo, "bosluk"))
	{
		return ITEM_DISABLED;
	}

	if(contain(szInfo, "stage") != -1)
	{
		new stageLevel = str_to_num(szInfo[5]);
		formatex(szMenuItem_Name, charsmax(szMenuItem_Name), "%s%L", currentSTAGE >= stageLevel ? "\r" : "\d", clientIndex, fmt("WEAPON_MENU_STAGE%i", stageLevel+1));
		menu_item_setname(iMenu, Item, szMenuItem_Name);
		return ITEM_DISABLED;
	}

	new weaponCode = str_to_num(szInfo);
	new stageLevel = Asama_Silahlari[weaponCode][2];

	new szWeaponName[32], szPistolName[32]; 
	if(Asama_Silahlari[weaponCode][0] != -1) formatex(szWeaponName, charsmax(szWeaponName), Weapon_Info[Asama_Silahlari[weaponCode][0]][WEAPON_NAME]);
	if(Asama_Silahlari[weaponCode][1] != -1) formatex(szPistolName, charsmax(szPistolName), Weapon_Info[Asama_Silahlari[weaponCode][1]][WEAPON_NAME]);

	if(Asama_Silahlari[weaponCode][0] != -1 && Asama_Silahlari[weaponCode][1] != -1) formatex(szMenuItem_Name, charsmax(szMenuItem_Name), "%s + %s + %i %L", szWeaponName, szPistolName, Asama_Silahlari[weaponCode][3], clientIndex, "WEAPON_MENU_HEAL");
	else if(Asama_Silahlari[weaponCode][0] == -1 && Asama_Silahlari[weaponCode][1] != -1) formatex(szMenuItem_Name, charsmax(szMenuItem_Name), "%s + %i %L", szPistolName, Asama_Silahlari[weaponCode][3], clientIndex, "WEAPON_MENU_HEAL");
	else if(Asama_Silahlari[weaponCode][0] != -1 && Asama_Silahlari[weaponCode][1] == -1) formatex(szMenuItem_Name, charsmax(szMenuItem_Name), "%s + %i %L", szWeaponName, Asama_Silahlari[weaponCode][3], clientIndex, "WEAPON_MENU_HEAL");
	else formatex(szMenuItem_Name, charsmax(szMenuItem_Name), "%i %L", Asama_Silahlari[weaponCode][3], clientIndex, "WEAPON_MENU_HEAL");

	if(currentSTAGE > stageLevel)
	{
		if(stageLevel != ASAMA_1)
		{
			menu_item_setname(iMenu, Item, fmt("\d%s", szMenuItem_Name));
			return ITEM_DISABLED;
		}
	}

	if(weaponCode == MyStageWeapons[clientIndex][stageLevel])
	{
		menu_item_setname(iMenu, Item, fmt("\y%s", szMenuItem_Name));
		return ITEM_ENABLED;
	}

	menu_item_setname(iMenu, Item, szMenuItem_Name);
	return ITEM_ENABLED;
}

public Show_WeaponMenu(const clientIndex)
{
	if(bUpdateMenu[clientIndex])
	{
		lastPage[clientIndex] = currentSTAGE;
		bUpdateMenu[clientIndex] = false;
	}

	menu_setprop(stageWeaponMENU, MPROP_TITLE, fmt("%L", clientIndex, "WEAPON_MENUTITLE"));
	menu_setprop(stageWeaponMENU, MPROP_BACKNAME, fmt("\w%L", clientIndex, "BACK_MENU_STAGE"));
	menu_setprop(stageWeaponMENU, MPROP_NEXTNAME, fmt("\w%L", clientIndex, "NEXT_MENU_STAGE"));
	menu_setprop(stageWeaponMENU, MPROP_EXITNAME, fmt("\w%L", clientIndex, "EXIT_MENU"));
	menu_display(clientIndex, stageWeaponMENU, lastPage[clientIndex]);
}

public Agent_Menu(const clientIndex)
{
	if(TEAM_ATTACKERS <= get_user_team(clientIndex) <= TEAM_DEFENDERS)
	{
		Main_Menu(clientIndex)
		return PLUGIN_HANDLED;
	}

	return PLUGIN_CONTINUE;
}

public MenuHandle_Weapon(const clientIndex, const iMenu, const iItem)
{
	if(iItem == MENU_EXIT)
	{
		return;
	}
	
	Log("%s/MenuHandle_Weapon", PLUGIN);

	new szInfo[12];
	menu_item_getinfo(iMenu, iItem, _, szInfo, charsmax(szInfo), _, _, _);

	new weaponCode = str_to_num(szInfo);
	new stageLevel = Asama_Silahlari[weaponCode][2];

	if(MyStageWeapons[clientIndex][stageLevel] == weaponCode)
		return;

	MyStageWeapons[clientIndex][stageLevel] = weaponCode;
	lastPage[clientIndex] = stageLevel;

	if(playerInBASE[clientIndex] && is_user_alive(clientIndex) && stageLevel <= currentSTAGE)
	{
		if(stageLevel == currentSTAGE)
		{
			if(!playerDECAY[clientIndex]) set_entvar(clientIndex, var_health, float(Asama_Silahlari[weaponCode][3]));
			set_entvar(clientIndex, var_max_health, float(Asama_Silahlari[weaponCode][3]));
		}

		new weaponID = Asama_Silahlari[weaponCode][1];
		if(weaponID != NULLENT)
		{
			set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 0);
		} else if(currentSTAGE > ASAMA_1) {
			weaponID = Asama_Silahlari[MyStageWeapons[clientIndex][ASAMA_1]][1];
			if(weaponID != NULLENT)
			{
				set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 0);
			} 
		} 

		weaponID = Asama_Silahlari[weaponCode][0];
		if(weaponID != NULLENT)
		{
			set_entvar(rg_give_custom_item(clientIndex, Weapon_Info[weaponID][WEAPON_ENTITY_NAME], GT_REPLACE, weaponID), var_orbweapon, 0);
		} else if(stageLevel != ASAMA_1){
			rg_remove_items_by_slot(clientIndex, PRIMARY_WEAPON_SLOT);
		}
	}
}

public Color_Chat(const clientIndex, const print_team, const message[], any:...)
{
	static szMessage[256]; vformat(szMessage, charsmax(szMessage), message, 4);

	replace_all(szMessage, charsmax(szMessage), "!g", "^x04");
	replace_all(szMessage, charsmax(szMessage), "!n", "^x01");
	replace_all(szMessage, charsmax(szMessage), "!t", "^x03");

	client_print_color(clientIndex, print_team, szMessage);
}

public Create_View_Sprite(const clientIndex, const szSprite[], const AttachmentID, const Effects, const Float:fScale, const Float:fDelayTime, const Float:fShowTime, const Float:fFramerate, const Float:fMaxFrame, const Float:fThinkTime, const bool:Loop, const parentIndex, const bool:bRemoveDeploy)
{
	Log("%s/Create_View_Sprite", PLUGIN);

	new spriteEntity = rg_create_entity("env_sprite");
	if (!is_nullent(spriteEntity))
   	{
		if(clientIndex <= 0 && parentIndex <= 0)
		{
			bEntityFullPack[spriteEntity] = true;
		}
 
		engfunc(EngFunc_SetModel, spriteEntity, szSprite),
		set_entvar(spriteEntity, var_rendermode, kRenderTransAdd);  
		set_entvar(spriteEntity, var_renderamt, fDelayTime > 0.0 ? 0.1 : 255.0);   
		set_entvar(spriteEntity, var_scale, fScale);

		set_entvar(spriteEntity, var_movetype, MOVETYPE_FOLLOW);
		if(parentIndex > 0)
		{
			set_entvar(spriteEntity, var_aiment, parentIndex);   
			set_entvar(spriteEntity, var_skin, parentIndex); 
		}    

		set_entvar(spriteEntity, var_body, AttachmentID); 
		set_entvar(spriteEntity, var_effects, EF_FORCEVISIBILITY | Effects);

		if(fFramerate > 0.0 && fMaxFrame > 0.0) 
		{
			new Float:fData[3];
			fData[0] = fFramerate; 
			fData[1] = fMaxFrame;
			fData[2] = fThinkTime;
			set_entvar(spriteEntity, var_vuser1, fData);
			set_entvar(spriteEntity, var_iuser1, Loop ? 1 : 0);

			SetThink(spriteEntity, "Think_Sprite");
			set_entvar(spriteEntity, var_nextthink, get_gametime()+fDelayTime);
		}

		if(clientIndex > 0 && clientIndex <= MAX_PLAYERS)
		{
			set_entvar(spriteEntity, var_owner, clientIndex); 

			ChildrenParent_Entity(clientIndex, spriteEntity);
			if(bRemoveDeploy)
			{
				if(ArrayFindValue(ArrayWillRemoveEntities[clientIndex], spriteEntity) == -1)
				{
					ArrayPushCell(ArrayWillRemoveEntities[clientIndex], spriteEntity);
					iTotalWillRemoveEntities[clientIndex]++;
				}
			}
		}

		bEntitySprite[spriteEntity] = true;
		remove_task(spriteEntity+TASK_VIEWSPRITE, 1);

		if(parentIndex > 0) RequestFrame("Think_CheckSprite", spriteEntity);
		if(fDelayTime > 0.0) 
		{
			new params[1]; params[0] = spriteEntity;
			set_task(fDelayTime, "Show_Sprite", spriteEntity+TASK_VIEWSPRITE, params, sizeof(params));
			if(fShowTime > 0.0) UTIL_RemoveEntity(spriteEntity, fDelayTime+fShowTime);
		} else if(fShowTime > 0.0) {
			UTIL_RemoveEntity(spriteEntity, fShowTime);
		} 

		return spriteEntity;
	}
	return NULLENT;
}

public Think_CheckSprite(SpriteEntity)
{
	if(is_nullent(SpriteEntity))
		return;
	if(get_entvar(SpriteEntity, var_flags) & FL_KILLME)	
		return;

	new clientIndex = get_entvar(SpriteEntity, var_owner);
	if(cs_get_user_zoom(clientIndex) > CS_SET_NO_ZOOM && get_viewent(clientIndex) == clientIndex)
	{
		if(!(get_entvar(SpriteEntity, var_effects) & EF_NODRAW)) set_entvar(SpriteEntity, var_effects, get_entvar(SpriteEntity, var_effects) | EF_NODRAW);
	} else if(get_entvar(SpriteEntity, var_effects) & EF_NODRAW) {
		set_entvar(SpriteEntity, var_effects, get_entvar(SpriteEntity, var_effects) & ~EF_NODRAW);
	}

	RequestFrame("Think_CheckSprite", SpriteEntity);
}

public Show_Sprite(params[], taskid)
{
	new entityIndex = params[0];

	Log("%s/Show_Sprite", PLUGIN);

	set_entvar(entityIndex, var_renderamt, 255.0);
}

public Think_Sprite(const entityIndex)
{
	static Float:Frame, Float:fData[3]; Frame = get_entvar(entityIndex, var_frame);
	get_entvar(entityIndex, var_vuser1, fData);

	if((Frame += fData[0]) > fData[1]) 
	{
		if(get_entvar(entityIndex, var_iuser1)) Frame = 0.0;
		else {
			UTIL_RemoveEntity(entityIndex, 0.0);
			return;
		}
	} 
	set_entvar(entityIndex, var_frame, Frame);
	set_entvar(entityIndex, var_nextthink, get_gametime() + fData[2]);
}

bool:CanSee(const clientIndex, const targetIndex)
{
	static flags; flags = get_entvar(targetIndex, var_flags);
	if (flags & EF_NODRAW || flags & FL_NOTARGET)
	{
		return false;
	}

	static Float:lookerOrig[3];
	static Float:targetBaseOrig[3];
	static Float:targetOrig[3];
	static Float:temp[3];

	get_entvar(clientIndex, var_origin, lookerOrig);
	get_entvar(clientIndex, var_view_ofs, temp);
	xs_vec_add(lookerOrig, temp, lookerOrig);

	get_entvar(targetIndex, var_origin, targetBaseOrig);
	get_entvar(targetIndex, var_view_ofs, temp);
	xs_vec_add(targetBaseOrig, temp, targetOrig);

	engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, IGNORE_MONSTERS, clientIndex, 0);
	if (get_tr2(0, TraceResult:TR_InOpen) && get_tr2(0, TraceResult:TR_InWater))
	{
		return false;
	} 
	else 
	{
		static Float:flFraction;
		get_tr2(0, TraceResult:TR_flFraction, flFraction);
		if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
		{
			return true;
		}
		else
		{
			targetOrig = targetBaseOrig;
			engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, IGNORE_MONSTERS, clientIndex, 0); 
			get_tr2(0, TraceResult:TR_flFraction, flFraction);
			if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
			{
				return true;
			}
	
			targetOrig = targetBaseOrig;
			targetOrig[2] += 20.0;
			engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, IGNORE_MONSTERS, clientIndex, 0); 
			get_tr2(0, TraceResult:TR_flFraction, flFraction);
			if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
			{
				return true;
			}

			targetOrig = targetBaseOrig;
			targetOrig[2] -= 17.0;
			engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, IGNORE_MONSTERS, clientIndex, 0); 
			get_tr2(0, TraceResult:TR_flFraction, flFraction);
			if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
			{
				return true;
			}

			targetOrig = targetBaseOrig;
			GetPosition(0, 0.0, 20.0, 0.0, targetOrig, Float:{0.0, 0.0, 0.0}, false, targetOrig, true);
			engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, IGNORE_MONSTERS, clientIndex, 0); 
			get_tr2(0, TraceResult:TR_flFraction, flFraction);
			if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
			{
				return true;
			}

			targetOrig = targetBaseOrig;
			GetPosition(0, 0.0, -20.0, 0.0, targetOrig, Float:{0.0, 0.0, 0.0}, false, targetOrig, true);
			engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, IGNORE_MONSTERS, clientIndex, 0); 
			get_tr2(0, TraceResult:TR_flFraction, flFraction);
			if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
			{
				return true;
			}
	
			targetOrig = targetBaseOrig;
			GetPosition(0, -20.0, 0.0, 0.0, targetOrig, Float:{0.0, 0.0, 0.0}, false, targetOrig, true);
			engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, IGNORE_MONSTERS, clientIndex, 0); 
			get_tr2(0, TraceResult:TR_flFraction, flFraction);
			if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
			{
				return true;
			}

			targetOrig = targetBaseOrig;
			GetPosition(0, 20.0, 0.0, 0.0, targetOrig, Float:{0.0, 0.0, 0.0}, false, targetOrig, true);
			engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, IGNORE_MONSTERS, clientIndex, 0); 
			get_tr2(0, TraceResult:TR_flFraction, flFraction);
			if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
			{
				return true;
			}
		}
	}
	return false;
}

public HAM_BuckShoot_TraceAttack_Post(const clientIndex, const attackerIndex, Float:fDamage, const Float:vDirection[3], const iTracehandle, const iDamageType)
{
	static Float:vecEnd[3];	get_tr2(iTracehandle, TR_vecEndPos, vecEnd);	
	static Float:vecStart[3]; 
	if(attackerIndex > 0 && attackerIndex <= MaxClients) GetEyePosition(attackerIndex, vecStart);	
	OnPenetrableEntity_Post(vecStart, vecEnd, attackerIndex, clientIndex);
}

public OnPenetrableEntity_Post(const Float:vecStart[3], Float:vecEnd[3], const clientIndex, const victimIndex)
{
	Log("%s/OnPenetrableEntity_Post", PLUGIN);

	static Float:vecPlaneNormal[3]; global_get(glb_trace_plane_normal, vecPlaneNormal);
	if(is_user_connected(victimIndex) || (victimIndex > MaxClients && entityBARRIER[victimIndex]))
	{
		new weaponEntity = currentWeaponENTITY[clientIndex];
		if(weaponEntity != NULLENT)
		{
			new Float:vecStart2[3]; 
			new impulse = get_entvar(weaponEntity, var_impulse);
			if(impulse == OPERATOR || impulse == MARSHALL)
			{
				GetPosition(clientIndex, 30.0, 12.0, -6.0, vecStart2, Float:{0.0, 0.0, 0.0}, false, vecStart, true);
				Create_Trace(clientIndex, vecStart2, vecEnd, 0.0, 3, 5, 255);
			} else {
				GetPosition(clientIndex, 0.0, get_entvar(weaponEntity, var_weapon_zoom) ? 0.0 : 12.0, -6.0, vecStart2, Float:{0.0, 0.0, 0.0}, false, vecStart, true);
				Create_Trace(clientIndex, vecStart2, vecEnd, 0.0, 1, impulse == PHANTOM || impulse == SPECTRE || impulse == GHOST ? 0 : 5, 255);
			}
		}

		if(victimIndex > MaxClients)
		{
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
			write_byte(TE_STREAK_SPLASH);
			write_coord_f(vecEnd[0]);
			write_coord_f(vecEnd[1]);
			write_coord_f(vecEnd[2]);
			write_coord_f(vecPlaneNormal[0] * random_float(25.0, 30.0));
			write_coord_f(vecPlaneNormal[1] * random_float(25.0, 30.0));
			write_coord_f(vecPlaneNormal[2] * random_float(25.0, 30.0));
			write_byte(0);
			write_short(6);
			write_short(3);
			write_short(75);
			message_end();

			if(is_user_connected(clientIndex))
			{
				static Float:delaysound;
				if(delaysound <= get_gametime())
				{
					rh_emit_sound(victimIndex, clientIndex, CHAN_STATIC, Barrier_Hit[random_num(0, sizeof(Barrier_Hit)-1)], 0.6, ATTN_NONE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
					delaysound = get_gametime() + 0.1;
				}
			}
		}
		return;
	}
	static iPointContents; iPointContents = engfunc(EngFunc_PointContents, vecEnd);
	if(iPointContents == CONTENTS_SKY)
		return;
	if(victimIndex && is_nullent(victimIndex) || (get_entvar(victimIndex, var_flags) & FL_KILLME))
		return;
	if(!ExecuteHam(Ham_IsBSPModel, victimIndex) || get_entvar(victimIndex, var_takedamage) == DAMAGE_YES)
		return;

	new weaponEntity = currentWeaponENTITY[clientIndex];
	if(weaponEntity != NULLENT)
	{
		new Float:vecStart2[3]; 
		new impulse = get_entvar(weaponEntity, var_impulse);
		if(impulse == OPERATOR || impulse == MARSHALL)
		{
			GetPosition(clientIndex, 30.0, 12.0, -6.0, vecStart2, Float:{0.0, 0.0, 0.0}, false, vecStart, true);
			Create_Trace(clientIndex, vecStart2, vecEnd, 0.0, 3, 5, 255);
		} else {
			GetPosition(clientIndex, 0.0, get_entvar(weaponEntity, var_weapon_zoom) ? 0.0 : 12.0, -6.0, vecStart2, Float:{0.0, 0.0, 0.0}, false, vecStart, true);
			Create_Trace(clientIndex, vecStart2, vecEnd, 0.0, 1, impulse == PHANTOM || impulse == SPECTRE || impulse == GHOST ? 0 : 5, 255);
		}
	}

	GunshotDecalTrace(victimIndex, vecEnd);

	xs_vec_mul_scalar(vecPlaneNormal, 7.5, vecPlaneNormal);

	static Float:vSmokeOrigin[3];
	xs_vec_add(vecEnd, vecPlaneNormal, vSmokeOrigin);

	if(vecEnd[2] < vSmokeOrigin[2]) vSmokeOrigin[2] -= 15.0;
	else vSmokeOrigin[2] -= 7.5;

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(TE_STREAK_SPLASH);
	write_coord_f(vecEnd[0]);
	write_coord_f(vecEnd[1]);
	write_coord_f(vecEnd[2]);
	write_coord_f(vecPlaneNormal[0]);
	write_coord_f(vecPlaneNormal[1]);
	write_coord_f(vecPlaneNormal[2]);
	write_byte(5);
	write_short(random_num(10, 20));
	write_short(3);
	write_short(64);
	message_end();
	
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(TE_SMOKE);
	write_coord_f(vSmokeOrigin[0]);
	write_coord_f(vSmokeOrigin[1]);
	write_coord_f(vSmokeOrigin[2] - 15.0);
	write_short(wallPuffEffect);
	write_byte(2);
	write_byte(45);
	message_end();
}

stock GunshotDecalTrace(const entityIndex, const Float:vecOrigin[3])
{	
	new iDecalId = UTIL_DamageDecal(entityIndex);
	if (iDecalId == -1) return;

	message_begin_f(MSG_PAS, SVC_TEMPENTITY, vecOrigin, 0);
	write_byte(TE_GUNSHOTDECAL);
	write_coord_f(vecOrigin[0]);
	write_coord_f(vecOrigin[1]);
	write_coord_f(vecOrigin[2]);
	write_short(entityIndex);
	write_byte(iDecalId);
	message_end();
}

stock UTIL_DamageDecal(const entityIndex)
{
	new iRenderMode = get_entvar(entityIndex, var_rendermode);
	if (iRenderMode == kRenderTransAlpha)
		return -1;

	static iGlassDecalId; if (!iGlassDecalId) iGlassDecalId = engfunc(EngFunc_DecalIndex, "{bproof1");
	if (iRenderMode != kRenderNormal)
		return iGlassDecalId;

	static iShotDecalId; if(!iShotDecalId) iShotDecalId = engfunc(EngFunc_DecalIndex, "{shot1");
	return (iShotDecalId - random_num(0, 4));
}

// Stocks
enum {
    // Edict
    GL_trace_ent = 0,

    // Float
    GL_coop,
    GL_deathmatch,
    GL_force_retouch,
    GL_found_secrets,
    GL_frametime,
    GL_serverflags,
    GL_teamplay,
    GL_time,
    GL_trace_allsolid,
    GL_trace_fraction,
    GL_trace_inopen,
    GL_trace_inwater,
    GL_trace_plane_dist,
    GL_trace_startsolid,

    // Int
    GL_cdAudioTrack,
    GL_maxClients,
    GL_maxEntities,
    GL_msg_entity,
    GL_trace_flags,
    GL_trace_hitgroup,

    // String
    GL_pStringBase,
    GL_mapname,
    GL_startspot,

    // Vector
    GL_trace_endpos,
    GL_trace_plane_normal,
    GL_v_forward,
    GL_v_right,
    GL_v_up,
    GL_vecLandmarkOffset,

    // Void (not supported)
    GL_pSaveData
};

native get_global_vector(variable, Float:vector[3]);
stock GetVectorAiming(const clientIndex, Float:vecAiming[3]) 
{
	static Float:vecAngles[3], Float:punchAngle[3]; 
	
	if(bRealBot[clientIndex]) 
	{
		new Float:vVector[3], Float:vOrigin[3]; GetEyePosition(clientIndex, vOrigin);
		xs_vec_sub(vOrigin, vLastRandom[clientIndex], vVector);
		xs_vec_normalize(vVector, vVector);
		vector_to_angle(vVector, vecAngles);
		vecAngles[1] -= 180.0;
		get_entvar(clientIndex, var_punchangle, punchAngle);
		xs_vec_add(vecAngles, punchAngle, vecAngles);
	} else get_entvar(clientIndex, var_v_angle, vecAngles);

	engfunc(EngFunc_MakeVectors, vecAngles);

	get_global_vector(GL_v_forward, vecAiming);
	xs_vec_mul_scalar(vecAiming, 1.0, vecAiming);
}

stock GetEyePosition(const clientIndex, Float:vecEyeLevel[3])
{
	static Float:vecOrigin[3]; get_entvar(clientIndex, var_origin, vecOrigin);
	static Float:vecViewOfs[3]; get_entvar(clientIndex, var_view_ofs, vecViewOfs);

	xs_vec_add(vecOrigin, vecViewOfs, vecEyeLevel);
}

public ReadyForBuckShoot(bool:enable)
{
	if(enable)
	{
		for(new i; i < sizeof(fwBuckShootTraceAttack_Post); i++)
		{
			EnableHamForward(fwBuckShootTraceAttack_Post[i]);
		}
	} else {
		for(new i; i < sizeof(fwBuckShootTraceAttack_Post); i++)
		{
			DisableHamForward(fwBuckShootTraceAttack_Post[i]);
		}
	}
}

FireBulletsPlayer(weaponEntity, cShots, Float:vecSrc[3], Float:vecDirShooting[3], Float:vecSpread[3], Float:flDistance, Float:flDamage, Float:flRangeModifier, attackerIndex, Float:vecOut[3]) 
{
	new clientIndex = get_member(weaponEntity, m_pPlayer);
	new shared_rand = clientIndex > 0 ? get_member(clientIndex, random_seed) : 0;

	new pTr = create_tr2();

	static Float:vecRight[3];
	get_global_vector(GL_v_right, vecRight);

	static Float:vecUp[3];
	get_global_vector(GL_v_up, vecUp);

	static Float:vecMultiplier[3];

	if (!attackerIndex) {
		attackerIndex = weaponEntity;    
	}

	for (new iShot = 1; iShot <= cShots; iShot++) {
		vecMultiplier[0] = SharedRandomFloat( shared_rand + iShot, -0.5, 0.5 ) + SharedRandomFloat( shared_rand + ( 1 + iShot ) , -0.5, 0.5 );
		vecMultiplier[1] = SharedRandomFloat( shared_rand + ( 2 + iShot ), -0.5, 0.5 ) + SharedRandomFloat( shared_rand + ( 3 + iShot ), -0.5, 0.5 );
		vecMultiplier[2] = vecMultiplier[0] * vecMultiplier[0] + vecMultiplier[1] * vecMultiplier[1];

		static Float:vecDir[3];
		for (new i = 0; i < 3; ++i) {
			vecDir[i] = vecDirShooting[i] + (vecMultiplier[0] * vecSpread[0] * vecRight[i]) + (vecMultiplier[1] * vecSpread[1] * vecUp[i]);
		}

		static Float:vecEnd[3];
		for (new i = 0; i < 3; ++i) {
			vecEnd[i] = vecSrc[i] + (vecDir[i] * flDistance);
		}

		engfunc(EngFunc_TraceLine, vecSrc, vecEnd, DONT_IGNORE_MONSTERS, weaponEntity, pTr);

		new Float:flFraction;
		get_tr2(pTr, TR_flFraction, flFraction);
		
		get_tr2(pTr, TR_vecEndPos, vecEnd);

		// do damage, paint decals
		if (flFraction != 1.0) {
			new pHit = get_tr2(pTr, TR_pHit);

			if (pHit < 0) {
				pHit = 0;
			}

			new Float:flCurrentDistance = flDistance * flFraction;
			new Float:flCurrentDamage = flDamage * floatpower(flRangeModifier, flCurrentDistance / 500.0);

			rg_multidmg_clear();
			ExecuteHamB(Ham_TraceAttack, pHit, attackerIndex, flCurrentDamage, vecDir, pTr, DMG_BULLET | DMG_NEVERGIB);
			OnPenetrableEntity_Post(vecSrc, vecEnd, attackerIndex, pHit);
			rg_multidmg_apply(weaponEntity, attackerIndex);
		}
	}

	vecOut[0] = vecMultiplier[0] * vecSpread[0];
	vecOut[1] = vecMultiplier[1] * vecSpread[1];
	vecOut[2] = 0.0;

	free_tr2(pTr);
}

new const seed_table[256] = {
    28985, 27138, 26457, 9451, 17764, 10909, 28790, 8716, 6361, 4853, 17798, 21977, 19643, 20662, 10834, 20103,
    27067, 28634, 18623, 25849, 8576, 26234, 23887, 18228, 32587, 4836, 3306, 1811, 3035, 24559, 18399, 315,
    26766, 907, 24102, 12370, 9674, 2972, 10472, 16492, 22683, 11529, 27968, 30406, 13213, 2319, 23620, 16823,
    10013, 23772, 21567, 1251, 19579, 20313, 18241, 30130, 8402, 20807, 27354, 7169, 21211, 17293, 5410, 19223,
    10255, 22480, 27388, 9946, 15628, 24389, 17308, 2370, 9530, 31683, 25927, 23567, 11694, 26397, 32602, 15031,
    18255, 17582, 1422, 28835, 23607, 12597, 20602, 10138, 5212, 1252, 10074, 23166, 19823, 31667, 5902, 24630,
    18948, 14330, 14950, 8939, 23540, 21311, 22428, 22391, 3583, 29004, 30498, 18714, 4278, 2437, 22430, 3439,
    28313, 23161, 25396, 13471, 19324, 15287, 2563, 18901, 13103, 16867, 9714, 14322, 15197, 26889, 19372, 26241,
    31925, 14640, 11497, 8941, 10056, 6451, 28656, 10737, 13874, 17356, 8281, 25937, 1661, 4850, 7448, 12744,
    21826, 5477, 10167, 16705, 26897, 8839, 30947, 27978, 27283, 24685, 32298, 3525, 12398, 28726, 9475, 10208,
    617, 13467, 22287, 2376, 6097, 26312, 2974, 9114, 21787, 28010, 4725, 15387, 3274, 10762, 31695, 17320,
    18324, 12441, 16801, 27376, 22464, 7500, 5666, 18144, 15314, 31914, 31627, 6495, 5226, 31203, 2331, 4668,
    12650, 18275, 351, 7268, 31319, 30119, 7600, 2905, 13826, 11343, 13053, 15583, 30055, 31093, 5067, 761,
    9685, 11070, 21369, 27155, 3663, 26542, 20169, 12161, 15411, 30401, 7580, 31784, 8985, 29367, 20989, 14203,
    29694, 21167, 10337, 1706, 28578, 887, 3373, 19477, 14382, 675, 7033, 15111, 26138, 12252, 30996, 21409,
    25678, 18555, 13256, 23316, 22407, 16727, 991, 9236, 5373, 29402, 6117, 15241, 27715, 19291, 19888, 19847
};

Float:SharedRandomFloat(seed, Float:low, Float:high) {
    new Float:range = high - low;
    if (!range) {
        return low;
    }

    new glSeed = U_Srand(seed + floatround(low) + floatround(high));
    U_Random(glSeed);
    U_Random(glSeed);

    new tensixrand = U_Random(glSeed) & 65535;
    new Float:offset = float(tensixrand) / 65536.0;

    return (low + offset * range );
}

U_Random(&glSeed)    {
    glSeed *= 69069; 
    glSeed += seed_table[glSeed & 0xff];

    return (++glSeed & 0x0fffffff);
}

U_Srand(seed) {
    return seed_table[seed & 0xff];
}

Create_Trace(const clientIndex, const Float:vStartOrigin[3], const Float:vEndOrigin[3], const Float:fSpeed, const Life, const Color, const Length)
{
	static Float:vVelocity[3], Float:fTime;

	if(fSpeed <= 0.0) fTime = 3.0;
	else fTime = get_distance_f(vStartOrigin, vEndOrigin) / fSpeed;

	vVelocity[0] = (vStartOrigin[0] - vEndOrigin[0]) / fTime;
	vVelocity[1] = (vStartOrigin[1] - vEndOrigin[1]) / fTime;
	vVelocity[2] = (vStartOrigin[2] - vEndOrigin[2]) / fTime;
	
	if(clientIndex > 0) message_begin_f(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, vEndOrigin, clientIndex);
	else message_begin_f(MSG_BROADCAST, SVC_TEMPENTITY, vEndOrigin, 0);
	write_byte(TE_USERTRACER);
	write_coord_f(vEndOrigin[0]);
	write_coord_f(vEndOrigin[1]);
	write_coord_f(vEndOrigin[2]);
	write_coord_f(vVelocity[0]);
	write_coord_f(vVelocity[1]);
	write_coord_f(vVelocity[2]);
	write_byte(Life);
	write_byte(clamp(Color, 0, 12));
	write_byte(Length);
	message_end();
}    

enum spreadActivities
{
	Act_NormalShoot = 0,
	Act_OnAir,
	Act_OnMove,
	Act_Ducking,
	Act_Shift
};

public CBasePlayerWeapon__Fire(const weaponEntity)
{
	Log("%s/CBasePlayerWeapon__Fire", PLUGIN);
	
	new clientIndex = get_entvar(weaponEntity, var_owner);
	SemiclipEntity(clientIndex);
	static Float:vecSrc[3]; GetEyePosition(clientIndex, vecSrc);
	static Float:vecAiming[3]; GetVectorAiming(clientIndex, vecAiming);
	static iShotsFired; iShotsFired = get_member(weaponEntity, m_Weapon_iShotsFired) + 1;

	set_member(weaponEntity, m_Weapon_iShotsFired, iShotsFired);

	new weaponCode = get_entvar(weaponEntity, var_impulse);
	switch(weaponCode)
	{
		case BUCKY:
		{
			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, 0.0, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));

			get_entvar(clientIndex, var_punchangle, vecAiming);
			vecAiming[0] -= 7.0; 
			set_entvar(clientIndex, var_punchangle, vecAiming);		
		}
		case CLASSIC:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/
			GetSpreadByAction(weaponEntity, Float:{0.016, 7.0, 2.1, 0.8, 1.6}, 30.0); 
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);
			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.3);
			}*/

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			get_entvar(clientIndex, var_punchangle, vecAiming);
			vecAiming[0] -= 1.0; 
			set_entvar(clientIndex, var_punchangle, vecAiming);		
		}
		case GHOST:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/
			GetSpreadByAction(weaponEntity, Float:{0.016, 7.0, 3.2, 0.8, 2.0}, 30.0); 
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.3);
			}*/

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			get_entvar(clientIndex, var_punchangle, vecAiming);
			vecAiming[0] -= 2.0; 
			set_entvar(clientIndex, var_punchangle, vecAiming);		
		}
		case SHERRIF:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/
			GetSpreadByAction(weaponEntity, Float:{0.01, 8.0, 4.0, 0.8, 2.5}, 30.0); 
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.3);
			}*/

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			get_entvar(clientIndex, var_punchangle, vecAiming);
			vecAiming[0] -= 5.0; 
			set_entvar(clientIndex, var_punchangle, vecAiming);		
		}
		case FRENZY:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/
			new spreadActivities:Act = GetSpreadByAction(weaponEntity, Float:{0.02, 7.0, 2.0, 0.8, 1.5}, 30.0); 
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.3);
			}*/

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			if(iShotsFired == ((iShotsFired/4)*4))
				set_member(weaponEntity, m_Weapon_iDirection, get_member(weaponEntity, m_Weapon_iDirection) == -1 ? random_num(0, 1) : get_member(weaponEntity, m_Weapon_iDirection) ? 0 : 1);
			
			switch(Act)
			{	
				/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
				case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 8.0, 2.5);
				case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
				case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 5.0, 2.5);
				case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 6.0, 2.5);
			} 	
		}
		case VANDAL:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/

			new spreadActivities:Act = GetSpreadByAction(weaponEntity, Float:{0.012, 13.0, 8.0, 0.8, 3.0}, 30.0); 
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.3);
			}
*/
			if(get_entvar(weaponEntity, var_weapon_zoom)) fLastValue *= 0.9;

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			if(iShotsFired == ((iShotsFired/8)*8))
				set_member(weaponEntity, m_Weapon_iDirection, get_member(weaponEntity, m_Weapon_iDirection) == -1 ? random_num(0, 1) : get_member(weaponEntity, m_Weapon_iDirection) ? 0 : 1);
			
			if(get_entvar(weaponEntity, var_weapon_zoom))
			{
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 8.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 6.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 6.0, 2.5);
				} 	
			} else {
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 9.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 8.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
				} 
			}
		}
		case PHANTOM:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/

			new spreadActivities:Act = GetSpreadByAction(weaponEntity, Float:{0.01, 13.0, 8.0, 0.8, 3.0}, 30.0); 
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.3);
			}*/

			if(get_entvar(weaponEntity, var_weapon_zoom)) fLastValue *= 0.9;

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			if(iShotsFired == ((iShotsFired/8)*8))
				set_member(weaponEntity, m_Weapon_iDirection, get_member(weaponEntity, m_Weapon_iDirection) == -1 ? random_num(0, 1) : get_member(weaponEntity, m_Weapon_iDirection) ? 0 : 1);
			
			if(get_entvar(weaponEntity, var_weapon_zoom))
			{
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.15, 7.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.15, 6.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.15, 5.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.15, 5.0, 2.5);
				} 	
			} else {
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.15, 8.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.15, 7.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.15, 6.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.15, 6.0, 2.5);
				} 
			}
		}
		case SPECTRE:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/

			new spreadActivities:Act = GetSpreadByAction(weaponEntity, Float:{0.0165, 10.0, 3.5, 0.8, 2.0}, 30.0); 
		/*	static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.8);
			}*/

			if(get_entvar(weaponEntity, var_weapon_zoom)) fLastValue *= 0.9;

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			if(iShotsFired == ((iShotsFired/6)*6))
				set_member(weaponEntity, m_Weapon_iDirection, get_member(weaponEntity, m_Weapon_iDirection) == -1 ? random_num(0, 1) : get_member(weaponEntity, m_Weapon_iDirection) ? 0 : 1);
			
			if(get_entvar(weaponEntity, var_weapon_zoom))
			{
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.1, 6.0, 1.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.1, 5.0, 1.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.1, 4.0, 1.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.1, 4.0, 1.5);
				} 	
			} else {
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.1, 6.0, 1.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.1, 5.0, 1.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.1, 4.0, 1.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.1, 4.0, 1.5);
				} 
			}
		}
		case ARES:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/

			new spreadActivities:Act = GetSpreadByAction(weaponEntity, Float:{0.025, 10.0, 6.0, 0.8, 2.4}, 30.0); 
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.3);
			}*/

			if(get_entvar(weaponEntity, var_weapon_zoom)) fLastValue *= 0.9;

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			if(iShotsFired == ((iShotsFired/10)*10))
				set_member(weaponEntity, m_Weapon_iDirection, get_member(weaponEntity, m_Weapon_iDirection) == -1 ? random_num(0, 1) : get_member(weaponEntity, m_Weapon_iDirection) ? 0 : 1);
			
			if(get_entvar(weaponEntity, var_weapon_zoom))
			{
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 10.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 8.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
				} 	
			} else {
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 10.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 8.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
				} 
			}
		}
		case ODIN:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/

			new spreadActivities:Act = GetSpreadByAction(weaponEntity, Float:{0.03, 10.0, 6.0, 0.8, 2.4}, 30.0); 
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.3);
			}*/

			if(get_entvar(weaponEntity, var_weapon_zoom)) fLastValue *= 0.9;

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			if(iShotsFired == ((iShotsFired/10)*10))
				set_member(weaponEntity, m_Weapon_iDirection, get_member(weaponEntity, m_Weapon_iDirection) == -1 ? random_num(0, 1) : get_member(weaponEntity, m_Weapon_iDirection) ? 0 : 1);
			
			if(get_entvar(weaponEntity, var_weapon_zoom))
			{
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 10.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 8.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
				} 	
			} else {
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.12, 10.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 8.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
				} 
			}
		}
		case STINGER:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/

			new spreadActivities:Act = GetSpreadByAction(weaponEntity, Float:{0.013, 10.0, 3.5, 0.8, 2.0}, 30.0); 
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.3);
			}*/

			if(get_entvar(weaponEntity, var_weapon_zoom)) fLastValue *= 1.2;

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			if(get_member(weaponEntity, m_Weapon_iDirection) == -1)
			{
				if(iShotsFired == ((iShotsFired/6)*6))
					set_member(weaponEntity, m_Weapon_iDirection, get_member(weaponEntity, m_Weapon_iDirection) == -1 ? random_num(0, 1) : get_member(weaponEntity, m_Weapon_iDirection) ? 0 : 1);
			} else {
				if(iShotsFired == ((iShotsFired/18)*18))
					set_member(weaponEntity, m_Weapon_iDirection, get_member(weaponEntity, m_Weapon_iDirection) == -1 ? random_num(0, 1) : get_member(weaponEntity, m_Weapon_iDirection) ? 0 : 1);
			}
			if(get_entvar(weaponEntity, var_weapon_zoom))
			{
				/*switch(Act)
				{	
					Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 1.5, 0.0, 4.0, 0.8, 10.0, 10.0);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 1.5, 0.0, 4.0, 0.6, 8.0, 8.0);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 1.5, 0.0, 4.0, 0.4, 6.0, 6.0);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 1.5, 0.0, 4.0, 0.4, 6.0, 6.0);
				} 	*/
				get_entvar(clientIndex, var_punchangle, vecAiming);
				vecAiming[0] -= 1.75; 
				set_entvar(clientIndex, var_punchangle, vecAiming);		
			} else {
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.6, 0.2, 8.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.6, 0.2, 7.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.6, 0.2, 6.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.6, 0.2, 6.0, 2.5);
				} 
			}
		}
		case BULLDOG:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/

			new spreadActivities:Act = GetSpreadByAction(weaponEntity, Float:{0.012, 10.0, 5.0, 0.8, 2.0}, 30.0); 
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.3);
			}*/

			if(get_entvar(weaponEntity, var_weapon_zoom)) fLastValue *= 0.9;

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));

			if(iShotsFired == ((iShotsFired/8)*8))
				set_member(weaponEntity, m_Weapon_iDirection, get_member(weaponEntity, m_Weapon_iDirection) == -1 ? random_num(0, 1) : get_member(weaponEntity, m_Weapon_iDirection) ? 0 : 1);
			
			if(get_entvar(weaponEntity, var_weapon_zoom))
			{
				/*switch(Act)
				{	
					Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 1.0, 0.0, 4.0, 0.2, 7.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 1.0, 0.0, 4.0, 0.2, 6.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 1.0, 0.0, 4.0, 0.2, 5.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 1.0, 0.0, 4.0, 0.2, 5.0, 2.5);
				} */
				get_entvar(clientIndex, var_punchangle, vecAiming);
				vecAiming[0] -= 1.0; 
				set_entvar(clientIndex, var_punchangle, vecAiming);		
			} else {
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 8.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 7.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 6.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 2.0, 0.0, 0.4, 0.2, 6.0, 2.5);
				} 
			}
		}
		case GUARDIAN:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/

			new spreadActivities:Act = GetSpreadByAction(weaponEntity, Float:{0.01, 10.0, 5.0, 0.8, 2.0}, 30.0); 
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.3);
			}*/

			if(get_entvar(weaponEntity, var_weapon_zoom)) fLastValue *= 0.9;

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			if(iShotsFired == ((iShotsFired/4)*4))
				set_member(weaponEntity, m_Weapon_iDirection, get_member(weaponEntity, m_Weapon_iDirection) == -1 ? random_num(0, 1) : get_member(weaponEntity, m_Weapon_iDirection) ? 0 : 1);
			
			if(get_entvar(weaponEntity, var_weapon_zoom))
			{
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 1.5, 0.0, 1.5, 0.2, 6.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 1.5, 0.0, 1.5, 0.2, 5.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 1.5, 0.0, 1.5, 0.2, 4.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 1.5, 0.0, 1.5, 0.2, 4.0, 2.5);
				} 	
			} else {
				switch(Act)
				{	
					/*Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax*/
					case Act_OnAir: WeaponKickBack(weaponEntity, clientIndex, 1.5, 0.0, 1.5, 0.2, 6.0, 2.5);
					case Act_OnMove, Act_Shift: WeaponKickBack(weaponEntity, clientIndex, 1.5, 0.0, 1.5, 0.2, 5.0, 2.5);
					case Act_Ducking: WeaponKickBack(weaponEntity, clientIndex, 1.5, 0.0, 1.5, 0.2, 4.0, 2.5);
					case Act_NormalShoot: WeaponKickBack(weaponEntity, clientIndex, 1.5, 0.0, 1.5, 0.2, 4.0, 2.5);
				} 
			}
		}
		case MARSHALL:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/
			if(get_entvar(weaponEntity, var_weapon_zoom))
			{
				GetSpreadByAction(weaponEntity, Float:{0.01, 200.0, 150.0, 0.8, 100.0}, 60.0); 
			} else {
				GetSpreadByAction(weaponEntity, Float:{0.03, 20.0, 15.0, 0.8, 10.0}, 60.0); 	
			}
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.3);
			}*/

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			get_entvar(clientIndex, var_punchangle, vecAiming);
			vecAiming[0] -= 5.0; 
			set_entvar(clientIndex, var_punchangle, vecAiming);		
		}
		case OPERATOR:
		{
			/*
				Act_NormalShoot = 0,
				Act_OnAir,
				Act_OnMove,
				Act_Ducking,
				Act_Shift
			*/
			if(get_entvar(weaponEntity, var_weapon_zoom))
			{
				GetSpreadByAction(weaponEntity, Float:{0.01, 150.0, 150.0, 0.8, 100.0}, 60.0); 
			} else {
				GetSpreadByAction(weaponEntity, Float:{0.1, 15.0, 15.0, 0.8, 10.0}, 60.0); 	
			}
			/*static Float:flAccuracy; flAccuracy = get_member(weaponEntity, m_Weapon_flAccuracy);

			if(iShotsFired) 
			{
				fLastValue += (iShotsFired*flAccuracy);
				fLastValue = floatclamp(fLastValue, 0.0, 0.6);
			}*/

			rg_fire_bullets3(weaponEntity, clientIndex, vecSrc, vecAiming, fLastValue, 4096.0, 1, BULLET_PLAYER_9MM, 40, 1.0, false, get_member(clientIndex, random_seed));
		
			get_entvar(clientIndex, var_punchangle, vecAiming);
			vecAiming[0] -= 7.0; 
			set_entvar(clientIndex, var_punchangle, vecAiming);		
		}
	}	
	
	rg_set_animation(clientIndex, PLAYER_ATTACK1);
	UnSemiclipEntity(clientIndex);		
}

public Task_Apply_Button(params[], taskid)
{
	new weaponEntity = params[0];

	new clientIndex = get_entvar(weaponEntity, var_owner), Impulse = get_entvar(weaponEntity, var_impulse), Float:Time = get_gametime(); 
	switch(Impulse)
	{
		case ARES:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 1.0 : 1.5;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.00175);
		}
		case BUCKY:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.6 : 1.0;
		}
		case BULLDOG:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.6 : 1.0;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.00175);
		}
		case CLASSIC:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.5 : 0.8;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.0125);
		}	
		case FRENZY:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.6 : 1.0;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.0025);
		}
		case GHOST:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.6 : 1.0;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.0025);
		}
		case GUARDIAN:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.8 : 1.2;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.00125);
		}
		case JUDGE:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.8 : 1.2;
		}
		case KNIFE:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.6 : 1.0;
		}
		case MARSHALL:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 1.0 : 1.5;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.025);
		}
		case ODIN:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 1.0 : 1.9;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.00175);
		}
		case OPERATOR:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 1.2 : 1.8;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.0325);
		}
		case PHANTOM:
		{	
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.8 : 1.2;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.00175);
		}
		case SHERRIF:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.8 : 1.2;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.0425);
		}
		case SHORTY:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.5 : 0.8;
		}
		case SPECTRE:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.6 : 1.0;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.0015);
		} 
		case STINGER:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.8 : 1.2;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.00175);
		}
		case VANDAL:
		{
			Time += (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.8 : 1.2;
			set_member(weaponEntity, m_Weapon_flAccuracy, 0.00225);
		}
	}	
	Time -= (bWeaponFast[clientIndex] || skillFastDRAW[clientIndex]) ? 0.5 : 0.4;
	if(skillFastDRAW[clientIndex]) skillFastDRAW[clientIndex] = false;
	SetThink(weaponEntity, "Think_Weapon_Buttons");
	set_entvar(weaponEntity, var_nextthink, Time); 
}

spreadActivities:GetSpreadByAction(const weaponIndex, const Float:flSpreadInActions[5], const Float:flMoveSpeed)
{
	fLastValue = Float:flSpreadInActions[Act_NormalShoot];

	new spreadActivities:Act;
	static clientIndex; clientIndex = get_member(weaponIndex, m_pPlayer);
	static bitsFlags; bitsFlags = get_entvar(clientIndex, var_flags);	
	static Float:vecVelocity[3]; get_entvar(clientIndex, var_velocity, vecVelocity);

	if (~bitsFlags & FL_ONGROUND)
	{	
		Act = Act_OnAir;
		fLastValue *= Float:flSpreadInActions[Act_OnAir];
	} else if(xs_vec_len_2d(vecVelocity) > flMoveSpeed) {
		if(xs_vec_len_2d(vecVelocity) > 200.0)
		{
			Act = Act_OnMove;
			fLastValue *= Float:flSpreadInActions[Act_OnMove];
		} else {
			Act = Act_Shift;
			fLastValue *= Float:flSpreadInActions[Act_Shift];
		}
	} else if(bitsFlags & FL_DUCKING && bitsFlags & FL_ONGROUND) {
		Act = Act_Ducking;
		fLastValue *= Float:flSpreadInActions[Act_Ducking];
	} else {
		Act = Act_NormalShoot;
	}

	return Act;
}

stock WeaponKickBack(const pItem, const pPlayer, Float: flUpBase, Float: flLateralBase, Float: flUpModifier, Float: flLateralModifier, Float: flUpMax, Float: flLateralMax) 
{
	new Float: flKickUp, Float: flKickLateral;
	new iShotsFired = get_member( pItem, m_Weapon_iShotsFired );
	new iDirection = get_member( pItem, m_Weapon_iDirection );
	new Float:vecPunchangle[3]; get_entvar( pPlayer, var_punchangle, vecPunchangle );

	if ( iShotsFired == 1 ) 
	{
		flKickUp = flUpBase;
		flKickLateral = flLateralBase;
	}
	else
	{
		flKickUp = iShotsFired * flUpModifier;
		flKickLateral = flLateralModifier * 3.0;
	}

	vecPunchangle[ 0 ] -= flKickUp;

	if ( vecPunchangle[ 0 ] < -flUpMax ) 
		vecPunchangle[ 0 ] = -flUpMax;

	if(iDirection != -1)
	{
		if ( iDirection ) 
		{
			vecPunchangle[ 1 ] += flKickLateral;
			if ( vecPunchangle[ 1 ] > flLateralMax ) 
				vecPunchangle[ 1 ] = flLateralMax;
		}
		else
		{
			vecPunchangle[ 1 ] -= flKickLateral;
			if ( vecPunchangle[ 1 ] < -flLateralMax ) 
				vecPunchangle[ 1 ] = -flLateralMax;
		}
	}

	set_entvar( pPlayer, var_punchangle, vecPunchangle );
}

#define VECTOR_CONE_DM_SHOTGUN {0.06976, 0.06976, 0.06976}
public CBasePlayerWeapon__BuckFire(const weaponEntity, const ammo)
{
	Log("%s/CBasePlayerWeapon__BuckFire", PLUGIN);

	new clientIndex = get_entvar(weaponEntity, var_owner);
	SemiclipEntity(clientIndex);
	static Float:vecSrc[3]; GetEyePosition(clientIndex, vecSrc);
	static Float:vecAiming[3]; GetVectorAiming(clientIndex, vecAiming);
	static Float:vecSpread[3]; 

	set_member(weaponEntity, m_Weapon_iShotsFired, get_member(weaponEntity, m_Weapon_iShotsFired) + 1);

	new weaponCode = get_entvar(weaponEntity, var_impulse);
	switch(weaponCode)
	{
		case BUCKY:
		{
			if(get_entvar(weaponEntity, var_weapon_right))
			{
				CalculateWeaponSpread(weaponEntity, Float:VECTOR_CONE_DM_SHOTGUN, 1.1, 0.4, 0.8, 1.2, vecSpread);
			} else {
				CalculateWeaponSpread(weaponEntity, Float:VECTOR_CONE_DM_SHOTGUN, 1.2, 0.6, 0.8, 1.5, vecSpread);
			} 
			FireBulletsPlayer(weaponEntity, ammo, vecSrc, vecAiming, vecSpread, 4096.0, 40.0, 1.0, clientIndex, Float:{0.0, 0.0, 0.0});

			get_entvar(clientIndex, var_punchangle, vecAiming);
			vecAiming[0] -= 7.0; 
			set_entvar(clientIndex, var_punchangle, vecAiming);		
		}
		case CLASSIC:
		{
			CalculateWeaponSpread(weaponEntity, Float:VECTOR_CONE_DM_SHOTGUN, 1.3, 0.45, 0.9, 2.1, vecSpread);
			FireBulletsPlayer(weaponEntity, ammo, vecSrc, vecAiming, vecSpread, 4096.0, 40.0, 1.0, clientIndex, Float:{0.0, 0.0, 0.0});
		
			get_entvar(clientIndex, var_punchangle, vecAiming);
			vecAiming[0] -= 3.0; 
			set_entvar(clientIndex, var_punchangle, vecAiming);		
		}
		case JUDGE:
		{
			CalculateWeaponSpread(weaponEntity, Float:VECTOR_CONE_DM_SHOTGUN, 1.2, 0.9, 0.8, 1.6, vecSpread);
			FireBulletsPlayer(weaponEntity, ammo, vecSrc, vecAiming, vecSpread, 4096.0, 40.0, 1.0, clientIndex, Float:{0.0, 0.0, 0.0});
		
			get_entvar(clientIndex, var_punchangle, vecAiming);
			vecAiming[0] -= 5.0; 
			set_entvar(clientIndex, var_punchangle, vecAiming);		
		}
		case SHORTY:
		{
			CalculateWeaponSpread(weaponEntity, Float:VECTOR_CONE_DM_SHOTGUN, 1.1, 1.1, 0.8, 1.5, vecSpread);
			FireBulletsPlayer(weaponEntity, ammo, vecSrc, vecAiming, vecSpread, 4096.0, 40.0, 1.0, clientIndex, Float:{0.0, 0.0, 0.0});

			get_entvar(clientIndex, var_punchangle, vecAiming);
			vecAiming[0] -= 6.0; 
			set_entvar(clientIndex, var_punchangle, vecAiming);		
		}
	}	
	UnSemiclipEntity(clientIndex);
}

stock Float:CalculateWeaponSpread(const pWeapon, const Float:vecSpread[3], Float:flMovementFactor, Float:flFirstShotModifier, Float:flDuckFactor, Float:flAirFactor, Float:vecOut[3]) 
{
	new pPlayer = get_member(pWeapon, m_pPlayer);
	new iPlayerFlags = get_entvar(pPlayer, var_flags);

	new Float:flSpreadRatio = flFirstShotModifier;
	new Float:vecVelocity[3]; get_entvar(pPlayer, var_velocity, vecVelocity);
	if (~iPlayerFlags & FL_ONGROUND)
	{	
		flSpreadRatio *= flAirFactor;
	} else if(xs_vec_len_2d(vecVelocity) > 30.0) {
		flSpreadRatio *= flMovementFactor;
	} else if(iPlayerFlags & FL_ONGROUND && iPlayerFlags & FL_DUCKING) {
		flSpreadRatio *= flDuckFactor;
	} 

	xs_vec_mul_scalar(vecSpread, flSpreadRatio, vecOut);
	return flSpreadRatio;
}

stock UTIL_PrecacheWeaponList( const szWeaponList[ ] )
{
	new szBuffer[196], pFile;

	format(szBuffer, charsmax(szBuffer), "sprites/Jenessee_Valorant/weapons/%s.txt", szWeaponList);
	engfunc(EngFunc_PrecacheGeneric, szBuffer);

	if (!(pFile = fopen( szBuffer, "rb")))
		return;

	new szSprName[128], iPos;
	while (!feof(pFile)) 
	{
		fgets(pFile, szBuffer, charsmax(szBuffer));
		trim(szBuffer);

		if (!strlen(szBuffer)) 
			continue;

		if ((iPos = containi(szBuffer, "640")) == -1)
			continue;
				
		format(szBuffer, charsmax(szBuffer), "%s", szBuffer[iPos + 3]);		
		trim(szBuffer);

		strtok(szBuffer, szSprName, charsmax(szSprName), szBuffer, charsmax(szBuffer), ' ', 1);
		trim(szSprName);

		formatex(szBuffer, charsmax(szBuffer), "sprites/%s.spr", szSprName);
		engfunc(EngFunc_PrecacheGeneric, szBuffer);
	}

	fclose(pFile);
}

public CMD_Language(const clientIndex)
{
	client_cmd(clientIndex, "setinfo ^"lang^" ^"%s^"", !bPlayerTurkish[clientIndex] ? "tr" : "en");
	set_user_info(clientIndex, "lang", !bPlayerTurkish[clientIndex] ? "tr" : "en");

	bPlayerTurkish[clientIndex] = !bPlayerTurkish[clientIndex];
	Color_Chat(clientIndex, 0, "!g[%s]!n %L", PLUGIN, clientIndex, "INFO_LANGUAGE_CHANGED");	
}

public CMD_Reset(const clientIndex)
{
	set_entvar(clientIndex, var_frags, 0.0);
	set_member(clientIndex, m_iDeaths, 0);

	message_begin(MSG_BROADCAST, Message_ScoreInfo);
	write_byte(clientIndex);
	write_short(get_entvar(clientIndex, var_frags));
	write_short(get_member(clientIndex, m_iDeaths));
	write_short(0);
	write_short(get_member(clientIndex, m_iTeam));
	message_end();

	Color_Chat(clientIndex, 0, "!g[%s]!n %L", PLUGIN, clientIndex, "INFO_SCORE_RESET");	
}

public CMD_NextMAP(const clientIndex)
{
	if(strlen(nextMAP))
	{
		Color_Chat(clientIndex, 0, "!g[%s]!n %L", PLUGIN, clientIndex, "INFO_NEXT_MAP", nextMAP);	
		return PLUGIN_HANDLED;
	}

	return PLUGIN_CONTINUE;
}

public Task_Show_Player_Info()
{
	static iShowInfo;

	new szInfo[32];
	switch(iShowInfo)
	{
		case 0: formatex(szInfo, charsmax(szInfo), "INFO_DEVELOPER");
		case 1: formatex(szInfo, charsmax(szInfo), "THANKS");
		case 2: formatex(szInfo, charsmax(szInfo), "INFO_YOUTUBE");
	}
	
	for(new arrayID = ArraySize(Array_playerCONNECTED)-1, clientIndex; arrayID >= 0; arrayID--)
	{
		clientIndex = ArrayGetCell(Array_playerCONNECTED, arrayID);
		if(is_user_bot(clientIndex))
			continue;

 		if(iShowInfo == 0) Color_Chat(clientIndex, 0, "!g[%s]!n %L : !tJenessee", PLUGIN, clientIndex, szInfo);
		else if(iShowInfo == 1) Color_Chat(clientIndex, 0, "!g[%s]!n %L", PLUGIN, clientIndex, szInfo, "Virtualzio");
		else Color_Chat(clientIndex, 0, "!g[%s]!n %L", PLUGIN, clientIndex, szInfo);
	}

	if(++iShowInfo >= 3) iShowInfo = 0;
}

public Task_Player_Weapon_Huds()
{
	set_msg_block(Message_WeapPickup, BLOCK_NOT)

	for(new arrayID = ArraySize(Array_playerALIVE)-1, clientIndex; arrayID >= 0; arrayID--)
	{
		clientIndex = ArrayGetCell(Array_playerALIVE, arrayID);
		if(is_user_bot(clientIndex))
			continue;

 		Show_Weapon_Huds(clientIndex);
	}

	set_msg_block(Message_WeapPickup, BLOCK_SET)
}

public Show_Hud_Messages()
{
	for(new arrayID = ArraySize(Array_playerALIVE)-1, clientIndex; arrayID >= 0; arrayID--)
	{
		clientIndex = ArrayGetCell(Array_playerALIVE, arrayID);

		if(is_user_bot(clientIndex) && random_num(0, 10) == 6)
		{
			if(!playerCOOLDOWN[clientIndex])
			{
				Hook_C_Skill(clientIndex);
			}
		}
		if(playerCOOLDOWN[clientIndex] && !get_member_game(m_bFreezePeriod))
		{
			playerCOOLDOWN[clientIndex]--;
			if(!playerCOOLDOWN[clientIndex])
			{
				Character_Quote(clientIndex, QUOTE_ULTREADY);
				fSkillDelay[clientIndex] = get_gametime() + 0.01;

				rh_emit_sound(clientIndex, clientIndex, CHAN_STATIC, Skill_Resources[3], 0.6, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);

				rg_remove_items_by_slot(clientIndex, GRENADE_SLOT);
				new weaponEntity = rg_give_custom_item(clientIndex, "weapon_hegrenade", GT_APPEND);
				if(weaponEntity != NULLENT)
				{
					if(currentWeaponENTITY[clientIndex] == weaponEntity)
					{
						if(fBlockWeaponChange[clientIndex] <= get_gametime()) 
						{
							engclient_cmd(clientIndex, "weapon_knife");
						}
					}

					remove_task(weaponEntity+TASK_WEAPON, 1);

					Change_WeaponList(clientIndex, weaponEntity, fmt("Jenessee_Valorant/weapons/%s", Agent_Skills[playerAgentID[clientIndex]][SKILL_SPRITE]), false);
					
					rg_set_iteminfo(weaponEntity, ItemInfo_pszName, fmt("Jenessee_Valorant/weapons/%s", Agent_Skills[playerAgentID[clientIndex]][SKILL_SPRITE]));
					set_entvar(weaponEntity, var_netname, fmt("%L", LANG_PLAYER, Agent_Skills[playerAgentID[clientIndex]][SKILL_NAME]));
				}
			}
		}

		if(is_user_bot(clientIndex))
			continue;

 		set_dhudmessage(255, 255, 255, -1.0, 0.0, 0, 1.0, 1.0);
   	 	show_dhudmessage(clientIndex, "%i %L | %L | %L %i", get_member_game(m_iNumTerroristWins), clientIndex, "SCOREBOARD_ATTACKERS", clientIndex, fmt("SCOREBOARD_STAGE%i", currentSTAGE+1), clientIndex, "SCOREBOARD_DEFENDERS", get_member_game(m_iNumCTWins));
	}
}

public Show_Weapon_Huds(const clientIndex)
{
	for (new InventorySlotType:weaponSlot = KNIFE_SLOT, weaponEntity; weaponSlot >= PRIMARY_WEAPON_SLOT; weaponSlot--) 
	{
		if((weaponEntity = get_member(clientIndex, m_rgpPlayerItems, weaponSlot)) != -1) 
		{
			do 
			{
				new weaponID = get_member(weaponEntity, m_iId);
				message_begin(MSG_ONE_UNRELIABLE, Message_WeapPickup, _, clientIndex);
				write_byte(weaponID);
				message_end();
			} while ((weaponEntity = get_member(weaponEntity, m_pNext)) != -1);
		}
	}

	message_begin(MSG_ONE_UNRELIABLE, Message_WeapPickup, _, clientIndex);
	write_byte(CSW_HEGRENADE);
	message_end();
}

public Hook_Skill(const clientIndex)
{
	return PLUGIN_HANDLED;
}

public Hook_C_Skill(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) 
	{
		if(playerInBASE[clientIndex] && playerAgentID[clientIndex] == AGENT_JETT)
			return PLUGIN_HANDLED;

		if(playerCOOLDOWN[clientIndex])
		{
			Character_Quote(clientIndex, QUOTE_CANTUSE);
		}
		
		engclient_cmd(clientIndex, "weapon_hegrenade");
	}
	return PLUGIN_HANDLED;
}

public Hook_weapon_m3(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, "weapon_m3");
	return PLUGIN_HANDLED;
}

public Hook_weapon_aug(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, "weapon_aug");
	return PLUGIN_HANDLED;
}

public Hook_weapon_deagle(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, "weapon_deagle");
	return PLUGIN_HANDLED;
}

public Hook_weapon_galil(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, "weapon_galil");
	return PLUGIN_HANDLED;
}

public Hook_weapon_xm1014(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, "weapon_xm1014");
	return PLUGIN_HANDLED;
}

public Hook_weapon_knife(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, "weapon_knife");
	return PLUGIN_HANDLED;
}

public Hook_weapon_scout(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, "weapon_scout");
	return PLUGIN_HANDLED;
}

public Hook_weapon_m249(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, "weapon_m249");
	return PLUGIN_HANDLED;
}

public Hook_weapon_awp(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, "weapon_awp");
	return PLUGIN_HANDLED;
}

public Hook_weapon_m4a1(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, "weapon_m4a1");
	return PLUGIN_HANDLED;
}

public Hook_weapon_ak47(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, "weapon_ak47");
	return PLUGIN_HANDLED;
}

public Hook_weapon_p90(const clientIndex)
{
	if(fBlockWeaponChange[clientIndex] <= get_gametime()) engclient_cmd(clientIndex, "weapon_p90");
	return PLUGIN_HANDLED;
}

Knife_Damage(const clientIndex, const weaponEntity, const Float:fDistance)
{
	static iTarget, iHitGroup = HIT_GENERIC; 
	static Float:vAttackerOrigin[3]; get_entvar(clientIndex, var_origin, vAttackerOrigin);
	static Float:vUp[3]; get_entvar(clientIndex, var_view_ofs, vUp);
	static Float:vAttackerAngle[3]; get_entvar(clientIndex, var_v_angle, vAttackerAngle);
	xs_vec_add(vAttackerOrigin, vUp, vAttackerOrigin)
	static Float:vForward[3]; angle_vector(vAttackerAngle, ANGLEVECTOR_FORWARD, vForward);
	static Float:vTargetOrigin[3]; 

	vTargetOrigin[0] = vAttackerOrigin[0] + vForward[0] * fDistance;
	vTargetOrigin[1] = vAttackerOrigin[1] + vForward[1] * fDistance;
	vTargetOrigin[2] = vAttackerOrigin[2] + vForward[2] * fDistance;

	engfunc(EngFunc_TraceLine, vAttackerOrigin, vTargetOrigin, DONT_IGNORE_MONSTERS, clientIndex, 0); 

	static Float:flFraction; get_tr2(0, TR_flFraction, flFraction);
	iTarget = get_tr2(0, TR_pHit);
	if(flFraction == 1.0 || iTarget <= 0 || (iTarget > MaxClients && get_entvar(iTarget, var_takedamage) == DAMAGE_YES))
	{
		engfunc(EngFunc_TraceHull, vAttackerOrigin, vTargetOrigin, DONT_IGNORE_MONSTERS, HULL_HEAD, clientIndex, 0); 
		get_tr2(0, TR_flFraction, flFraction);
		iTarget = get_tr2(0, TR_pHit);
	}
	
	iHitGroup = get_tr2(0, TR_iHitgroup); 
	get_tr2(0, TR_vecEndPos, vTargetOrigin);

	if(iTarget > MaxClients && get_entvar(iTarget, var_takedamage) == DAMAGE_YES)
	{
		ExecuteHamB(Ham_TakeDamage, iTarget, weaponEntity, clientIndex, float(Weapon_Info[KNIFE][BODY_DAMAGE]), DMG_BULLET);
		return HIT_ENEMY;
	}
	
	if(flFraction < 1.0) 
	{
		if(is_user_connected(iTarget) || (iTarget > MaxClients && get_entvar(iTarget, var_takedamage) == DAMAGE_YES))
		{
			if(iTarget <= MaxClients && rg_is_player_can_takedamage(clientIndex, iTarget))
			{
				iHitGroup = get_tr2(0, TR_iHitgroup);
				set_member(iTarget, m_LastHitGroup, iHitGroup);
				SpawnBlood(vTargetOrigin, iHitGroup, 9, 247);
			}

			ExecuteHamB(Ham_TakeDamage, iTarget, weaponEntity, clientIndex, 1.0, DMG_BULLET);
			return HIT_ENEMY;
		} 

		static Float:vecEnd[3], Float:vecPlaneNormal[3]; 
		get_tr2(0, TR_vecEndPos, vecEnd);
		get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal);

		xs_vec_mul_scalar(vecPlaneNormal, 15.0, vecPlaneNormal);
		
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
		write_byte(TE_STREAK_SPLASH);
		write_coord_f(vecEnd[0]);
		write_coord_f(vecEnd[1]);
		write_coord_f(vecEnd[2]);
		write_coord_f(vecPlaneNormal[0]);
		write_coord_f(vecPlaneNormal[1]);
		write_coord_f(vecPlaneNormal[2]);
		if(!is_nullent(iTarget) && entityBARRIER[iTarget])
		{
			write_byte(0);

			static Float:delaysound;
			if(delaysound <= get_gametime())
			{
				rh_emit_sound(iTarget, clientIndex, CHAN_STATIC, Barrier_Hit[random_num(0, sizeof(Barrier_Hit)-1)], 0.6, ATTN_NONE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				delaysound = get_gametime() + 0.1;
			}
		} else write_byte(5);
		write_short(random_num(10, 20));
		write_short(3);
		write_short(64);
		message_end();

		return HIT_WALL;
	} 
	return HIT_NONE;
}

bool:Distance_Entity_Angles(const Entity, const iTarget, const Float:ViewDis)
{
	static Float:Origin[3]; get_entvar(Entity, var_origin, Origin);
	static Float:Angles[3]; get_entvar(Entity, Entity > MAX_PLAYERS ? var_angles : var_v_angle, Angles);
	static Float:Target[3]; get_entvar(iTarget, var_origin, Target);
	static Float:X; X = Target[0] - Origin[0];
	static Float:Y; Y = Target[1] - Origin[1];
	static Float:Radians; Radians = floatatan2(Y, X, radian);
	static Float:GoalAngles[3]; GoalAngles[1] = Radians * (180 / 3.14);
    	
	static Float:Distance; Distance = 180.0 - floatabs(floatabs(GoalAngles[1] - Angles[1]) - 180.0);
	if(Distance <= (ViewDis*0.5)) return true;
	return false;
}   

SpawnBlood(const Float:Origin[3], const iBody, const iScale, const Color)
{
	static Blood_Scale;
	switch (iBody)
	{
		case HIT_HEAD: Blood_Scale = iScale+8; // Eğer kafaya vurulmuşsa kan daha büyük çıkar.
		case HIT_CHEST, HIT_STOMACH: Blood_Scale = iScale+3;
		default: Blood_Scale = iScale;
	}

	engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, Origin);
	write_byte(TE_BLOODSPRITE);
	engfunc(EngFunc_WriteCoord, Origin[0]);
	engfunc(EngFunc_WriteCoord, Origin[1]);
	engfunc(EngFunc_WriteCoord, Origin[2]);
	write_short(g_iBloods[1]);
	write_short(g_iBloods[0]);
	write_byte(Color);
	write_byte(Blood_Scale);
	message_end();
}    

public CMD_Agent(const clientIndex)
{
	Agent_Select_Menu(clientIndex);
}

public Agent_Select_Menu(const clientIndex)
{
	menu_setprop(agentSelectMENU, MPROP_TITLE, fmt("%L", clientIndex, "AGENT_MENUTITLE"));
	menu_setprop(agentSelectMENU, MPROP_BACKNAME, fmt("\w%L", clientIndex, "BACK_MENU"));
	menu_setprop(agentSelectMENU, MPROP_NEXTNAME, fmt("\w%L", clientIndex, "NEXT_MENU"));
	menu_setprop(agentSelectMENU, MPROP_EXITNAME, fmt("\w%L", clientIndex, "EXIT_MENU"));
	menu_display(clientIndex, agentSelectMENU, agentPAGE[clientIndex]);
	return PLUGIN_HANDLED;
}

Create_Agent_Menu()
{
	new szMenuTitle[64]; formatex(szMenuTitle, charsmax(szMenuTitle), "%L", LANG_PLAYER, "AGENT_MENUTITLE"); 
	agentSelectMENU = menu_create(szMenuTitle, "MenuHandle_Agent");
	new callBack = menu_makecallback("MenuCallback_Agent");
	for(new index = 0; index < sizeof(Agent_Info); index++)
	{
		menu_additem(agentSelectMENU, fmt("%s", Agent_Info[index][NAME]), fmt("%i", index), _, callBack);
	}
}

public MenuCallback_Agent(const clientIndex, const iMenu, const Item)
{
	new szInfo[12];
	menu_item_getinfo(iMenu, Item, _, szInfo, charsmax(szInfo), _, _, _);

	new agentCode = str_to_num(szInfo);
	if(agentCode == playerNextAgent[clientIndex])
	{
		menu_item_setname(iMenu, Item, fmt("\d%s %L", Agent_Info[agentCode][NAME], clientIndex, Agent_Skills[agentCode][SKILL_NAME]));
		return ITEM_ENABLED;
	}

	menu_item_setname(iMenu, Item, fmt("%s \y%L", Agent_Info[agentCode][NAME], clientIndex, Agent_Skills[agentCode][SKILL_NAME]));
	return ITEM_ENABLED;
}

public MenuHandle_Agent(const clientIndex, const iMenu, const agentCode)
{
	if(agentCode == MENU_EXIT)
		return;
	if(agentCode < 0)
		return;
	if(playerNextAgent[clientIndex] == agentCode)
		return;

	Log("%s/MenuHandle_Agent", PLUGIN);

	playerNextAgent[clientIndex] = agentCode;
	agentPAGE[clientIndex] = agentCode <= 6 ? 0 : (agentCode / 7);

	Color_Chat(clientIndex, 0, "!g[%s]!n %L", PLUGIN, clientIndex, "AGENT_SELECTED", Agent_Info[agentCode][NAME]);

	if(is_user_alive(clientIndex)) 
	{
		if(strlen(agentSelectSOUND)) 
		{
			rh_emit_sound(clientIndex, clientIndex, CHAN_STATIC, agentSelectSOUND, 0.6, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		}

		rh_emit_sound(clientIndex, clientIndex, CHAN_VOICE, fmt("Jenessee_Valorant/agent/%s.wav", Agent_Quote_Selected[agentCode]), 0.75, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);

		if(playerInBASE[clientIndex])
		{
			Load_Player_Agent(clientIndex);

			new weaponEntity = currentWeaponENTITY[clientIndex];
			if(weaponEntity != NULLENT)
			{
				ExecuteHamB(Ham_Item_Deploy, weaponEntity);
			}
		}
	}
}

public balance_teams()
{
	new iTimes = ArraySize(Array_playerDEFENDERS) - ArraySize(Array_playerATTACKERS);
	if(iTimes == 0)
		return;

	iTimes = abs(iTimes)

	if(iTimes < 2 || iTimes <= get_cvar_pointer("mp_limitteams"))
	{
		return
	}

	static iMsgTeamInfo;
	if(!iMsgTeamInfo) iMsgTeamInfo = get_user_msgid("TeamInfo");

	rg_balance_teams();
	for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, clientIndex; arrayIndex >= 0; arrayIndex--)
	{
		clientIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);

		if(playerTEAM[clientIndex] == TEAM_DEFENDERS && cs_get_user_team(clientIndex) == CS_TEAM_T)
		{
			emessage_begin(MSG_ALL, iMsgTeamInfo);
			ewrite_byte(clientIndex);
			ewrite_string("TERRORIST"); 
			emessage_end();

			if(is_user_alive(clientIndex))
			{
				rg_round_respawn(clientIndex);
			}
		}

		if(playerTEAM[clientIndex] == TEAM_ATTACKERS && cs_get_user_team(clientIndex) == CS_TEAM_CT)
		{
			emessage_begin(MSG_ALL, iMsgTeamInfo);
			ewrite_byte(clientIndex);
			ewrite_string("CT"); 
			emessage_end();

			if(is_user_alive(clientIndex))
			{
				rg_round_respawn(clientIndex);
			}
		}
	}
}

public CMD_Crosshair(const clientIndex)
{
	Crosshair_Select_Menu(clientIndex);
}

public CMD_FPS(const clientIndex)
{
	bHideTeammates[clientIndex] = !bHideTeammates[clientIndex];
	new steamID[32]; get_user_authid(clientIndex, steamID, charsmax(steamID));
	formatex(IDFormat[clientIndex], charsmax(IDFormat), "%s-HIDE", steamID)
	num_to_str(bHideTeammates[clientIndex] ? 1 : 0, HIDEPLAYERS[clientIndex], charsmax(HIDEPLAYERS));
	nvault_set(Vault, IDFormat[clientIndex], HIDEPLAYERS[clientIndex]);
}

public CMD_Nightvision(const clientIndex)
{
	Crosshair_Select_Menu(clientIndex);
	return PLUGIN_HANDLED;
}

public Crosshair_Select_Menu(const clientIndex)
{
	menu_setprop(crosshairSelectMENU, MPROP_TITLE, fmt("%L", clientIndex, "CROSSHAIR_MENUTITLE"));
	menu_setprop(crosshairSelectMENU, MPROP_BACKNAME, fmt("\w%L", clientIndex, "BACK_MENU"));
	menu_setprop(crosshairSelectMENU, MPROP_NEXTNAME, fmt("\w%L", clientIndex, "NEXT_MENU"));
	menu_setprop(crosshairSelectMENU, MPROP_EXITNAME, fmt("\w%L", clientIndex, "EXIT_MENU"));
	menu_display(clientIndex, crosshairSelectMENU, crosshairPAGE[clientIndex]);
	return PLUGIN_HANDLED;
}

Create_Crosshair_Menu()
{
	new szMenuTitle[64]; formatex(szMenuTitle, charsmax(szMenuTitle), "%L", LANG_PLAYER, "CROSSHAIR_MENUTITLE"); 
	crosshairSelectMENU = menu_create(szMenuTitle, "MenuHandle_Crosshair");
	new callBack = menu_makecallback("MenuCallback_Crosshair");
	for(new index = 0; index < sizeof(Crosshair_Info); index++)
	{
		menu_additem(crosshairSelectMENU, fmt("%s", Crosshair_Info[index][CROSSHAIR_NAME]), fmt("%i", index), _, callBack);
	}
}

public MenuCallback_Crosshair(const clientIndex, const iMenu, const Item)
{
	new szInfo[12];
	menu_item_getinfo(iMenu, Item, _, szInfo, charsmax(szInfo), _, _, _);

	new crossCODE = str_to_num(szInfo);
	if(crossCODE == playerCROSSHAIR[clientIndex])
	{
		menu_item_setname(iMenu, Item, fmt("\y%L", clientIndex, Crosshair_Info[crossCODE][CROSSHAIR_NAME]));
		return ITEM_ENABLED;
	}

	menu_item_setname(iMenu, Item, fmt("%L", clientIndex, Crosshair_Info[crossCODE][CROSSHAIR_NAME]));
	return ITEM_ENABLED;
}

public MenuHandle_Crosshair(const clientIndex, const iMenu, const crossCODE)
{
	if(crossCODE == MENU_EXIT)
	{
		return;
	}
	if(crossCODE < 0)
		return;
	if(playerCROSSHAIR[clientIndex] == crossCODE)
		return;

	Log("%s/MenuHandle_Crosshair", PLUGIN);

	new crossNAME[128];
	menu_item_getinfo(iMenu, crossCODE, _, _,_, crossNAME, charsmax(crossNAME), _);

	new steamID[32]; get_user_authid(clientIndex, steamID, charsmax(steamID));
	formatex(IDFormat[clientIndex], charsmax(IDFormat), "%s-Crosshair", steamID)
	num_to_str(crossCODE, Crosshair[clientIndex], charsmax(Crosshair));
	nvault_set(Vault, IDFormat[clientIndex], Crosshair[clientIndex]);

	playerCROSSHAIR[clientIndex] = crossCODE;
	crosshairPAGE[clientIndex] = crossCODE <= 6 ? 0 : (crossCODE / 7);

	formatex(myCROSSHAIR[clientIndex], charsmax(myCROSSHAIR), Crosshair_Info[crossCODE][CROSSHAIR_SPRITE]);

	Color_Chat(clientIndex, 0, "!g[%s]!n %L", PLUGIN, clientIndex, "CROSSHAIR_SELECTED", clientIndex, Crosshair_Info[crossCODE][CROSSHAIR_NAME]);

	if(is_user_alive(clientIndex))
	{
		new weaponEntity = currentWeaponENTITY[clientIndex];
		if(weaponEntity != NULLENT)
		{
			Change_Crosshair(clientIndex, weaponEntity);
		}
	}
}

public ClientCommands(const clientIndex)
{
	new szCMD[32]; read_argv(0, szCMD, charsmax(szCMD));
	if(!is_user_bot(clientIndex))
	{
		if(equal(szCMD, "weapon_" , 7))
			return FMRES_SUPERCEDE;
	}
		
	new weaponEntity = lastWeaponENTITY[clientIndex];
	if(weaponEntity != NULLENT)
	{
		if(playerAgentID[clientIndex] == AGENT_JETT && !get_entvar(weaponEntity, var_impulse))
		{
			if(equal(szCMD, "lastinv"))
				return FMRES_SUPERCEDE;
		}
	}
	if(fBlockWeaponChange[clientIndex] <= get_gametime())
		return FMRES_IGNORED;
	if(equal(szCMD, "lastinv"))
			return FMRES_SUPERCEDE;

	return FMRES_IGNORED;
}

public OnExplodeFlashbang_Pre(const entityIndex, const tracehandle, const bitsDamageType)   
{
	UTIL_RemoveEntity(entityIndex, 0.0);
	return HC_SUPERCEDE;
}

public OnThrowHeGrenade_Post(clientIndex, Float:vecSrc[3], Float:vecVelocity[3], Float:fTime, team, usEvent) 
{
	new grenadeEntity = GetHookChainReturn(ATYPE_INTEGER);
	if(playerAgentID[clientIndex] == AGENT_DEADLOCK)
	{
		if(entityTotalCHILDRENS[clientIndex] > 0)
		{
			for(new arrayIndex = entityTotalCHILDRENS[clientIndex]-1, entityMODEL[128], childrenEntity; arrayIndex >= 0; arrayIndex--)
			{
				childrenEntity = ArrayGetCell(entityCHILDRENS[clientIndex], arrayIndex);
				get_entvar(childrenEntity, var_model, entityMODEL, charsmax(entityMODEL));
				if(!equal(entityMODEL, Skill_Resources[28]))
					continue;

				UTIL_RemoveEntity(childrenEntity, 0.0);
			}
		}

		new params[1]; 
		new weaponEntity = currentWeaponENTITY[clientIndex];
		if(weaponEntity != NULLENT && !is_nullent(weaponEntity) && !get_entvar(weaponEntity, var_impulse))
		{
			remove_task(weaponEntity+TASK_WEAPON);
			fBlockWeaponChange[clientIndex] = get_gametime() + 0.9;
			playerCOOLDOWN[clientIndex] = Agent_Skills[playerAgentID[clientIndex]][SKILL_COOLDOWN];
			rg_set_user_bpammo(clientIndex, get_member(weaponEntity, m_iId), 0);

			params[0] = weaponEntity;
			set_task(0.5, "Task_Raze_Bomb_Remove", weaponEntity+TASK_WEAPON, params, sizeof(params));
		}
		
		new Float:dmgtime; get_entvar(grenadeEntity, var_dmgtime, dmgtime);
		set_entvar(grenadeEntity, var_dmgtime, dmgtime + 99999.0);

		remove_task(grenadeEntity+TASK_REMOVE_ENTITY, 1);
		params[0] = grenadeEntity;
		set_task(2.5, "Task_Deadlock_Projectile", grenadeEntity+TASK_REMOVE_ENTITY, params, sizeof(params));

		rh_emit_sound(grenadeEntity, 0, CHAN_ITEM, Skill_Resources[31], 1.0, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);

		bMuteEntity[grenadeEntity] = true;
		bEntityHaveTeam[grenadeEntity] = true;
		bDeadlockEntity[grenadeEntity] = true;
		
		set_entvar(grenadeEntity, var_netname, fmt("%L", LANG_PLAYER, Agent_Skills[AGENT_DEADLOCK][SKILL_NAME]));

		set_entvar(grenadeEntity, var_takedamage, DAMAGE_YES);
		set_entvar(grenadeEntity, var_health, 300.0);

		engfunc(EngFunc_SetModel, grenadeEntity, Skill_Resources[28]);

		set_entvar(grenadeEntity, var_bombtype, AGENT_DEADLOCK);
		set_entvar(grenadeEntity, var_team, get_entvar(clientIndex, var_team));
		set_entvar(grenadeEntity, var_iuser1, 1);

		RequestFrame("Deadlock_Barrier_Animation", clientIndex);
		ChildrenParent_Entity(clientIndex, grenadeEntity);
		Entity_Will_Remove_NewRound(grenadeEntity, true);
		Semiclip_Entity(grenadeEntity, TEAM_ATTACKERS);
		Semiclip_Entity(grenadeEntity, TEAM_DEFENDERS);

		new Float:vMins[3], Float:vMaxs[3];

		vMins[0] = -16.0;
		vMins[1] = -16.0;
		vMins[2] = -2.93;
		vMaxs[0] = 16.0;
		vMaxs[1] = 16.0;
		vMaxs[2] = 3.0;

		engfunc(EngFunc_SetSize, grenadeEntity, vMins, vMaxs);
		set_entvar(grenadeEntity, var_mins, vMins); 
		set_entvar(grenadeEntity, var_maxs, vMaxs); 
		set_entvar(grenadeEntity, var_absmin, vMins);
		set_entvar(grenadeEntity, var_absmax, vMaxs);

		new Float:vAngle[3]; get_entvar(clientIndex, var_v_angle, vAngle);
		GetPosition(clientIndex, 0.0, 0.0, 0.0, vecSrc, vAngle, true, Float:{0.0, 0.0, 0.0}, false);
		set_entvar(grenadeEntity, var_origin, vecSrc);
		Kurtar(grenadeEntity, 32, 128);
		vAngle[1] += 90.0;
		vAngle[0] = 45.0;
		set_entvar(grenadeEntity, var_angles, vAngle);
		return;
	}
	if(playerAgentID[clientIndex] != AGENT_RAZE)
		return;

	new weaponEntity = currentWeaponENTITY[clientIndex];
	if(weaponEntity != NULLENT && !is_nullent(weaponEntity) && !get_entvar(weaponEntity, var_impulse))
	{
		Character_Quote(clientIndex, QUOTE_SKILL1);
		remove_task(weaponEntity+TASK_WEAPON);
		fBlockWeaponChange[clientIndex] = get_gametime() + 0.8;
		playerCOOLDOWN[clientIndex] = Agent_Skills[playerAgentID[clientIndex]][SKILL_COOLDOWN];
		rg_set_user_bpammo(clientIndex, get_member(weaponEntity, m_iId), 0);
		new params[1]; params[0] = weaponEntity;
		set_task(0.5, "Task_Raze_Bomb_Remove", weaponEntity+TASK_WEAPON, params, sizeof(params));
	}

	xs_vec_mul_scalar(vecVelocity, weaponRight[clientIndex] ? 0.55 : 1.2, vecVelocity);
	set_entvar(grenadeEntity, var_velocity, vecVelocity);
	set_entvar(grenadeEntity, var_team, get_entvar(clientIndex, var_team));
	if(!weaponRight[clientIndex])
	{
		RequestFrame("Frame_Raze_Bomb_Animation", clientIndex);
	}

	bMuteEntity[grenadeEntity] = true;
	bEntityHaveTeam[grenadeEntity] = true;
	bRazeBomb[grenadeEntity] = true;

	rh_emit_sound(grenadeEntity, 0, CHAN_ITEM, Skill_Resources[5], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);

	new Float:dmgtime; get_entvar(grenadeEntity, var_dmgtime, dmgtime);
	set_entvar(grenadeEntity, var_dmgtime, dmgtime + 0.5);

	set_entvar(grenadeEntity, var_fuser2, get_gametime() + 0.1);
	set_entvar(grenadeEntity, var_netname, fmt("%L", LANG_PLAYER, Agent_Skills[AGENT_RAZE][SKILL_NAME]));

	engfunc(EngFunc_SetModel, grenadeEntity, Skill_Resources[4]);
	set_entvar(grenadeEntity, var_avelocity, Float:{0.0, 600.0, 200.0});
	set_entvar(grenadeEntity, var_bombtype, AGENT_RAZE);

	ChildrenParent_Entity(clientIndex, grenadeEntity);
	Entity_Will_Remove_NewRound(grenadeEntity, true);
}

public Task_Deadlock_Projectile(params[], taskid)
{
	new entityIndex = params[0];

	rh_emit_sound(entityIndex, 0, CHAN_ITEM, Skill_Resources[31], 1.0, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
}

public Deadlock_Barrier_Animation(const clientIndex)
{
	if(!is_user_alive(clientIndex))
		return;
	if(currentWeaponENTITY[clientIndex] == NULLENT)
		return;
	if(get_entvar(currentWeaponENTITY[clientIndex], var_impulse) != 0)
		return;

	UTIL_PlayerAnimation(clientIndex, "ref_shoot_grenade");
	UTIL_SendWeaponAnim(clientIndex, 2); 
}

public Frame_Raze_Bomb_Animation(const clientIndex)
{
	if(!is_user_alive(clientIndex))
		return;
	if(currentWeaponENTITY[clientIndex] == NULLENT)
		return;
	if(get_entvar(currentWeaponENTITY[clientIndex], var_impulse) != 0)
		return;

	UTIL_SendWeaponAnim(clientIndex, 1); 
}

public Task_Deadlock_Idle(params[], taskid)
{
	new entityIndex = params[0];

	rh_emit_sound(entityIndex, 0, CHAN_ITEM, Skill_Resources[33], 1.0, ATTN_IDLE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	new param[1]; param[0] = entityIndex;
	set_task(20.0, "Task_Deadlock_Idle", entityIndex+TASK_REMOVE_ENTITY, param, sizeof(param));
}

public OnThinkGrenade(entityIndex)
{
	if(is_nullent(entityIndex)) 
		return HAM_IGNORED 

	if(get_entvar(entityIndex, var_bombtype) == AGENT_DEADLOCK)
	{
		new Float:vOrigin[3]; get_entvar(entityIndex, var_origin, vOrigin);
		if(get_entvar(entityIndex, var_flags) & FL_ONGROUND || !DistanceToFloor(entityIndex, vOrigin, 9.0, false))
		{
			if(get_entvar(entityIndex, var_iuser1))
			{
				if(!isPointAvailable(entityIndex, vOrigin))
				{
					new clientIndex = get_entvar(entityIndex, var_owner);
					Character_Quote(clientIndex, QUOTE_SKILL1);
					if(playerCOOLDOWN[clientIndex] > 2) playerCOOLDOWN[clientIndex] = 2;
					UTIL_RemoveEntity(entityIndex, 0.0);
					return HAM_IGNORED;
				}

				remove_task(entityIndex+TASK_REMOVE_ENTITY, 1);
				new param[1]; param[0] = entityIndex;
				set_task(1.0, "Task_Deadlock_Idle", entityIndex+TASK_REMOVE_ENTITY, param, sizeof(param));

				set_entvar(entityIndex, var_effects, get_entvar(entityIndex, var_effects) | EF_NODRAW);
				bEntityHaveTeam[entityIndex] = false;
				rh_emit_sound(entityIndex, 0, CHAN_STATIC, Skill_Resources[32], 1.0, ATTN_STATIC, 0, PITCH_NORM, SND_EMIT2_NOPAS);
				set_entvar(entityIndex, var_iuser1, 0);

				set_entvar(entityIndex, var_velocity, Float:{0.1, 0.1, 0.1});

				new Float:vAngle[3], Float:vecPlaneNormal[3]; 
				vecPlaneNormal = vOrigin;
				vecPlaneNormal[2] -= 1000.0;
				engfunc(EngFunc_TraceLine, vOrigin, vecPlaneNormal, IGNORE_MONSTERS, entityIndex, 0); 
				get_tr2(0, TR_vecEndPos, vOrigin);	
				vOrigin[2] += 2.93;
				get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal);
				vector_to_angle(vecPlaneNormal, vAngle);
				vAngle[0] -= 90.0;
				if(vAngle[0] != 0.0)
				{	
					set_entvar(entityIndex, var_angles, vAngle);
				} else {
					get_entvar(entityIndex, var_angles, vAngle);
					vAngle[0] = 0.0;
					set_entvar(entityIndex, var_angles, vAngle);
				}

				set_entvar(entityIndex, var_origin, vOrigin);

				new modelEntity = rg_create_entity("info_target");
				if(!is_nullent(modelEntity))
				{
					engfunc(EngFunc_SetModel, modelEntity, Skill_Resources[36]);  

					set_entvar(modelEntity, var_owner, get_entvar(entityIndex, var_owner));

					set_entvar(modelEntity, var_movetype, MOVETYPE_FLY);
					set_entvar(modelEntity, var_solid, SOLID_NOT);

					set_entvar(modelEntity, var_origin, vOrigin);
					set_entvar(modelEntity, var_angles, vAngle);

					bEntityHaveTeam[modelEntity] = true;
					set_entvar(modelEntity, var_team, get_entvar(entityIndex, var_team));

					ChildrenParent_Entity(entityIndex, modelEntity);
					Play_Animation(modelEntity, "spin_idle", 3.0);
				}

				new reviveEffect = rg_create_entity("info_target");
				if(!is_nullent(reviveEffect))
				{
					engfunc(EngFunc_SetModel, reviveEffect, Skill_Resources[29]);  

					bEntityHaveTeam[reviveEffect] = true;

					set_entvar(reviveEffect, var_movetype, MOVETYPE_FLY);
					set_entvar(reviveEffect, var_solid, SOLID_NOT);

					set_entvar(reviveEffect, var_owner, get_entvar(entityIndex, var_owner));

					set_entvar(reviveEffect, var_rendermode, kRenderTransAdd);   
					set_entvar(reviveEffect, var_renderamt, 255.0);   
					bDeadlockEffect[reviveEffect] = true;
					set_entvar(reviveEffect, var_team, get_entvar(entityIndex, var_team));
					set_entvar(reviveEffect, var_origin, vOrigin);
					vAngle[0] -= 90.0;
					set_entvar(reviveEffect, var_angles, vAngle);

					ChildrenParent_Entity(entityIndex, reviveEffect);
					Play_Animation(reviveEffect, "idle", 1.0);
				}
			}
		} else {
			set_entvar(entityIndex, var_animtime, get_gametime());
			set_entvar(entityIndex, var_framerate, 5.0);
			set_entvar(entityIndex, var_sequence, 0);
		}
		return HAM_IGNORED;
	}

	if(get_entvar(entityIndex, var_flags) & FL_ONGROUND)
	{
		set_entvar(entityIndex, var_avelocity, Float:{0.0, 0.0, 0.0});
		set_entvar(entityIndex, var_angles, Float:{0.0, 0.0, 0.0});
		set_entvar(entityIndex, var_sequence, 0);
	} else {
		set_entvar(entityIndex, var_animtime, get_gametime());
		set_entvar(entityIndex, var_framerate, 5.0);
		set_entvar(entityIndex, var_sequence, 1);
	}

	static Float:dmgtime; get_entvar(entityIndex, var_dmgtime, dmgtime);
	if((dmgtime - 0.5) <= get_gametime())
	{
		if(get_entvar(entityIndex, var_fuser1) <= get_gametime())
		{
			new Float:vOrigin[3]; GetBonePosition(entityIndex, 0, vOrigin, Float:{0.0, 0.0, 0.0});
			
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
			write_byte(TE_SPARKS);
			write_coord_f(vOrigin[0]);
			write_coord_f(vOrigin[1]);
			write_coord_f(vOrigin[2]);
			message_end();

			set_entvar(entityIndex, var_fuser1, get_gametime() + 0.1);
		}

		if(!get_entvar(entityIndex, var_iuser4))
		{
			set_entvar(entityIndex, var_iuser4, 1);
			rh_emit_sound(entityIndex, 0, CHAN_ITEM, Skill_Resources[6], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		}
	}

	if(get_entvar(entityIndex, var_fuser2) <= get_gametime())
	{
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
		write_byte(TE_BEAMFOLLOW);
		write_short(entityIndex | 0x1000);
		write_short(laserBeam);
		write_byte(15); // life
		write_byte(1);
		write_byte(155);
		write_byte(0);
		write_byte(255);
		write_byte(90);
		message_end();

		set_entvar(entityIndex, var_fuser2, get_gametime() + 9999.0);
	}

	if(dmgtime > get_gametime())
		return HAM_IGNORED

	new clientIndex = get_entvar(entityIndex, var_owner);
	new Float:vOrigin[3], Float:vTarget[3]; get_entvar(entityIndex, var_origin, vOrigin);
	rh_emit_sound(entityIndex, 0, CHAN_STATIC, Skill_Resources[7], 1.0, ATTN_NONE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	vOrigin[2] += 1.0;
	for(new index = 0, bombEntity; index < 4; index++)
	{
		vTarget = vOrigin;
		bombEntity = Create_RazeBomb(vOrigin, clientIndex, entityIndex);
		if(bombEntity != NULLENT)
		{
			switch(index)
			{
				case 0: vTarget[0] -= 60.0;
				case 1: vTarget[0] += 60.0;
				case 2: vTarget[1] -= 60.0;
				case 3: vTarget[1] += 60.0;
			}

			HookEnt(bombEntity, vTarget, 60.0, false);
			get_entvar(bombEntity, var_velocity, vTarget);
			vTarget[2] = 300.0;
			set_entvar(bombEntity, var_velocity, vTarget);
		}
	}
	
	set_entvar(entityIndex, var_effects, get_entvar(entityIndex, var_effects) | EF_NODRAW);

	vOrigin[2] += 40.0;
	rg_dmg_radius(vOrigin, entityIndex, clientIndex, 250.0, 200.0, 0, DMG_CLUB);
	Create_Model_Sprite(clientIndex, Skill_Resources[8], vOrigin, VP_PARALLEL, 0, 0.03, 0.0, 0.0, 0, 0.0, 41, false, false);
	UTIL_RemoveEntity(entityIndex, 3.0);
	return HAM_SUPERCEDE;
}

Create_RazeBomb(Float:vOrigin[3], const clientIndex, const grenadeEntity)
{
	new bombEntity = rg_create_entity("info_target");
	if(!is_nullent(bombEntity))
	{
		set_entvar(bombEntity, var_movetype, MOVETYPE_PUSHSTEP);
		set_entvar(bombEntity, var_solid, SOLID_TRIGGER);

		set_entvar(bombEntity, var_origin, vOrigin);
		set_entvar(bombEntity, var_team, get_entvar(clientIndex, var_team));
		set_entvar(bombEntity, var_owner, clientIndex);
		set_entvar(bombEntity, var_iuser1, grenadeEntity);

		engfunc(EngFunc_SetModel, bombEntity, Skill_Resources[17]);

		remove_task(bombEntity+TASK_BOMB, 1);
		new params[1]; params[0] = bombEntity;
		set_task(0.7, "Task_Bomb2_Sounds", bombEntity+TASK_BOMB, params, sizeof(params));
		set_task(1.0, "Task_Bomb2_Ready", bombEntity+TASK_BOMB, params, sizeof(params));
		set_task(random_float(1.3, 1.6), "Task_Bomb2_Explosion", bombEntity+TASK_BOMB, params, sizeof(params));

		new Float:vAngle[3];
		vAngle[1] = random_float(0.0, 360.0);
		set_entvar(bombEntity, var_angles, vAngle);

		set_entvar(bombEntity, var_avelocity, Float:{0.0, 600.0, 200.0});
		set_entvar(bombEntity, var_animtime, get_gametime());
		set_entvar(bombEntity, var_framerate, 2.0);
		set_entvar(bombEntity, var_sequence, random_num(2, 5));
		set_entvar(bombEntity, var_frame, 0.0);

		set_entvar(bombEntity, var_netname, fmt("%L", LANG_PLAYER, Agent_Skills[AGENT_RAZE][SKILL_NAME]));

		static Float:vMins[3] = {-1.0, -1.0, 0.0};
		static Float:vMaxs[3] = {1.0, 1.0, 1.0};
		engfunc(EngFunc_SetSize, bombEntity, vMins, vMaxs);
		set_entvar(bombEntity, var_mins, vMins); 
		set_entvar(bombEntity, var_maxs, vMaxs); 
		set_entvar(bombEntity, var_absmin, vMins);
		set_entvar(bombEntity, var_absmax, vMaxs);

		Entity_Will_Remove_NewRound(bombEntity, true);
		ChildrenParent_Entity(clientIndex, bombEntity);

		message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
		write_byte(TE_BEAMFOLLOW);
		write_short(bombEntity | 0x1000);
		write_short(laserBeam);
		write_byte(15); // life
		write_byte(1);
		write_byte(155);
		write_byte(0);
		write_byte(255);
		write_byte(90);
		message_end();	

		rh_emit_sound(bombEntity, 0, CHAN_ITEM, Skill_Resources[9], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);

		bMuteEntity[bombEntity] = true;
		bEntityHaveTeam[bombEntity] = true;
		bRazeBomb[bombEntity] = true;

		SetThink(bombEntity, "Think_Bomb_OnGround");
		set_entvar(bombEntity, var_nextthink, get_gametime());
		return bombEntity;
	}

	return NULLENT;
}

public Think_Bomb_OnGround(const bombEntity)
{
	if(get_entvar(bombEntity, var_flags) & FL_ONGROUND)
	{
		set_entvar(bombEntity, var_avelocity, Float:{0.0, 0.0, 0.0});
		set_entvar(bombEntity, var_animtime, get_gametime());
		set_entvar(bombEntity, var_framerate, 1.0);
		set_entvar(bombEntity, var_sequence, 0);
		set_entvar(bombEntity, var_frame, 0.0);
		new Float:vAngles[3]; get_entvar(bombEntity, var_angles, vAngles);
		vAngles[0] = 0.0;
		set_entvar(bombEntity, var_angles, vAngles);
		return;
	}
	set_entvar(bombEntity, var_nextthink, get_gametime());
}

public Task_Bomb2_Sounds(params[], taskid)
{
	new bombEntity = params[0];

	rh_emit_sound(bombEntity, 0, CHAN_ITEM, Skill_Resources[9], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	new param[1]; param[0] = bombEntity;
	set_task(0.7, "Task_Bomb2_Sounds", bombEntity+TASK_BOMB, param, sizeof(param));
}

public Task_Bomb2_Ready(params[], taskid)
{
	new bombEntity = params[0];
	
	new Float:vOrigin[3]; GetBonePosition(bombEntity, 0, vOrigin, Float:{0.0, 0.0, 0.0});
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(TE_SPARKS);
	write_coord_f(vOrigin[0]);
	write_coord_f(vOrigin[1]);
	write_coord_f(vOrigin[2]);
	message_end();

	new param[1]; param[0] = bombEntity;
	set_task(0.1, "Task_Bomb2_Ready", bombEntity+TASK_BOMB, param, sizeof(param));
}

public Task_Bomb2_Explosion(params[], taskid)
{
	new bombEntity = params[0];
	
	new Float:vOrigin[3]; get_entvar(bombEntity, var_origin, vOrigin);
	rh_emit_sound(bombEntity, 0, CHAN_STATIC, Skill_Resources[random_num(10, 12)], 0.6, ATTN_NONE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	new clientIndex = get_entvar(bombEntity, var_owner);
	vOrigin[2] += 36.0;
	rg_dmg_radius(vOrigin, get_entvar(bombEntity, var_iuser1), clientIndex, 120.0, 150.0, 0, DMG_CLUB);
	Create_Model_Sprite(clientIndex, Skill_Resources[13], vOrigin, VP_PARALLEL, 0, 0.03, 0.0, 0.0, 0, 0.0, 26, false, false);
	UTIL_RemoveEntity(bombEntity, 0.0);
}

public Set_Player_RoomType(const clientIndex, bool:bActive)
{
	if(bActive)
	{
		playerRoomType[clientIndex] = floatround(get_member(clientIndex, m_flSndRoomtype));

		emessage_begin(MSG_ONE, SVC_ROOMTYPE, .player = clientIndex);
		ewrite_short(16);
		emessage_end();
	} else if(playerRoomType[clientIndex] != NULLENT) {
		emessage_begin(MSG_ONE, SVC_ROOMTYPE, .player = clientIndex);
		ewrite_short(playerRoomType[clientIndex]);
		emessage_end();

		playerRoomType[clientIndex] = NULLENT;
	}
}

public Change_Fog(const clientIndex, const Density, const Red, const Green, const Blue) 
{
	if(Red == 0 && Green == 0 && Blue == 0 && Density == 0)
	{	
		if(mySkyBox[clientIndex] > 0)
		{
			set_entvar(mySkyBox[clientIndex], var_flags, FL_KILLME);
			mySkyBox[clientIndex] = NULLENT;
		}
	} else if(mySkyBox[clientIndex] <= 0) {
		mySkyBox[clientIndex] = CreateSky(clientIndex);
	}

	static Density2; Density2 = (4 * Density);
	if(clientIndex <= 0) message_begin(MSG_BROADCAST, Message_Fog);
	else message_begin(MSG_ONE, Message_Fog, _, clientIndex);
	write_byte(Red);
	write_byte(Green);
	write_byte(Blue); 
	write_byte(g_fog_density[Density2]); 
	write_byte(g_fog_density[Density2+1]); 
	write_byte(g_fog_density[Density2+2]); 
	write_byte(g_fog_density[Density2+3]);
	message_end();
}

public CreateSky(const clientIndex)
{
	new skyEntity = rg_create_entity("info_target");
	if (skyEntity != NULLENT)
	{
		engfunc(EngFunc_SetModel, skyEntity, Skill_Resources[18]);
		
		set_entvar(skyEntity, var_sequence, 0);
		set_entvar(skyEntity, var_framerate, 1.0);
		set_entvar(skyEntity, var_owner, clientIndex);
		set_entvar(skyEntity, var_light_level, 10.0);
		set_entvar(skyEntity, var_origin, Float:{0.0, 0.0, 0.0});
		set_entvar(skyEntity, var_effects, EF_FORCEVISIBILITY | EF_OWNER_VISIBILITY);

		bSkyBoxEntity[skyEntity] = true;
	}
	return skyEntity;
}

SetPlayerLight(const clientIndex, const LightStyle[])
{
	new light[5];
	formatex(light, charsmax(light), LightStyle);

	if(equal(light, "n"))
	{
		new szMapName[32]; get_mapname(szMapName, 31);
		if (contain(szMapName, "library") >= 0) formatex(light, charsmax(light), "e");
	}


	if(clientIndex > 0) message_begin(MSG_ONE, SVC_LIGHTSTYLE, .player = clientIndex);
	else message_begin(MSG_BROADCAST, SVC_LIGHTSTYLE);
	write_byte(0);
	write_string(light);
	message_end();
}

public Think_Leer_Helper(const entityIndex)
{
	new parentIndex = get_entvar(entityIndex, var_owner);

	static Float:vParentOrigin[3], Float:vParentPosition[3], Float:vParentAngles[3]; 
	get_entvar(parentIndex, var_v_angle, vParentAngles);
	GetPosition(parentIndex, 20.0, 8.0, 0.0, vParentOrigin, vParentAngles, true, Float:{0.0, 0.0, 0.0}, false);
	GetPosition(parentIndex, 350.0, 0.0, 0.0, vParentPosition, vParentAngles, true, Float:{0.0, 0.0, 0.0}, false);
	vParentAngles[1] -= 90.0;
	set_entvar(entityIndex, var_angles, vParentAngles);
	
	if(vParentAngles[0] <= 25.0)
	{
		engfunc(EngFunc_TraceHull, vParentPosition, vParentPosition, IGNORE_MONSTERS, HULL_HEAD, parentIndex, 0); 
		if(!get_tr2(0, TR_AllSolid))
		{
			set_entvar(entityIndex, var_velocity, {0.1, 0.1, 0.1});
			set_entvar(entityIndex, var_origin, vParentPosition);
			bSeeEye[parentIndex] = false;
			set_entvar(entityIndex, var_nextthink, get_gametime());
			return;
		}
	}

	engfunc(EngFunc_TraceHull, vParentOrigin, vParentPosition, IGNORE_MONSTERS, HULL_POINT, parentIndex, 0); 
	new Float:flFraction; get_tr2(0, TR_flFraction, flFraction);
	if(flFraction != 1.0)
	{
		get_tr2(0, TR_vecEndPos, vParentPosition);	

		static Float:vecPlaneNormal[3]; get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal);
		xs_vec_mul_scalar(vecPlaneNormal, 25.0, vecPlaneNormal);
		xs_vec_add(vParentPosition, vecPlaneNormal, vParentPosition);
	}

	set_entvar(entityIndex, var_velocity, {0.1, 0.1, 0.1});
	set_entvar(entityIndex, var_origin, vParentPosition);
	bSeeEye[parentIndex] = true;
	set_entvar(entityIndex, var_nextthink, get_gametime());
}

public Create_Reyna_Leer(const clientIndex)
{
	new eyeEntity = rg_create_entity("info_target");
	if (!is_nullent((eyeEntity)))
	{
		engfunc(EngFunc_SetModel, eyeEntity, Skill_Resources[21]);  

		set_entvar(eyeEntity, var_rendermode, kRenderTransAdd);   
		set_entvar(eyeEntity, var_renderamt, 255.0);   

		set_entvar(eyeEntity, var_owner, clientIndex);
		if(!bSeeEye[clientIndex])
		{
			set_entvar(eyeEntity, var_movetype, MOVETYPE_NOCLIP);
		} else {
			set_entvar(eyeEntity, var_movetype, MOVETYPE_FLY);
			SetTouch(eyeEntity, "Touch_Eye");
		}
		set_entvar(eyeEntity, var_solid, SOLID_TRIGGER); 

		set_entvar(eyeEntity, var_animtime, get_gametime());
		set_entvar(eyeEntity, var_frame, 0.0);
		set_entvar(eyeEntity, var_framerate, 20.0);
		set_entvar(eyeEntity, var_sequence, 0);
		set_entvar(eyeEntity, var_body, 1);

		set_entvar(eyeEntity, var_team, get_entvar(clientIndex, var_team));

		new Float:vOrigin[3]; GetPosition(clientIndex, 20.0, 8.0, 0.0, vOrigin, Float:{0.0, 0.0, 0.0}, false, Float:{0.0, 0.0, 0.0}, false);
		set_entvar(eyeEntity, var_origin, vOrigin);

		set_entvar(eyeEntity, var_mins, Float:{ -1.0, -1.0, -1.0 }); 
		set_entvar(eyeEntity, var_maxs, Float:{ 1.0, 1.0, 1.0 }); 

		Entity_Will_Remove_NewRound(eyeEntity, true);

		GetPosition(clientIndex, 1000.0, 0.0, 0.0, vOrigin, Float:{0.0, 0.0, 0.0}, false, Float:{0.0, 0.0, 0.0}, false);
		HookEnt(eyeEntity, vOrigin, 1000.0, true);

		SetThink(eyeEntity, "Think_Eye_Delay");
		set_entvar(eyeEntity, var_nextthink, get_gametime() + 0.35);

		for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, playerIndex; arrayIndex >= 0; arrayIndex--)
		{
			playerIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);
			if(playerTEAM[playerIndex] != playerTEAM[clientIndex])
			{
				rh_emit_sound(eyeEntity, playerIndex, CHAN_NETWORKVOICE_END, Skill_Resources[23], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			} else {
				rh_emit_sound(eyeEntity, playerIndex, CHAN_NETWORKVOICE_END, Skill_Resources[22], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			}
		}
	} 
}

public Think_Eye_Delay(const eyeEntity)
{
	new Float:vEyeOrigin[3], Float:vVelocity[3], Float:vAngle[3], Float:vForward[3]; get_entvar(eyeEntity, var_origin, vEyeOrigin), get_entvar(eyeEntity, var_velocity, vVelocity);
	vector_to_angle(vVelocity, vAngle);
	vAngle[0] *= -1.0;
	angle_vector(vAngle, ANGLEVECTOR_FORWARD, vForward);

	vVelocity[0] = vEyeOrigin[0] + vForward[0] * 25.0;
	vVelocity[1] = vEyeOrigin[1] + vForward[1] * 25.0;
	vVelocity[2] = vEyeOrigin[2] + vForward[2] * 25.0;

	engfunc(EngFunc_TraceLine, vEyeOrigin, vVelocity, IGNORE_MONSTERS, eyeEntity, 0); 
	new Float:flFraction; get_tr2(0, TR_flFraction, flFraction);
	if(flFraction != 1.0)
	{
		static Float:vecPlaneNormal[3]; get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal);
		xs_vec_mul_scalar(vecPlaneNormal, 33.0, vecPlaneNormal);
		xs_vec_add(vEyeOrigin, vecPlaneNormal, vEyeOrigin);
	}

	new clientIndex = get_entvar(eyeEntity, var_owner);
	new eyeStartEntity = Create_View_Sprite(clientIndex, Skill_Resources[14], 0, 0, 0.3, 0.0, 0.0, 1.0, 12.0, 0.075, false, 0, false);
	if(eyeStartEntity != NULLENT)
	{
		set_entvar(eyeStartEntity, var_origin, vEyeOrigin);

		for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, playerIndex; arrayIndex >= 0; arrayIndex--)
		{
			playerIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);
			if(playerTEAM[playerIndex] != playerTEAM[clientIndex])
			{
				rh_emit_sound(eyeEntity, playerIndex, CHAN_NETWORKVOICE_END, Skill_Resources[25], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			} else {
				rh_emit_sound(eyeEntity, playerIndex, CHAN_NETWORKVOICE_END, Skill_Resources[24], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			}
		}
		new params[1]; params[0] = eyeStartEntity;
		set_task(0.4, "Task_Eye_Loop", eyeStartEntity+TASK_VIEWSPRITE, params, sizeof(params));
	}

	set_entvar(eyeEntity, var_flags, FL_KILLME);
}

public Touch_Eye(const eyeEntity, const victimIndex)
{
	if(is_user_alive(victimIndex))
		return;

	SetTouch(eyeEntity, "");
	Think_Eye_Delay(eyeEntity);
}

public Task_Eye_Loop(params[], taskid)
{
	new eyeStartEntity = params[0];

	new Float:vEyeOrigin[3]; get_entvar(eyeStartEntity, var_origin, vEyeOrigin);
	new clientIndex = get_entvar(eyeStartEntity, var_owner);
	new eyeLoopEntity = Create_View_Sprite(clientIndex, Skill_Resources[15], 0, 0, 0.3, 0.0, 2.0, 1.0, 11.0, 0.085, true, 0, false);
	if((eyeLoopEntity) != NULLENT)
	{
		set_entvar(eyeLoopEntity, var_origin, vEyeOrigin);

		set_entvar(eyeLoopEntity, var_solid, SOLID_BBOX);
		set_entvar(eyeLoopEntity, var_movetype, MOVETYPE_NOCLIP);
		set_entvar(eyeLoopEntity, var_takedamage, DAMAGE_YES);
		set_entvar(eyeLoopEntity, var_health, 100.0);
		set_entvar(eyeLoopEntity, var_team, get_entvar(clientIndex, var_team));

		bEyeEntity[eyeLoopEntity] = true;	

		static Float:Mins[3] = { -15.0, -15.0, -10.0 }; 
		static Float:Maxs[3] = { 15.0, 15.0, 10.0 };

		engfunc(EngFunc_SetSize, eyeLoopEntity, Mins, Maxs);
		set_entvar(eyeLoopEntity, var_mins, Mins); 
		set_entvar(eyeLoopEntity, var_maxs, Maxs); 
		set_entvar(eyeLoopEntity, var_absmin, Mins);
		set_entvar(eyeLoopEntity, var_absmax, Maxs);

		Entity_Will_Remove_NewRound(eyeLoopEntity, true);

		Semiclip_Entity(eyeLoopEntity, TEAM_ATTACKERS);
		Semiclip_Entity(eyeLoopEntity, TEAM_DEFENDERS);

		RequestFrame("Eye_Blind_Enemies", eyeLoopEntity); 
	}
}

public Eye_Blind_Enemies(eyeEntity)
{
	if(is_nullent(eyeEntity))
		return;
	if(get_entvar(eyeEntity, var_flags) & FL_KILLME)
		return;

	new params[1]; 
	static Float:vOrigin[3]; get_entvar(eyeEntity, var_origin, vOrigin);
	for(new arrayIndex = ArraySize(Array_playerALIVE)-1, playerIndex, viewEntity; arrayIndex >= 0; arrayIndex--)
	{
		playerIndex = ArrayGetCell(Array_playerALIVE, arrayIndex);
		if(playerInBASE[playerIndex])
			continue;
		viewEntity = get_viewent(playerIndex);
		viewEntity = viewEntity == -1 ? playerIndex : viewEntity;
		if(get_entvar(playerIndex, var_team) == get_entvar(eyeEntity, var_team))
			continue;
		if(!CanSee2(viewEntity, eyeEntity))
			continue;
		if(viewEntity > MAX_PLAYERS)
		{
			if(!DistanceEntityAngles(viewEntity, eyeEntity, 90.0))
				continue;
		} else {
			if(!is_in_viewcone(viewEntity, vOrigin, 1))
				continue;
		}

		if(!isPlayerBlind[playerIndex])
		{
			new blindEntity = Create_Model_Sprite(playerIndex, Skill_Resources[39], Float:{0.0, 0.0, 0.0}, VP_PARALLEL_ORIENTED, 0, 0.05, 0.0, 0.0, playerIndex, 36.0, 5, true, false);
			bEntityHaveTeam[blindEntity] = true;
			set_entvar(blindEntity, var_team, playerTEAM[playerIndex]);
			isPlayerBlind[playerIndex] = true;
			PlaySound(playerIndex, Skill_Resources[19]);
			Change_Fog(playerIndex, 9, 155, 50, 255);
			SetPlayerLight(playerIndex, "a");
			Set_Player_RoomType(playerIndex, true);
		}

		if(is_user_bot(playerIndex))
		{
			set_entvar(playerIndex, var_maxspeed, 0.1);
		}

		remove_task(playerIndex+TASK_LEERBLIND, 1);
		params[0] = playerIndex;	
		set_task(0.1, "Task_UnBlind", playerIndex+TASK_LEERBLIND, params, sizeof(params));
	}

	RequestFrame("Eye_Blind_Enemies", eyeEntity); 
}

public Task_UnBlind(params[], taskid)
{
	new clientIndex = params[0]; 
	if(!isPlayerBlind[clientIndex])
		return;

	if(entityTotalCHILDRENS[clientIndex] > 0)
	{
		for(new arrayIndex = entityTotalCHILDRENS[clientIndex]-1, entityMODEL[128], childrenEntity; arrayIndex >= 0; arrayIndex--)
		{
			childrenEntity = ArrayGetCell(entityCHILDRENS[clientIndex], arrayIndex);
			get_entvar(childrenEntity, var_model, entityMODEL, charsmax(entityMODEL));

			if(!equal(entityMODEL, Skill_Resources[39]))
				continue;

			UTIL_RemoveEntity(childrenEntity, 0.0);
		}
	}

	isPlayerBlind[clientIndex] = false;
	Change_Fog(clientIndex, 0, 0, 0, 0);
	SetPlayerLight(clientIndex, "n");
	PlaySound(clientIndex, Skill_Resources[20]);
	Set_Player_RoomType(clientIndex, false);

	if(is_user_bot(clientIndex))
	{
		if(bRealBot[clientIndex])
		{
			remove_task(clientIndex+TASK_BOT_FIRE, 1);

			new enemyIndex = botEnemy[clientIndex];
			botEnemy[clientIndex] = NULLENT;
			if(enemyIndex != NULLENT)
			{
				new iArrayID;
				if((iArrayID = ArrayFindValue(playerEnemy[enemyIndex], clientIndex)) != -1)
				{
					ArrayDeleteItem(playerEnemy[enemyIndex], iArrayID);
					totalMyEnemy[enemyIndex]--;
				}	
			}
		}
		rg_reset_maxspeed(clientIndex);
	}
}

bool:DistanceEntityAngles(const Entity, const iTarget, const Float:ViewDis)
{
	static Float:Origin[3]; get_entvar(Entity, var_origin, Origin);
	static Float:Angles[3]; get_entvar(Entity, Entity > MAX_PLAYERS ? var_angles : var_v_angle, Angles);
	static Float:Target[3]; get_entvar(iTarget, var_origin, Target);
	static Float:X; X = Target[0] - Origin[0];
	static Float:Y; Y = Target[1] - Origin[1];
	static Float:Radians; Radians = floatatan2(Y, X, radian);
	static Float:GoalAngles[3]; GoalAngles[1] = Radians * (180 / 3.14);
    	
	static Float:Distance; Distance = 180.0 - floatabs(floatabs(GoalAngles[1] - Angles[1]) - 180.0);
	if(Distance <= (ViewDis*0.5)) return true;
	return false;
}   

enum Coord_e { Float:x, Float:y, Float:z };
bool:Kurtar(const clientIndex, const i_StartDistance, const i_MaxAttempts)
{
	static Float:vf_OriginalOrigin[Coord_e], Float:vf_NewOrigin[Coord_e];
	static i_Attempts, i_Distance;
	
	// --| Get the current player's origin.
	get_entvar(clientIndex, var_origin, vf_OriginalOrigin);
	engfunc(EngFunc_TraceHull, vf_OriginalOrigin, vf_OriginalOrigin, IGNORE_MONSTERS, clientIndex <= MAX_PLAYERS ? (get_entvar(clientIndex, var_flags) & FL_DUCKING ? HULL_HEAD : HULL_HUMAN) : HULL_HEAD, clientIndex, 0);

	if(!get_tr2(0, TR_InOpen) || get_tr2(0, TR_AllSolid) || get_tr2(0, TR_StartSolid))
	{
		i_Distance = i_StartDistance;
		
		while (i_Distance < 1000)
		{
			i_Attempts = i_MaxAttempts;
			
			while (i_Attempts--)
			{
				vf_NewOrigin[x] = random_float(vf_OriginalOrigin[x] - i_Distance, vf_OriginalOrigin[x] + i_Distance);
				vf_NewOrigin[y] = random_float(vf_OriginalOrigin[y] - i_Distance, vf_OriginalOrigin[y] + i_Distance);
				vf_NewOrigin[z] = random_float(vf_OriginalOrigin[z] - i_Distance, vf_OriginalOrigin[z] + i_Distance);
			
				engfunc(EngFunc_TraceHull, vf_NewOrigin, vf_NewOrigin, DONT_IGNORE_MONSTERS, clientIndex <= MAX_PLAYERS ? (get_entvar(clientIndex, var_flags) & FL_DUCKING ? HULL_HEAD : HULL_HUMAN) : HULL_HEAD, clientIndex, 0);
			
				// --| Free space found.
				if (get_tr2(0, TR_InOpen) && !get_tr2(0, TR_AllSolid) && !get_tr2(0, TR_StartSolid))
				{
					// --| Set the new origin .
					engfunc(EngFunc_SetOrigin, clientIndex, vf_NewOrigin);
					return true;
				}
			}
			
			i_Distance += i_StartDistance;
		}
	}
	
	return false;
}    


bool:CanSee2(const clientIndex, const targetIndex)
{
	static flags; flags = get_entvar(clientIndex, var_flags);
	if (flags & EF_NODRAW || flags & FL_NOTARGET)
	{
		return false;
	}

	static Float:lookerOrig[3];
	static Float:targetBaseOrig[3];
	static Float:targetOrig[3];
	static Float:temp[3];

	get_entvar(clientIndex, var_origin, lookerOrig);
	get_entvar(clientIndex, var_view_ofs, temp);
	xs_vec_add(lookerOrig, temp, lookerOrig);

	get_entvar(targetIndex, var_origin, targetBaseOrig);
	get_entvar(targetIndex, var_view_ofs, temp);
	xs_vec_add(targetBaseOrig, temp, targetOrig);

	engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, IGNORE_MONSTERS, clientIndex, 0);
	if (get_tr2(0, TraceResult:TR_InOpen) && get_tr2(0, TraceResult:TR_InWater))
	{
		return false;
	} 
	else 
	{
		static Float:flFraction;
		get_tr2(0, TraceResult:TR_flFraction, flFraction);
		if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
		{
			return true;
		}
		else
		{
			targetOrig = targetBaseOrig;
			engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, IGNORE_MONSTERS, clientIndex, 0); 
			get_tr2(0, TraceResult:TR_flFraction, flFraction);
			if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
			{
				return true;
			}
			else
			{
				targetOrig = targetBaseOrig;
				targetOrig[2] -= 17.0;
				engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, IGNORE_MONSTERS, clientIndex, 0); 
				get_tr2(0, TraceResult:TR_flFraction, flFraction);
				if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
				{
					return true;
				}
			}
		}
	}
	return false;
}

bool:CanSee3(const clientIndex, const targetIndex)
{
	static flags; flags = get_entvar(clientIndex, var_flags);
	if (flags & EF_NODRAW || flags & FL_NOTARGET)
	{
		return false;
	}

	static Float:lookerOrig[3];
	static Float:targetBaseOrig[3];
	static Float:targetOrig[3];
	static Float:temp[3];

	get_entvar(clientIndex, var_origin, lookerOrig);
	get_entvar(clientIndex, var_view_ofs, temp);
	xs_vec_add(lookerOrig, temp, lookerOrig);

	get_entvar(targetIndex, var_origin, targetBaseOrig);
	get_entvar(targetIndex, var_view_ofs, temp);
	xs_vec_add(targetBaseOrig, temp, targetOrig);

	engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, DONT_IGNORE_MONSTERS, clientIndex, 0);
	if (get_tr2(0, TraceResult:TR_InOpen) && get_tr2(0, TraceResult:TR_InWater))
	{
		return false;
	} 
	else 
	{
		static Float:flFraction;
		get_tr2(0, TraceResult:TR_flFraction, flFraction);
		if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
		{
			return true;
		}
		else
		{
			targetOrig = targetBaseOrig;
			engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, DONT_IGNORE_MONSTERS, clientIndex, 0); 
			get_tr2(0, TraceResult:TR_flFraction, flFraction);
			if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
			{
				return true;
			}
			else
			{
				targetOrig = targetBaseOrig;
				targetOrig[2] -= 17.0;
				engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, DONT_IGNORE_MONSTERS, clientIndex, 0); 
				get_tr2(0, TraceResult:TR_flFraction, flFraction);
				if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == targetIndex))
				{
					return true;
				}
			}
		}
	}
	return false;
}

bool:isPointAvailable(const clientIndex, const Float:vOrigin[3])
{
	static Float:vPosition[3], Float:fFraction;

	vPosition[0] = vOrigin[0];
	vPosition[1] = vOrigin[1];
	vPosition[2] = vOrigin[2] - 9000.0;

	engfunc(EngFunc_TraceLine, vOrigin, vPosition, IGNORE_MONSTERS, clientIndex, 0);
	get_tr2(0, TR_flFraction, fFraction);

	vPosition = vOrigin;
	vPosition[2] -= (9000.0*fFraction);

	if((vOrigin[2] - vPosition[2]) > 10.0)
	{
		return false;
	}

	vPosition[2] += 36.1;
	engfunc(EngFunc_TraceHull, vPosition, vPosition, IGNORE_MONSTERS, HULL_HUMAN, clientIndex, 0);
	if(get_tr2(0, TR_AllSolid))
	{
		return false;
	}
	
	return true;
}

public Set_Player_View(const clientIndex, const Float:fForwardAdd, const Float:fRightAdd, const Float:fUpAdd, const Float:fDistance, const iParent)
{
	new iCameraEntity;
	if((iCameraEntity = cameraEntity[clientIndex]) <= 0) iCameraEntity = rg_create_entity("info_target"); 
	
	if(!is_nullent(iCameraEntity))
	{
		new Float:Position[3]; 
		Position[0] = fForwardAdd;
		Position[1] = fRightAdd;
		Position[2] = fUpAdd;

		if(iParent != clientIndex) ChildrenParent_Entity(clientIndex, iCameraEntity);
		ChildrenParent_Entity(iParent, iCameraEntity);

		bCameraEntity[iCameraEntity] = true;
		set_entvar(iCameraEntity, var_vuser1, Position);
		set_entvar(iCameraEntity, var_fuser1, fDistance);
		set_entvar(iCameraEntity, var_parent, iParent);

		if(cameraEntity[clientIndex] != iCameraEntity)
		{
			engfunc(EngFunc_SetModel, iCameraEntity, "models/rpgrocket.mdl");

			set_entvar(iCameraEntity, var_rendermode, kRenderTransTexture);  
			set_entvar(iCameraEntity, var_renderamt, 0.1);     

			set_entvar(iCameraEntity, var_owner, clientIndex);
			set_entvar(iCameraEntity, var_movetype, MOVETYPE_BOUNCEMISSILE);

			SetThink(iCameraEntity, "Think_Camera");
			Think_Camera(iCameraEntity);
			
			engset_view(clientIndex, iCameraEntity);
		}

		cameraEntity[clientIndex] = iCameraEntity;
		return iCameraEntity;
	}

	cameraEntity[clientIndex] = NULLENT;
	return NULLENT;
}

public Think_Camera(const iCameraEntity)
{
	static iParent, iOwner, Float:vCameraPosition[3], Float:vParentOrigin[3], Float:fDistance, Float:vAngles[3], Float:flFraction;  
	iParent = get_entvar(iCameraEntity, var_parent); 
	if(is_nullent(iParent))
	{	
		set_entvar(iCameraEntity, var_flags, FL_KILLME);
		return;
	}
	iOwner = get_entvar(iCameraEntity, var_owner);
	get_entvar(iCameraEntity, var_vuser1, vCameraPosition);
	get_entvar(iCameraEntity, var_fuser1, fDistance);
	get_entvar(iOwner, var_v_angle, vAngles);
	fDistance *= -1.0;

	GetPosition(iParent, 9.0, 0.0, 0.0, vParentOrigin, vAngles, true, Float:{0.0, 0.0, 0.0}, false);
	fDistance += vCameraPosition[0];
	GetPosition(iParent, fDistance, vCameraPosition[1], vCameraPosition[2], vCameraPosition, vAngles, true, vParentOrigin, true);

	engfunc(EngFunc_TraceHull, vParentOrigin, vCameraPosition, IGNORE_MONSTERS, HULL_POINT, iParent, 0);
	get_tr2(0, TR_flFraction, flFraction);
	if(flFraction != 1.0)
	{ 
		get_tr2(0, TR_vecEndPos, vCameraPosition);
		static Float:vecPlaneNormal[3]; get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal);
		xs_vec_mul_scalar(vecPlaneNormal, 5.0, vecPlaneNormal);
		xs_vec_add(vCameraPosition, vecPlaneNormal, vCameraPosition);
		
		//Set_Position(iParent, (flFraction*fDistance), 0.0, 0.0, vCameraPosition, vAngles, true, vParentOrigin, false);
	} 
	
	set_entvar(iCameraEntity, var_origin, vCameraPosition);
	set_entvar(iCameraEntity, var_angles, vAngles);
	set_entvar(iCameraEntity, var_nextthink, get_gametime());
}

public Get_Player_ViewEntity(const clientIndex)
{
	if(clientIndex > 0 && clientIndex <= MAX_PLAYERS) 
		return cameraEntity[clientIndex];

	return NULLENT;
}	

public Create_Fade_Prowler(const clientIndex)
{
	new moveEntity = rg_create_entity("info_target");
	if (!is_nullent((moveEntity)))
	{
		engfunc(EngFunc_SetModel, moveEntity, "models/rpgrocket.mdl");  
		set_entvar(moveEntity, var_owner, clientIndex);

		set_entvar(moveEntity, var_movetype, MOVETYPE_BOUNCEMISSILE);
		set_entvar(moveEntity, var_solid, SOLID_TRIGGER); 
		set_entvar(moveEntity, var_effects, get_entvar(moveEntity, var_effects) | EF_NODRAW);

		new Float:vOrigin[3]; GetPosition(clientIndex, 0.0, 0.0, 0.0, vOrigin, Float:{0.0, 0.0, 0.0}, false, Float:{0.0, 0.0, 0.0}, false);
		set_entvar(moveEntity, var_origin, vOrigin);
		get_entvar(clientIndex, var_v_angle, vOrigin);
		vOrigin[0] *= -1.0;
		set_entvar(moveEntity, var_angles, vOrigin);

		static Float:Mins[3] = { -1.0, -1.0, -1.0 }; 
		static Float:Maxs[3] = { 1.0, 1.0, 1.0 };

		engfunc(EngFunc_SetSize, moveEntity, Mins, Maxs);
		set_entvar(moveEntity, var_mins, Mins); 
		set_entvar(moveEntity, var_maxs, Maxs); 
		set_entvar(moveEntity, var_absmin, Mins);
		set_entvar(moveEntity, var_absmax, Maxs);

		Entity_Will_Remove_NewRound(moveEntity, true);
		ChildrenParent_Entity(clientIndex, moveEntity);

		SetThink(moveEntity, "Think_Prowler_Move");
		set_entvar(moveEntity, var_nextthink, get_gametime());
	} 

	new prowlerEntity = rg_create_entity("info_target");
	if (!is_nullent((prowlerEntity)))
	{
		engfunc(EngFunc_SetModel, prowlerEntity, Skill_Resources[40]);  
		set_entvar(prowlerEntity, var_owner2, clientIndex);

		set_entvar(prowlerEntity, var_movetype, MOVETYPE_BOUNCEMISSILE);
		set_entvar(prowlerEntity, var_solid, SOLID_BBOX); 
		set_entvar(prowlerEntity, var_parent, moveEntity); 
		set_entvar(moveEntity, var_parent, prowlerEntity); 

		Play_Animation(prowlerEntity, "spottedrun", 1.0);

		set_entvar(prowlerEntity, var_takedamage, DAMAGE_YES);
		set_entvar(prowlerEntity, var_health, 160.0);

		set_entvar(prowlerEntity, var_team, get_entvar(clientIndex, var_team));
		bEntityHaveTeam[prowlerEntity] = true;

		set_entvar(prowlerEntity, var_netname, fmt("%L", LANG_PLAYER, Agent_Skills[AGENT_FADE][SKILL_NAME]));

		new Float:vOrigin[3]; GetPosition(clientIndex, 0.0, 0.0, 0.0, vOrigin, Float:{0.0, 0.0, 0.0}, false, Float:{0.0, 0.0, 0.0}, false);
		set_entvar(prowlerEntity, var_origin, vOrigin);
		get_entvar(clientIndex, var_v_angle, vOrigin);
		vOrigin[0] *= -1.0;
		set_entvar(prowlerEntity, var_angles, vOrigin);

		static Float:Mins[3] = { -16.0, -16.0, -20.0 }; 
		static Float:Maxs[3] = { 16.0, 16.0, 20.0 };

		engfunc(EngFunc_SetSize, prowlerEntity, Mins, Maxs);
		set_entvar(prowlerEntity, var_mins, Mins); 
		set_entvar(prowlerEntity, var_maxs, Maxs); 
		set_entvar(prowlerEntity, var_absmin, Mins);
		set_entvar(prowlerEntity, var_absmax, Maxs);

		Entity_Will_Remove_NewRound(prowlerEntity, true);
		ChildrenParent_Entity(moveEntity, prowlerEntity);

		bMuteEntity[prowlerEntity] = true;

		Semiclip_Entity(prowlerEntity, TEAM_ATTACKERS);
		Semiclip_Entity(prowlerEntity, TEAM_DEFENDERS);

		for(new arrayIndex = ArraySize(Array_playerCONNECTED)-1, playerIndex; arrayIndex >= 0; arrayIndex--)
		{
			playerIndex = ArrayGetCell(Array_playerCONNECTED, arrayIndex);
			if(playerTEAM[playerIndex] != playerTEAM[clientIndex])
			{
				rh_emit_sound(prowlerEntity, playerIndex, CHAN_ITEM, Skill_Resources[random_num(49, 51)], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			} else {
				rh_emit_sound(prowlerEntity, playerIndex, CHAN_ITEM, Skill_Resources[random_num(43, 46)], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
			}
		}

		SetTouch(prowlerEntity, "Touch_Prowler_Player");

		UTIL_RemoveEntity(prowlerEntity, 3.0);
		bProwlerEntity[prowlerEntity] = true;
	} 
}	

public Touch_Prowler_Player(const prowlerEntity, const touchIndex)
{
	if(!is_user_alive(touchIndex))
		return;
	if(get_entvar(touchIndex, var_team) == get_entvar(prowlerEntity, var_team))
		return;

	new moveEntity = get_entvar(prowlerEntity, var_parent);
	if(moveEntity > 0) 
	{
		SetThink(moveEntity, "");
		set_entvar(moveEntity, var_velocity, Float:{0.0, 0.0, 0.0});
	}
	static Float:Mins[3] = { -1.0, -1.0, -1.0 }; 
	static Float:Maxs[3] = { 1.0, 1.0, 1.0 };

	new clientIndex = get_entvar(prowlerEntity, var_owner2);
	Character_Quote(clientIndex, QUOTE_SKILL2);

	engfunc(EngFunc_SetSize, prowlerEntity, Mins, Maxs);
	set_entvar(prowlerEntity, var_mins, Mins); 
	set_entvar(prowlerEntity, var_maxs, Maxs); 
	set_entvar(prowlerEntity, var_absmin, Mins);
	set_entvar(prowlerEntity, var_absmax, Maxs);

	set_entvar(prowlerEntity, var_iuser3, 1);
	set_entvar(prowlerEntity, var_velocity, Float:{0.0, 0.0, 0.0});
	set_entvar(prowlerEntity, var_solid, SOLID_NOT); 

	SetTouch(prowlerEntity, "");
	UTIL_RemoveEntity(prowlerEntity, 0.6);
	new params[1]; params[0] = prowlerEntity;
	set_task(0.5, "Task_Prowler_Bite", prowlerEntity+TASK_REMOVE_ENTITY, params, sizeof(params));
	rh_emit_sound(prowlerEntity, 0, CHAN_ITEM, Skill_Resources[54], 1.0, ATTN_NORM, 0, PITCH_NORM, SND_EMIT2_NOPAS);
	Play_Animation(prowlerEntity, "iyigeceler", 1.0);
	set_entvar(prowlerEntity, var_enemy, touchIndex);
	set_entvar(touchIndex, var_flags, get_entvar(touchIndex, var_flags) | FL_FROZEN);

	new Float:vOrigin[3]; get_entvar(clientIndex, var_origin, vOrigin);
	new Float:vTarget[3]; get_entvar(touchIndex, var_origin, vTarget);

	static Float:vPosition[3], Float:vAngle[3]; 
	xs_vec_sub(vOrigin, vTarget, vPosition);
	xs_vec_normalize(vPosition, vPosition);
	vector_to_angle(vPosition, vAngle);
	vAngle[0] *= -1.0;
	GetPosition(0, 70.0, 0.0, 0.0, vPosition, vAngle, true, vTarget, true);

	vAngle[1] -= 180.0;
	set_entvar(prowlerEntity, var_angles, vAngle);
	set_entvar(prowlerEntity, var_origin, vPosition);

	get_entvar(touchIndex, var_origin, vOrigin);
	Create_Model_Sprite(0, Skill_Resources[42], vOrigin, VP_PARALLEL, 0, 0.08, 0.0, 0.0, 0, 0.0, 18, false, false);
}

public Task_Prowler_Bite(params[], taskid)
{
	new prowlerEntity = params[0];

	new clientIndex = get_entvar(prowlerEntity, var_owner2);
	rh_emit_sound(prowlerEntity, clientIndex, CHAN_STATIC, Skill_Resources[55], 1.0, ATTN_NONE, 0, PITCH_NORM, SND_EMIT2_NOPAS);

	new enemyIndex = get_entvar(prowlerEntity, var_enemy);
	if(is_user_alive(enemyIndex))
	{
		rh_emit_sound(prowlerEntity, enemyIndex, CHAN_STATIC, Skill_Resources[48], 1.0, ATTN_NONE, 0, PITCH_NORM, SND_EMIT2_NOPAS);
		
		set_entvar(enemyIndex, var_flags, get_entvar(enemyIndex, var_flags) & ~FL_FROZEN);

		ExecuteHamB(Ham_TakeDamage, enemyIndex, prowlerEntity, clientIndex, 12000.0, DMG_CLUB);
	}
}

public Think_Prowler_Move(const moveEntity)
{
	static prowlerEntity, Float:vAngle[3], Float:vOrigin[3], clientIndex, Float:vVelocity[3]; 
	prowlerEntity = get_entvar(moveEntity, var_parent);
	if(prowlerEntity <= 0)
		return;
		
	get_entvar(moveEntity, var_origin, vOrigin);
	if(engfunc(EngFunc_PointContents, vOrigin) == CONTENTS_SKY)
	{
		set_entvar(moveEntity, var_flags, FL_KILLME);
		return;
	}

	clientIndex = get_entvar(moveEntity, var_owner);

	set_entvar(prowlerEntity, var_origin, vOrigin);
	set_entvar(prowlerEntity, var_velocity, Float:{0.1, 0.1, 0.1});
	set_entvar(moveEntity, var_nextthink, get_gametime());

	GetPosition(clientIndex, 4096.0, 0.0, 0.0, vOrigin, vAngle, false, vAngle, false);
	HookEnt(moveEntity, vOrigin, 360.0, true);

	get_entvar(moveEntity, var_velocity, vVelocity);
	vector_to_angle(vVelocity, vAngle); 
	set_entvar(prowlerEntity, var_angles, vAngle);
	set_entvar(moveEntity, var_angles, vAngle);

	GetPosition(prowlerEntity, 0.0, 0.0, 0.0, vOrigin, vAngle, false, vAngle, false);
	GetPosition(prowlerEntity, 32.0, 0.0, 0.0, vAngle, vAngle, false, vAngle, false);

	engfunc(EngFunc_TraceHull, vOrigin, vAngle, IGNORE_MONSTERS, HULL_HEAD, prowlerEntity, 0); 

	new Float:flFraction; get_tr2(0, TR_flFraction, flFraction);
	if(flFraction != 1.0)
	{
		new Float:vecPlaneNormal[3]; get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal);
		xs_vec_mul_scalar(vecPlaneNormal, 16.0, vecPlaneNormal);
		xs_vec_add(vOrigin, vecPlaneNormal, vOrigin);

		set_entvar(moveEntity, var_origin, vOrigin);
		set_entvar(prowlerEntity, var_origin, vOrigin);
		set_entvar(prowlerEntity, var_velocity, Float:{0.1, 0.1, 0.1});
	}

	GetPosition(prowlerEntity, 0.0, 0.0, 0.0, vOrigin, vAngle, false, vAngle, false);
	GetPosition(prowlerEntity, 0.0, 0.0, -8.0, vAngle, vAngle, false, vAngle, false);

	engfunc(EngFunc_TraceHull, vOrigin, vAngle, IGNORE_MONSTERS, HULL_HEAD, prowlerEntity, 0); 

 	get_tr2(0, TR_flFraction, flFraction);
	if(flFraction != 1.0)
	{
		new Float:vecPlaneNormal[3]; get_tr2(0, TR_vecPlaneNormal, vecPlaneNormal);
		xs_vec_mul_scalar(vecPlaneNormal, 8.0, vecPlaneNormal);
		xs_vec_add(vOrigin, vecPlaneNormal, vOrigin);

		set_entvar(moveEntity, var_origin, vOrigin);
		set_entvar(prowlerEntity, var_origin, vOrigin);
		set_entvar(prowlerEntity, var_velocity, Float:{0.1, 0.1, 0.1});
	}
}

public Main_Menu(const clientIndex)
{
	menu_setprop(mainMENU, MPROP_TITLE, fmt("%L", clientIndex, "MAIN_MENUTITLE"));
	menu_setprop(mainMENU, MPROP_BACKNAME, fmt("\w%L", clientIndex, "BACK_MENU"));
	menu_setprop(mainMENU, MPROP_NEXTNAME, fmt("\w%L", clientIndex, "NEXT_MENU"));
	menu_setprop(mainMENU, MPROP_EXITNAME, fmt("\w%L", clientIndex, "EXIT_MENU"));
	menu_display(clientIndex, mainMENU, 0);
	return PLUGIN_HANDLED;
}

Create_Main_Menu()
{
	new szMenuTitle[64]; formatex(szMenuTitle, charsmax(szMenuTitle), "%L", LANG_PLAYER, "MAIN_MENUTITLE"); 
	mainMENU = menu_create(szMenuTitle, "MenuHandle_MAIN");
	new callBack = menu_makecallback("MenuCallback_MAIN");

	menu_additem(mainMENU, "0", "0", _, callBack);
	menu_additem(mainMENU, "1", "1", _, callBack);
	menu_additem(mainMENU, "2", "2", _, callBack);
	menu_additem(mainMENU, "3", "3", _, callBack);
	menu_additem(mainMENU, "4", "4", _, callBack);
	menu_additem(mainMENU, "5", "5", _, callBack);
}

public MenuCallback_MAIN(const clientIndex, const iMenu, const Item)
{
	new szInfo[12];
	menu_item_getinfo(iMenu, Item, _, szInfo, charsmax(szInfo), _, _, _);

	new menuCODE = str_to_num(szInfo);
	switch(menuCODE)
	{
		case 0:
		{
			menu_item_setname(iMenu, Item, fmt("%L", clientIndex, "MAIN_MENUWEAPONS"));
		}
		case 1:
		{
			menu_item_setname(iMenu, Item, fmt("%L", clientIndex, "MAIN_MENUAGENTS"));
		}
		case 2:
		{
			menu_item_setname(iMenu, Item, fmt("%L", clientIndex, "MAIN_MENUCROSSHAIR"));
		}
		case 3:
		{
			menu_item_setname(iMenu, Item, fmt("%L \r[%L]", clientIndex, "MAIN_MENUHIDE", clientIndex, (bHideTeammates[clientIndex] ? "MAIN_OPEN" : "MAIN_CLOSE")));
		}
		case 4:
		{
			menu_item_setname(iMenu, Item, fmt("%L \r[%L]", clientIndex, "MAIN_MENUFOV", clientIndex, (bFovTYPE[clientIndex] ? "MAIN_OPEN" : "MAIN_CLOSE")));
		}
		case 5:
		{
			menu_item_setname(iMenu, Item, fmt("%L", clientIndex, "MAIN_MENUCHANGE_LANGUAGE"));
		}
	}
	return ITEM_ENABLED;
}

public MenuHandle_MAIN(const clientIndex, const iMenu, const Item)
{
	if(Item == MENU_EXIT)
		return;
	if(Item < 0)
		return;

	Log("%s/MenuHandle_Main", PLUGIN);
	new szInfo[12];
	menu_item_getinfo(iMenu, Item, _, szInfo, charsmax(szInfo), _, _, _);

	new menuCODE = str_to_num(szInfo);
	switch(menuCODE)
	{
		case 0:
		{
			Show_WeaponMenu(clientIndex);
		}
		case 1:
		{
			Agent_Select_Menu(clientIndex);
		}
		case 2:
		{
			Crosshair_Select_Menu(clientIndex);
		}
		case 3:
		{
			bHideTeammates[clientIndex] = !bHideTeammates[clientIndex];
			new steamID[32]; get_user_authid(clientIndex, steamID, charsmax(steamID));
			formatex(IDFormat[clientIndex], charsmax(IDFormat), "%s-HIDE", steamID)
			num_to_str(bHideTeammates[clientIndex] ? 1 : 0, HIDEPLAYERS[clientIndex], charsmax(HIDEPLAYERS));
			nvault_set(Vault, IDFormat[clientIndex], HIDEPLAYERS[clientIndex]);
			Main_Menu(clientIndex);
		}
		case 4:
		{
			bFovTYPE[clientIndex] = !bFovTYPE[clientIndex];
			new steamID[32]; get_user_authid(clientIndex, steamID, charsmax(steamID));
			formatex(IDFormat[clientIndex], charsmax(IDFormat), "%s-FOV", steamID)
			num_to_str(bFovTYPE[clientIndex] ? 1 : 0, FOVTYPE[clientIndex], charsmax(FOVTYPE));
			nvault_set(Vault, IDFormat[clientIndex], FOVTYPE[clientIndex]);
			Main_Menu(clientIndex);

			if(bWeaponFast[clientIndex]) Player_FOV(clientIndex, bFovTYPE[clientIndex] ? orbSpeedFOV2 : orbSpeedFOV, true);
			else Player_FOV(clientIndex, bFovTYPE[clientIndex] ? 105 : 90, true);
		}
		case 5:
		{
			CMD_Language(clientIndex);
		}
	}
}

public Reset_Player(const clientIndex)
{
	if(bRealBot[clientIndex]) Reset_Player_Enemy(clientIndex);
	else Reset_Bot_Enemy(clientIndex);
}

public Search_Enemy(const clientIndex)
{
	new Float:vOrigin[3], Float:vVictimOrigin[3], enemyIndex = NULLENT; get_entvar(clientIndex, var_origin, vOrigin);
	new arrayIndex = playerTEAM[clientIndex] == TEAM_ATTACKERS ? ArraySize(Array_playerDEFENDERS)-1 : playerTEAM[clientIndex] == TEAM_DEFENDERS ? ArraySize(Array_playerATTACKERS)-1 : -1;
	for(new playerIndex, Float:fMinDistance = -1.0, Float:fDistance; arrayIndex >= 0; arrayIndex--)
	{
		playerIndex = ArrayGetCell(playerTEAM[clientIndex] == TEAM_ATTACKERS ? Array_playerDEFENDERS : Array_playerATTACKERS, arrayIndex);

		/*if(totalEnemy != NULLENT)
		{
			if(totalEnemy < totalMyEnemy[playerIndex])
				continue;
		}*/

		get_entvar(playerIndex, var_origin, vVictimOrigin);
		fDistance = get_distance_f(vOrigin, vVictimOrigin)
		if(fMinDistance != -1.0)
		{
			if(fDistance >= fMinDistance)
				continue;
		}
		if(!CanSee3(clientIndex, playerIndex))
			continue;
		if(!is_in_viewcone(clientIndex, vVictimOrigin, 1))
			continue;

		fMinDistance = fDistance;
		//totalEnemy = totalMyEnemy[playerIndex];
		enemyIndex = playerIndex;
	}

	return enemyIndex;
}

public Reset_Player_Enemy(const clientIndex)
{
	bBotDucking[clientIndex] = false;
	bBotJumping[clientIndex] = false;

	new enemyIndex = botEnemy[clientIndex];
	botEnemy[clientIndex] = NULLENT;
	if(enemyIndex != NULLENT)
	{
		new iArrayID;
		if((iArrayID = ArrayFindValue(playerEnemy[enemyIndex], clientIndex)) != -1)
		{
			ArrayDeleteItem(playerEnemy[enemyIndex], iArrayID);
			totalMyEnemy[enemyIndex]--;
		}	
	}
}

public Reset_Bot_Enemy(const clientIndex)
{
	for(new arrayIndex = totalMyEnemy[clientIndex]-1, botIndex; arrayIndex >= 0; arrayIndex--)
	{
		botIndex = ArrayGetCell(playerEnemy[clientIndex], arrayIndex);

		if(botEnemy[botIndex] == clientIndex)
		{
			ArrayDeleteItem(playerEnemy[clientIndex], arrayIndex);
			totalMyEnemy[clientIndex]--;

			botEnemy[botIndex] = NULLENT;
		}
	}

	ArrayClear(playerEnemy[clientIndex]);
	totalMyEnemy[clientIndex] = 0;
}

public Task_Bot_SearchEnemy(params[], taskid)
{
	new clientIndex = params[0]; 
	new param[1]; param[0] = clientIndex;
	new enemyBot = Search_Enemy(clientIndex);
	if(enemyBot != NULLENT)
	{
		new enemyIndex = botEnemy[clientIndex];
		if(enemyIndex != NULLENT)
		{
			new iArrayID;
			if((iArrayID = ArrayFindValue(playerEnemy[enemyIndex], clientIndex)) != -1)
			{
				ArrayDeleteItem(playerEnemy[enemyIndex], iArrayID);
				totalMyEnemy[enemyIndex]--;
			}	
		}

		if(botEnemy[clientIndex] != enemyBot)
		{
			remove_task(clientIndex+TASK_BOT_FIRE, 1);
			set_task(random_float(0.4, 1.5), "Task_Bot_Fire", clientIndex+TASK_BOT_FIRE, param, sizeof(param));
		}
		botEnemy[clientIndex] = enemyBot;

		ArrayPushCell(playerEnemy[enemyBot], clientIndex);
		totalMyEnemy[enemyBot]++;

		remove_task(clientIndex+TASK_BOTDEATH, 1);
		remove_task(clientIndex+TASK_BOT_SEARCHENEMY, 1);
	} else {
		remove_task(clientIndex+TASK_BOT_FIRE, 1);

		new enemyIndex = botEnemy[clientIndex];
		botEnemy[clientIndex] = NULLENT;
		if(enemyIndex != NULLENT)
		{
			new iArrayID;
			if((iArrayID = ArrayFindValue(playerEnemy[enemyIndex], clientIndex)) != -1)
			{
				ArrayDeleteItem(playerEnemy[enemyIndex], iArrayID);
				totalMyEnemy[enemyIndex]--;
			}	
		}
	}

	set_task(0.1, "Task_Bot_SearchEnemy", clientIndex+TASK_BOT_SEARCHENEMY, param, sizeof(param));
}

public Task_Bot_Fire(params[], taskid)
{
	
}

stock bool:IsHullStucked(ignoreEnt, const Float:origin[3], hull = HULL_HUMAN)
{
	engfunc(EngFunc_TraceHull, origin, origin, DONT_IGNORE_MONSTERS, hull, ignoreEnt, 0)
	if (!get_tr2(0, TR_InOpen) || get_tr2(0, TR_StartSolid) || get_tr2(0, TR_AllSolid)) return true
	return false
}
stock bool:IsMonsterStucked(ent, const Float:origin[3])
{
	engfunc(EngFunc_TraceMonsterHull, ent, origin, origin, DONT_IGNORE_MONSTERS, ent, 0)
	if (!get_tr2(0, TR_InOpen) || get_tr2(0, TR_StartSolid) || get_tr2(0, TR_AllSolid)) return true
	return false
}
stock bool:IsHullVacant(const Float:origin[3], hull = HULL_HUMAN)
{
	engfunc(EngFunc_TraceHull, origin, origin, DONT_IGNORE_MONSTERS, hull, 0, 0)
	if (!get_tr2(0, TR_InOpen) || get_tr2(0, TR_AllSolid) || get_tr2(0, TR_StartSolid)) return false
	return true
}

stock bool:rh_emit_sound(const entity, const recipient, const channel, const sample[], Float:vol = VOL_NORM, Float:attn = ATTN_NORM, const flags = 0, const pitch = PITCH_NORM, emitFlags = 0, const Float:origin[3] = {0.0,0.0,0.0})
{
	if(recipient > 0 && recipient <= MAX_PLAYERS && is_user_bot(recipient))
		return false;

	return rh_emit_sound2(entity, recipient, channel, sample, vol, attn, flags, pitch, emitFlags, origin);
}

loadSettings(filename[])
{
	if (!file_exists(filename))
		return 0

	new szText[32];
	new buff[256];
	new fp=fopen(filename,"r");
	
	while (!feof(fp))
	{
		buff[0]='^0';
		szText[0]='^0';
		
		fgets(fp, buff, charsmax(buff));
		
		parse(buff, szText, charsmax(szText));
		
		if (szText[0] != ';' && ValidMap(szText))
		{
			ArrayPushString(mapName, szText);
		}
	}
	
	fclose(fp);

	return ArraySize(mapName);
}

stock bool:ValidMap(mapname[])
{
	if ( is_map_valid(mapname) )
	{
		return true;
	}
	// If the is_map_valid check failed, check the end of the string
	new len = strlen(mapname) - 4;
	
	// The mapname was too short to possibly house the .bsp extension
	if (len < 0)
	{
		return false;
	}
	if ( equali(mapname[len], ".bsp") )
	{
		// If the ending was .bsp, then cut it off.
		// the string is byref'ed, so this copies back to the loaded text.
		mapname[len] = '^0';
		
		// recheck
		if ( is_map_valid(mapname) )
		{
			return true;
		}
	}
	
	return false;
}

public bool:Get_Origin_MapEntities(const entityIndex, Float:vOrigin[3])
{
	static bool:bMapEntity; bMapEntity = false;
	if(entityIndex > 0 && entityIndex <= 1365) 
	{
		get_entvar(entityIndex, var_origin, vOrigin);
		if(vOrigin[0] == 0.0 && vOrigin[1] == 0.0 && vOrigin[2] == 0.0)
		{
			static Float:vMins[3], Float:vMaxs[3]
			get_entvar(entityIndex, var_absmin, vMins)
			get_entvar(entityIndex, var_absmax, vMaxs)

			vOrigin[0] += (vMins[0] + vMaxs[0]) * 0.5
			vOrigin[1] += (vMins[1] + vMaxs[1]) * 0.5
			vOrigin[2] += (vMins[2] + vMaxs[2]) * 0.5
			bMapEntity = true;
		}
	}
	return bMapEntity;
}

bool:DistanceToFloor(const clientIndex, const Float:vPoint[3], const Float:fDistance, const bool:hull) 
{
	static Float:vEnd[3], Float:fFraction;

	vEnd[0] = vPoint[0];
	vEnd[1] = vPoint[1];
	vEnd[2] = vPoint[2] - fDistance;

	if(hull) engfunc(EngFunc_TraceHull, vPoint, vEnd, IGNORE_MONSTERS, HULL_HEAD, clientIndex, 0);
	else engfunc(EngFunc_TraceLine, vPoint, vEnd, IGNORE_MONSTERS, clientIndex, 0);
	get_tr2(0, TR_flFraction, fFraction)
	return (fFraction >= 1.0 && !get_tr2(0, TR_StartSolid) && !get_tr2(0, TR_AllSolid) && get_tr2(0, TR_InOpen)) ? true : false;
}

public fw_PrecacheModel( const Model[ ] ) 
{ 
	for( new i = 0; i < sizeof( UnPrecache_ModelList ); i++ ) 
	{ 
		if( equal( Model, UnPrecache_ModelList[ i ] ) ) 
			return FMRES_SUPERCEDE 
	} 
	
	return FMRES_IGNORED 
}

public fw_PrecacheModel_Post( const Model[ ] )
{
	for( new i = 0; i < sizeof( UnPrecache_ModelList ); i++ ) 
	{ 
		if( equal( Model, UnPrecache_ModelList[ i ] ) ) 
			return FMRES_IGNORED 
	} 
	
	new Precached = 0 
	
	for( new i = 0; i < ArraySize( ArModel ); i++ ) 
	{ 
		ArrayGetString( ArModel, i, GTempData, sizeof( GTempData ) ) 
		if( equal( GTempData, Model ) ) { Precached = 1; break; } 
	} 
	
	if( !Precached ) ArrayPushString( ArModel, Model ) 
	return FMRES_IGNORED 
}

public fw_PrecacheSound( const Sound[ ] )
{
	if( Sound[ 0 ] == 'h' && Sound[1] == 'o' ) 
		return FMRES_SUPERCEDE 
	for( new i = 0; i < sizeof(UnPrecache_SoundList); i++ )
	{ 
		if( equal( Sound, UnPrecache_SoundList[ i ] ) ) 
			return FMRES_SUPERCEDE 
	} 
	 
	return FMRES_HANDLED 
} 

public fw_PrecacheSound_Post( const Sound[ ] ) 
{
	if( Sound[0] == 'h' && Sound[1] == 'o') 
		return FMRES_IGNORED 
	for( new i = 0; i < sizeof( UnPrecache_SoundList ); i++ ) 
	{
		if( equal( Sound, UnPrecache_SoundList[ i ] ) )
			return FMRES_IGNORED 
	} 
	
	new Precached = 0 
	
	for( new i = 0; i < ArraySize( ArSound ); i++ ) 
	{ 
		ArrayGetString( ArSound, i, GTempData, sizeof( GTempData ) ) 
		if( equal( GTempData, Sound ) ) { Precached = 1; break; } 
	} 
	
	static Line 
	
	if( !Precached ) 
	{ 
		ArrayPushString( ArSound, Sound )
		Line++ 
	} 
	
	return FMRES_HANDLED 
} 