#define Mod_Name "Zombie Base"

// Teams
enum iPlayerTeams
{
	TEAM_NONE = 0,
	TEAM_ZOMBIE,
	TEAM_HUMAN,
	TEAM_SPECTATORS
}

// EVOLUTION LEVELS
enum iEvolutionLevel
{
	EVOL_LEVEL0 = 0,
	EVOL_LEVEL1,
	EVOL_LEVEL2
}

// ROUND STATE
enum iRoundState
{
	ROUND_UNAVAILABLE = 0,
	ROUND_FREEZETIME,
	ROUND_START_COUNTDOWN,
	ROUND_NORMALPLAY,
	ROUND_120SECONDLEFT,
	ROUND_60SECONDLEFT,
	ROUND_30SECONDLEFT,
	ROUND_20SECONDLEFT,
	ROUND_10SECONDLEFT,
	ROUND_HUMANWIN,
	ROUND_ZOMBIEWIN
}

// TASKS
enum (+= 1366) 
{
    TASK_COUNTDOWN = 1366, // 1366,
    TASK_ROUND_END, // 2732,
	TASK_CLAW, // 4098,
	TASK_MODELSPRITE, // 5464, 
	TASK_BANSHEEBLIND, // 6830,
	TASK_BANSHEESUMMON, // 8196,
	TASK_ZOMBIE_HITBOX, // 9562,
	TASK_VIEWSPRITE, // 10928,
	TASK_COFFINSTAMP, // 12294,
	TASK_COFFINEXPLOSION, // 13660,
	TASK_YAKSHAICEBALL, // 15026,
	TASK_YAKSHAFREEZETIME, // 16392,
	TASK_LILITHHURRICANE, // 17758,
	TASK_ZOMBIEFOOTSTEPS, // 19124,
	TASK_ZOMBIEIDLE, // 20490,
	TASK_ENTITYREMOVE, // 21856,
	TASK_KNOCKBACK_SPEED, // 23222,
	TASK_DEADLYSHOT, // 24588,
	TASK_SATANISTPOWER, // 25954,
	TASK_PLAYERFALL, // 27320,
	TASK_PLAYERDECAY, // 28686,
	TASK_PLAYERSLIP, // 30052,
	TASK_RESPAWN, // 31418,
	TASK_COOLDOWN, // 32784,
	TASK_DAMAGEHUD, // 34150,
	TASK_DAMAGEBALANCER, // 35516,
	TASK_WAYPOINT, // 36882,
	TASK_BOT_SEARCHENEMY, // 38248,
	TASK_BOTDEATH, // 39614,
	TASK_BOTLADDER, // 40980,
	TASK_BOTDUCK, // 42346,
	TASK_PLAYER_IMMORTAL, // 43712,
	TASK_NIGHTVISION, // 45078,
	TASK_COMBOHUDS, // 46444,
	TASK_ASSIST, // 47810,
	TASK_STAMPERMUSIC, // 49176, 
	TASK_PLAYERKICK, // 50542,
	TASK_TYRANTMACE_FREEZE, // 51908,
	TASK_STIMBEACON_HEAL, // 53274,
	TASK_FIELDBARRIER_SLOW, // 54640
	TASK_DGAXEEX_ENERGY,
	TASK_DGAXEX_PPOTECTION,
	TASK_TYRANTMACE_ENERGY,
	TASK_DVHAMMER_ENERGY,
	TASK_MODELCHANGE,
	TASK_ARACHNE_TRAP,
	TASK_BDC_FREEZE
}

enum (+= 1365) 
{
    CODE_ZOMBIECLAW = 60000, // 60000,

	CODE_MONKEY1, // 601366,
    CODE_DRAGONSWORD, // 62732,
 	CODE_JANUS9, // 64098,
	CODE_OZSCARECROW, // 65464,
	CODE_RUYISTICK, // 66830,
	CODE_SKULL9, // 68196,
	CODE_HAMMER, // 69562,
	CODE_NATA, // 70928,
	CODE_DNATA, // 72294,
	CODE_BSWORD, // 73660,
    CODE_IRONFAN, // 75026,
	CODE_KATANAD, // 76392,
	CODE_JAYSDAGGER, // 77758,
	CODE_BALROG9, // 79124,
	CODE_ANCIENTSWORD, // 80490,

	CODE_BALROG1, // 81856,
	CODE_M950SE, // 83222,
	CODE_DDEAGLE, // 84588,
	CODE_DINFINITY, // 85954,
	CODE_MONKEY2, // 87320,
	CODE_M1887CRAFT, // 88686,
	CODE_DUCKGUN, // 90052,
	CODE_SKULL2, // 91418, 
	CODE_VULCANUS1, // 92784,
	CODE_JANUS1, // 94150,

	CODE_AS50, // 95516,
	CODE_FALCONEX, // 96882,
	CODE_SKULL5, // 98248,
	CODE_SAVERY, // 99614,

	CODE_M1887, // 100980,
	CODE_QBARREL, // 102346,
	CODE_SPSG, // 103712,
	CODE_JANUS11, // 105078,
	CODE_RAILCANNON, // 106444,

	CODE_THANATOS3, // 107810,
	CODE_BLOCKSMG, // 109176,
	CODE_JANUS3, // 110542,
	CODE_SPSMG, // 111908,
	CODE_DUALKRISSHERO, // 113274,
	CODE_STERLINGBAYONET, // 114640,

	CODE_COILMG, // 116006,
	CODE_JANUS7, // 117372,
	CODE_SFMG, // 118738,
	CODE_THANATOS7, // 120104,
	CODE_VULCANUS7, // 121470,

	CODE_AK47LONG, // 122836,
	CODE_HEAVYZG, // 124202,
	CODE_SKULL4, // 125568,
	CODE_SVDEX, // 126934,
	
	CODE_RAILGUN, // 128300,

	CODE_STIMBEACON_POWER, // 129666,
	CODE_STIMBEACON_HEAL, // 131032,
	CODE_STIMBEACON_SHIELD, // 132398,

	CODE_KICK, // 133764,

	CODE_TYRANTMACE, // 135130,
	CODE_DVHAMMER, // 136496,
	CODE_M3DRAGON, // 137862,
	CODE_LINKATTACK, // 139228
	CODE_DRAKAR3,
	CODE_DGAXE,
	CODE_ASURAHELL,
	CODE_GUNGNIREX,
	CODE_CHAINSR,
	CODE_RDC
}

enum SpeedValues
{
	SPEED_WEAPONSPEED = 1, // 1
	SPEED_SATANIST,  // 2
	SPEED_LINKATTACK_FIELD,  // 3
	SPEED_PLAYERSLIP,  // 4
	SPEED_KNOCKBACK,  // 5
	SPEED_ARACHNE_WEB_TRAP,  // 6
	SPEED_YAKSHA_ICE_GROUND,  // 7
	SPEED_ICE_GROUND_BDC,  // 8
	SPEED_ICE_GROUND,  // 9
	SPEED_BOT_STOP,  // 10
	SPEED_BANSHEEBAT, // 11
	SPEED_PLAYERFALL,  // 12
	SPEED_LIMIT
}

enum GravityValues
{
	GRAVITY_DEFAULT = 1, // 1
	GRAVITY_BANSHEEBAT,  // 2
	GRAVITY_LIMIT
}

enum iHitType
{
    HIT_NONE = 0,
	HIT_ENEMY,
	HIT_WALL
}

enum 
{
	CONTINUE = 0,
	BLOCK
}

enum 
{
	SKILL_G = 0,
	SKILL_F,
	SKILL_T,
	SKILL_X
}

enum 
{
	TYPE_PRIMARY = 0,
	TYPE_SECONDARY,
	TYPE_KNIFE
}

enum 
{
	CATEGORY_FREE = 1,
	CATEGORY_BLUE,
	CATEGORY_RED,
	CATEGORY_YELLOW,
	CATEGORY_PURPLE
}

enum 
{
	BULLETTRAIL_COLOR_WHITE = 0, // 0
	BULLETTRAIL_COLOR_RED, // 1
	BULLETTRAIL_COLOR_GREEN, // 2
	BULLETTRAIL_COLOR_BLUE, // 3
	BULLETTRAIL_COLOR_NORMAL, // 4
	BULLETTRAIL_COLOR_GOLD, // 5
	BULLETTRAIL_COLOR_LIGHTORANGE, // 6
	BULLETTRAIL_COLOR_LIGHTBLUE // 7
}

enum (+= 100) // var_max_health
{
	ENT_MISSILE = 100,
	ENT_SMOKE,
	ENT_REFERENCE
}

enum iBlindTypes
{
  	NOT_BLINDED = 0,
	NIGHTVISION,
	BANSHEE_ASTRAL_FORM,
	BANSHEE_EYE_BLIND
}

enum stimbeaconAbilities
{
  	POWER = 0,
	HEAL,
	SHIELD
}

enum spreadActivities
{
	Act_OnAir = 0,
	Act_OnMove,
	Act_Ducking,
	Act_FirstShoot,
	Act_None
};

// Customize Files
#define ZOMBIECLASSES_FILE "zombiebase_zombieclasses.ini"
#define ZOMBIESKILLS_FILE "zombiebase_zombieskills.ini"
#define PRECACHE_FILE "zombiebase_precache.ini"
#define GAMEPLAY_FILE "zombiebase_gameplay.ini"
#define WEAPONS_FILE "zombiebase_weapons.ini"
#define WEAPONMENU_FILE "zombiebase_weaponmenu.ini"
#define LANGUAGE_FILE "zombie_base.txt"

const EntVars:var_bloodscale = var_bInDuck;
const EntVars:var_owner2 = var_iuser1; // for solid entities
const EntVars:var_code = var_flTimeStepSound;
const EntVars:var_enttype = var_max_health;
const EntVars:var_parent = var_iuser2;
const EntVars:var_maxframe = var_enemy;
const EntVars:var_next_attack = var_fuser1;

// Mask Entity
#define MaskEnt(%0)    ( 1<<(%0 & 31) )
#define MaskEnt2(%0)   ( 1<<((%0+33) & 31))

// Natives
native Register_Zombie(bool:ZombieDarkness, const szZombieName[], const szZombieDesc[], const szPlayerModelHost[], const szPlayerModelOrigin[], const szViewModelHost[], const szViewModelOrigin[], const szHealSound[], const szPainSounds[], const szDeathSounds[], const iMaxHealth, const Float:fMaxSpeed, const Float:fGravity, const Float:fKnockback, const bool:Female, const bool:NightStalker);

native bool:is_player_connected(const clientIndex);
native bool:is_player_alive(const clientIndex);
native bool:is_player_zombie(const clientIndex);
native bool:is_player_darknesszombie(const clientIndex);
native bool:is_player_nightstalker(const clientIndex);
native bool:is_player_female(const clientIndex);
native bool:is_player_fromturkey(const clientIndex);
native bool:is_player_fakeclient(const clientIndex);
native bool:is_player_lefthanded(const clientIndex);
native bool:is_entity_cantakedamage(const entityIndex);
native bool:is_player_realbot(const clientIndex);
native bool:is_player_fall(const clientIndex);

native playerIsRealBOT(const clientIndex);
native Player_CurrentZombieID(const clientIndex);
native Player_SelectedZombieID(const clientIndex);
native Change_SelectedZombieID(const clientIndex, const zombieID);

native TotalZombie_Count();
native TotalHuman_Count();
native TotalAlive_Count();
native TotalPlayer_Count();
native TotalCanTakeDamage_Count();
native BiggestClientID();

native Get_Player_Name(const clientIndex, const szName[], const len);
native Get_Player_Country(const clientIndex, const szCountry[], const len);

native Get_ArrayValue_ConnectedPlayers(const iArrayID);
native Get_ArrayValue_AlivePlayers(const iArrayID);
native Get_ArrayValue_ZombiePlayers(const iArrayID);
native Get_ArrayValue_HumanPlayers(const iArrayID);
native Get_ArrayValue_CanTakeDamage(const iArrayID);

native Array:Array_CanTakeDamage();
native Array:Array_Entity_Childrens(const entityIndex);
native Array:Array_Entity_Parents(const entityIndex);

native ChildrenParent_Entity(const parentEntity, const childrenEntity);
native Entity_Will_Remove_NewRound(const entityIndex, const bool:bSet);
native Entity_Add_CanTakeDamage(const entityIndex);
native Entity_Active_Semiclip(const entityIndex, const iPlayerTeams:iTeamID);
native bool:Get_Origin_MapEntities(const entityIndex, const Float:vOrigin[3]);
native Get_Origin_Blood(const Float:vOrigin[3]);


native Player_Get_MaxHealth(const entityIndex);
native Player_Set_MaxHealth(const entityIndex, const iValue, bool:UpdateHealth);

native Float:Player_Get_WeaponSpeed(const clientIndex);
native Player_Set_WeaponSpeed(const clientIndex, const Float:fValue, bool:UpdateSpeed);

native Float:Player_Get_Gravity(const clientIndex);

native Float:Player_Get_Knockback(const clientIndex);
native Player_Set_Knockback(const clientIndex, const Float:fValue);

native Active_Speed_Type(const clientIndex, SpeedValues:speedTYPE, bool:bSet);
native bool:IsActivated_Speed_Type(const clientIndex, SpeedValues:speedTYPE);

native Active_Gravity_Type(const clientIndex, GravityValues:gravityTYPE, bool:bSet);
native bool:IsActivated_Gravity_Type(const clientIndex, GravityValues:gravityTYPE);

native iEvolutionLevel:Player_Get_EvolutionLevel(const clientIndex);
native Player_Set_EvolutionLevel(const clientIndex, const iEvolutionLevel:iValue, bool:Update);

native Set_Player_HammerFlinch(const clientIndex);
native Set_Player_Animation(const clientIndex, const AnimName[], const Float:framerate, const bool:Instantly);
native Player_Block_Animations(const clientIndex, const Float:Time);
native Player_Block_WeaponChange(const clientIndex, const Float:Time);
native Float:Player_GetBlockTime(const clientIndex);
native Player_Get_Sequence(const clientIndex, const AnimName[]);

native bool:is_zombieclass_nightstalker(const ZombieClassID);

native Get_ZombieClass_MaxHealth(const ZombieClassID, const iEvolutionLevel:ZombieEvolLevel);
native Float:Get_ZombieClass_Speed(const ZombieClassID, const iEvolutionLevel:ZombieEvolLevel);
native Float:Get_ZombieClass_Gravity(const ZombieClassID, const iEvolutionLevel:ZombieEvolLevel);
native Float:Get_ZombieClass_Knockback(const ZombieClassID, const iEvolutionLevel:ZombieEvolLevel);

native Get_ZombieEvolution_HealthMultiplier();
native Float:Get_ZombieEvolution_SpeedMultiplier();
native Float:Get_ZombieEvolution_GravityMultiplier();
native Float:Get_ZombieEvolution_KnockbackMultiplier();

native Set_RoundState(const iRoundState:RoundState);
native iRoundState:Get_RoundState();
native bool:isGameAvailable();

native Set_Player_Zombie(const clientIndex, const AttackerIndex, const bool:Selected, const bool:Coming);
native Set_Player_Human(const clientIndex);

native Regeneration_Player_Health(const clientIndex, PlayerHealth, const Float:HudTime);
native Reset_Player_Speed(const clientIndex);
native Reset_Player_Gravity(const clientIndex);

native Play_Background_Sound(const clientIndex, const szSound[], const Float:Time);
native Update_Player_Frags(const AttackerIndex, const VictimIndex, const AddScore, const AddDeath, bool:Update);
native Open_ZombieClass_Menu(const clientIndex);

native Change_ModName(const ModeName[]);
native Weapon_Animation(const clientIndex, const iSequence, const iBody);
native BloodPrecacheID(const bool:Spray);

native Game_Debug(const Message[], any:...);
native Change_WeaponSprite(const clientIndex, const WeaponEntityID, const szSpriteName[]);
native Weapon_FixAmmoHud(const clientIndex, const WeaponIdType:WEAPON_ID, const WEAPON_AMMO);
native Weapon_BPAmmoHud(const clientIndex, const WeaponIdType:WEAPON_ID, const WEAPON_BPAMMO);
native Weapon_FixCrosshair(const clientIndex, const weaponIndex, const bool:customCrosshair, const clipAmount);
native iHitType:Knife_Attack(const clientIndex, const iWeaponEntityID, const Float:Damage, const Float:Damage_Range, const Float:Point_Dis, const Float:Knockback, const Float:KnockUp, const Float:Painshock, const DamageType, const bool:bHammerFlinch);
native iHitType:Knife_Attack2(Float:vSourceOrigin[3], const entityIndex, Float:OwnerOrigin[3], const clientIndex, const iWeaponEntityID, const Float:Damage, const Float:Damage_Range, const Float:Point_Dis, const Float:Knockback, const Float:KnockUp, const Float:Painshock, const DamageType, const bool:bHammerFlinch);
native iHitType:Fake_TraceAttack(const iAttacker, const iVictim, const iInflictor, Float:fDamage, const Float:fDistance, const bool:bBackDmgAdd, const bool:bTraceLine, const iDamageType);
native Explosion_Damage(const Float:vSourceOrigin[3], const entityIndex, const Float:vOwnerOrigin[3], const clientIndex, const iWeaponEntityID, const Float:Damage, const Float:Damage_Range, const Float:Knockback, const Float:KnockUp, const Float:Painshock, const DamageType, const bool:bHammerFlinch);
native Explosion_Effect(entityIndex, const decalEffect, Float:vOrigin[3]);
native Refill_Weapons_Ammo(const clientIndex, const divisionValue);

native Get_TraceAttack_LastHit();
native SpawnBlood(const Float:Origin[3], const iBody, const iScale);
native Float:Damage_Multiplier(const iHitGroup);
native Hook_Entity(const Entity, const Float:TargetOrigin[3], Float:Knockback, Float:KnockUp, bool:KnockBack);
native Hook_Force(const bool:bActive);
native bool:DistanceEntityAngles(const Entity, const iTarget, const Float:ViewDis);
native Set_Position(const iEntityIndex, const Float:fForwardAdd, const Float:fRightAdd, const Float:fUpAdd, Float:vPosition[3], const Float:vCustomAngle[3], const bool:WorkCustomAngle, const Float:vCustomOrigin[3], const bool:WorkCustomOrigin);

native UTIL_GetVectorAiming(const clientIndex, const Float:vecAiming[3]);
native UTIL_GetEyePosition(const clientIndex, const Float:vecEyeLevel[3]);
native UTIL_GunshotDecalTrace(const entityIndex, const Float:vecOrigin[3]);
native UTIL_WeaponKickBack(const entityIndex, const clientIndex, Float:flUpBase, Float:flLateralBase, Float:flUpModifier, Float:flLateralModifier, Float:flUpMax, Float:flLateralMax);
native spreadActivities:UTIL_GetSpreadByAction(const weaponIndex, const Float:flSpreadInActions[5], const Float:flMoveSpeed);
native UTIL_CalculateWeaponSpread(const weaponIndex, const Float:vecSpread[3], Float:flMovementFactor, Float:flFirstShotModifier, Float:flDuckFactor, Float:flAirFactor, Float:vecOut[3]);
native Float:UTIL_GetSpreadValue();
native bool:isFriendlyFire_Open();
native UTIL_CreateColorTrace(const clientIndex, const Float:vStartOrigin[3], const Float:vEndOrigin[3], const Float:fSpeed, const Life, const Color, const Length);
native UTIL_CreateBeamFollow(const Float:vStartOrigin[3], const Float:vEndOrigin[3]);
native UTIL_FireBulletWeapon(weaponEntity, cShots, Float:vecSrc[3], Float:vecDirShooting[3], Float:vecSpread[3], Float:flDistance, Float:flDamage, Float:flRangeModifier, attackerIndex, Float:vecOut[3]);
native UTIL_RemoveEntity(const entityIndex, const Float:fTime);
native UTIL_GetMissileWeaponHitGroup(const entityIndex);
native UTIL_ChangeFov(const clientIndex, const iFOV, const bool:defaultFov);
native GetDefaultFov(const clientIndex);
native GetHitGroup(const attackerIndex, const victimIndex, const hitGroup);

native ChangeEntityHeadBone(const entityIndex, const boneIndex);
native GetEntityHeadBone(const entityIndex);
native bool:GetEntityHeadOrigin(const entityIndex, const Float:vHeadOrigin[3]);

native bool:Can_See(const clientIndex, const targetIndex);
native Color_Chat(const clientIndex, const print_team, const szText[], any:...);

// non-solid owner var_owner, solid owner var_iuser1
native Create_Model_Sprite(const iOwnerIndex, const szModel[], Float:vEffectPosition[3], const iCode, const fadeOut, const Float:fThinkUpdate, const Float:fShowTime, const Float:fFrameRate, const iParentIndex, const Float:fUpParentPosition, const iMaxFrame, const bool:Loop, const bool:Solid);
native Create_View_Sprite(const clientIndex, const szSprite[], const AttachmentID, const Effects, const Float:fScale, const Float:fDelayTime, const Float:fShowTime, const Float:fFramerate, const Float:fMaxFrame, const Float:fThinkTime, const bool:Loop, const parentIndex, const bool:bRemoveDeploy);

native Get_CurrentWeapon_EntityID(const clientIndex);
native WeaponIdType:Get_CurrentWeapon_ID(const clientIndex);
native Get_CurrentItem_ID(const clientIndex);

native Change_Fog(const clientIndex, const Density, const Red, const Green, const Blue);
native Change_Light(const clientIndex, const LightStyle[]);
native Get_Game_Light(const LightStyle[], const len);

native Set_Player_View(const clientIndex, const Float:fForwardAdd, const Float:fRightAdd, const Float:fUpAdd, const Float:fDistance, const iParent);
native Get_Player_ViewEntity(const clientIndex);

native bool:Set_Player_BlindType(const clientIndex, const iBlindTypes:iBlindType);
native iBlindTypes:Get_Player_BlindType(const clientIndex);

native GetArray_Claw_SlashSounds(const iArrayID, const szSound[], const len);
native GetArray_Claw_StabSounds_Female(const iArrayID, const szSound[], const len);
native GetArray_Claw_StabSounds_Male(const iArrayID, const szSound[], const len);
native GetArray_Claw_WallSounds(const iArrayID, const szSound[], const len);
native GetArray_Claw_HitSounds(const iArrayID, const szSound[], const len);
native GetArray_Claw_StabHitSounds_Female(const iArrayID, const szSound[], const len);
native GetArray_Claw_StabHitSounds_Male(const iArrayID, const szSound[], const len);
native ArraySize_Claw_SlashSounds();
native ArraySize_Claw_StabSounds_Female();
native ArraySize_Claw_StabSounds_Male();
native ArraySize_Claw_WallSounds();
native ArraySize_Claw_HitSounds();
native ArraySize_Claw_StabHitSounds_Female();
native ArraySize_Claw_StabHitSounds_Male();

native Remove_Player_Abilities(const clientIndex);

native Float:Get_Damage();
native Set_Damage(Float:fDamage);

native Add_Weapon_List(const szWeaponEntity[32], const weaponCode, const spriteCode, const weaponType, const weaponCategory);
native HideCrosshair(const clientIndex);
native CanOpenMenu(const clientIndex);
native CanUseSkill(const clientIndex);
native SetCooldown(const clientIndex, const cooldownSeconds);
native Set_Player_RoomType(const clientIndex, const bActive);
native Player_Protection(const clientIndex, const Float:fTime);
native Set_Semiclip(const clientIndex);
native UnSet_Semiclip(const clientIndex);
native bool:TraceEffects();
native Float:FadeOutSPEED();
native bool:isAllBotsZombie();
native MakeAllBotsZombie(bool:bSet);
native PlayerUseSkill(const clientIndex, const skillID);

// Forwards 
forward Player_Connected(const clientIndex);
forward Player_Disconnected(const clientIndex);
forward Player_Spawned(const clientIndex);
forward Player_Died(const clientIndex, const bool:bZombie, const iZombieID, const attackerIndex, const bool:Headshot);
forward Player_Selected_Zombie_From_Menu(const clientIndex, const iZombieID);
forward Change_Round_State(const iRoundState:RoundState);
forward Player_Deploy_Weapon(const clientIndex, const Impulse, const iWeaponEntityID, const WeaponIdType:iWeaponCode, const bool:bZombie, const iZombieID, const bool:bPost);
forward Player_Team_Change(const clientIndex, const iPlayerTeams:iTeamID);
forward Player_Animation(const clientIndex, const iZombieID, PLAYER_ANIM:playerAnim);
forward Player_Infected(const clientIndex, const iZombieID);
forward Player_Humanized(const clientIndex);
forward Player_Evolution(const clientIndex, const iZombieID, const iEvolutionLevel:iZombieEvolLevel, const bool:UpdateZombie);
forward Player_Reset_Speed(const clientIndex, SpeedValues:speedTYPE);
forward Player_Reset_Gravity(const clientIndex, GravityValues:gravityTYPE);
forward OnEntityRemoved(const entityIndex, const iImpulse, const iOwner, const szEntityClassname[], const szEntityGlobalname[], const iUser);
forward Mouse2_Attack_ZDarkness(const clientIndex, const weaponEntity, const iZombieID);
forward Claw_Attack_Zombie(const clientIndex, const iZombieID, const iEnemyID, const iHitType:HitType, const bool:bStab);
forward Can_Claw_Attack_Zombie(const clientIndex, const iZombieID, const bool:bStab);
forward Player_Skill_G(const clientIndex, const bool:bZombie, const iZombieID);
forward Player_Skill_F(const clientIndex, const bool:bZombie, const iZombieID);
forward Player_Skill_T(const clientIndex, const bool:bZombie, const iZombieID);
forward Player_Skill_X(const clientIndex, const bool:bZombie, const iZombieID);
forward Reset_Player_Camera(const iCameraEntity, const iOwnerIndex);
forward Call_Player_Camera(const clientIndex);
forward TakeDamage(const clientIndex, const iInflictor, const attackerIndex, Float:fDamage, const DamageBits, const bool:clientConnected, const bool:clientZombie, const bool:attackerConnected, const bool:attackerZombie);
forward TakeDamage_Post(const clientIndex, const iInflictor, const attackerIndex, Float:fDamage, const DamageBits, const bool:clientConnected, const bool:clientZombie, const bool:attackerConnected, const bool:attackerZombie);
forward TraceAttack(const clientIndex, const attackerIndex, Float:fDamage, const Float:vDirection[3], const iTracehandle, const iDamageType, const bool:clientConnected, const bool:clientZombie, const bool:attackerConnected, const bool:attackerZombie);
forward TraceAttack_Post(const clientIndex, const attackerIndex, Float:fDamage, const Float:vDirection[3], const iTracehandle, const iDamageType, const bool:clientConnected, const bool:clientZombie, const bool:attackerConnected, const bool:attackerZombie);
forward Can_Change_Player_BlindType(const clientIndex, iBlindTypes:iCurrentBlindType, iBlindTypes:iBlindType);
forward Remove_Player_BlindType(const clientIndex, iBlindTypes:iOldBlindType, iBlindTypes:iNewBlindType);
forward Changed_Player_BlindType(const clientIndex, iBlindTypes:iOldBlindType, iBlindTypes:iNewBlindType);
forward Player_Remove_Abilities(const clientIndex, const bool:bZombie, const iZombieID);
forward OnPlayerHammerFlinch(const clientIndex, const iZombieID);
forward OnFakeTraceAttackHit(const iHitType:hitType, const clientIndex, const victimIndex, const Float:vTargetOrigin[3]);
forward Player_Add_Item(const clientIndex, const weaponEntity, WeaponIdType:iId, const impulse, const weaponName[]);
forward OnExplosionDamage(const clientIndex,  const victimIndex, const Float:vSourceOrigin[3], const Float:vOwnerOrigin[3], const iWeaponEntityID, const Float:Damage, const Float:Damage_Range, const DamageType, const bool:bHammerFlinch);
forward OnPenetrableEntity(const clientIndex, const victimIndex, const iHitType:hitType, Float:vecStart[3], Float:vecEnd[3], Float:vecPlaneNormal[3], const iPointContents);
forward OnGetHitGroup(const attackerIndex, const victimIndex, hitGroup);
forward Satanist_Claw_Animation(const clientIndex, const iZombieID, const weaponEntity);
forward OnPlayerFall(const clientIndex, const bool:bPost);
forward OnPlayerFallDeath(const clientIndex);
forward OnPlayerStand(const clientIndex);
forward OnStimBeacon_Ability(const clientIndex, const stimbeaconAbilities:Ability);
forward OnRefillAmmo(const clientIndex, const weaponEntity, const impulse, divisionValue);
forward OnWeaponGived(const clientIndex);
forward OnMenuOpen(const clientIndex);
forward OnSkillUse(const clientIndex, const bool:bZombie, const iZombieID);
forward OnCooldownChange(const clientIndex, const Cooldown, const bool:bZombie, const iZombieID);
forward OnPlayerAssist(const assisIndex, const attackerIndex, const victimIndex);
forward OnPlayerHearMusic(const clientIndex, const bool:bZombie, const iZombieID);
forward OnPlayerDontHearMusic(const clientIndex, const bool:bZombie, const iZombieID);
forward OnPlayerStartSatanist(const clientIndex, const bool:bZombie, const iZombieID);
forward OnPlayerEndSatanist(const clientIndex, const bool:bZombie, const iZombieID);
forward OnRefreshCrosshair(const clientIndex);
forward OnDecoderOpen(const clientIndex);
forward OnPlayerKick(const clientIndex);
forward OnPlayerKicked(const clientIndex);
forward OnBatTouch(const batEntity, const touchEntity);
forward OnBatRelease(const batEntity, const touchEntity);
forward OnHurricaneCanTouch(const hurricaneEntity, const touchEntity);
forward OnHurricaneFirstTouch(const hurricaneEntity, const touchEntity);
forward OnHurricaneRelease(const touchEntity);
forward OnUpdatePlayerSize(const clientIndex, const iZombieID, const bool:bDuck);